/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.injector;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.module.apikit.AbstractConfiguration;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.injector.InjectableSecurityScheme;
import org.mule.module.apikit.injector.InjectableTrait;
import org.mule.module.apikit.injector.SecuritySchemeAlreadyDefinedException;
import org.mule.module.apikit.injector.TraitAlreadyDefinedException;
import org.mule.raml.implv1.model.RamlImplV1;
import org.mule.raml.interfaces.model.IRaml;
import org.raml.model.Action;
import org.raml.model.Raml;
import org.raml.model.SecurityScheme;
import org.raml.model.Template;

public class RamlUpdater {
    private Raml raml;
    private AbstractConfiguration config;
    private Set<String> currentTraits;
    private Set<String> currentSecuritySchemes;
    private Map<String, InjectableTrait> injectedTraits;
    private Map<String, InjectableSecurityScheme> injectedSecuritySchemes;

    public RamlUpdater(Raml raml, AbstractConfiguration config) {
        this.raml = raml;
        this.config = config;
        this.injectedTraits = new HashMap<String, InjectableTrait>();
        this.injectedSecuritySchemes = new HashMap<String, InjectableSecurityScheme>();
        this.populateCurrentTraits();
        this.populateCurrentSecuritySchemes();
    }

    private void populateCurrentSecuritySchemes() {
        this.currentSecuritySchemes = new HashSet<String>();
        for (Map schemes : this.raml.getSecuritySchemes()) {
            this.currentSecuritySchemes.addAll(schemes.keySet());
        }
    }

    private void populateCurrentTraits() {
        this.currentTraits = new HashSet<String>();
        for (Map traitMap : this.raml.getTraits()) {
            this.currentTraits.addAll(traitMap.keySet());
        }
    }

    public void resetAndUpdate() {
        this.config.updateApi((IRaml)new RamlImplV1(this.raml));
    }

    public void reset() {
        if (!this.injectedTraits.isEmpty() || !this.injectedSecuritySchemes.isEmpty()) {
            throw new ApikitRuntimeException("Cannot inject and reset with the same Updater");
        }
        this.resetAndUpdate();
    }

    private Template getTemplate(String name) {
        Template template = new Template();
        template.setDisplayName(name);
        return template;
    }

    public RamlUpdater injectTrait(String name, String traitYaml) {
        if (this.currentTraits.contains(name)) {
            throw new TraitAlreadyDefinedException("Duplicate Trait definition: " + name);
        }
        this.currentTraits.add(name);
        HashMap<String, Template> traitDef = new HashMap<String, Template>();
        traitDef.put(name, this.getTemplate(name));
        this.raml.getTraits().add(traitDef);
        this.injectedTraits.put(name, new InjectableTrait(name, traitYaml));
        return this;
    }

    public RamlUpdater applyTrait(String name, String ... actionRefs) {
        for (String actionRef : actionRefs) {
            Action action = this.getAction(actionRef);
            InjectableTrait injectableTrait = this.injectedTraits.get(name);
            if (injectableTrait == null) {
                throw new ApikitRuntimeException("Trying to apply an undefined Trait: " + name);
            }
            injectableTrait.applyToAction(action);
        }
        return this;
    }

    private Action getAction(String actionRef) {
        String[] coord = actionRef.split(":");
        Action action = this.raml.getResource(coord[1]).getAction(coord[0]);
        return action;
    }

    public RamlUpdater injectSecuritySchemes(String name, String securitySchemeYaml) {
        if (this.currentSecuritySchemes.contains(name)) {
            throw new SecuritySchemeAlreadyDefinedException("Duplicate Security Scheme definition: " + name);
        }
        this.currentSecuritySchemes.add(name);
        HashMap<String, SecurityScheme> securitySchemeDef = new HashMap<String, SecurityScheme>();
        InjectableSecurityScheme injectableSecurityScheme = new InjectableSecurityScheme(name, securitySchemeYaml);
        securitySchemeDef.put(name, injectableSecurityScheme.getSecurityScheme());
        this.raml.getSecuritySchemes().add(securitySchemeDef);
        this.injectedSecuritySchemes.put(name, injectableSecurityScheme);
        return this;
    }

    public RamlUpdater applySecurityScheme(String name, String ... actionRefs) {
        for (String actionRef : actionRefs) {
            Action action = this.getAction(actionRef);
            InjectableSecurityScheme injectableSecurityScheme = this.injectedSecuritySchemes.get(name);
            if (injectableSecurityScheme == null) {
                throw new ApikitRuntimeException("Trying to apply an undefined Security Scheme: " + name);
            }
            injectableSecurityScheme.applyToAction(action);
        }
        return this;
    }
}

