(function(){function Lexer(options){this.tokens=[],this.tokens.links={},this.options=options||marked.defaults,this.rules=block.normal,this.options.gfm&&(this.options.tables?this.rules=block.tables:this.rules=block.gfm)}function InlineLexer(links,options){if(this.options=options||marked.defaults,this.links=links,this.rules=inline.normal,this.renderer=this.options.renderer||new Renderer,this.renderer.options=this.options,!this.links)throw new Error("Tokens array requires a `links` property.");this.options.gfm?this.options.breaks?this.rules=inline.breaks:this.rules=inline.gfm:this.options.pedantic&&(this.rules=inline.pedantic)}function Renderer(options){this.options=options||{}}function Parser(options){this.tokens=[],this.token=null,this.options=options||marked.defaults,this.options.renderer=this.options.renderer||new Renderer,this.renderer=this.options.renderer,this.renderer.options=this.options}function escape(html,encode){return html.replace(encode?/&/g:/&(?!#?\w+;)/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#39;")}function unescape(html){return html.replace(/&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/g,function(_,n){return n=n.toLowerCase(),"colon"===n?":":"#"===n.charAt(0)?"x"===n.charAt(1)?String.fromCharCode(parseInt(n.substring(2),16)):String.fromCharCode(+n.substring(1)):""})}function replace(regex,opt){return regex=regex.source,opt=opt||"",function self(name,val){return name?(val=val.source||val,val=val.replace(/(^|[^\[])\^/g,"$1"),regex=regex.replace(name,val),self):new RegExp(regex,opt)}}function noop(){}function merge(obj){for(var target,key,i=1;i<arguments.length;i++){target=arguments[i];for(key in target)Object.prototype.hasOwnProperty.call(target,key)&&(obj[key]=target[key])}return obj}function marked(src,opt,callback){if(callback||"function"==typeof opt){callback||(callback=opt,opt=null),opt=merge({},marked.defaults,opt||{});var tokens,pending,highlight=opt.highlight,i=0;try{tokens=Lexer.lex(src,opt)}catch(e){return callback(e)}pending=tokens.length;var done=function(err){if(err)return opt.highlight=highlight,callback(err);var out;try{out=Parser.parse(tokens,opt)}catch(e){err=e}return opt.highlight=highlight,err?callback(err):callback(null,out)};if(!highlight||highlight.length<3)return done();if(delete opt.highlight,!pending)return done();for(;i<tokens.length;i++)!function(token){return"code"!==token.type?--pending||done():highlight(token.text,token.lang,function(err,code){return err?done(err):null==code||code===token.text?--pending||done():(token.text=code,token.escaped=!0,void(--pending||done()))})}(tokens[i])}else try{return opt&&(opt=merge({},marked.defaults,opt)),Parser.parse(Lexer.lex(src,opt),opt)}catch(e){if(e.message+="\nPlease report this to https://github.com/chjj/marked.",(opt||marked.defaults).silent)return"<p>An error occured:</p><pre>"+escape(e.message+"",!0)+"</pre>";throw e}}var block={newline:/^\n+/,code:/^( {4}[^\n]+\n*)+/,fences:noop,hr:/^( *[-*_]){3,} *(?:\n+|$)/,heading:/^ *(#{1,6}) *([^\n]+?) *#* *(?:\n+|$)/,nptable:noop,lheading:/^([^\n]+)\n *(=|-){2,} *(?:\n+|$)/,blockquote:/^( *>[^\n]+(\n(?!def)[^\n]+)*\n*)+/,list:/^( *)(bull) [\s\S]+?(?:hr|def|\n{2,}(?! )(?!\1bull )\n*|\s*$)/,html:/^ *(?:comment *(?:\n|\s*$)|closed *(?:\n{2,}|\s*$)|closing *(?:\n{2,}|\s*$))/,def:/^ *\[([^\]]+)\]: *<?([^\s>]+)>?(?: +["(]([^\n]+)[")])? *(?:\n+|$)/,table:noop,paragraph:/^((?:[^\n]+\n?(?!hr|heading|lheading|blockquote|tag|def))+)\n*/,text:/^[^\n]+/};block.bullet=/(?:[*+-]|\d+\.)/,block.item=/^( *)(bull) [^\n]*(?:\n(?!\1bull )[^\n]*)*/,block.item=replace(block.item,"gm")(/bull/g,block.bullet)(),block.list=replace(block.list)(/bull/g,block.bullet)("hr","\\n+(?=\\1?(?:[-*_] *){3,}(?:\\n+|$))")("def","\\n+(?="+block.def.source+")")(),block.blockquote=replace(block.blockquote)("def",block.def)(),block._tag="(?!(?:a|em|strong|small|s|cite|q|dfn|abbr|data|time|code|var|samp|kbd|sub|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo|span|br|wbr|ins|del|img)\\b)\\w+(?!:/|[^\\w\\s@]*@)\\b",block.html=replace(block.html)("comment",/<!--[\s\S]*?-->/)("closed",/<(tag)[\s\S]+?<\/\1>/)("closing",/<tag(?:"[^"]*"|'[^']*'|[^'">])*?>/)(/tag/g,block._tag)(),block.paragraph=replace(block.paragraph)("hr",block.hr)("heading",block.heading)("lheading",block.lheading)("blockquote",block.blockquote)("tag","<"+block._tag)("def",block.def)(),block.normal=merge({},block),block.gfm=merge({},block.normal,{fences:/^ *(`{3,}|~{3,})[ \.]*(\S+)? *\n([\s\S]*?)\s*\1 *(?:\n+|$)/,paragraph:/^/,heading:/^ *(#{1,6}) +([^\n]+?) *#* *(?:\n+|$)/}),block.gfm.paragraph=replace(block.paragraph)("(?!","(?!"+block.gfm.fences.source.replace("\\1","\\2")+"|"+block.list.source.replace("\\1","\\3")+"|")(),block.tables=merge({},block.gfm,{nptable:/^ *(\S.*\|.*)\n *([-:]+ *\|[-| :]*)\n((?:.*\|.*(?:\n|$))*)\n*/,table:/^ *\|(.+)\n *\|( *[-:]+[-| :]*)\n((?: *\|.*(?:\n|$))*)\n*/}),Lexer.rules=block,Lexer.lex=function(src,options){var lexer=new Lexer(options);return lexer.lex(src)},Lexer.prototype.lex=function(src){return src=src.replace(/\r\n|\r/g,"\n").replace(/\t/g,"    ").replace(/\u00a0/g," ").replace(/\u2424/g,"\n"),this.token(src,!0)},Lexer.prototype.token=function(src,top,bq){for(var next,loose,cap,bull,b,item,space,i,l,src=src.replace(/^ +$/gm,"");src;)if((cap=this.rules.newline.exec(src))&&(src=src.substring(cap[0].length),cap[0].length>1&&this.tokens.push({type:"space"})),cap=this.rules.code.exec(src))src=src.substring(cap[0].length),cap=cap[0].replace(/^ {4}/gm,""),this.tokens.push({type:"code",text:this.options.pedantic?cap:cap.replace(/\n+$/,"")});else if(cap=this.rules.fences.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"code",lang:cap[2],text:cap[3]||""});else if(cap=this.rules.heading.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"heading",depth:cap[1].length,text:cap[2]});else if(top&&(cap=this.rules.nptable.exec(src))){for(src=src.substring(cap[0].length),item={type:"table",header:cap[1].replace(/^ *| *\| *$/g,"").split(/ *\| */),align:cap[2].replace(/^ *|\| *$/g,"").split(/ *\| */),cells:cap[3].replace(/\n$/,"").split("\n")},i=0;i<item.align.length;i++)/^ *-+: *$/.test(item.align[i])?item.align[i]="right":/^ *:-+: *$/.test(item.align[i])?item.align[i]="center":/^ *:-+ *$/.test(item.align[i])?item.align[i]="left":item.align[i]=null;for(i=0;i<item.cells.length;i++)item.cells[i]=item.cells[i].split(/ *\| */);this.tokens.push(item)}else if(cap=this.rules.lheading.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"heading",depth:"="===cap[2]?1:2,text:cap[1]});else if(cap=this.rules.hr.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"hr"});else if(cap=this.rules.blockquote.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"blockquote_start"}),cap=cap[0].replace(/^ *> ?/gm,""),this.token(cap,top,!0),this.tokens.push({type:"blockquote_end"});else if(cap=this.rules.list.exec(src)){for(src=src.substring(cap[0].length),bull=cap[2],this.tokens.push({type:"list_start",ordered:bull.length>1}),cap=cap[0].match(this.rules.item),next=!1,l=cap.length,i=0;l>i;i++)item=cap[i],space=item.length,item=item.replace(/^ *([*+-]|\d+\.) +/,""),~item.indexOf("\n ")&&(space-=item.length,item=this.options.pedantic?item.replace(/^ {1,4}/gm,""):item.replace(new RegExp("^ {1,"+space+"}","gm"),"")),this.options.smartLists&&i!==l-1&&(b=block.bullet.exec(cap[i+1])[0],bull===b||bull.length>1&&b.length>1||(src=cap.slice(i+1).join("\n")+src,i=l-1)),loose=next||/\n\n(?!\s*$)/.test(item),i!==l-1&&(next="\n"===item.charAt(item.length-1),loose||(loose=next)),this.tokens.push({type:loose?"loose_item_start":"list_item_start"}),this.token(item,!1,bq),this.tokens.push({type:"list_item_end"});this.tokens.push({type:"list_end"})}else if(cap=this.rules.html.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:this.options.sanitize?"paragraph":"html",pre:!this.options.sanitizer&&("pre"===cap[1]||"script"===cap[1]||"style"===cap[1]),text:cap[0]});else if(!bq&&top&&(cap=this.rules.def.exec(src)))src=src.substring(cap[0].length),this.tokens.links[cap[1].toLowerCase()]={href:cap[2],title:cap[3]};else if(top&&(cap=this.rules.table.exec(src))){for(src=src.substring(cap[0].length),item={type:"table",header:cap[1].replace(/^ *| *\| *$/g,"").split(/ *\| */),align:cap[2].replace(/^ *|\| *$/g,"").split(/ *\| */),cells:cap[3].replace(/(?: *\| *)?\n$/,"").split("\n")},i=0;i<item.align.length;i++)/^ *-+: *$/.test(item.align[i])?item.align[i]="right":/^ *:-+: *$/.test(item.align[i])?item.align[i]="center":/^ *:-+ *$/.test(item.align[i])?item.align[i]="left":item.align[i]=null;for(i=0;i<item.cells.length;i++)item.cells[i]=item.cells[i].replace(/^ *\| *| *\| *$/g,"").split(/ *\| */);this.tokens.push(item)}else if(top&&(cap=this.rules.paragraph.exec(src)))src=src.substring(cap[0].length),this.tokens.push({type:"paragraph",text:"\n"===cap[1].charAt(cap[1].length-1)?cap[1].slice(0,-1):cap[1]});else if(cap=this.rules.text.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"text",text:cap[0]});else if(src)throw new Error("Infinite loop on byte: "+src.charCodeAt(0));return this.tokens};var inline={escape:/^\\([\\`*{}\[\]()#+\-.!_>])/,autolink:/^<([^ >]+(@|:\/)[^ >]+)>/,url:noop,tag:/^<!--[\s\S]*?-->|^<\/?\w+(?:"[^"]*"|'[^']*'|[^'">])*?>/,link:/^!?\[(inside)\]\(href\)/,reflink:/^!?\[(inside)\]\s*\[([^\]]*)\]/,nolink:/^!?\[((?:\[[^\]]*\]|[^\[\]])*)\]/,strong:/^__([\s\S]+?)__(?!_)|^\*\*([\s\S]+?)\*\*(?!\*)/,em:/^\b_((?:[^_]|__)+?)_\b|^\*((?:\*\*|[\s\S])+?)\*(?!\*)/,code:/^(`+)\s*([\s\S]*?[^`])\s*\1(?!`)/,br:/^ {2,}\n(?!\s*$)/,del:noop,text:/^[\s\S]+?(?=[\\<!\[_*`]| {2,}\n|$)/};inline._inside=/(?:\[[^\]]*\]|[^\[\]]|\](?=[^\[]*\]))*/,inline._href=/\s*<?([\s\S]*?)>?(?:\s+['"]([\s\S]*?)['"])?\s*/,inline.link=replace(inline.link)("inside",inline._inside)("href",inline._href)(),inline.reflink=replace(inline.reflink)("inside",inline._inside)(),inline.normal=merge({},inline),inline.pedantic=merge({},inline.normal,{strong:/^__(?=\S)([\s\S]*?\S)__(?!_)|^\*\*(?=\S)([\s\S]*?\S)\*\*(?!\*)/,em:/^_(?=\S)([\s\S]*?\S)_(?!_)|^\*(?=\S)([\s\S]*?\S)\*(?!\*)/}),inline.gfm=merge({},inline.normal,{escape:replace(inline.escape)("])","~|])")(),url:/^(https?:\/\/[^\s<]+[^<.,:;"')\]\s])/,del:/^~~(?=\S)([\s\S]*?\S)~~/,text:replace(inline.text)("]|","~]|")("|","|https?://|")()}),inline.breaks=merge({},inline.gfm,{br:replace(inline.br)("{2,}","*")(),text:replace(inline.gfm.text)("{2,}","*")()}),InlineLexer.rules=inline,InlineLexer.output=function(src,links,options){var inline=new InlineLexer(links,options);return inline.output(src)},InlineLexer.prototype.output=function(src){for(var link,text,href,cap,out="";src;)if(cap=this.rules.escape.exec(src))src=src.substring(cap[0].length),out+=cap[1];else if(cap=this.rules.autolink.exec(src))src=src.substring(cap[0].length),"@"===cap[2]?(text=":"===cap[1].charAt(6)?this.mangle(cap[1].substring(7)):this.mangle(cap[1]),href=this.mangle("mailto:")+text):(text=escape(cap[1]),href=text),out+=this.renderer.link(href,null,text);else if(this.inLink||!(cap=this.rules.url.exec(src))){if(cap=this.rules.tag.exec(src))!this.inLink&&/^<a /i.test(cap[0])?this.inLink=!0:this.inLink&&/^<\/a>/i.test(cap[0])&&(this.inLink=!1),src=src.substring(cap[0].length),out+=this.options.sanitize?this.options.sanitizer?this.options.sanitizer(cap[0]):escape(cap[0]):cap[0];else if(cap=this.rules.link.exec(src))src=src.substring(cap[0].length),this.inLink=!0,out+=this.outputLink(cap,{href:cap[2],title:cap[3]}),this.inLink=!1;else if((cap=this.rules.reflink.exec(src))||(cap=this.rules.nolink.exec(src))){if(src=src.substring(cap[0].length),link=(cap[2]||cap[1]).replace(/\s+/g," "),link=this.links[link.toLowerCase()],!link||!link.href){out+=cap[0].charAt(0),src=cap[0].substring(1)+src;continue}this.inLink=!0,out+=this.outputLink(cap,link),this.inLink=!1}else if(cap=this.rules.strong.exec(src))src=src.substring(cap[0].length),out+=this.renderer.strong(this.output(cap[2]||cap[1]));else if(cap=this.rules.em.exec(src))src=src.substring(cap[0].length),out+=this.renderer.em(this.output(cap[2]||cap[1]));else if(cap=this.rules.code.exec(src))src=src.substring(cap[0].length),out+=this.renderer.codespan(escape(cap[2],!0));else if(cap=this.rules.br.exec(src))src=src.substring(cap[0].length),out+=this.renderer.br();else if(cap=this.rules.del.exec(src))src=src.substring(cap[0].length),out+=this.renderer.del(this.output(cap[1]));else if(cap=this.rules.text.exec(src))src=src.substring(cap[0].length),out+=this.renderer.text(escape(this.smartypants(cap[0])));else if(src)throw new Error("Infinite loop on byte: "+src.charCodeAt(0))}else src=src.substring(cap[0].length),text=escape(cap[1]),href=text,out+=this.renderer.link(href,null,text);return out},InlineLexer.prototype.outputLink=function(cap,link){var href=escape(link.href),title=link.title?escape(link.title):null;return"!"!==cap[0].charAt(0)?this.renderer.link(href,title,this.output(cap[1])):this.renderer.image(href,title,escape(cap[1]))},InlineLexer.prototype.smartypants=function(text){return this.options.smartypants?text.replace(/---/g,"—").replace(/--/g,"–").replace(/(^|[-\u2014\/(\[{"\s])'/g,"$1‘").replace(/'/g,"’").replace(/(^|[-\u2014\/(\[{\u2018\s])"/g,"$1“").replace(/"/g,"”").replace(/\.{3}/g,"…"):text},InlineLexer.prototype.mangle=function(text){if(!this.options.mangle)return text;for(var ch,out="",l=text.length,i=0;l>i;i++)ch=text.charCodeAt(i),Math.random()>.5&&(ch="x"+ch.toString(16)),out+="&#"+ch+";";return out},Renderer.prototype.code=function(code,lang,escaped){if(this.options.highlight){var out=this.options.highlight(code,lang);null!=out&&out!==code&&(escaped=!0,code=out)}return lang?'<pre><code class="'+this.options.langPrefix+escape(lang,!0)+'">'+(escaped?code:escape(code,!0))+"\n</code></pre>\n":"<pre><code>"+(escaped?code:escape(code,!0))+"\n</code></pre>"},Renderer.prototype.blockquote=function(quote){return"<blockquote>\n"+quote+"</blockquote>\n"},Renderer.prototype.html=function(html){return html},Renderer.prototype.heading=function(text,level,raw){return"<h"+level+' id="'+this.options.headerPrefix+raw.toLowerCase().replace(/[^\w]+/g,"-")+'">'+text+"</h"+level+">\n"},Renderer.prototype.hr=function(){return this.options.xhtml?"<hr/>\n":"<hr>\n"},Renderer.prototype.list=function(body,ordered){var type=ordered?"ol":"ul";return"<"+type+">\n"+body+"</"+type+">\n"},Renderer.prototype.listitem=function(text){return"<li>"+text+"</li>\n"},Renderer.prototype.paragraph=function(text){return"<p>"+text+"</p>\n"},Renderer.prototype.table=function(header,body){return"<table>\n<thead>\n"+header+"</thead>\n<tbody>\n"+body+"</tbody>\n</table>\n"},Renderer.prototype.tablerow=function(content){return"<tr>\n"+content+"</tr>\n"},Renderer.prototype.tablecell=function(content,flags){var type=flags.header?"th":"td",tag=flags.align?"<"+type+' style="text-align:'+flags.align+'">':"<"+type+">";return tag+content+"</"+type+">\n"},Renderer.prototype.strong=function(text){return"<strong>"+text+"</strong>"},Renderer.prototype.em=function(text){return"<em>"+text+"</em>"},Renderer.prototype.codespan=function(text){return"<code>"+text+"</code>"},Renderer.prototype.br=function(){return this.options.xhtml?"<br/>":"<br>"},Renderer.prototype.del=function(text){return"<del>"+text+"</del>"},Renderer.prototype.link=function(href,title,text){if(this.options.sanitize){try{var prot=decodeURIComponent(unescape(href)).replace(/[^\w:]/g,"").toLowerCase()}catch(e){return""}if(0===prot.indexOf("javascript:")||0===prot.indexOf("vbscript:"))return""}var out='<a href="'+href+'"';return title&&(out+=' title="'+title+'"'),out+=">"+text+"</a>"},Renderer.prototype.image=function(href,title,text){var out='<img src="'+href+'" alt="'+text+'"';return title&&(out+=' title="'+title+'"'),out+=this.options.xhtml?"/>":">"},Renderer.prototype.text=function(text){return text},Parser.parse=function(src,options,renderer){var parser=new Parser(options,renderer);return parser.parse(src)},Parser.prototype.parse=function(src){this.inline=new InlineLexer(src.links,this.options,this.renderer),this.tokens=src.reverse();for(var out="";this.next();)out+=this.tok();return out},Parser.prototype.next=function(){return this.token=this.tokens.pop()},Parser.prototype.peek=function(){return this.tokens[this.tokens.length-1]||0},Parser.prototype.parseText=function(){for(var body=this.token.text;"text"===this.peek().type;)body+="\n"+this.next().text;return this.inline.output(body)},Parser.prototype.tok=function(){switch(this.token.type){case"space":return"";case"hr":return this.renderer.hr();case"heading":return this.renderer.heading(this.inline.output(this.token.text),this.token.depth,this.token.text);case"code":return this.renderer.code(this.token.text,this.token.lang,this.token.escaped);case"table":var i,row,cell,flags,j,header="",body="";for(cell="",i=0;i<this.token.header.length;i++)flags={header:!0,align:this.token.align[i]},cell+=this.renderer.tablecell(this.inline.output(this.token.header[i]),{header:!0,align:this.token.align[i]});for(header+=this.renderer.tablerow(cell),i=0;i<this.token.cells.length;i++){for(row=this.token.cells[i],cell="",j=0;j<row.length;j++)cell+=this.renderer.tablecell(this.inline.output(row[j]),{header:!1,align:this.token.align[j]});body+=this.renderer.tablerow(cell)}return this.renderer.table(header,body);case"blockquote_start":for(var body="";"blockquote_end"!==this.next().type;)body+=this.tok();return this.renderer.blockquote(body);case"list_start":for(var body="",ordered=this.token.ordered;"list_end"!==this.next().type;)body+=this.tok();return this.renderer.list(body,ordered);case"list_item_start":for(var body="";"list_item_end"!==this.next().type;)body+="text"===this.token.type?this.parseText():this.tok();return this.renderer.listitem(body);case"loose_item_start":for(var body="";"list_item_end"!==this.next().type;)body+=this.tok();return this.renderer.listitem(body);case"html":var html=this.token.pre||this.options.pedantic?this.token.text:this.inline.output(this.token.text);return this.renderer.html(html);case"paragraph":return this.renderer.paragraph(this.inline.output(this.token.text));case"text":return this.renderer.paragraph(this.parseText())}},noop.exec=noop,marked.options=marked.setOptions=function(opt){return merge(marked.defaults,opt),marked},marked.defaults={gfm:!0,tables:!0,breaks:!1,pedantic:!1,sanitize:!1,sanitizer:null,mangle:!0,smartLists:!1,silent:!1,highlight:null,langPrefix:"lang-",smartypants:!1,headerPrefix:"",renderer:new Renderer,xhtml:!1},marked.Parser=Parser,marked.parser=Parser.parse,marked.Renderer=Renderer,marked.Lexer=Lexer,marked.lexer=Lexer.lex,marked.InlineLexer=InlineLexer,marked.inlineLexer=InlineLexer.output,marked.parse=marked,"undefined"!=typeof module&&"object"==typeof exports?module.exports=marked:"function"==typeof define&&define.amd?define(function(){return marked}):this.marked=marked}).call(function(){return this||("undefined"!=typeof window?window:global)}()),!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t(function(){try{return require("RAML.XmlValidation")}catch(e){}}(),function(){try{return require("RAML.JsonValidation")}catch(e){}}(),require("typescript")):"function"==typeof define&&define.amd?define(["RAML.XmlValidation","RAML.JsonValidation","typescript"],t):"object"==typeof exports?exports.Parser=t(function(){try{return require("RAML.XmlValidation")}catch(e){}}(),function(){try{return require("RAML.JsonValidation")}catch(e){}}(),require("typescript")):(e.RAML=e.RAML||{},e.RAML.Parser=t(e["RAML.XmlValidation"],e["RAML.JsonValidation"],e.typescript))}(this,function(__WEBPACK_EXTERNAL_MODULE_63__,__WEBPACK_EXTERNAL_MODULE_65__,__WEBPACK_EXTERNAL_MODULE_183__){return function(e){function t(r){if(n[r])return n[r].exports;var i=n[r]={exports:{},id:r,loaded:!1};return e[r].call(i.exports,i,i.exports,t),i.loaded=!0,i.exports}var n={};return t.m=e,t.c=n,t.p="",t(0)}([function(e,t,n){"use strict";function r(e,t){return y.load(e,t)}function i(e,t){return y.loadSync(e,t)}function a(e,t){return y.parse(e,t)}function o(e,t){return y.parseSync(e,t)}function s(e,t,n){return y.loadApi(e,t,n).getOrElse(null)}function u(e,t,n){return y.loadApi(e,t,n).getOrElse(null)}function l(e,t){var n=y.virtualFilePath(t),r=y.optionsForContent(e,t,n);return y.loadApi(n,[],r).getOrElse(null)}function p(e,t){var n=y.virtualFilePath(t),r=y.optionsForContent(e,t,n);return y.loadApiAsync(n,[],r)}function c(e,t,n){return y.loadApiAsync(e,t,n)}function f(e,t,n){return y.loadRAMLAsync(e,t,n)}function h(e){return y.getLanguageElementByRuntimeType(e)}function d(e){return t.api10.isFragment(e)}function m(e){return t.api10.asFragment(e)}Object.defineProperty(t,"__esModule",{value:!0});var y=n(1);t.jsonTypings=n(315);var v=n(329);t.api10=n(281),t.api08=n(330),t.load=r,t.loadSync=i,t.parse=a,t.parseSync=o,t.loadApiSync=s,t.loadRAMLSync=u,t.parseRAMLSync=l,t.parseRAML=p,t.loadApi=c,t.loadRAML=f,t.getLanguageElementByRuntimeType=h,t.isFragment=d,t.asFragment=m,t.hl=n(196),t.ll=n(5),t.search=n(271),t.stubs=n(331),t.utils=n(296),t.project=n(332),t.universeHelpers=n(203),t.ds=n(56),t.schema=n(333),t.universes=t.ds.universesInfo,t.parser=n(335),t.expander=n(337),t.wrapperHelper=n(338),"undefined"==typeof Promise&&"undefined"!=typeof window&&(window.Promise=v)},function(e,t,n){"use strict";function r(e,t){var n=I(t);return a(e,t).then(function(e){return V.dump(e,n)})}function i(e,t){var n=I(t),r=o(e,t);return V.dump(r,n)}function a(e,t){t=t||{};var n=e;b(e)&&(t=S(e,t,t.filePath),n=M(t));var r=N(t);return h(n,r).then(function(e){var n;return n=!t.hasOwnProperty("expandLibraries")||t.expandLibraries?x.expandLibrariesHL(e):x.expandTraitsAndResourceTypesHL(e)})}function o(e,t){t=t||{};var n=e;b(e)&&(t=S(e,t,t.filePath),n=M(t));var r,i=N(t),a=p(n,i);return r=!t.hasOwnProperty("expandLibraries")||t.expandLibraries?K.isLibraryType(a.definition())?x.expandLibraryHL(a)||a:x.expandLibrariesHL(a)||a:x.expandTraitsAndResourceTypesHL(a)||a}function s(e,t,n){var r=p(e,t,n);if(!r)return L.empty();var i=r.wrapperNode(),a=Array.isArray(t)?n:t;return _(i,a),new L(i)}function u(e,t,n){var r=p(e,t,n);if(!r)return L.empty();var i=r.wrapperNode(),a=Array.isArray(t)?n:t;return _(i,a),new L(i)}function l(e,t,n){var r=p(e,t,n);return r?new L(r):L.empty()}function p(e,t,n){var r=Array.isArray(t),i=r?t:null,a=r?n:t;a=a||{};var o=y(e,a),s=e.indexOf("://"),u=-1!=s&&6>s?e:C.basename(e),l=o.unit(u);n&&!i&&(i=null);var p;if(l)if(i&&i.length>0){var c=[];i.forEach(function(e){if(!e||0==e.trim().length)throw new Error(H.EXTENSIONS_AND_OVERLAYS_LEGAL_FILE_PATHS.message)}),i.forEach(function(e){c.push(o.unit(e,C.isAbsolute(e)))}),c.forEach(function(e){return v(e,a)}),p=v(U.mergeAPIs(l,c,O.OverlayMergeMode.MERGE),a)}else p=v(l,a),p.setMergeMode(O.OverlayMergeMode.MERGE);if(!l)throw new Error(W.applyTemplate(H.CAN_NOT_RESOLVE,{path:e}));if(a.rejectOnErrors&&p&&p.errors().filter(function(e){return!e.isWarning}).length)throw g(p);return p}function c(e,t,n){var r=f(e,t,n);return r.then(function(e){return e})}function f(e,t,n){return h(e,t,n).then(function(e){if(!e)return null;for(var r=Array.isArray(t),i=r?n:t,a=e;null!=a;){var o=a.wrapperNode();_(o,i);var s=a.getMaster();a=s?s.asElement():null}return e.wrapperNode()})}function h(e,t,n){var r=Array.isArray(t),i=r?t:null,a=r?n:t;a=a||{};var o=y(e,a),s=e.indexOf("://"),u=-1!=s&&6>s?e:C.basename(e);return n&&!i&&(i=null),i&&0!=i.length?(i.forEach(function(e){if(!e||0==e.trim().length)throw new Error(H.EXTENSIONS_AND_OVERLAYS_LEGAL_FILE_PATHS.message)}),m(o,u,a).then(function(e){var t=[];return i.forEach(function(e){t.push(m(o,e,a))}),Promise.all(t).then(function(t){var n=[];t.forEach(function(e){return n.push(e.lowLevel().unit())});var r=U.mergeAPIs(e.lowLevel().unit(),n,O.OverlayMergeMode.MERGE);return r}).then(function(e){return v(e,a)})})):m(o,u,a).then(function(e){return e.setMergeMode(O.OverlayMergeMode.MERGE),e})}function d(e){if(null==e)return null;var t=e.getAdapter(B.RAMLService).getDeclaringNode();return null==t?null:t.wrapperNode()}function m(e,t,n){return D.fetchIncludesAndMasterAsync(e,t).then(function(e){try{var t=v(e,n);return n.rejectOnErrors&&t&&t.errors().filter(function(e){return!e.isWarning}).length?Promise.reject(g(t)):t}catch(e){return Promise.reject(e)}})}function y(e,t){t=t||{};var n,r=t.fsResolver,i=t.httpResolver,a=t.reusedNode;if(a){var o=a.lowLevel().unit();n=o.project(),n.namespaceResolver().deleteUnitModel(o.absolutePath()),n.deleteUnit(C.basename(e)),r&&n.setFSResolver(r),i&&n.setHTTPResolver(i)}else{var s=C.dirname(e);n=new P.Project(s,r,i)}return n}function v(e,t,n){if(void 0===n&&(n=!1),t=t||{},!e)return null;var r=null,i=null;e.isRAMLUnit?r=e:(i=e,r=i.lowLevel().unit());var a=r.contents(),o=O.ramlFirstLine(a);if(!o)throw new Error(H.INVALID_FIRST_LINE.message);var s,u,l=o[1];if(o[2],"0.8"==l?u="RAML08":"1.0"==l&&(u="RAML10"),!u)throw new Error(H.UNKNOWN_RAML_VERSION.message);if("RAML08"==u&&n)throw new Error(H.EXTENSIONS_AND_OVERLAYS_NOT_SUPPORTED_0_8.message);var p=Y(u);return p.type(s),i||(i=O.fromUnit(r),t.reusedNode&&t.reusedNode.lowLevel().unit().absolutePath()==r.absolutePath()&&E(i,t.reusedNode)&&i.setReusedNode(t.reusedNode)),i}function g(e){var t=new Error(H.API_CONTAINS_ERROR.message);return t.parserErrors=O.toParserErrors(e.errors(),e),t}function A(e,t,n){void 0===t&&(t=!1),void 0===n&&(n=!0);var r=Y("RAML10"),i=r.type(F.Universe10.Api.name),a=new P.Project(e),o=[];return a.units().forEach(function(e){var r=e.ast();t&&(r=D.toChildCachingNode(r));var a=new w.ApiImpl(new O.ASTNodeImpl(r,null,i,null));n&&(a=U.expandTraitsAndResourceTypes(a)),o.push(a)}),o}function E(e,t){if(!t)return!1;for(var n=e.lowLevel().unit().contents(),r=t.lowLevel().unit().contents(),i=Math.min(n.length,r.length),a=-1,o=0;i>o;o++)if(n.charAt(o)!=r.charAt(o)){a=o;break}for(;a>0&&""==n.charAt(a).replace(/\s/,"");)a--;0>a&&n.length!=r.length&&(a=i);var s=j.deepFindNode(t,a,a+1);if(!s)return!0;if(s.lowLevel().unit().absolutePath()!=e.lowLevel().unit().absolutePath())return!0;var u=s.isElement()?s.asElement():s.parent();if(!u)return!0;var l=u.property();if(!l)return!0;if(K.isAnnotationsProperty(l)&&(u=u.parent()),!u)return!0;for(var p=u;p;){var c=p.definition();if(K.isResourceTypeType(c)||K.isTraitType(c))return!1;var f=p.property();if(!f)return!0;if(K.isTypeDeclarationDescendant(c)&&(K.isTypesProperty(f)||K.isAnnotationTypesProperty(f)))return!1;var h=f.range();if(K.isResourceTypeRefType(h)||K.isTraitRefType(h))return!1;p=p.parent()}return!0}function _(e,t){t=t||{},null!=t.attributeDefaults&&e?e.setAttributeDefaults(t.attributeDefaults):e&&e.setAttributeDefaults(!0)}function T(e,t,n){var r=n||M(t),i=R(r,e,t&&t.fsResolver);return{fsResolver:i,httpResolver:t?t.httpResolver:null,rejectOnErrors:!!t&&t.rejectOnErrors,attributeDefaults:!t||t.attributeDefaults}}function N(e){return e?{fsResolver:e.fsResolver,httpResolver:e.httpResolver,rejectOnErrors:!1,attributeDefaults:!0}:{}}function S(e,t,n){var r=n||M(t),i=R(r,e,t&&t.fsResolver),a={fsResolver:i};if(!t)return a;for(var o=0,s=Object.keys(t);o<s.length;o++){var u=s[o];"fsResolver"!=u&&(a[u]=t[u])}return a}function b(e){return e=e&&e.trim(),!e||(e.length<="#%RAML".length?k.stringStartsWith("#%RAML",e):!!k.stringStartsWith(e,"#%RAML")||e.indexOf("\n")>=0)}function I(e){return e=e||{},{rootNodeDetails:!0,attributeDefaults:!0,serializeMetadata:!0,unfoldTypes:e.unfoldTypes,typeReferences:e.typeReferences}}function R(e,t,n){return null!=e&&(e=e.replace(/\\/g,"/")),{content:function(r){return r===e?t:n?n.content(r):void 0},contentAsync:function(r){return r===e?Promise.resolve(t):n?n.contentAsync(r):void 0}}}function M(e){var t=e&&e.filePath||C.resolve("/#local.raml");return t.replace(/\\/g,"/")}Object.defineProperty(t,"__esModule",{value:!0});var w=n(2),C=n(6),L=n(17),P=n(4),O=n(55),D=n(4),U=n(276),x=n(284),k=n(15),F=n(202),B=n(308),V=n(293),K=n(203),j=n(271),W=n(19),H=n(269),Y=n(297);t.load=r,t.loadSync=i,t.parse=a,t.parseSync=o,t.loadApi=s,t.loadRAML=u,t.loadRAMLHL=l,t.loadApiAsync=c,t.loadRAMLAsync=f,t.loadRAMLAsyncHL=h,t.getLanguageElementByRuntimeType=d,t.toError=g,t.loadApis1=A,t.optionsForContent=T,t.loadOptionsForContent=S,t.virtualFSResolver=R,t.virtualFilePath=M},function(e,t,n){"use strict";function r(e){var t=J.getUniverse("RAML10"),n=t.type("Api"),r=$.createStubNode(n,null,e);return r}function i(e){var t=J.getUniverse("RAML10"),n=t.type("LibraryBase"),r=$.createStubNode(n,null,e);return r}function a(e){var t=J.getUniverse("RAML10"),n=t.type("FragmentDeclaration"),r=$.createStubNode(n,null,e);return r}function o(e){var t=J.getUniverse("RAML10"),n=t.type("Trait"),r=$.createStubNode(n,null,e);return r}function s(e){var t=J.getUniverse("RAML10"),n=t.type("MethodBase"),r=$.createStubNode(n,null,e);return r}function u(e){var t=J.getUniverse("RAML10"),n=t.type("Operation"),r=$.createStubNode(n,null,e);return r}function l(e){var t=J.getUniverse("RAML10"),n=t.type("TypeDeclaration"),r=$.createStubNode(n,null,e);return r}function p(e){var t=J.getUniverse("RAML10"),n=t.type("UsesDeclaration"),r=$.createStubNode(n,null,e);return r}function c(e){var t=J.getUniverse("RAML10"),n=t.type("XMLFacetInfo"),r=$.createStubNode(n,null,e);return r}function f(e){var t=J.getUniverse("RAML10"),n=t.type("ArrayTypeDeclaration"),r=$.createStubNode(n,null,e);return r}function h(e){var t=J.getUniverse("RAML10"),n=t.type("UnionTypeDeclaration"),r=$.createStubNode(n,null,e);return r}function d(e){var t=J.getUniverse("RAML10"),n=t.type("ObjectTypeDeclaration"),r=$.createStubNode(n,null,e);return r}function m(e){var t=J.getUniverse("RAML10"),n=t.type("StringTypeDeclaration"),r=$.createStubNode(n,null,e);return r}function y(e){var t=J.getUniverse("RAML10"),n=t.type("BooleanTypeDeclaration"),r=$.createStubNode(n,null,e);return r}function v(e){var t=J.getUniverse("RAML10"),n=t.type("NumberTypeDeclaration"),r=$.createStubNode(n,null,e);return r}function g(e){var t=J.getUniverse("RAML10"),n=t.type("IntegerTypeDeclaration"),r=$.createStubNode(n,null,e);return r}function A(e){var t=J.getUniverse("RAML10"),n=t.type("DateOnlyTypeDeclaration"),r=$.createStubNode(n,null,e);return r}function E(e){var t=J.getUniverse("RAML10"),n=t.type("TimeOnlyTypeDeclaration"),r=$.createStubNode(n,null,e);return r}function _(e){var t=J.getUniverse("RAML10"),n=t.type("DateTimeOnlyTypeDeclaration"),r=$.createStubNode(n,null,e);return r}function T(e){var t=J.getUniverse("RAML10"),n=t.type("DateTimeTypeDeclaration"),r=$.createStubNode(n,null,e);return r}function N(e){var t=J.getUniverse("RAML10"),n=t.type("FileTypeDeclaration"),r=$.createStubNode(n,null,e);return r}function S(e){var t=J.getUniverse("RAML10"),n=t.type("Response"),r=$.createStubNode(n,null,e);return r}function b(e){var t=J.getUniverse("RAML10"),n=t.type("SecuritySchemePart"),r=$.createStubNode(n,null,e);return r}function I(e){var t=J.getUniverse("RAML10"),n=t.type("AbstractSecurityScheme"),r=$.createStubNode(n,null,e);return r}function R(e){var t=J.getUniverse("RAML10"),n=t.type("SecuritySchemeSettings"),r=$.createStubNode(n,null,e);return r}function M(e){var t=J.getUniverse("RAML10"),n=t.type("OAuth1SecuritySchemeSettings"),r=$.createStubNode(n,null,e);return r}function w(e){var t=J.getUniverse("RAML10"),n=t.type("OAuth2SecuritySchemeSettings"),r=$.createStubNode(n,null,e);return r}function C(e){var t=J.getUniverse("RAML10"),n=t.type("OAuth2SecurityScheme"),r=$.createStubNode(n,null,e);return r}function L(e){var t=J.getUniverse("RAML10"),n=t.type("OAuth1SecurityScheme"),r=$.createStubNode(n,null,e);return r}function P(e){var t=J.getUniverse("RAML10"),n=t.type("PassThroughSecurityScheme"),r=$.createStubNode(n,null,e);return r}function O(e){var t=J.getUniverse("RAML10"),n=t.type("BasicSecurityScheme"),r=$.createStubNode(n,null,e);return r}function D(e){var t=J.getUniverse("RAML10"),n=t.type("DigestSecurityScheme"),r=$.createStubNode(n,null,e);return r}function U(e){var t=J.getUniverse("RAML10"),n=t.type("CustomSecurityScheme"),r=$.createStubNode(n,null,e);return r}function x(e){var t=J.getUniverse("RAML10"),n=t.type("Method"),r=$.createStubNode(n,null,e);return r;
}function k(e){var t=J.getUniverse("RAML10"),n=t.type("ResourceType"),r=$.createStubNode(n,null,e);return r}function F(e){var t=J.getUniverse("RAML10"),n=t.type("ResourceBase"),r=$.createStubNode(n,null,e);return r}function B(e){var t=J.getUniverse("RAML10"),n=t.type("Resource"),r=$.createStubNode(n,null,e);return r}function V(e){var t=J.getUniverse("RAML10"),n=t.type("DocumentationItem"),r=$.createStubNode(n,null,e);return r}function K(e){var t=J.getUniverse("RAML10"),n=t.type("Library"),r=$.createStubNode(n,null,e);return r}function j(e){var t=J.getUniverse("RAML10"),n=t.type("Overlay"),r=$.createStubNode(n,null,e);return r}function W(e){var t=J.getUniverse("RAML10"),n=t.type("Extension"),r=$.createStubNode(n,null,e);return r}function H(e,t,n){return Z.loadApi(e,t,n).getOrElse(null)}function Y(e,t,n){return Z.loadApi(e,t,n).getOrElse(null)}function q(e,t,n){return Z.loadApiAsync(e,t,n)}function G(e,t,n){return Z.loadRAMLAsync(e,t,n)}function X(e){return Z.getLanguageElementByRuntimeType(e)}var z=this&&this.__extends||function(){var e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();Object.defineProperty(t,"__esModule",{value:!0});var $=n(3),J=n(56),Q=n(278),Z=n(1),ee=n(288),te=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.annotations=function(){return e.prototype.attributes.call(this,"annotations",function(e){return new Lt(e)})},t.prototype.wrapperClassName=function(){return"AnnotableImpl"},t.prototype.kind=function(){return"Annotable"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("Annotable")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.AnnotableImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.AnnotableImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(Q.BasicNodeImpl);t.AnnotableImpl=te;var ne=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"ValueTypeImpl"},t.prototype.kind=function(){return"ValueType"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("ValueType")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("undefined.ValueTypeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("undefined.ValueTypeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"undefined"},t.prototype.value=function(){return this.attr.value()},t}(Q.AttributeNodeImpl);t.ValueTypeImpl=ne;var re=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"StringTypeImpl"},t.prototype.kind=function(){return"StringType"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("StringType")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.StringTypeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.StringTypeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.value=function(){return this.attr.value()},t}(ne);t.StringTypeImpl=re;var ie=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"UriTemplateImpl"},t.prototype.kind=function(){return"UriTemplate"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("UriTemplate")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.UriTemplateImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.UriTemplateImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(re);t.UriTemplateImpl=ie;var ae=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"RelativeUriStringImpl"},t.prototype.kind=function(){return"RelativeUriString"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("RelativeUriString")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.RelativeUriStringImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.RelativeUriStringImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(ie);t.RelativeUriStringImpl=ae;var oe=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"FullUriTemplateStringImpl"},t.prototype.kind=function(){return"FullUriTemplateString"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("FullUriTemplateString")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.FullUriTemplateStringImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.FullUriTemplateStringImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(ie);t.FullUriTemplateStringImpl=oe;var se=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"StatusCodeStringImpl"},t.prototype.kind=function(){return"StatusCodeString"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("StatusCodeString")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.StatusCodeStringImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.StatusCodeStringImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(re);t.StatusCodeStringImpl=se;var ue=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"FixedUriStringImpl"},t.prototype.kind=function(){return"FixedUriString"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("FixedUriString")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.FixedUriStringImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.FixedUriStringImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(re);t.FixedUriStringImpl=ue;var le=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"ContentTypeImpl"},t.prototype.kind=function(){return"ContentType"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("ContentType")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.ContentTypeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.ContentTypeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(re);t.ContentTypeImpl=le;var pe=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"MarkdownStringImpl"},t.prototype.kind=function(){return"MarkdownString"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("MarkdownString")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.MarkdownStringImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.MarkdownStringImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(re);t.MarkdownStringImpl=pe;var ce=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"SchemaStringImpl"},t.prototype.kind=function(){return"SchemaString"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("SchemaString")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.SchemaStringImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.SchemaStringImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(re);t.SchemaStringImpl=ce;var fe=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"MimeTypeImpl"},t.prototype.kind=function(){return"MimeType"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("MimeType")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.MimeTypeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.MimeTypeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(re);t.MimeTypeImpl=fe;var he=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"AnyTypeImpl"},t.prototype.kind=function(){return"AnyType"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("AnyType")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.AnyTypeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.AnyTypeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(ne);t.AnyTypeImpl=he;var de=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"NumberTypeImpl"},t.prototype.kind=function(){return"NumberType"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("NumberType")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.NumberTypeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.NumberTypeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.value=function(){return this.attr.value()},t}(ne);t.NumberTypeImpl=de;var me=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"IntegerTypeImpl"},t.prototype.kind=function(){return"IntegerType"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("IntegerType")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.IntegerTypeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.IntegerTypeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(ne);t.IntegerTypeImpl=me;var ye=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"NullTypeImpl"},t.prototype.kind=function(){return"NullType"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("NullType")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.NullTypeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.NullTypeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(ne);t.NullTypeImpl=ye;var ve=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"TimeOnlyTypeImpl"},t.prototype.kind=function(){return"TimeOnlyType"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("TimeOnlyType")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.TimeOnlyTypeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.TimeOnlyTypeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(ne);t.TimeOnlyTypeImpl=ve;var ge=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"DateOnlyTypeImpl"},t.prototype.kind=function(){return"DateOnlyType"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("DateOnlyType")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.DateOnlyTypeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.DateOnlyTypeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(ne);t.DateOnlyTypeImpl=ge;var Ae=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"DateTimeOnlyTypeImpl"},t.prototype.kind=function(){return"DateTimeOnlyType"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("DateTimeOnlyType")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.DateTimeOnlyTypeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.DateTimeOnlyTypeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(ne);t.DateTimeOnlyTypeImpl=Ae;var Ee=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"DateTimeTypeImpl"},t.prototype.kind=function(){return"DateTimeType"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("DateTimeType")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.DateTimeTypeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.DateTimeTypeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(ne);t.DateTimeTypeImpl=Ee;var _e=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"FileTypeImpl"},t.prototype.kind=function(){return"FileType"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("FileType")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.FileTypeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.FileTypeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(ne);t.FileTypeImpl=_e;var Te=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"BooleanTypeImpl"},t.prototype.kind=function(){return"BooleanType"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("BooleanType")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.BooleanTypeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.BooleanTypeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.value=function(){return this.attr.value()},t}(ne);t.BooleanTypeImpl=Te;var Ne=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"AnnotationTargetImpl"},t.prototype.kind=function(){return"AnnotationTarget"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("AnnotationTarget")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.AnnotationTargetImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.AnnotationTargetImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(ne);t.AnnotationTargetImpl=Ne;var Se=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"ReferenceImpl"},t.prototype.kind=function(){return"Reference"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("Reference")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.ReferenceImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.ReferenceImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.value=function(){return Q.toStructuredValue(this.attr)},t.prototype.structuredValue=function(){return ee.structuredValue(this)},t.prototype.name=function(){return ee.referenceName(this)},t}(Q.AttributeNodeImpl);t.ReferenceImpl=Se;var be=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"TraitRefImpl"},t.prototype.kind=function(){return"TraitRef"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("TraitRef")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.TraitRefImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.TraitRefImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.trait=function(){return ee.referencedTrait(this)},t}(Se);t.TraitRefImpl=be;var Ie=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?u(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.queryParameters=function(){return e.prototype.elements.call(this,"queryParameters")},t.prototype.headers=function(){return e.prototype.elements.call(this,"headers")},t.prototype.queryString=function(){return e.prototype.element.call(this,"queryString")},t.prototype.responses=function(){return e.prototype.elements.call(this,"responses")},t.prototype.wrapperClassName=function(){return"OperationImpl"},t.prototype.kind=function(){return"Operation"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("Operation")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.OperationImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.OperationImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(te);t.OperationImpl=Ie;var Re=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?l(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.name=function(){return e.prototype.attribute.call(this,"name",this.toString)},t.prototype.setName=function(e){return this.highLevel().attrOrCreate("name").setValue(""+e),this},t.prototype.displayName=function(){return e.prototype.attribute.call(this,"displayName",this.toString)},t.prototype.setDisplayName=function(e){return this.highLevel().attrOrCreate("displayName").setValue(""+e),this},t.prototype.facets=function(){return e.prototype.elements.call(this,"facets")},t.prototype.schema_original=function(){return e.prototype.attributes.call(this,"schema",this.toString)},t.prototype.setSchema=function(e){return this.highLevel().attrOrCreate("schema").setValue(""+e),this},t.prototype.type_original=function(){return e.prototype.attributes.call(this,"type",this.toString)},t.prototype.setType=function(e){return this.highLevel().attrOrCreate("type").setValue(""+e),this},t.prototype.location=function(){return e.prototype.attribute.call(this,"location",function(e){return new Me(e)})},t.prototype.locationKind=function(){return e.prototype.attribute.call(this,"locationKind",function(e){return new we(e)})},t.prototype["default"]=function(){return e.prototype.attribute.call(this,"default",this.toAny)},t.prototype.setDefault=function(e){return this.highLevel().attrOrCreate("default").setValue(""+e),this},t.prototype.example_original=function(){return e.prototype.element.call(this,"example")},t.prototype.examples_original=function(){return e.prototype.elements.call(this,"examples")},t.prototype.required=function(){return e.prototype.attribute.call(this,"required",this.toBoolean)},t.prototype.setRequired=function(e){return this.highLevel().attrOrCreate("required").setValue(""+e),this},t.prototype.description=function(){return e.prototype.attribute.call(this,"description",function(e){return new pe(e)})},t.prototype.xml=function(){return e.prototype.element.call(this,"xml")},t.prototype.allowedTargets=function(){return e.prototype.attributes.call(this,"allowedTargets",function(e){return new Ne(e)})},t.prototype.isAnnotation=function(){return e.prototype.attribute.call(this,"isAnnotation",this.toBoolean)},t.prototype.setIsAnnotation=function(e){return this.highLevel().attrOrCreate("isAnnotation").setValue(""+e),this},t.prototype.annotations=function(){return e.prototype.attributes.call(this,"annotations",function(e){return new Lt(e)})},t.prototype.uses=function(){return e.prototype.elements.call(this,"uses")},t.prototype.wrapperClassName=function(){return"TypeDeclarationImpl"},t.prototype.kind=function(){return"TypeDeclaration"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("TypeDeclaration")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.TypeDeclarationImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.TypeDeclarationImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.runtimeType=function(){return ee.runtimeType(this)},t.prototype.validateInstance=function(e){return ee.validateInstance(this,e)},t.prototype.validateInstanceWithDetailedStatuses=function(e){return ee.validateInstanceWithDetailedStatuses(this,e)},t.prototype.example=function(){return ee.getTypeExample(this)},t.prototype.examples=function(){return ee.getTypeExamples(this)},t.prototype.fixedFacets=function(){return ee.typeFixedFacets(this)},t.prototype.type=function(){return ee.typeValue(this)},t.prototype.schema=function(){return ee.schemaValue(this)},t.prototype.structuredType=function(){return ee.typeStructuredValue(this)},t.prototype.parametrizedProperties=function(){return ee.getTemplateParametrizedProperties(this)},t.prototype.scalarsAnnotations=function(){return new Ue(this.highLevel())},t}(te);t.TypeDeclarationImpl=Re;var Me=function(){function e(e){this.attr=e}return e.prototype.wrapperClassName=function(){return"ModelLocationImpl"},e.prototype.kind=function(){return"ModelLocation"},e.prototype.allKinds=function(){return["ModelLocation"]},e.prototype.allWrapperClassNames=function(){return["RAML10.ModelLocationImpl"]},e.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.ModelLocationImpl"==r)return!0}return!1},e.prototype.RAMLVersion=function(){return"RAML10"},e}();t.ModelLocationImpl=Me;var we=function(){function e(e){this.attr=e}return e.prototype.wrapperClassName=function(){return"LocationKindImpl"},e.prototype.kind=function(){return"LocationKind"},e.prototype.allKinds=function(){return["LocationKind"]},e.prototype.allWrapperClassNames=function(){return["RAML10.LocationKindImpl"]},e.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.LocationKindImpl"==r)return!0}return!1},e.prototype.RAMLVersion=function(){return"RAML10"},e}();t.LocationKindImpl=we;var Ce=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?p(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.key=function(){return e.prototype.attribute.call(this,"key",this.toString)},t.prototype.setKey=function(e){return this.highLevel().attrOrCreate("key").setValue(""+e),this},t.prototype.value=function(){return e.prototype.attribute.call(this,"value",this.toString)},t.prototype.setValue=function(e){return this.highLevel().attrOrCreate("value").setValue(""+e),this},t.prototype.wrapperClassName=function(){return"UsesDeclarationImpl"},t.prototype.kind=function(){return"UsesDeclaration"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("UsesDeclaration")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.UsesDeclarationImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.UsesDeclarationImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.ast=function(){return ee.referencedNode(this)},t.prototype.scalarsAnnotations=function(){return new Le(this.highLevel())},t}(te);t.UsesDeclarationImpl=Ce;var Le=function(){function e(e){this.node=e}return e.prototype.value=function(){var e=this.node.attr("value");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e}();t.UsesDeclarationScalarsAnnotationsImpl=Le;var Pe=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?c(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.attribute=function(){return e.prototype.attribute.call(this,"attribute",this.toBoolean)},t.prototype.setAttribute=function(e){return this.highLevel().attrOrCreate("attribute").setValue(""+e),this},t.prototype.wrapped=function(){return e.prototype.attribute.call(this,"wrapped",this.toBoolean)},t.prototype.setWrapped=function(e){return this.highLevel().attrOrCreate("wrapped").setValue(""+e),this},t.prototype.name=function(){return e.prototype.attribute.call(this,"name",this.toString)},t.prototype.setName=function(e){return this.highLevel().attrOrCreate("name").setValue(""+e),this},t.prototype.namespace=function(){return e.prototype.attribute.call(this,"namespace",this.toString)},t.prototype.setNamespace=function(e){return this.highLevel().attrOrCreate("namespace").setValue(""+e),this},t.prototype.prefix=function(){return e.prototype.attribute.call(this,"prefix",this.toString)},t.prototype.setPrefix=function(e){return this.highLevel().attrOrCreate("prefix").setValue(""+e),this},t.prototype.wrapperClassName=function(){return"XMLFacetInfoImpl"},t.prototype.kind=function(){return"XMLFacetInfo"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("XMLFacetInfo")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.XMLFacetInfoImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.XMLFacetInfoImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.scalarsAnnotations=function(){return new Oe(this.highLevel())},t}(te);t.XMLFacetInfoImpl=Pe;var Oe=function(){function e(e){this.node=e}return e.prototype.attribute=function(){var e=this.node.attr("attribute");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.wrapped=function(){var e=this.node.attr("wrapped");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.name=function(){var e=this.node.attr("name");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.namespace=function(){var e=this.node.attr("namespace");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.prefix=function(){var e=this.node.attr("prefix");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e}();t.XMLFacetInfoScalarsAnnotationsImpl=Oe;var De=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?f(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.uniqueItems=function(){return e.prototype.attribute.call(this,"uniqueItems",this.toBoolean)},t.prototype.setUniqueItems=function(e){return this.highLevel().attrOrCreate("uniqueItems").setValue(""+e),this},t.prototype.items_original=function(){return e.prototype.attributes.call(this,"items",this.toString)},t.prototype.setItems=function(e){return this.highLevel().attrOrCreate("items").setValue(""+e),this},t.prototype.minItems=function(){return e.prototype.attribute.call(this,"minItems",this.toNumber)},t.prototype.setMinItems=function(e){return this.highLevel().attrOrCreate("minItems").setValue(""+e),
this},t.prototype.maxItems=function(){return e.prototype.attribute.call(this,"maxItems",this.toNumber)},t.prototype.setMaxItems=function(e){return this.highLevel().attrOrCreate("maxItems").setValue(""+e),this},t.prototype.wrapperClassName=function(){return"ArrayTypeDeclarationImpl"},t.prototype.kind=function(){return"ArrayTypeDeclaration"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("ArrayTypeDeclaration")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.ArrayTypeDeclarationImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.ArrayTypeDeclarationImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.structuredItems=function(){return ee.itemsStructuredValue(this)},t.prototype.items=function(){return ee.getItems(this)},t.prototype.findComponentTypeDeclaration=function(){return ee.findComponentTypeDeclaration(this)},t.prototype.scalarsAnnotations=function(){return new xe(this.highLevel())},t}(Re);t.ArrayTypeDeclarationImpl=De;var Ue=function(){function e(e){this.node=e}return e.prototype.displayName=function(){var e=this.node.attr("displayName");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.schema=function(){var e=this.node.attributes("schema");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},e.prototype.type=function(){var e=this.node.attributes("type");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},e.prototype.location=function(){var e=this.node.attr("location");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.locationKind=function(){var e=this.node.attr("locationKind");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype["default"]=function(){var e=this.node.attr("default");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.required=function(){var e=this.node.attr("required");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.description=function(){var e=this.node.attr("description");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.allowedTargets=function(){var e=this.node.attributes("allowedTargets");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},e.prototype.isAnnotation=function(){var e=this.node.attr("isAnnotation");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e}();t.TypeDeclarationScalarsAnnotationsImpl=Ue;var xe=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.uniqueItems=function(){var e=this.node.attr("uniqueItems");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype.items=function(){var e=this.node.attributes("items");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},t.prototype.minItems=function(){var e=this.node.attr("minItems");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype.maxItems=function(){var e=this.node.attr("maxItems");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t}(Ue);t.ArrayTypeDeclarationScalarsAnnotationsImpl=xe;var ke=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?h(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.wrapperClassName=function(){return"UnionTypeDeclarationImpl"},t.prototype.kind=function(){return"UnionTypeDeclaration"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("UnionTypeDeclaration")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.UnionTypeDeclarationImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.UnionTypeDeclarationImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(Re);t.UnionTypeDeclarationImpl=ke;var Fe=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?d(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.properties=function(){return e.prototype.elements.call(this,"properties")},t.prototype.minProperties=function(){return e.prototype.attribute.call(this,"minProperties",this.toNumber)},t.prototype.setMinProperties=function(e){return this.highLevel().attrOrCreate("minProperties").setValue(""+e),this},t.prototype.maxProperties=function(){return e.prototype.attribute.call(this,"maxProperties",this.toNumber)},t.prototype.setMaxProperties=function(e){return this.highLevel().attrOrCreate("maxProperties").setValue(""+e),this},t.prototype.additionalProperties=function(){return e.prototype.attribute.call(this,"additionalProperties",this.toBoolean)},t.prototype.setAdditionalProperties=function(e){return this.highLevel().attrOrCreate("additionalProperties").setValue(""+e),this},t.prototype.discriminator=function(){return e.prototype.attribute.call(this,"discriminator",this.toString)},t.prototype.setDiscriminator=function(e){return this.highLevel().attrOrCreate("discriminator").setValue(""+e),this},t.prototype.discriminatorValue=function(){return e.prototype.attribute.call(this,"discriminatorValue",this.toString)},t.prototype.setDiscriminatorValue=function(e){return this.highLevel().attrOrCreate("discriminatorValue").setValue(""+e),this},t.prototype["enum"]=function(){return e.prototype.attributes.call(this,"enum",this.toAny)},t.prototype.setEnum=function(e){return this.highLevel().attrOrCreate("enum").setValue(""+e),this},t.prototype.wrapperClassName=function(){return"ObjectTypeDeclarationImpl"},t.prototype.kind=function(){return"ObjectTypeDeclaration"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("ObjectTypeDeclaration")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.ObjectTypeDeclarationImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.ObjectTypeDeclarationImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.scalarsAnnotations=function(){return new Be(this.highLevel())},t}(Re);t.ObjectTypeDeclarationImpl=Fe;var Be=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.minProperties=function(){var e=this.node.attr("minProperties");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype.maxProperties=function(){var e=this.node.attr("maxProperties");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype.additionalProperties=function(){var e=this.node.attr("additionalProperties");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype.discriminator=function(){var e=this.node.attr("discriminator");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype.discriminatorValue=function(){var e=this.node.attr("discriminatorValue");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype["enum"]=function(){var e=this.node.attributes("enum");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},t}(Ue);t.ObjectTypeDeclarationScalarsAnnotationsImpl=Be;var Ve=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?m(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.pattern=function(){return e.prototype.attribute.call(this,"pattern",this.toString)},t.prototype.setPattern=function(e){return this.highLevel().attrOrCreate("pattern").setValue(""+e),this},t.prototype.minLength=function(){return e.prototype.attribute.call(this,"minLength",this.toNumber)},t.prototype.setMinLength=function(e){return this.highLevel().attrOrCreate("minLength").setValue(""+e),this},t.prototype.maxLength=function(){return e.prototype.attribute.call(this,"maxLength",this.toNumber)},t.prototype.setMaxLength=function(e){return this.highLevel().attrOrCreate("maxLength").setValue(""+e),this},t.prototype["enum"]=function(){return e.prototype.attributes.call(this,"enum",this.toString)},t.prototype.setEnum=function(e){return this.highLevel().attrOrCreate("enum").setValue(""+e),this},t.prototype.wrapperClassName=function(){return"StringTypeDeclarationImpl"},t.prototype.kind=function(){return"StringTypeDeclaration"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("StringTypeDeclaration")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.StringTypeDeclarationImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.StringTypeDeclarationImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.scalarsAnnotations=function(){return new Ke(this.highLevel())},t}(Re);t.StringTypeDeclarationImpl=Ve;var Ke=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.pattern=function(){var e=this.node.attr("pattern");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype.minLength=function(){var e=this.node.attr("minLength");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype.maxLength=function(){var e=this.node.attr("maxLength");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype["enum"]=function(){var e=this.node.attributes("enum");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},t}(Ue);t.StringTypeDeclarationScalarsAnnotationsImpl=Ke;var je=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?y(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype["enum"]=function(){return e.prototype.attributes.call(this,"enum",this.toBoolean)},t.prototype.setEnum=function(e){return this.highLevel().attrOrCreate("enum").setValue(""+e),this},t.prototype.wrapperClassName=function(){return"BooleanTypeDeclarationImpl"},t.prototype.kind=function(){return"BooleanTypeDeclaration"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("BooleanTypeDeclaration")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.BooleanTypeDeclarationImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.BooleanTypeDeclarationImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.scalarsAnnotations=function(){return new We(this.highLevel())},t}(Re);t.BooleanTypeDeclarationImpl=je;var We=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype["enum"]=function(){var e=this.node.attributes("enum");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},t}(Ue);t.BooleanTypeDeclarationScalarsAnnotationsImpl=We;var He=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?v(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.minimum=function(){return e.prototype.attribute.call(this,"minimum",this.toNumber)},t.prototype.setMinimum=function(e){return this.highLevel().attrOrCreate("minimum").setValue(""+e),this},t.prototype.maximum=function(){return e.prototype.attribute.call(this,"maximum",this.toNumber)},t.prototype.setMaximum=function(e){return this.highLevel().attrOrCreate("maximum").setValue(""+e),this},t.prototype["enum"]=function(){return e.prototype.attributes.call(this,"enum",this.toNumber)},t.prototype.setEnum=function(e){return this.highLevel().attrOrCreate("enum").setValue(""+e),this},t.prototype.format=function(){return e.prototype.attribute.call(this,"format",this.toString)},t.prototype.setFormat=function(e){return this.highLevel().attrOrCreate("format").setValue(""+e),this},t.prototype.multipleOf=function(){return e.prototype.attribute.call(this,"multipleOf",this.toNumber)},t.prototype.setMultipleOf=function(e){return this.highLevel().attrOrCreate("multipleOf").setValue(""+e),this},t.prototype.wrapperClassName=function(){return"NumberTypeDeclarationImpl"},t.prototype.kind=function(){return"NumberTypeDeclaration"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("NumberTypeDeclaration")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.NumberTypeDeclarationImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.NumberTypeDeclarationImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.scalarsAnnotations=function(){return new qe(this.highLevel())},t}(Re);t.NumberTypeDeclarationImpl=He;var Ye=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?g(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.format=function(){return e.prototype.attribute.call(this,"format",this.toString)},t.prototype.setFormat=function(e){return this.highLevel().attrOrCreate("format").setValue(""+e),this},t.prototype.wrapperClassName=function(){return"IntegerTypeDeclarationImpl"},t.prototype.kind=function(){return"IntegerTypeDeclaration"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("IntegerTypeDeclaration")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.IntegerTypeDeclarationImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.IntegerTypeDeclarationImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.scalarsAnnotations=function(){return new Ge(this.highLevel())},t}(He);t.IntegerTypeDeclarationImpl=Ye;var qe=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.minimum=function(){var e=this.node.attr("minimum");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype.maximum=function(){var e=this.node.attr("maximum");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype["enum"]=function(){var e=this.node.attributes("enum");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},t.prototype.format=function(){var e=this.node.attr("format");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype.multipleOf=function(){var e=this.node.attr("multipleOf");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t}(Ue);t.NumberTypeDeclarationScalarsAnnotationsImpl=qe;var Ge=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.format=function(){var e=this.node.attr("format");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t}(qe);t.IntegerTypeDeclarationScalarsAnnotationsImpl=Ge;var Xe=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?A(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.wrapperClassName=function(){return"DateOnlyTypeDeclarationImpl"},t.prototype.kind=function(){return"DateOnlyTypeDeclaration"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("DateOnlyTypeDeclaration")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.DateOnlyTypeDeclarationImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.DateOnlyTypeDeclarationImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(Re);t.DateOnlyTypeDeclarationImpl=Xe;var ze=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?E(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.wrapperClassName=function(){return"TimeOnlyTypeDeclarationImpl"},t.prototype.kind=function(){return"TimeOnlyTypeDeclaration"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("TimeOnlyTypeDeclaration")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.TimeOnlyTypeDeclarationImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.TimeOnlyTypeDeclarationImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(Re);t.TimeOnlyTypeDeclarationImpl=ze;var $e=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?_(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.wrapperClassName=function(){return"DateTimeOnlyTypeDeclarationImpl"},t.prototype.kind=function(){return"DateTimeOnlyTypeDeclaration"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("DateTimeOnlyTypeDeclaration")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.DateTimeOnlyTypeDeclarationImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.DateTimeOnlyTypeDeclarationImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(Re);t.DateTimeOnlyTypeDeclarationImpl=$e;var Je=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?T(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.format=function(){return e.prototype.attribute.call(this,"format",this.toString)},t.prototype.setFormat=function(e){return this.highLevel().attrOrCreate("format").setValue(""+e),this},t.prototype.wrapperClassName=function(){return"DateTimeTypeDeclarationImpl"},t.prototype.kind=function(){return"DateTimeTypeDeclaration"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("DateTimeTypeDeclaration")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.DateTimeTypeDeclarationImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.DateTimeTypeDeclarationImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.scalarsAnnotations=function(){return new Qe(this.highLevel())},t}(Re);t.DateTimeTypeDeclarationImpl=Je;var Qe=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.format=function(){var e=this.node.attr("format");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t}(Ue);t.DateTimeTypeDeclarationScalarsAnnotationsImpl=Qe;var Ze=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?N(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.fileTypes=function(){return e.prototype.attributes.call(this,"fileTypes",function(e){return new le(e)})},t.prototype.minLength=function(){return e.prototype.attribute.call(this,"minLength",this.toNumber)},t.prototype.setMinLength=function(e){return this.highLevel().attrOrCreate("minLength").setValue(""+e),this},t.prototype.maxLength=function(){return e.prototype.attribute.call(this,"maxLength",this.toNumber)},t.prototype.setMaxLength=function(e){return this.highLevel().attrOrCreate("maxLength").setValue(""+e),this},t.prototype.wrapperClassName=function(){return"FileTypeDeclarationImpl"},t.prototype.kind=function(){return"FileTypeDeclaration"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("FileTypeDeclaration")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.FileTypeDeclarationImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.FileTypeDeclarationImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.scalarsAnnotations=function(){return new et(this.highLevel())},t}(Re);t.FileTypeDeclarationImpl=Ze;var et=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.fileTypes=function(){var e=this.node.attributes("fileTypes");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},t.prototype.minLength=function(){var e=this.node.attr("minLength");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype.maxLength=function(){var e=this.node.attr("maxLength");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t}(Ue);t.FileTypeDeclarationScalarsAnnotationsImpl=et;var tt=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?S(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.code=function(){return e.prototype.attribute.call(this,"code",function(e){return new se(e)})},t.prototype.headers=function(){return e.prototype.elements.call(this,"headers")},t.prototype.body=function(){return e.prototype.elements.call(this,"body")},t.prototype.description=function(){return e.prototype.attribute.call(this,"description",function(e){return new pe(e)})},t.prototype.annotations=function(){return e.prototype.attributes.call(this,"annotations",function(e){return new Lt(e)})},t.prototype.wrapperClassName=function(){return"ResponseImpl"},t.prototype.kind=function(){return"Response"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("Response")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.ResponseImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.ResponseImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.isOkRange=function(){return ee.isOkRange(this)},t.prototype.parametrizedProperties=function(){return ee.getTemplateParametrizedProperties(this)},t.prototype.scalarsAnnotations=function(){return new nt(this.highLevel())},t}(te);t.ResponseImpl=tt;var nt=function(){function e(e){this.node=e}return e.prototype.description=function(){var e=this.node.attr("description");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e}();t.ResponseScalarsAnnotationsImpl=nt;var rt=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?b(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.annotations=function(){return e.prototype.attributes.call(this,"annotations",function(e){return new Lt(e)})},t.prototype.wrapperClassName=function(){return"SecuritySchemePartImpl"},t.prototype.kind=function(){return"SecuritySchemePart"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("SecuritySchemePart")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.SecuritySchemePartImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.SecuritySchemePartImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(Ie);t.SecuritySchemePartImpl=rt;var it=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?s(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.body=function(){return e.prototype.elements.call(this,"body")},t.prototype.protocols=function(){return e.prototype.attributes.call(this,"protocols",this.toString)},t.prototype.setProtocols=function(e){return this.highLevel().attrOrCreate("protocols").setValue(""+e),this},t.prototype.is=function(){return e.prototype.attributes.call(this,"is",function(e){return new be(e)})},t.prototype.securedBy=function(){return e.prototype.attributes.call(this,"securedBy",function(e){return new at(e)})},t.prototype.description=function(){return e.prototype.attribute.call(this,"description",function(e){return new pe(e)})},t.prototype.displayName=function(){return e.prototype.attribute.call(this,"displayName",this.toString)},t.prototype.setDisplayName=function(e){return this.highLevel().attrOrCreate("displayName").setValue(""+e),this},t.prototype.wrapperClassName=function(){return"MethodBaseImpl"},t.prototype.kind=function(){return"MethodBase"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("MethodBase")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.MethodBaseImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.MethodBaseImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.scalarsAnnotations=function(){return new Et(this.highLevel())},t}(Ie);t.MethodBaseImpl=it;var at=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"SecuritySchemeRefImpl"},t.prototype.kind=function(){return"SecuritySchemeRef"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("SecuritySchemeRef")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.SecuritySchemeRefImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.SecuritySchemeRefImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.securitySchemeName=function(){return ee.securitySchemeName(this)},t.prototype.securityScheme=function(){return ee.securityScheme(this)},t}(Se);t.SecuritySchemeRefImpl=at;var ot=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?I(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.name=function(){return e.prototype.attribute.call(this,"name",this.toString)},t.prototype.setName=function(e){return this.highLevel().attrOrCreate("name").setValue(""+e),this},t.prototype.type=function(){return e.prototype.attribute.call(this,"type",this.toString)},t.prototype.setType=function(e){return this.highLevel().attrOrCreate("type").setValue(""+e),this},t.prototype.description=function(){return e.prototype.attribute.call(this,"description",function(e){return new pe(e)})},t.prototype.describedBy=function(){return e.prototype.element.call(this,"describedBy")},t.prototype.displayName=function(){return e.prototype.attribute.call(this,"displayName",this.toString)},t.prototype.setDisplayName=function(e){return this.highLevel().attrOrCreate("displayName").setValue(""+e),this},t.prototype.settings=function(){return e.prototype.element.call(this,"settings")},t.prototype.wrapperClassName=function(){return"AbstractSecuritySchemeImpl"},t.prototype.kind=function(){return"AbstractSecurityScheme"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("AbstractSecurityScheme")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.AbstractSecuritySchemeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.AbstractSecuritySchemeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.scalarsAnnotations=function(){return new gt(this.highLevel())},t}(te);t.AbstractSecuritySchemeImpl=ot;var st=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?R(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.wrapperClassName=function(){return"SecuritySchemeSettingsImpl"},t.prototype.kind=function(){return"SecuritySchemeSettings"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("SecuritySchemeSettings")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.SecuritySchemeSettingsImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.SecuritySchemeSettingsImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(te);t.SecuritySchemeSettingsImpl=st;var ut=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?M(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.requestTokenUri=function(){return e.prototype.attribute.call(this,"requestTokenUri",function(e){return new ue(e)})},t.prototype.authorizationUri=function(){return e.prototype.attribute.call(this,"authorizationUri",function(e){return new ue(e)})},t.prototype.tokenCredentialsUri=function(){return e.prototype.attribute.call(this,"tokenCredentialsUri",function(e){return new ue(e)})},t.prototype.signatures=function(){return e.prototype.attributes.call(this,"signatures",this.toString)},t.prototype.setSignatures=function(e){return this.highLevel().attrOrCreate("signatures").setValue(""+e),this},t.prototype.wrapperClassName=function(){return"OAuth1SecuritySchemeSettingsImpl";
},t.prototype.kind=function(){return"OAuth1SecuritySchemeSettings"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("OAuth1SecuritySchemeSettings")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.OAuth1SecuritySchemeSettingsImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.OAuth1SecuritySchemeSettingsImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.scalarsAnnotations=function(){return new lt(this.highLevel())},t}(st);t.OAuth1SecuritySchemeSettingsImpl=ut;var lt=function(){function e(e){this.node=e}return e.prototype.requestTokenUri=function(){var e=this.node.attr("requestTokenUri");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.authorizationUri=function(){var e=this.node.attr("authorizationUri");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.tokenCredentialsUri=function(){var e=this.node.attr("tokenCredentialsUri");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.signatures=function(){var e=this.node.attributes("signatures");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},e}();t.OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl=lt;var pt=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?w(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.accessTokenUri=function(){return e.prototype.attribute.call(this,"accessTokenUri",function(e){return new ue(e)})},t.prototype.authorizationUri=function(){return e.prototype.attribute.call(this,"authorizationUri",function(e){return new ue(e)})},t.prototype.authorizationGrants=function(){return e.prototype.attributes.call(this,"authorizationGrants",this.toString)},t.prototype.setAuthorizationGrants=function(e){return this.highLevel().attrOrCreate("authorizationGrants").setValue(""+e),this},t.prototype.scopes=function(){return e.prototype.attributes.call(this,"scopes",this.toString)},t.prototype.setScopes=function(e){return this.highLevel().attrOrCreate("scopes").setValue(""+e),this},t.prototype.wrapperClassName=function(){return"OAuth2SecuritySchemeSettingsImpl"},t.prototype.kind=function(){return"OAuth2SecuritySchemeSettings"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("OAuth2SecuritySchemeSettings")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.OAuth2SecuritySchemeSettingsImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.OAuth2SecuritySchemeSettingsImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.scalarsAnnotations=function(){return new ct(this.highLevel())},t}(st);t.OAuth2SecuritySchemeSettingsImpl=pt;var ct=function(){function e(e){this.node=e}return e.prototype.accessTokenUri=function(){var e=this.node.attr("accessTokenUri");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.authorizationUri=function(){var e=this.node.attr("authorizationUri");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.authorizationGrants=function(){var e=this.node.attributes("authorizationGrants");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},e.prototype.scopes=function(){var e=this.node.attributes("scopes");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},e}();t.OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl=ct;var ft=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?C(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.settings=function(){return e.prototype.element.call(this,"settings")},t.prototype.wrapperClassName=function(){return"OAuth2SecuritySchemeImpl"},t.prototype.kind=function(){return"OAuth2SecurityScheme"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("OAuth2SecurityScheme")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.OAuth2SecuritySchemeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.OAuth2SecuritySchemeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(ot);t.OAuth2SecuritySchemeImpl=ft;var ht=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?L(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.settings=function(){return e.prototype.element.call(this,"settings")},t.prototype.wrapperClassName=function(){return"OAuth1SecuritySchemeImpl"},t.prototype.kind=function(){return"OAuth1SecurityScheme"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("OAuth1SecurityScheme")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.OAuth1SecuritySchemeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.OAuth1SecuritySchemeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(ot);t.OAuth1SecuritySchemeImpl=ht;var dt=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?P(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.settings=function(){return e.prototype.element.call(this,"settings")},t.prototype.wrapperClassName=function(){return"PassThroughSecuritySchemeImpl"},t.prototype.kind=function(){return"PassThroughSecurityScheme"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("PassThroughSecurityScheme")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.PassThroughSecuritySchemeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.PassThroughSecuritySchemeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(ot);t.PassThroughSecuritySchemeImpl=dt;var mt=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?O(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.wrapperClassName=function(){return"BasicSecuritySchemeImpl"},t.prototype.kind=function(){return"BasicSecurityScheme"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("BasicSecurityScheme")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.BasicSecuritySchemeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.BasicSecuritySchemeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(ot);t.BasicSecuritySchemeImpl=mt;var yt=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?D(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.wrapperClassName=function(){return"DigestSecuritySchemeImpl"},t.prototype.kind=function(){return"DigestSecurityScheme"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("DigestSecurityScheme")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.DigestSecuritySchemeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.DigestSecuritySchemeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(ot);t.DigestSecuritySchemeImpl=yt;var vt=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?U(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.wrapperClassName=function(){return"CustomSecuritySchemeImpl"},t.prototype.kind=function(){return"CustomSecurityScheme"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("CustomSecurityScheme")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.CustomSecuritySchemeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.CustomSecuritySchemeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(ot);t.CustomSecuritySchemeImpl=vt;var gt=function(){function e(e){this.node=e}return e.prototype.type=function(){var e=this.node.attr("type");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.description=function(){var e=this.node.attr("description");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.displayName=function(){var e=this.node.attr("displayName");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e}();t.AbstractSecuritySchemeScalarsAnnotationsImpl=gt;var At=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?x(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.method=function(){return e.prototype.attribute.call(this,"method",this.toString)},t.prototype.setMethod=function(e){return this.highLevel().attrOrCreate("method").setValue(""+e),this},t.prototype.displayName=function(){return e.prototype.attribute.call(this,"displayName",this.toString)},t.prototype.setDisplayName=function(e){return this.highLevel().attrOrCreate("displayName").setValue(""+e),this},t.prototype.wrapperClassName=function(){return"MethodImpl"},t.prototype.kind=function(){return"Method"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("Method")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.MethodImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.MethodImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.parentResource=function(){return ee.parentResource(this)},t.prototype.ownerApi=function(){return ee.ownerApi(this)},t.prototype.methodId=function(){return ee.methodId(this)},t.prototype.allSecuredBy=function(){return ee.allSecuredBy(this)},t.prototype.parametrizedProperties=function(){return ee.getTemplateParametrizedProperties(this)},t.prototype.scalarsAnnotations=function(){return new _t(this.highLevel())},t}(it);t.MethodImpl=At;var Et=function(){function e(e){this.node=e}return e.prototype.protocols=function(){var e=this.node.attributes("protocols");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},e.prototype.is=function(){var e=this.node.attributes("is");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},e.prototype.securedBy=function(){var e=this.node.attributes("securedBy");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},e.prototype.description=function(){var e=this.node.attr("description");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.displayName=function(){var e=this.node.attr("displayName");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e}();t.MethodBaseScalarsAnnotationsImpl=Et;var _t=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.displayName=function(){var e=this.node.attr("displayName");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t}(Et);t.MethodScalarsAnnotationsImpl=_t;var Tt=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?o(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.name=function(){return e.prototype.attribute.call(this,"name",this.toString)},t.prototype.setName=function(e){return this.highLevel().attrOrCreate("name").setValue(""+e),this},t.prototype.usage=function(){return e.prototype.attribute.call(this,"usage",this.toString)},t.prototype.setUsage=function(e){return this.highLevel().attrOrCreate("usage").setValue(""+e),this},t.prototype.displayName=function(){return e.prototype.attribute.call(this,"displayName",this.toString)},t.prototype.setDisplayName=function(e){return this.highLevel().attrOrCreate("displayName").setValue(""+e),this},t.prototype.uses=function(){return e.prototype.elements.call(this,"uses")},t.prototype.wrapperClassName=function(){return"TraitImpl"},t.prototype.kind=function(){return"Trait"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("Trait")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.TraitImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.TraitImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.parametrizedProperties=function(){return ee.getTemplateParametrizedProperties(this)},t.prototype.scalarsAnnotations=function(){return new Nt(this.highLevel())},t}(it);t.TraitImpl=Tt;var Nt=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.usage=function(){var e=this.node.attr("usage");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype.displayName=function(){var e=this.node.attr("displayName");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t}(Et);t.TraitScalarsAnnotationsImpl=Nt;var St=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"ResourceTypeRefImpl"},t.prototype.kind=function(){return"ResourceTypeRef"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("ResourceTypeRef")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.ResourceTypeRefImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.ResourceTypeRefImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.resourceType=function(){return ee.referencedResourceType(this)},t}(Se);t.ResourceTypeRefImpl=St;var bt=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?F(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.methods=function(){return e.prototype.elements.call(this,"methods")},t.prototype.is=function(){return e.prototype.attributes.call(this,"is",function(e){return new be(e)})},t.prototype.type=function(){return e.prototype.attribute.call(this,"type",function(e){return new St(e)})},t.prototype.description=function(){return e.prototype.attribute.call(this,"description",function(e){return new pe(e)})},t.prototype.securedBy=function(){return e.prototype.attributes.call(this,"securedBy",function(e){return new at(e)})},t.prototype.uriParameters_original=function(){return e.prototype.elements.call(this,"uriParameters")},t.prototype.wrapperClassName=function(){return"ResourceBaseImpl"},t.prototype.kind=function(){return"ResourceBase"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("ResourceBase")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.ResourceBaseImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.ResourceBaseImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.uriParameters=function(){return ee.uriParametersPrimary(this)},t.prototype.allUriParameters=function(){return ee.uriParameters(this)},t.prototype.allSecuredBy=function(){return ee.allSecuredBy(this)},t.prototype.scalarsAnnotations=function(){return new Rt(this.highLevel())},t}(te);t.ResourceBaseImpl=bt;var It=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?B(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.relativeUri=function(){return e.prototype.attribute.call(this,"relativeUri",function(e){return new ae(e)})},t.prototype.displayName=function(){return e.prototype.attribute.call(this,"displayName",this.toString)},t.prototype.setDisplayName=function(e){return this.highLevel().attrOrCreate("displayName").setValue(""+e),this},t.prototype.resources=function(){return e.prototype.elements.call(this,"resources")},t.prototype.description=function(){return e.prototype.attribute.call(this,"description",function(e){return new pe(e)})},t.prototype.annotations=function(){return e.prototype.attributes.call(this,"annotations",function(e){return new Lt(e)})},t.prototype.wrapperClassName=function(){return"ResourceImpl"},t.prototype.kind=function(){return"Resource"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("Resource")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.ResourceImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.ResourceImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.completeRelativeUri=function(){return ee.completeRelativeUri(this)},t.prototype.absoluteUri=function(){return ee.absoluteUri(this)},t.prototype.parentResource=function(){return ee.parent(this)},t.prototype.childResource=function(e){return ee.childResource(this,e)},t.prototype.childMethod=function(e){return ee.childMethod(this,e)},t.prototype.ownerApi=function(){return ee.ownerApi(this)},t.prototype.absoluteUriParameters=function(){return ee.absoluteUriParameters(this)},t.prototype.scalarsAnnotations=function(){return new Mt(this.highLevel())},t}(bt);t.ResourceImpl=It;var Rt=function(){function e(e){this.node=e}return e.prototype.is=function(){var e=this.node.attributes("is");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},e.prototype.type=function(){var e=this.node.attr("type");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.description=function(){var e=this.node.attr("description");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.securedBy=function(){var e=this.node.attributes("securedBy");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},e}();t.ResourceBaseScalarsAnnotationsImpl=Rt;var Mt=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.displayName=function(){var e=this.node.attr("displayName");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype.description=function(){var e=this.node.attr("description");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t}(Rt);t.ResourceScalarsAnnotationsImpl=Mt;var wt=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?k(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.displayName=function(){return e.prototype.attribute.call(this,"displayName",this.toString)},t.prototype.setDisplayName=function(e){return this.highLevel().attrOrCreate("displayName").setValue(""+e),this},t.prototype.name=function(){return e.prototype.attribute.call(this,"name",this.toString)},t.prototype.setName=function(e){return this.highLevel().attrOrCreate("name").setValue(""+e),this},t.prototype.usage=function(){return e.prototype.attribute.call(this,"usage",this.toString)},t.prototype.setUsage=function(e){return this.highLevel().attrOrCreate("usage").setValue(""+e),this},t.prototype.uses=function(){return e.prototype.elements.call(this,"uses")},t.prototype.wrapperClassName=function(){return"ResourceTypeImpl"},t.prototype.kind=function(){return"ResourceType"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("ResourceType")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.ResourceTypeImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.ResourceTypeImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.parametrizedProperties=function(){return ee.getTemplateParametrizedProperties(this)},t.prototype.scalarsAnnotations=function(){return new Ct(this.highLevel())},t}(bt);t.ResourceTypeImpl=wt;var Ct=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.displayName=function(){var e=this.node.attr("displayName");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype.usage=function(){var e=this.node.attr("usage");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t}(Rt);t.ResourceTypeScalarsAnnotationsImpl=Ct;var Lt=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.wrapperClassName=function(){return"AnnotationRefImpl"},t.prototype.kind=function(){return"AnnotationRef"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("AnnotationRef")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.AnnotationRefImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.AnnotationRefImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.annotation=function(){return ee.referencedAnnotation(this)},t}(Se);t.AnnotationRefImpl=Lt;var Pt=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?V(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.title=function(){return e.prototype.attribute.call(this,"title",this.toString)},t.prototype.setTitle=function(e){return this.highLevel().attrOrCreate("title").setValue(""+e),this},t.prototype.content=function(){return e.prototype.attribute.call(this,"content",function(e){return new pe(e)})},t.prototype.uses=function(){return e.prototype.elements.call(this,"uses")},t.prototype.wrapperClassName=function(){return"DocumentationItemImpl"},t.prototype.kind=function(){return"DocumentationItem"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("DocumentationItem")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.DocumentationItemImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.DocumentationItemImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.scalarsAnnotations=function(){return new Ot(this.highLevel())},t}(te);t.DocumentationItemImpl=Pt;var Ot=function(){function e(e){this.node=e}return e.prototype.title=function(){var e=this.node.attr("title");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.content=function(){var e=this.node.attr("content");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e}();t.DocumentationItemScalarsAnnotationsImpl=Ot;var Dt=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?a(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.uses=function(){return e.prototype.elements.call(this,"uses")},t.prototype.wrapperClassName=function(){return"FragmentDeclarationImpl"},t.prototype.kind=function(){return"FragmentDeclaration"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("FragmentDeclaration")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.FragmentDeclarationImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.FragmentDeclarationImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t}(te);t.FragmentDeclarationImpl=Dt;var Ut=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?i(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.schemas=function(){return e.prototype.elements.call(this,"schemas")},t.prototype.types=function(){return e.prototype.elements.call(this,"types")},t.prototype.traits_original=function(){return e.prototype.elements.call(this,"traits")},t.prototype.resourceTypes_original=function(){return e.prototype.elements.call(this,"resourceTypes")},t.prototype.annotationTypes=function(){return e.prototype.elements.call(this,"annotationTypes")},t.prototype.securitySchemes=function(){return e.prototype.elements.call(this,"securitySchemes")},t.prototype.wrapperClassName=function(){return"LibraryBaseImpl"},t.prototype.kind=function(){return"LibraryBase"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("LibraryBase")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.LibraryBaseImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.LibraryBaseImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.traits=function(){return ee.traitsPrimary(this)},t.prototype.allTraits=function(){return ee.allTraits(this)},t.prototype.resourceTypes=function(){return ee.resourceTypesPrimary(this)},t.prototype.allResourceTypes=function(){return ee.allResourceTypes(this)},t}(Dt);t.LibraryBaseImpl=Ut;var xt=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?K(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.usage=function(){return e.prototype.attribute.call(this,"usage",this.toString)},t.prototype.setUsage=function(e){return this.highLevel().attrOrCreate("usage").setValue(""+e),this},t.prototype.name=function(){return e.prototype.attribute.call(this,"name",this.toString)},t.prototype.setName=function(e){return this.highLevel().attrOrCreate("name").setValue(""+e),this},t.prototype.wrapperClassName=function(){return"LibraryImpl"},t.prototype.kind=function(){return"Library"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("Library")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.LibraryImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.LibraryImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.expand=function(){return ee.expandLibrarySpec(this)},t.prototype.scalarsAnnotations=function(){return new kt(this.highLevel())},t}(Ut);t.LibraryImpl=xt;var kt=function(){function e(e){this.node=e}return e.prototype.usage=function(){var e=this.node.attr("usage");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e}();t.LibraryScalarsAnnotationsImpl=kt;var Ft=function(e){function t(t,n){void 0===n&&(n=!0);var i=e.call(this,"string"==typeof t?r(t):t,n)||this;return i.nodeOrKey=t,i.setAsTopLevel=n,i}return z(t,e),t.prototype.title=function(){return e.prototype.attribute.call(this,"title",this.toString)},t.prototype.setTitle=function(e){return this.highLevel().attrOrCreate("title").setValue(""+e),this},t.prototype.description=function(){return e.prototype.attribute.call(this,"description",function(e){return new pe(e)})},t.prototype.version=function(){return e.prototype.attribute.call(this,"version",this.toString)},t.prototype.setVersion=function(e){return this.highLevel().attrOrCreate("version").setValue(""+e),this},t.prototype.baseUri=function(){return e.prototype.attribute.call(this,"baseUri",function(e){return new oe(e)})},t.prototype.baseUriParameters_original=function(){return e.prototype.elements.call(this,"baseUriParameters")},t.prototype.protocols=function(){return e.prototype.attributes.call(this,"protocols",this.toString)},t.prototype.setProtocols=function(e){return this.highLevel().attrOrCreate("protocols").setValue(""+e),this},t.prototype.mediaType=function(){return e.prototype.attributes.call(this,"mediaType",function(e){return new fe(e)})},t.prototype.securedBy=function(){return e.prototype.attributes.call(this,"securedBy",function(e){return new at(e)})},t.prototype.resources=function(){return e.prototype.elements.call(this,"resources")},t.prototype.documentation=function(){return e.prototype.elements.call(this,"documentation")},t.prototype.annotations=function(){return e.prototype.attributes.call(this,"annotations",function(e){return new Lt(e)})},t.prototype.wrapperClassName=function(){return"ApiImpl"},t.prototype.kind=function(){return"Api"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("Api")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.ApiImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.ApiImpl"==r)return!0}return!1},t.prototype.RAMLVersion_original=function(){return"RAML10"},t.prototype.expand=function(e){
return void 0===e&&(e=!1),ee.expandSpec(this,e)},t.prototype.childResource=function(e){return ee.childResource(this,e)},t.prototype.allResources=function(){return ee.allResources(this)},t.prototype.baseUriParameters=function(){return ee.baseUriParametersPrimary(this)},t.prototype.allBaseUriParameters=function(){return ee.baseUriParameters(this)},t.prototype.allProtocols=function(){return ee.allProtocols(this)},t.prototype.RAMLVersion=function(){return ee.RAMLVersion(this)},t.prototype.scalarsAnnotations=function(){return new Vt(this.highLevel())},t}(Ut);t.ApiImpl=Ft;var Bt=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?j(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.usage=function(){return e.prototype.attribute.call(this,"usage",this.toString)},t.prototype.setUsage=function(e){return this.highLevel().attrOrCreate("usage").setValue(""+e),this},t.prototype["extends"]=function(){return e.prototype.attribute.call(this,"extends",this.toString)},t.prototype.setExtends=function(e){return this.highLevel().attrOrCreate("extends").setValue(""+e),this},t.prototype.title=function(){return e.prototype.attribute.call(this,"title",this.toString)},t.prototype.setTitle=function(e){return this.highLevel().attrOrCreate("title").setValue(""+e),this},t.prototype.wrapperClassName=function(){return"OverlayImpl"},t.prototype.kind=function(){return"Overlay"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("Overlay")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.OverlayImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.OverlayImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.scalarsAnnotations=function(){return new Kt(this.highLevel())},t}(Ft);t.OverlayImpl=Bt;var Vt=function(){function e(e){this.node=e}return e.prototype.title=function(){var e=this.node.attr("title");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.description=function(){var e=this.node.attr("description");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.version=function(){var e=this.node.attr("version");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.baseUri=function(){var e=this.node.attr("baseUri");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},e.prototype.protocols=function(){var e=this.node.attributes("protocols");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},e.prototype.mediaType=function(){var e=this.node.attributes("mediaType");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},e.prototype.securedBy=function(){var e=this.node.attributes("securedBy");return e.map(function(e){var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n})},e}();t.ApiScalarsAnnotationsImpl=Vt;var Kt=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.usage=function(){var e=this.node.attr("usage");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype["extends"]=function(){var e=this.node.attr("extends");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype.title=function(){var e=this.node.attr("title");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t}(Vt);t.OverlayScalarsAnnotationsImpl=Kt;var jt=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,"string"==typeof t?W(t):t,n)||this;return r.nodeOrKey=t,r.setAsTopLevel=n,r}return z(t,e),t.prototype.usage=function(){return e.prototype.attribute.call(this,"usage",this.toString)},t.prototype.setUsage=function(e){return this.highLevel().attrOrCreate("usage").setValue(""+e),this},t.prototype["extends"]=function(){return e.prototype.attribute.call(this,"extends",this.toString)},t.prototype.setExtends=function(e){return this.highLevel().attrOrCreate("extends").setValue(""+e),this},t.prototype.title=function(){return e.prototype.attribute.call(this,"title",this.toString)},t.prototype.setTitle=function(e){return this.highLevel().attrOrCreate("title").setValue(""+e),this},t.prototype.wrapperClassName=function(){return"ExtensionImpl"},t.prototype.kind=function(){return"Extension"},t.prototype.allKinds=function(){return e.prototype.allKinds.call(this).concat("Extension")},t.prototype.allWrapperClassNames=function(){return e.prototype.allWrapperClassNames.call(this).concat("RAML10.ExtensionImpl")},t.isInstance=function(e){if(null!=e&&e.allWrapperClassNames&&"function"==typeof e.allWrapperClassNames)for(var t=0,n=e.allWrapperClassNames();t<n.length;t++){var r=n[t];if("RAML10.ExtensionImpl"==r)return!0}return!1},t.prototype.RAMLVersion=function(){return"RAML10"},t.prototype.scalarsAnnotations=function(){return new Wt(this.highLevel())},t}(Ft);t.ExtensionImpl=jt;var Wt=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return z(t,e),t.prototype.usage=function(){var e=this.node.attr("usage");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype["extends"]=function(){var e=this.node.attr("extends");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t.prototype.title=function(){var e=this.node.attr("title");if(null==e)return[];var t=e.annotations(),n=Q.attributesToValues(t,function(e){return new Lt(e)});return n},t}(Vt);t.ExtensionScalarsAnnotationsImpl=Wt,t.loadApiSync=H,t.loadRAMLSync=Y,t.loadApi=q,t.loadRAML=G,t.getLanguageElementByRuntimeType=X},function(e,t,n){"use strict";function r(e,t,n){var r=e.definition().property(t);if(!r)return null;var i=r.range(),a=h(i,r,n);return a}function i(e,t,n,r){var i=y.newMap(n.map(function(e){return y.newMapping(y.newScalar(e.key),y.newScalar(e.value))})),a=new d.ASTNode(i,r?r.lowLevel().unit():null,r?r.lowLevel():null,null,null);return new m.StructuredValue(a,r,r?r.definition().property(e):null,t)}function a(e,t,n){var r=e.definition().property(t);if(!r)return null;var i=r.range(),a=e.lowLevel().unit().stub(),o=h(i,r,n,a);return o.isInEdit=!0,o.lowLevel()._unit=a,o._parent=e.copy(),o._parent.lowLevel()._unit=a,o}function o(e,t){return a(e,"resources",t)}function s(e,t){return a(e,"methods",t)}function u(e,t){return a(e,"responses",t)}function l(e,t){return a(e,"body",t)}function p(e,t){return a(e,"uriParameters",t)}function c(e,t){return a(e,"queryParameters",t)}function f(e,t){var n=d.createMapping(e.nameId(),t),r=new m.ASTPropImpl(n,null,e.range(),e);return r}function h(e,t,n,r){void 0===n&&(n=null);var i=d.createNode(n?n:"key",null,r),a=new m.ASTNodeImpl(i,null,e,t);return i.unit()||(i._unit=r),a.children(),a}Object.defineProperty(t,"__esModule",{value:!0});var d=n(4),m=n(55),y=n(21);t.createStub0=r,t.genStructuredValue=i,t.createStub=a,t.createResourceStub=o,t.createMethodStub=s,t.createResponseStub=u,t.createBodyStub=l,t.createUriParameterStub=p,t.createQueryParameterStub=c,t.createAttr=f,t.createStubNode=h},function(e,t,n){"use strict";function r(){return new Y}function i(e){if(null==e)return null;switch(e.kind){case I.Kind.SCALAR:return{errors:[],startPosition:e.startPosition,endPosition:e.endPosition,value:e.value,kind:I.Kind.SCALAR,parent:e.parent};case I.Kind.MAPPING:var t=e;return{errors:[],key:i(t.key),value:i(t.value),startPosition:t.startPosition,endPosition:t.endPosition,kind:I.Kind.MAPPING,parent:t.parent};case I.Kind.MAP:var n=e;return{errors:[],startPosition:e.startPosition,endPosition:e.endPosition,mappings:n.mappings.map(function(e){return i(e)}),kind:I.Kind.MAP,parent:n.parent}}return e}function a(e){var t=e.match(/^.*((\r\n|\n|\r)|$)/gm);return t}function o(e,t){for(var n=a(e),r=[],i=0;i<n.length;i++)0==i?r.push(n[0]):r.push(n[i].substring(t.length));return r.join("")}function s(e){for(var t="",n=0;n<e.length;n++){var r=e[n];if("\r"!=r&&"\n"!=r){if(" "!=r&&"	"!=r)break;t+=r}}return t}function u(e,t){var n=e.substr(t.offset,t.replacementLength);return-1!=n.indexOf("\n")||-1!=t.text.indexOf("\n")||void 0}function l(e){if("null"==e)e=null;else if("~"==e)e=null;else if("true"==e)e=!0;else if("false"==e)e=!1;else{var t=parseFloat(e);isNaN(t)||(""+e).match("^[-+]?[0-9]*\\.?[0-9]+$")&&(e=t)}return e}function p(e,t,n){var r=I.newMapping(I.newScalar(e),I.newMap());return new Q(r,n,t,null,null)}function c(e){var t=I.newMap(e);return new Q(t,null,null,null,null)}function f(e){var t=I.newScalar(e);return new Q(t,null,null,null,null)}function h(e,t,n){return new Q(e,n,t,null,null)}function d(e){var t=I.newMapping(I.newScalar(e),I.newItems());return new Q(t,null,null,null,null)}function m(e){var t=I.newMapping(I.newScalar(e),I.newMap());return new Q(t,null,null,null,null)}function y(e,t){var n=I.newMapping(I.newScalar(e),I.newScalar(t));return new Q(n,null,null,null,null)}function v(e){if(!Q.isInstance(e))return null;var t=e,n=new Q(t.yamlNode(),t.unit(),null,null,null,!0);return n._errors=t._errors,n}function g(e){if(!Q.isInstance(e))return null;var t=e,n=new Q(t.yamlNode(),t.unit(),null,null,null,!1);return n._errors=t._errors,n}function A(e){var t=e.highLevelNode();if(t)return t.definition();var n=e.parent();if(!n)return null;var r=e.key();if(!r)return null;var i=n.nodeDefinition();if(!i)return null;if(!i.property)return null;var a=i.property(r);return a?a.range():null}function E(e,t,n,r){if(e.isOverlayOrExtension()){var i=e.getMasterReferenceNode();if(i){var a=i.value();if(a){var o=N.dirname(e.absolutePath()),s=T.toAbsolutePath(o,a);if(!t[s]){if(n[s])return void i.errors().push(new V(n[a]));var u=r[s];u||(u=[],r[s]=u),u.push(i)}}}}}function _(e,t){var n={},r={},i=[],a=function(t){for(var o=[],s={};t<i.length;){var u=i[t],l=u.absolutePath();E(u,n,r,s);var p=u.getIncludeNodes();p.forEach(function(t){var i=t.includePath();if(i){var a=O.getIncludeReference(i);if(a)return void o.push(e.resolveAsync(u.absolutePath(),i));if(i){var p=T.buildPath(i,l,e.getRootPath());if(!n[p]){if(r[p]&&t.errors)return void t.errors().push(new V(r[i]));var c=s[p];c||(c=[],s[p]=c),c.push(t)}}}}),t++}var c=Object.keys(s);if(0==o.length&&0==c.length)return Promise.resolve();var f=o;return c.forEach(function(t){f.push(e.unitAsync(t,!0).then(function(e){n[e.absolutePath()]||(n[e.absolutePath()]=!0,i.push(e))},function(n){var i=e.pathToUnit[t];s[t].forEach(function(e){i||e.errors&&e.errors().push(new V(n))}),r[t]=n,e.failedUnits[t]=n,i&&(n.inner=!0)}))}),Promise.all(f).then(function(e){return a(t)})};return e.unitAsync(t,N.isAbsolute(t)).then(function(e){return i.push(e),n[e.absolutePath()]=!0,a(0)}).then(function(e){return i.length>0?i[0]:null})}Object.defineProperty(t,"__esModule",{value:!0});var T=n(5),N=n(6),S=n(8),b=n(307),I=n(21),R=n(16),M=n(287),w=n(55),C=n(308),L=n(229),P=n(15),O=n(309),D=n(313),U=n(202),x=n(276),k=n(205),F=n(19),B=n(269),V=I.YAMLException;t.Kind={SCALAR:I.Kind.SCALAR};var K=function(){function e(e){this.text="",this.indent=e}return e.prototype.isLastNL=function(){return this.text.length>0&&"\n"==this.text[this.text.length-1]},e.prototype.addWithIndent=function(e,t){this.isLastNL()&&(this.text+=M.indent(e),this.text+=this.indent),this.text+=t},e.prototype.addChar=function(e){this.isLastNL()&&(this.text+=this.indent),this.text+=e},e.prototype.append=function(e){for(var t=0;t<e.length;t++)this.addChar(e[t])},e}();t.MarkupIndentingBuffer=K;var j=function(){function e(e,t,n,r,i){this._path=e,this._content=t,this._tl=n,this._project=r,this._apath=i,this._includedByPaths=[],this._path=null!=this._path?this._path.replace(/\\/g,"/"):null}return e.isInstance=function(t){return null!=t&&t.getClassIdentifier&&"function"==typeof t.getClassIdentifier&&R.contains(t.getClassIdentifier(),e.CLASS_IDENTIFIER)},e.prototype.getClassIdentifier=function(){var t=[];return t.concat(e.CLASS_IDENTIFIER)},e.prototype.highLevel=function(){return this._hl?this._hl:(this._hl=w.fromUnit(this),this._hl)},e.prototype.isStubUnit=function(){return this.stu},e.prototype.resolveAsync=function(e){var t=this._project.resolveAsync(this._path,e);return t},e.prototype.getIncludeNodes=function(){var e=this.ast(),t=[];return null==e?[]:(e.gatherIncludes(t),e.children().forEach(function(e){"uses"==e.key()&&e.children().forEach(function(e){t.push({includePath:function(){var t=e.value();return"string"!=typeof t?null:t}})})}),t)},e.prototype.cloneToProject=function(t){var n=new e(this._path,this._content,this._tl,t,this._apath);return n},e.prototype.clone=function(){var t=new e(this._path,this._content,this._tl,this.project(),this._apath);return t},e.prototype.stub=function(){var t=new e(this._path,this._content,this._tl,this.project(),this._apath);return t.stu=!0,t},e.prototype.isDirty=function(){return!1},e.prototype.expandedHighLevel=function(){if(this.expanded)return this.expanded;var e=this.highLevel().asElement(),t=x.expandTraitsAndResourceTypes(e.wrapperNode()),n=t.highLevel();return n._expanded=!0,this.expanded=n,n},e.prototype.absolutePath=function(){return this._apath},e.prototype.isRAMLUnit=function(){var e=this.absolutePath();if(T.isWebPath(e))try{e=S.parse(e).pathname}catch(t){e=this._path}var t=N.extname(e);if(".raml"==t||".yaml"==t||".yml"==t)return!0;if(!t){if(!this._content)return!1;var n=this._content.trim();if(P.stringStartsWith(n,"#%RAML"))return!0;for(var r=n.split("\n"),i=void 0,a=0,o=r;a<o.length;a++){var s=o[a],u=s.trim();if(u&&!P.stringStartsWith(u,"#")){i=s;break}}if(!i)return!0;try{var l=I.load(i,{ignoreDuplicateKeys:!0});return l.kind!=I.Kind.SCALAR}catch(e){return!1}}return!1},e.prototype.contents=function(){return this._content},e.prototype.resolve=function(e){if("string"!=typeof e)return null;var t=this._project.resolve(this._path,e);return t},e.prototype.path=function(){return this._path},e.prototype.lexerErrors=function(){return null==this.errors&&this.ast(),this.errors},e.prototype.ast=function(){var e=this;if(this._node)return this._node;try{var t=I.load(this._content,{ignoreDuplicateKeys:!0});return this.errors=t.errors,this.errors.forEach(function(t){t.mark&&(t.mark.filePath=e.absolutePath())}),this._node=new Q(t,this,null,null,null),this._node._errors=this.errors,this._node}catch(e){return this.errors=[],this.errors.push(new V(e.message)),this._node=null,this._node}},e.prototype.isTopLevel=function(){return this._tl},e.prototype.updateContent=function(e){this._content=e,this.errors=null,this._node=null,this._lineMapper=null},e.prototype.updateContentSafe=function(e){this._content=e,this._lineMapper=null,this._hl=null},e.prototype.project=function(){return this._project},e.prototype.lineMapper=function(){return null==this._lineMapper&&(this._lineMapper=new T.LineMapperImpl(this.contents(),this.absolutePath())),this._lineMapper},e.prototype.isOverlayOrExtension=function(){for(var e=this.contents(),t="",n=null,r=0,i=0,a=0;a<e.length;a++){var o=e.charAt(a);if("\r"==o||"\n"==o){t?n=e.substring(i,a).trim():t=e.substring(0,a).trim();break}" "==o&&(r++,t||2!=r||(t=e.substring(0,a),i=a))}return"Extension"==n||"Overlay"==n},e.prototype.getMasterReferenceNode=function(){return R.find(this.ast().children(),function(e){return e.key()==U.Universe10.Overlay.properties["extends"].name})},e.prototype.addIncludedBy=function(e){this.includedByContains(e)||this._includedByPaths.push(e)},e.prototype.includedByContains=function(e){return null!=R.find(this._includedByPaths,function(t){return t==e})},e.prototype.getIncludedByPaths=function(){return this._includedByPaths},e.CLASS_IDENTIFIER="jsyaml2lowLevel.CompilationUnit",e}();t.CompilationUnit=j;var W=n(314).XMLHttpRequest,H=n(314).XMLHttpRequest,Y=function(){function e(){}return e.prototype.open=function(e,t,n){this.xhr=n?new H:new W,this.async=n,this.xhr.open(e,t,n)},e.prototype.setRequestHeader=function(e,t){this.xhr.setRequestHeader(e,t)},e.prototype.getResponseHeader=function(e){return this.xhr.getResponseHeader(e)},e.prototype.getAllResponseHeaders=function(){return this.xhr.getAllResponseHeaders()},e.prototype.send=function(e){var t=this;this.xhr.onload=function(){return t.onResponse(!1)},this.xhr.onerror=function(){return t.onResponse(!0)},this.xhr.send(e)},e.prototype.onResponse=function(e){return this.statusText=this.xhr.statusText,this.responseText=this.xhr.responseText,this.responseType=this.xhr.responseType,this.status=this.xhr.status,e&&this.onerror?void this.onerror():void(this.onload&&this.onload())},e}();t.XMLHttpRequestWrapper=Y,t.buildXHR=r;var q=function(){function e(){}return e.prototype.execute=function(e,t){void 0===t&&(t=!0);var n=r(),i=e.url;t&&(i=this.appendParams(e,e.url)),n.open(e.method,i,!1),this.doRequest(e,n);var a=n.status;if(a>300&&400>a){var o=n.getResponseHeader("location");if(o)return e.url=o,this.execute(e,!1)}var s={status:a,statusText:n.statusText,headers:n.getAllResponseHeaders().split("\n").map(function(e){var t=e.indexOf(":");return{name:e.substring(0,t).trim(),value:e.substring(t+1).trim()}}),content:{text:n.responseText,mimeType:n.responseType}};return s},e.prototype.appendParams=function(e,t){var n=e.queryString&&e.queryString.length>0;if(n){t+="?";var r=[];n&&(r=r.concat(e.queryString.map(function(e){return encodeURIComponent(e.name)+"="+encodeURIComponent(e.value)}))),t+=r.join("&")}return t},e.prototype.log=function(e,t){},e.prototype.executeAsync=function(e,t){void 0===t&&(t=!0);var n=r(),i=e.url;t&&(i=this.appendParams(e,e.url));var a=this;return new Promise(function(t,r){n.open(e.method,i,!0),n.onload=function(){var e=n.status,r={status:e,statusText:n.statusText,headers:n.getAllResponseHeaders().split("\n").map(function(e){var t=e.indexOf(":");return{name:e.substring(0,t).trim(),value:e.substring(t+1).trim()}}),content:{text:n.responseText,mimeType:n.responseType}};t(r)},n.onerror=function(){r(new V(B.NETWORK_ERROR.message))},a.doRequest(e,n)})},e.prototype.doRequest=function(e,t){if(e.headers&&e.headers.forEach(function(e){return t.setRequestHeader(e.name,e.value)}),e.postData)if(e.postData.params){var n=e.postData.params.map(function(e){return encodeURIComponent(e.name)+"="+encodeURIComponent(e.value)}).join("&");t.send(n)}else t.send(e.postData.text);else t.send()},e}();t.SimpleExecutor=q;var G=function(){function e(){this.executor=new q}return e.prototype.getResource=function(e){if("undefined"!=typeof atom&&null!=atom){var t=L.get(e);if(t)return t;L.addNotify(e);try{var n={content:""};return this.getResourceAsync(e).then(function(t){try{t.errorMessage?L.set(e,{content:null,errorMessage:null}):(t.errorMessage=null,L.set(e,t))}finally{n.callback&&n.callback(L.get(e)),L.removeNotity(e)}},function(t){L.set(e,{content:null,errorMessage:null}),n.callback&&n.callback(L.get(e)),L.removeNotity(e)}),n}catch(e){console.log("Error"),console.log(e)}}var r=this.executor.execute({method:"get",url:e});if(!r)throw new V(F.applyTemplate(B.UNABLE_TO_EXECUTE_GET,{url:e}));var i=this.toResponse(r,e);return i},e.prototype.getResourceAsync=function(e){var t=this;return this.executor.executeAsync({method:"get",url:e}).then(function(n){if(!n)return Promise.reject(new V(F.applyTemplate(B.UNABLE_TO_EXECUTE_GET,{url:e})));var r=t.toResponse(n,e);return r},function(t){return Promise.reject(F.applyTemplate(B.UNABLE_TO_EXECUTE_GET,{url:e}))})},e.prototype.toResponse=function(e,t){var n=null;e.status>=400&&(n="GET "+t+"\nreturned error: "+e.status,e.statusText&&(n+=" "+e.statusText));var r=null;e.content&&e.content.text&&(r=e.content.text);var i={content:r,errorMessage:n};return i},e}();t.HTTPResolverImpl=G;var X=function(){function e(){}return e.prototype.content=function(e){if("string"!=typeof e&&(e=""+e),!b.existsSync(e))return null;try{return b.readFileSync(e).toString()}catch(e){return null}},e.prototype.list=function(e){return b.readdirSync(e)},e.prototype.contentAsync=function(e){return new Promise(function(t,n){b.readFile(e,function(e,r){if(null!=e)return n(e);var i=r.toString();t(i)})})},e.prototype.listAsync=function(e){return new Promise(function(t,n){b.readdir(e,function(e,t){return null!=e?Promise.reject(e):void n(t)})})},e}();t.FSResolverImpl=X;var z=function(e,t,n){if(t&&(t.startPosition>=e&&(t.startPosition+=n),t.endPosition>e&&(t.endPosition+=n),t.kind==I.Kind.MAPPING)){var r=t;z(e,r.key,n),z(e,r.value,n)}},$=function(e,t){for(var n="",r=e.start()-1;r>0;){var i=t[r];if(" "!=i&&"-"!=i)break;n=" "+n,r--}return n},J=function(){function e(e,t,n){this.rootPath=e,this.resolver=t,this._httpResolver=n,this.listeners=[],this.tlisteners=[],this.pathToUnit={},this.failedUnits={},this._fsEnabled=!0,this._namespaceResolver=new k.NamespaceResolver,null==this.resolver?this.resolver=new X:this._fsEnabled=!1,null==this._httpResolver&&(this._httpResolver=new G)}return e.prototype.getMainUnit=function(){return this.mainUnitPath?this.unit(this.mainUnitPath,!0):null},e.prototype.getRootPath=function(){return this.rootPath},e.prototype.getMainUnitPath=function(){return this.mainUnitPath},e.prototype.setMainUnitPath=function(e){this.mainUnitPath=e},e.prototype.setFSResolver=function(e){this.resolver=e},e.prototype.setHTTPResolver=function(e){this._httpResolver=e},e.prototype.fsEnabled=function(){return this._fsEnabled},e.prototype.cloneWithResolver=function(t,n){void 0===n&&(n=null);var r=new e(this.rootPath,t,n?n:this._httpResolver);for(var i in this.pathToUnit)r.pathToUnit[i]=this.pathToUnit[i].cloneToProject(r);return r},e.prototype.setCachedUnitContent=function(e,t,n){void 0===n&&(n=!0);var r=e,i=T.toAbsolutePath(this.rootPath,e),a=new j(r,t,n,this,i);return this.pathToUnit[i]=a,a},e.prototype.resolveAsync=function(e,t){var n=this;if(!t)return Promise.reject(new V(B.UNIT_PATH_IS_NULL.message));var r=O.getIncludeReference(t),i=t;r&&(t=r.getIncludePath());var a=T.buildPath(t,e,this.rootPath);if(r){var o,s=T.toAbsolutePath(N.dirname(T.toAbsolutePath(this.rootPath,e)),r.encodedName());this.pathToUnit[a]?Promise.resolve(o).then(function(e){return n.pathToUnit[s]=new j(r.encodedName(),O.resolveContents(i,n.pathToUnit[a].contents()),!1,n,s),n.pathToUnit[s]}):this.unitAsync(a,!0).then(function(e){return n.pathToUnit[a]=e,n.pathToUnit[s]=new j(r.encodedName(),O.resolveContents(i,n.pathToUnit[a].contents()),!1,n,s),n.pathToUnit[s]})}return this.unitAsync(a,!0)},e.prototype.resolve=function(e,t){if(!t)return null;t=t.replace(/\\/g,"/");var n=O.getIncludeReference(t),r=t;n&&(t=n.getIncludePath());var i=T.buildPath(t,e,this.rootPath);if(n){this.pathToUnit[i]||(this.pathToUnit[i]=this.unit(i,!0));var a=this.pathToUnit[i],o=T.toAbsolutePath(N.dirname(T.toAbsolutePath(this.rootPath,e)),n.encodedName());return this.pathToUnit[o]?this.pathToUnit[o]:(this.pathToUnit[o]=new j(n.encodedName(),O.resolveContents(r,a&&a.contents()),!1,this,o),this.pathToUnit[o])}return this.unit(i,!0)},e.prototype.units=function(){var e=this;if(!this.resolver.list)throw new V(B.FSRESOLVER_IS_UNABLE_USE_EXTENDEDFSRESOLVER.message);var t=this.resolver.list(this.rootPath).filter(function(e){return".raml"==N.extname(e)});return t.map(function(t){return e.unit(t)}).filter(function(e){return e.isTopLevel()})},e.prototype.unitsAsync=function(){var e=this;return this.resolver.listAsync?this.resolver.listAsync(this.rootPath).then(function(t){var n=t.filter(function(e){return".raml"==N.extname(e)}).map(function(t){return e.unitAsync(t).then(function(e){return e.isTopLevel()?e:null},function(e){return null})});return Promise.all(n).then(function(e){return e.filter(function(e){return null!=e})})}):Promise.reject(new V(B.FSRESOLVER_IS_UNABLE_USE_EXTENDEDFSRESOLVER.message))},e.prototype.lexerErrors=function(){var e=[];return this.units().forEach(function(t){e=e.concat(t.lexerErrors())}),e},e.prototype.deleteUnit=function(e,t){void 0===t&&(t=!1);var n=null;n=T.isWebPath(e)?e:t?e:T.toAbsolutePath(this.rootPath,e),delete this.pathToUnit[n]},e.prototype.unit=function(e,t){if(void 0===t&&(t=!1),t||T.isWebPath(e)){if(null!=this.failedUnits[e]&&!this.failedUnits[e].inner)return null}else{var n=T.toAbsolutePath(this.rootPath,e);if(this.failedUnits[n]&&!this.failedUnits[e].inner)return null}var r,i=null,a=e;if(T.isWebPath(e)){if(this.pathToUnit[a])return this.pathToUnit[a];if(this._httpResolver){if(r=this._httpResolver.getResource(e),r&&r.errorMessage)throw new V(r.errorMessage);i=r?r.content:null}else r=(new G).getResource(a),i=r?r.content:null}else{"/"!=e.charAt(0)||t||(e=e.substr(1));var a=T.toAbsolutePath(this.rootPath,e);if(this.pathToUnit[a])return this.pathToUnit[a];if(T.isWebPath(a))if(this._httpResolver){var o=this._httpResolver.getResource(a);if(o&&o.errorMessage)throw new V(o.errorMessage);i=o?o.content:null}else{var s=(new G).getResource(a);i=s?s.content:null}else i=this.resolver.content(a)}if(null==i)return null;var u=P.stringStartsWith(i,"#%RAML"),l=T.isWebPath(this.rootPath)==T.isWebPath(a)?N.relative(this.rootPath,a):a,p=new j(l,i,u,this,a);return this.pathToUnit[a]=p,r&&(r.callback=function(e){p.updateContent(e&&e.content)}),p},e.prototype.unitAsync=function(e,t){var n=this;void 0===t&&(t=!1);var r=null,i=e;if(T.isWebPath(e)){if(this.pathToUnit[i])return Promise.resolve(this.pathToUnit[i]);if(this._httpResolver){var a=this._httpResolver.getResourceAsync(i);r=a.then(function(e){return e.errorMessage?Promise.reject(new V(e.errorMessage)):e.content})}else r=(new G).getResourceAsync(i).then(function(e){return e.errorMessage?Promise.reject(e.errorMessage):e.content})}else{if("/"!=e.charAt(0)||t||(e=e.substr(1)),i=t?e:T.toAbsolutePath(this.rootPath,e),this.pathToUnit[i])return Promise.resolve(this.pathToUnit[i]);if(T.isWebPath(i))if(this._httpResolver){var a=this._httpResolver.getResourceAsync(i);r=a.then(function(e){return e.errorMessage?Promise.reject(new V(e.errorMessage)):e.content})}else r=(new G).getResourceAsync(i).then(function(e){return e.errorMessage?Promise.reject(new V(e.errorMessage)):e.content});else r=this.resolver.contentAsync(i)}if(null==r)return Promise.resolve(null);var o=T.isWebPath(this.rootPath)==T.isWebPath(i)?N.relative(this.rootPath,i):i;return r.then(function(e){if(null==e)return Promise.reject(new V(F.applyTemplate(B.CAN_NOT_RESOLVE,{path:i})));var t=P.stringStartsWith(e,"#%RAML"),r=new j(o,e,t,n,i);return n.pathToUnit[i]=r,r},function(e){return"object"==typeof e&&e instanceof V?Promise.reject(e):Promise.reject(new V(e.toString()))}).then(function(e){return e.isRAMLUnit()?e:D.isScheme(e.contents())?D.startDownloadingReferencesAsync(e.contents(),e):e})},e.prototype.visualizeNewlines=function(e){for(var t="",n=0;n<e.length;n++){var r=e[n];"\r"==r&&(r="\\r"),"\n"==r&&(r="\\n"),t+=r}return t},e.prototype.indent=function(e){var t=e.unit().contents();if(e==e.root())return"";var n=$(e,t),r=a(e.dump());if(r.length>1&&r[1].trim().length>0){var i=s(r[1]);return n+i}return n+"  "},e.prototype.startIndent=function(e){if(e.unit().contents(),e==e.root())return"";var t=a(e.dump());if(t.length>0){console.log("FIRST: "+t[0]);var n=s(t[0]);return n+"  "}return""},e.prototype.canWriteInOneLine=function(e){return!1},e.prototype.isOneLine=function(e){return e.text().indexOf("\n")<0},e.prototype.recalcPositionsUp=function(e){for(var t=e;t;)t.recalcEndPositionFromChilds(),t=t.parent()},e.prototype.add2=function(e,t,n,r,i){void 0===i&&(i=!1);var a=e.unit(),o=(e.root(),null);if(r&&(Q.isInstance(r)&&(o=r),ee.isInstance(r)&&(o=r.point)),e.isValueInclude()){var s=e.children();if(0==s.length)throw new V(B.NOT_IMPLEMENTED_INSERT_INTO_EMPTY_REF.message);var u=s[0].parent();return void this.add2(u,t,n,o,i)}var l=(new M.TextRange(a.contents(),t.start(),t.end()),new M.TextRange(a.contents(),e.start(),e.end()),e.unit().contents());e.valueKind()==I.Kind.SEQ&&(e=h(e.valueAsSeq(),e,e.unit()));var i=this.isJson(e),p=i?"":this.indent(e.isSeq()?e.parent():e),c=p,f=p.length,d=e.isSeq()||e.isMapping()&&(e.isValueSeq()||e.isValueScalar()||!e.asMapping().value);n=n,n&&(i||d&&(c+="  ",f+=2));var m=new K(c);t.markupNode(m,t._actualNode(),0,i);var y=m.text;if(n){var v=M.trimEnd(y),g=y.length-v.length;if(g>0){var A=y.length;y=y.substring(0,A-g),t.shiftNodes(A-g,-g)}}n&&!i?(t.highLevelNode(),e.isMapping(),y=e.isSeq()||e.isMapping()&&(e.isValueSeq()||e.isValueScalar()||!e.asMapping().value)?p+"- "+y:p+y):y=p+y;var E=e.end();if(o)o!=e?E=o.end():i&&n||(E=e.keyEnd()+1,E=new M.TextRange(l,E,E).extendAnyUntilNewLines().endpos());else if(i&&n){var _=e.asSeq();_&&(E=_.items.length>0?_.items[_.items.length-1].endPosition:_.endPosition-1)}else if(r&&ee.isInstance(r)){var T=r;T.type==Z.START&&(E=e.keyEnd()+1,E=new M.TextRange(l,E,E).extendAnyUntilNewLines().endpos())}var N=new M.TextRange(l,0,E);if(E=N.extendToNewlines().reduceSpaces().endpos(),i&&e.isSeq()){var _=e.asSeq();_.items.length>0&&(y=", "+y,f+=2)}else E>0&&"\n"!=l[E-1]&&(y="\n"+y,f++);var S=0;n&&!i&&(y+="\n",S++);var b=l.substring(0,E)+y+l.substring(E,l.length),R=a;if(R.updateContentSafe(b),this.executeReplace(new M.TextRange(l,E,E),y,R),e.root().shiftNodes(E,f+(t.end()-t.start())+S),o){for(var s=e.children(),w=-1,C=0;C<s.length;C++){var L=s[C];if(L.start()==o.start()&&L.end()==o.end()){w=C;break}}w>=0?e.addChild(t,w+1):e.addChild(t)}else e.addChild(t);t.shiftNodes(0,E+f),this.recalcPositionsUp(e),t.setUnit(e.unit()),t.visit(function(t){var n=t;return n.setUnit(e.unit()),!0})},e.prototype.isJsonMap=function(e){if(!e.isMap())return!1;var t=e.text().trim();return t.length>=2&&"{"==t[0]&&"}"==t[t.length-1]},e.prototype.isJsonSeq=function(e){if(!e.isSeq())return!1;var t=e.text().trim();return t.length>=2&&"["==t[0]&&"]"==t[t.length-1]},e.prototype.isJson=function(e){return this.isJsonMap(e)||this.isJsonSeq(e)},e.prototype.remove=function(e,t,n){var r=n.parent();if(n._oldText=n.dump(),this.isOneLine(n)&&n.isMapping()&&n.parent().isMap()){var i=n.parent();if(1==i.asMap().mappings.length&&null!=i.parent())return void this.remove(e,i.parent(),i)}if(this.isOneLine(n)&&n.isScalar()&&n.parent().isSeq()){var a=n.parent(),o=a.asSeq();if(1==o.items.length)return void this.remove(e,a.parent(),a)}if(t.isMapping()&&n.isSeq()){var s=t.parent();return void this.remove(e,s,t)}var u=new M.TextRange(e.contents(),n.start(),n.end()),l=(new M.TextRange(e.contents(),t.start(),t.end()),new M.TextRange(e.contents(),r.start(),r.end()),u.startpos());if(t.isSeq()){var p=n.isSeq()?n:n.parentOfKind(I.Kind.SEQ);u=p&&this.isJson(p)?u.extendSpaces().extendCharIfAny(",").extendSpaces():u.extendToStartOfLine().extendAnyUntilNewLines().extendToNewlines()}t.isMap()&&(u=u.trimEnd().extendAnyUntilNewLines().extendToNewlines(),u=u.extendToStartOfLine().extendUntilNewlinesBack()),t.kind()==I.Kind.MAPPING&&(this.isJson(n)&&this.isOneLine(n)||(u=u.extendSpacesUntilNewLines(),u=u.extendToNewlines(),u=u.extendToStartOfLine().extendUntilNewlinesBack())),n.isSeq()&&(u=u.reduceSpaces());var c=e;c.updateContentSafe(u.remove()),this.executeReplace(u,"",c),n.parent().removeChild(n);var f=-u.len();t.root().shiftNodes(l,f),this.recalcPositionsUp(t)},e.prototype.changeKey=function(e,t,n){var r=new M.TextRange(t.unit().contents(),t.keyStart(),t.keyEnd());if(t.kind()==I.Kind.MAPPING){var i=t._actualNode().key;i.value=n,i.endPosition=i.startPosition+n.length}var a=e;this.executeReplace(r,n,a);var o=n.length-r.len();t.root().shiftNodes(r.startpos(),o,t),this.recalcPositionsUp(t)},e.prototype.executeReplace=function(e,t,n){var r=new T.TextChangeCommand(e.startpos(),e.endpos()-e.startpos(),t,n);n.project();try{this.tlisteners.forEach(function(e){return e(r)})}catch(e){return!1}var i=e.replace(t);return n.updateContentSafe(i),!0},e.prototype.changeValue=function(e,t,n){var r,i=new M.TextRange(t.unit().contents(),t.start(),t.end()),a=0,o=0,s=null,u=null;if(t.kind()==I.Kind.SCALAR){
if("string"!=typeof n)throw new V(B.NOT_IMPLEMENTED.message);t.asScalar().value=n,r=n}else if(t.kind()==I.Kind.MAPPING){if(u=t.asMapping(),t.isValueInclude()){var l=t.valueAsInclude(),p=l.value,f=p,h=t.unit().resolve(f);if(null==h)return void console.log(F.applyTemplate(B.ATTR_SETVALUE_NOT_RESOLVE,{path:f}));if(h.isRAMLUnit())return;return void(O.getIncludeReference(p)||h.updateContent(n))}if(i=u.value?i.withStart(t.valueStart()).withEnd(t.valueEnd()):i.withStart(t.keyEnd()+1).withEnd(t.keyEnd()+1),i=i.reduceNewlinesEnd(),null==n)r="",u.value=null;else if("string"==typeof n||null==n){var d=n,m=this.indent(t);if(d&&M.isMultiLine(d)&&(d=""+M.makeMutiLine(d,m.length/2)),r=d,u.value){if(u.value.kind==I.Kind.SEQ)throw console.log("seq value"),u.value.items[0],"assign value!!!";if(u.value.kind==I.Kind.SCALAR){var y=u.value,v=y.value||"";y.value=d,u.value.endPosition=u.value.startPosition+d.length,u.endPosition=u.value.endPosition,o+=d.length-v.length}}else if(console.log("no value"),u.value=I.newScalar(d),u.value.startPosition=t.keyEnd()+1,u.value.endPosition=u.value.startPosition+d.length,u.endPosition=u.value.endPosition,e.contents().length>t.keyEnd()+1){var g=t.keyEnd()+1;":"==e.contents()[g-1]&&(r=" "+r,u.value.startPosition++,u.value.endPosition++,u.endPosition++,o++)}}else{var A=n;if(A.isMapping())n=c([A.asMapping()]),A=n;else if(!A.isMap())throw new V(B.ONLY_MAP_NODES_ALLOWED.message);var E=new K("");A.markupNode(E,A._actualNode(),0,!0),r=""+E.text,A.shiftNodes(0,i.startpos()+o),s=A}}else console.log(F.applyTemplate(B.UNSUPPORTED_CHANGE_VALUE_CASE,{name:t.kindName()}));var _=e;this.executeReplace(i,r,_);var T=r.length-i.len();t.root().shiftNodes(i.endpos()+a,T,t),s&&(u.value=s._actualNode()),this.recalcPositionsUp(t)},e.prototype.initWithRoot=function(e,t){var n=e.end();t.markup(!1),t._actualNode().startPosition=n,t._actualNode().endPosition=n,t.setUnit(e.unit())},e.prototype.execute=function(e){var t=this;e.commands.forEach(function(e){switch(e.kind){case T.CommandKind.CHANGE_VALUE:var n=e.target,r=n.value();r||(r="");var i=e.value;if(console.log("set value: "+typeof r+" ==> "+typeof i),"string"!=typeof r&&"number"!=typeof r&&"boolean"!=typeof r||"string"!=typeof i)if("string"!=typeof r&&"number"!=typeof r&&"boolean"!=typeof r||"string"==typeof i)if("string"!=typeof r&&"string"==typeof i){var a=e.value;if(r.kind()!=I.Kind.MAPPING)throw new V(F.applyTemplate(B.UNSUPPORTED_CASE_ATTRIBUTE_VALUE_CONVERSION,{curval:r,newval:i}));M.isMultiLine(a)?(n.children().forEach(function(e){t.remove(n.unit(),n,e)}),t.changeValue(n.unit(),n,a)):t.changeKey(n.unit(),r,a)}else{if("string"==typeof r||"string"==typeof i)throw new V(F.applyTemplate(B.UNSUPPORTED_CASE_ATTRIBUTE_VALUE_CONVERSION,{curval:r,newval:i}));var o=i;if(o.isMapping()&&(i=c([o.asMapping()])),r==i)break;var s=i;s.asMap(),n.children().forEach(function(e){t.remove(n.unit(),n,e)}),s.children().forEach(function(e){}),t.changeValue(n.unit(),n,i)}else t.changeValue(n.unit(),n,i);else r!=i&&t.changeValue(n.unit(),n,i);return;case T.CommandKind.CHANGE_KEY:var n=e.target;return void t.changeKey(n.unit(),n,e.value);case T.CommandKind.ADD_CHILD:var n=e.target,u=e.value;return void t.add2(n,u,e.toSeq,e.insertionPoint);case T.CommandKind.REMOVE_CHILD:var l=e.target,s=e.value;return void t.remove(l.unit(),l,s);case T.CommandKind.INIT_RAML_FILE:var p=e.target,f=e.value;return void t.initWithRoot(p,f);default:return void console.log(F.applyTemplate(B.UNSUPPORTED_COMMAND,{name:T.CommandKind[e.kind]}))}})},e.prototype.replaceYamlNode=function(e,t,n,r,i){var a=I.load(t,{ignoreDuplicateKeys:!0});this.updatePositions(e.start(),a),e.root().shiftNodes(n,r);var o=e.parent(),s=e._actualNode(),u=s.parent;if(a.parent=u,o&&o.kind()==I.Kind.MAP){var l=o._actualNode();l.mappings=l.mappings.map(function(e){return e!=s?e:a})}e.updateFrom(a),this.recalcPositionsUp(e)},e.prototype.executeTextChange2=function(e){var t=e.unit,n=t.contents(),r=e.target;if(r){var i=n.substring(r.start(),r.end());n=n.substr(0,e.offset)+e.text+n.substr(e.offset+e.replacementLength);var a=i.substr(0,e.offset-r.start())+e.text+i.substr(e.offset-r.start()+e.replacementLength);if(t.updateContentSafe(n),e.offset>r.start())try{var o=e.text.length-e.replacementLength,s=e.offset;r.unit().project().replaceYamlNode(r,a,s,o,e.unit)}catch(e){console.log("New node contents (causes error below): \n"+a),console.log("Reparse error: "+e.stack)}}else n=n.substr(0,e.offset)+e.text+n.substr(e.offset+e.replacementLength);t.updateContent(n),this.listeners.forEach(function(e){e(null)}),this.tlisteners.forEach(function(t){t(e)})},e.prototype.executeTextChange=function(e){(new Date).getTime();try{var t=e.unit.contents(),n=e.target;null==n&&(n=this.findNode(e.unit.ast(),e.offset,e.offset+e.replacementLength));var r=e.unit;if(n){var a=t.substring(n.start(),n.end()),o=t;t=t.substr(0,e.offset)+e.text+t.substr(e.offset+e.replacementLength);var s=a.substr(0,e.offset-n.start())+e.text+a.substr(e.offset-n.start()+e.replacementLength);if(r.updateContentSafe(t),u(o,e),e.offset>n.start())try{var l=I.load(s,{ignoreDuplicateKeys:!0});this.updatePositions(n.start(),l);var p=e.text.length-e.replacementLength;if(e.unit.ast().shiftNodes(e.offset,p),null!=l&&l.kind==I.Kind.MAP){var c=l.mappings[0],f=n._actualNode(),h=f.parent,d=new T.ASTDelta,m=e.unit;if(d.commands=[new T.ASTChangeCommand(T.CommandKind.CHANGE_VALUE,new Q(i(f),m,null,null,null),new Q(c,m,null,null,null),0)],h&&h.kind==I.Kind.MAP){var y=h;y.mappings=y.mappings.map(function(e){return e!=f?e:c})}return c.parent=h,this.recalcPositionsUp(n),n.updateFrom(c),this.listeners.forEach(function(e){e(d)}),void this.tlisteners.forEach(function(t){t(e)})}}catch(e){console.log(F.applyTemplate(B.NEW_NODE_CONTENTS_ERROR_BELOW,{content:s})),console.log(F.applyTemplate(B.REPARSE_ERROR,{content:e.stack}))}}else t=t.substr(0,e.offset)+e.text+t.substr(e.offset+e.replacementLength);(new Date).getTime(),r.updateContent(t),this.listeners.forEach(function(e){e(null)}),this.tlisteners.forEach(function(t){t(e)})}finally{(new Date).getTime()}},e.prototype.updatePositions=function(e,t){var n=this;if(null!=t)switch(-1==t.startPosition?t.startPosition=e:t.startPosition=e+t.startPosition,t.endPosition=e+t.endPosition,t.kind){case I.Kind.MAP:var r=t;r.mappings.forEach(function(t){return n.updatePositions(e,t)});break;case I.Kind.MAPPING:var i=t;this.updatePositions(e,i.key),this.updatePositions(e,i.value);break;case I.Kind.SCALAR:break;case I.Kind.SEQ:var a=t;a.items.forEach(function(t){return n.updatePositions(e,t)})}},e.prototype.findNode=function(e,t,n){var r=this;if(null==e)return null;var i=e;if(e.start()<=t&&e.end()>=n){var a=e;return i.directChildren().forEach(function(e){var i=r.findNode(e,t,n);i&&(a=i)}),a}return null},e.prototype.addTextChangeListener=function(e){this.tlisteners.push(e)},e.prototype.removeTextChangeListener=function(e){this.tlisteners=this.tlisteners.filter(function(t){return t!=e})},e.prototype.addListener=function(e){this.listeners.push(e)},e.prototype.removeListener=function(e){this.listeners=this.listeners.filter(function(t){return t!=e})},e.prototype.namespaceResolver=function(){return this._namespaceResolver},e}();t.Project=J;var Q=function(){function e(e,t,n,r,i,a,o){void 0===a&&(a=!1),void 0===o&&(o=!1),this._node=e,this._unit=t,this._parent=n,this._anchor=r,this._include=i,this.cacheChildren=a,this._includesContents=o,this._errors=[]}return e.isInstance=function(t){return null!=t&&t.getClassIdentifier&&"function"==typeof t.getClassIdentifier&&R.contains(t.getClassIdentifier(),e.CLASS_IDENTIFIER)},e.prototype.getClassIdentifier=function(){var t=[];return t.concat(e.CLASS_IDENTIFIER)},e.prototype.actual=function(){return this._node},e.prototype.yamlNode=function(){return this._node},e.prototype.includesContents=function(){return this._includesContents},e.prototype.setIncludesContents=function(e){this._includesContents=e},e.prototype.gatherIncludes=function(t,n,r,i){var a=this;if(void 0===t&&(t=[]),void 0===n&&(n=null),void 0===r&&(r=null),void 0===i&&(i=!0),null!=this._node){var o=this._node.kind;if(o!=I.Kind.SCALAR)if(o==I.Kind.MAP){var s=this._node;1!=s.mappings.length||i?s.mappings.map(function(t){return new e(t,a._unit,a,r?r:a._anchor,n?n:a._include,a.cacheChildren)}).forEach(function(e){return e.gatherIncludes(t)}):new e(s.mappings[0].value,this._unit,this,n,r,this.cacheChildren).gatherIncludes(t)}else if(o==I.Kind.MAPPING){var u=this._node;null==u.value||new e(u.value,this._unit,this,r?r:this._anchor,n?n:this._include,this.cacheChildren).gatherIncludes(t)}else if(o==I.Kind.SEQ){var l=this._node;l.items.filter(function(e){return null!=e}).map(function(t){return new e(t,a._unit,a,r?r:a._anchor,n?n:a._include,a.cacheChildren)}).forEach(function(e){return e.gatherIncludes(t)})}else o==I.Kind.INCLUDE_REF&&this._unit&&t.push(this);else if(D.isScheme(this._node.value)){var p=D.getReferences(this._node.value,this.unit());p.forEach(function(n){var r=I.newScalar(n);r.kind=I.Kind.INCLUDE_REF;var i=new e(r,a.unit(),null,null,null);t.push(i)})}}},e.prototype.setHighLevelParseResult=function(e){this._highLevelParseResult=e},e.prototype.highLevelParseResult=function(){return this._highLevelParseResult},e.prototype.setHighLevelNode=function(e){this._highLevelNode=e},e.prototype.highLevelNode=function(){return this._highLevelNode},e.prototype.start=function(){return this._node.startPosition},e.prototype.errors=function(){return this._errors},e.prototype.addIncludeError=function(e){if(!R.find(this._errors,function(t){return t.message==e.message})){var t=this._node;t.includeErrors||(t.includeErrors=[]),R.find(t.includeErrors,function(t){return t.message==e.message})||(this._errors.push(e),t.includeErrors.push(e))}},e.prototype.parent=function(){return this._parent},e.prototype.recalcEndPositionFromChilds=function(){var e=(this.children(),this.children()[0]),t=this.children()[this.children().length-1];if(this.isMapping()){var n=this.asMapping();if(n.value)if(n.value.kind==I.Kind.MAP){var r=n.value;r.startPosition<0&&e&&(r.startPosition=e.start()),t&&(this._node.endPosition=t._node.endPosition),this._node.endPosition=Math.max(this._node.endPosition,n.value.endPosition)}else if(n.value.kind==I.Kind.SEQ){var i=n.value;if(i.startPosition<0&&i.items.length>0){var a=i.items[0].startPosition,o=new M.TextRange(this.unit().contents(),a,a);o=o.extendSpacesBack().extendCharIfAnyBack("-"),i.startPosition=o.startpos()}if(i.items.length>0){var s=i.items[i.items.length-1];this._node.endPosition=Math.max(this._node.endPosition,i.endPosition,s.endPosition),i.endPosition=Math.max(this._node.endPosition,i.endPosition,s.endPosition)}}else n.value.kind==I.Kind.SCALAR||t&&(this._node.endPosition=t._node.endPosition)}else t&&(this._node.endPosition=t._node.endPosition)},e.prototype.isValueLocal=function(){if(this._node.kind==I.Kind.MAPPING){var e=this._node.value.kind;return e!=I.Kind.INCLUDE_REF&&e!=I.Kind.ANCHOR_REF}return!0},e.prototype.keyStart=function(){return this._node.kind==I.Kind.MAPPING?this._node.key.startPosition:-1},e.prototype.keyEnd=function(){return this._node.kind==I.Kind.MAPPING?this._node.key.endPosition:-1},e.prototype.valueStart=function(){if(this._node.kind==I.Kind.MAPPING){var e=this.asMapping();return e.value?e.value.startPosition:e.endPosition}return this._node.kind==I.Kind.SCALAR?this.start():-1},e.prototype.valueEnd=function(){if(this._node.kind==I.Kind.MAPPING){var e=this.asMapping();return e.value?e.value.endPosition:e.endPosition}return this._node.kind==I.Kind.SCALAR?this.end():-1},e.prototype.end=function(){return this._node.endPosition},e.prototype.dump=function(){if(this._oldText)return this._oldText;if(this._unit&&this._node.startPosition>0&&this._node.endPosition>0){var e=this._unit.contents().substring(this._node.startPosition,this._node.endPosition);return e=o(e,$(this,this._unit.contents()))}return I.dump(this.dumpToObject(),{})},e.prototype.dumpToObject=function(e){return void 0===e&&(e=!1),this.dumpNode(this._node,e)},e.prototype.dumpNode=function(e,t){var n=this;if(void 0===t&&(t=!1),!e)return null;if(e.kind==I.Kind.INCLUDE_REF){if(this._unit){var r=e,i=r.value,a=null;try{a=this._unit.resolve(i)}catch(e){}if(null==a)return null;if(a.isRAMLUnit()&&this.canInclude(a)){var o=this.unit(),s=a;s.addIncludedBy(o.absolutePath()),o.getIncludedByPaths().forEach(function(e){s.addIncludedBy(e)});var u=a.ast();if(u)return u.dumpToObject(t)}else if(this.canInclude(a))return a.contents()}return null}if(e.kind==I.Kind.SEQ){var p=e,c=[];return p.items.forEach(function(e){return c.push(n.dumpNode(e,t))}),c}if(e.kind==I.Kind.ANCHOR_REF){var f=e;return this.dumpNode(f.value,t)}if(e.kind==I.Kind.MAPPING){var h=e,d={},m=h.value,y=this.dumpNode(m,t);return d[""+this.dumpNode(h.key,t)]=y,d}if(e.kind==I.Kind.SCALAR){var r=e,v=r.value;return r.plainScalar&&(v=l(v)),v}if(e.kind==I.Kind.MAP){var g=e,A={};return g.mappings&&g.mappings.forEach(function(e){var r=n.dumpNode(e.value,t);null==r&&(r=t?"!$$$novalue":r),A[n.dumpNode(e.key,t)+""]=r}),A}},e.prototype.keyKind=function(){return this._node.key?this._node.key.kind:null},e.prototype._actualNode=function(){return this._node},e.prototype.execute=function(e){this.unit()?this.unit().project().execute(e):e.commands.forEach(function(e){switch(e.kind){case T.CommandKind.CHANGE_VALUE:var t=e.target,n=e.value,r=t._actualNode();return t.start(),void(r.kind==I.Kind.MAPPING&&(r.value=I.newScalar(""+n)));case T.CommandKind.CHANGE_KEY:var t=e.target,n=e.value,r=t._actualNode();if(r.kind==I.Kind.MAPPING){var i=r.key;i.value=n}return}})},e.prototype.updateFrom=function(e){this._node=e},e.prototype.isAnnotatedScalar=function(){if(!this.unit())return!1;for(var e,t=this;!e&&t;)e=t.highLevelNode(),t=t.parent();if(e){var n=void 0;if(e.isElement())n=e.asElement().definition();else{var r=e.property();n=r&&(r.domain()||r.range())}if(n){var i=n.universe().version();if("RAML08"==i)return!1}}var a;if(this.kind()==I.Kind.MAPPING&&this.valueKind()==I.Kind.MAP?a=this._node.value.mappings:null==this.key()&&this.kind()==I.Kind.MAP&&(a=this._node.mappings),a){var o=a.length>0;return a.forEach(function(e){"value"!==e.key.value&&(e.key.value&&"("==e.key.value.charAt(0)&&")"==e.key.value.charAt(e.key.value.length-1)||(o=!1))}),o}return!1},e.prototype.value=function(t){if(!this._node)return"";if(this._node.kind==I.Kind.SCALAR){if("~"===this._node.value&&null===this._node.valueObject)return null;if(!t&&""+this._node.valueObject===this._node.value)return this._node.valueObject;var n=null;return n=this._node.hasOwnProperty("valueObject")&&null==this._node.valueObject?this._node.valueObject:this._node.value,t||this._node.plainScalar&&(n=l(n)),n}if(this._node.kind==I.Kind.ANCHOR_REF){var r=this._node;return new e(r.value,this._unit,this,null,null).value(t)}if(this._node.kind==I.Kind.MAPPING){var i=this._node;if(null==i.value)return null;if(this.isAnnotatedScalar())for(var a=new e(i.value,this._unit,this,null,null),o=a.children(),s=0;s<o.length;s++)if("value"===o[s].key())return o[s].valueKind()==I.Kind.SEQ?o[s].children().map(function(e){return e.value()}):o[s].value();return new e(i.value,this._unit,this,null,null).value(t)}if(this._node.kind==I.Kind.INCLUDE_REF){var u=this._node.value,p=u,c=null;try{c=this._unit.resolve(p)}catch(e){return F.applyTemplate(B.CAN_NOT_RESOLVE_REASON,{path:p,reason:e.message})}if(null==c)return F.applyTemplate(B.CAN_NOT_RESOLVE,{path:p});if(c.isRAMLUnit()){var f=c.ast();return f?f.value():F.applyTemplate(B.CAN_NOT_RESOLVE_REASON,{path:p,reason:"file is empty"})}var h=c.contents();return M.isMultiLineValue(h)&&(h=M.fromMutiLine(h)),h}if(this._node.kind==I.Kind.MAP){var d=this._node;if(1==d.mappings.length)return new e(d.mappings[0],this._unit,this,null,null);if(this.isAnnotatedScalar())for(var o=this.children(),s=0;s<o.length;s++)if("value"===o[s].key())return o[s].valueKind()==I.Kind.SEQ?o[s].children().map(function(e){return e.value()}):o[s].value()}if(this._node.kind==I.Kind.SEQ){var m=this._node;if(1==m.items.length)return new e(m.items[0],this._unit,this,null,null).value(t)}return null},e.prototype.printDetails=function(e){var t="";e||(e="");var n=this.kindName();return this.kind()==I.Kind.SCALAR?t+=e+"["+n+"] "+this.value()+"\n":this.kind()==I.Kind.MAPPING&&this._node.value&&this._node.value.kind==I.Kind.SCALAR?t+=e+"["+n+"] "+this.key()+" = "+this.value()+"\n":this.kind()==I.Kind.MAPPING?(t+=e+"["+n+"] "+this.key()+" = :\n",this.children().forEach(function(n){t+=n.printDetails(e+"	")})):(t+=e+"["+n+"] :\n",this.children().forEach(function(n){t+=n.printDetails(e+"	")})),t},e.prototype.visit=function(e){this.children().forEach(function(t){e(t)&&t.visit(e)})},e.prototype.rawKey=function(){if(!this._node)return"";if(this._node.kind==I.Kind.MAPPING){var e=this._node;if(e.key.kind==I.Kind.SEQ){var t=e.key,n="[";return t.items.forEach(function(e){return n+=e.value}),n+"]"}return e.key.value}if(this._node.kind==I.Kind.INCLUDE_REF){var r=this.children();if(1==r.length)return r[0].key()}return null},e.prototype.key=function(e){void 0===e&&(e=!1);var t=this.rawKey();return e?t:(null!=t&&P.stringEndsWith(t,"?")&&(t=t.substring(0,t.length-1)),t)},e.prototype.optional=function(){var e=this.rawKey();return null!=e&&P.stringEndsWith(e,"?")},e.prototype.addChild=function(e,t){void 0===t&&(t=-1);var n=e;if(n._parent=this,this._oldText=null,this.isMap()){var r=this.asMap();null!=r.mappings&&void 0!=r.mappings||(r.mappings=[]),t>=0?r.mappings.splice(t,0,n.asMapping()):r.mappings.push(n.asMapping())}else if(this.isMapping()){var i=this.asMapping(),a=i.value;if(!i.value&&n.isMap())return void(i.value=n._actualNode());if(i.value&&i.value.kind==I.Kind.SCALAR&&(i.value=null,a=null),a||(a=n.isScalar()||n.highLevelNode()&&n.highLevelNode().property().getAdapter(C.RAMLPropertyParserService).isEmbedMap()?I.newSeq():I.newMap(),i.value=a),a.kind==I.Kind.MAP){var r=a;null!=r.mappings&&void 0!=r.mappings||(r.mappings=[]),n.isScalar(),t>=0?r.mappings.splice(t,0,n.asMapping()):r.mappings.push(n.asMapping())}else{if(a.kind!=I.Kind.SEQ)throw new V(F.applyTemplate(B.INSERT_INTO_MAPPING_VALUE_NOT_SUPPORTED,{value:I.Kind[i.value.kind]}));var o=a;t>=0?o.items.splice(t,0,n._actualNode()):o.items.push(n._actualNode())}}else{if(!this.isSeq())throw new V(F.applyTemplate(B.INSERT_INTO_NOT_SUPPORTED,{name:this.kindName()}));var o=this.asSeq();t>=0?o.items.splice(t,0,n._actualNode()):o.items.push(n._actualNode())}},e.prototype.removeChild=function(e){this._oldText=null;var t,n,r=e;if(this.kind()==I.Kind.SEQ){var i=this.asSeq();t=r._node,n=i.items.indexOf(t),n>-1&&i.items.splice(n,1)}else if(this.kind()==I.Kind.MAP){var a=this.asMap();t=r.asMapping(),n=a.mappings.indexOf(t),n>-1&&a.mappings.splice(n,1)}else{if(this.kind()!=I.Kind.MAPPING)throw new V(F.applyTemplate(B.DELETE_FROM_NOT_SUPPORTED,{name:I.Kind[this.kind()]}));var o=this.asMapping();if(r._actualNode()==o.value)o.value=null;else{var a=o.value;t=r.asMapping(),a&&a.mappings&&(n=a.mappings.indexOf(t),n>-1&&a.mappings.splice(n,1))}}},e.prototype.hasInnerIncludeError=function(){return this.innerIncludeErrors},e.prototype.includeErrors=function(){if(this._node.kind==I.Kind.MAPPING){var t=this._node;if(null==t.value)return[];var n=new e(t.value,this._unit,this,this._anchor,this._include),r=n.includeErrors();return this.innerIncludeErrors=n.hasInnerIncludeError(),r}var i=[];if(this._node.kind==I.Kind.INCLUDE_REF){var t=this._node;if(null==t.value)return[];var a=this.includePath(),o=null;try{o=this._unit.resolve(a)}catch(e){this.innerIncludeErrors=e.inner;var s=F.applyTemplate(B.CAN_NOT_RESOLVE_REASON,{path:a,reason:e.message});return i.push(s),i}var u=this._node.includeErrors;if(u&&u.length>0)return this.innerIncludeErrors=!0,i=u.map(function(e){return"object"==typeof e&&e instanceof V?e.message:e.toString()});if(null==o)return i.push(F.applyTemplate(B.CAN_NOT_RESOLVE,{path:a})),i;if(o.isRAMLUnit()){var l=o.ast();if(l)return[];i.push(F.applyTemplate(B.CAN_NOT_BE_PARSED,{path:a}))}}return i},e.prototype.joinMappingsWithFullIncludeAnchor=function(t,n,r){var i=this,a=R.find(t,function(e){return e.key&&e.value&&e.key.kind==I.Kind.SCALAR&&"<<"==e.key.value&&e.value.kind==I.Kind.ANCHOR_REF});if(!a)return t.map(function(t){return new e(t,i._unit,i,r?r:i._anchor,n?n:i._include,i.cacheChildren)});var o=R.filter(t,function(e){return!(e.key.kind==I.Kind.SCALAR&&"<<"==e.key.value&&e.value.kind==I.Kind.ANCHOR_REF)}),s=new e(a.value,this._unit,this,n,r,this.cacheChildren).children(null,null,!0),u=o.map(function(t){return new e(t,i._unit,i,r?r:i._anchor,n?n:i._include,i.cacheChildren)});return u.concat(s)},e.prototype.children=function(t,n,r){var i=this;if(void 0===t&&(t=null),void 0===n&&(n=null),void 0===r&&(r=!0),null==this._node)return[];if(this.cacheChildren&&this._children)return this._children;var a,o=this._node.kind;if(o==I.Kind.SCALAR)a=[];else if(o==I.Kind.MAP){var s=this._node;a=1!=s.mappings.length||r?this.joinMappingsWithFullIncludeAnchor(s.mappings,t,n):new e(s.mappings[0].value,this._unit,this,t,n,this.cacheChildren).children(null,null,!0)}else if(o==I.Kind.MAPPING){var u=this._node;if(null==u.value)a=[];else{var l=new e(u.value,this._unit,this,n?n:this._anchor,t?t:this._include,this.cacheChildren);a=l.children(),l.includesContents()&&this.setIncludesContents(!0)}}else if(o==I.Kind.SEQ){var p=this._node;a=p.items.filter(function(e){return null!=e}).map(function(r){return new e(r,i._unit,i,n?n:i._anchor,t?t:i._include,i.cacheChildren)})}else if(o==I.Kind.INCLUDE_REF){if(this._unit){var c=this.includePath(),f=null;try{f=this._unit.resolve(c)}catch(e){}if(null==f)a=[];else if(f.isRAMLUnit())if(this.canInclude(f)){var h=this.unit(),d=f;d.addIncludedBy(h.absolutePath()),h.getIncludedByPaths().forEach(function(e){d.addIncludedBy(e)});var m=f.ast();m&&(this.cacheChildren&&(m=v(m)),a=f.ast().children(this,null),this.setIncludesContents(!0))}else this.addIncludeError&&this.addIncludeError(new V(B.RECURSIVE_DEFINITION_EMPTY.message))}a||(a=[])}else{if(o!=I.Kind.ANCHOR_REF)throw new V(F.applyTemplate(B.SHOULD_NEVER_HAPPEN_KIND,{kind:I.Kind[this._node.kind]}));var y=this._node;a=new e(y.value,this._unit,this,null,null,this.cacheChildren).children()}return this.cacheChildren&&(this._children=a),a},e.prototype.canInclude=function(e){for(var t=this.includedFrom();null!=t;){if(t.unit().absolutePath()==e.absolutePath())return!1;t=t.includedFrom()}return!this.unit().includedByContains(e.absolutePath())},e.prototype.directChildren=function(t,n,r){var i=this;if(void 0===t&&(t=null),void 0===n&&(n=null),void 0===r&&(r=!0),this._node){switch(this._node.kind){case I.Kind.SCALAR:return[];case I.Kind.MAP:var a=this._node;return 1!=a.mappings.length||r?a.mappings.map(function(r){return new e(r,i._unit,i,n?n:i._anchor,t?t:i._include)}):new e(a.mappings[0].value,this._unit,this,t,n).directChildren(null,null,!0);case I.Kind.MAPPING:var o=this._node;return null==o.value?[]:new e(o.value,this._unit,this,n?n:this._anchor,t?t:this._include).directChildren();case I.Kind.SEQ:var s=this._node;return s.items.filter(function(e){return null!=e}).map(function(r){return new e(r,i._unit,i,n?n:i._anchor,t?t:i._include)});case I.Kind.INCLUDE_REF:return[];case I.Kind.ANCHOR_REF:return[]}throw new V(F.applyTemplate(B.SHOULD_NEVER_HAPPEN_KIND,{kind:I.Kind[this._node.kind]}))}return[]},e.prototype.anchorId=function(){return this._node.anchorId},e.prototype.unit=function(){return this._unit},e.prototype.containingUnit=function(){return this.valueKind()==I.Kind.INCLUDE_REF?this.unit().resolve(this._node.value.value):this.kind()==I.Kind.INCLUDE_REF?this.unit().resolve(this._node.value):this._unit},e.prototype.includeBaseUnit=function(){return this._unit},e.prototype.setUnit=function(e){this._unit=e},e.prototype.includePath=function(){var e=this.getIncludeString();return e?e:null},e.prototype.includeReference=function(){var e=this.getIncludeString();return e?O.getIncludeReference(e):null},e.prototype.getIncludeString=function(){if(!this._node)return null;if(this._node.kind==I.Kind.INCLUDE_REF){var t=this._node.value;return t}if(this._node.kind==I.Kind.MAPPING){var n=this._node;return null==n.value?null:new e(n.value,this._unit,this,null,null).getIncludeString()}if(this._node.kind==I.Kind.ANCHOR_REF){var r=this._node.value;return new e(r,this._unit,this,null,null).getIncludeString()}return null},e.prototype.anchoredFrom=function(){return this._anchor},e.prototype.includedFrom=function(){return this._include},e.prototype.kind=function(){return this._actualNode().kind},e.prototype.valueKind=function(){if(this._node.kind!=I.Kind.MAPPING)return null;var e=this._node;return e.value?e.value.kind:null},e.prototype.anchorValueKind=function(){if(this.valueKind()==I.Kind.ANCHOR_REF){var e=this._node.value;return e&&e.value&&e.value.kind}return null},e.prototype.resolvedValueKind=function(){var e=this.valueKind();if(e==I.Kind.ANCHOR_REF){var t=this.anchorValueKind();if(t==I.Kind.INCLUDE_REF){var n=this._node.value,r=n.value.value;return this.unitKind(r)}return t}if(e==I.Kind.INCLUDE_REF){var r=this.includePath();return this.unitKind(r)}return e},e.prototype.unitKind=function(e){var t;try{t=this._unit.resolve(e)}catch(e){return null}if(null==t)return I.Kind.SCALAR;if(t.isRAMLUnit()){var n=t.ast();if(n)return n.kind()}return I.Kind.SCALAR},e.prototype.valueKindName=function(){var e=this.valueKind();return void 0!=e?I.Kind[e]:null},e.prototype.kindName=function(){return I.Kind[this.kind()]},e.prototype.indent=function(e,t){void 0===t&&(t="");for(var n="",r=0;e>r;r++)n+="  ";return n+t},e.prototype.replaceNewlines=function(e,t){void 0===t&&(t=null);for(var n="",r=0;r<e.length;r++){var i=e[r];"\r"==i&&(i=null==t?"\\r":t),"\n"==i&&(i=null==t?"\\n":t),n+=i}return n},e.prototype.shortText=function(e,t){void 0===t&&(t=50);var n=this.end()-this.start(),r=n,i=this.unit();!e&&i&&(e=i.contents());var a;if(e){var o=e;a=o?o.substring(this.start(),this.end()):"[no-text]"}else a="[no-unit]";return a="["+this.start()+".."+this.end()+"] "+n+" // "+a+" //",n>r&&(a+="..."),a=this.replaceNewlines(a)},e.prototype.nodeShortText=function(e,t,n){void 0===n&&(n=50);var r=e.endPosition-e.startPosition,i=r,a=this.unit();!t&&a&&(t=a.contents());var o;if(t){var s=t;o=s?s.substring(e.startPosition,e.endPosition):"[no-text]"}else o="[no-unit]";return o="["+e.startPosition+".."+e.endPosition+"] "+r+" // "+o+" //",r>i&&(o+="..."),o=this.replaceNewlines(o)},e.prototype.show=function(e,t,n){void 0===e&&(e=null),void 0===t&&(t=0),void 0===n&&(n=null),e&&0==t&&console.log(e);var r=this.children(),i=this.kindName(),a=this._actualNode().value;this.kind()==I.Kind.MAPPING&&(i+="["+this._actualNode().key.value+"]"),i+=a?"/"+I.Kind[a.kind]:"",0==r.length?(console.log(this.indent(t)+i+" // "+this.shortText(n)),this.isMapping()&&this.asMapping().value&&console.log(this.indent(t+1)+"// "+this.valueKindName()+": "+this.nodeShortText(this.asMapping().value,n))):(console.log(this.indent(t)+i+" { // "+this.shortText(n)),this.isMapping()&&this.asMapping().value&&console.log(this.indent(t+1)+"// "+this.valueKindName()+": "+this.nodeShortText(this.asMapping().value,n)),r.forEach(function(e){var r=e;r.show(null,t+1,n)}),console.log(this.indent(t)+"}"))},e.prototype.showParents=function(e,t){void 0===t&&(t=0),e&&0==t&&console.log(e);var n=0;if(this.parent()){var r=this.parent();n=r.showParents(null,t+1)}var i=this.kindName(),a=this._actualNode().value;return i+=a?"/"+I.Kind[a.kind]:"/null",console.log(this.indent(n)+i+" // "+this.shortText(null)),n+1},e.prototype.inlined=function(e){return e==I.Kind.SCALAR||e==I.Kind.INCLUDE_REF},e.prototype.markupNode=function(e,t,n,r){void 0===r&&(r=!1);var i=e.text.length;switch(t.kind){case I.Kind.MAP:r&&e.append("{");for(var o=t.mappings,s=0;s<o.length;s++)r&&s>0&&e.append(", "),this.markupNode(e,o[s],n,r);r&&e.append("}");break;case I.Kind.SEQ:for(var u=t.items,s=0;s<u.length;s++)e.append(this.indent(n,"- ")),this.markupNode(e,u[s],n+1,r);break;case I.Kind.MAPPING:var l=t,p=l.value;if(r){if(!p){e.append("\n");break}if(e.append(l.key.value),e.append(": "),p.kind==I.Kind.SCALAR){var c=p;e.append(c.value)}else{if(p.kind!=I.Kind.MAP)throw new V(F.applyTemplate(B.NOT_IMPLEMENTED_KIND,{kind:I.Kind[p.kind]}));this.markupNode(e,l.value,n+1,r)}break}if(e.addWithIndent(n,l.key.value+":"),!p){e.append("\n");break}if(p.kind==I.Kind.SCALAR)var c=p;l.value?(e.append(this.inlined(l.value.kind)?" ":"\n"),this.markupNode(e,l.value,n+1,r)):e.append("\n");break;case I.Kind.SCALAR:var c=t;if(M.isMultiLine(c.value)){e.append("|\n");for(var f=a(c.value),s=0;s<f.length;s++)e.append(this.indent(n,f[s]));e.append("\n")}else e.append(c.value+"\n");break;case I.Kind.INCLUDE_REF:var h=t;e.append("!include "+h.value+"\n");break;default:throw new V(F.applyTemplate(B.UNKNOWN_NODE_KIND,{kind:I.Kind[t.kind]}))}for(;i<e.text.length&&" "==e.text[i];)i++;t.startPosition=i,t.endPosition=e.text.length},e.prototype.markup=function(e){void 0===e&&(e=!1);var t=new K("");return this.markupNode(t,this._actualNode(),0,e),t.text},e.prototype.root=function(){for(var e=this;e.parent();){var t=e.parent();e=t}return e},e.prototype.parentOfKind=function(e){for(var t=this.parent();t;){if(t.kind()==e)return t;t=t.parent()}return null},e.prototype.find=function(e){var t=null;return this.directChildren().forEach(function(n){n.key()&&n.key()==e&&(t||(t=n))}),t},e.prototype.shiftNodes=function(e,t,n){if(this.directChildren().forEach(function(r){n&&n.start()==r.start()&&n.end()==r.end()||r.shiftNodes(e,t,n)}),n&&n.start()==this.start()&&n.end()==this.end());else{var r=this._actualNode();r&&z(e,r,t)}return null},e.prototype.isMap=function(){return this.kind()==I.Kind.MAP},e.prototype.isMapping=function(){return this.kind()==I.Kind.MAPPING},e.prototype.isSeq=function(){return this.kind()==I.Kind.SEQ},e.prototype.isScalar=function(){return this.kind()==I.Kind.SCALAR},e.prototype.asMap=function(){if(!this.isMap())throw new V(F.applyTemplate(B.EXPECTED_INSTEAD_OF,{expected:"map",received:this.kindName()}));return this._actualNode()},e.prototype.asMapping=function(){if(!this.isMapping())throw new V(F.applyTemplate(B.EXPECTED_INSTEAD_OF,{expected:"mapping",received:this.kindName()}));return this._actualNode()},e.prototype.asSeq=function(){if(!this.isSeq())throw new V(F.applyTemplate(B.EXPECTED_INSTEAD_OF,{expected:"seq",received:this.kindName()}));return this._actualNode()},e.prototype.asScalar=function(){if(!this.isScalar())throw new V(F.applyTemplate(B.EXPECTED_INSTEAD_OF,{expected:"scalar",received:this.kindName()}));return this._actualNode()},e.prototype.isValueSeq=function(){return this.valueKind()==I.Kind.SEQ},e.prototype.isValueMap=function(){return this.valueKind()==I.Kind.MAP},e.prototype.isValueInclude=function(){return this.valueKind()==I.Kind.INCLUDE_REF},e.prototype.isValueScalar=function(){return this.valueKind()==I.Kind.SCALAR},e.prototype.valueAsSeq=function(){if(!this.isMapping())throw new V(F.applyTemplate(B.EXPECTED_INSTEAD_OF,{expected:"mapping",received:this.kindName()}));if(this.valueKind()!=I.Kind.SEQ)throw new V(F.applyTemplate(B.EXPECTED_INSTEAD_OF,{expected:"mapping/seq",received:"mapping/"+this.kindName()}));return this.asMapping().value},e.prototype.valueAsMap=function(){if(!this.isMapping())throw new V(F.applyTemplate(B.EXPECTED_INSTEAD_OF,{expected:"mapping",received:this.kindName()}));if(this.valueKind()!=I.Kind.MAP)throw new V(F.applyTemplate(B.EXPECTED_INSTEAD_OF,{expected:"mapping/map",received:"mapping/"+this.kindName()}));return this.asMapping().value},e.prototype.valueAsScalar=function(){if(!this.isMapping())throw new V(F.applyTemplate(B.EXPECTED_INSTEAD_OF,{expected:"mapping",received:this.kindName()}));if(this.valueKind()!=I.Kind.SCALAR)throw new V(F.applyTemplate(B.EXPECTED_INSTEAD_OF,{expected:"mapping/scalar",received:"mapping/"+this.kindName()}));return this.asMapping().value},e.prototype.valueAsInclude=function(){if(!this.isMapping())throw new V(F.applyTemplate(B.EXPECTED_INSTEAD_OF,{expected:"mapping",received:this.kindName()}));if(this.valueKind()!=I.Kind.INCLUDE_REF)throw new V(F.applyTemplate(B.EXPECTED_INSTEAD_OF,{expected:"mapping/include",
received:"mapping/"+this.kindName()}));return this.asMapping().value},e.prototype.text=function(e){if(void 0===e&&(e=null),!e){if(!this.unit())return"[no-text]";e=this.unit().contents()}return e.substring(this.start(),this.end())},e.prototype.copy=function(){var t=i(this._actualNode());return new e(t,this._unit,this._parent,this._anchor,this._include,this._includesContents)},e.prototype.nodeDefinition=function(){return A(this)},e.CLASS_IDENTIFIER="jsyaml2lowLevel.ASTNode",e}();t.ASTNode=Q;var Z;!function(e){e[e.NONE=0]="NONE",e[e.START=1]="START",e[e.END=2]="END",e[e.POINT=3]="POINT"}(Z=t.InsertionPointType||(t.InsertionPointType={}));var ee=function(){function e(e,t){void 0===t&&(t=null),this.type=e,this.point=t}return e.isInstance=function(t){return null!=t&&t.getClassIdentifier&&"function"==typeof t.getClassIdentifier&&R.contains(t.getClassIdentifier(),e.CLASS_IDENTIFIER)},e.prototype.getClassIdentifier=function(){var t=[];return t.concat(e.CLASS_IDENTIFIER)},e.after=function(t){return new e(Z.POINT,t)},e.atStart=function(){return new e(Z.START)},e.atEnd=function(){return new e(Z.END)},e.node=function(){return new e(Z.NONE)},e.prototype.show=function(e){e?(console.log(e),console.log(F.applyTemplate(B.INSERTION_POINT_TYPE,{type:Z[this.type]}))):console.log(F.applyTemplate(B.INSERTION_POINT_TYPE,{type:Z[this.type]})),this.type==Z.POINT&&this.point&&this.point.show()},e.CLASS_IDENTIFIER="jsyaml2lowLevel.InsertionPoint",e}();t.InsertionPoint=ee,t.createNode=p,t.createMap=c,t.createScalar=f,t.createSeq=h,t.createSeqNode=d,t.createMapNode=m,t.createMapping=y,t.toChildCachingNode=v,t.toIncludingNode=g,t.getDefinitionForLowLevelNode=A,t.fetchIncludesAndMasterAsync=_},function(e,t,n){"use strict";function r(e,t){return new N(A.CHANGE_VALUE,e,t,-1)}function i(e,t){return new N(A.CHANGE_VALUE,e,t.lowLevel(),-1)}function a(e,t){return new N(A.CHANGE_KEY,e,t,-1)}function o(e,t){return new N(A.REMOVE_CHILD,e,t,-1)}function s(e,t,n,r){void 0===n&&(n=null),void 0===r&&(r=!1);var i=new N(A.ADD_CHILD,e,t,-1);return i.insertionPoint=n,i.toSeq=r,i}function u(e,t){return new N(A.INIT_RAML_FILE,e,t,-1)}function l(e,t,n){if(h.isAbsolute(e)){var r=h.extname(t);".xsd"!=r&&(e=e.substr(1),t=p(n,h.basename(t)))}return c(e)||h.isAbsolute(e)?e:c(t)||h.isAbsolute(t)?p(h.dirname(t),e):p(h.dirname(p(n,t)),e)}function p(e,t){if(c(t))return t;var n;if(c(e)){var r=m.stringEndsWith(e,"/")?e:e+"/";n=d.resolve(r,t).replace(/\\/g,"/")}else n=h.resolve(e,t).replace(/\\/g,"/");return n}function c(e){return null!=e&&(m.stringStartsWith(e,"http://")||m.stringStartsWith(e,"https://"))}function f(e){return e.start&&e.end&&e.unit&&e.key&&e.value&&e.children&&e.includePath}Object.defineProperty(t,"__esModule",{value:!0});var h=n(6),d=n(8),m=n(15),y=n(19),v=n(269),g=function(){function e(){}return e}();t.ASTDelta=g;var A;!function(e){e[e.ADD_CHILD=0]="ADD_CHILD",e[e.REMOVE_CHILD=1]="REMOVE_CHILD",e[e.MOVE_CHILD=2]="MOVE_CHILD",e[e.CHANGE_KEY=3]="CHANGE_KEY",e[e.CHANGE_VALUE=4]="CHANGE_VALUE",e[e.INIT_RAML_FILE=5]="INIT_RAML_FILE"}(A=t.CommandKind||(t.CommandKind={}));var E=function(){function e(e,t,n,r,i){void 0===i&&(i=null),this.offset=e,this.replacementLength=t,this.text=n,this.unit=r,this.target=i}return e}();t.TextChangeCommand=E;var _=function(){function e(){this.commands=[]}return e}();t.CompositeCommand=_;var T;!function(e){e[e.NONE=0]="NONE",e[e.START=1]="START",e[e.END=2]="END",e[e.POINT=3]="POINT"}(T=t.InsertionPointType||(t.InsertionPointType={}));var N=function(){function e(e,t,n,r){this.toSeq=!1,this.kind=e,this.target=t,this.value=n,this.position=r}return e}();t.ASTChangeCommand=N,t.setAttr=r,t.setAttrStructured=i,t.setKey=a,t.removeNode=o,t.insertNode=s,t.initRamlFile=u;var S=function(){function e(e,t){this.content=e,this.absPath=t}return e.prototype.position=function(e){var t=e;this.initMapping();for(var n=0;n<this.mapping.length;n++){var r=this.mapping[n];if(r>t)return{line:n,column:t,position:e};t-=r}if(0==t)return{line:this.mapping.length-1,column:this.mapping[this.mapping.length-1],position:this.content.length};if(1==t)return{line:this.mapping.length-1,column:this.mapping[this.mapping.length-1]-1,position:e-1};throw new Error(y.applyTemplate(v.POSITION_EXCEEDS_TEXT_LENGTH,{pos:e,length:this.content.length,absPath:this.absPath}))},e.prototype.initMapping=function(){if(null==this.mapping){if(null==this.content)throw new Error(y.applyTemplate(v.LINE_MAPPER_HAS_NULL_CONTENT,{path:null!=this.absPath?". Path: "+this.absPath:" and null path."}));this.mapping=[];for(var e=0,t=this.content.length,n=0;t>n;n++)"\r"==this.content.charAt(n)?t-1>n&&"\n"==this.content.charAt(n+1)?(this.mapping.push(n-e+2),e=n+2,n++):(this.mapping.push(n-e+1),e=n+1):"\n"==this.content.charAt(n)&&(this.mapping.push(n-e+1),e=n+1);this.mapping.push(t-e)}},e.prototype.toPosition=function(e,t){var n=t;this.initMapping();for(var r=e;r<this.mapping.length;r++){var i=this.mapping[r];if(i>n){for(var a=n,o=0;r>o;o++)a+=this.mapping[o];return{line:r,column:n,position:a}}n-=i}return{line:r,column:n,position:this.content.length}},e}();t.LineMapperImpl=S,t.buildPath=l,t.toAbsolutePath=p,t.isWebPath=c,t.isLowLevelNode=f},function(e,t,n){(function(e){function n(e,t){for(var n=0,r=e.length-1;r>=0;r--){var i=e[r];"."===i?e.splice(r,1):".."===i?(e.splice(r,1),n++):n&&(e.splice(r,1),n--)}if(t)for(;n--;n)e.unshift("..");return e}function r(e,t){if(e.filter)return e.filter(t);for(var n=[],r=0;r<e.length;r++)t(e[r],r,e)&&n.push(e[r]);return n}var i=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/,a=function(e){return i.exec(e).slice(1)};t.resolve=function(){for(var t="",i=!1,a=arguments.length-1;a>=-1&&!i;a--){var o=a>=0?arguments[a]:e.cwd();if("string"!=typeof o)throw new TypeError("Arguments to path.resolve must be strings");o&&(t=o+"/"+t,i="/"===o.charAt(0))}return t=n(r(t.split("/"),function(e){return!!e}),!i).join("/"),(i?"/":"")+t||"."},t.normalize=function(e){var i=t.isAbsolute(e),a="/"===o(e,-1);return e=n(r(e.split("/"),function(e){return!!e}),!i).join("/"),e||i||(e="."),e&&a&&(e+="/"),(i?"/":"")+e},t.isAbsolute=function(e){return"/"===e.charAt(0)},t.join=function(){var e=Array.prototype.slice.call(arguments,0);return t.normalize(r(e,function(e,t){if("string"!=typeof e)throw new TypeError("Arguments to path.join must be strings");return e}).join("/"))},t.relative=function(e,n){function r(e){for(var t=0;t<e.length&&""===e[t];t++);for(var n=e.length-1;n>=0&&""===e[n];n--);return t>n?[]:e.slice(t,n-t+1)}e=t.resolve(e).substr(1),n=t.resolve(n).substr(1);for(var i=r(e.split("/")),a=r(n.split("/")),o=Math.min(i.length,a.length),s=o,u=0;o>u;u++)if(i[u]!==a[u]){s=u;break}for(var l=[],u=s;u<i.length;u++)l.push("..");return l=l.concat(a.slice(s)),l.join("/")},t.sep="/",t.delimiter=":",t.dirname=function(e){var t=a(e),n=t[0],r=t[1];return n||r?(r&&(r=r.substr(0,r.length-1)),n+r):"."},t.basename=function(e,t){var n=a(e)[2];return t&&n.substr(-1*t.length)===t&&(n=n.substr(0,n.length-t.length)),n},t.extname=function(e){return a(e)[3]};var o="b"==="ab".substr(-1)?function(e,t,n){return e.substr(t,n)}:function(e,t,n){return 0>t&&(t=e.length+t),e.substr(t,n)}}).call(t,n(7))},function(e,t){function n(){throw new Error("setTimeout has not been defined")}function r(){throw new Error("clearTimeout has not been defined")}function i(e){if(p===setTimeout)return setTimeout(e,0);if((p===n||!p)&&setTimeout)return p=setTimeout,setTimeout(e,0);try{return p(e,0)}catch(t){try{return p.call(null,e,0)}catch(t){return p.call(this,e,0)}}}function a(e){if(c===clearTimeout)return clearTimeout(e);if((c===r||!c)&&clearTimeout)return c=clearTimeout,clearTimeout(e);try{return c(e)}catch(t){try{return c.call(null,e)}catch(t){return c.call(this,e)}}}function o(){m&&h&&(m=!1,h.length?d=h.concat(d):y=-1,d.length&&s())}function s(){if(!m){var e=i(o);m=!0;for(var t=d.length;t;){for(h=d,d=[];++y<t;)h&&h[y].run();y=-1,t=d.length}h=null,m=!1,a(e)}}function u(e,t){this.fun=e,this.array=t}function l(){}var p,c,f=e.exports={};!function(){try{p="function"==typeof setTimeout?setTimeout:n}catch(e){p=n}try{c="function"==typeof clearTimeout?clearTimeout:r}catch(e){c=r}}();var h,d=[],m=!1,y=-1;f.nextTick=function(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var n=1;n<arguments.length;n++)t[n-1]=arguments[n];d.push(new u(e,t)),1!==d.length||m||i(s)},u.prototype.run=function(){this.fun.apply(null,this.array)},f.title="browser",f.browser=!0,f.env={},f.argv=[],f.version="",f.versions={},f.on=l,f.addListener=l,f.once=l,f.off=l,f.removeListener=l,f.removeAllListeners=l,f.emit=l,f.prependListener=l,f.prependOnceListener=l,f.listeners=function(e){return[]},f.binding=function(e){throw new Error("process.binding is not supported")},f.cwd=function(){return"/"},f.chdir=function(e){throw new Error("process.chdir is not supported")},f.umask=function(){return 0}},function(e,t,n){"use strict";function r(){this.protocol=null,this.slashes=null,this.auth=null,this.host=null,this.port=null,this.hostname=null,this.hash=null,this.search=null,this.query=null,this.pathname=null,this.path=null,this.href=null}function i(e,t,n){if(e&&l.isObject(e)&&e instanceof r)return e;var i=new r;return i.parse(e,t,n),i}function a(e){return l.isString(e)&&(e=i(e)),e instanceof r?e.format():r.prototype.format.call(e)}function o(e,t){return i(e,!1,!0).resolve(t)}function s(e,t){return e?i(e,!1,!0).resolveObject(t):t}var u=n(9),l=n(11);t.parse=i,t.resolve=o,t.resolveObject=s,t.format=a,t.Url=r;var p=/^([a-z0-9.+-]+:)/i,c=/:[0-9]*$/,f=/^(\/\/?(?!\/)[^\?\s]*)(\?[^\s]*)?$/,h=["<",">",'"',"`"," ","\r","\n","	"],d=["{","}","|","\\","^","`"].concat(h),m=["'"].concat(d),y=["%","/","?",";","#"].concat(m),v=["/","?","#"],g=255,A=/^[+a-z0-9A-Z_-]{0,63}$/,E=/^([+a-z0-9A-Z_-]{0,63})(.*)$/,_={javascript:!0,"javascript:":!0},T={javascript:!0,"javascript:":!0},N={http:!0,https:!0,ftp:!0,gopher:!0,file:!0,"http:":!0,"https:":!0,"ftp:":!0,"gopher:":!0,"file:":!0},S=n(12);r.prototype.parse=function(e,t,n){if(!l.isString(e))throw new TypeError("Parameter 'url' must be a string, not "+typeof e);var r=e.indexOf("?"),i=-1!==r&&r<e.indexOf("#")?"?":"#",a=e.split(i),o=/\\/g;a[0]=a[0].replace(o,"/"),e=a.join(i);var s=e;if(s=s.trim(),!n&&1===e.split("#").length){var c=f.exec(s);if(c)return this.path=s,this.href=s,this.pathname=c[1],c[2]?(this.search=c[2],t?this.query=S.parse(this.search.substr(1)):this.query=this.search.substr(1)):t&&(this.search="",this.query={}),this}var h=p.exec(s);if(h){h=h[0];var d=h.toLowerCase();this.protocol=d,s=s.substr(h.length)}if(n||h||s.match(/^\/\/[^@\/]+@[^@\/]+/)){var b="//"===s.substr(0,2);!b||h&&T[h]||(s=s.substr(2),this.slashes=!0)}if(!T[h]&&(b||h&&!N[h])){for(var I=-1,R=0;R<v.length;R++){var M=s.indexOf(v[R]);-1!==M&&(-1===I||I>M)&&(I=M)}var w,C;C=-1===I?s.lastIndexOf("@"):s.lastIndexOf("@",I),-1!==C&&(w=s.slice(0,C),s=s.slice(C+1),this.auth=decodeURIComponent(w)),I=-1;for(var R=0;R<y.length;R++){var M=s.indexOf(y[R]);-1!==M&&(-1===I||I>M)&&(I=M)}-1===I&&(I=s.length),this.host=s.slice(0,I),s=s.slice(I),this.parseHost(),this.hostname=this.hostname||"";var L="["===this.hostname[0]&&"]"===this.hostname[this.hostname.length-1];if(!L)for(var P=this.hostname.split(/\./),R=0,O=P.length;O>R;R++){var D=P[R];if(D&&!D.match(A)){for(var U="",x=0,k=D.length;k>x;x++)U+=D.charCodeAt(x)>127?"x":D[x];if(!U.match(A)){var F=P.slice(0,R),B=P.slice(R+1),V=D.match(E);V&&(F.push(V[1]),B.unshift(V[2])),B.length&&(s="/"+B.join(".")+s),this.hostname=F.join(".");break}}}this.hostname.length>g?this.hostname="":this.hostname=this.hostname.toLowerCase(),L||(this.hostname=u.toASCII(this.hostname));var K=this.port?":"+this.port:"",j=this.hostname||"";this.host=j+K,this.href+=this.host,L&&(this.hostname=this.hostname.substr(1,this.hostname.length-2),"/"!==s[0]&&(s="/"+s))}if(!_[d])for(var R=0,O=m.length;O>R;R++){var W=m[R];if(-1!==s.indexOf(W)){var H=encodeURIComponent(W);H===W&&(H=escape(W)),s=s.split(W).join(H)}}var Y=s.indexOf("#");-1!==Y&&(this.hash=s.substr(Y),s=s.slice(0,Y));var q=s.indexOf("?");if(-1!==q?(this.search=s.substr(q),this.query=s.substr(q+1),t&&(this.query=S.parse(this.query)),s=s.slice(0,q)):t&&(this.search="",this.query={}),s&&(this.pathname=s),N[d]&&this.hostname&&!this.pathname&&(this.pathname="/"),this.pathname||this.search){var K=this.pathname||"",G=this.search||"";this.path=K+G}return this.href=this.format(),this},r.prototype.format=function(){var e=this.auth||"";e&&(e=encodeURIComponent(e),e=e.replace(/%3A/i,":"),e+="@");var t=this.protocol||"",n=this.pathname||"",r=this.hash||"",i=!1,a="";this.host?i=e+this.host:this.hostname&&(i=e+(-1===this.hostname.indexOf(":")?this.hostname:"["+this.hostname+"]"),this.port&&(i+=":"+this.port)),this.query&&l.isObject(this.query)&&Object.keys(this.query).length&&(a=S.stringify(this.query));var o=this.search||a&&"?"+a||"";return t&&":"!==t.substr(-1)&&(t+=":"),this.slashes||(!t||N[t])&&i!==!1?(i="//"+(i||""),n&&"/"!==n.charAt(0)&&(n="/"+n)):i||(i=""),r&&"#"!==r.charAt(0)&&(r="#"+r),o&&"?"!==o.charAt(0)&&(o="?"+o),n=n.replace(/[?#]/g,function(e){return encodeURIComponent(e)}),o=o.replace("#","%23"),t+i+n+o+r},r.prototype.resolve=function(e){return this.resolveObject(i(e,!1,!0)).format()},r.prototype.resolveObject=function(e){if(l.isString(e)){var t=new r;t.parse(e,!1,!0),e=t}for(var n=new r,i=Object.keys(this),a=0;a<i.length;a++){var o=i[a];n[o]=this[o]}if(n.hash=e.hash,""===e.href)return n.href=n.format(),n;if(e.slashes&&!e.protocol){for(var s=Object.keys(e),u=0;u<s.length;u++){var p=s[u];"protocol"!==p&&(n[p]=e[p])}return N[n.protocol]&&n.hostname&&!n.pathname&&(n.path=n.pathname="/"),n.href=n.format(),n}if(e.protocol&&e.protocol!==n.protocol){if(!N[e.protocol]){for(var c=Object.keys(e),f=0;f<c.length;f++){var h=c[f];n[h]=e[h]}return n.href=n.format(),n}if(n.protocol=e.protocol,e.host||T[e.protocol])n.pathname=e.pathname;else{for(var d=(e.pathname||"").split("/");d.length&&!(e.host=d.shift()););e.host||(e.host=""),e.hostname||(e.hostname=""),""!==d[0]&&d.unshift(""),d.length<2&&d.unshift(""),n.pathname=d.join("/")}if(n.search=e.search,n.query=e.query,n.host=e.host||"",n.auth=e.auth,n.hostname=e.hostname||e.host,n.port=e.port,n.pathname||n.search){var m=n.pathname||"",y=n.search||"";n.path=m+y}return n.slashes=n.slashes||e.slashes,n.href=n.format(),n}var v=n.pathname&&"/"===n.pathname.charAt(0),g=e.host||e.pathname&&"/"===e.pathname.charAt(0),A=g||v||n.host&&e.pathname,E=A,_=n.pathname&&n.pathname.split("/")||[],d=e.pathname&&e.pathname.split("/")||[],S=n.protocol&&!N[n.protocol];if(S&&(n.hostname="",n.port=null,n.host&&(""===_[0]?_[0]=n.host:_.unshift(n.host)),n.host="",e.protocol&&(e.hostname=null,e.port=null,e.host&&(""===d[0]?d[0]=e.host:d.unshift(e.host)),e.host=null),A=A&&(""===d[0]||""===_[0])),g)n.host=e.host||""===e.host?e.host:n.host,n.hostname=e.hostname||""===e.hostname?e.hostname:n.hostname,n.search=e.search,n.query=e.query,_=d;else if(d.length)_||(_=[]),_.pop(),_=_.concat(d),n.search=e.search,n.query=e.query;else if(!l.isNullOrUndefined(e.search)){if(S){n.hostname=n.host=_.shift();var b=!!(n.host&&n.host.indexOf("@")>0)&&n.host.split("@");b&&(n.auth=b.shift(),n.host=n.hostname=b.shift())}return n.search=e.search,n.query=e.query,l.isNull(n.pathname)&&l.isNull(n.search)||(n.path=(n.pathname?n.pathname:"")+(n.search?n.search:"")),n.href=n.format(),n}if(!_.length)return n.pathname=null,n.search?n.path="/"+n.search:n.path=null,n.href=n.format(),n;for(var I=_.slice(-1)[0],R=(n.host||e.host||_.length>1)&&("."===I||".."===I)||""===I,M=0,w=_.length;w>=0;w--)I=_[w],"."===I?_.splice(w,1):".."===I?(_.splice(w,1),M++):M&&(_.splice(w,1),M--);if(!A&&!E)for(;M--;M)_.unshift("..");!A||""===_[0]||_[0]&&"/"===_[0].charAt(0)||_.unshift(""),R&&"/"!==_.join("/").substr(-1)&&_.push("");var C=""===_[0]||_[0]&&"/"===_[0].charAt(0);if(S){n.hostname=n.host=C?"":_.length?_.shift():"";var b=!!(n.host&&n.host.indexOf("@")>0)&&n.host.split("@");b&&(n.auth=b.shift(),n.host=n.hostname=b.shift())}return A=A||n.host&&_.length,A&&!C&&_.unshift(""),_.length?n.pathname=_.join("/"):(n.pathname=null,n.path=null),l.isNull(n.pathname)&&l.isNull(n.search)||(n.path=(n.pathname?n.pathname:"")+(n.search?n.search:"")),n.auth=e.auth||n.auth,n.slashes=n.slashes||e.slashes,n.href=n.format(),n},r.prototype.parseHost=function(){var e=this.host,t=c.exec(e);t&&(t=t[0],":"!==t&&(this.port=t.substr(1)),e=e.substr(0,e.length-t.length)),e&&(this.hostname=e)}},function(e,t,n){var r;(function(e,i){!function(a){function o(e){throw RangeError(P[e])}function s(e,t){for(var n=e.length,r=[];n--;)r[n]=t(e[n]);return r}function u(e,t){var n=e.split("@"),r="";n.length>1&&(r=n[0]+"@",e=n[1]),e=e.replace(L,".");var i=e.split("."),a=s(i,t).join(".");return r+a}function l(e){for(var t,n,r=[],i=0,a=e.length;a>i;)t=e.charCodeAt(i++),t>=55296&&56319>=t&&a>i?(n=e.charCodeAt(i++),56320==(64512&n)?r.push(((1023&t)<<10)+(1023&n)+65536):(r.push(t),i--)):r.push(t);return r}function p(e){return s(e,function(e){var t="";return e>65535&&(e-=65536,t+=U(e>>>10&1023|55296),e=56320|1023&e),t+=U(e)}).join("")}function c(e){return 10>e-48?e-22:26>e-65?e-65:26>e-97?e-97:_}function f(e,t){return e+22+75*(26>e)-((0!=t)<<5)}function h(e,t,n){var r=0;for(e=n?D(e/b):e>>1,e+=D(e/t);e>O*N>>1;r+=_)e=D(e/O);return D(r+(O+1)*e/(e+S))}function d(e){var t,n,r,i,a,s,u,l,f,d,m=[],y=e.length,v=0,g=R,A=I;for(n=e.lastIndexOf(M),0>n&&(n=0),r=0;n>r;++r)e.charCodeAt(r)>=128&&o("not-basic"),m.push(e.charCodeAt(r));for(i=n>0?n+1:0;y>i;){for(a=v,s=1,u=_;i>=y&&o("invalid-input"),l=c(e.charCodeAt(i++)),(l>=_||l>D((E-v)/s))&&o("overflow"),v+=l*s,f=A>=u?T:u>=A+N?N:u-A,!(f>l);u+=_)d=_-f,s>D(E/d)&&o("overflow"),s*=d;t=m.length+1,A=h(v-a,t,0==a),D(v/t)>E-g&&o("overflow"),g+=D(v/t),v%=t,m.splice(v++,0,g)}return p(m)}function m(e){var t,n,r,i,a,s,u,p,c,d,m,y,v,g,A,S=[];for(e=l(e),y=e.length,t=R,n=0,a=I,s=0;y>s;++s)m=e[s],128>m&&S.push(U(m));for(r=i=S.length,i&&S.push(M);y>r;){for(u=E,s=0;y>s;++s)m=e[s],m>=t&&u>m&&(u=m);for(v=r+1,u-t>D((E-n)/v)&&o("overflow"),n+=(u-t)*v,t=u,s=0;y>s;++s)if(m=e[s],t>m&&++n>E&&o("overflow"),m==t){for(p=n,c=_;d=a>=c?T:c>=a+N?N:c-a,!(d>p);c+=_)A=p-d,g=_-d,S.push(U(f(d+A%g,0))),p=D(A/g);S.push(U(f(p,0))),a=h(n,v,r==i),n=0,++r}++n,++t}return S.join("")}function y(e){return u(e,function(e){return w.test(e)?d(e.slice(4).toLowerCase()):e})}function v(e){return u(e,function(e){return C.test(e)?"xn--"+m(e):e})}var g=("object"==typeof t&&t&&!t.nodeType&&t,"object"==typeof e&&e&&!e.nodeType&&e,"object"==typeof i&&i);g.global!==g&&g.window!==g&&g.self!==g||(a=g);var A,E=2147483647,_=36,T=1,N=26,S=38,b=700,I=72,R=128,M="-",w=/^xn--/,C=/[^\x20-\x7E]/,L=/[\x2E\u3002\uFF0E\uFF61]/g,P={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},O=_-T,D=Math.floor,U=String.fromCharCode;A={version:"1.3.2",ucs2:{decode:l,encode:p},decode:d,encode:m,toASCII:v,toUnicode:y},r=function(){return A}.call(t,n,t,e),!(void 0!==r&&(e.exports=r))}(this)}).call(t,n(10)(e),function(){return this}())},function(e,t){e.exports=function(e){return e.webpackPolyfill||(e.deprecate=function(){},e.paths=[],e.children=[],e.webpackPolyfill=1),e}},function(e,t){"use strict";e.exports={isString:function(e){return"string"==typeof e},isObject:function(e){return"object"==typeof e&&null!==e},isNull:function(e){return null===e},isNullOrUndefined:function(e){return null==e}}},function(e,t,n){"use strict";t.decode=t.parse=n(13),t.encode=t.stringify=n(14)},function(e,t){"use strict";function n(e,t){return Object.prototype.hasOwnProperty.call(e,t)}e.exports=function(e,t,r,i){t=t||"&",r=r||"=";var a={};if("string"!=typeof e||0===e.length)return a;var o=/\+/g;e=e.split(t);var s=1e3;i&&"number"==typeof i.maxKeys&&(s=i.maxKeys);var u=e.length;s>0&&u>s&&(u=s);for(var l=0;u>l;++l){var p,c,f,h,d=e[l].replace(o,"%20"),m=d.indexOf(r);m>=0?(p=d.substr(0,m),c=d.substr(m+1)):(p=d,c=""),f=decodeURIComponent(p),h=decodeURIComponent(c),n(a,f)?Array.isArray(a[f])?a[f].push(h):a[f]=[a[f],h]:a[f]=h}return a}},function(e,t){"use strict";var n=function(e){switch(typeof e){case"string":return e;case"boolean":return e?"true":"false";case"number":return isFinite(e)?e:"";default:return""}};e.exports=function(e,t,r,i){return t=t||"&",r=r||"=",null===e&&(e=void 0),"object"==typeof e?Object.keys(e).map(function(i){var a=encodeURIComponent(n(i))+r;return Array.isArray(e[i])?e[i].map(function(e){return a+encodeURIComponent(n(e))}).join(t):a+encodeURIComponent(n(e[i]))}).join(t):i?encodeURIComponent(n(i))+r+encodeURIComponent(n(e)):""}},function(e,t,n){"use strict";function r(e){var t={};return e.forEach(function(e){return Object.keys(e).forEach(function(n){return t[n]=e[n]})}),t}function i(e,t){return new b(S.find(e||[],t))}function a(e){return Object.keys(e).map(function(t){return[t,e[t]]})}function o(e){var t={};return e.forEach(function(e){return t[e[0]]=e[1]}),t}function s(e,t){return t(e),e}function u(e,t){"object"==typeof e&&Object.keys(e).forEach(function(n){return t(n,e[n])})}function l(e,n,r){void 0===r&&(r=!1);var i={};return e.forEach(function(e){var a=t.shallowCopy(e);r&&delete a[n],i[e[n]]=a}),i}function p(e,t){var n=e.length-t.length;return n>=0&&e.lastIndexOf(t)===n}function c(e,t,n){return void 0===n&&(n=0),e.length-t.length>=n&&e.substring(n,n+t.length)===t}function f(e){return"_"==e[e.length-1]}function h(e,t,n){var r,i=!1;e[t]=function(){return i||(i=!0,r=n.apply(e)),r}}function d(e,n){void 0===n&&(n=f);for(var r in e)n(r)&&t.ifInstanceOf(e[r],Function,function(t){return 0===t.length?h(e,r,t):null})}function m(e,t){void 0!==e&&t(e)}function y(e){return"string"==typeof e&&""!=e&&p(e,".raml")}function v(e){for(var t,n=[],r=new RegExp("require\\('([^']+)'\\)","gi");t=r.exec(e);)n.push(t[1]);for(var i=new RegExp('require\\("([^"]+)"\\)',"gi");t=i.exec(e);)n.push(t[1]);return n=S.unique(n).filter(function(e){return""!=e}),n.sort(),n}function g(e){return"undefined"!=typeof e&&null!=e}function A(e){return 0==e.length?e:e.charAt(0).toUpperCase()+e.substr(1)}function E(e,t,n){void 0===n&&(n=!1);var r=Object.keys(t);if(n){var i={};r.forEach(function(e){return i[e]=!0}),Object.keys(e).forEach(function(e){return i[e]=!0}),r=Object.keys(i)}r.forEach(function(n){var r=e[n];r instanceof Object?(t[n]||(t[n]={}),E(r,t[n],!0)):void 0!=r&&(t[n]=e[n])})}function _(e,t){return Object.keys(t).forEach(function(n){return e=T(e,n,t[n])}),e}function T(e,t,n){for(var r="",i=0,a=e.indexOf(t);a<e.length&&a>=0;a=e.indexOf(t,i))r+=e.substring(i,a),r+=n,i=a+t.length;return r+=e.substring(i,e.length)}function N(e){if(null==e||"object"!=typeof e)return e;var t;if(Array.isArray(e)){t=[];for(var n=0,r=e;n<r.length;n++){var i=r[n];t.push(N(i))}}else{t={};for(var a=0,o=Object.keys(e);a<o.length;a++){var s=o[a];t[s]=N(e[s])}}return t}Object.defineProperty(t,"__esModule",{value:!0});var S=n(16),b=n(17);t.defined=function(e){return null!==e&&void 0!==e},t.flattenArrayOfObjects=r,t.find=i,t.isInstance=function(e,t){return e instanceof t?[e]:[]},t.ifInstanceOf=function(e,t,n){return e instanceof t?n(e):null},t.toTuples=a,t.fromTuples=o,t.collectInstancesOf=function(e,n){return s([],function(r){return e.forEach(function(e){return t.ifInstanceOf(e,n,function(e){return r.push(e)})})})},t.collectInstancesOfInMap=function(e,t){return Object.keys(e).map(function(t){return[t,e[t]]}).filter(function(e){return e[1]instanceof t}).map(function(e){return e})},t.asArray=function(e){return t.defined(e)?e instanceof Array?e:[e]:[]},t.shallowCopy=function(e){return s({},function(t){return Object.keys(e).forEach(function(n){return t[n]=e[n]})})},t.flatMap=function(e,n){return t.flatten(e.map(n))},t.flatten=function(e){return Array.prototype.concat.apply([],e)},t.takeWhile=function(e,t){return s([],function(n){for(var r=0;r<e.length&&t(e[r]);r++)n.push(e[r])})},t.tap=s,t.kv=u,t.indexed=l,t.stringEndsWith=p,t.stringStartsWith=c,t.lazypropkeyfilter=f,t.lazyprops=d,t.iff=m,t.isRAMLUrl=y,t.getAllRequiredExternalModulesFromCode=v,t.serial=function(){var e=0;return function(){return e++}}(),t.isEssential=g,t.firstToUpper=A,t.updateObject=E,t.replaceMap=_,t.replace=T,t.deepCopy=N},function(e,t,n){var r,i;(function(){function n(e){function t(t,n,r,i,a,o){for(;a>=0&&o>a;a+=e){var s=i?i[a]:a;r=n(r,t[s],s,t)}return r}return function(n,r,i,a){r=N(r,a,4);var o=!C(n)&&T.keys(n),s=(o||n).length,u=e>0?0:s-1;return arguments.length<3&&(i=n[o?o[u]:u],u+=e),t(n,r,i,o,u,s)}}function a(e){return function(t,n,r){n=S(n,r);for(var i=w(t),a=e>0?0:i-1;a>=0&&i>a;a+=e)if(n(t[a],a,t))return a;return-1}}function o(e,t,n){return function(r,i,a){var o=0,s=w(r);if("number"==typeof a)e>0?o=a>=0?a:Math.max(a+s,o):s=a>=0?Math.min(a+1,s):a+s+1;else if(n&&a&&s)return a=n(r,i),r[a]===i?a:-1;if(i!==i)return a=t(d.call(r,o,s),T.isNaN),a>=0?a+o:-1;for(a=e>0?o:s-1;a>=0&&s>a;a+=e)if(r[a]===i)return a;return-1}}function s(e,t){var n=U.length,r=e.constructor,i=T.isFunction(r)&&r.prototype||c,a="constructor";for(T.has(e,a)&&!T.contains(t,a)&&t.push(a);n--;)a=U[n],a in e&&e[a]!==i[a]&&!T.contains(t,a)&&t.push(a)}var u=this,l=u._,p=Array.prototype,c=Object.prototype,f=Function.prototype,h=p.push,d=p.slice,m=c.toString,y=c.hasOwnProperty,v=Array.isArray,g=Object.keys,A=f.bind,E=Object.create,_=function(){},T=function(e){return e instanceof T?e:this instanceof T?void(this._wrapped=e):new T(e)};"undefined"!=typeof e&&e.exports&&(t=e.exports=T),t._=T,T.VERSION="1.8.3";var N=function(e,t,n){if(void 0===t)return e;switch(null==n?3:n){case 1:return function(n){return e.call(t,n)};case 2:return function(n,r){return e.call(t,n,r)};case 3:return function(n,r,i){return e.call(t,n,r,i)};case 4:return function(n,r,i,a){return e.call(t,n,r,i,a)}}return function(){return e.apply(t,arguments)}},S=function(e,t,n){return null==e?T.identity:T.isFunction(e)?N(e,t,n):T.isObject(e)?T.matcher(e):T.property(e)};T.iteratee=function(e,t){return S(e,t,1/0)};var b=function(e,t){return function(n){var r=arguments.length;if(2>r||null==n)return n;for(var i=1;r>i;i++)for(var a=arguments[i],o=e(a),s=o.length,u=0;s>u;u++){var l=o[u];t&&void 0!==n[l]||(n[l]=a[l])}return n}},I=function(e){if(!T.isObject(e))return{};if(E)return E(e);_.prototype=e;var t=new _;return _.prototype=null,t},R=function(e){return function(t){return null==t?void 0:t[e]}},M=Math.pow(2,53)-1,w=R("length"),C=function(e){var t=w(e);return"number"==typeof t&&t>=0&&M>=t};T.each=T.forEach=function(e,t,n){t=N(t,n);var r,i;if(C(e))for(r=0,i=e.length;i>r;r++)t(e[r],r,e);else{var a=T.keys(e);for(r=0,i=a.length;i>r;r++)t(e[a[r]],a[r],e)}return e},T.map=T.collect=function(e,t,n){t=S(t,n);for(var r=!C(e)&&T.keys(e),i=(r||e).length,a=Array(i),o=0;i>o;o++){var s=r?r[o]:o;a[o]=t(e[s],s,e)}return a},T.reduce=T.foldl=T.inject=n(1),T.reduceRight=T.foldr=n(-1),T.find=T.detect=function(e,t,n){var r;return r=C(e)?T.findIndex(e,t,n):T.findKey(e,t,n),void 0!==r&&-1!==r?e[r]:void 0},T.filter=T.select=function(e,t,n){var r=[];return t=S(t,n),T.each(e,function(e,n,i){t(e,n,i)&&r.push(e)}),r},T.reject=function(e,t,n){return T.filter(e,T.negate(S(t)),n)},T.every=T.all=function(e,t,n){t=S(t,n);for(var r=!C(e)&&T.keys(e),i=(r||e).length,a=0;i>a;a++){var o=r?r[a]:a;if(!t(e[o],o,e))return!1}return!0},T.some=T.any=function(e,t,n){t=S(t,n);for(var r=!C(e)&&T.keys(e),i=(r||e).length,a=0;i>a;a++){var o=r?r[a]:a;if(t(e[o],o,e))return!0}return!1},T.contains=T.includes=T.include=function(e,t,n,r){return C(e)||(e=T.values(e)),("number"!=typeof n||r)&&(n=0),T.indexOf(e,t,n)>=0},T.invoke=function(e,t){var n=d.call(arguments,2),r=T.isFunction(t);return T.map(e,function(e){var i=r?t:e[t];return null==i?i:i.apply(e,n)})},T.pluck=function(e,t){return T.map(e,T.property(t))},T.where=function(e,t){return T.filter(e,T.matcher(t))},T.findWhere=function(e,t){return T.find(e,T.matcher(t))},T.max=function(e,t,n){var r,i,a=-(1/0),o=-(1/0);if(null==t&&null!=e){e=C(e)?e:T.values(e);for(var s=0,u=e.length;u>s;s++)r=e[s],r>a&&(a=r)}else t=S(t,n),T.each(e,function(e,n,r){i=t(e,n,r),(i>o||i===-(1/0)&&a===-(1/0))&&(a=e,o=i)});return a},T.min=function(e,t,n){var r,i,a=1/0,o=1/0;if(null==t&&null!=e){e=C(e)?e:T.values(e);for(var s=0,u=e.length;u>s;s++)r=e[s],a>r&&(a=r)}else t=S(t,n),T.each(e,function(e,n,r){i=t(e,n,r),(o>i||i===1/0&&a===1/0)&&(a=e,o=i)});return a},T.shuffle=function(e){for(var t,n=C(e)?e:T.values(e),r=n.length,i=Array(r),a=0;r>a;a++)t=T.random(0,a),t!==a&&(i[a]=i[t]),i[t]=n[a];return i},T.sample=function(e,t,n){return null==t||n?(C(e)||(e=T.values(e)),e[T.random(e.length-1)]):T.shuffle(e).slice(0,Math.max(0,t))},T.sortBy=function(e,t,n){return t=S(t,n),T.pluck(T.map(e,function(e,n,r){return{value:e,index:n,criteria:t(e,n,r)}}).sort(function(e,t){var n=e.criteria,r=t.criteria;if(n!==r){if(n>r||void 0===n)return 1;if(r>n||void 0===r)return-1}return e.index-t.index}),"value")};var L=function(e){return function(t,n,r){var i={};return n=S(n,r),T.each(t,function(r,a){var o=n(r,a,t);e(i,r,o)}),i}};T.groupBy=L(function(e,t,n){T.has(e,n)?e[n].push(t):e[n]=[t]}),T.indexBy=L(function(e,t,n){e[n]=t}),T.countBy=L(function(e,t,n){T.has(e,n)?e[n]++:e[n]=1}),T.toArray=function(e){return e?T.isArray(e)?d.call(e):C(e)?T.map(e,T.identity):T.values(e):[]},T.size=function(e){return null==e?0:C(e)?e.length:T.keys(e).length},T.partition=function(e,t,n){t=S(t,n);var r=[],i=[];return T.each(e,function(e,n,a){(t(e,n,a)?r:i).push(e)}),[r,i]},T.first=T.head=T.take=function(e,t,n){return null!=e?null==t||n?e[0]:T.initial(e,e.length-t):void 0},T.initial=function(e,t,n){return d.call(e,0,Math.max(0,e.length-(null==t||n?1:t)))},T.last=function(e,t,n){return null!=e?null==t||n?e[e.length-1]:T.rest(e,Math.max(0,e.length-t)):void 0},T.rest=T.tail=T.drop=function(e,t,n){return d.call(e,null==t||n?1:t)},T.compact=function(e){return T.filter(e,T.identity)};var P=function(e,t,n,r){for(var i=[],a=0,o=r||0,s=w(e);s>o;o++){var u=e[o];if(C(u)&&(T.isArray(u)||T.isArguments(u))){t||(u=P(u,t,n));var l=0,p=u.length;for(i.length+=p;p>l;)i[a++]=u[l++]}else n||(i[a++]=u)}return i};T.flatten=function(e,t){return P(e,t,!1)},T.without=function(e){return T.difference(e,d.call(arguments,1))},T.uniq=T.unique=function(e,t,n,r){T.isBoolean(t)||(r=n,n=t,t=!1),null!=n&&(n=S(n,r));for(var i=[],a=[],o=0,s=w(e);s>o;o++){var u=e[o],l=n?n(u,o,e):u;t?(o&&a===l||i.push(u),a=l):n?T.contains(a,l)||(a.push(l),i.push(u)):T.contains(i,u)||i.push(u)}return i},T.union=function(){return T.uniq(P(arguments,!0,!0))},T.intersection=function(e){for(var t=[],n=arguments.length,r=0,i=w(e);i>r;r++){var a=e[r];if(!T.contains(t,a)){for(var o=1;n>o&&T.contains(arguments[o],a);o++);o===n&&t.push(a)}}return t},T.difference=function(e){var t=P(arguments,!0,!0,1);return T.filter(e,function(e){return!T.contains(t,e)})},T.zip=function(){return T.unzip(arguments)},T.unzip=function(e){for(var t=e&&T.max(e,w).length||0,n=Array(t),r=0;t>r;r++)n[r]=T.pluck(e,r);return n},T.object=function(e,t){for(var n={},r=0,i=w(e);i>r;r++)t?n[e[r]]=t[r]:n[e[r][0]]=e[r][1];return n},T.findIndex=a(1),T.findLastIndex=a(-1),T.sortedIndex=function(e,t,n,r){n=S(n,r,1);for(var i=n(t),a=0,o=w(e);o>a;){var s=Math.floor((a+o)/2);n(e[s])<i?a=s+1:o=s}return a},T.indexOf=o(1,T.findIndex,T.sortedIndex),T.lastIndexOf=o(-1,T.findLastIndex),T.range=function(e,t,n){null==t&&(t=e||0,e=0),n=n||1;for(var r=Math.max(Math.ceil((t-e)/n),0),i=Array(r),a=0;r>a;a++,e+=n)i[a]=e;return i};var O=function(e,t,n,r,i){if(!(r instanceof t))return e.apply(n,i);var a=I(e.prototype),o=e.apply(a,i);return T.isObject(o)?o:a};T.bind=function(e,t){if(A&&e.bind===A)return A.apply(e,d.call(arguments,1));if(!T.isFunction(e))throw new TypeError("Bind must be called on a function");var n=d.call(arguments,2),r=function(){return O(e,r,t,this,n.concat(d.call(arguments)))};return r},T.partial=function(e){var t=d.call(arguments,1),n=function(){for(var r=0,i=t.length,a=Array(i),o=0;i>o;o++)a[o]=t[o]===T?arguments[r++]:t[o];for(;r<arguments.length;)a.push(arguments[r++]);return O(e,n,this,this,a)};return n},T.bindAll=function(e){var t,n,r=arguments.length;if(1>=r)throw new Error("bindAll must be passed function names");for(t=1;r>t;t++)n=arguments[t],e[n]=T.bind(e[n],e);return e},T.memoize=function(e,t){
var n=function(r){var i=n.cache,a=""+(t?t.apply(this,arguments):r);return T.has(i,a)||(i[a]=e.apply(this,arguments)),i[a]};return n.cache={},n},T.delay=function(e,t){var n=d.call(arguments,2);return setTimeout(function(){return e.apply(null,n)},t)},T.defer=T.partial(T.delay,T,1),T.throttle=function(e,t,n){var r,i,a,o=null,s=0;n||(n={});var u=function(){s=n.leading===!1?0:T.now(),o=null,a=e.apply(r,i),o||(r=i=null)};return function(){var l=T.now();s||n.leading!==!1||(s=l);var p=t-(l-s);return r=this,i=arguments,0>=p||p>t?(o&&(clearTimeout(o),o=null),s=l,a=e.apply(r,i),o||(r=i=null)):o||n.trailing===!1||(o=setTimeout(u,p)),a}},T.debounce=function(e,t,n){var r,i,a,o,s,u=function(){var l=T.now()-o;t>l&&l>=0?r=setTimeout(u,t-l):(r=null,n||(s=e.apply(a,i),r||(a=i=null)))};return function(){a=this,i=arguments,o=T.now();var l=n&&!r;return r||(r=setTimeout(u,t)),l&&(s=e.apply(a,i),a=i=null),s}},T.wrap=function(e,t){return T.partial(t,e)},T.negate=function(e){return function(){return!e.apply(this,arguments)}},T.compose=function(){var e=arguments,t=e.length-1;return function(){for(var n=t,r=e[t].apply(this,arguments);n--;)r=e[n].call(this,r);return r}},T.after=function(e,t){return function(){return--e<1?t.apply(this,arguments):void 0}},T.before=function(e,t){var n;return function(){return--e>0&&(n=t.apply(this,arguments)),1>=e&&(t=null),n}},T.once=T.partial(T.before,2);var D=!{toString:null}.propertyIsEnumerable("toString"),U=["valueOf","isPrototypeOf","toString","propertyIsEnumerable","hasOwnProperty","toLocaleString"];T.keys=function(e){if(!T.isObject(e))return[];if(g)return g(e);var t=[];for(var n in e)T.has(e,n)&&t.push(n);return D&&s(e,t),t},T.allKeys=function(e){if(!T.isObject(e))return[];var t=[];for(var n in e)t.push(n);return D&&s(e,t),t},T.values=function(e){for(var t=T.keys(e),n=t.length,r=Array(n),i=0;n>i;i++)r[i]=e[t[i]];return r},T.mapObject=function(e,t,n){t=S(t,n);for(var r,i=T.keys(e),a=i.length,o={},s=0;a>s;s++)r=i[s],o[r]=t(e[r],r,e);return o},T.pairs=function(e){for(var t=T.keys(e),n=t.length,r=Array(n),i=0;n>i;i++)r[i]=[t[i],e[t[i]]];return r},T.invert=function(e){for(var t={},n=T.keys(e),r=0,i=n.length;i>r;r++)t[e[n[r]]]=n[r];return t},T.functions=T.methods=function(e){var t=[];for(var n in e)T.isFunction(e[n])&&t.push(n);return t.sort()},T.extend=b(T.allKeys),T.extendOwn=T.assign=b(T.keys),T.findKey=function(e,t,n){t=S(t,n);for(var r,i=T.keys(e),a=0,o=i.length;o>a;a++)if(r=i[a],t(e[r],r,e))return r},T.pick=function(e,t,n){var r,i,a={},o=e;if(null==o)return a;T.isFunction(t)?(i=T.allKeys(o),r=N(t,n)):(i=P(arguments,!1,!1,1),r=function(e,t,n){return t in n},o=Object(o));for(var s=0,u=i.length;u>s;s++){var l=i[s],p=o[l];r(p,l,o)&&(a[l]=p)}return a},T.omit=function(e,t,n){if(T.isFunction(t))t=T.negate(t);else{var r=T.map(P(arguments,!1,!1,1),String);t=function(e,t){return!T.contains(r,t)}}return T.pick(e,t,n)},T.defaults=b(T.allKeys,!0),T.create=function(e,t){var n=I(e);return t&&T.extendOwn(n,t),n},T.clone=function(e){return T.isObject(e)?T.isArray(e)?e.slice():T.extend({},e):e},T.tap=function(e,t){return t(e),e},T.isMatch=function(e,t){var n=T.keys(t),r=n.length;if(null==e)return!r;for(var i=Object(e),a=0;r>a;a++){var o=n[a];if(t[o]!==i[o]||!(o in i))return!1}return!0};var x=function(e,t,n,r){if(e===t)return 0!==e||1/e===1/t;if(null==e||null==t)return e===t;e instanceof T&&(e=e._wrapped),t instanceof T&&(t=t._wrapped);var i=m.call(e);if(i!==m.call(t))return!1;switch(i){case"[object RegExp]":case"[object String]":return""+e==""+t;case"[object Number]":return+e!==+e?+t!==+t:0===+e?1/+e===1/t:+e===+t;case"[object Date]":case"[object Boolean]":return+e===+t}var a="[object Array]"===i;if(!a){if("object"!=typeof e||"object"!=typeof t)return!1;var o=e.constructor,s=t.constructor;if(o!==s&&!(T.isFunction(o)&&o instanceof o&&T.isFunction(s)&&s instanceof s)&&"constructor"in e&&"constructor"in t)return!1}n=n||[],r=r||[];for(var u=n.length;u--;)if(n[u]===e)return r[u]===t;if(n.push(e),r.push(t),a){if(u=e.length,u!==t.length)return!1;for(;u--;)if(!x(e[u],t[u],n,r))return!1}else{var l,p=T.keys(e);if(u=p.length,T.keys(t).length!==u)return!1;for(;u--;)if(l=p[u],!T.has(t,l)||!x(e[l],t[l],n,r))return!1}return n.pop(),r.pop(),!0};T.isEqual=function(e,t){return x(e,t)},T.isEmpty=function(e){return null==e||(C(e)&&(T.isArray(e)||T.isString(e)||T.isArguments(e))?0===e.length:0===T.keys(e).length)},T.isElement=function(e){return!(!e||1!==e.nodeType)},T.isArray=v||function(e){return"[object Array]"===m.call(e)},T.isObject=function(e){var t=typeof e;return"function"===t||"object"===t&&!!e},T.each(["Arguments","Function","String","Number","Date","RegExp","Error"],function(e){T["is"+e]=function(t){return m.call(t)==="[object "+e+"]"}}),T.isArguments(arguments)||(T.isArguments=function(e){return T.has(e,"callee")}),"function"!=typeof/./&&"object"!=typeof Int8Array&&(T.isFunction=function(e){return"function"==typeof e||!1}),T.isFinite=function(e){return isFinite(e)&&!isNaN(parseFloat(e))},T.isNaN=function(e){return T.isNumber(e)&&e!==+e},T.isBoolean=function(e){return e===!0||e===!1||"[object Boolean]"===m.call(e)},T.isNull=function(e){return null===e},T.isUndefined=function(e){return void 0===e},T.has=function(e,t){return null!=e&&y.call(e,t)},T.noConflict=function(){return u._=l,this},T.identity=function(e){return e},T.constant=function(e){return function(){return e}},T.noop=function(){},T.property=R,T.propertyOf=function(e){return null==e?function(){}:function(t){return e[t]}},T.matcher=T.matches=function(e){return e=T.extendOwn({},e),function(t){return T.isMatch(t,e)}},T.times=function(e,t,n){var r=Array(Math.max(0,e));t=N(t,n,1);for(var i=0;e>i;i++)r[i]=t(i);return r},T.random=function(e,t){return null==t&&(t=e,e=0),e+Math.floor(Math.random()*(t-e+1))},T.now=Date.now||function(){return(new Date).getTime()};var k={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},F=T.invert(k),B=function(e){var t=function(t){return e[t]},n="(?:"+T.keys(e).join("|")+")",r=RegExp(n),i=RegExp(n,"g");return function(e){return e=null==e?"":""+e,r.test(e)?e.replace(i,t):e}};T.escape=B(k),T.unescape=B(F),T.result=function(e,t,n){var r=null==e?void 0:e[t];return void 0===r&&(r=n),T.isFunction(r)?r.call(e):r};var V=0;T.uniqueId=function(e){var t=++V+"";return e?e+t:t},T.templateSettings={evaluate:/<%([\s\S]+?)%>/g,interpolate:/<%=([\s\S]+?)%>/g,escape:/<%-([\s\S]+?)%>/g};var K=/(.)^/,j={"'":"'","\\":"\\","\r":"r","\n":"n","\u2028":"u2028","\u2029":"u2029"},W=/\\|'|\r|\n|\u2028|\u2029/g,H=function(e){return"\\"+j[e]};T.template=function(e,t,n){!t&&n&&(t=n),t=T.defaults({},t,T.templateSettings);var r=RegExp([(t.escape||K).source,(t.interpolate||K).source,(t.evaluate||K).source].join("|")+"|$","g"),i=0,a="__p+='";e.replace(r,function(t,n,r,o,s){return a+=e.slice(i,s).replace(W,H),i=s+t.length,n?a+="'+\n((__t=("+n+"))==null?'':_.escape(__t))+\n'":r?a+="'+\n((__t=("+r+"))==null?'':__t)+\n'":o&&(a+="';\n"+o+"\n__p+='"),t}),a+="';\n",t.variable||(a="with(obj||{}){\n"+a+"}\n"),a="var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};\n"+a+"return __p;\n";try{var o=new Function(t.variable||"obj","_",a)}catch(e){throw e.source=a,e}var s=function(e){return o.call(this,e,T)},u=t.variable||"obj";return s.source="function("+u+"){\n"+a+"}",s},T.chain=function(e){var t=T(e);return t._chain=!0,t};var Y=function(e,t){return e._chain?T(t).chain():t};T.mixin=function(e){T.each(T.functions(e),function(t){var n=T[t]=e[t];T.prototype[t]=function(){var e=[this._wrapped];return h.apply(e,arguments),Y(this,n.apply(T,e))}})},T.mixin(T),T.each(["pop","push","reverse","shift","sort","splice","unshift"],function(e){var t=p[e];T.prototype[e]=function(){var n=this._wrapped;return t.apply(n,arguments),"shift"!==e&&"splice"!==e||0!==n.length||delete n[0],Y(this,n)}}),T.each(["concat","join","slice"],function(e){var t=p[e];T.prototype[e]=function(){return Y(this,t.apply(this._wrapped,arguments))}}),T.prototype.value=function(){return this._wrapped},T.prototype.valueOf=T.prototype.toJSON=T.prototype.value,T.prototype.toString=function(){return""+this._wrapped},r=[],i=function(){return T}.apply(t,r),!(void 0!==i&&(e.exports=i))}).call(this)},function(e,t,n){"use strict";var r,i=n(18),a=function(e){return null!=e},o=function(){function e(t){var n=this;this._value=t,this._isDefined=!1,this._isEmpty=!0,this._arr=void 0,this.getOrThrow=function(){return i(n._isDefined,"Opt is empty. Use `Opt#getOrElse` or check `Opt#isDefined`."),n._value},this.value=function(){return n._value},this.isDefined=function(){return n._isDefined},this.isEmpty=function(){return n._isEmpty},this.toArray=function(){return n._arr||(n._arr=n._isDefined?[n._value]:[])},this.getOrElse=function(e){return n._isDefined?n._value:e},this.getOrElseF=function(e){return n._isDefined?n._value:e()},this.map=function(t){return n._isEmpty?e.empty():new e(t(n._value))},this.flatMap=function(t){return n.map(t).getOrElse(e.empty())},this.equals=function(t){return i(t instanceof e,"Expected other to be an `Opt`, but got `%s`",typeof t),n._isDefined===t.isDefined()&&n._value===t.value()},a(this._value)&&(this._isDefined=!0,this._isEmpty=!1)}return e.prototype.forEach=function(e){this.isDefined()&&e(this._value)},e.empty=function(){return r||(r=new e)},e}();e.exports=o},function(e,t,n){(function(t){"use strict";var n=function(e,n,r,i,a,o,s,u){if("production"!==t.env.NODE_ENV&&void 0===n)throw new Error("invariant requires an error message argument");if(!e){var l;if(void 0===n)l=new Error("Minified exception occurred; use the non-minified dev environment for the full error message and additional helpful warnings.");else{var p=[r,i,a,o,s,u],c=0;l=new Error(n.replace(/%s/g,function(){return p[c++]})),l.name="Invariant Violation"}throw l.framesToPop=1,l}};e.exports=n}).call(t,n(7))},function(e,t,n){(function(e){"use strict";function r(e,t,n){return new Be.Function(e).call(t,n)}function i(e,t){var n=e.property();return n&&n.getContextRequirements().forEach(function(r){e.checkContextValue(r.name,r.value,r.value)||t.accept(Z(xe.CONTEXT_REQUIREMENT,{name:r.name,value:r.value,propName:n.nameId()},e))}),n}function a(e,t){var n;try{n=e.lowLevel().unit().project().fsEnabled()}catch(e){n=!0}if(n&&"undefined"!=typeof Ae&&Ae){for(var r=["exists","readFile","writeFile","readdir","existsSync","readFileSync","writeFileSync","readdirSync"],i=(Object.keys(Ae),0);i<r.length;i++)if(!Ae[r[i]])return;var a=e.lowLevel().unit().absolutePath(),o=ge.dirname(a),s=ge.resolve(o,"raml-lint.js");Ve(s,t,e);var u=ge.resolve(o,".raml");if(Ae.existsSync(u)){var l=Ae.statSync(u);if(l.isDirectory()){var p=Ae.readdirSync(u);p.forEach(function(n){-1!=n.indexOf("-lint.js")&&Ve(ge.resolve(u,n),t,e)})}}}}function o(e){return e.nameId()==Ee.Universe10.TypeDeclaration.properties.type.name||e.nameId()==Ee.Universe10.TypeDeclaration.properties.schema.name}function s(e){return!!l(e)&&e.nameId()==Ee.Universe10.TypeDeclaration.properties["default"].name}function u(e){return!!l(e)&&e.nameId()==Ee.Universe10.TypeDeclaration.properties.example.name}function l(e){return!!e.domain()&&!e.domain().getAdapter(Ne.RAMLService).isUserDefined()}function p(e){return!!l(e)&&e.nameId()==Ee.Universe08.MethodBase.properties.securedBy.name}function c(e){e.isElement()||(e=e.parent());for(var t=e&&e.asElement();t;){if(t.definition().getAdapter(Ne.RAMLService).isInlinedTemplates())return t.definition();var n=t.parent();if(!n)break;t=n}return null}function f(e){var n=e.parent(),r=null,i=n.definition();if(n&&ye.UserDefinedClass.isInstance(i)){var a=n.property();if(_e.isIsProperty(a)||_e.isTypeProperty(a)){var o=e.name();if(null!=t.RESERVED_TEMPLATE_PARAMETERS[o])r=Z(xe.INVALID_PARAMETER_NAME,{paramName:o},e);else{var s=o.indexOf(":");if(ve.BasicASTNode.isInstance(e)&&s>=0){var u=o.substring(0,s+1)+" "+o.substring(s+1);r=Z(xe.UNUSED_PARAMETER_MISSING_SEPARATING_SPACE,{paramName:o,correctMapping:u},e,!0)}else r=Z(xe.UNUSED_PARAMETER,{paramName:o},e,!0)}}}if(!r){var l=e.name(),p=Te("RAML08"),c=i.universe().version()==p.version();if(c){var f=Ee.Universe08.Parameter.name;if(Ee.Universe10.TypeDeclaration.name,c&&i.isAssignableFrom(f)){for(var h=p.type(f).allSubTypes().filter(function(e){return null!=Ee.Universe08[e.nameId()].properties[l]}),d={},m=0;m<h.length;m++){var y=h[m];if(!d[y.nameId()]){var v=y.valueRequirements();if(v&&0!=v.length){var g=v.filter(function(e){return"type"==e.name}).map(function(e){return e.value});if(0!=g.length){var A=g[0];d[y.nameId()]=A,y.allSubTypes().forEach(function(e){return h.push(e)})}}}}var E=Object.keys(d).map(function(e){return d[e]}).sort();if(E.length>0){var _=E.map(function(e,t){var n="'"+e+"'";return t==E.length-1?n:t==E.length-2?n+" or ":n+", "}).join("");r=Z(xe.INVALID_PROPERTY_OWNER_TYPE,{propName:l,namesStr:_},e)}}}}return r}function h(e,t){if(e.isElement()){if(e.invalidSequence){var n=e.property().nameId();n=De.sentenceCase(Ue.singular(n)),t.acceptUnique(te(xe.SEQUENCE_NOT_ALLOWED_10,{propName:n},e.lowLevel().parent().parent(),e))}var r=e.asElement();if(r.definition().isAssignableFrom(Ee.Universe10.LibraryBase.name)){var i,a=!1,o=!1;r.lowLevel().children().forEach(function(e){"schemas"==e.key()&&(a=!0,i=e),"types"==e.key()&&(o=!0)}),a&&o&&t.accept(Et(i,r,fe.IssueCode.ILLEGAL_PROPERTY_VALUE,!1,"types and schemas are mutually exclusive",!1))}r.definition().requiredProperties()&&r.definition().requiredProperties().length>0,d(e,t),(new at).validate(r,t),(new vt).validate(r,t)}else d(e,t);(new mt).validate(e,t)}function d(e,t,n){void 0===n&&(n=!1);var r=e.parent(),i=e.lowLevel().value();if(e.lowLevel()){if(e.lowLevel().keyKind()==me.Kind.MAP&&t.accept(Z(xe.NODE_KEY_IS_A_MAP,{},e)),e.lowLevel().keyKind()==me.Kind.SEQ&&null==i){var a=!1;e.isElement()&&e.asElement().definition().isAssignableFrom(Ee.Universe10.TypeDeclaration.name)&&(a=!0),a||t.accept(Z(xe.NODE_KEY_IS_A_SEQUENCE,{},e))}if(null==r){var o=e.lowLevel().unit().contents().length;e.lowLevel().errors().forEach(function(n){var r=n.mark?n.mark.position:0,i=r>=o?r:r+1;if(n.mark&&n.mark.toLineEnd){var a=n.mark.buffer,s=a.indexOf("\n",r);0>s&&(s=a.length),s<a.length&&"\r"==a.charAt(s)&&s--,i=s}var u={code:"YAML_ERROR",message:n.message,node:null,start:r,end:i,isWarning:n.isWarning,path:e.lowLevel().unit()==e.root().lowLevel().unit()?null:e.lowLevel().unit().path(),unit:e.lowLevel().unit()};t.accept(u)})}}if(e.isUnknown()){if("string"==typeof e.name()&&e.name().indexOf("<<")>=0&&null!=c(r))return(new Ye).validateName(e,t),!1;if(e.needSequence&&t.accept(Z(xe.SEQUENCE_REQUIRED,{name:e.name()},e)),e.needMap)return e.knownProperty?t.accept(Z(xe.PROPERTY_MUST_BE_A_MAP_10,{propName:e.knownProperty.nameId()},e)):t.accept(Z(xe.MAP_REQUIRED,{},e)),!1;if(e.unresolvedRef&&t.accept(Z(xe.UNRESOLVED_REFERENCE,{ref:i},e)),e.knownProperty){if(0==e.lowLevel().includeErrors().length){if(c(r)&&we.startsWith(i,"<<")&&we.endsWith(i,">>"))return!1;if("body"==e.name()&&e.computedValue("mediaType"))return!1;"~"!=e.lowLevel().value()&&(oe(e,t,xe.SCALAR_PROHIBITED.code,!1)||t.accept(Z(xe.SCALAR_PROHIBITED,{propName:e.name()},e)))}}else{var s="string"==typeof e.name()?e.name().indexOf("<<"):-1;if(s>0&&c(r)&&e.name().indexOf(">>",s))return!1;var u=f(e);u||(u=m(e)),t.accept(u)}}if(e.markCh()&&!e.allowRecursive())return!!e.property()&&(t.accept(Z(xe.RECURSIVE_DEFINITION,{name:e.name()},e)),!1);if(e.definition&&e.definition().isAssignableFrom(Ee.Universe10.Operation.name)){var l=v(e.wrapperNode()),p=l.queryStringComesFrom,h=l.queryParamsComesFrom;p&&h&&(t.accept(y(p,e,!1)),t.accept(y(h,e,!0)))}var d=e.definition&&e.definition()&&(e.definition().key()===Ee.Universe10.Overlay||e.definition().key()===Ee.Universe10.Extension);return d&&N(e,t,n),!0}function m(e){var t,n=e.parent();if(n){var r=n.definition();if(r){var i=e.name(),a=r.nameId();if(Ie.isPossibleMethodName(i))t=Z(xe.INVALID_METHOD_USAGE,{typeName:a},e);else if("/"==i.charAt(0))t=Z(xe.INVALID_SUBRESOURCE_USAGE,{typeName:a},e);else{var o=r&&r.universe();if(o){var s=_t.getInstance().hasProperty(i);if(s){var u=void 0;"RAML10"==o.version()?u="RAML 1.0":"RAML08"==o.version()&&(u="RAML 0.8"),u&&(t=Z(xe.INVALID_PROPERTY_USAGE,{propName:i,typeName:a,ramlVersion:u},e))}}}}}return t||(t=Z(xe.UNKNOWN_NODE,{name:e.name()},e)),t}function y(e,t,n){var r=e,i=e,a=n?Ee.Universe10.Operation.properties.queryString.name:Ee.Universe10.Operation.properties.queryParameters.name;return r.unit?te(xe.QUERY_STRING_AND_QUERY_PARAMETERS_ARE_MUTUALLY_EXCLUSIVE,{propName:a},r,t):Z(xe.QUERY_STRING_AND_QUERY_PARAMETERS_ARE_MUTUALLY_EXCLUSIVE,{propName:a},i)}function v(e){return{queryParamsComesFrom:g(e,!0),queryStringComesFrom:g(e,!1)}}function g(e,t,n,r){if(void 0===n&&(n=!0),void 0===r&&(r={}),!e)return null;if(e.name){var i=e.name();if(r[i])return;r[i]=!0}var a=E(e,t);if(a)return a;var o=e.is&&e.is()||[],s=de.find(o,function(e){return g(e.trait(),t,n,r)});if(s)return s.highLevel();if(n){var u=e.parentResource&&e.parentResource(),l=u&&A(u,t,r);if(l)return l;if(u=e.parent&&e.parent(),u&&u.highLevel().definition().isAssignableFrom(Ee.Universe10.ResourceBase.name))return A(u,t,r)}return null}function A(e,t,n,r){if(void 0===n&&(n={}),void 0===r&&(r={}),e.name){var i=e.name();if(r[i])return;r[i]=!0}var a=e.is(),o=de.find(a,function(e){return g(e.trait(),t,!1,n)});if(o)return o.highLevel();var s=e.type(),u=s&&s.resourceType(),l=u&&A(u,t,n,r);return l?s.highLevel():void 0}function E(e,t){return t?_(e):T(e)}function _(e){var t=e.highLevel();return t.lowLevel&&de.find(t.lowLevel().children(),function(e){return e.key&&e.key()===Ee.Universe10.Operation.properties.queryParameters.name})}function T(e){var t=e.highLevel(),n=t.element(Ee.Universe10.Operation.properties.queryString.name);return n}function N(e,t,n){if(void 0===n&&(n=!1),!e.parent()){var r=e.asElement();if(r&&r.isAuxilary()){var i=r.getMaster();i&&h(i,t)}}}function S(e,t,n){if(void 0===n&&(n=!1),d(e,t,n))try{var r=e.definition&&e.definition()&&(e.definition().key()===Ee.Universe10.Overlay||e.definition().key()===Ee.Universe10.Extension),i=r?e.children():e.directChildren();i.filter(function(e){return!n||e.property&&e.property()&&e.property().isRequired()}).forEach(function(n){if(n&&n.errorMessage){var r=n.errorMessage;return void t.accept(Z(r.entry,r.parameters,n.name()?n:e))}n.validate(t)})}finally{e.unmarkCh()}}function b(e,t){if(!e.parent())try{R(e,t)}finally{I(e,t)}if(e.isAttr())(new Ge).validate(e,t);else if(e.isElement()){if(e.invalidSequence){var n=e.property().nameId();t.acceptUnique(te(xe.SEQUENCE_NOT_ALLOWED_10,{propName:n},e.lowLevel().parent().parent(),e,!1))}var r=e.asElement();if(_e.isExampleSpecType(r.definition())){var i=r.children();if(0==i.length)return void S(e,t,!0);var a=i.filter(function(e){var t=e.lowLevel().key();return!t||("("!=t.charAt(0)||")"!=t.charAt(t.length-1))&&null==r.definition().property(t)});if(a.length>0)return void S(e,t,!0)}if(r.definition().isAnnotationType()||r.property()&&"annotations"==r.property().nameId())return void(new rt).validate(r,t);if(r.definition().isAssignableFrom(Ee.Universe10.UsesDeclaration.name)){var o=r.attr(Ee.Universe10.UsesDeclaration.properties.value.name),s=o&&o.value();if(null!=s&&"string"==typeof s){var u=r.lowLevel().unit().resolve(s);if(u&&null!==u.contents()){if(!Le.isWaitingFor(s)){var l=[];if(0===u.contents().trim().length)return void t.accept(Z(xe.EMPTY_FILE,{path:s},r,!1));var p=u.highLevel().asElement(),c=new ve.ASTNodeImpl(p.lowLevel(),p.parent(),p.definition(),p.property());if(c.setValueSource(r),c.validate(ve.createBasicValidationAcceptor(l,c)),l.length>0){var f=je(o,r);l.forEach(function(e){e.unit=null==e.unit?u:e.unit,e.path||(e.path=u.absolutePath())});for(var h=0,d=l;h<d.length;h++){for(var m=d[h],y=m;y.extras&&y.extras.length>0;)y=y.extras[0];y!=f&&(y.extras||(y.extras=[]),y.extras.push(f)),t.accept(m)}}}}else t.accept(Z(xe.INVALID_LIBRARY_PATH,{path:s},r,!1))}}if(r.definition().isAssignableFrom(Ee.Universe10.TypeDeclaration.name))return r.attrs().forEach(function(n){var i=n.property().range().key();if(i==Ee.Universe08.RelativeUriString||i==Ee.Universe10.RelativeUriString)return void(new $e).validate(n,t);if(i==Ee.Universe08.FullUriTemplateString||i==Ee.Universe10.FullUriTemplateString)return void(new $e).validate(n,t);if(n.property().getAdapter(Ne.RAMLPropertyService).isKey()){var a=e.property()&&e.property().nameId();if(a==Ee.Universe08.Resource.properties.uriParameters.name||a==Ee.Universe08.Resource.properties.baseUriParameters.name)return;if(r.property()&&r.property().nameId()==Ee.Universe10.MethodBase.properties.body.name)return void(new Je).validate(n,t)}}),(new pt).validate(r,t),(new ct).validate(r,t),(new ut).validate(r,t),void(new it).validate(r,t);if(r.definition().isAssignableFrom(Ee.Universe10.LibraryBase.name)){var v,g=!1,A=!1;r.lowLevel().children().forEach(function(e){"schemas"==e.key()&&(g=!0,v=e),"types"==e.key()&&(A=!0)}),g&&A&&t.accept(te(xe.TYPES_AND_SCHEMAS_ARE_EXCLUSIVE,{},v,r))}var E=r.definition().requiredProperties()&&r.definition().requiredProperties().length>0,_=r.definition().getAdapter(Ne.RAMLService).getAllowAny();_?E&&S(e,t,!0):S(e,t),(new yt).validate(r,t),(new at).validate(r,t),(new vt).validate(r,t)}else S(e,t);(new mt).validate(e,t)}function I(e,t){if(e.lowLevel()){var n=e.lowLevel().actual();delete n._inc,e.children().forEach(function(e){return I(e,t)})}}function R(e,t){var n=e.lowLevel();if(n){var r=n.actual();if(!r._inc){if(e.isElement()){var i=e.name();null!=c(e)&&(i=i.replace(/<<[^<>]*>>/g,"")),"string"==typeof i&&null!=i&&-1!=i.indexOf(" ")&&t.accept(Z(xe.SPACES_IN_KEY,{value:i},e,!0))}if(r._inc=!0,n){n.includeErrors().forEach(function(n){var r=!1;e.lowLevel().hasInnerIncludeError()&&(r=!0);var i=Z(xe.INCLUDE_ERROR,{msg:n},e,r);t.accept(i)});var a=n.includePath();if(null!=a&&!ge.isAbsolute(a)&&!he.isWebPath(a)){var o=n.unit().absolutePath(),s=w(ge.dirname(o),a);if(s>0){var u=Z(xe.PATH_EXCEEDS_ROOT,{},e,!0);t.accept(u)}}}e.children().forEach(function(e){return R(e,t)}),0==e.children().length&&null!=n&&n.children().forEach(function(n){return M(n,t,e)})}}}function M(e,t,n){e.includeErrors().forEach(function(r){var i=!1;e.hasInnerIncludeError()&&(i=!0);var a=te(xe.INCLUDE_ERROR,{msg:r},e,n,i);t.accept(a)});var r=e.includePath();if(null!=r&&!ge.isAbsolute(r)&&!he.isWebPath(r)){var i=e.unit().absolutePath(),a=w(ge.dirname(i),r);if(a>0){var o=te(xe.PATH_EXCEEDS_ROOT,{},e,n,!0);t.accept(o)}}e.children().forEach(function(e){return M(e,t,n)})}function w(e,t){for(var n=We(e),r=We(t),i=n.length,a=0,o=0,s=r;o<s.length;o++){var u=s[o];".."==u?(i--,0>i&&(a=Math.min(i,a))):i++}return-1*a}function C(e,t,n,r,i){return e.hasArrayInHierarchy()?L(e,t,n,r,i):!e.hasValueTypeInHierarchy()||P(e,t,n,r,i)}function L(e,t,n,r,i){return!e.arrayInHierarchy().componentType()||C(e.arrayInHierarchy().componentType(),t,n,r)}function P(e,t,n,r,i){try{if(e.key()==Ee.Universe10.AnnotationRef){var a=Re.referenceTargets(r,t),o=de.find(a,function(e){return ve.qName(e,t)==n});if(null!=o){var s=o.attributes("allowedTargets");if(s){var u=s.map(function(e){return e.value()});if(u.length>0){var l=!1,p=t.definition().allSuperTypes();p=p.concat([t.definition()]);var c=p.map(function(e){return e.nameId()});if(u.forEach(function(e){"API"==e&&(e="Api"),"NamedExample"==e&&(e="ExampleSpec"),"SecurityScheme"==e&&(e="AbstractSecurityScheme"),"SecuritySchemeSettings"==e&&(e="SecuritySchemeSettings"),de.find(c,function(t){return t==e})?l=!0:("Parameter"==e&&t.computedValue("location")&&(l=!0),"Field"==e&&t.computedValue("field")&&(l=!0))}),!l){var f=u.map(function(e){return"'"+e+"'"}).join(", ");return new Xe(xe.INVALID_ANNOTATION_LOCATION,{aName:n,aValues:f})}}}}return g}if(e.key()==Ee.Universe08.SchemaString||e.key()==Ee.Universe10.SchemaString){var h=!1;if(ye.UserDefinedProp.isInstance(r)){var d=r,m=d.node();if(m){var y=m.property();y&&(h=_e.isTypeProperty(y)||_e.isSchemaProperty(y))}}if(h)return!1;var v=n&&n.trim().length>0&&("{"==n.trim().charAt(0)||"<"==n.trim().charAt(0)),g=Pe.createSchema(n,Y(t.lowLevel(),i&&i.lowLevel()));if(!g)return g;if(g instanceof Error)g.isWarning=!0,v||(g.canBeRef=!0);else{var A=!1;try{JSON.parse(n),A=!0}catch(e){}if(A)try{g.validateSelf()}catch(e){return e.isWarning=!0,e}}return g}if(e.key()==Ee.Universe08.StatusCodeString||e.key()==Ee.Universe10.StatusCodeString){var E=re(""+n);if(null!=E)return E}if(e.key()==Ee.Universe08.BooleanType||e.isAssignableFrom(Ee.Universe10.BooleanType.name)){if("true"!==n&&"false"!==n&&n!==!0&&n!==!1)return new Xe(xe.BOOLEAN_EXPECTED);if(i){var _=i.lowLevel().value(!0);if("true"!==_&&"false"!==_)return new Xe(xe.BOOLEAN_EXPECTED)}}if(e.key()==Ee.Universe08.NumberType||e.isAssignableFrom(Ee.Universe10.NumberType.name)){var T=parseFloat(n);if(isNaN(T))return new Xe(xe.NUMBER_EXPECTED,{propName:r.nameId()})}if((e.key()==Ee.Universe08.StringType||e.isAssignableFrom(Ee.Universe10.StringType.name))&&null===n&&t&&r){var N=t.attr(r.nameId());if(N){var S=N.lowLevel().children();if(S&&S.length>0)return new Xe(xe.STRING_EXPECTED_3,{propName:r.nameId()})}}return!0}catch(e){return e.canBeRef=!0,e}}function O(e){if(!e)return!1;var t=e.toLowerCase(),n=e.toUpperCase();return e!==t&&e!==n}function D(e){if(!e)return null;if(e.isElement()){var n=e,r=n.definition();if(r&&t.typeToName.hasOwnProperty(r.nameId()))return t.typeToName[r.nameId()];if(r.isAssignableFrom(Ee.Universe10.TypeDeclaration.name)||r.isAssignableFrom(Ee.Universe08.Parameter.name)){if(n.property()&&t.parameterPropertyToName.hasOwnProperty(n.property().nameId()))return t.parameterPropertyToName[n.property().nameId()];if(n.property()&&n.parent()&&n.property().nameId()==Ee.Universe10.LibraryBase.properties.types.name&&n.parent().definition()&&n.parent().definition().isAssignableFrom(Ee.Universe10.LibraryBase.name))return"type";if(n.property()&&n.parent()&&n.property().nameId()==Ee.Universe10.LibraryBase.properties.securitySchemes.name&&n.parent().definition()&&n.parent().definition().isAssignableFrom(Ee.Universe10.LibraryBase.name))return"security scheme"}}return null}function U(e,t,n){var r=Re.declRoot(n);ce.LowLevelProxyNode.isInstance(n.lowLevel())&&(n=r),r._cach||(r._cach={});var i=e.id();if(e.domain()&&(i+=e.domain().nameId()),i){var a=r._cach[i];if(a)return null!=a[t]}var o=Re.enumValues(e,n),s={};return o.forEach(function(e){return s[e]=1}),e.id()&&(r._cach[i]=s),null!=s[t]}function x(e,n,r,i){var a="string"==typeof r?r.indexOf("<<"):-1;if(!(a>=0&&r.indexOf(">>",a)>=0&&null!=c(n))&&(F(e,n,i),B(e,n,i),r&&("null"!=r||!e.isAllowNull()))){var o=e.getAdapter(Ne.RAMLPropertyService),s=n.parent(),u=!1,l=ce.LowLevelCompositeNode.isInstance(n.lowLevel())&&n.lowLevel().getMeta("chaining");if(l||(u=U(e,r,s),u||n.lowLevel().unit().absolutePath()===s.lowLevel().unit().absolutePath()||(u=U(e,r,ve.fromUnit(n.lowLevel().unit())))),!u){if("string"==typeof r&&0==r.indexOf("x-")&&e.nameId()==Ee.Universe10.TypeDeclaration.properties.type.name)return!0;var p=o.isReference&&o.isReference()&&o.referencesTo&&o.referencesTo()&&o.referencesTo().nameId&&o.referencesTo().nameId(),f=t.typeToName[p]||K(n),h={referencedToName:f,ref:r,typeName:r},d=f?xe.UNRECOGNIZED_ELEMENT:xe.UNRESOLVED_REFERENCE,m=V(d,e,n,r),y=e.range().key()===Ee.Universe08.SchemaString;return oe(n,i,m.code,y)||i.accept(Z(m,h,n,y)),!0}return!(!k(n)||!_e.isTraitRefType(n.definition())||(i.accept(Z(xe.DUPLICATE_TRAIT_REFERENCE,{refValue:r},n)),0))}}function k(e){var t,n=e.property().domain().universe().version();if(t="RAML10"==n?pe(le.serialize(e.lowLevel())):e.value()&&e.value().valueName&&e.value().valueName(),!t)return!1;var r=e.parent&&e.parent();if(!r)return!1;var i=e.name&&e.name();if(!i)return!1;var a=r.attributes&&r.attributes(i);if(!a)return!1;if(0===a.length)return!1;var o=0;return a.forEach(function(e){var r;"RAML10"==n?t=pe(le.serialize(e.lowLevel())):r=e.value&&e.value()&&e.value().valueName&&e.value().valueName(),r===t&&o++}),o>1}function F(e,t,n){if(_e.isIsProperty(e)){var r=t.lowLevel();if(null!=r){var i=null,a=r.parent(),o=null!=a?a.parent():null;if(r.kind()==me.Kind.MAPPING&&r.key()&&"is"==r.key()?i=r:null!=a&&a.kind()==me.Kind.MAPPING&&a.key()&&"is"==a.key()?i=a:null!=o&&o.kind()==me.Kind.MAPPING&&o.key()&&"is"==o.key()&&(i=o),null!=i){null==i.value()||i.children()&&0!=i.children().length||n.accept(Z(xe.IS_IS_ARRAY,{},t));var s=!1;i.children().forEach(function(e){e.kind()!=me.Kind.SCALAR&&e.kind()!=me.Kind.MAP&&(s=!0)}),s&&n.accept(Z(xe.IS_IS_ARRAY,{},t))}}}}function B(e,t,n){if(_e.isTypeProperty(e)&&_e.isResourceTypeRefType(t.definition())){var r=t.lowLevel();null==t.value()&&r&&r.children()&&0==r.children().length?r.kind()==me.Kind.MAPPING&&null!=r.valueKind()&&n.accept(Z(xe.RESOURCE_TYPE_NAME,{},t)):null==t.value()&&r&&r.children()&&r.children().length>1&&n.accept(Z(xe.MULTIPLE_RESOURCE_TYPES,{},t))}}function V(e,t,n,r){if("type"==t.nameId()&&"RAML08"==t.domain().universe().version()&&t.domain().isAssignableFrom(Ee.Universe08.Parameter.name))return xe.TYPES_VARIETY_RESTRICTION;if(null!=n.parent()&&_e.isSecuritySchemaType(n.parent().definition()))return xe.UNRECOGNIZED_SECURITY_SCHEME;if(_e.isAnnotationsProperty(t)){var i=ce.LowLevelCompositeNode.isInstance(n.lowLevel())&&n.lowLevel().getMeta("chaining"),a=n.parent().types(),o=a&&a.getAnnotationTypeRegistry();return i||o&&o.getByChain(r)?xe.LIBRARY_CHAINIG_IN_ANNOTATION_TYPE:xe.UNKNOWN_ANNOTATION_TYPE}return e}function K(e){var t=e&&e.lowLevel()&&e.lowLevel().key();if(t===Ee.Universe10.AbstractSecurityScheme.properties.type.name){var n=e.parent()&&e.parent().definition()&&e.parent().definition().nameId();if(n===Ee.Universe10.AbstractSecurityScheme.name)return"security scheme type"}else if(t===Ee.Universe08.BodyLike.properties.schema.name){var n=e.parent()&&e.parent().definition()&&e.parent().definition().nameId();if(n===Ee.Universe08.BodyLike.name)return"schema"}}function j(e,t){var n=t.getValidationPath(),r=H(e,n),i=t.getInternalPath(),a=!1;if(i){var o=H(r,i);o&&o!=r&&(r=o,a=!0)}return{node:r,internalPathUsed:a}}function W(e,t){var n=e.getExtra(Me.SOURCE_EXTRA);return ve.LowLevelWrapperForTypeSystem.isInstance(n)?n.node():null}function H(e,t){if(!t)return e;var n=e.children().filter(function(e){return!(e.isAttr()&&e.asAttr().isFromKey()||e.name()!==t.name)});if(e.isElement()&&_e.isTypeDeclarationDescendant(e.asElement().definition())){var r=e.lowLevel();n=de.uniq(e.directChildren().concat(e.children())).filter(function(e){return!(e.isAttr()&&e.asAttr().isFromKey()||e.name()!==t.name)}).sort(function(e,t){for(var n=e.lowLevel().parent();n&&n.kind()!=me.Kind.MAPPING;)n=n.parent();for(var i=t.lowLevel().parent();i&&i.kind()!=me.Kind.MAPPING;)i=i.parent();return n==r?-1:i==r?1:0})}var i=t.child&&"number"==typeof t.child.name?t.child.name:-1;if(i>=0&&n.length>i)return H(n[i],t.child.child);if(n.length>0)return H(n[0],t.child);if(!e.lowLevel())return e;for(var a=e.lowLevel().children(),o=0;o<a.length;o++)if(a[o].key()===t.name){var s=new ve.BasicASTNode(a[o],e);return H(s,t.child)}if(!isNaN(t.name)&&a[t.name]){var u=a[t.name],s=new ve.BasicASTNode(u,e);return H(s,t.child)}return e}function Y(e,t){var n=e&&e.includeBaseUnit()&&(e.includePath&&e.includePath()?e.includeBaseUnit().resolve(e.includePath()):e.includeBaseUnit());if(t){var r=t&&t.includeBaseUnit()&&(t.includePath&&t.includePath()?t.includeBaseUnit().resolve(t.includePath()):t.includeBaseUnit());r!=n&&(n=r)}return new Ce.ContentProvider(n)}function q(e){return-1!=e.indexOf("json")}function G(e){return-1!=e.indexOf("xml")}function X(e){var t=z(e);if("body"==t){var n=e.root().attr("mediaType");return n?n.value():null}return t}function z(e){if(e.parent()){var t=e.parent().definition();if(t.key()==Ee.Universe08.BodyLike)return e.parent().name();if(e.parent().parent()){var n=e.parent().parent().definition().key();if(n==Ee.Universe08.Response||n==Ee.Universe10.Response)return e.parent().property().nameId()==Ee.Universe08.Response.properties.headers.name?null:e.parent().name();if(n==Ee.Universe08.Method||n==Ee.Universe10.Method)return e.parent().property().nameId()==Ee.Universe10.MethodBase.properties.queryParameters.name||e.parent().property().nameId()==Ee.Universe10.MethodBase.properties.headers.name?null:e.parent().name();
}}return null}function $(e,t,n,r,i,a,o,s,u,l){if(void 0===u&&(u=!1),void 0===l&&(l=!1),!s)return null;var p=t.start(),c=t.end(),f=t.actual(),h=f&&f.value,d=h&&h.rawValue,m=t.valueKind();m==me.Kind.ANCHOR_REF&&(m=t.anchorValueKind());var y=m;if(m==me.Kind.INCLUDE_REF&&(m=t.resolvedValueKind()),m!=me.Kind.SCALAR&&!u)return null;if(y==me.Kind.INCLUDE_REF){var v=t.unit().resolve(t.includePath());if(v){var g=v.lineMapper(),A=g.toPosition(s.start.line,s.start.column),E=g.toPosition(s.end.line,s.end.column),_={code:n,isWarning:r,message:i,node:null,start:A.position,end:E.position,path:v.path(),extras:[],unit:v},T=void 0;return T=e?At(e,n,r,i,a,o,t):Et(t,null,n,r,i,a,null,l),_.extras.push(T),_}}var N=t.unit().lineMapper(),S=t.valueStart();0>S&&(S=t.start());var b,I,R=N.position(S),M=R.line+s.start.line,w=R.line+s.end.line;if(d&&"string"==typeof d&&"|"==d.charAt(0)){var C=d.indexOf("\n")+1,L=d.indexOf("\n",C);0>L&&(L=d.length);var P=gt.exec(d.substring(C,L))[0].length;b=P+s.start.column,I=P+s.end.column,M++,w++}else b=R.column+s.start.column,I=R.column+s.end.column,h&&(h.singleQuoted||h.doubleQuoted)&&(b++,I++);var O=N.toPosition(M,b),D=N.toPosition(w,I);return O&&D&&(p=O.position,c=D.position),{code:n,isWarning:r,message:i,node:e,start:p,end:c,path:a?t.unit()?t.unit().path():"":null,extras:[],unit:t?t.unit():null}}function J(e,t){return ee(e.getCode(),e.getMessage(),j(t,e).node,e.isWarning())}function Q(e,t,n){var r=null!=n?n:e.isWarning,i=e.internalPath,a=t,o=!1,s=t.lowLevel().valueKind();if(s==me.Kind.INCLUDE_REF&&(s=t.lowLevel().resolvedValueKind()),i&&s!=me.Kind.SCALAR){var u=ye.rt.toValidationPath(i);if(u){var l=H(t,u);l&&l!=t&&(a=l,o=!0)}}var p=o?null:e.internalRange;e.filePath&&a.lowLevel().unit().absolutePath()!=e.filePath&&(p=null,e.filePath=null);var c=Z(e.messageEntry,e.parameters,a,r,p);if(e.filePath){var f=t.lowLevel().unit().project().unit(e.filePath,!0);c.unit=f,c.path=e.filePath}return c}function Z(e,t,n,r,i){void 0===r&&(r=!1);var a=ie(e,t),o=Tt.getInstance().isKeyError(e.code);return ee(e.code,a,n,r,i,!1,o)}function ee(e,t,n,r,i,a,o){void 0===r&&(r=!1),void 0===a&&(a=!1),void 0===o&&(o=!1);var s=null,u=null;if(ce.LowLevelProxyNode.isInstance(n.lowLevel()))for(var l=n.lowLevel();!l.primaryNode();){if(!s){var p=l.transformer()&&l.transformer().paramNodesChain(l,o);if(p&&p.length>0){n.lowLevel().valueKind()!=n.lowLevel().resolvedValueKind()?(s=At(n,e,r,t,!1,u,null,i,a),i=null,a=!1):s=At(n,e,r,t,!1,u,null);for(var c=s;c.extras.length>0;)c=c.extras[0];for(var f=0;f<p.length;f++){var h=p[f],d=f==p.length-1?i:null,m=f==p.length-1&&a,y=Et(h,null,e,r,t,!1,d,!0,m);c.extras.push(y),c=y}return s}s=At(n,e,r,t,!0,u,null,i,a),i=null}n=n.parent(),l=n.lowLevel()}var v=n;if(n&&(u=n.property(),n.lowLevel().unit()!=n.root().lowLevel().unit()))for(s=At(n,e,r,t,!0,u,null,i,a),i=null,n.lowLevel().unit();n.lowLevel().unit()!=n.root().lowLevel().unit();)u=n.property(),n=n.parent();if(s){var g=n.lowLevel().unit().project().namespaceResolver();if(g){var A=g.resolveNamespace(n.root().lowLevel().unit(),v.lowLevel().unit());if(A){var E=A.usesNodes.map(function(e){return te(xe.ISSUES_IN_THE_LIBRARY,{value:e.value()},e,e.unit().highLevel(),!0)});E.push(s),E=E.reverse();for(var _=0;_<E.length-1;_++)E[_].extras.push(E[_+1]);return s}}n.property()&&n.property().nameId()==Ee.Universe10.FragmentDeclaration.properties.uses.name&&null!=n.parent()&&(u=n.property(),n=n.parent())}var T=At(n,e,r,t,!1,u,null,i,a);if(s){for(var c=s;c.extras&&c.extras.length>0;)c=c.extras[0];if(c.extras.push(T),n.lowLevel().valueKind()==me.Kind.INCLUDE_REF){var N=xe.ERROR_IN_INCLUDED_FILE;T.code=N.code,T.message=ie(N,{msg:T.message})}T=s}return T}function te(e,t,n,r,i,a,o){void 0===i&&(i=!1),void 0===a&&(a=!1);var s=ie(e,t);return ne(e.code,s,n,r,i,a,o)}function ne(e,t,n,r,i,a,o){void 0===i&&(i=!1),void 0===a&&(a=!1);var s=null;if(n){var u=r.root().lowLevel().unit();if(r.lowLevel().unit()!=u){s=Et(n,r,e,i,t,!0,o);var l=r.lowLevel().unit();for(l&&(t=t+" "+l.path());r.lowLevel().unit()!=u;)r=r.parent()}}s&&(o=null,r.property()&&r.property().nameId()==Ee.Universe10.FragmentDeclaration.properties.uses.name&&null!=r.parent()&&(r=r.parent()),n=r.lowLevel());var p=Et(n,r,e,i,t,a,o);return s&&(s.extras.push(p),n.valueKind()==me.Kind.INCLUDE_REF&&(p.message=ie(xe.ERROR_IN_INCLUDED_FILE,{msg:p.message})),p=s),p}function re(e){if(3!=e.length)return new Xe(xe.STATUS_MUST_BE_3NUMBER);for(var t=0;t<e.length;t++){var n=e[t];if(!de.find(["0","1","2","3","4","5","6","7","8","9"],function(e){return e==n}))return new Xe(xe.STATUS_MUST_BE_3NUMBER)}return null}function ie(e,t){for(var n="",r=e.message,i=0,a=r.indexOf("{{");a>=0;a=r.indexOf("{{",i)){if(n+=r.substring(i,a),i=r.indexOf("}}",a),0>i){i=a;break}a+="{{".length;var o=r.substring(a,i),s=o.split("|"),u=s[0].trim(),l=be.getTransformersForOccurence(o);i+="}}".length;var p=t[u];if(void 0===p)throw new Error(ie(xe.MESSAGE_PARAMETER_NO_VALUE,{paramName:u}));for(var c=0,f=l;c<f.length;c++){var h=f[c];p=h(p)}n+=p}return n+=r.substring(i,r.length)}function ae(e){if(!e)return!1;if(e=e.trim().toLowerCase(),e.indexOf("\n")>=0||e.indexOf("\r")>=0)return!1;we.startsWith(e,"http://")?e=e.substring("http://".length):we.startsWith(e,"https://")?e=e.substring("https://".length):we.startsWith(e,"./")?e=e.substring("./".length):we.startsWith(e,"/")&&(e=e.substring("/".length)),e=e.replace(/\.\.\//g,"");var t=e.split("/");if(0==t.length)return!1;for(var n=0,r=t;n<r.length;n++){var i=r[n];if(!/^[-a-z\\d%_.~+]+$/.test(i))return!1}return!0}function oe(e,t,n,r){if(void 0===r&&(r=!1),n!=xe.SCALAR_PROHIBITED.code&&n!=xe.SCALAR_PROHIBITED_2.code&&"CAN_NOT_PARSE_JSON"!=n&&"TYPE_EXPECTED"!=n&&"CONTENT_DOES_NOT_MATCH_THE_SCHEMA"!=n&&"INHERITING_UNKNOWN_TYPE"!=n&&"SCHEMA_ERROR"!=n&&"UNRECOGNIZED_ELEMENT"!=n)return!1;if(e){var i=e.lowLevel(),a=i.valueKind();if(a==me.Kind.ANCHOR_REF&&(a=i.anchorValueKind()),a==me.Kind.INCLUDE_REF)return!1;var o=e.property();o||(o=e.knownProperty);var s=_e.isExampleProperty(o)||_e.isExamplesProperty(o),u=_e.isTypeOrSchemaProperty(o);if(u||o&&_e.isGlobalSchemaType(o.domain())&&_e.isValueProperty(o)&&(u=!0),o&&(u||s||!o.range().isValueType())){var l=e.parent();if(!l)return!1;var p=l.definition(),c=e.lowLevel().value();if("string"==typeof c&&ae(c)){if(c.indexOf(".")<0)return!1;if(s){if(!(_e.isBodyLikeType(p)||_e.isObjectTypeDeclarationSibling(p)||_e.isArrayTypeDeclarationSibling(p)))return!1;if(!(we.endsWith(c,".raml")||we.endsWith(c,".yml")||we.endsWith(c,".yaml")||we.endsWith(c,".xml")||we.endsWith(c,".json")))return!1}else if(u){if(!(we.endsWith(c,".raml")||we.endsWith(c,".yml")||we.endsWith(c,".yaml")||we.endsWith(c,".xml")||we.endsWith(c,".json")||we.endsWith(c,".xsd")))return!1}else if(!(we.endsWith(c,".raml")||we.endsWith(c,".yml")||we.endsWith(c,".yaml")))return!1;var f=Z(xe.INCLUDE_TAG_MISSING,null,e,r);return t.accept(f),!0}}return!1}}var se=this&&this.__extends||function(){var e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();Object.defineProperty(t,"__esModule",{value:!0});var ue=n(4),le=n(20),pe=n(198),ce=n(197),fe=n(196),he=n(5),de=n(16),me=n(21),ye=n(56),ve=n(55),ge=n(6),Ae=n(298),Ee=n(202),_e=n(203),Te=n(297),Ne=ye,Se=n(299),be=n(276),Ie=n(284),Re=n(271),Me=ye.rt,we=n(287),Ce=n(295),Le=n(229),Pe=ye.getSchemaUtils(),Oe=(n(274),n(300)),De=n(207),Ue=n(285),xe=n(269),ke=function(){function e(){this.validateNotStrictExamples=!0}return e}(),Fe=new ke,Be=n(304);t.RESERVED_TEMPLATE_PARAMETERS={resourcePathName:'Part of the resource path following the rightmost "/"',methodName:"Method name",resourcePath:"Path of the resource"};var Ve=function(e,t,n){if(Ae.existsSync(e))try{var i=Ae.readFileSync(e).toString(),a=new Ke(t);r(i,a,null),a.visit(n)}catch(e){console.log("Error in custom linter"),console.log(e)}},Ke=function(){function e(e){this.acceptor=e,this.nodes={}}return e.prototype.error=function(e,t){this.acceptor.accept(Z(xe.INVALID_VALUE_SCHEMA,{iValue:t},e.highLevel()))},e.prototype.errorOnProperty=function(e,t,n){var r=e.highLevel().attr(t);this.acceptor.accept(Z(xe.INVALID_VALUE_SCHEMA,{iValue:n},r))},e.prototype.warningOnProperty=function(e,t,n){var r=e.highLevel().attr(t);this.acceptor.accept(Z(xe.INVALID_VALUE_SCHEMA,{iValue:n},r,!0))},e.prototype.warning=function(e,t){this.acceptor.accept(Z(xe.INVALID_VALUE_SCHEMA,{iValue:t},e.highLevel(),!0))},e.prototype.registerRule=function(e,t){var n=this.nodes[e];n||(n=[],this.nodes[e]=n),n.push(t)},e.prototype.visit=function(e){var t=this,n=e.definition();this.process(n,e),n.allSuperTypes().forEach(function(n){return t.process(n,e)}),e.elements().forEach(function(e){return t.visit(e)})},e.prototype.process=function(e,t){var n=this;if(ye.NodeClass.isInstance(e)&&!e.getAdapter(Ne.RAMLService).getDeclaringNode()){var r=this.nodes[e.nameId()];r&&r.forEach(function(e){return e(t.wrapperNode(),n)})}},e}();!function(){function e(){}return e.prototype.toString=function(){return this.prev?this.value+"."+this.prev.toString():this.value},e.prototype.last=function(){return this.prev?this.prev.last():this},e}(),t.typeOfContainingTemplate=c,t.validateBasicFlat=d,function(){function e(){}return e}(),t.validateBasic=S;var je=function(e,t){var n=t.lowLevel().start(),r=[];if(0>n){for(var i=t.attr("key").value().split("."),a=[],o=t.parent(),s=0,u=i;s<u.length;s++){var l=u[s],p=de.find(o.elementsOfKind("uses"),function(e){return e.attr("key")&&e.attr("key").value()==l});a.push(p),o=p.lowLevel().unit().resolve(p.attr("value").value()).highLevel().asElement()}var c=a.map(function(e){return Z(xe.ISSUES_IN_THE_LIBRARY,{value:e.attr("value").value()},e,!0)});c=c.reverse();for(var f=0;f<c.length-1;f++)c[f].extras.push(c[f+1]);return c[0]}return r.push(t),Z(xe.ISSUES_IN_THE_LIBRARY,{value:e.value()},t,!0)};t.validate=b;var We=function(t){t=t.replace(/\\/g,"/").trim(),t.length>1&&":"==t.charAt(1)&&/^win/.test(e.platform)&&(t=t.substring(2));var n=t.split("/");return 0==n[0].length&&(n=n.slice(1)),n.length>0&&0==n[n.length-1].length&&(n=n.slice(0,n.length-1)),n},He=function(e,t,n){try{new RegExp(e)}catch(r){t.accept(Z(xe.ILLEGAL_PATTERN,{value:e},n))}},Ye=function(){function e(){}return e.prototype.validateName=function(e,t){var n=e.name();if(n){var r=e.lowLevel().keyStart();this.check(n,r,e,t)}},e.prototype.validateValue=function(e,t){var n=e.value();if("string"==typeof n){var r=e.lowLevel().valueStart();this.check(n,r,e,t)}},e.prototype.hasTraitOrResourceTypeParent=function(e){for(var t=e.parent();null!=t;){if(!t.definition())return!1;if(_e.isTraitType(t.definition())||_e.isResourceTypeType(t.definition()))return!0;t=t.parent()}return!1},e.prototype.check=function(e,t,n,r){if(!this.hasTraitOrResourceTypeParent(n))return[];for(var i=[],a=0,o=e.indexOf("<<");o>=0;o=e.indexOf("<<",a)){o+="<<".length,a=e.indexOf(">>",o);var s=e.substring(o,a),u=s.indexOf("|"),l=u>=0?s.substring(0,u):s;if(0==l.trim().length){var p=Z(xe.TEMPLATE_PARAMETER_NAME_MUST_CONTAIN_NONWHITESPACE_CHARACTERS,{},n);p.start=t+o,p.end=t+a,r.accept(p)}if(-1!=u){u++;for(var c=s.split("|").slice(1).map(function(e){return e.trim()}),f=be.getTransformNames(),h=0,d=c;h<d.length;h++){var m=d[h];if(!de.find(f,function(e){return m===e||m==="!"+e})){var p=Z(xe.UNKNOWN_FUNCTION,{transformerName:m},n,!1);p.start=t+u,p.end=t+a,r.accept(p)}}}a+=">>".length}return i},e}(),qe=function(){function e(){}return e.prototype.validate=function(t,n){var r=t.parent();if(r&&(r.definition().isAssignableFrom(Ee.Universe08.Method.name)||r.definition().isAssignableFrom(Ee.Universe10.Method.name))){var i=de.find(r.lowLevel()&&r.lowLevel().children()||[],function(e){var t=e.key();return t&&(Ee.Universe08.MethodBase.properties.body.name===t||Ee.Universe10.MethodBase.properties.body.name===t)});i&&de.find(e.methodsWithoutRequestBody,function(e){return r.name()===e})&&n.accept(Z(xe.REQUEST_BODY_DISABLED,{methodName:r.name()},r))}},e.methodsWithoutRequestBody=["trace"],e}(),Ge=function(){function e(){}return e.prototype.validate=function(e,t){var n=i(e,t),r=e.value(),a=e.parent(),l=a.definition(),f=l.universe().version(),h=null!=c(a),d=e.property();if(!d.range().hasStructure()){if(ve.StructuredValue.isInstance(r)&&!d.isSelfNode()){if(o(d)&&d.domain().key()==Ee.Universe08.BodyLike){var m=new ve.ASTNodeImpl(e.lowLevel(),a,l.universe().type(Ee.Universe08.BodyLike.name),d);return void m.validate(t)}if("RAML10"==f&&h)return;t.accept(Z(xe.SCALAR_EXPECTED,{},e))}else{var y=e.lowLevel().valueKind();if(e.lowLevel().valueKind()!=me.Kind.INCLUDE_REF&&!d.getAdapter(Ne.RAMLPropertyService).isKey()&&!(d.isMultiValue()||_e.isApiType(l)&&_e.isTitleProperty(d))){var v=d.range().key();v!=Ee.Universe08.StringType&&v!=Ee.Universe08.MarkdownString&&v!=Ee.Universe08.MimeType||y!=me.Kind.SEQ&&y!=me.Kind.MAPPING&&y!=me.Kind.MAP&&(!d.isRequired()&&!_e.isMediaTypeProperty(d)||null!=y&&void 0!==y)||d.domain().getAdapter(Ne.RAMLService).isInlinedTemplates()||t.accept(Z(xe.STRING_EXPECTED,{propName:e.name()},e))}}if(e.isAnnotatedScalar()){var g=new rt;e.annotations().forEach(function(e){var n=e.value(),r=n.toHighLevel();r?g.validate(r,t):t.accept(Z(xe.UNKNOWN_ANNOTATION,{aName:n.valueName()},e))})}}var A;if("string"==typeof r?A=r:ve.StructuredValue.isInstance(r)&&(A=r.valueName()),!(A&&-1!=A.indexOf("<<")&&A.indexOf(">>")>A.indexOf("<<")&&((new Ye).validateValue(e,t),h))){if((new qe).validate(e,t),d.range().key()==Ee.Universe08.MimeType||d.range().key()==Ee.Universe10.MimeType||d.nameId()==Ee.Universe10.TypeDeclaration.properties.name.name&&a.property().nameId()==Ee.Universe10.MethodBase.properties.body.name)return void(new Je).validate(e,t);if((u(d)||s(d))&&(new ht).validate(e,t),p(d)){if("RAML08"==f){var E=e.lowLevel().parent(),_=me.Kind.SEQ;ce.LowLevelProxyNode.isInstance(e.lowLevel())?E.valueKind()!=_&&t.accept(Z(xe.SECUREDBY_LIST_08,{},e,!1)):E.kind()!=_&&t.accept(Z(xe.SECUREDBY_LIST_08,{},e,!1))}if((new ht).validate(e,t),"RAML10"==f&&ve.StructuredValue.isInstance(r)){var T=r,N=T.children().filter(function(e){return"scopes"==e.valueName()});if(N.length>0){var S=e.findReferencedValue();if(S){var b=[];N.forEach(function(e){var t=e.children();if(t.length>0)t.forEach(function(e){var t=e.lowLevel().value();null==t||h&&t.indexOf("<<")>=0||b.push(e)});else{var n=e.lowLevel().value();null==n||h&&n.indexOf("<<")>=0||b.push(e)}});var I={},R=S.element(ye.universesInfo.Universe10.AbstractSecurityScheme.properties.settings.name);if(R){var M=R.attributes(ye.universesInfo.Universe10.OAuth2SecuritySchemeSettings.properties.scopes.name);M.forEach(function(e){return I[e.value()]=!0})}for(var w=0,C=b;w<C.length;w++){var L=C[w],P=L.lowLevel().value();I.hasOwnProperty(P)||t.accept(te(xe.INVALID_SECURITY_SCHEME_SCOPE,{invalidScope:P,securityScheme:S.name(),allowedScopes:Object.keys(I).map(function(e){return"'"+e+"'"}).join(", ")},L.lowLevel(),e,!1))}}}}}if(d.nameId()==Ee.Universe10.TypeDeclaration.properties.name.name){var O=a.property()&&a.property().nameId();if(O==Ee.Universe08.Resource.properties.uriParameters.name||O==Ee.Universe08.Resource.properties.baseUriParameters.name)return}var D=d.range().key();if(D==Ee.Universe08.RelativeUriString||D==Ee.Universe10.RelativeUriString)return void(new $e).validate(e,t);if(D==Ee.Universe08.FullUriTemplateString||D==Ee.Universe10.FullUriTemplateString)return void(new $e).validate(e,t);if("pattern"==e.name()&&Ee.Universe10.StringType==e.definition().key()&&l.isAssignableFrom("StringTypeDeclaration")&&He(e.value(),t,e),"name"==e.name()&&Ee.Universe10.StringType==e.definition().key()&&"string"==typeof e.value()&&0==e.value().indexOf("[")&&e.value().lastIndexOf("]")==e.value().length-1&&ve.ASTNodeImpl.isInstance(a)&&Ee.Universe10.ObjectTypeDeclaration.properties.properties.name==a.property().nameId()&&ve.ASTNodeImpl.isInstance(a.parent())&&Ee.Universe10.ObjectTypeDeclaration==a.parent().definition().key()){var U=e.value().substr(1,e.value().length-2);He(U,t,e)}n.isReference()||n.isDescriminator()?(new Ze).validate(e,t):(new ze).validate(e,t)}},e}();t.isValid=C;var Xe=function(e){function t(n,r){void 0===r&&(r={});var i=e.call(this)||this;return i.messageEntry=n,i.parameters=r,i.isWarning=!1,i.getClassIdentifier=t.prototype.getClassIdentifier,i}return se(t,e),t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&de.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_ValidationError)},t.prototype.getClassIdentifier=function(){var e=[];return e.concat(t.CLASS_IDENTIFIER_ValidationError)},t.CLASS_IDENTIFIER_ValidationError="linter.ValidationError",t}(Error),ze=function(){function e(){}return e.prototype.validate=function(e,t){var n=e.value(),r=e.property(),i=r.range(),a=i.getAdapter(Ne.RAMLService).getDeclaringNode();if(a&&i.isUserDefined()){var o=a.parsedType(),s=e.parent().lowLevel().dumpToObject(),u=s[e.parent().name()],l=r.canBeValue(),p=l||null===u||void 0===u?u:u[r.nameId()],c=o.validate(p,!0);c.isOk()||c.getErrors().forEach(function(n){return t.accept(ee(n.getCode(),n.getMessage(),e,!1))})}var f=t;if(e.lowLevel().keyKind()!=me.Kind.SEQ)var h=C(r.range(),e.parent(),n,r,e);else h=!0;if(h instanceof Error&&!h.canBeRef)return Xe.isInstance(h)?f.accept(Q(h,e)):f.accept(Z(xe.SCHEMA_EXCEPTION,{msg:h.message},e,h.isWarning)),void(h=null);if(!h||h instanceof Error)if("value"!=r.nameId()){if(!x(r,e,n,f)){if((r.nameId()==Ee.Universe10.TypeDeclaration.properties.schema.name||Ee.Universe10.TypeDeclaration.properties.type.name)&&n&&n.trim()&&(r.domain().key()==Ee.Universe08.BodyLike||r.domain().key()==Ee.Universe10.TypeDeclaration)){var d=n.trim().charAt(0);if("{"!=d&&"<"!=d)return}var m=e.findReferencedValue();if(m instanceof Error){var y=e.findReferenceDeclaration();if(y){var v=void 0,g=void 0;if(Xe.isInstance(m)){var A=m;v=Q(A,y),g=Z(A.messageEntry,{msg:A.message},e)}else v=Z(xe.SCHEMA_EXCEPTION,{msg:m.message},y),g=Z(xe.SCHEMA_EXCEPTION,{msg:m.message},e);v.extras.push(g),f.accept(v)}}if(!m){if(n&&r.nameId()==Ee.Universe10.TypeDeclaration.properties.schema.name){var E=n.trim();if("{"!=E.charAt(0)&&"<"!=E.charAt(0)&&(-1!=n.indexOf("|")||-1!=n.indexOf("[]")||-1!=n.indexOf("(")))return}if(h instanceof Error&&n)return Xe.isInstance(h)?f.accept(Q(h,e)):f.accept(Z(xe.SCHEMA_EXCEPTION,{msg:h.message},e)),void(h=null);if(e.property().isRequired()&&null==e.value())f.accept(Z(xe.EMPTY_VALUE_NOT_ALLOWED,{},e));else{var _=e.lowLevel().valueKind();_!=me.Kind.MAP&&_!=me.Kind.SEQ&&_!=me.Kind.MAPPING||f.accept(Z(xe.EMPTY_VALUE_NOT_ALLOWED,{},e))}}}}else{var T=r.range().key()==Ee.Universe08.SchemaString;if(h instanceof Error){var N=h.message;oe(e,f,xe.SCHEMA_ERROR.code,T)||f.accept(Z(xe.SCHEMA_ERROR,{msg:N},e,T))}else{var n=e.value();f.accept(Z(xe.INVALID_VALUE_SCHEMA,{iValue:n},e,T))}}var S=r.enumOptions();if(S){var b=e.parent()&&e.parent().definition(),I=b&&b.isAssignableFrom(Ee.Universe10.Api.name),R=b&&b.isAssignableFrom(Ee.Universe08.Api.name),M=r.nameId()===Ee.Universe08.Api.properties.protocols.name,w=r.nameId()===Ee.Universe10.Api.properties.protocols.name;if("string"!=typeof n)return;!R&&!I||!M&&!w||O(n)||(n=n.toUpperCase()),"string"==typeof S?S!=n&&(n&&0==n.indexOf("x-")&&r.nameId()==Ee.Universe08.AbstractSecurityScheme.properties.type.name||f.accept(Z(xe.INVALID_VALUE,{iValue:n,aValues:"'"+S+"'"},e))):S.length>0&&(de.find(S,function(e){return e==n})||n&&0==n.indexOf("x-")&&r.nameId()==Ee.Universe08.AbstractSecurityScheme.properties.type.name||f.accept(Z(xe.INVALID_VALUE,{iValue:n,aValues:S.map(function(e){return"'"+e+"'"}).join(", ")},e)))}},e}(),$e=function(){function e(){}return e.prototype.validate=function(e,t){try{var n=(new Qe).parseUrl(e.value()||"");if(n.some(function(e){return"version"==e})&&"baseUri"==e.property().nameId()){var r=e.root().attr("version");r||t.accept(Z(xe.MISSING_VERSION,{},e,!1))}n.some(function(e){return 0==e.length})&&t.accept(Z(xe.URI_PARAMETER_NAME_MISSING,{},e,!1))}catch(n){t.accept(Z(xe.URI_EXCEPTION,{msg:n.message},e,!1))}},e}(),Je=function(){function e(){}return e.prototype.validate=function(e,t){try{var n=e.value();if("body"==n&&e.parent().parent()){var r=e.parent().parent().definition().key();(r===Ee.Universe08.Response||r===Ee.Universe10.Response||e.parent().parent().definition().isAssignableFrom(Ee.Universe10.MethodBase.name))&&(n=e.parent().computedValue("mediaType"))}if(null!=c(e)&&"string"==typeof n&&n.indexOf("<<")>=0)return;var i=be.parseMediaType(n);if(!i)return;i.type.match(/[\w\d][\w\d!#\$&\-\^_+\.]*/)||t.accept(Z(xe.INVALID_MEDIATYPE,{mediaType:i.type},e))}catch(n){t.accept(Z(xe.MEDIATYPE_EXCEPTION,{msg:n.message},e))}(e.value()&&"multipart/form-data"==e.value()||"application/x-www-form-urlencoded"==e.value())&&e.parent()&&e.parent().parent()&&e.parent().parent().property()&&e.parent().parent().property().nameId()==Ee.Universe10.MethodBase.properties.responses.name&&t.accept(Z(xe.FORM_IN_RESPONSE,{},e,!0))},e}(),Qe=function(){function e(){}return e.prototype.checkBaseUri=function(e,t,n,r){var i=t.root().attr("baseUri");if(i){var a=i.value();try{var o=this.parseUrl(a);de.find(o,function(e){return e==n})||r.accept(Z(xe.UNUSED_URL_PARAMETER,{paramName:""},e))}catch(e){}}else r.accept(Z(xe.UNUSED_URL_PARAMETER,{paramName:""},e))},e.prototype.parseUrl=function(e){for(var t=[],n="",r=!1,i=0,a=0;a<e.length;a++){var o=e[a];"{"!=o?"}"!=o?r&&(n+=o):(i--,r=!1,t.push(n),n=""):(i++,r=!0)}if(i>0)throw new Error(ie(xe.INVALID_RESOURCE_NAME_UNMATCHED_SYMBOL,{symbol:"{"}));if(0>i)throw new Error(ie(xe.INVALID_RESOURCE_NAME_UNMATCHED_SYMBOL,{symbol:"}"}));return t},e.prototype.validate=function(e,t){var n=e.value();if(e.parent().property().nameId()==Ee.Universe10.Api.properties.baseUri.name){var r=e.parent().parent();return void this.checkBaseUri(e,r,n,t)}var r=e.parent().parent(),i=r.name();if(r.definition().key()===Ee.Universe10.Api||r.definition().key()===Ee.Universe08.Api)return void this.checkBaseUri(e,r,n,t);if(r.definition().key()!=Ee.Universe10.ResourceType&&r.definition().key()!=Ee.Universe08.ResourceType)try{var a=this.parseUrl(i),o=de.find(a,function(e){return e==n});if(!o){var s=e.root().attr(Ee.Universe10.Api.properties.baseUri.name);if(s&&e.name()===Ee.Universe08.Api.properties.baseUriParameters.name){var u=s.value();if(u&&(a=this.parseUrl(u),a&&a.length>0&&de.find(a,function(e){return e==n})))return}t.accept(Z(xe.UNUSED_URL_PARAMETER,{paramName:"'"+n+"'"},e))}}catch(e){}},e}();t.UrlParameterNameValidator=Qe,t.typeToName={},t.typeToName[Ee.Universe08.Trait.name]="trait",t.typeToName[Ee.Universe08.ResourceType.name]="resource type",t.typeToName[Ee.Universe10.Trait.name]="trait",t.typeToName[Ee.Universe10.ResourceType.name]="resource type",t.typeToName[Ee.Universe10.AbstractSecurityScheme.name]="security scheme",t.typeToName[Ee.Universe10.Method.name]="method",t.typeToName[Ee.Universe08.Method.name]="method",t.typeToName[Ee.Universe10.Resource.name]="resource",t.typeToName[Ee.Universe08.Resource.name]="resource",t.typeToName[Ee.Universe10.Api.name]="api",t.typeToName[Ee.Universe08.Api.name]="api",t.typeToName[Ee.Universe10.Response.name]="response",t.typeToName[Ee.Universe08.Response.name]="response",t.typeToName[Ee.Universe08.BodyLike.name]="body",t.parameterPropertyToName={},t.parameterPropertyToName[Ee.Universe08.MethodBase.properties.headers.name]="header",t.parameterPropertyToName[Ee.Universe08.MethodBase.properties.queryParameters.name]="query parameter",t.parameterPropertyToName[Ee.Universe08.Api.properties.uriParameters.name]="uri parameter",t.parameterPropertyToName[Ee.Universe08.Api.properties.baseUriParameters.name]="base uri parameter",t.parameterPropertyToName[Ee.Universe08.BodyLike.properties.formParameters.name]="form parameter",t.parameterPropertyToName[Ee.Universe10.MethodBase.properties.headers.name]="header",t.parameterPropertyToName[Ee.Universe10.MethodBase.properties.queryParameters.name]="query parameter",t.parameterPropertyToName[Ee.Universe10.ResourceBase.properties.uriParameters.name]="uri parameter",t.parameterPropertyToName[Ee.Universe10.Api.properties.baseUriParameters.name]="base uri parameter",t.parameterPropertyToName[Ee.Universe10.MethodBase.properties.body.name]="body",t.getHumanReadableNodeName=D;var Ze=function(){function e(){}return e.prototype.validate=function(e,t){var n=e.value(),r=n,i=e.property();if("string"==typeof n){if(x(i,e,n,t),ye.ReferenceType.isInstance(i.range())){var a=(i.range(),ue.createNode(""+n,e.lowLevel().parent(),e.lowLevel().unit()));a._actualNode().startPosition=e.lowLevel().valueStart(),a._actualNode().endPosition=e.lowLevel().valueEnd();var o=new ve.StructuredValue(a,e.parent(),e.property()),s=o.toHighLevel();s&&s.validate(t)}}else if(ve.StructuredValue.isInstance(n)){var u=n;if(u){r=u.valueName();var l=u.valueName();if(!x(i,e,l,t)){var p=u.toHighLevel();p&&p.validate(t)}}else r=null}else"number"==typeof n||"boolean"==typeof n?e.definition().isAssignableFrom(Ee.Universe10.Reference.name)&&x(i,e,n+"",t):e.definition().isAssignableFrom(Ee.Universe10.Reference.name)&&x(i,e,null,t);if(r){var c=C(i.range(),e.parent(),r,i);c instanceof Error&&(Xe.isInstance(c)?t.accept(Q(c,e)):t.accept(Z(xe.SCHEMA_EXCEPTION,{msg:c.message},e,c.isWarning)),c=null)}},e}(),et=function(){function e(){}return e.prototype.validate=function(e,t){var n=e.universe(),r=n.getTypedVersion();if(r){if("0.8"!==r&&"1.0"!==r){var i=Z(xe.UNKNOWN_RAML_VERSION,{},e);t.accept(i)}var a=n.getOriginalTopLevelText();if(a){var o={typeName:a};if(a!=e.definition().nameId()){if("Api"==e.definition().nameId()){var i=Z(xe.UNKNOWN_TOPL_LEVEL_TYPE,o,e);t.accept(i)}}else if("Api"==n.getOriginalTopLevelText()){var i=Z(xe.REDUNDANT_FRAGMENT_NAME,o,e);t.accept(i)}}}},e}(),tt=function(){function e(){}return e.prototype.validate=function(e,t){var n=this;e.definition().getAdapter(Ne.RAMLService).getContextRequirements().forEach(function(n){if(!e.checkContextValue(n.name,n.value,n.value)){var r={v1:n.name,v2:n.value,v3:e.definition().nameId()},i=xe.CONTEXT_REQUIREMENT_VIOLATION;"location"==n.name&&"ParameterLocation.FORM"==n.value&&(i=xe.WEB_FORMS),t.accept(Z(i,r,e))}});var r,i=e.definition().getAdapter(Ne.RAMLService).isInlinedTemplates();if(i){for(var a={},o=0,s=e.lowLevel().children();o<s.length;o++){var u=s[o];a[u.key()]=u.value(!0)}for(var l=e.definition().isAssignableFrom(Ee.Universe10.Trait.name)?"trait":"resource type",p=be.toUnits(e),c=new be.ValueTransformer(l,e.definition().nameId(),p,a),f=e.parent(),h=f?f.definition():e.definition();null!=f&&!_e.isResourceType(h)&&!_e.isMethodType(h);)f=f.parent();r=new be.DefaultTransformer(f,c,p)}e.definition().requiredProperties().forEach(function(a){if(i){var o=a.getAdapter(Ne.RAMLPropertyService).meta("templatePaths");if(o){for(var s=e.parent(),u=!1,l=0,p=o;l<p.length;l++){var c=p[l];if(c=c.map(function(e){return r.transform(e).value}),n.checkPathSufficiency(s.lowLevel(),c,s)){u=!0;break}}if(!u)return}}var f=a.range();if(f.hasArrayInHierarchy()&&(f=f.arrayInHierarchy().componentType()),f.hasValueTypeInHierarchy()){var h=e.attr(a.nameId()),d=!1;if(null!=h&&(h.lowLevel().kind()==me.Kind.SCALAR||h.lowLevel().resolvedValueKind()==me.Kind.SCALAR?null!=h.value()&&(d=!0):0!=h.lowLevel().children().length&&(d=!0)),!d){var m={propName:a.nameId()},y=xe.MISSING_REQUIRED_PROPERTY;i&&(y=xe.VALUE_NOT_PROVIDED);var v=Z(y,m,e);t.accept(v)}}else{var g=e.elementsOfKind(a.nameId());if(!g||0==g.length){var v=Z(xe.MISSING_REQUIRED_PROPERTY,{propName:a.nameId()},e);t.accept(v)}}})},e.prototype.checkPathSufficiency=function(e,t,n){if(null==n||null==n.definition())return!1;var r=n.definition();if(_e.isResourceTypeType(r)||_e.isTraitType(r))return!0;if(0==t.length)return!1;if(null==e)return!1;var i=t[0];if(null==i)return!1;if("/"==i)return this.checkPathSufficiency(e,t.slice(1),n);if(0==i.length)return!0;var a=e.children().filter(function(e){return e.key()==i});0==a.length&&t.indexOf("/")<0;var o=a[0];if(ce.LowLevelCompositeNode.isInstance(o)&&(o=o.primaryNode()),null==o)return t.indexOf("/")<0;if("type"==o.key())return!0;if(1==t.length)return null==o||null==o.value();var s=t.slice(1);return this.checkPathSufficiency(o,s,n)},e}(),nt=function(){function e(){}return e.prototype.validate=function(e,t){var n=e.lowLevel().unit();e.lowLevel().visit(function(r){if(r.unit()!=n)return!1;if(r.value()&&r._node&&r._node.value&&r._node.value.doubleQuoted){var i=(r.value()+"").indexOf(":"),a=(r.value()+"").indexOf("\n");if(-1!=i&&-1!=a&&(!r.includePath()||0==r.includePath().length)){var o=Z(xe.SUSPICIOUS_DOUBLEQUOTE,{value:r.value()},e,!0);o.start=r._node.value.startPosition,o.end=r._node.value.endPosition,o.start==o.end&&o.end++,t.accept(o)}}return!0})},e}(),rt=function(){function e(){}return e.prototype.validate=function(e,t){var n=e.definition(),r=n.getAdapter(Ne.RAMLService).getDeclaringNode();if(r){var i=r.parsedType(),a=e.lowLevel().dumpToObject(!0);a&&(a=a[Object.keys(a)[0]]);var o=i.validate(a,!1,!1);o.isOk()||(_e.isAnnotationsProperty(e.property())?o.getErrors().forEach(function(n){if("nothing"==n.getMessage()){var r=e.parent().types(),a=r&&r.getAnnotationTypeRegistry(),o=new ve.StructuredValue(e.lowLevel(),e.parent(),e.property()),s=o.valueName(),u=i.allFacets().filter(function(e){return e.kind()==ye.tsInterfaces.MetaInformationKind.ImportedByChain});if(u.length>0&&a&&a.getByChain(s)){var l=u[0].value();t.accept(Z(xe.LIBRARY_CHAINIG_IN_ANNOTATION_TYPE_SUPERTYPE,{typeName:s,chainedType:l},e))}else t.accept(Z(xe.UNKNOWN_ANNOTATION_TYPE,{typeName:s},e))}else t.accept(ee(n.getCode(),n.getMessage(),j(e,n).node,!1))}):o.getErrors().forEach(function(n){return t.accept(ee(n.getCode(),n.getMessage(),j(e,n).node,!1))}))}},e}(),it=function(){function e(){this.annotables={API:!0,DocumentationItem:!0,Resource:!0,Method:!0,Response:!0,RequestBody:!0,ResponseBody:!0,TypeDeclaration:!0,Example:!0,ResourceType:!0,Trait:!0,SecurityScheme:!0,SecuritySchemeSettings:!0,AnnotationType:!0,Library:!0,Overlay:!0,Extension:!0}}return e.prototype.validate=function(e,t){var n=(e.definition(),e.parsedType()),r=n.validateType(e.types().getAnnotationTypeRegistry());if(!r.isOk())for(var i=0,a=r.getErrors();i<a.length;i++){var o=a[i],s=W(o,e.lowLevel().unit().project()),u=void 0,l=j(e,o);if(l.node==e&&!l.internalPathUsed){var p=o.getValidationPath();if(p&&p.name==ye.universesInfo.Universe10.TypeDeclaration.properties.type.name&&e.attr(ye.universesInfo.Universe10.TypeDeclaration.properties.schema.name)){var c=p.name;p.name=ye.universesInfo.Universe10.TypeDeclaration.properties.schema.name,l=j(e,o),p.name=c}}var f=l.internalPathUsed?null:o.getInternalRange();if(s){if(u=ne(o.getCode(),o.getMessage(),s,l.node,o.isWarning(),!0,f),s.unit().absolutePath()!=e.lowLevel().unit().absolutePath()){var h=ee(o.getCode(),o.getMessage(),e,o.isWarning());u.extras.push(h)}}else{if(o.getFilePath()&&o.getFilePath()!=e.lowLevel().unit().absolutePath()){var d=e.lowLevel().unit().project().unit(o.getFilePath(),!0);if(d){var m=d.highLevel();if(m){u=ee(o.getCode(),o.getMessage(),m,o.isWarning(),f,!0);var h=ee(o.getCode(),o.getMessage(),l.node,o.isWarning());u.extras.push(h)}}}if(!u){if(oe(l.node,t,o.getCode(),o.isWarning()))continue;u=ee(o.getCode(),o.getMessage(),l.node,o.isWarning(),f)}}var y=o.getFilePath();if(null!=y){var v=e.lowLevel().unit().project().unit(y);v&&(u.unit=v,u.path=y)}t.accept(u)}var g=e.lowLevel()&&de.find(e.lowLevel().children(),function(e){return"examples"==e.key()});if(g&&g.valueKind&&g.valueKind()===me.Kind.SEQ){var u=te(xe.MAP_EXPECTED,{},g,e,!1);t.accept(u)}if(e.property()&&_e.isAnnotationTypesProperty(e.property())||ve.isAnnotationTypeFragment(e))for(var A=e.attributes(Ee.Universe10.TypeDeclaration.properties.allowedTargets.name),E=0,_=A;E<_.length;E++){var T=_[E];this.checkAnnotationTarget(T,t)}},e.prototype.checkAnnotationTarget=function(e,t){var n=e.value();if(null!=n){if("string"!=typeof n)return void t.accept(Z(xe.ANNOTATION_TARGET_MUST_BE_A_STRING,{},e,!1));var r=n;n.replace(/\w|\s/g,"").length>0?t.accept(Z(xe.ALLOWED_TARGETS_MUST_BE_ARRAY,{},e,!1)):this.annotables[r]||t.accept(Z(xe.UNSUPPORTED_ANNOTATION_TARGET,{
aTarget:r},e,!1))}},e}(),at=function(){function e(){}return e.prototype.validate=function(e,t){if(!e.definition().isAnnotationType()){if(e.lowLevel().keyKind()==me.Kind.SEQ){var n=e.definition().isAssignableFrom(Ee.Universe10.TypeDeclaration.name);n||t.accept(Z(xe.NODE_KEY_IS_A_SEQUENCE,{},e))}var r=e.name();if(null==r&&(r=e.lowLevel().key(),null==r&&(r="")),e.definition().key()==Ee.Universe08.GlobalSchema&&e.lowLevel().valueKind()!=me.Kind.SCALAR){var o=!1;if(e.lowLevel().valueKind()==me.Kind.ANCHOR_REF||e.lowLevel().valueKind()==me.Kind.INCLUDE_REF){var s=e.lowLevel().value();"string"==typeof s&&(o=!0)}o||t.accept(Z(xe.SCHEMA_NAME_MUST_BE_STRING,{name:r},e))}e.parent()||((new et).validate(e,t),e.definition().key()!=Ee.Universe08.Api&&e.definition().key()!=Ee.Universe10.Api||(new Se).validateApi(e.wrapperNode(),t),(new nt).validate(e,t),a(e,t)),(new lt).validate(e,t);var u=e.definition();if(u.key()==Ee.Universe08.BodyLike&&e.lowLevel().children().map(function(e){return e.key()}).some(function(e){return"formParameters"===e}))if(e.parent()&&e.parent().definition().key()==Ee.Universe08.Response){var l=Z(xe.FORM_PARAMS_IN_RESPONSE,{},e);t.accept(l)}else if(e.lowLevel().children().map(function(e){return e.key()}).some(function(e){return"schema"===e||"example"===e})){var l=Z(xe.FORM_PARAMS_WITH_EXAMPLE,{},e);t.accept(l)}if(u.key()==Ee.Universe10.OAuth2SecuritySchemeSettings){var p=!1;if(e.attributes("authorizationGrants").forEach(function(e){var n=e.value();if("authorization_code"===n||"implicit"===n)p=!0;else if("password"!==n&&"client_credentials"!==n&&n&&"string"==typeof n&&-1==n.indexOf("://")&&-1==n.indexOf(":")){var r=Z(xe.AUTHORIZATION_GRANTS_ENUM,{},e);t.accept(r)}}),p&&!e.attr("authorizationUri")){var l=Z(xe.AUTHORIZATION_URI_REQUIRED,{},e);t.accept(l)}}if(e.definition().isAssignableFrom(Ee.Universe08.Parameter.name)||e.definition().isAssignableFrom(Ee.Universe10.TypeDeclaration.name)){var f=e.attributes("enum").map(function(e){return e.value()});if(f.length!=de.uniq(f).length){var l=Z(xe.REPEATING_COMPONENTS_IN_ENUM,{},e);t.accept(l)}if(e.definition().isAssignableFrom(Ee.Universe08.NumberTypeDeclaration.name)||e.definition().isAssignableFrom(Ee.Universe10.NumberTypeDeclaration.name)){var h=e.definition().isAssignableFrom(Ee.Universe08.IntegerTypeDeclaration.name)||e.definition().isAssignableFrom(Ee.Universe10.IntegerTypeDeclaration.name);e.attributes("enum").forEach(function(e){var n=h?parseInt(e.value()):parseFloat(e.value()),r=h?!isNaN(n)&&-1===e.value().indexOf("."):!isNaN(n);if(!r){var i=Z(h?xe.INTEGER_EXPECTED:xe.NUMBER_EXPECTED_2,{},e);t.accept(i)}})}}_e.isResourceTypeType(e.definition())&&null==e.value()&&0==e.lowLevel().children().length&&"RAML08"==e.definition().universe().version()&&e.lowLevel().resolvedValueKind()==me.Kind.SCALAR&&t.accept(Z(xe.RESOURCE_TYPE_NULL,{},e)),i(e,t);var d=e.value();if(("string"==typeof d||"number"==typeof d||"boolean"==typeof d)&&!e.definition().getAdapter(Ne.RAMLService).allowValue()&&e.parent()&&"~"!=d){var m=null!=c(e)&&"string"==typeof d&&we.startsWith(d,"<<")&&we.endsWith(d,">>"),y=!0;if(""==d){var v=e.lowLevel().actual()&&e.lowLevel().actual().value;v&&(v.doubleQuoted||v.singleQuoted)||(y=!1)}if(y&&!m&&!oe(e,t,xe.SCALAR_PROHIBITED_2.code)){var l=Z(xe.SCALAR_PROHIBITED_2,{name:r},e);t.accept(l)}}(new tt).validate(e,t),(new ft).validate(e,t),(new ut).validate(e,t)}},e}(),ot=function(){function e(){}return e.prototype.validate=function(e,t){var n=e.attrValue(Ee.Universe10.TypeDeclaration.properties.name.name);"version"==n&&t.accept(Z(xe.VERSION_NOT_ALLOWED,{},e))},e}(),st=function(){function e(e,t,n,r){void 0===r&&(r=!1),this.definitions=e,this.propertyName=t,this.assignableFrom=r,this.validator=n}return e.prototype.validate=function(e,t){var n=e.definition();if(null!=n){var r=!1;if(r=this.assignableFrom?this.definitions.some(function(e){return n.isAssignableFrom(e.name)}):this.definitions.some(function(e){return e===n})){if(null!=this.propertyName){if(null==e.property())return;if(e.property().nameId()!=this.propertyName)return}this.validator.validate(e,t)}}},e}(),ut=function(){function e(){}return e.createRegistry=function(){var t=[];return e.registerValidator(t,[Ee.Universe10.TypeDeclaration,Ee.Universe08.Parameter],Ee.Universe10.Api.properties.baseUriParameters.name,new ot,!0),t},e.registerValidator=function(e,t,n,r,i){void 0===i&&(i=!1);var a=new st(t,n,r,i);e.push(a)},e.prototype.validate=function(t,n){e.entries.forEach(function(e){return e.validate(t,n)})},e.entries=e.createRegistry(),e}(),lt=function(){function e(){}return e.prototype.allowsAnyChildren=function(e,t){var n=e.property(),r=e.definition();return!!((_e.isAnnotationTypeType(r)||_e.isTypeDeclarationTypeOrDescendant(r))&&_e.isAnnotationTypesProperty(n)||e.parent()==t&&_e.isTypesProperty(n)&&_e.isTypeDeclarationTypeOrDescendant(r)||_e.isSchemasProperty(n)&&_e.isTypeDeclarationTypeOrDescendant(r)||e.parent()==t&&_e.isDocumentationProperty(n)&&_e.isDocumentationType(r)||_e.isAnnotationsProperty(n)||_e.isUsesProperty(n)||_e.isExamplesProperty(n))},e.prototype.nodeAllowedDueToParent=function(e,t){for(var n=e;n!=t&&null!=n;){if(this.allowsAnyChildren(n,t))return!0;n=n.parent()}return!1},e.prototype.validate=function(e,t){var n=e.root();if((!n.isExpanded()||n.lowLevel().unit().absolutePath()==e.lowLevel().unit().absolutePath())&&(e.property(),e.definition(),_e.isOverlayType(n.definition()))){if(e==n)return void this.validateProperties(e,t);if(!this.nodeAllowedDueToParent(e,n)){var r=n.knownIds();if(r){var i=r.hasOwnProperty(e.id());return i?void this.validateProperties(e,t):void t.accept(Z(xe.INVALID_OVERLAY_NODE,{nodeId:e.id()},e))}}}},e.prototype.validateProperties=function(e,t){var n=e.root(),r=n.lowLevel().unit().absolutePath(),i=n.isExpanded();e.attrs().forEach(function(n){i&&r!=n.lowLevel().unit().absolutePath()||n.property().getAdapter(Ne.RAMLPropertyService).isKey()||n.parent()==e&&(n.isElement()||_e.isTitlePropertyName(n.name())||_e.isDescriptionPropertyName(n.name())||_e.isDisplayNamePropertyName(n.name())||_e.isUsagePropertyName(n.name())||_e.isExampleProperty(n.property())||_e.isMasterRefProperty(n.property())||_e.isAnnotationsProperty(n.property())||_e.isUsesProperty(n.property())||t.accept(Z(xe.INVALID_OVERRIDE_IN_OVERLAY,{propName:n.name()},n)))})},e}(),pt=function(){function e(){}return e.prototype.validate=function(e,t){var n=this,r=new lt;r.validate(e,t),e.directChildren().forEach(function(e){e.isElement()&&n.validate(e.asElement(),t)})},e}(),ct=function(){function e(){}return e.prototype.val=function(e,t,n){var r=this;if(e.kind()==me.Kind.MAP||e.kind()==me.Kind.MAPPING){var i={};e.children().forEach(function(e){var r=e.key();if(r){if(i.hasOwnProperty(r)){var a=Z(xe.KEYS_SHOULD_BE_UNIQUE,{},n,!1);e.unit()==n.lowLevel().unit()&&(a.start=e.keyStart(),a.end=e.keyEnd()),t.accept(a)}i[r]=1}})}e.children().forEach(function(e){r.val(e,t,n)})},e.prototype.validate=function(e,t){this.val(e.lowLevel(),t,e)},e}(),ft=function(){function e(){}return e.prototype.validate=function(e,t){this.validateChildElements(e,t);var n=e.lowLevel().children(),r=de.groupBy(n.filter(function(e){return null!=e.key()}),function(e){return e.key()});this.validateChildAttributes(e,r,t),this.validateUnrecognizedLowLevelChildren(e,r,t)},e.prototype.validateChildElements=function(e,t){var n={},r=e.directChildren().filter(function(e){return e.isElement()});r.forEach(function(e){var t=e;if(!t._computed&&t.name()){var r=t.name()+t.property().nameId();n.hasOwnProperty(r)?t.isNamePatch()||n[r].push(t):n[r]=[t]}}),Object.keys(n).forEach(function(e){var r=n[e];!r||r.length<2||r.forEach(function(e){var n=D(e),r={name:e.name()},i=xe.ALREADY_EXISTS_IN_CONTEXT;n&&(r.capitalized=De.upperCaseFirst(n),i=xe.ALREADY_EXISTS);var a=Z(i,r,e);t.accept(a)})})},e.prototype.validateChildAttributes=function(e,t,n){var r=this.getHighLevelAttributes(e),i=de.groupBy(r,function(e){return e.name()}),a=this.allowsAnyAndHasRequireds(e);Object.keys(i).forEach(function(r){if(!(i[r].length<2)){var o=i[r][0].isUnknown(),s=!o&&i[r][0].property().isMultiValue();s&&(e.definition().isAssignableFrom(Ee.Universe08.SecuritySchemeSettings.name)||e.definition().isAssignableFrom(Ee.Universe10.SecuritySchemeSettings.name))&&(s=t[r]&&1===t[r].length),(o&&a||!s||s&&null!=t[r]&&t[r].length>1)&&i[r].forEach(function(e){var t={propName:e.property()?e.property().nameId():e.name()},r=xe.PROPERTY_USED,i=D(e.parent());i&&(t.parent=De.upperCaseFirst(i),r=xe.PARENT_PROPERTY_USED);var a=Z(r,t,e);n.accept(a)})}})},e.prototype.validateUnrecognizedLowLevelChildren=function(e,t,n){var r=e.directChildren(),i=de.groupBy(r,function(e){return e.name()});Object.keys(t).forEach(function(r){if(r&&t[r].length>1&&!i[r]){if(e.definition().isAssignableFrom(Ee.Universe10.ObjectTypeDeclaration.name))return;var a={propName:r},o=xe.PROPERTY_USED,s=D(e);s&&(a.parent=De.upperCaseFirst(s),o=xe.PARENT_PROPERTY_USED),t[r].forEach(function(t){var r=te(o,a,t,e);r.start=t.keyStart(),r.end=t.keyEnd(),n.accept(r)})}})},e.prototype.filterMultiValueAnnotations=function(e,t,n){this.getHighLevelAttributes(e),Object.keys(t).forEach(function(e){"("!==e.charAt(0)||t[e].length<2})},e.prototype.getHighLevelAttributes=function(e){var t=this.allowsAnyAndHasRequireds(e);return e.directChildren().filter(function(e){return e.isAttr()||t})},e.prototype.allowsAnyAndHasRequireds=function(e){var t=e.definition().requiredProperties(),n=t&&t.length>0,r=e.definition().getAdapter(Ne.RAMLService),i=r&&r.getAllowAny(),a=i&&n;return a},e}(),ht=function(){function e(){}return e.prototype.validate=function(e,t){var n=this.isStrict(e);if(n||Fe.validateNotStrictExamples){var r=this.parseObject(e,t,n);if(null!=r){var i=this.aquireSchema(e);if(i){var a=r;"object"==typeof a&&(a=e.value()),i.validate(a,t,n)}}}},e.prototype.isExampleNode=function(e){return this.isSingleExampleNode(e)||this.isExampleNodeInMultipleDecl(e)},e.prototype.isSingleExampleNode=function(e){return e.name()==Ee.Universe10.TypeDeclaration.properties.example.name},e.prototype.isExampleNodeInMultipleDecl=function(e){var t=e.parent();return!!t&&_e.isExampleSpecType(t.definition())},e.prototype.findParentSchemaOrTypeAttribute=function(e){var t=e.parent().attr(Ee.Universe10.TypeDeclaration.properties.schema.name);return t?t:(t=e.parent().attr(Ee.Universe10.TypeDeclaration.properties.type.name))?t:e.parent()?(t=e.parent().parent().attr(Ee.Universe10.TypeDeclaration.properties.schema.name))?t:(t=e.parent().parent().attr(Ee.Universe10.TypeDeclaration.properties.type.name),t?t:null):null},e.prototype.aquireSchema=function(e){var t=e.parent().definition().isAssignableFrom(Ee.Universe10.TypeDeclaration.name);if(this.isExampleNode(e)){var n=e;if(this.isExampleNodeInMultipleDecl(e)&&(n=e.parent()),n.parent()&&(n.parent().definition().isAssignableFrom(Ee.Universe10.TypeDeclaration.name)&&null===n.parent().parent()?t=!1:n.parent().property().nameId()==Ee.Universe10.LibraryBase.properties.types.name&&(t=!1),n.parent().parent())){var r=n.parent().parent().definition().key();r!=Ee.Universe08.Method&&r!=Ee.Universe10.Method||n.parent().property().nameId()==Ee.Universe10.MethodBase.properties.queryParameters.name||(t=!0),r!=Ee.Universe08.Response&&r!=Ee.Universe10.Response||(t=!0)}}if(e.parent().definition().key()==Ee.Universe08.BodyLike||t){var i=this.findParentSchemaOrTypeAttribute(e);if(i){var a=i.value();if(ve.StructuredValue.isInstance(a))return null;var o=(""+a).trim(),s=null;if("{"==o.charAt(0))try{s=Pe.getJSONSchema(o,Y(i.lowLevel()))}catch(e){return null}if("<"==o.charAt(0))try{s=Pe.getXMLSchema(o)}catch(e){return null}if(s)return{validate:function(t,n,r){try{if(t.__$validated)return;if(s instanceof Error)return void n.accept(Z(xe.INVALID_VALUE_SCHEMA,{iValue:s.message},e,!r));s.validate(t)}catch(t){var a="Cannot assign to read only property '__$validated' of ";if(t.message&&0==t.message.indexOf(a)){var o=t.message.substr(a.length,t.message.length-a.length);return void n.accept(Z(xe.INVALID_JSON_SCHEMA,{propName:o},i,!r))}if("Object.keys called on non-object"==t.message)return;return Xe.isInstance(t)?void(oe(e,n,t.messageEntry.code,!r)||n.accept(Q(t,e,!r))):void n.accept(Z(xe.EXAMPLE_SCHEMA_FAILURE,{msg:t.message},e,!r))}}};if(o.length>0){var u=e.parent(),l=u&&u.parent(),p=u&&u.definition()&&u.definition().isAssignableFrom(Ee.Universe10.ObjectTypeDeclaration.name)&&u;if(p=p||l&&l.definition()&&l.definition().isAssignableFrom(Ee.Universe10.ObjectTypeDeclaration.name)&&l)return this.typeValidator(p,e)}}}return this.getSchemaFromModel(e)},e.prototype.getSchemaFromModel=function(e){var t=e.parent();return this.typeValidator(t,e)},e.prototype.typeValidator=function(e,t){var n={validate:function(n,r,i){var a=e.parsedType();if(a&&!a.isUnknown()){"number"==typeof n&&a.isString()&&(n=""+n),"boolean"==typeof n&&a.isString()&&(n=""+n),a.getExtra("repeat")&&(n=[n]);var o=a.validate(n,!1);o.isOk()||o.getErrors().forEach(function(e){return r.accept(ee(e.getCode(),e.getMessage(),t,!i,e.getInternalRange()))})}}};return n},e.prototype.toObject=function(e,t,n){var r=t.lowLevel().dumpToObject(!0);return this.testDublication(e,t.lowLevel(),n),r.example?r.example:r.content?r.content:void 0},e.prototype.testDublication=function(e,t,n){var r=this,i={};t.children().forEach(function(t){t.key()&&(i[t.key()]&&n.accept(Z(xe.KEYS_SHOULD_BE_UNIQUE,{},new ve.BasicASTNode(t,e.parent()))),i[t.key()]=t),r.testDublication(e,t,n)})},e.prototype.parseObject=function(e,t,n){var r=null,i=e.value(),a=X(e);if(ve.StructuredValue.isInstance(i))r=this.toObject(e,i,t);else if(a){if(q(a))try{ye.rt.getSchemaUtils().tryParseJSON(i,!0),r=JSON.parse(i)}catch(r){return void(Xe.isInstance(r)?oe(e,t,r.messageEntry.code,!n)||t.accept(Q(r,e,!n)):t.accept(Z(xe.CAN_NOT_PARSE_JSON,{msg:r.message},e,!n)))}if(G(a))try{r=Oe.parseXML(i)}catch(r){return void t.accept(Z(xe.CAN_NOT_PARSE_XML,{msg:r.message},e,!n))}}else try{if(!(i&&i.length>0)||"["!=i.trim().charAt(0)&&"{"!=i.trim().charAt(0)&&"<"!=i.trim().charAt(0))return i;r=JSON.parse(i)}catch(a){if(0!=i.trim().indexOf("<"))return i;try{r=Oe.parseXML(i)}catch(r){return void t.accept(Z(xe.CAN_NOT_PARSE_XML,{msg:r.message},e,!n))}}return null!=r&&"object"!=typeof r?i:r},e.prototype.isStrict=function(e){if(_e.isDefaultValue(e.property()))return!0;if(_e.isExampleProperty(e.property())&&"RAML08"==e.parent().definition().universe().version())return!1;var t=!1,n=e.parent().attr("strict");return n&&"true"==n.value()&&(t=!0),t},e}();t.ExampleAndDefaultValueValidator=ht;var dt=function(e,t,n){var r=De.sentence(e).toLowerCase();return t||(r=De.ucFirst(r)),n&&(r=Ue.plural(r)),r},mt=function(){function e(){}return e.prototype.validate=function(e,t){if(e.isAttr()){if(!e.optional())return;var n=e,r=n.property();if(r.isMultiValue()||r.range().isArray())return;if(!r.isFromParentKey()){var i=c(n.parent());if(i&&r.isValueProperty()){var a=Z(xe.OPTIONAL_SCLARAR_PROPERTIES_10,{templateName:i.nameId(),propName:n.name()},n,!1);t.accept(a)}}}else if(e.isElement()){var o=e,r=o.property(),s=o.allowsQuestion();s||o.optionalProperties().forEach(function(n){o.children().forEach(function(n){var i={propName:r.nameId(),oPropName:n.lowLevel().key()},a=Z(xe.OPTIONAL_PROPERTIES_10,i,e,!1);t.accept(a)})});var u=e.asElement().definition();if(e.optional()&&"RAML10"==u.universe().version()){var r=e.property(),l=_e.isQueryParametersProperty(r)||_e.isUriParametersProperty(r)||_e.isHeadersProperty(r);if(!(_e.isMethodType(u)||_e.isTypeDeclarationType(u)&&l)){var a=Z(xe.ONLY_METHODS_CAN_BE_OPTIONAL,{},e,!1);t.accept(a)}}}},e}(),yt=function(){function e(){}return e.prototype.validate=function(e,t){var n=e.definition(),r=Ee.Universe10.Api.properties.baseUri.name,i=Ee.Universe10.Api.properties.baseUriParameters.name,a=Ee.Universe10.Resource.properties.relativeUri.name,o=Ee.Universe10.ResourceBase.properties.uriParameters.name;if(_e.isApiSibling(n))this.inspectParameters(e,t,r,i);else if(_e.isResourceType(n)){var s=e.root();this.inspectParameters(e,t,r,i,s),this.inspectParameters(e,t,a,o)}else if(_e.isResourceTypeType(n)){var s=e.root();this.inspectParameters(e,t,r,i,s)}},e.prototype.inspectParameters=function(e,t,n,r,i){i=i||e;var a="",o=i.attr(n);o&&(a=o.value(),a&&"string"==typeof a||(a=""));var s=e.elementsOfKind(r);s.forEach(function(n){var i=n.attr(Ee.Universe10.TypeDeclaration.properties.name.name);if(i){var o=i.value();if(null!=o&&a.indexOf("{"+o+"}")<0){if(_e.isResourceTypeType(e.definition())&&o.indexOf("<<")>=0)return;var s=De.upperCaseFirst(Ue.singular(De.sentence(r))),u=Z(xe.PROPERTY_UNUSED,{propName:s},n,!0);t.accept(u)}}})},e}(),vt=function(){function e(){this.nameProperty=Ee.Universe10.ResourceType.properties.name.name}return e.prototype.validate=function(e,t){var n=e.definition();if(_e.isLibraryBaseSibling(n)||_e.isApiType(n)){var r=(Ee.Universe10.LibraryBase.properties.resourceTypes.name,Ee.Universe10.ResourceBase.properties.type.name),i=(Ee.Universe10.LibraryBase.properties.traits.name,Ee.Universe10.MethodBase.properties.is.name),a=Re.globalDeclarations(e).filter(function(e){return _e.isResourceTypeType(e.definition())}),o=Re.globalDeclarations(e).filter(function(e){return _e.isTraitType(e.definition())});this.checkCycles(a,r,t),this.checkCycles(o,i,t)}},e.prototype.checkCycles=function(e,t,n){var r=this,i={};e.forEach(function(e){var t=r.templateName(e);i[t]=e});var a={};e.forEach(function(e){var o=r.templateName(e);a[o]||r.findCyclesInDefinition(e,t,i).forEach(function(t){t.forEach(function(e){return a[e]=!0}),t=t.reverse();var r=dt(e.definition().nameId()),i=t.join(" -> "),o={typeName:r,cycle:i},s=Z(xe.CYCLE_IN_DEFINITION,o,e,!1);n.accept(s)})})},e.prototype.templateName=function(e){var t=e.attr(this.nameProperty);return t?t.value():null},e.prototype.findCyclesInDefinition=function(e,t,n,r){void 0===r&&(r={});var i=this.templateName(e);if(r[i])return[[i]];var a={};Object.keys(r).forEach(function(e){return a[e]=r[e]}),a[i]=!0;for(var o=[],s=e.attributes(t),u=0;u<s.length;u++){var l=s[u],p=l.value();if(p){var c="string"==typeof p||"number"==typeof p||"boolean"==typeof p?p+"":p.valueName(),f=n[c];if(null!=f){var h=this.findCyclesInDefinition(f,t,n,a);h.forEach(function(e){return o.push(e)})}}}return o.forEach(function(e){return e.push(i)}),o},e}();t.isJson=q,t.isXML=G,t.getMediaType=X;var gt=/^[ ]*/,At=function(e,t,n,r,i,a,o,s,u){void 0===u&&(u=!1);var l=o?o:e.lowLevel();if(s){var p=$(e,l,t,n,r,i,a,s,u);if(p)return p}var c=l.unit()&&l.unit().contents(),f=c&&c.length,h=l.start(),d=l.end();if(f&&d>f&&(d=f-1),l.key()&&l.keyStart()){var m=l.keyStart();m>0&&(h=m);var y=l.keyEnd();y>0&&(d=y)}if(h>d&&(d=h+1,e.isElement())){var v=e.definition();_e.isApiType(v)&&(h=0==f?0:f-1,d=h)}if(a&&!a.getAdapter(Ne.RAMLPropertyService).isMerged()&&null==e.parent()){var g=de.find(l.children(),function(e){return e.key()==a.nameId()});if(g){var m=g.keyStart(),y=g.keyEnd();m>0&&y>m&&(h=m,d=y)}}return{code:t,isWarning:n,message:r,node:e,start:h,end:d,path:i?l.unit()?l.unit().path():"":null,extras:[],unit:e?l.unit():null}},Et=function(e,t,n,r,i,a,o,s,u){if(void 0===s&&(s=!1),void 0===u&&(u=!1),o){var l=$(null,e,n,r,i,a,null,o,u,s);if(l)return l}var p=e.unit()&&e.unit().contents(),c=p&&p.length,f=e.start(),h=e.end();if(c&&h>=c&&(h=c-1),e.key()&&e.keyStart()){var d=e.keyStart();d>0&&(f=d);var m=e.keyEnd();m>0&&(h=m)}var y=e.value(!0);return s&&y&&y.length>0&&(f=e.valueStart(),h=e.valueEnd()),{code:n,isWarning:r,message:i,node:t,start:f,end:h,path:a?e.unit()?e.unit().path():"":null,extras:[],unit:e?e.unit():null}};t.toIssue=J,t.createIssue1=Z,t.createIssue=ee,t.createLLIssue=ne,t.validateResponseString=re,t.applyTemplate=ie;var _t=function(){function e(){this.propertiesMap={},this.init()}return e.getInstance=function(){return e.instance||(e.instance=new e),e.instance},e.prototype.init=function(){for(var e=ye.getUniverse.availableUniverses(),t=0,n=e;t<n.length;t++)for(var r=n[t],i=ye.getUniverse(r),a=0,o=i.types();a<o.length;a++)for(var s=o[a],u=0,l=s.properties();u<l.length;u++){var p=l[u];this.propertiesMap[p.nameId()]=!0}},e.prototype.hasProperty=function(e){return this.propertiesMap[e]||!1},e}(),Tt=function(){function e(){this.codesMap={},this.init()}return e.getInstance=function(){return e.instance||(e.instance=new e),e.instance},e.prototype.init=function(){for(var e=[xe.NODE_KEY_IS_A_MAP,xe.NODE_KEY_IS_A_SEQUENCE,xe.UNKNOWN_NODE,xe.INVALID_PROPERTY_USAGE,xe.INVALID_SUBRESOURCE_USAGE,xe.INVALID_METHOD_USAGE,xe.SPACES_IN_KEY,xe.UNKNOWN_ANNOTATION,xe.INVALID_ANNOTATION_LOCATION,xe.KEYS_SHOULD_BE_UNIQUE,xe.ALREADY_EXISTS,xe.ALREADY_EXISTS_IN_CONTEXT,xe.PROPERTY_USED,xe.PARENT_PROPERTY_USED,xe.UNKNOWN_ANNOTATION_TYPE,xe.LIBRARY_CHAINIG_IN_ANNOTATION_TYPE,xe.LIBRARY_CHAINIG_IN_ANNOTATION_TYPE_SUPERTYPE],t=0,n=e;t<n.length;t++){var r=n[t];this.codesMap[r.code]=!0}},e.prototype.isKeyError=function(e){return this.codesMap[e]||!1},e}()}).call(t,n(7))},function(e,t,n){"use strict";function r(e,t){if(void 0===t&&(t=!1),!e)return null;var n=e.kind();if(n==u.Kind.ANCHOR_REF&&(n=e.anchorValueKind()),n==u.Kind.INCLUDE_REF){if(null!=e.unit()){var i=e.includePath(),a=null;try{a=e.unit().resolve(i)}catch(e){}if(null==a)return null;if(!a.isRAMLUnit())return h.ASTNode.isInstance(e)&&!e.canInclude(a)?null:a.contents();if(h.ASTNode.isInstance(e)&&!e.canInclude(a))return null;var o=a.ast();if(o)return r(o,t)}return null}if(n==u.Kind.SEQ){for(var s=[],l=0,p=e.children();l<p.length;l++){var c=p[l];s.push(r(c,t))}return s}if(n==u.Kind.ANCHOR_REF)return r(e.anchoredFrom(),t);if(n==u.Kind.MAPPING){var f={},d=""+e.key(!0),m=e.valueKind();if(m==u.Kind.ANCHOR_REF&&(m=e.anchorValueKind()),m==u.Kind.INCLUDE_REF){var y=e.children();0==y.length?f[d]=e.value():m=null==y[0].key()?u.Kind.SEQ:u.Kind.MAP}if(m==u.Kind.SCALAR)f[d]=e.value();else if(m==u.Kind.SEQ){var s=[];f[d]=s;for(var v=0,g=e.children();v<g.length;v++){var c=g[v];s.push(r(c,t))}}else if(m==u.Kind.MAP){var A={};f[d]=A;for(var E=0,_=e.children();E<_.length;E++){var c=_[E],T=""+c.key(!0),N=r(c,t);void 0===N&&(N=t?"!$$$novalue":null),A[T]=N}}return f[d]}if(n==u.Kind.SCALAR){var S=e.value(!1);return S}if(n==u.Kind.MAP){for(var A={},b=0,I=e.children();b<I.length;b++){var c=I[b],T=""+c.key(!0),N=r(c,!0);A[T]=void 0===N?null:N}return A}}function i(e,t){if(void 0===t&&(t={}),t=t||{},0==e.children().length)return e.value();if(e.children()[0].key()){var n={};if(e.children().forEach(function(e){n[o(e.key(t.rawKey),t)]=i(e,t)}),t&&t.writeErrors){var r=a(e);null!=r&&r.length>0&&(n.__$errors__=r)}return n}var s=[];return e.children().forEach(function(e){s.push(i(e,t))}),s}function a(e){var t=[].concat(e.errors());return e.children().forEach(function(e){var n=e.children();return 0==n.length?void e.errors().forEach(function(e){return t.push(e)}):void(n[0].key()||n.forEach(function(e){0==e.children().length&&e.errors().forEach(function(e){return t.push(e)})}))}),t}function o(e,t){return t&&e&&t.escapeNumericKeys&&0==e.replace(/\d/g,"").trim().length?"__$EscapedKey$__"+e:e}function s(e,t){return e?(t=t||{},t.escapeNumericKeys&&f.stringStartsWith(e,"__$EscapedKey$__")&&0==e.substring("__$EscapedKey$__".length).replace(/\d/g,"").trim().length?e.substring("__$EscapedKey$__".length):e):e}Object.defineProperty(t,"__esModule",{value:!0});var u=n(21),l=n(5),p=n(55),c=n(16),f=n(15),h=n(4),d=n(269),m=u.YAMLException,y=function(){function e(e,t,n,r,i,a){void 0===a&&(a={}),this._absolutePath=e,this._path=t,this._content=n,this._project=r,this._isTopoLevel=i,this.serializeOptions=a,this._node=new v(this,JSON.parse(this._content),null,a)}return e.prototype.highLevel=function(){return p.fromUnit(this)},e.prototype.absolutePath=function(){return this._absolutePath},e.prototype.clone=function(){return null},e.prototype.contents=function(){return this._content},e.prototype.lexerErrors=function(){return[]},e.prototype.path=function(){return this._content},e.prototype.isTopLevel=function(){return this._isTopoLevel},e.prototype.ast=function(){return this._node},e.prototype.expandedHighLevel=function(){return this.highLevel()},e.prototype.isDirty=function(){return!0},e.prototype.getIncludeNodes=function(){return[]},e.prototype.resolveAsync=function(e){return null},e.prototype.isRAMLUnit=function(){return!0},e.prototype.project=function(){return this._project},e.prototype.updateContent=function(e){},e.prototype.ramlVersion=function(){throw new m(d.NOT_IMPLEMENTED.message)},e.prototype.lineMapper=function(){return new l.LineMapperImpl(this.contents(),this.absolutePath())},e.prototype.resolve=function(e){return null},e.prototype.isOverlayOrExtension=function(){return!1},e.prototype.getMasterReferenceNode=function(){return null},e}();t.CompilationUnit=y;var v=function(){function e(e,t,n,r,i){void 0===r&&(r={});var a=this;this._unit=e,this._object=t,this._parent=n,this.options=r,this._key=i,this._isOptional=!1,this._object instanceof Object&&Object.keys(this._object).forEach(function(e){var t=s(e,a.options);if(t!=e){var n=a._object[e];delete a._object[e],a._object[t]=n}}),this._key&&f.stringEndsWith(this._key,"?")&&(this._isOptional=!0,this._key=this._key.substring(0,this._key.length-1))}return e.isInstance=function(t){return null!=t&&t.getClassIdentifier&&"function"==typeof t.getClassIdentifier&&c.contains(t.getClassIdentifier(),e.CLASS_IDENTIFIER)},e.prototype.getClassIdentifier=function(){var t=[];return t.concat(e.CLASS_IDENTIFIER)},e.prototype.keyKind=function(){return null},e.prototype.isAnnotatedScalar=function(){return!1},e.prototype.hasInnerIncludeError=function(){return!1},e.prototype.start=function(){return-1},e.prototype.end=function(){return-1},e.prototype.value=function(){return this._object},e.prototype.actual=function(){return this._object},e.prototype.includeErrors=function(){return[]},e.prototype.includePath=function(){return null},e.prototype.includeReference=function(){return null},e.prototype.key=function(){return this._key},e.prototype.optional=function(){return this._isOptional},e.prototype.children=function(){var t=this;return this._object?Array.isArray(this._object)?this._object.map(function(n){return new e(t._unit,n,t,t.options)}):this._object instanceof Object?Object.keys(this._object).map(function(n){return new e(t._unit,t._object[n],t,t.options,n)}):[]:[]},e.prototype.parent=function(){return this._parent},e.prototype.unit=function(){return this._unit},e.prototype.containingUnit=function(){return this._unit},e.prototype.includeBaseUnit=function(){return this._unit},e.prototype.anchorId=function(){return null},e.prototype.errors=function(){return[]},e.prototype.anchoredFrom=function(){return this},e.prototype.includedFrom=function(){return this},e.prototype.visit=function(e){e(this)&&this.children().forEach(function(t){return t.visit(e)})},e.prototype.dumpToObject=function(){return this._object},e.prototype.addChild=function(e){},e.prototype.execute=function(e){},e.prototype.dump=function(){return JSON.stringify(this._object)},e.prototype.keyStart=function(){return-1},e.prototype.keyEnd=function(){return-1},e.prototype.valueStart=function(){return-1},e.prototype.valueEnd=function(){return-1},e.prototype.isValueLocal=function(){return!0},e.prototype.kind=function(){return Array.isArray(this._object)?u.Kind.SEQ:this._object instanceof Object?u.Kind.MAP:u.Kind.SCALAR},e.prototype.valueKind=function(){if(!this._object)return null;var e=typeof this._object;return Array.isArray(this._object)?u.Kind.SEQ:"object"==e?u.Kind.MAP:"string"==e||"number"==e||"boolean"==e?u.Kind.SCALAR:null},e.prototype.anchorValueKind=function(){return null},e.prototype.resolvedValueKind=function(){return this.valueKind()},e.prototype.show=function(e){},e.prototype.setHighLevelParseResult=function(e){this._highLevelParseResult=e},e.prototype.highLevelParseResult=function(){return this._highLevelParseResult},e.prototype.setHighLevelNode=function(e){this._highLevelNode=e},e.prototype.highLevelNode=function(){return this._highLevelNode},e.prototype.text=function(e){throw new m(d.NOT_IMPLEMENTED.message)},e.prototype.copy=function(){throw new m(d.NOT_IMPLEMENTED.message)},e.prototype.markup=function(e){throw new m(d.NOT_IMPLEMENTED.message)},e.prototype.nodeDefinition=function(){return h.getDefinitionForLowLevelNode(this)},e.prototype.includesContents=function(){return!1},e.CLASS_IDENTIFIER="json2LowLeve.AstNode",e}();t.AstNode=v,t.serialize2=r,t.serialize=i},function(e,t,n){"use strict";function r(e){for(var n in e)t.hasOwnProperty(n)||(t[n]=e[n])}Object.defineProperty(t,"__esModule",{value:!0});var i=n(22);t.load=i.load,t.loadAll=i.loadAll,t.safeLoad=i.safeLoad,t.safeLoadAll=i.safeLoadAll;var a=n(53);t.dump=a.dump,t.safeDump=a.safeDump,t.YAMLException=n(25),r(n(23)),r(n(54))},function(e,t,n){"use strict";function r(e){return 10===e||13===e}function i(e){return 9===e||32===e}function a(e){return 9===e||32===e||10===e||13===e}function o(e){return 44===e||91===e||93===e||123===e||125===e}function s(e){var t;return e>=48&&57>=e?e-48:(t=32|e,t>=97&&102>=t?t-97+10:-1)}function u(e){return 120===e?2:117===e?4:85===e?8:0}function l(e){return e>=48&&57>=e?e-48:-1}function p(e){return 48===e?"\x00":97===e?"":98===e?"\b":116===e?"	":9===e?"	":110===e?"\n":118===e?"":102===e?"\f":114===e?"\r":101===e?"":32===e?" ":34===e?'"':47===e?"/":92===e?"\\":78===e?"":95===e?" ":76===e?"\u2028":80===e?"\u2029":""}function c(e){return 65535>=e?String.fromCharCode(e):String.fromCharCode((e-65536>>10)+55296,(e-65536&1023)+56320)}function f(e,t,n){return void 0===n&&(n=!1),new j(t,new W(e.filename,e.input,e.position,e.line,e.position-e.lineStart),n)}function h(e,t,n,r,i){void 0===r&&(r=!1),void 0===i&&(i=!1);var a=A(e,t);if(a){var o=n+t;if(!e.errorMap[o]){var s=new W(e.filename,e.input,t,a.line,t-a.start);i&&(s.toLineEnd=!0);var u=new j(n,s,r);e.errors.push(u)}}}function d(e,t){var n=f(e,t),r=n.message+n.mark.position;if(!e.errorMap[r]){e.errors.push(n),e.errorMap[r]=1;for(var i=e.position;;){if(e.position>=e.input.length-1)return;var a=e.input.charAt(e.position);if("\n"==a)return e.position--,void(e.position==i&&(e.position+=1));if("\r"==a)return e.position--,void(e.position==i&&(e.position+=1));e.position++}}}function m(e,t){var n=f(e,t);e.onWarning&&e.onWarning.call(null,n)}function y(e,t,n,r){var i,a,o,s,u=e.result;if(-1==u.startPosition&&(u.startPosition=t),n>=t){if(s=e.input.slice(t,n),r)for(i=0,a=s.length;a>i;i+=1)o=s.charCodeAt(i),9===o||o>=32&&1114111>=o||d(e,"expected valid JSON character");u.value+=s,u.endPosition=n}}function v(e,t,n,r,i){if(null!=r){null===t&&(t={startPosition:r.startPosition,endPosition:i.endPosition,parent:null,errors:[],mappings:[],kind:V.Kind.MAP});var a=V.newMapping(r,i);return a.parent=t,r.parent=a,null!=i&&(i.parent=a),!e.ignoreDuplicateKeys&&t.mappings.forEach(function(t){t.key&&t.key.value===(a.key&&a.key.value)&&(h(e,a.key.startPosition,"duplicate key"),h(e,t.key.startPosition,"duplicate key"))}),t.mappings.push(a),t.endPosition=i?i.endPosition:r.endPosition+1,t}}function g(e){var t;t=e.input.charCodeAt(e.position),10===t?e.position++:13===t?(e.position++,10===e.input.charCodeAt(e.position)&&e.position++):d(e,"a line break is expected"),e.line+=1,e.lineStart=e.position,e.lines.push({start:e.lineStart,line:e.line})}function A(e,t){for(var n,r=0;r<e.lines.length&&!(e.lines[r].start>t);r++)n=e.lines[r];return n?n:{start:0,line:0}}function E(e,t,n){for(var a=0,o=e.input.charCodeAt(e.position);0!==o;){for(;i(o);)9===o&&e.errors.push(f(e,"Using tabs can lead to unpredictable results",!0)),o=e.input.charCodeAt(++e.position);if(t&&35===o)do o=e.input.charCodeAt(++e.position);while(10!==o&&13!==o&&0!==o);if(!r(o))break;for(g(e),o=e.input.charCodeAt(e.position),a++,e.lineIndent=0;32===o;)e.lineIndent++,o=e.input.charCodeAt(++e.position)}return-1!==n&&0!==a&&e.lineIndent<n&&m(e,"deficient indentation"),a}function _(e){var t,n=e.position;return t=e.input.charCodeAt(n),!(45!==t&&46!==t||e.input.charCodeAt(n+1)!==t||e.input.charCodeAt(n+2)!==t||(n+=3,t=e.input.charCodeAt(n),0!==t&&!a(t)))}function T(e,t,n){1===n?t.value+=" ":n>1&&(t.value+=K.repeat("\n",n-1))}function N(e,t,n){var s,u,l,p,c,f,h,d,m,v=e.kind,g=e.result,A=V.newScalar();if(A.plainScalar=!0,
e.result=A,m=e.input.charCodeAt(e.position),a(m)||o(m)||35===m||38===m||42===m||33===m||124===m||62===m||39===m||34===m||37===m||64===m||96===m)return!1;if((63===m||45===m)&&(u=e.input.charCodeAt(e.position+1),a(u)||n&&o(u)))return!1;for(e.kind="scalar",l=p=e.position,c=!1;0!==m;){if(58===m){if(u=e.input.charCodeAt(e.position+1),a(u)||n&&o(u))break}else if(35===m){if(s=e.input.charCodeAt(e.position-1),a(s))break}else{if(e.position===e.lineStart&&_(e)||n&&o(m))break;if(r(m)){if(f=e.line,h=e.lineStart,d=e.lineIndent,E(e,!1,-1),e.lineIndent>=t){c=!0,m=e.input.charCodeAt(e.position);continue}e.position=p,e.line=f,e.lineStart=h,e.lineIndent=d;break}}if(c&&(y(e,l,p,!1),T(e,A,e.line-f),l=p=e.position,c=!1),i(m)||(p=e.position+1),m=e.input.charCodeAt(++e.position),e.position>=e.input.length)return!1}return y(e,l,p,!1),-1!=e.result.startPosition?(A.rawValue=e.input.substring(A.startPosition,A.endPosition),!0):(e.kind=v,e.result=g,!1)}function S(e,t){var n,i,a;if(n=e.input.charCodeAt(e.position),39!==n)return!1;var o=V.newScalar();for(o.singleQuoted=!0,e.kind="scalar",e.result=o,o.startPosition=e.position,e.position++,i=a=e.position;0!==(n=e.input.charCodeAt(e.position));)if(39===n){if(y(e,i,e.position,!0),n=e.input.charCodeAt(++e.position),o.endPosition=e.position,39!==n)return!0;i=a=e.position,e.position++}else r(n)?(y(e,i,a,!0),T(e,o,E(e,!1,t)),i=a=e.position):e.position===e.lineStart&&_(e)?d(e,"unexpected end of the document within a single quoted scalar"):(e.position++,a=e.position,o.endPosition=e.position);d(e,"unexpected end of the stream within a single quoted scalar")}function b(e,t){var n,i,a,o,l,p;if(p=e.input.charCodeAt(e.position),34!==p)return!1;e.kind="scalar";var f=V.newScalar();for(f.doubleQuoted=!0,e.result=f,f.startPosition=e.position,e.position++,n=i=e.position;0!==(p=e.input.charCodeAt(e.position));){if(34===p)return y(e,n,e.position,!0),e.position++,f.endPosition=e.position,f.rawValue=e.input.substring(f.startPosition,f.endPosition),!0;if(92===p){if(y(e,n,e.position,!0),p=e.input.charCodeAt(++e.position),r(p))E(e,!1,t);else if(256>p&&(e.allowAnyEscape?se[p]:ae[p]))f.value+=e.allowAnyEscape?ue[p]:oe[p],e.position++;else if((l=u(p))>0){for(a=l,o=0;a>0;a--)p=e.input.charCodeAt(++e.position),(l=s(p))>=0?o=(o<<4)+l:d(e,"expected hexadecimal character");f.value+=c(o),e.position++}else d(e,"unknown escape sequence");n=i=e.position}else r(p)?(y(e,n,i,!0),T(e,f,E(e,!1,t)),n=i=e.position):e.position===e.lineStart&&_(e)?d(e,"unexpected end of the document within a double quoted scalar"):(e.position++,i=e.position)}d(e,"unexpected end of the stream within a double quoted scalar")}function I(e,t){var n,r,i,o,s,u,l,p,c,f,h,m=!0,y=e.tag,g=e.anchor;if(h=e.input.charCodeAt(e.position),91===h)o=93,l=!1,r=V.newItems(),r.startPosition=e.position;else{if(123!==h)return!1;o=125,l=!0,r=V.newMap(),r.startPosition=e.position}for(null!==e.anchor&&(r.anchorId=e.anchor,e.anchorMap[e.anchor]=r),h=e.input.charCodeAt(++e.position);0!==h;){if(E(e,!0,t),h=e.input.charCodeAt(e.position),h===o)return e.position++,e.tag=y,e.anchor=g,e.kind=l?"mapping":"sequence",e.result=r,r.endPosition=e.position,!0;if(!m){var A=e.position;d(e,"missed comma between flow collection entries"),e.position=A+1}if(c=p=f=null,s=u=!1,63===h&&(i=e.input.charCodeAt(e.position+1),a(i)&&(s=u=!0,e.position++,E(e,!0,t))),n=e.line,O(e,t,G,!1,!0),c=e.tag,p=e.result,E(e,!0,t),h=e.input.charCodeAt(e.position),!u&&e.line!==n||58!==h||(s=!0,h=e.input.charCodeAt(++e.position),E(e,!0,t),O(e,t,G,!1,!0),f=e.result),l)v(e,r,c,p,f);else if(s){var _=v(e,null,c,p,f);_.parent=r,r.items.push(_)}else p&&(p.parent=r),r.items.push(p);r.endPosition=e.position+1,E(e,!0,t),h=e.input.charCodeAt(e.position),44===h?(m=!0,h=e.input.charCodeAt(++e.position)):m=!1}d(e,"unexpected end of the stream within a flow collection")}function R(e,t){var n,a,o,s,u=J,p=!1,c=t,f=0,h=!1;if(s=e.input.charCodeAt(e.position),124===s)a=!1;else{if(62!==s)return!1;a=!0}var m=V.newScalar();for(e.kind="scalar",e.result=m,m.startPosition=e.position;0!==s;)if(s=e.input.charCodeAt(++e.position),43===s||45===s)J===u?u=43===s?Z:Q:d(e,"repeat of a chomping mode identifier");else{if(!((o=l(s))>=0))break;0===o?d(e,"bad explicit indentation width of a block scalar; it cannot be less than one"):p?d(e,"repeat of an indentation width identifier"):(c=t+o-1,p=!0)}if(i(s)){do s=e.input.charCodeAt(++e.position);while(i(s));if(35===s)do s=e.input.charCodeAt(++e.position);while(!r(s)&&0!==s)}for(;0!==s;){for(g(e),e.lineIndent=0,s=e.input.charCodeAt(e.position);(!p||e.lineIndent<c)&&32===s;)e.lineIndent++,s=e.input.charCodeAt(++e.position);if(!p&&e.lineIndent>c&&(c=e.lineIndent),r(s))f++;else{if(e.lineIndent<c){u===Z?m.value+=K.repeat("\n",f):u===J&&p&&(m.value+="\n");break}for(a?i(s)?(h=!0,m.value+=K.repeat("\n",f+1)):h?(h=!1,m.value+=K.repeat("\n",f+1)):0===f?p&&(m.value+=" "):m.value+=K.repeat("\n",f):p&&(m.value+=K.repeat("\n",f+1)),p=!0,f=0,n=e.position;!r(s)&&0!==s;)s=e.input.charCodeAt(++e.position);y(e,n,e.position,!1)}}m.endPosition=e.position;for(var v=e.position-1,A=!1;;){var E=e.input[v];if("\r"==E||"\n"==E){A&&v--;break}if(" "!=E&&"	"!=E)break;v--}return m.endPosition=v,m.rawValue=e.input.substring(m.startPosition,m.endPosition),!0}function M(e,t){var n,r,i,o=e.tag,s=e.anchor,u=V.newItems(),l=!1;for(null!==e.anchor&&(u.anchorId=e.anchor,e.anchorMap[e.anchor]=u),u.startPosition=e.position,i=e.input.charCodeAt(e.position);0!==i&&45===i&&(r=e.input.charCodeAt(e.position+1),a(r));)if(l=!0,e.position++,E(e,!0,-1)&&e.lineIndent<=t)u.items.push(null),i=e.input.charCodeAt(e.position);else if(n=e.line,O(e,t,z,!1,!0),e.result&&(e.result.parent=u,u.items.push(e.result)),E(e,!0,-1),i=e.input.charCodeAt(e.position),(e.line===n||e.lineIndent>t)&&0!==i)d(e,"bad indentation of a sequence entry");else if(e.lineIndent<t)break;return u.endPosition=e.position,!!l&&(e.tag=o,e.anchor=s,e.kind="sequence",e.result=u,u.endPosition=e.position,!0)}function w(e,t,n){var o,s,u,l,p=e.tag,c=e.anchor,f=V.newMap(),h=null,m=null,y=null,g=!1,A=!1;for(f.startPosition=e.position,null!==e.anchor&&(f.anchorId=e.anchor,e.anchorMap[e.anchor]=f),l=e.input.charCodeAt(e.position);0!==l;){if(o=e.input.charCodeAt(e.position+1),u=e.line,63!==l&&58!==l||!a(o)){if(!O(e,n,X,!1,!0))break;if(e.line===u){for(l=e.input.charCodeAt(e.position);i(l);)l=e.input.charCodeAt(++e.position);if(58===l)l=e.input.charCodeAt(++e.position),a(l)||d(e,"a whitespace character is expected after the key-value separator within a block mapping"),g&&(v(e,f,h,m,null),h=m=y=null),A=!0,g=!1,s=!1,h=e.tag,m=e.result;else{if(e.position==e.lineStart&&_(e))break;if(!A)return e.tag=p,e.anchor=c,!0;d(e,"can not read an implicit mapping pair; a colon is missed")}}else{if(!A)return e.tag=p,e.anchor=c,!0;for(d(e,"can not read a block mapping entry; a multiline key may not be an implicit key");e.position>0;)if(l=e.input.charCodeAt(--e.position),r(l)){e.position++;break}}}else 63===l?(g&&(v(e,f,h,m,null),h=m=y=null),A=!0,g=!0,s=!0):g?(g=!1,s=!0):d(e,"incomplete explicit mapping pair; a key node is missed"),e.position+=1,l=o;if((e.line===u||e.lineIndent>t)&&(O(e,t,$,!0,s)&&(g?m=e.result:y=e.result),g||(v(e,f,h,m,y),h=m=y=null),E(e,!0,-1),l=e.input.charCodeAt(e.position)),e.lineIndent>t&&0!==l)d(e,"bad indentation of a mapping entry");else if(e.lineIndent<t)break}return g&&v(e,f,h,m,null),A&&(e.tag=p,e.anchor=c,e.kind="mapping",e.result=f),A}function C(e){var t,n,r,i,o=!1,s=!1;if(i=e.input.charCodeAt(e.position),33!==i)return!1;if(null!==e.tag&&d(e,"duplication of a tag property"),i=e.input.charCodeAt(++e.position),60===i?(o=!0,i=e.input.charCodeAt(++e.position)):33===i?(s=!0,n="!!",i=e.input.charCodeAt(++e.position)):n="!",t=e.position,o){do i=e.input.charCodeAt(++e.position);while(0!==i&&62!==i);e.position<e.length?(r=e.input.slice(t,e.position),i=e.input.charCodeAt(++e.position)):d(e,"unexpected end of the stream within a verbatim tag")}else{for(;0!==i&&!a(i);)33===i&&(s?d(e,"tag suffix cannot contain exclamation marks"):(n=e.input.slice(t-1,e.position+1),re.test(n)||d(e,"named tag handle cannot contain such characters"),s=!0,t=e.position+1)),i=e.input.charCodeAt(++e.position);r=e.input.slice(t,e.position),ne.test(r)&&d(e,"tag suffix cannot contain flow indicator characters")}return r&&!ie.test(r)&&d(e,"tag name cannot contain such characters: "+r),o?e.tag=r:q.call(e.tagMap,n)?e.tag=e.tagMap[n]+r:"!"===n?e.tag="!"+r:"!!"===n?e.tag="tag:yaml.org,2002:"+r:d(e,'undeclared tag handle "'+n+'"'),!0}function L(e){var t,n;if(n=e.input.charCodeAt(e.position),38!==n)return!1;for(null!==e.anchor&&d(e,"duplication of an anchor property"),n=e.input.charCodeAt(++e.position),t=e.position;0!==n&&!a(n)&&!o(n);)n=e.input.charCodeAt(++e.position);return e.position===t&&d(e,"name of an anchor node must contain at least one character"),e.anchor=e.input.slice(t,e.position),!0}function P(e){var t,n,r;if(e.length,e.input,r=e.input.charCodeAt(e.position),42!==r)return!1;for(r=e.input.charCodeAt(++e.position),t=e.position;0!==r&&!a(r)&&!o(r);)r=e.input.charCodeAt(++e.position);return e.position<=t&&(d(e,"name of an alias node must contain at least one character"),e.position=t+1),n=e.input.slice(t,e.position),e.anchorMap.hasOwnProperty(n)||(d(e,'unidentified alias "'+n+'"'),e.position<=t&&(e.position=t+1)),e.result=V.newAnchorRef(n,t,e.position,e.anchorMap[n]),E(e,!0,-1),!0}function O(e,t,n,r,i){var a,o,s,u,l,p,c,f,m=1,y=!1,v=!1;e.tag=null,e.anchor=null,e.kind=null,e.result=null,a=o=s=$===n||z===n,r&&E(e,!0,-1)&&(y=!0,e.lineIndent>t?m=1:e.lineIndent===t?m=0:e.lineIndent<t&&(m=-1));var g=e.position;if(e.position-e.lineStart,1===m)for(;C(e)||L(e);)E(e,!0,-1)?(y=!0,s=a,e.lineIndent>t?m=1:e.lineIndent===t?m=0:e.lineIndent<t&&(m=-1)):s=!1;if(s&&(s=y||i),1!==m&&$!==n||(c=G===n||X===n?t:t+1,f=e.position-e.lineStart,1===m?s&&(M(e,f)||w(e,f,c))||I(e,c)?v=!0:(o&&R(e,c)||S(e,c)||b(e,c)?v=!0:P(e)?(v=!0,null===e.tag&&null===e.anchor||d(e,"alias node should not have any properties")):N(e,c,G===n)&&(v=!0,null===e.tag&&(e.tag="?")),null!==e.anchor&&(e.anchorMap[e.anchor]=e.result,e.result.anchorId=e.anchor)):0===m&&(v=s&&M(e,f))),null!==e.tag&&"!"!==e.tag)if("!include"==e.tag)e.result||(e.result=V.newScalar(),e.result.startPosition=e.position,e.result.endPosition=e.position,d(e,"!include without value")),e.result.kind=V.Kind.INCLUDE_REF;else if("?"===e.tag)for(u=0,l=e.implicitTypes.length;l>u;u+=1){p=e.implicitTypes[u];var A=e.result.value;if(p.resolve(A)){e.result.valueObject=p.construct(e.result.value),e.tag=p.tag,null!==e.anchor&&(e.result.anchorId=e.anchor,e.anchorMap[e.anchor]=e.result);break}}else q.call(e.typeMap,e.tag)?(p=e.typeMap[e.tag],null!==e.result&&p.kind!==e.kind&&d(e,"unacceptable node kind for !<"+e.tag+'> tag; it should be "'+p.kind+'", not "'+e.kind+'"'),p.resolve(e.result)?(e.result=p.construct(e.result),null!==e.anchor&&(e.result.anchorId=e.anchor,e.anchorMap[e.anchor]=e.result)):d(e,"cannot resolve a node with !<"+e.tag+"> explicit tag")):h(e,g,"unknown tag <"+e.tag+">",!1,!0);return null!==e.tag||null!==e.anchor||v}function D(e){var t,n,o,s,u=e.position,l=!1;for(e.version=null,e.checkLineBreaks=e.legacy,e.tagMap={},e.anchorMap={};0!==(s=e.input.charCodeAt(e.position))&&(E(e,!0,-1),s=e.input.charCodeAt(e.position),!(e.lineIndent>0||37!==s));){for(l=!0,s=e.input.charCodeAt(++e.position),t=e.position;0!==s&&!a(s);)s=e.input.charCodeAt(++e.position);for(n=e.input.slice(t,e.position),o=[],n.length<1&&d(e,"directive name must not be less than one character in length");0!==s;){for(;i(s);)s=e.input.charCodeAt(++e.position);if(35===s){do s=e.input.charCodeAt(++e.position);while(0!==s&&!r(s));break}if(r(s))break;for(t=e.position;0!==s&&!a(s);)s=e.input.charCodeAt(++e.position);o.push(e.input.slice(t,e.position))}0!==s&&g(e),q.call(ce,n)?ce[n](e,n,o):(m(e,'unknown document directive "'+n+'"'),e.position++)}return E(e,!0,-1),0===e.lineIndent&&45===e.input.charCodeAt(e.position)&&45===e.input.charCodeAt(e.position+1)&&45===e.input.charCodeAt(e.position+2)?(e.position+=3,E(e,!0,-1)):l&&d(e,"directives end mark is expected"),O(e,e.lineIndent-1,$,!1,!0),E(e,!0,-1),e.checkLineBreaks&&te.test(e.input.slice(u,e.position))&&m(e,"non-ASCII line breaks are interpreted as content"),e.documents.push(e.result),e.position===e.lineStart&&_(e)?void(46===e.input.charCodeAt(e.position)&&(e.position+=3,E(e,!0,-1))):void(e.position<e.length-1&&d(e,"end of the stream or a document separator is expected"))}function U(e,t){e=String(e),t=t||{};var n=e.length;0!==n&&(10!==e.charCodeAt(n-1)&&13!==e.charCodeAt(n-1)&&(e+="\n"),65279===e.charCodeAt(0)&&(e=e.slice(1)));var r=new pe(e,t);for(ee.test(r.input)&&d(r,"the stream contains non-printable characters"),r.input+="\x00";32===r.input.charCodeAt(r.position);)r.lineIndent+=1,r.position+=1;for(;r.position<r.length-1;){var i=r.position;if(D(r),r.position<=i)for(;r.position<r.length-1;r.position++){var a=r.input.charAt(r.position);if("\n"==a)break}}var o=r.documents,s=o.length;s>0&&(o[s-1].endPosition=n);for(var u=0,l=o;u<l.length;u++){var p=l[u];p.errors=r.errors,p.startPosition>p.endPosition&&(p.startPosition=p.endPosition)}return o}function x(e,t,n){void 0===n&&(n={});var r,i,a=U(e,n);for(r=0,i=a.length;i>r;r+=1)t(a[r])}function k(e,t){void 0===t&&(t={});var n=U(e,t);if(0!==n.length){if(1===n.length)return n[0];var r=new j("expected a single document in the stream, but found more");return r.mark=new W("","",0,0,0),r.mark.position=n[0].endPosition,n[0].errors.push(r),n[0]}}function F(e,t,n){void 0===n&&(n={}),x(e,t,K.extend({schema:H},n))}function B(e,t){return void 0===t&&(t={}),k(e,K.extend({schema:H},t))}Object.defineProperty(t,"__esModule",{value:!0});for(var V=n(23),K=n(24),j=n(25),W=n(26),H=n(27),Y=n(50),q=Object.prototype.hasOwnProperty,G=1,X=2,z=3,$=4,J=1,Q=2,Z=3,ee=/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uD800-\uDFFF\uFFFE\uFFFF]/,te=/[\x85\u2028\u2029]/,ne=/[,\[\]\{\}]/,re=/^(?:!|!!|![a-z\-]+!)$/i,ie=/^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i,ae=new Array(256),oe=new Array(256),se=new Array(256),ue=new Array(256),le=0;256>le;le++)ue[le]=oe[le]=p(le),ae[le]=oe[le]?1:0,se[le]=1,ae[le]||(ue[le]="\\"+String.fromCharCode(le));var pe=function(){function e(e,t){this.errorMap={},this.errors=[],this.lines=[],this.input=e,this.filename=t.filename||null,this.schema=t.schema||Y,this.onWarning=t.onWarning||null,this.legacy=t.legacy||!1,this.allowAnyEscape=t.allowAnyEscape||!1,this.ignoreDuplicateKeys=t.ignoreDuplicateKeys||!1,this.implicitTypes=this.schema.compiledImplicit,this.typeMap=this.schema.compiledTypeMap,this.length=e.length,this.position=0,this.line=0,this.lineStart=0,this.lineIndent=0,this.documents=[]}return e}(),ce={YAML:function(e,t,n){var r,i,a;null!==e.version&&d(e,"duplication of %YAML directive"),1!==n.length&&d(e,"YAML directive accepts exactly one argument"),r=/^([0-9]+)\.([0-9]+)$/.exec(n[0]),null===r&&d(e,"ill-formed argument of the YAML directive"),i=parseInt(r[1],10),a=parseInt(r[2],10),1!==i&&d(e,"found incompatible YAML document (version 1.2 is required)"),e.version=n[0],e.checkLineBreaks=2>a,2!==a&&d(e,"found incompatible YAML document (version 1.2 is required)")},TAG:function(e,t,n){var r,i;2!==n.length&&d(e,"TAG directive accepts exactly two arguments"),r=n[0],i=n[1],re.test(r)||d(e,"ill-formed tag handle (first argument) of the TAG directive"),q.call(e.tagMap,r)&&d(e,'there is a previously declared suffix for "'+r+'" tag handle'),ie.test(i)||d(e,"ill-formed tag prefix (second argument) of the TAG directive"),e.tagMap[r]=i}};!function(){function e(){}return e}(),t.loadAll=x,t.load=k,t.safeLoadAll=F,t.safeLoad=B,e.exports.loadAll=x,e.exports.load=k,e.exports.safeLoadAll=F,e.exports.safeLoad=B},function(e,t){"use strict";function n(e,t){var n=t?t.endPosition:e.endPosition+1,r={key:e,value:t,startPosition:e.startPosition,endPosition:n,kind:u.MAPPING,parent:null,errors:[]};return r}function r(e,t,n,r){return{errors:[],referencesAnchor:e,value:r,startPosition:t,endPosition:n,kind:u.ANCHOR_REF,parent:null}}function i(e){return void 0===e&&(e=""),{errors:[],startPosition:-1,endPosition:-1,value:e,kind:u.SCALAR,parent:null,doubleQuoted:!1,rawValue:e}}function a(){return{errors:[],startPosition:-1,endPosition:-1,items:[],kind:u.SEQ,parent:null}}function o(){return a()}function s(e){return{errors:[],startPosition:-1,endPosition:-1,mappings:e?e:[],kind:u.MAP,parent:null}}Object.defineProperty(t,"__esModule",{value:!0});var u;!function(e){e[e.SCALAR=0]="SCALAR",e[e.MAPPING=1]="MAPPING",e[e.MAP=2]="MAP",e[e.SEQ=3]="SEQ",e[e.ANCHOR_REF=4]="ANCHOR_REF",e[e.INCLUDE_REF=5]="INCLUDE_REF"}(u=t.Kind||(t.Kind={})),t.newMapping=n,t.newAnchorRef=r,t.newScalar=i,t.newItems=a,t.newSeq=o,t.newMap=s},function(e,t){"use strict";function n(e){return"undefined"==typeof e||null===e}function r(e){return"object"==typeof e&&null!==e}function i(e){return Array.isArray(e)?e:n(e)?[]:[e]}function a(e,t){var n,r,i,a;if(t)for(a=Object.keys(t),n=0,r=a.length;r>n;n+=1)i=a[n],e[i]=t[i];return e}function o(e,t){var n,r="";for(n=0;t>n;n+=1)r+=e;return r}function s(e){return 0===e&&Number.NEGATIVE_INFINITY===1/e}Object.defineProperty(t,"__esModule",{value:!0}),t.isNothing=n,t.isObject=r,t.toArray=i,t.extend=a,t.repeat=o,t.isNegativeZero=s},function(e,t){"use strict";var n=function(){function e(e,t,n){void 0===t&&(t=null),void 0===n&&(n=!1),this.name="YAMLException",this.reason=e,this.mark=t,this.message=this.toString(!1),this.isWarning=n}return e.isInstance=function(t){if(null!=t&&t.getClassIdentifier&&"function"==typeof t.getClassIdentifier)for(var n=0,r=t.getClassIdentifier();n<r.length;n++){var i=r[n];if(i==e.CLASS_IDENTIFIER)return!0}return!1},e.prototype.getClassIdentifier=function(){var t=[];return t.concat(e.CLASS_IDENTIFIER)},e.prototype.toString=function(e){void 0===e&&(e=!1);var t;return t="JS-YAML: "+(this.reason||"(unknown reason)"),!e&&this.mark&&(t+=" "+this.mark.toString()),t},e.CLASS_IDENTIFIER="yaml-ast-parser.YAMLException",e}();e.exports=n},function(e,t,n){"use strict";var r=n(24),i=function(){function e(e,t,n,r,i){this.name=e,this.buffer=t,this.position=n,this.line=r,this.column=i}return e.prototype.getSnippet=function(e,t){void 0===e&&(e=0),void 0===t&&(t=75);var n,i,a,o,s;if(!this.buffer)return null;for(e=e||4,t=t||75,n="",i=this.position;i>0&&-1==="\x00\r\n\u2028\u2029".indexOf(this.buffer.charAt(i-1));)if(i-=1,this.position-i>t/2-1){n=" ... ",i+=5;break}for(a="",o=this.position;o<this.buffer.length&&-1==="\x00\r\n\u2028\u2029".indexOf(this.buffer.charAt(o));)if(o+=1,o-this.position>t/2-1){a=" ... ",o-=5;break}return s=this.buffer.slice(i,o),r.repeat(" ",e)+n+s+a+"\n"+r.repeat(" ",e+this.position-i+n.length)+"^"},e.prototype.toString=function(e){void 0===e&&(e=!0);var t,n="";return this.name&&(n+='in "'+this.name+'" '),n+="at line "+(this.line+1)+", column "+(this.column+1),e||(t=this.getSnippet(),t&&(n+=":\n"+t)),n},e}();e.exports=i},function(e,t,n){"use strict";var r=n(28),i=new r.Schema({include:[n(30)],implicit:[n(40),n(41)],explicit:[n(42),n(47),n(48),n(49)]});e.exports=i},function(e,t,n){"use strict";function r(e,t,n){var i=[];return e.include.forEach(function(e){n=r(e,t,n)}),e[t].forEach(function(e){n.forEach(function(t,n){t.tag===e.tag&&i.push(n)}),n.push(e)}),n.filter(function(e,t){return-1===i.indexOf(t)})}function i(){function e(e){r[e.tag]=e}var t,n,r={};for(t=0,n=arguments.length;n>t;t+=1)arguments[t].forEach(e);return r}Object.defineProperty(t,"__esModule",{value:!0});var a=n(24),o=n(25),s=n(29),u=function(){function e(e){this.include=e.include||[],this.implicit=e.implicit||[],this.explicit=e.explicit||[],this.implicit.forEach(function(e){if(e.loadKind&&"scalar"!==e.loadKind)throw new o("There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.")}),this.compiledImplicit=r(this,"implicit",[]),this.compiledExplicit=r(this,"explicit",[]),this.compiledTypeMap=i(this.compiledImplicit,this.compiledExplicit)}return e.DEFAULT=null,e.create=function(){var t,n;switch(arguments.length){case 1:t=e.DEFAULT,n=arguments[0];break;case 2:t=arguments[0],n=arguments[1];break;default:throw new o("Wrong number of arguments for Schema.create function")}if(t=a.toArray(t),n=a.toArray(n),!t.every(function(t){return t instanceof e}))throw new o("Specified list of super schemas (or a single Schema object) contains a non-Schema object.");if(!n.every(function(e){return e instanceof s.Type}))throw new o("Specified list of YAML types (or a single Type object) contains a non-Type object.");return new e({include:t,explicit:n})},e}();t.Schema=u},function(e,t,n){"use strict";function r(e){var t={};return null!==e&&Object.keys(e).forEach(function(n){e[n].forEach(function(e){t[String(e)]=n})}),t}Object.defineProperty(t,"__esModule",{value:!0});var i=n(25),a=["kind","resolve","construct","instanceOf","predicate","represent","defaultStyle","styleAliases"],o=["scalar","sequence","mapping"],s=function(){function e(e,t){if(t=t||{},Object.keys(t).forEach(function(t){if(-1===a.indexOf(t))throw new i('Unknown option "'+t+'" is met in definition of "'+e+'" YAML type.')}),this.tag=e,this.kind=t.kind||null,this.resolve=t.resolve||function(){return!0},this.construct=t.construct||function(e){return e},this.instanceOf=t.instanceOf||null,this.predicate=t.predicate||null,this.represent=t.represent||null,this.defaultStyle=t.defaultStyle||null,this.styleAliases=r(t.styleAliases||null),-1===o.indexOf(this.kind))throw new i('Unknown kind "'+this.kind+'" is specified for "'+e+'" YAML type.')}return e}();t.Type=s},function(e,t,n){"use strict";var r=n(28);e.exports=new r.Schema({include:[n(31)]})},function(e,t,n){"use strict";var r=n(28);e.exports=new r.Schema({include:[n(32)],implicit:[n(36),n(37),n(38),n(39)]})},function(e,t,n){"use strict";var r=n(28);e.exports=new r.Schema({explicit:[n(33),n(34),n(35)]})},function(e,t,n){"use strict";var r=n(29);e.exports=new r.Type("tag:yaml.org,2002:str",{kind:"scalar",construct:function(e){return null!==e?e:""}})},function(e,t,n){"use strict";var r=n(29);e.exports=new r.Type("tag:yaml.org,2002:seq",{kind:"sequence",construct:function(e){return null!==e?e:[]}})},function(e,t,n){"use strict";var r=n(29);e.exports=new r.Type("tag:yaml.org,2002:map",{kind:"mapping",construct:function(e){return null!==e?e:{}}})},function(e,t,n){"use strict";function r(e){if(null===e)return!0;var t=e.length;return 1===t&&"~"===e||4===t&&("null"===e||"Null"===e||"NULL"===e)}function i(){return null}function a(e){return null===e}var o=n(29);e.exports=new o.Type("tag:yaml.org,2002:null",{kind:"scalar",resolve:r,construct:i,predicate:a,represent:{canonical:function(){return"~"},lowercase:function(){return"null"},uppercase:function(){return"NULL"},camelcase:function(){return"Null"}},defaultStyle:"lowercase"})},function(e,t,n){"use strict";function r(e){if(null===e)return!1;var t=e.length;return 4===t&&("true"===e||"True"===e||"TRUE"===e)||5===t&&("false"===e||"False"===e||"FALSE"===e)}function i(e){return"true"===e||"True"===e||"TRUE"===e}function a(e){return"[object Boolean]"===Object.prototype.toString.call(e)}var o=n(29);e.exports=new o.Type("tag:yaml.org,2002:bool",{kind:"scalar",resolve:r,construct:i,predicate:a,represent:{lowercase:function(e){return e?"true":"false"},uppercase:function(e){return e?"TRUE":"FALSE"},camelcase:function(e){return e?"True":"False"}},defaultStyle:"lowercase"})},function(e,t,n){"use strict";function r(e){return e>=48&&57>=e||e>=65&&70>=e||e>=97&&102>=e}function i(e){return e>=48&&55>=e}function a(e){return e>=48&&57>=e}function o(e){if(null===e)return!1;var t,n=e.length,o=0,s=!1;if(!n)return!1;if(t=e[o],"-"!==t&&"+"!==t||(t=e[++o]),"0"===t){if(o+1===n)return!0;if(t=e[++o],"b"===t){for(o++;n>o;o++)if(t=e[o],"_"!==t){if("0"!==t&&"1"!==t)return!1;s=!0}return s}if("x"===t){for(o++;n>o;o++)if(t=e[o],"_"!==t){if(!r(e.charCodeAt(o)))return!1;s=!0}return s}for(;n>o;o++)if(t=e[o],"_"!==t){if(!i(e.charCodeAt(o)))return!1;s=!0}return s}for(;n>o;o++)if(t=e[o],"_"!==t){if(":"===t)break;if(!a(e.charCodeAt(o)))return!1;s=!0}return!!s&&(":"!==t||/^(:[0-5]?[0-9])+$/.test(e.slice(o)))}function s(e){var t,n,r=e,i=1,a=[];return-1!==r.indexOf("_")&&(r=r.replace(/_/g,"")),t=r[0],"-"!==t&&"+"!==t||("-"===t&&(i=-1),r=r.slice(1),t=r[0]),"0"===r?0:"0"===t?"b"===r[1]?i*parseInt(r.slice(2),2):"x"===r[1]?i*parseInt(r,16):i*parseInt(r,8):-1!==r.indexOf(":")?(r.split(":").forEach(function(e){a.unshift(parseInt(e,10))}),r=0,n=1,a.forEach(function(e){r+=e*n,n*=60}),i*r):i*parseInt(r,10)}function u(e){return"[object Number]"===Object.prototype.toString.call(e)&&0===e%1&&!l.isNegativeZero(e)}var l=n(24),p=n(29);e.exports=new p.Type("tag:yaml.org,2002:int",{kind:"scalar",resolve:o,construct:s,predicate:u,represent:{binary:function(e){return"0b"+e.toString(2)},octal:function(e){return"0"+e.toString(8)},decimal:function(e){return e.toString(10)},hexadecimal:function(e){return"0x"+e.toString(16).toUpperCase()}},defaultStyle:"decimal",styleAliases:{binary:[2,"bin"],octal:[8,"oct"],decimal:[10,"dec"],hexadecimal:[16,"hex"]}})},function(e,t,n){"use strict";function r(e){return null===e?!1:!!l.test(e)}function i(e){var t,n,r,i;return t=e.replace(/_/g,"").toLowerCase(),n="-"===t[0]?-1:1,i=[],0<="+-".indexOf(t[0])&&(t=t.slice(1)),".inf"===t?1===n?Number.POSITIVE_INFINITY:Number.NEGATIVE_INFINITY:".nan"===t?NaN:0<=t.indexOf(":")?(t.split(":").forEach(function(e){i.unshift(parseFloat(e,10))}),t=0,r=1,i.forEach(function(e){t+=e*r,r*=60}),n*t):n*parseFloat(t,10)}function a(e,t){if(isNaN(e))switch(t){case"lowercase":return".nan";case"uppercase":return".NAN";case"camelcase":return".NaN"}else if(Number.POSITIVE_INFINITY===e)switch(t){case"lowercase":return".inf";case"uppercase":return".INF";case"camelcase":return".Inf"}else if(Number.NEGATIVE_INFINITY===e)switch(t){case"lowercase":return"-.inf";case"uppercase":return"-.INF";case"camelcase":return"-.Inf"}else if(s.isNegativeZero(e))return"-0.0";return e.toString(10)}function o(e){return"[object Number]"===Object.prototype.toString.call(e)&&(0!==e%1||s.isNegativeZero(e))}var s=n(24),u=n(29),l=new RegExp("^(?:[-+]?(?:[0-9][0-9_]*)\\.[0-9_]*(?:[eE][-+][0-9]+)?|\\.[0-9_]+(?:[eE][-+][0-9]+)?|[-+]?[0-9][0-9_]*(?::[0-5]?[0-9])+\\.[0-9_]*|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$");e.exports=new u.Type("tag:yaml.org,2002:float",{kind:"scalar",resolve:r,construct:i,predicate:o,represent:a,defaultStyle:"lowercase"})},function(e,t,n){"use strict";function r(e){if(null===e)return!1;var t;return t=s.exec(e),null!==t}function i(e){var t,n,r,i,a,o,u,l,p,c,f=0,h=null;if(t=s.exec(e),null===t)throw new Error("Date resolve error");if(n=+t[1],r=+t[2]-1,i=+t[3],!t[4])return new Date(Date.UTC(n,r,i));if(a=+t[4],o=+t[5],u=+t[6],t[7]){for(f=t[7].slice(0,3);f.length<3;)f+="0";f=+f}return t[9]&&(l=+t[10],p=+(t[11]||0),h=6e4*(60*l+p),"-"===t[9]&&(h=-h)),c=new Date(Date.UTC(n,r,i,a,o,u,f)),h&&c.setTime(c.getTime()-h),c}function a(e){return e.toISOString()}var o=n(29),s=new RegExp("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:(?:[Tt]|[ \\t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \\t]*(Z|([-+])([0-9][0-9]?)(?::([0-9][0-9]))?))?)?$");e.exports=new o.Type("tag:yaml.org,2002:timestamp",{kind:"scalar",resolve:r,construct:i,instanceOf:Date,represent:a})},function(e,t,n){"use strict";function r(e){return"<<"===e||null===e}var i=n(29);e.exports=new i.Type("tag:yaml.org,2002:merge",{kind:"scalar",resolve:r})},function(e,t,n){"use strict";function r(e){if(null===e)return!1;var t,n,r=0,i=e.length,a=l;for(n=0;i>n;n++)if(t=a.indexOf(e.charAt(n)),!(t>64)){if(0>t)return!1;r+=6}return r%8===0}function i(e){var t,n,r=e.replace(/[\r\n=]/g,""),i=r.length,a=l,o=0,u=[];for(t=0;i>t;t++)t%4===0&&t&&(u.push(o>>16&255),u.push(o>>8&255),u.push(255&o)),o=o<<6|a.indexOf(r.charAt(t));return n=i%4*6,0===n?(u.push(o>>16&255),u.push(o>>8&255),u.push(255&o)):18===n?(u.push(o>>10&255),u.push(o>>2&255)):12===n&&u.push(o>>4&255),s?new s(u):u}function a(e){var t,n,r="",i=0,a=e.length,o=l;for(t=0;a>t;t++)t%3===0&&t&&(r+=o[i>>18&63],r+=o[i>>12&63],r+=o[i>>6&63],r+=o[63&i]),i=(i<<8)+e[t];return n=a%3,0===n?(r+=o[i>>18&63],r+=o[i>>12&63],r+=o[i>>6&63],r+=o[63&i]):2===n?(r+=o[i>>10&63],r+=o[i>>4&63],r+=o[i<<2&63],r+=o[64]):1===n&&(r+=o[i>>2&63],r+=o[i<<4&63],r+=o[64],r+=o[64]),r}function o(e){return s&&s.isBuffer(e)}var s=n(43).Buffer,u=n(29),l="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r";e.exports=new u.Type("tag:yaml.org,2002:binary",{kind:"scalar",resolve:r,construct:i,predicate:o,represent:a})},function(e,t,n){(function(e){"use strict";function r(){try{var e=new Uint8Array(1);return e.__proto__={__proto__:Uint8Array.prototype,foo:function(){return 42}},42===e.foo()&&"function"==typeof e.subarray&&0===e.subarray(1,1).byteLength}catch(e){return!1}}function i(){return o.TYPED_ARRAY_SUPPORT?2147483647:1073741823}function a(e,t){if(i()<t)throw new RangeError("Invalid typed array length");return o.TYPED_ARRAY_SUPPORT?(e=new Uint8Array(t),e.__proto__=o.prototype):(null===e&&(e=new o(t)),e.length=t),e}function o(e,t,n){if(!(o.TYPED_ARRAY_SUPPORT||this instanceof o))return new o(e,t,n);if("number"==typeof e){if("string"==typeof t)throw new Error("If encoding is specified then the first argument must be a string");return p(this,e)}return s(this,e,t,n)}function s(e,t,n,r){if("number"==typeof t)throw new TypeError('"value" argument must not be a number');return"undefined"!=typeof ArrayBuffer&&t instanceof ArrayBuffer?h(e,t,n,r):"string"==typeof t?c(e,t,n):d(e,t)}function u(e){if("number"!=typeof e)throw new TypeError('"size" argument must be a number');if(0>e)throw new RangeError('"size" argument must not be negative')}function l(e,t,n,r){return u(t),0>=t?a(e,t):void 0!==n?"string"==typeof r?a(e,t).fill(n,r):a(e,t).fill(n):a(e,t)}function p(e,t){if(u(t),e=a(e,0>t?0:0|m(t)),!o.TYPED_ARRAY_SUPPORT)for(var n=0;t>n;++n)e[n]=0;return e}function c(e,t,n){if("string"==typeof n&&""!==n||(n="utf8"),!o.isEncoding(n))throw new TypeError('"encoding" must be a valid string encoding');var r=0|v(t,n);e=a(e,r);var i=e.write(t,n);return i!==r&&(e=e.slice(0,i)),e}function f(e,t){var n=t.length<0?0:0|m(t.length);e=a(e,n);for(var r=0;n>r;r+=1)e[r]=255&t[r];return e}function h(e,t,n,r){if(t.byteLength,0>n||t.byteLength<n)throw new RangeError("'offset' is out of bounds");if(t.byteLength<n+(r||0))throw new RangeError("'length' is out of bounds");return t=void 0===n&&void 0===r?new Uint8Array(t):void 0===r?new Uint8Array(t,n):new Uint8Array(t,n,r),o.TYPED_ARRAY_SUPPORT?(e=t,e.__proto__=o.prototype):e=f(e,t),e}function d(e,t){if(o.isBuffer(t)){var n=0|m(t.length);return e=a(e,n),0===e.length?e:(t.copy(e,0,0,n),e)}if(t){if("undefined"!=typeof ArrayBuffer&&t.buffer instanceof ArrayBuffer||"length"in t)return"number"!=typeof t.length||$(t.length)?a(e,0):f(e,t);if("Buffer"===t.type&&Z(t.data))return f(e,t.data)}throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.")}function m(e){if(e>=i())throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x"+i().toString(16)+" bytes");return 0|e}function y(e){return+e!=e&&(e=0),o.alloc(+e)}function v(e,t){if(o.isBuffer(e))return e.length;if("undefined"!=typeof ArrayBuffer&&"function"==typeof ArrayBuffer.isView&&(ArrayBuffer.isView(e)||e instanceof ArrayBuffer))return e.byteLength;"string"!=typeof e&&(e=""+e);var n=e.length;if(0===n)return 0;for(var r=!1;;)switch(t){case"ascii":case"latin1":case"binary":return n;case"utf8":case"utf-8":case void 0:return Y(e).length;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return 2*n;case"hex":return n>>>1;case"base64":return X(e).length;default:if(r)return Y(e).length;t=(""+t).toLowerCase(),r=!0}}function g(e,t,n){var r=!1;if((void 0===t||0>t)&&(t=0),t>this.length)return"";if((void 0===n||n>this.length)&&(n=this.length),0>=n)return"";if(n>>>=0,t>>>=0,t>=n)return"";for(e||(e="utf8");;)switch(e){case"hex":return O(this,t,n);case"utf8":case"utf-8":return w(this,t,n);case"ascii":return L(this,t,n);case"latin1":case"binary":return P(this,t,n);case"base64":return M(this,t,n);case"ucs2":
case"ucs-2":case"utf16le":case"utf-16le":return D(this,t,n);default:if(r)throw new TypeError("Unknown encoding: "+e);e=(e+"").toLowerCase(),r=!0}}function A(e,t,n){var r=e[t];e[t]=e[n],e[n]=r}function E(e,t,n,r,i){if(0===e.length)return-1;if("string"==typeof n?(r=n,n=0):n>2147483647?n=2147483647:-2147483648>n&&(n=-2147483648),n=+n,isNaN(n)&&(n=i?0:e.length-1),0>n&&(n=e.length+n),n>=e.length){if(i)return-1;n=e.length-1}else if(0>n){if(!i)return-1;n=0}if("string"==typeof t&&(t=o.from(t,r)),o.isBuffer(t))return 0===t.length?-1:_(e,t,n,r,i);if("number"==typeof t)return t&=255,o.TYPED_ARRAY_SUPPORT&&"function"==typeof Uint8Array.prototype.indexOf?i?Uint8Array.prototype.indexOf.call(e,t,n):Uint8Array.prototype.lastIndexOf.call(e,t,n):_(e,[t],n,r,i);throw new TypeError("val must be string, number or Buffer")}function _(e,t,n,r,i){function a(e,t){return 1===o?e[t]:e.readUInt16BE(t*o)}var o=1,s=e.length,u=t.length;if(void 0!==r&&(r=String(r).toLowerCase(),"ucs2"===r||"ucs-2"===r||"utf16le"===r||"utf-16le"===r)){if(e.length<2||t.length<2)return-1;o=2,s/=2,u/=2,n/=2}var l;if(i){var p=-1;for(l=n;s>l;l++)if(a(e,l)===a(t,-1===p?0:l-p)){if(-1===p&&(p=l),l-p+1===u)return p*o}else-1!==p&&(l-=l-p),p=-1}else for(n+u>s&&(n=s-u),l=n;l>=0;l--){for(var c=!0,f=0;u>f;f++)if(a(e,l+f)!==a(t,f)){c=!1;break}if(c)return l}return-1}function T(e,t,n,r){n=Number(n)||0;var i=e.length-n;r?(r=Number(r),r>i&&(r=i)):r=i;var a=t.length;if(a%2!==0)throw new TypeError("Invalid hex string");r>a/2&&(r=a/2);for(var o=0;r>o;++o){var s=parseInt(t.substr(2*o,2),16);if(isNaN(s))return o;e[n+o]=s}return o}function N(e,t,n,r){return z(Y(t,e.length-n),e,n,r)}function S(e,t,n,r){return z(q(t),e,n,r)}function b(e,t,n,r){return S(e,t,n,r)}function I(e,t,n,r){return z(X(t),e,n,r)}function R(e,t,n,r){return z(G(t,e.length-n),e,n,r)}function M(e,t,n){return 0===t&&n===e.length?J.fromByteArray(e):J.fromByteArray(e.slice(t,n))}function w(e,t,n){n=Math.min(e.length,n);for(var r=[],i=t;n>i;){var a=e[i],o=null,s=a>239?4:a>223?3:a>191?2:1;if(n>=i+s){var u,l,p,c;switch(s){case 1:128>a&&(o=a);break;case 2:u=e[i+1],128===(192&u)&&(c=(31&a)<<6|63&u,c>127&&(o=c));break;case 3:u=e[i+1],l=e[i+2],128===(192&u)&&128===(192&l)&&(c=(15&a)<<12|(63&u)<<6|63&l,c>2047&&(55296>c||c>57343)&&(o=c));break;case 4:u=e[i+1],l=e[i+2],p=e[i+3],128===(192&u)&&128===(192&l)&&128===(192&p)&&(c=(15&a)<<18|(63&u)<<12|(63&l)<<6|63&p,c>65535&&1114112>c&&(o=c))}}null===o?(o=65533,s=1):o>65535&&(o-=65536,r.push(o>>>10&1023|55296),o=56320|1023&o),r.push(o),i+=s}return C(r)}function C(e){var t=e.length;if(ee>=t)return String.fromCharCode.apply(String,e);for(var n="",r=0;t>r;)n+=String.fromCharCode.apply(String,e.slice(r,r+=ee));return n}function L(e,t,n){var r="";n=Math.min(e.length,n);for(var i=t;n>i;++i)r+=String.fromCharCode(127&e[i]);return r}function P(e,t,n){var r="";n=Math.min(e.length,n);for(var i=t;n>i;++i)r+=String.fromCharCode(e[i]);return r}function O(e,t,n){var r=e.length;(!t||0>t)&&(t=0),(!n||0>n||n>r)&&(n=r);for(var i="",a=t;n>a;++a)i+=H(e[a]);return i}function D(e,t,n){for(var r=e.slice(t,n),i="",a=0;a<r.length;a+=2)i+=String.fromCharCode(r[a]+256*r[a+1]);return i}function U(e,t,n){if(e%1!==0||0>e)throw new RangeError("offset is not uint");if(e+t>n)throw new RangeError("Trying to access beyond buffer length")}function x(e,t,n,r,i,a){if(!o.isBuffer(e))throw new TypeError('"buffer" argument must be a Buffer instance');if(t>i||a>t)throw new RangeError('"value" argument is out of bounds');if(n+r>e.length)throw new RangeError("Index out of range")}function k(e,t,n,r){0>t&&(t=65535+t+1);for(var i=0,a=Math.min(e.length-n,2);a>i;++i)e[n+i]=(t&255<<8*(r?i:1-i))>>>8*(r?i:1-i)}function F(e,t,n,r){0>t&&(t=4294967295+t+1);for(var i=0,a=Math.min(e.length-n,4);a>i;++i)e[n+i]=t>>>8*(r?i:3-i)&255}function B(e,t,n,r,i,a){if(n+r>e.length)throw new RangeError("Index out of range");if(0>n)throw new RangeError("Index out of range")}function V(e,t,n,r,i){return i||B(e,t,n,4,3.4028234663852886e38,-3.4028234663852886e38),Q.write(e,t,n,r,23,4),n+4}function K(e,t,n,r,i){return i||B(e,t,n,8,1.7976931348623157e308,-1.7976931348623157e308),Q.write(e,t,n,r,52,8),n+8}function j(e){if(e=W(e).replace(te,""),e.length<2)return"";for(;e.length%4!==0;)e+="=";return e}function W(e){return e.trim?e.trim():e.replace(/^\s+|\s+$/g,"")}function H(e){return 16>e?"0"+e.toString(16):e.toString(16)}function Y(e,t){t=t||1/0;for(var n,r=e.length,i=null,a=[],o=0;r>o;++o){if(n=e.charCodeAt(o),n>55295&&57344>n){if(!i){if(n>56319){(t-=3)>-1&&a.push(239,191,189);continue}if(o+1===r){(t-=3)>-1&&a.push(239,191,189);continue}i=n;continue}if(56320>n){(t-=3)>-1&&a.push(239,191,189),i=n;continue}n=(i-55296<<10|n-56320)+65536}else i&&(t-=3)>-1&&a.push(239,191,189);if(i=null,128>n){if((t-=1)<0)break;a.push(n)}else if(2048>n){if((t-=2)<0)break;a.push(n>>6|192,63&n|128)}else if(65536>n){if((t-=3)<0)break;a.push(n>>12|224,n>>6&63|128,63&n|128)}else{if(!(1114112>n))throw new Error("Invalid code point");if((t-=4)<0)break;a.push(n>>18|240,n>>12&63|128,n>>6&63|128,63&n|128)}}return a}function q(e){for(var t=[],n=0;n<e.length;++n)t.push(255&e.charCodeAt(n));return t}function G(e,t){for(var n,r,i,a=[],o=0;o<e.length&&!((t-=2)<0);++o)n=e.charCodeAt(o),r=n>>8,i=n%256,a.push(i),a.push(r);return a}function X(e){return J.toByteArray(j(e))}function z(e,t,n,r){for(var i=0;r>i&&!(i+n>=t.length||i>=e.length);++i)t[i+n]=e[i];return i}function $(e){return e!==e}var J=n(44),Q=n(45),Z=n(46);t.Buffer=o,t.SlowBuffer=y,t.INSPECT_MAX_BYTES=50,o.TYPED_ARRAY_SUPPORT=void 0!==e.TYPED_ARRAY_SUPPORT?e.TYPED_ARRAY_SUPPORT:r(),t.kMaxLength=i(),o.poolSize=8192,o._augment=function(e){return e.__proto__=o.prototype,e},o.from=function(e,t,n){return s(null,e,t,n)},o.TYPED_ARRAY_SUPPORT&&(o.prototype.__proto__=Uint8Array.prototype,o.__proto__=Uint8Array,"undefined"!=typeof Symbol&&Symbol.species&&o[Symbol.species]===o&&Object.defineProperty(o,Symbol.species,{value:null,configurable:!0})),o.alloc=function(e,t,n){return l(null,e,t,n)},o.allocUnsafe=function(e){return p(null,e)},o.allocUnsafeSlow=function(e){return p(null,e)},o.isBuffer=function(e){return!(null==e||!e._isBuffer)},o.compare=function(e,t){if(!o.isBuffer(e)||!o.isBuffer(t))throw new TypeError("Arguments must be Buffers");if(e===t)return 0;for(var n=e.length,r=t.length,i=0,a=Math.min(n,r);a>i;++i)if(e[i]!==t[i]){n=e[i],r=t[i];break}return r>n?-1:n>r?1:0},o.isEncoding=function(e){switch(String(e).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"latin1":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return!0;default:return!1}},o.concat=function(e,t){if(!Z(e))throw new TypeError('"list" argument must be an Array of Buffers');if(0===e.length)return o.alloc(0);var n;if(void 0===t)for(t=0,n=0;n<e.length;++n)t+=e[n].length;var r=o.allocUnsafe(t),i=0;for(n=0;n<e.length;++n){var a=e[n];if(!o.isBuffer(a))throw new TypeError('"list" argument must be an Array of Buffers');a.copy(r,i),i+=a.length}return r},o.byteLength=v,o.prototype._isBuffer=!0,o.prototype.swap16=function(){var e=this.length;if(e%2!==0)throw new RangeError("Buffer size must be a multiple of 16-bits");for(var t=0;e>t;t+=2)A(this,t,t+1);return this},o.prototype.swap32=function(){var e=this.length;if(e%4!==0)throw new RangeError("Buffer size must be a multiple of 32-bits");for(var t=0;e>t;t+=4)A(this,t,t+3),A(this,t+1,t+2);return this},o.prototype.swap64=function(){var e=this.length;if(e%8!==0)throw new RangeError("Buffer size must be a multiple of 64-bits");for(var t=0;e>t;t+=8)A(this,t,t+7),A(this,t+1,t+6),A(this,t+2,t+5),A(this,t+3,t+4);return this},o.prototype.toString=function(){var e=0|this.length;return 0===e?"":0===arguments.length?w(this,0,e):g.apply(this,arguments)},o.prototype.equals=function(e){if(!o.isBuffer(e))throw new TypeError("Argument must be a Buffer");return this===e||0===o.compare(this,e)},o.prototype.inspect=function(){var e="",n=t.INSPECT_MAX_BYTES;return this.length>0&&(e=this.toString("hex",0,n).match(/.{2}/g).join(" "),this.length>n&&(e+=" ... ")),"<Buffer "+e+">"},o.prototype.compare=function(e,t,n,r,i){if(!o.isBuffer(e))throw new TypeError("Argument must be a Buffer");if(void 0===t&&(t=0),void 0===n&&(n=e?e.length:0),void 0===r&&(r=0),void 0===i&&(i=this.length),0>t||n>e.length||0>r||i>this.length)throw new RangeError("out of range index");if(r>=i&&t>=n)return 0;if(r>=i)return-1;if(t>=n)return 1;if(t>>>=0,n>>>=0,r>>>=0,i>>>=0,this===e)return 0;for(var a=i-r,s=n-t,u=Math.min(a,s),l=this.slice(r,i),p=e.slice(t,n),c=0;u>c;++c)if(l[c]!==p[c]){a=l[c],s=p[c];break}return s>a?-1:a>s?1:0},o.prototype.includes=function(e,t,n){return-1!==this.indexOf(e,t,n)},o.prototype.indexOf=function(e,t,n){return E(this,e,t,n,!0)},o.prototype.lastIndexOf=function(e,t,n){return E(this,e,t,n,!1)},o.prototype.write=function(e,t,n,r){if(void 0===t)r="utf8",n=this.length,t=0;else if(void 0===n&&"string"==typeof t)r=t,n=this.length,t=0;else{if(!isFinite(t))throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");t|=0,isFinite(n)?(n|=0,void 0===r&&(r="utf8")):(r=n,n=void 0)}var i=this.length-t;if((void 0===n||n>i)&&(n=i),e.length>0&&(0>n||0>t)||t>this.length)throw new RangeError("Attempt to write outside buffer bounds");r||(r="utf8");for(var a=!1;;)switch(r){case"hex":return T(this,e,t,n);case"utf8":case"utf-8":return N(this,e,t,n);case"ascii":return S(this,e,t,n);case"latin1":case"binary":return b(this,e,t,n);case"base64":return I(this,e,t,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return R(this,e,t,n);default:if(a)throw new TypeError("Unknown encoding: "+r);r=(""+r).toLowerCase(),a=!0}},o.prototype.toJSON=function(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}};var ee=4096;o.prototype.slice=function(e,t){var n=this.length;e=~~e,t=void 0===t?n:~~t,0>e?(e+=n,0>e&&(e=0)):e>n&&(e=n),0>t?(t+=n,0>t&&(t=0)):t>n&&(t=n),e>t&&(t=e);var r;if(o.TYPED_ARRAY_SUPPORT)r=this.subarray(e,t),r.__proto__=o.prototype;else{var i=t-e;r=new o(i,void 0);for(var a=0;i>a;++a)r[a]=this[a+e]}return r},o.prototype.readUIntLE=function(e,t,n){e|=0,t|=0,n||U(e,t,this.length);for(var r=this[e],i=1,a=0;++a<t&&(i*=256);)r+=this[e+a]*i;return r},o.prototype.readUIntBE=function(e,t,n){e|=0,t|=0,n||U(e,t,this.length);for(var r=this[e+--t],i=1;t>0&&(i*=256);)r+=this[e+--t]*i;return r},o.prototype.readUInt8=function(e,t){return t||U(e,1,this.length),this[e]},o.prototype.readUInt16LE=function(e,t){return t||U(e,2,this.length),this[e]|this[e+1]<<8},o.prototype.readUInt16BE=function(e,t){return t||U(e,2,this.length),this[e]<<8|this[e+1]},o.prototype.readUInt32LE=function(e,t){return t||U(e,4,this.length),(this[e]|this[e+1]<<8|this[e+2]<<16)+16777216*this[e+3]},o.prototype.readUInt32BE=function(e,t){return t||U(e,4,this.length),16777216*this[e]+(this[e+1]<<16|this[e+2]<<8|this[e+3])},o.prototype.readIntLE=function(e,t,n){e|=0,t|=0,n||U(e,t,this.length);for(var r=this[e],i=1,a=0;++a<t&&(i*=256);)r+=this[e+a]*i;return i*=128,r>=i&&(r-=Math.pow(2,8*t)),r},o.prototype.readIntBE=function(e,t,n){e|=0,t|=0,n||U(e,t,this.length);for(var r=t,i=1,a=this[e+--r];r>0&&(i*=256);)a+=this[e+--r]*i;return i*=128,a>=i&&(a-=Math.pow(2,8*t)),a},o.prototype.readInt8=function(e,t){return t||U(e,1,this.length),128&this[e]?-1*(255-this[e]+1):this[e]},o.prototype.readInt16LE=function(e,t){t||U(e,2,this.length);var n=this[e]|this[e+1]<<8;return 32768&n?4294901760|n:n},o.prototype.readInt16BE=function(e,t){t||U(e,2,this.length);var n=this[e+1]|this[e]<<8;return 32768&n?4294901760|n:n},o.prototype.readInt32LE=function(e,t){return t||U(e,4,this.length),this[e]|this[e+1]<<8|this[e+2]<<16|this[e+3]<<24},o.prototype.readInt32BE=function(e,t){return t||U(e,4,this.length),this[e]<<24|this[e+1]<<16|this[e+2]<<8|this[e+3]},o.prototype.readFloatLE=function(e,t){return t||U(e,4,this.length),Q.read(this,e,!0,23,4)},o.prototype.readFloatBE=function(e,t){return t||U(e,4,this.length),Q.read(this,e,!1,23,4)},o.prototype.readDoubleLE=function(e,t){return t||U(e,8,this.length),Q.read(this,e,!0,52,8)},o.prototype.readDoubleBE=function(e,t){return t||U(e,8,this.length),Q.read(this,e,!1,52,8)},o.prototype.writeUIntLE=function(e,t,n,r){if(e=+e,t|=0,n|=0,!r){var i=Math.pow(2,8*n)-1;x(this,e,t,n,i,0)}var a=1,o=0;for(this[t]=255&e;++o<n&&(a*=256);)this[t+o]=e/a&255;return t+n},o.prototype.writeUIntBE=function(e,t,n,r){if(e=+e,t|=0,n|=0,!r){var i=Math.pow(2,8*n)-1;x(this,e,t,n,i,0)}var a=n-1,o=1;for(this[t+a]=255&e;--a>=0&&(o*=256);)this[t+a]=e/o&255;return t+n},o.prototype.writeUInt8=function(e,t,n){return e=+e,t|=0,n||x(this,e,t,1,255,0),o.TYPED_ARRAY_SUPPORT||(e=Math.floor(e)),this[t]=255&e,t+1},o.prototype.writeUInt16LE=function(e,t,n){return e=+e,t|=0,n||x(this,e,t,2,65535,0),o.TYPED_ARRAY_SUPPORT?(this[t]=255&e,this[t+1]=e>>>8):k(this,e,t,!0),t+2},o.prototype.writeUInt16BE=function(e,t,n){return e=+e,t|=0,n||x(this,e,t,2,65535,0),o.TYPED_ARRAY_SUPPORT?(this[t]=e>>>8,this[t+1]=255&e):k(this,e,t,!1),t+2},o.prototype.writeUInt32LE=function(e,t,n){return e=+e,t|=0,n||x(this,e,t,4,4294967295,0),o.TYPED_ARRAY_SUPPORT?(this[t+3]=e>>>24,this[t+2]=e>>>16,this[t+1]=e>>>8,this[t]=255&e):F(this,e,t,!0),t+4},o.prototype.writeUInt32BE=function(e,t,n){return e=+e,t|=0,n||x(this,e,t,4,4294967295,0),o.TYPED_ARRAY_SUPPORT?(this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e):F(this,e,t,!1),t+4},o.prototype.writeIntLE=function(e,t,n,r){if(e=+e,t|=0,!r){var i=Math.pow(2,8*n-1);x(this,e,t,n,i-1,-i)}var a=0,o=1,s=0;for(this[t]=255&e;++a<n&&(o*=256);)0>e&&0===s&&0!==this[t+a-1]&&(s=1),this[t+a]=(e/o>>0)-s&255;return t+n},o.prototype.writeIntBE=function(e,t,n,r){if(e=+e,t|=0,!r){var i=Math.pow(2,8*n-1);x(this,e,t,n,i-1,-i)}var a=n-1,o=1,s=0;for(this[t+a]=255&e;--a>=0&&(o*=256);)0>e&&0===s&&0!==this[t+a+1]&&(s=1),this[t+a]=(e/o>>0)-s&255;return t+n},o.prototype.writeInt8=function(e,t,n){return e=+e,t|=0,n||x(this,e,t,1,127,-128),o.TYPED_ARRAY_SUPPORT||(e=Math.floor(e)),0>e&&(e=255+e+1),this[t]=255&e,t+1},o.prototype.writeInt16LE=function(e,t,n){return e=+e,t|=0,n||x(this,e,t,2,32767,-32768),o.TYPED_ARRAY_SUPPORT?(this[t]=255&e,this[t+1]=e>>>8):k(this,e,t,!0),t+2},o.prototype.writeInt16BE=function(e,t,n){return e=+e,t|=0,n||x(this,e,t,2,32767,-32768),o.TYPED_ARRAY_SUPPORT?(this[t]=e>>>8,this[t+1]=255&e):k(this,e,t,!1),t+2},o.prototype.writeInt32LE=function(e,t,n){return e=+e,t|=0,n||x(this,e,t,4,2147483647,-2147483648),o.TYPED_ARRAY_SUPPORT?(this[t]=255&e,this[t+1]=e>>>8,this[t+2]=e>>>16,this[t+3]=e>>>24):F(this,e,t,!0),t+4},o.prototype.writeInt32BE=function(e,t,n){return e=+e,t|=0,n||x(this,e,t,4,2147483647,-2147483648),0>e&&(e=4294967295+e+1),o.TYPED_ARRAY_SUPPORT?(this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e):F(this,e,t,!1),t+4},o.prototype.writeFloatLE=function(e,t,n){return V(this,e,t,!0,n)},o.prototype.writeFloatBE=function(e,t,n){return V(this,e,t,!1,n)},o.prototype.writeDoubleLE=function(e,t,n){return K(this,e,t,!0,n)},o.prototype.writeDoubleBE=function(e,t,n){return K(this,e,t,!1,n)},o.prototype.copy=function(e,t,n,r){if(n||(n=0),r||0===r||(r=this.length),t>=e.length&&(t=e.length),t||(t=0),r>0&&n>r&&(r=n),r===n)return 0;if(0===e.length||0===this.length)return 0;if(0>t)throw new RangeError("targetStart out of bounds");if(0>n||n>=this.length)throw new RangeError("sourceStart out of bounds");if(0>r)throw new RangeError("sourceEnd out of bounds");r>this.length&&(r=this.length),e.length-t<r-n&&(r=e.length-t+n);var i,a=r-n;if(this===e&&t>n&&r>t)for(i=a-1;i>=0;--i)e[i+t]=this[i+n];else if(1e3>a||!o.TYPED_ARRAY_SUPPORT)for(i=0;a>i;++i)e[i+t]=this[i+n];else Uint8Array.prototype.set.call(e,this.subarray(n,n+a),t);return a},o.prototype.fill=function(e,t,n,r){if("string"==typeof e){if("string"==typeof t?(r=t,t=0,n=this.length):"string"==typeof n&&(r=n,n=this.length),1===e.length){var i=e.charCodeAt(0);256>i&&(e=i)}if(void 0!==r&&"string"!=typeof r)throw new TypeError("encoding must be a string");if("string"==typeof r&&!o.isEncoding(r))throw new TypeError("Unknown encoding: "+r)}else"number"==typeof e&&(e&=255);if(0>t||this.length<t||this.length<n)throw new RangeError("Out of range index");if(t>=n)return this;t>>>=0,n=void 0===n?this.length:n>>>0,e||(e=0);var a;if("number"==typeof e)for(a=t;n>a;++a)this[a]=e;else{var s=o.isBuffer(e)?e:Y(new o(e,r).toString()),u=s.length;for(a=0;n-t>a;++a)this[a+t]=s[a%u]}return this};var te=/[^+\/0-9A-Za-z-_]/g}).call(t,function(){return this}())},function(e,t){"use strict";function n(e){var t=e.length;if(t%4>0)throw new Error("Invalid string. Length must be a multiple of 4");return"="===e[t-2]?2:"="===e[t-1]?1:0}function r(e){return 3*e.length/4-n(e)}function i(e){var t,r,i,a,o,s=e.length;a=n(e),o=new p(3*s/4-a),r=a>0?s-4:s;var u=0;for(t=0;r>t;t+=4)i=l[e.charCodeAt(t)]<<18|l[e.charCodeAt(t+1)]<<12|l[e.charCodeAt(t+2)]<<6|l[e.charCodeAt(t+3)],o[u++]=i>>16&255,o[u++]=i>>8&255,o[u++]=255&i;return 2===a?(i=l[e.charCodeAt(t)]<<2|l[e.charCodeAt(t+1)]>>4,o[u++]=255&i):1===a&&(i=l[e.charCodeAt(t)]<<10|l[e.charCodeAt(t+1)]<<4|l[e.charCodeAt(t+2)]>>2,o[u++]=i>>8&255,o[u++]=255&i),o}function a(e){return u[e>>18&63]+u[e>>12&63]+u[e>>6&63]+u[63&e]}function o(e,t,n){for(var r,i=[],o=t;n>o;o+=3)r=(e[o]<<16)+(e[o+1]<<8)+e[o+2],i.push(a(r));return i.join("")}function s(e){for(var t,n=e.length,r=n%3,i="",a=[],s=16383,l=0,p=n-r;p>l;l+=s)a.push(o(e,l,l+s>p?p:l+s));return 1===r?(t=e[n-1],i+=u[t>>2],i+=u[t<<4&63],i+="=="):2===r&&(t=(e[n-2]<<8)+e[n-1],i+=u[t>>10],i+=u[t>>4&63],i+=u[t<<2&63],i+="="),a.push(i),a.join("")}t.byteLength=r,t.toByteArray=i,t.fromByteArray=s;for(var u=[],l=[],p="undefined"!=typeof Uint8Array?Uint8Array:Array,c="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",f=0,h=c.length;h>f;++f)u[f]=c[f],l[c.charCodeAt(f)]=f;l["-".charCodeAt(0)]=62,l["_".charCodeAt(0)]=63},function(e,t){t.read=function(e,t,n,r,i){var a,o,s=8*i-r-1,u=(1<<s)-1,l=u>>1,p=-7,c=n?i-1:0,f=n?-1:1,h=e[t+c];for(c+=f,a=h&(1<<-p)-1,h>>=-p,p+=s;p>0;a=256*a+e[t+c],c+=f,p-=8);for(o=a&(1<<-p)-1,a>>=-p,p+=r;p>0;o=256*o+e[t+c],c+=f,p-=8);if(0===a)a=1-l;else{if(a===u)return o?NaN:(h?-1:1)*(1/0);o+=Math.pow(2,r),a-=l}return(h?-1:1)*o*Math.pow(2,a-r)},t.write=function(e,t,n,r,i,a){var o,s,u,l=8*a-i-1,p=(1<<l)-1,c=p>>1,f=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,h=r?0:a-1,d=r?1:-1,m=0>t||0===t&&0>1/t?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(s=isNaN(t)?1:0,o=p):(o=Math.floor(Math.log(t)/Math.LN2),t*(u=Math.pow(2,-o))<1&&(o--,u*=2),t+=o+c>=1?f/u:f*Math.pow(2,1-c),t*u>=2&&(o++,u/=2),o+c>=p?(s=0,o=p):o+c>=1?(s=(t*u-1)*Math.pow(2,i),o+=c):(s=t*Math.pow(2,c-1)*Math.pow(2,i),o=0));i>=8;e[n+h]=255&s,h+=d,s/=256,i-=8);for(o=o<<i|s,l+=i;l>0;e[n+h]=255&o,h+=d,o/=256,l-=8);e[n+h-d]|=128*m}},function(e,t){var n={}.toString;e.exports=Array.isArray||function(e){return"[object Array]"==n.call(e)}},function(e,t,n){"use strict";function r(e){if(null===e)return!0;var t,n,r,i,a,u=[],l=e;for(t=0,n=l.length;n>t;t+=1){if(r=l[t],a=!1,"[object Object]"!==s.call(r))return!1;for(i in r)if(o.call(r,i)){if(a)return!1;a=!0}if(!a)return!1;if(-1!==u.indexOf(i))return!1;u.push(i)}return!0}function i(e){return null!==e?e:[]}var a=n(29),o=Object.prototype.hasOwnProperty,s=Object.prototype.toString;e.exports=new a.Type("tag:yaml.org,2002:omap",{kind:"sequence",resolve:r,construct:i})},function(e,t,n){"use strict";function r(e){if(null===e)return!0;if(e.kind!=o.Kind.SEQ)return!1;var t,n,r,i=e.items;for(t=0,n=i.length;n>t;t+=1){if(r=i[t],"[object Object]"!==s.call(r))return!1;if(!Array.isArray(r.mappings))return!1;if(1!==r.mappings.length)return!1}return!0}function i(e){if(null===e||!Array.isArray(e.items))return[];var t,n,r,i=e.items;for(r=o.newItems(),r.parent=e.parent,r.startPosition=e.startPosition,r.endPosition=e.endPosition,t=0,n=i.length;n>t;t+=1){var a=i[t],s=a.mappings[0],u=o.newItems();u.parent=r,u.startPosition=s.key.startPosition,u.endPosition=s.value.startPosition,s.key.parent=u,s.value.parent=u,u.items=[s.key,s.value],r.items.push(u)}return r}var a=n(29),o=n(23),s=Object.prototype.toString;e.exports=new a.Type("tag:yaml.org,2002:pairs",{kind:"sequence",resolve:r,construct:i})},function(e,t,n){"use strict";function r(e){return null===e||e.kind==o.Kind.MAP}function i(e){return null!==e?e:{}}var a=n(29),o=n(23);Object.prototype.hasOwnProperty,e.exports=new a.Type("tag:yaml.org,2002:set",{kind:"mapping",resolve:r,construct:i})},function(e,t,n){"use strict";var r=n(28),i=new r.Schema({include:[n(27)],explicit:[n(51),n(52)]});r.Schema.DEFAULT=i,e.exports=i},function(e,t,n){"use strict";function r(){return!0}function i(){}function a(){return""}function o(e){return"undefined"==typeof e}var s=n(29);e.exports=new s.Type("tag:yaml.org,2002:js/undefined",{kind:"scalar",resolve:r,construct:i,predicate:o,represent:a})},function(e,t,n){"use strict";function r(e){if(null===e)return!1;if(0===e.length)return!1;var t=e,n=/\/([gim]*)$/.exec(e),r="";if("/"===t[0]){if(n&&(r=n[1]),r.length>3)return!1;if("/"!==t[t.length-r.length-1])return!1;t=t.slice(1,t.length-r.length-1)}try{return new RegExp(t,r),!0}catch(e){return!1}}function i(e){var t=e,n=/\/([gim]*)$/.exec(e),r="";return"/"===t[0]&&(n&&(r=n[1]),t=t.slice(1,t.length-r.length-1)),new RegExp(t,r)}function a(e){var t="/"+e.source+"/";return e.global&&(t+="g"),e.multiline&&(t+="m"),e.ignoreCase&&(t+="i"),t}function o(e){return"[object RegExp]"===Object.prototype.toString.call(e)}var s=n(29);e.exports=new s.Type("tag:yaml.org,2002:js/regexp",{kind:"scalar",resolve:r,construct:i,predicate:o,represent:a})},function(e,t,n){"use strict";function r(e,t){var n,r,i,a,o,s,u;if(null===t)return{};for(n={},r=Object.keys(t),i=0,a=r.length;a>i;i+=1)o=r[i],s=String(t[o]),"!!"===o.slice(0,2)&&(o="tag:yaml.org,2002:"+o.slice(2)),u=e.compiledTypeMap[o],u&&C.call(u.styleAliases,s)&&(s=u.styleAliases[s]),n[o]=s;return n}function i(e){var t,n,r;if(t=e.toString(16).toUpperCase(),255>=e)n="x",r=2;else if(65535>=e)n="u",r=4;else{if(!(4294967295>=e))throw new I("code point within a string may not be greater than 0xFFFFFFFF");n="U",r=8}return"\\"+n+b.repeat("0",r-t.length)+t}function a(e){this.schema=e.schema||R,this.indent=Math.max(1,e.indent||2),this.skipInvalid=e.skipInvalid||!1,this.flowLevel=b.isNothing(e.flowLevel)?-1:e.flowLevel,this.styleMap=r(this.schema,e.styles||null),this.implicitTypes=this.schema.compiledImplicit,this.explicitTypes=this.schema.compiledExplicit,this.tag=null,this.result="",this.duplicates=[],this.usedDuplicates=null}function o(e,t){for(var n,r=b.repeat(" ",t),i=0,a=-1,o="",s=e.length;s>i;)a=e.indexOf("\n",i),-1===a?(n=e.slice(i),i=s):(n=e.slice(i,a+1),i=a+1),n.length&&"\n"!==n&&(o+=r),o+=n;return o}function s(e,t){return"\n"+b.repeat(" ",e.indent*t)}function u(e,t){var n,r,i;for(n=0,r=e.implicitTypes.length;r>n;n+=1)if(i=e.implicitTypes[n],i.resolve(t))return!0;return!1}function l(e){this.source=e,this.result="",this.checkpoint=0}function p(e,t,n){var r,i,a,s,p,f,m,y,v,g,A,E,_,T,N,S,b,I,R,M,w;if(0===t.length)return void(e.dump="''");if(0==t.indexOf("!include"))return void(e.dump=""+t);if(0==t.indexOf("!$$$novalue"))return void(e.dump="");if(-1!==te.indexOf(t))return void(e.dump="'"+t+"'");for(r=!0,i=t.length?t.charCodeAt(0):0,a=D===i||D===t.charCodeAt(t.length-1),W!==i&&q!==i&&G!==i&&$!==i||(r=!1),a?(r=!1,s=!1,p=!1):(s=!0,p=!0),f=!0,m=new l(t),y=!1,v=0,g=0,A=e.indent*n,E=80,40>A?E-=A:E=40,T=0;T<t.length;T++){if(_=t.charCodeAt(T),r){if(h(_))continue;r=!1}f&&_===V&&(f=!1),N=ee[_],S=d(_),(N||S)&&(_!==P&&_!==x&&_!==V?(s=!1,p=!1):_===P&&(y=!0,f=!1,T>0&&(b=t.charCodeAt(T-1),b===D&&(p=!1,s=!1)),s&&(I=T-v,v=T,I>g&&(g=I))),_!==x&&(f=!1),m.takeUpTo(T),m.escapeChar())}if(r&&u(e,t)&&(r=!1),R="",(s||p)&&(M=0,t.charCodeAt(t.length-1)===P&&(M+=1,t.charCodeAt(t.length-2)===P&&(M+=1)),0===M?R="-":2===M&&(R="+")),p&&E>g&&(s=!1),y||(p=!1),r)e.dump=t;else if(f)e.dump="'"+t+"'";else if(s)w=c(t,E),e.dump=">"+R+"\n"+o(w,A);else if(p)R||(t=t.replace(/\n$/,"")),e.dump="|"+R+"\n"+o(t,A);else{if(!m)throw new Error("Failed to dump scalar value");m.finish(),e.dump='"'+m.result+'"'}}function c(e,t){var n,r="",i=0,a=e.length,o=/\n+$/.exec(e);for(o&&(a=o.index+1);a>i;)n=e.indexOf("\n",i),n>a||-1===n?(r&&(r+="\n\n"),r+=f(e.slice(i,a),t),i=a):(r&&(r+="\n\n"),r+=f(e.slice(i,n),t),i=n+1);return o&&"\n"!==o[0]&&(r+=o[0]),r}function f(e,t){if(""===e)return e;for(var n,r,i,a=/[^\s] [^\s]/g,o="",s=0,u=0,l=a.exec(e);l;)n=l.index,n-u>t&&(r=s!==u?s:n,o&&(o+="\n"),i=e.slice(u,r),o+=i,u=r+1),s=n+1,l=a.exec(e);return o&&(o+="\n"),o+=u!==s&&e.length-u>t?e.slice(u,s)+"\n"+e.slice(s+1):e.slice(u)}function h(e){return L!==e&&P!==e&&O!==e&&j!==e&&X!==e&&z!==e&&J!==e&&Z!==e&&k!==e&&B!==e&&K!==e&&U!==e&&Q!==e&&Y!==e&&V!==e&&x!==e&&F!==e&&H!==e&&!ee[e]&&!d(e)}function d(e){return!(e>=32&&126>=e||133===e||e>=160&&55295>=e||e>=57344&&65533>=e||e>=65536&&1114111>=e)}function m(e,t,n){var r,i,a="",o=e.tag;for(r=0,i=n.length;i>r;r+=1)E(e,t,n[r],!1,!1)&&(0!==r&&(a+=", "),a+=e.dump);e.tag=o,e.dump="["+a+"]"}function y(e,t,n,r){var i,a,o="",u=e.tag;for(i=0,a=n.length;a>i;i+=1)E(e,t+1,n[i],!0,!0)&&(r&&0===i||(o+=s(e,t)),o+="- "+e.dump);e.tag=u,e.dump=o||"[]"}function v(e,t,n){var r,i,a,o,s,u="",l=e.tag,p=Object.keys(n);for(r=0,i=p.length;i>r;r+=1)s="",0!==r&&(s+=", "),a=p[r],o=n[a],E(e,t,a,!1,!1)&&(e.dump.length>1024&&(s+="? "),s+=e.dump+": ",E(e,t,o,!1,!1)&&(s+=e.dump,u+=s));e.tag=l,e.dump="{"+u+"}"}function g(e,t,n,r){var i,a,o,u,l,p,c="",f=e.tag,h=Object.keys(n);for(i=0,a=h.length;a>i;i+=1)p="",r&&0===i||(p+=s(e,t)),o=h[i],u=n[o],E(e,t+1,o,!0,!0)&&(l=null!==e.tag&&"?"!==e.tag||e.dump&&e.dump.length>1024,l&&(p+=e.dump&&P===e.dump.charCodeAt(0)?"?":"? "),p+=e.dump,l&&(p+=s(e,t)),E(e,t+1,u,!0,l)&&(p+=e.dump&&P===e.dump.charCodeAt(0)?":":": ",p+=e.dump,c+=p));e.tag=f,e.dump=c||"{}"}function A(e,t,n){var r,i,a,o,s,u;for(i=n?e.explicitTypes:e.implicitTypes,a=0,o=i.length;o>a;a+=1)if(s=i[a],(s.instanceOf||s.predicate)&&(!s.instanceOf||"object"==typeof t&&t instanceof s.instanceOf)&&(!s.predicate||s.predicate(t))){if(e.tag=n?s.tag:"?",s.represent){if(u=e.styleMap[s.tag]||s.defaultStyle,"[object Function]"===w.call(s.represent))r=s.represent(t,u);else{if(!C.call(s.represent,u))throw new I("!<"+s.tag+'> tag resolver accepts not "'+u+'" style');r=s.represent[u](t,u)}e.dump=r}return!0}return!1}function E(e,t,n,r,i){e.tag=null,e.dump=n,A(e,n,!1)||A(e,n,!0);var a=w.call(e.dump);r&&(r=0>e.flowLevel||e.flowLevel>t),(null!==e.tag&&"?"!==e.tag||2!==e.indent&&t>0)&&(i=!1);var o,s,u="[object Object]"===a||"[object Array]"===a;if(u&&(o=e.duplicates.indexOf(n),s=-1!==o),s&&e.usedDuplicates[o])e.dump="*ref_"+o;else{if(u&&s&&!e.usedDuplicates[o]&&(e.usedDuplicates[o]=!0),"[object Object]"===a)r&&0!==Object.keys(e.dump).length?(g(e,t,e.dump,i),s&&(e.dump="&ref_"+o+(0===t?"\n":"")+e.dump)):(v(e,t,e.dump),s&&(e.dump="&ref_"+o+" "+e.dump));else if("[object Array]"===a)r&&0!==e.dump.length?(y(e,t,e.dump,i),s&&(e.dump="&ref_"+o+(0===t?"\n":"")+e.dump)):(m(e,t,e.dump),s&&(e.dump="&ref_"+o+" "+e.dump));else{if("[object String]"!==a){if(e.skipInvalid)return!1;throw new I("unacceptable kind of an object to dump "+a)}"?"!==e.tag&&p(e,e.dump,t)}null!==e.tag&&"?"!==e.tag&&(e.dump="!<"+e.tag+"> "+e.dump)}return!0}function _(e,t){var n,r,i=[],a=[];for(T(e,i,a),n=0,r=a.length;r>n;n+=1)t.duplicates.push(i[a[n]]);t.usedDuplicates=new Array(r)}function T(e,t,n){var r,i,a;if(w.call(e),null!==e&&"object"==typeof e)if(i=t.indexOf(e),-1!==i)-1===n.indexOf(i)&&n.push(i);else if(t.push(e),Array.isArray(e))for(i=0,a=e.length;a>i;i+=1)T(e[i],t,n);else for(r=Object.keys(e),i=0,a=r.length;a>i;i+=1)T(e[r[i]],t,n)}function N(e,t){t=t||{};var n=new a(t);return _(e,n),E(n,0,e,!0,!0)?n.dump+"\n":""}function S(e,t){return N(e,b.extend({schema:M},t))}Object.defineProperty(t,"__esModule",{value:!0});var b=n(24),I=n(25),R=n(50),M=n(27),w=Object.prototype.toString,C=Object.prototype.hasOwnProperty,L=9,P=10,O=13,D=32,U=33,x=34,k=35,F=37,B=38,V=39,K=42,j=44,W=45,H=58,Y=62,q=63,G=64,X=91,z=93,$=96,J=123,Q=124,Z=125,ee={};ee[0]="\\0",ee[7]="\\a",ee[8]="\\b",ee[9]="\\t",ee[10]="\\n",ee[11]="\\v",ee[12]="\\f",ee[13]="\\r",ee[27]="\\e",ee[34]='\\"',ee[92]="\\\\",ee[133]="\\N",ee[160]="\\_",ee[8232]="\\L",ee[8233]="\\P";var te=["y","Y","yes","Yes","YES","on","On","ON","n","N","no","No","NO","off","Off","OFF"];l.prototype.takeUpTo=function(e){var t;if(e<this.checkpoint)throw t=new Error("position should be > checkpoint"),t.position=e,t.checkpoint=this.checkpoint,t;return this.result+=this.source.slice(this.checkpoint,e),this.checkpoint=e,this},l.prototype.escapeChar=function(){var e,t;return e=this.source.charCodeAt(this.checkpoint),t=ee[e]||i(e),this.result+=t,this.checkpoint+=1,this},l.prototype.finish=function(){this.source.length>this.checkpoint&&this.takeUpTo(this.source.length)},t.dump=N,t.safeDump=S},function(e,t){"use strict";function n(e){if(["true","True","TRUE"].lastIndexOf(e)>=0)return!0;if(["false","False","FALSE"].lastIndexOf(e)>=0)return!1;throw'Invalid boolean "'+e+'"'}function r(e){return 0===e.lastIndexOf("0o",0)?parseInt(e.substring(2),8):parseInt(e)}function i(e){var t=r(e);if(isNaN(t))throw'Invalid integer "'+e+'"';return t}function a(e){if([".nan",".NaN",".NAN"].lastIndexOf(e)>=0)return NaN;var t=/^([-+])?(?:\.inf|\.Inf|\.INF)$/,n=t.exec(e);if(n)return"-"===n[1]?-(1/0):1/0;var r=parseFloat(e);if(!isNaN(r))return r;throw'Invalid float "'+e+'"'}function o(e){if(void 0===e)return s["null"];if(e.doubleQuoted||!e.plainScalar||e.singleQuoted)return s.string;var t=e.value;if(["null","Null","NULL","~",""].indexOf(t)>=0)return s["null"];if(null===t||void 0===t)return s["null"];if(["true","True","TRUE","false","False","FALSE"].indexOf(t)>=0)return s.bool;var n=/^[-+]?[0-9]+$/,r=/^0o[0-7]+$/,i=/^0x[0-9a-fA-F]+$/;if(n.test(t)||r.test(t)||i.test(t))return s["int"];var a=/^[-+]?(\.[0-9]+|[0-9]+(\.[0-9]*)?)([eE][-+]?[0-9]+)?$/,o=/^[-+]?(\.inf|\.Inf|\.INF)$/;return a.test(t)||o.test(t)||[".nan",".NaN",".NAN"].indexOf(t)>=0?s["float"]:s.string}Object.defineProperty(t,"__esModule",{value:!0}),t.parseYamlBoolean=n,t.parseYamlInteger=i,t.parseYamlFloat=a;var s;!function(e){e[e["null"]=0]="null",e[e.bool=1]="bool",e[e["int"]=2]="int",e[e["float"]=3]="float",e[e.string=4]="string"}(s=t.ScalarType||(t.ScalarType={})),t.determineScalarType=o},function(e,t,n){"use strict";function r(e,t){var n=e.name();if(C.LowLevelProxyNode.isInstance(t.lowLevel())){if(C.LowLevelProxyNode.isInstance(e.lowLevel()))return n;var r=t.root().lowLevel().unit(),i=r.project().namespaceResolver(),a=e.lowLevel().unit(),o=i.resolveNamespace(t.lowLevel().unit(),a);if(null!=o){var s=o.namespace();if(null!=s)return s+"."+n}}if(e.lowLevel().unit()!=t.lowLevel().unit())for(var u=t;;){if(u.lowLevel().includePath()||null==u.parent()){u.unitMap||(u.unitMap={},u.asElement().elements().forEach(function(e){if(e.definition().key()==F.Universe10.UsesDeclaration){var t=e.attr("value");if(t){var n=e.root().lowLevel().unit().resolve(t.value());if(null!=n){var r=e.attr("key");r&&(u.unitMap[n.absolutePath()]=r.value())}}}}));var l=u.unitMap[e.lowLevel().unit().absolutePath()];if(l)return l+"."+n}if(!u.parent())break;u=u.parent()}return n}function i(e){var t=e;return t&&t.valueName&&t.toHighLevel&&t.toHighLevel2}function a(e){var t=e.property();if(!t)return!1;var n=e.parent(),r=n&&n.definition();if(!r)return!1;if("RAML08"==r.universe().version()){if(G.isStringTypeDeclarationDescendant(r)&&(G.isExampleProperty(t)||G.isDefaultValue(t)||G.isEnumProperty(t)))return!0}else if(G.isTypeOrSchemaProperty(t)&&G.isTypeDeclarationDescendant(r))return!1;return!!G.isStringTypeType(t.range())}function o(e){var t=e;return t&&t.isString&&t.isFromKey&&t.isEmbedded}function s(e){var t=j.newMap([j.newMapping(j.newScalar("example"),e.lowLevel().actual())]),n=j.newMapping(j.newScalar("types"),j.newMap([j.newMapping(j.newScalar("__AUX_TYPE__"),t)])),r=j.newMap([n]),i=new B.ASTNode(r,e.lowLevel().unit(),null,null,null),a=z.parseFromAST(new ae(i,e)),o=z.toNominal(a.types()[0],function(e){return null});return o}function u(e){return e.match(/^\s*#%RAML\s+(\d\.\d)\s*(\w*)\s*$/m)}function l(e){var t=e.lowLevel()&&e.lowLevel().unit()&&e.lowLevel().unit().contents();return null==t?null:ue(t,e.lowLevel()).ptype}function p(e){
if(null==e)return null;var t=e.contents(),n=e.ast(),r=ue(t,n),i=r.ptype,a=r.localUniverse,o=a.type(i);o||(o=a.type("Api"));var s=new se(n,null,o,null);s.setUniverse(a);var u=o&&o.universe();return u&&"RAML10"==u.version()?o.isAssignableFrom(L.universesInfo.Universe10.LibraryBase.name)||s.children():s.children(),s}function c(e,t){if(t){var n=t.root().lowLevel().unit();return n?new Q.PointOfViewValidationAcceptorImpl(e,t.root()):{accept:function(t){e.push(t)},begin:function(){},end:function(){},acceptUnique:function(t){for(var n=0,r=e;n<r.length;n++){var i=r[n];if(i.start==t.start&&i.message==t.message)return}this.accept(t)}}}}function f(e){if(null!=e.parent())return!1;var t=e.lowLevel().unit();if(null==t)return!1;var n=t.contents(),r=u(n);return!(r.length<3)&&"AnnotationTypeDeclaration"==r[2]}function h(e,t,n){var r=e.validationIssue;if(!r){var i=e.issueCode||t,a=e.node||n,o=e.message||U.createIssue1(Z.PLUGIN_REPORTS_AN_ERROR,{pluginId:t},a,!1).message,s=e.isWarning;r=U.createIssue(i,o,a,s)}return r}function d(e){for(var t=[],n=R.getNodeValidationPlugins(),r=0,i=n;r<i.length;r++){var a=i[r],o=a.process(e);o&&o.forEach(function(n){var r=h(n,a.id(),e);t.push(r)})}return t}function m(e){for(var t=new le(e),n=[],r=R.getNodeAnnotationValidationPlugins(),i=0,a=r;i<a.length;i++){var o=a[i],s=o.process(t);s&&s.forEach(function(t){var r=h(t,o.id(),e);n.push(r)})}return n}function y(e,t){var n=e.map(function(e){return g(e,t)}),r=v(n);return r}function v(e){var t=[],n={};e.map(function(e){n[JSON.stringify(e)]=e});for(var r=Object.keys(n),i=0;i<r.length;i++)t.push(n[r[i]]);return t}function g(e,t){var n=e.node&&e.node.lowLevel()&&e.node.lowLevel().unit().lineMapper()||t.lowLevel().unit().lineMapper(),r=null;try{r=n.position(e.start)}catch(e){console.warn(e)}var i=null;try{i=n.position(e.end)}catch(e){console.warn(e)}var a;a=e.path?e.path:e.node?e.node.lowLevel().unit().path():O.declRoot(t).lowLevel().unit().path();var o={code:e.code,message:e.message,path:a,range:{start:r,end:i},isWarning:e.isWarning};return e.extras&&e.extras.length>0&&(o.trace=e.extras.map(function(e){return g(e,t)})),o}function A(e){if(e.kind()==j.Kind.SCALAR)return void(_(e.value())&&e.addMeta("skipValidation",!0));var t=e.childWithKey(L.universesInfo.Universe10.TypeDeclaration.properties.type.name),n=e.childWithKey(L.universesInfo.Universe10.TypeDeclaration.properties.schema.name),r=[];t&&(t.kind()==j.Kind.SEQ?r=r.concat(t.children()):r.push(t)),n&&(n&&n.kind()==j.Kind.SEQ?r=r.concat(n.children()):r.push(n));for(var i=!1,a=0,o=r;a<o.length;a++){var s=o[a];if(s.kind()==j.Kind.SCALAR){var u=s.value();i=i||_(u)}else s.kind()!=j.Kind.MAP&&s.kind()!=j.Kind.MAPPING||A(s)}for(var l=0,p=e.children();l<p.length;l++){var c=p[l],f=c.key();_(f)?c.addMeta("skipValidation",!0):"string"==typeof c.value()?_(c.value())&&c.addMeta("skipValidation",!0):f&&f.length>0&&"("==f.charAt(0)&&")"==f.charAt(f.length-1)&&T(c.node())&&c.addMeta("skipValidation",!0)}i&&e.addMeta("skipValidation",!0);var h=e.childWithKey(L.universesInfo.Universe10.ObjectTypeDeclaration.properties.properties.name);E(h);var d=e.childWithKey(L.universesInfo.Universe10.TypeDeclaration.properties.facets.name);E(d);var m=e.childWithKey(L.universesInfo.Universe10.ArrayTypeDeclaration.properties.items.name);if(m)if(m.kind()==j.Kind.SCALAR)_(m.value())&&m.addMeta("skipValidation",!0);else if(m.kind()==j.Kind.MAP||m.kind()==j.Kind.MAPPING)for(var y=0,v=m.children();y<v.length;y++){var g=v[y];A(g)}}function E(e){if(e)for(var t=0,n=e.children();t<n.length;t++){var r=n[t];A(r)}}function _(e){if("string"==typeof e){var t=e.indexOf("<<");if(t>=0&&e.indexOf(">>",t)>0)return!0}return!1}function T(e){var t=e.value();if("string"==typeof t&&-1!=t.indexOf("<<"))return!0;for(var n=e.children(),r=0;r<n.length;r++)if(T(n[r]))return!0;return!1}function N(e,t){void 0===t&&(t=!1);var n,r=e.lowLevel(),i=r.unit().absolutePath(),a=S(r);if(r.kind()!=j.Kind.INCLUDE_REF&&r.valueKind()!=j.Kind.INCLUDE_REF||a.absolutePath()!=i||!r.includePath()){if(a.isRAMLUnit()&&a.ast()){var o=a.ast().includePath();o&&(n=o)}}else n=r.includePath();if(n||(n=a.absolutePath()),t&&i==n)return null;if(!M.isWebPath(n)){var s=a.project().getRootPath();n=$.relative(s,n).replace(/\\/g,"/")}return n}function S(e){for(var t=e.unit(),n=t;e.kind()==j.Kind.INCLUDE_REF||e.valueKind()==j.Kind.INCLUDE_REF;){var r=e.includePath(),i=n.resolve(r);if(!i)break;if(n=i,!n.isRAMLUnit())break;e=n.ast()}return n}var b=this&&this.__extends||function(){var e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();Object.defineProperty(t,"__esModule",{value:!0});var I=n(56),R=n(196),M=n(5),w=n(16),C=n(197),L=I,P=n(270),O=n(271),D=n(275),U=n(19),x=n(276),k=n(286),F=n(202),B=n(4),V=n(287),K=L,j=n(21),W=n(288),H=n(293),Y=n(289),q=n(283),G=n(203),X=n(229),z=I.rt,$=n(6),J=n(295),Q=n(296),Z=n(269);t.qName=r;var ee=function(){function e(e,t){this._node=e,this._parent=t,this._implicit=!1,this.values={},e&&e.setHighLevelParseResult(this)}return e.isInstance=function(t){return null!=t&&t.getClassIdentifier&&"function"==typeof t.getClassIdentifier&&w.contains(t.getClassIdentifier(),e.CLASS_IDENTIFIER)},e.prototype.getClassIdentifier=function(){var t=[];return t.concat(e.CLASS_IDENTIFIER)},e.prototype.getKind=function(){return R.NodeKind.BASIC},e.prototype.asAttr=function(){return null},e.prototype.asElement=function(){return null},e.prototype.hashkey=function(){return this._hashkey||(this._hashkey=this.parent()?this.parent().hashkey()+"/"+this.name():this.name()),this._hashkey},e.prototype.root=function(){return this.parent()?this.parent().root():this},e.prototype.version=function(){return""},e.prototype.getLowLevelStart=function(){return this.lowLevel().kind()===B.Kind.SCALAR?this.lowLevel().start():this.lowLevel().keyStart()},e.prototype.getLowLevelEnd=function(){return this.lowLevel().kind()===B.Kind.SCALAR?this.lowLevel().end():this.lowLevel().keyEnd()},e.prototype.isSameNode=function(e){return!(!e||e.lowLevel().actual()!=this.lowLevel().actual())},e.prototype.checkContextValue=function(e,t,n){var r=this.computedValue(e);return!(!r||-1==r.indexOf(t))||t==r||"false"==t},e.prototype.printDetails=function(e){return(e?e:"")+"Unkown\n"},e.prototype.testSerialize=function(e){return(e?e:"")+"Unkown\n"},e.prototype.errors=function(){var e=[],t=c(e,this);return this.validate(t),e},e.prototype.markCh=function(){for(var e=this.lowLevel();C.LowLevelProxyNode.isInstance(e);)e=e.originalNode();return e=e._node?e._node:e,!!e.markCh||void(e.markCh=1)},e.prototype.unmarkCh=function(){for(var e=this.lowLevel();C.LowLevelProxyNode.isInstance(e);)e=e.originalNode();e=e._node?e._node:e,delete e.markCh},e.prototype.validate=function(e){U.validate(this,e);for(var t=0,n=d(this);t<n.length;t++){var r=n[t];e.accept(r)}for(var i=0,a=m(this);i<a.length;i++){var r=a[i];e.accept(r)}},e.prototype.allowRecursive=function(){return!1},e.prototype.setComputed=function(e,t){this.values[e]=t},e.prototype.setValueSource=function(e){this._valueSource=e},e.prototype.computedValue=function(e){var t=this.values[e];if(!t){if(this.parent())return this.parent().computedValue(e);if(this._valueSource)return this._valueSource.computedValue(e);if(this.isElement()){var n=this.asElement().getMaster();if(n)return n.computedValue(e)}}return t},e.prototype.lowLevel=function(){return this._node},e.prototype.name=function(){var e=this.lowLevel().key();return e?e:""},e.prototype.optional=function(){var e=this.lowLevel(),t=e.optional();if(null!=e.key())return t;var n=this.property();if(!n||!n.isMultiValue())return t;for(var r=e.parent();r&&null==r.highLevelNode();){if(r.kind()==j.Kind.MAPPING)return r.optional();r=r.parent()}return t},e.prototype.parent=function(){return this._parent},e.prototype.setParent=function(e){this._parent=e},e.prototype.isElement=function(){return!1},e.prototype.directChildren=function(){return this.children()},e.prototype.children=function(){return[]},e.prototype.isAttached=function(){return null!=this.parent()},e.prototype.isImplicit=function(){return this._implicit},e.prototype.isAttr=function(){return!1},e.prototype.isUnknown=function(){return!0},e.prototype.id=function(){var e=this;if(this.cachedId)return this.cachedId;if(this._parent){var t=this.parent().id();t+="."+this.name();var n=this.parent().directChildren().filter(function(t){return t.name()==e.name()});if(n.length>1){var r=n.indexOf(this);t+="["+r+"]"}return this.cachedId=t,t}return this.cachedId="",this.cachedId},e.prototype.localId=function(){return this.name()},e.prototype.resetIDs=function(){this.cachedId=null,this.cachedFullId=null},e.prototype.fullLocalId=function(){var e=this;if(this.cachedFullId)return this.cachedFullId;if(this._parent){var t=".";t+=null!=this.property()&&G.isAnnotationsProperty(this.property())?this.lowLevel().key():this.name();var n=this.parent().directChildren().filter(function(t){return t.name()==e.name()});if(n.length>1){var r=n.indexOf(this);t+="["+r+"]"}return this.cachedFullId=t,t}return this.cachedFullId=this.localId(),this.cachedFullId},e.prototype.property=function(){return null},e.prototype.reuseMode=function(){return this._reuseMode},e.prototype.setReuseMode=function(e){this._reuseMode=e},e.prototype.isReused=function(){return this._isReused},e.prototype.setReused=function(e){this._isReused=e,this.children().forEach(function(t){return t.setReused(e)})},e.prototype.setJSON=function(e){this._jsonCache=e},e.prototype.getJSON=function(){return this._jsonCache},e.CLASS_IDENTIFIER="highLevelImpl.BasicASTNode",e}();t.BasicASTNode=ee;var te=function(){function e(e,t,n,r){void 0===r&&(r=null),this.node=e,this._parent=t,this.kv=r,this._pr=n}return e.isInstance=function(t){return null!=t&&t.getClassIdentifier&&"function"==typeof t.getClassIdentifier&&w.contains(t.getClassIdentifier(),e.CLASS_IDENTIFIER)},e.prototype.getClassIdentifier=function(){var t=[];return t.concat(e.CLASS_IDENTIFIER)},e.prototype.valueName=function(){var e=null;return this.kv&&(e=this.kv),e=this.node.key(),this._pr&&this._pr.isAnnotation()&&e&&"("==e.charAt(0)&&(e=e.substring(1,e.length-1)),e},e.prototype.children=function(){return this.node.children().map(function(t){return new e(t,null,null)})},e.prototype.lowLevel=function(){return this.node},e.prototype.toHighLevel=function(e){if(!e&&this._parent&&(e=this._parent),this._hl)return this._hl;var t=this.valueName(),n=e;if(C.LowLevelProxyNode.isInstance(this.node)){var i=this.node.definingUnitSequence(),a=i&&i[0]&&i[0].highLevel().asElement(),o=a&&a.lowLevel().unit().absolutePath();o==e.lowLevel().unit().absolutePath()?a=e:o==e.root().lowLevel().unit().absolutePath()&&(a=e.root()),n=a||n}var s=O.referenceTargets(this._pr,n).filter(function(e){return r(e,n)==t});if(s&&s[0]){var u=s[0].localType(),l=new se(this.node,e,u,this._pr);return this._pr&&this._pr.childRestrictions().forEach(function(e){l.setComputed(e.name,e.value)}),this._hl=l,l}return null},e.prototype.toHighLevel2=function(e){!e&&this._parent&&(e=this._parent);var t=this.valueName(),n=O.referenceTargets(this._pr,e).filter(function(n){return r(n,e)==t});if(n&&n[0]){var i=n[0].localType(),a=new se(this.node,e,i,this._pr);return this._pr&&this._pr.childRestrictions().forEach(function(e){a.setComputed(e.name,e.value)}),a}if(this._pr.range()){var a=new se(this.node.parent(),e,this._pr.range(),this._pr);return this._pr&&this._pr.childRestrictions().forEach(function(e){a.setComputed(e.name,e.value)}),a}return null},e.prototype.resetHighLevelNode=function(){this._hl=null},e.CLASS_IDENTIFIER="highLevelImpl.StructuredValue",e}();t.StructuredValue=te,t.isStructuredValue=i;var ne=function(e){function t(t,n,r,i,a){void 0===a&&(a=!1);var o=e.call(this,t,n)||this;return o._def=r,o._prop=i,o.fromKey=a,o}return b(t,e),t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&w.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_ASTPropImpl)},t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_ASTPropImpl)},t.prototype.definition=function(){return this._def},t.prototype.asAttr=function(){return this},t.prototype.errors=function(){var e=[],t=c(e,this);return this.parent().validate(t),e},t.prototype.isString=function(){return!(!this._def||this._def.key()!==F.Universe08.StringType&&this._def.key()!=F.Universe10.StringType)},t.prototype.isAnnotatedScalar=function(){return!this.property().isAnnotation()&&!this.property().isKey()&&this.lowLevel().isAnnotatedScalar()},t.prototype.annotations=function(){var e=this.lowLevel().children(),n=[],r=this.definition().universe().type(F.Universe10.Annotable.name);if(!r)return n;for(var i=r.property("annotations"),a=0;a<e.length;a++){var o=e[a],s=o.key();if(null!=s&&"("==s[0]&&")"==s[s.length-1]){var u=new t(o,this.parent(),i.range(),i);n.push(u)}}return n},t.prototype.getKind=function(){return R.NodeKind.ATTRIBUTE},t.prototype.owningWrapper=function(){return{node:this.parent().wrapperNode(),property:this.name()}},t.prototype.patchType=function(e){this._def=e},t.prototype.findReferenceDeclaration=function(){var e=this,t=O.referenceTargets(this.property(),this.parent()),n=this.value();if(te.isInstance(n))var i=n,a=i.valueName();else var a=""+n;var o=w.find(t,function(t){return r(t,e.parent())==a});return o},t.prototype.findReferencedValue=function(){var e=this.findReferenceDeclaration();if(e){var t=e.attr("value"),n=e.definition().key();if(n===F.Universe08.GlobalSchema){if(t){var r=t.value();if(r){var i=U.isValid(this._def,this.parent(),r,t.property(),t);return i}}return null}}return e},t.prototype.isElement=function(){return!1},t.prototype.property=function(){return this._prop},t.prototype.convertMultivalueToString=function(e){for(var t=0,n=2;" "==e[n];)t++,n++;var r=V.splitOnLines(e);return r=r.map(function(e){return e.substring(t,e.length)}),r.join("")},t.prototype.overrideValue=function(e){this._value=e},t.prototype.value=function(){return null!=this._value?this._value:(this._value=this.calcValue(),this._value)},t.prototype.plainValue=function(){var e=this,t=this.value();if(te.isInstance(t)){var n=t,r=n.lowLevel();t=r?r.dumpToObject():null;var i=this.property(),a=i.range(),o=i.nameId();if(a.isAssignableFrom("Reference")){var s=Object.keys(t)[0],u=n.valueName(),l=t[s];void 0===l&&(l=null),t={name:u,structuredValue:l}}else if("type"==o){var r=this.lowLevel(),p=L.getUniverse("RAML10").type(F.Universe10.TypeDeclaration.name),c=L.getUniverse("RAML10").type(F.Universe10.LibraryBase.name),f=new se(r,this.parent(),p,c.property(F.Universe10.LibraryBase.properties.types.name));f.patchType(P.doDescrimination(f)),t=f}else if("items"==o&&"object"==typeof t){var h=Array.isArray(t),d=!h;if(h&&(d=null!=w.find(t,function(e){return"object"==typeof e})),d){t=null;var m=this.parent().lowLevel();m.children().forEach(function(n){if("items"==n.key()){var r=L.getUniverse("RAML10").type(F.Universe10.TypeDeclaration.name),i=L.getUniverse("RAML10").type(F.Universe10.LibraryBase.name),a=new se(n,e.parent(),r,i.property(F.Universe10.LibraryBase.properties.types.name));a.patchType(P.doDescrimination(a)),t=a}})}}}return t},t.prototype.calcValue=function(){if(this._computed)return this.computedValue(this.property().nameId());if(this.fromKey){var e=this.parent(),t=e.definition();if("RAML08"==t.universe().version())return this._node.key();if(G.isNameProperty(this.property())&&t.isAssignableFrom(F.Universe10.TypeDeclaration.name)){var n=e.attr("required");if(n&&null!=n.value())return this._node.optional()?this._node.key()+"?":this._node.key()}return this._node.key()}if(this.property().isAnnotation()&&this._node.key()&&"annotations"!=this._node.key())return new te(this._node,this.parent(),this._prop);var r=a(this),i=this._node.value(r);if(this.property().isSelfNode()&&(i&&!B.ASTNode.isInstance(i)||(i=this._node,0==i.children().length&&(i=null))),B.ASTNode.isInstance(i)||C.LowLevelProxyNode.isInstance(i)){var o=!1;if(this.property().range().hasStructure()||this._node.isAnnotatedScalar()&&this._node.children().forEach(function(e){"value"===e.key()&&(i=e.value(r),o=!0)}),!o)return this._sval?this._sval:(this._sval=new te(i,this.parent(),this._prop),this._sval)}if("string"==typeof i&&V.isMultiLineValue(i)){var s=this.convertMultivalueToString(i);return s}return null==i&&this._node.children().length>0&&this.property()&&(G.isTypeOrSchemaProperty(this.property())||G.isItemsProperty(this.property()))&&this.parent()&&G.isTypeDeclarationDescendant(this.parent().definition())?new te(this._node,this.parent(),this._prop):i},t.prototype.name=function(){return this._prop.nameId()},t.prototype.printDetails=function(e){var t=this.definition().nameId(),n=this.property().range().nameId(),r=(e?e:"")+(this.name()+" : "+t+"["+n+"]  =  "+this.value())+(this.property().isKey()&&this.optional()?"?":"")+"\n";if(te.isInstance(this.value())){var i=this.value().toHighLevel();i&&i.printDetails&&(r+=i.printDetails(e+"	"))}return r},t.prototype.testSerialize=function(e){var t=this.definition().nameId(),n=(e?e:"")+(this.name()+" : "+t+"  =  "+this.value())+"\n";if(te.isInstance(this.value())){var r=this.value().toHighLevel();if(r&&r.testSerialize)n+=r.testSerialize((e?e:"")+"  ");else{var i=this.value().lowLevel(),a=i.dumpToObject(),o=JSON.stringify(a),s="",u=o.split("\n");u.forEach(function(t){return s+=(e?e:"")+"  "+t+"\n"}),n+=s+"\n"}}return n},t.prototype.isAttr=function(){return!0},t.prototype.isUnknown=function(){return!1},t.prototype.setValue=function(e){D.setValue(this,e),this._value=null},t.prototype.setKey=function(e){D.setKey(this,e),this._value=null},t.prototype.children=function(){return[]},t.prototype.addStringValue=function(e){D.addStringValue(this,e),this._value=null},t.prototype.addStructuredValue=function(e){D.addStructuredValue(this,e),this._value=null},t.prototype.addValue=function(e){if(!this.property().isMultiValue())throw new Error(Z.SETVALUE_ONLY_MULTI_VALUES_PROPERTIES.message);"string"==typeof e?this.addStringValue(e):this.addStructuredValue(e),this._value=null},t.prototype.isEmbedded=function(){var e=this.lowLevel().asMapping().key.value;return this.property().canBeValue()&&e!=this.property().nameId()},t.prototype.remove=function(){D.removeAttr(this)},t.prototype.setValues=function(e){D.setValues(this,e),this._value=null},t.prototype.isEmpty=function(){if(!this.property().isMultiValue())throw new Error(Z.ISEMPTY_ONLY_MULTI_VALUES_ATTRIBUTES.message);var e=this.parent(),t=(e.lowLevel(),e.attributes(this.name()));if(0==t.length)return!0;if(1==t.length){var n=t[0].lowLevel();return!(!n.isMapping()||null!=n.value())}return!1},t.prototype.isFromKey=function(){return this.fromKey},t.CLASS_IDENTIFIER_ASTPropImpl="highLevelImpl.ASTPropImpl",t}(ee);t.ASTPropImpl=ne,t.isASTPropImpl=o;var re,ie=new P.BasicNodeBuilder;!function(e){e[e.MERGE=0]="MERGE",e[e.AGGREGATE=1]="AGGREGATE"}(re=t.OverlayMergeMode||(t.OverlayMergeMode={}));var ae=function(e){function t(n,r){var i=e.call(this)||this;i._node=n,i._highLevelRoot=r;var a=r.root(),o=a.getMaster();if(o&&i._node===r.lowLevel()){var s=r.getMasterCounterPart();s&&(i._toMerge=new t(s.lowLevel(),s))}return i}return b(t,e),t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&w.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_LowLevelWrapperForTypeSystem)},t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_LowLevelWrapperForTypeSystem)},t.prototype.contentProvider=function(){var e=this._node&&this._node.includeBaseUnit()&&(this._node.includePath&&this._node.includePath()?this._node.includeBaseUnit().resolve(this._node.includePath()):this._node.includeBaseUnit());return new J.ContentProvider(e)},t.prototype.key=function(){var e=this._node.key();return this._node.optional()&&(e+="?"),e},t.prototype.value=function(){var e=this._node.resolvedValueKind();if(e===j.Kind.SEQ)return this.children().map(function(e){return e.value()});if(e===j.Kind.MAP){var t=this._node.dumpToObject(!1);return t[this.key()]}if(this._node.kind()==j.Kind.MAP){var t=this._node.dumpToObject(!1);return t}var n=this._node.value();return n},t.prototype.children=function(){var e=this;if(this._children)return this._children;var n="uses"==this.key();if(n){var r=this._node.parent(),i=r.parent();null!=i&&this._node.unit().absolutePath()==i.unit().absolutePath()&&(n=!1)}n?this._children=this._node.children().map(function(t){return new oe(t,e._highLevelRoot)}):this._children=this._node.children().map(function(n){return new t(n,e._highLevelRoot)}),this.childByKey={};for(var a=0;a<this._children.length;a++){var o=this._children[a];this.childByKey[o.key()]=o}if(this._toMerge)for(var s=this._toMerge.children(),a=0;a<s.length;a++){var o=s[a],u=this.childByKey[o.key()];u?u._toMerge=o:(this._children.push(o),this.childByKey[o.key()]=o)}return this._children},t.prototype.childWithKey=function(e){return this._children||this.children(),this.childByKey[e]},t.prototype.kind=function(){var e=this._node.valueKind();if(e==j.Kind.MAPPING||null===e)return z.NodeKind.MAP;if(e==j.Kind.MAP)return z.NodeKind.MAP;var t=this._node.kind();return t==j.Kind.MAP?z.NodeKind.MAP:e==j.Kind.SEQ?z.NodeKind.ARRAY:(e==j.Kind.INCLUDE_REF||e==j.Kind.ANCHOR_REF)&&this._node.children().length>0?z.NodeKind.MAP:z.NodeKind.SCALAR},t.prototype.getSource=function(){if(!this._node)return null;var e=this._node.highLevelNode();if(!e){var t=this._node.start(),n=O.deepFindNode(this._highLevelRoot,t,t,!0,!1);return n&&(this._node.setHighLevelParseResult(n),se.isInstance(n)&&this._node.setHighLevelNode(n)),n}return e},t.prototype.node=function(){return this._node},t.prototype.getMeta=function(e){return this.ownMeta&&this.ownMeta.hasOwnProperty(e)?this.ownMeta[e]:C.LowLevelProxyNode.isInstance(this._node)&&this._node.getMeta(e)},t.prototype.addMeta=function(e,t){this.ownMeta||(this.ownMeta={}),this.ownMeta[e]=t},t.CLASS_IDENTIFIER_LowLevelWrapperForTypeSystem="highLevelImpl.LowLevelWrapperForTypeSystem",t}(I.SourceProvider);t.LowLevelWrapperForTypeSystem=ae;var oe=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return b(t,e),t.prototype.children=function(){var e=this._node.unit().resolve(this.value());return e&&e.isRAMLUnit()&&e.contents().trim().length>0?new ae(e.ast(),this._highLevelRoot).children():[]},t.prototype.anchor=function(){return this._node.actual()},t.prototype.childWithKey=function(e){for(var t=this.children(),n=0;n<t.length;n++)if(t[n].key()==e)return t[n];return null},t}(ae);t.UsesNodeWrapperFoTypeSystem=oe,t.auxiliaryTypeForExample=s;var se=function(e){function t(t,n,r,i){var a=e.call(this,t,n)||this;return a._def=r,a._prop=i,a._expanded=!1,a._allowQuestion=!1,a._subTypesCache=null,a._auxChecked=!1,a.overlayMergeMode=re.MERGE,t&&t.setHighLevelNode(a),C.LowLevelProxyNode.isInstance(t)&&(a._expanded=!0),a}return b(t,e),t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&w.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_ASTNodeImpl)},t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_ASTNodeImpl)},t.prototype.createIssue=function(e){return U.toIssue(e,this)},t.prototype.validate=function(t){var n=this.definition().key();if((n==F.Universe10.Api||n==F.Universe08.Api||n==F.Universe10.Extension)&&!this.isExpanded()){var r=x.expandTraitsAndResourceTypes(this.wrapperNode()),i=r.highLevel();return i.resetChildren(),i.children(),i._expanded=!0,i.clearTypesCache(),void i.validate(t)}n!=F.Universe10.Overlay&&n!=F.Universe10.Extension||this.clearTypesCache(),e.prototype.validate.call(this,t)},t.prototype.clearTypesCache=function(){if(this._types=null,this.lowLevel()){var e=this.lowLevel().actual();e.types=null}},t.prototype.types=function(){var e=this;if(!this._types){if(this.parent()&&this.definition().key()!==F.Universe10.Library)return this.parent().types();var t=this.lowLevel().actual();if(t.types)return t.types;var n=this.lowLevel().unit();if(n){var r=n.project();if(n.absolutePath()!=r.getMainUnitPath()){var i=r.getMainUnit();if(i){var a=r.namespaceResolver(),o=a.unitModel(i).extensionSet();if(!o[n.absolutePath()]){var s=i.highLevel().types();if(s){var u=a.resolveNamespace(i,n);if(u){for(var l=u.namespaceSegments,p=s,c=0;c<l.length;){for(var f=void 0,h=c;h<l.length;h++){var d=l.slice(c,h+1).join(".");f=p.library(d),f&&(c=h+1,p=f)}if(null==f){p=null;break}}p&&(this._types=p)}}}}}}this._types||(this._types=z.parseFromAST(new ae(this.lowLevel(),this)),this._types.types().forEach(function(t){var n=k.convertType(e,t);n.putExtra(I.USER_DEFINED_EXTRA,!0)})),t.types=this._types}return this._types},t.prototype.setTypes=function(e){this._types=e},t.prototype.parsedType=function(){if(!this._ptype){var e=new ae(this.lowLevel(),this);if(U.typeOfContainingTemplate(this)&&A(e),"RAML08"==this.universe().version()&&G.isStringTypeDeclarationDescendant(this.definition())&&e.addMeta("acceptAllScalarsAsStrings",!0),this.property()&&this.property().nameId()==F.Universe10.MethodBase.properties.body.name){var t=this.isParametrizedType();this._ptype=z.parseTypeFromAST(this.name(),e,this.types(),!0,!1,!1,t)}else{var n=this.property()&&this.property().nameId()==F.Universe10.LibraryBase.properties.annotationTypes.name,r=!this.property()||this.property().nameId()==F.Universe10.LibraryBase.properties.types.name||this.property().nameId()==F.Universe10.LibraryBase.properties.schemas.name;if(!n&&null==this.parent()){var i=this.universe();i&&i.getOriginalTopLevelText()&&"AnnotationTypeDeclaration"==i.getOriginalTopLevelText()&&(n=!0)}this._ptype=z.parseTypeFromAST(this.name(),e,this.types(),!1,n,r)}this.property()&&G.isTypesProperty(this.property())&&this.parent()&&G.isApiType(this.parent().definition())&&this._ptype.putExtra&&this._ptype.putExtra(I.DEFINED_IN_TYPES_EXTRA,!0);var a=this._ptype;a.putExtra(I.USER_DEFINED_EXTRA,!0),this._ptype.putExtra(I.SOURCE_EXTRA,this)}return this._ptype},t.prototype.isParametrizedType=function(){var e=!1,t=this.attr(F.Universe10.TypeDeclaration.properties.type.name);if(t){var n=t.value();if("string"==typeof n&&n.indexOf("<<")>=0)for(var r=this.parent();null!=r;){if(G.isResourceTypeType(r.definition())||G.isTraitType(r.definition())){e=!0;break}r=r.parent()}}return e},t.prototype.localType=function(){return k.typeFromNode(this)},t.prototype.patchProp=function(e){this._prop=e},t.prototype.getKind=function(){return R.NodeKind.NODE},t.prototype.wrapperNode=function(){if(!this._wrapperNode){if(G.isExampleSpecType(this.definition())){var e=s(this),t=W.examplesFromNominal(e,this,!0,!1);return t[0]}var n=this.definition()&&this.definition().universe();n&&"RAML10"==n.version()?this.definition()&&this.definition().isAssignableFrom(L.universesInfo.Universe10.LibraryBase.name)||this.children():this.children(),this._wrapperNode=this.buildWrapperNode()}return this._wrapperNode},t.prototype.asElement=function(){return this},t.prototype.buildWrapperNode=function(){var e=this.definition().universe().version();return"RAML10"==e?Y.buildWrapperNode(this):"RAML08"==e?q.buildWrapperNode(this):null},t.prototype.propertiesAllowedToUse=function(){var e=this;return this.definition().allProperties().filter(function(t){return e.isAllowedToUse(t)})},t.prototype.isAllowedToUse=function(e){var t=this,n=!0;return!e.getAdapter(K.RAMLPropertyService).isSystem()&&(e.getContextRequirements().forEach(function(e){if(-1!=e.name.indexOf("("))return!0;var r=t.computedValue(e.name);r?n=n&&r==e.value:e.value&&(n=!1)}),n)},t.prototype.allowRecursive=function(){return!!this.definition().getAdapter(K.RAMLService).isUserDefined()},t.prototype.setWrapperNode=function(e){this._wrapperNode=e},t.prototype.setAssociatedType=function(e){this._associatedDef=e},t.prototype.associatedType=function(){return this._associatedDef},t.prototype.knownIds=function(){return this.isAuxilary(),this._knownIds?this._knownIds:{}},t.prototype.findById=function(e){var t=this,n=this.root();if(n!=this)return n.findById(e);if(!this._knownIds){this._knownIds={};var r=O.allChildren(this);r.forEach(function(e){return t._knownIds[e.id()]=e})}if(this.isAuxilary()){if(!this._slaveIds){this._slaveIds={},this._slaveIds[this.id()]=this;var r=O.allChildren(this);r.forEach(function(e){return t._slaveIds[e.id()]=e})}var i=this._slaveIds[e];if(i)return i}return this._knownIds[e]},t.prototype.isAuxilary=function(){if(this._isAux)return!0;if(this._auxChecked)return!1;this._auxChecked=!0;var e=this.getMaster();return!!e&&(this._isAux=!0,this.initilizeKnownIDs(e),!0)},t.prototype.initilizeKnownIDs=function(e){var t=this;this._knownIds={};var n=O.allChildren(e);n.forEach(function(e){return t._knownIds[e.id()]=e}),this._knownIds[""]=e},t.prototype.getMaster=function(){if(this.masterApi)return this.masterApi;var e=this.calculateMasterByRef();return e&&e.setSlave(this),e},t.prototype.overrideMaster=function(e){this.masterApi=e,this.resetAuxilaryState(),e&&e.setSlave(this)},t.prototype.setSlave=function(e){this.slave=e},t.prototype.setMergeMode=function(e){this.overlayMergeMode=e,this.resetAuxilaryState()},t.prototype.getMergeMode=function(){return this.overlayMergeMode},t.prototype.calculateMasterByRef=function(){var e=this.lowLevel().unit();if(!e)return null;var t=e.getMasterReferenceNode();if(!t||!t.value())return null;var n=this.lowLevel();if(n.master)return n.master;var r=t.value(),i=this.lowLevel().unit().project().resolve(this.lowLevel().unit().path(),r);if(!i)return null;var a=i.expandedHighLevel();return a.setMergeMode(this.overlayMergeMode),n.master=a,a},t.prototype.resetAuxilaryState=function(){this._isAux=!1,this._auxChecked=!1,this._knownIds=null,this.clearChildrenCache()},t.prototype.printDetails=function(e){var t="";e||(e="");var n=this.definition().nameId(),r=this.property()?this.property().range().nameId():"",i=this.property()?this.property().nameId():"";return t+=e+n+"["+r+"] <--- "+i+"\n",this.children().forEach(function(n){t+=n.printDetails(e+"	")}),t},t.prototype.testSerialize=function(e){var t="";e||(e="");var n=this.definition().nameId(),r=this.property()?this.property().nameId():"";return t+=e+n+" <-- "+r+"\n",this.children().forEach(function(n){n.testSerialize&&(t+=n.testSerialize(e+"  "))}),t},t.prototype.getExtractedChildren=function(){var e=this.root();if(e.isAuxilary()){if(e._knownIds){var t=e._knownIds[this.id()];if(t){var n=t.children();return n}}return[]}return[]},t.prototype.getMasterCounterPart=function(){var e=this.root();if(e.isAuxilary()){if(e._knownIds){var t=e._knownIds[this.id()];return t}return null}return null},t.prototype.getSlaveCounterPart=function(){var e=this.root();return e.slave?e.slave.findById(this.id()):null},t.prototype.getLastSlaveCounterPart=function(){var e=this.root(),t=e.slave;if(null==t)return null;for(;null!=t.slave;)t=t.slave;return""==this.id()?t:t.findById(this.id())},t.prototype.getExtractedLowLevelChildren=function(e){var t=this.root();if(t.isAuxilary()){if(t._knownLowLevelIds){var n=t._knownLowLevelIds[this.id()];if(n)return n.children()}return[]}return[]},t.prototype.allowsQuestion=function(){return this._allowQuestion||this.definition().getAdapter(K.RAMLService).getAllowQuestion()},t.prototype.findReferences=function(){var e=this,t=[];O.refFinder(this.root(),this,t),t.length>1&&(t=t.filter(function(t){return t!=e&&t.parent()!=e}));var n=[];return t.forEach(function(e){w.find(n,function(t){return t==e})||n.push(e)}),n},t.prototype.setNamePatch=function(e){this._patchedName=e},t.prototype.isNamePatch=function(){return this._patchedName},t.prototype.name=function(){if(this._patchedName)return this._patchedName;var t=w.find(this.directChildren(),function(e){return e.property()&&e.property().getAdapter(K.RAMLPropertyService).isKey()});if(t&&ne.isInstance(t)){var n=null,r=this.definition(),i=r.universe().version();
if(r&&"RAML10"==i&&t.isFromKey()){var a=this._node.key();n=this._node.optional()?a+"?":a}else n=t.value();return n}return e.prototype.name.call(this)},t.prototype.findElementAtOffset=function(e){return this._findNode(this,e,e)},t.prototype.isElement=function(){return!0},t.prototype.universe=function(){return this._universe?this._universe:this.definition().universe()},t.prototype.setUniverse=function(e){this._universe=e},t.prototype._findNode=function(e,t,n){var r=this;if(null==e)return null;if(e.lowLevel()&&e.lowLevel().start()<=t&&e.lowLevel().end()>=n){var i=e;return e.elements().forEach(function(a){if(a.lowLevel().unit()==e.lowLevel().unit()){var o=r._findNode(a,t,n);o&&(i=o)}}),i}return null},t.prototype.isStub=function(){return!this.lowLevel().unit()||this.lowLevel().unit().isStubUnit()},t.prototype.add=function(e){D.addToNode(this,e)},t.prototype.remove=function(e){D.removeNodeFrom(this,e)},t.prototype.dump=function(e){return this._node.dump()},t.prototype.patchType=function(e){this._def=e,this._associatedDef,this._associatedDef=null,this._children=null,this._mergedChildren=null},t.prototype.children=function(){var e=this.lowLevel();return e&&e.isValueInclude&&e.isValueInclude()&&X.isWaitingFor(e.includePath())?(this._children=null,[]):this._children?this._mergedChildren?this._mergedChildren:(this._mergedChildren=this.mergeChildren(this._children,this.getExtractedChildren()),this._mergedChildren):this._node?(this._children=ie.process(this,this._node.children()),this._children=this._children.filter(function(e){return null!=e}),this.mergeChildren(this._children,this.getExtractedChildren())):[]},t.prototype.mergeChildren=function(e,t){var n=this,r=this.root();if(r.overlayMergeMode==re.AGGREGATE)return e.concat(t);if(r.overlayMergeMode==re.MERGE){var i=[];return e.forEach(function(e){var r=w.find(t,function(t){return t.fullLocalId()==e.fullLocalId()});r?n.mergeChild(i,e,r):i.push(e)}),t.forEach(function(t){var n=w.find(e,function(e){return t.fullLocalId()==e.fullLocalId()});n||i.push(t)}),i}return null},t.prototype.mergeLowLevelChildren=function(e,t){var n=this,r=this.root();if(r.overlayMergeMode==re.AGGREGATE)return e.concat(t);if(r.overlayMergeMode==re.MERGE){var i=[];return e.forEach(function(e){var r=w.find(t,function(t){return t.key()==e.key()});r?n.mergeLowLevelChild(i,e,r):i.push(e)}),t.forEach(function(t){var n=w.find(e,function(e){return t.key()==e.key()});n||i.push(t)}),i}return null},t.prototype.mergeLowLevelChild=function(e,t,n){return t.kind()!=n.kind()?(e.push(t),void e.push(n)):void e.push(t)},t.prototype.mergeChild=function(e,t,n){return t.getKind()!=n.getKind()?(e.push(t),void e.push(n)):t.getKind()==R.NodeKind.NODE?void e.push(t):t.getKind()==R.NodeKind.ATTRIBUTE?void e.push(t):t.getKind()==R.NodeKind.BASIC?(e.push(t),void e.push(n)):void 0},t.prototype.directChildren=function(){return this._children?this._children:this._node?(this._children=ie.process(this,this._node.children()),this._mergedChildren=null,this._children):[]},t.prototype.resetChildren=function(){this._children=null,this._mergedChildren=null},t.prototype.isEmptyRamlFile=function(){var e=this.lowLevel().root();return e.isScalar()},t.prototype.initRamlFile=function(){D.initEmptyRAMLFile(this)},t.prototype.createAttr=function(e,t){D.createAttr(this,e,t)},t.prototype.isAttr=function(){return!1},t.prototype.isUnknown=function(){return!1},t.prototype.value=function(){return this._node.value()},t.prototype.valuesOf=function(e){var t=this._def.property(e);return null!=t?this.elements().filter(function(e){return e.property()==t}):[]},t.prototype.attr=function(e){return w.find(this.attrs(),function(t){return t.name()==e})},t.prototype.attrOrCreate=function(e){var t=this.attr(e);return t||this.createAttr(e,""),this.attr(e)},t.prototype.attrValue=function(e){var t=this.attr(e);return t?t.value():null},t.prototype.attributes=function(e){return w.filter(this.attrs(),function(t){return t.name()==e})},t.prototype.attrs=function(){var e=this.children().filter(function(e){return e.isAttr()});if(this._patchedName){var t=w.find(this.definition().allProperties(),function(e){return e.getAdapter(K.RAMLPropertyService).isKey()});if(t){var n=new ne(this.lowLevel(),this,t.range(),t,!0);return n._value=this._patchedName,[n].concat(e)}}return e},t.prototype.elements=function(){return this.children().filter(function(e){return!e.isAttr()&&!e.isUnknown()})},t.prototype.element=function(e){var t=this.elementsOfKind(e);return t.length>0?t[0]:null},t.prototype.elementsOfKind=function(e){var t=this.elements().filter(function(t){return t.property().nameId()==e});return t},t.prototype.definition=function(){return this._def},t.prototype.property=function(){return this._prop},t.prototype.isExpanded=function(){return this._expanded},t.prototype.copy=function(){return new t(this.lowLevel().copy(),this.parent(),this.definition(),this.property())},t.prototype.clearChildrenCache=function(){this._children=null,this._mergedChildren=null},t.prototype.optionalProperties=function(){var e=this.definition();if(null==e)return[];var t=[],n={},r=this.lowLevel().children();r.forEach(function(e){e.optional()&&(n[e.key()]=!0)});var i=e.allProperties();return i.forEach(function(e){var r=e;n[r.nameId()]&&t.push(r.nameId())}),t},t.prototype.setReuseMode=function(e){this._reuseMode=e,this._children&&this.lowLevel().valueKind()!=j.Kind.SEQ&&this._children.forEach(function(t){return t.setReuseMode(e)})},t.prototype.reusedNode=function(){return this._reusedNode},t.prototype.setReusedNode=function(e){this._reusedNode=e},t.prototype.resetRuntimeTypes=function(){delete this._associatedDef,this.elements().forEach(function(e){return e.resetRuntimeTypes()})},t.prototype.toJSON=function(e){return new H.JsonSerializer(e).dump(this)},t.CLASS_IDENTIFIER_ASTNodeImpl="highLevelImpl.ASTNodeImpl",t}(ee);t.ASTNodeImpl=se,t.universeProvider=n(297);var ue=function(e,n){var r=u(e),i=r&&r[1]||"",a=r&&r.length>2&&r[2]||"Api",o=r&&r.length>2&&r[2],s="1.0"==i?new L.Universe(null,"RAML10",t.universeProvider("RAML10"),"RAML10"):new L.Universe(null,"RAML08",t.universeProvider("RAML08"));return"API"==a?a="Api":"NamedExample"==a?a="ExampleSpec":"DataType"==a?a="TypeDeclaration":"SecurityScheme"==a?a="AbstractSecurityScheme":"AnnotationTypeDeclaration"==a&&(a="TypeDeclaration"),s.setOriginalTopLevelText(o),s.setTopLevel(a),s.setTypedVersion(i),{ptype:a,localUniverse:s}};t.ramlFirstLine=u,t.getFragmentDefenitionName=l,t.fromUnit=p,t.createBasicValidationAcceptor=c,t.isAnnotationTypeFragment=f;var le=function(){function e(e){this._node=e}return e.prototype.kind=function(){return"AnnotatedNode"},e.prototype.annotationsMap=function(){var e=this;return this._annotationsMap||(this._annotationsMap={},this.annotations().forEach(function(t){var n=t.name(),r=n.lastIndexOf(".");r>=0&&(n=n.substring(r+1)),e._annotationsMap[n]=t})),this._annotationsMap},e.prototype.annotations=function(){if(!this._annotations){var e=[];this._node.isElement()?e=this._node.asElement().attributes(L.universesInfo.Universe10.Annotable.properties.annotations.name):this._node.isAttr()&&(e=this._node.asAttr().annotations()),this._annotations=e.map(function(e){return new pe(e)})}return this._annotations},e.prototype.value=function(){if(this._node.isElement())return this._node.asElement().wrapperNode().toJSON();if(this._node.isAttr()){var e=this._node.asAttr().value();return te.isInstance(e)?e.lowLevel().dump():e}return this._node.lowLevel().dump()},e.prototype.name=function(){return this._node.name()},e.prototype.entry=function(){return this._node},e}();t.AnnotatedNode=le;var pe=function(){function e(e){this.attr=e}return e.prototype.name=function(){return this.attr.value().valueName()},e.prototype.value=function(){var e=this.attr.value();if(te.isInstance(e)){var t=e.lowLevel().dumpToObject(),n=Object.keys(t)[0];return t[n]}return e},e.prototype.definition=function(){var e=this.attr.parent(),t=this.name(),n=O.referenceTargets(this.attr.property(),e).filter(function(n){return r(n,e)==t});return 0==n.length?null:n[0].parsedType()},e}();t.AnnotationInstance=pe,t.applyNodeValidationPlugins=d,t.applyNodeAnnotationValidationPlugins=m,t.toParserErrors=y,t.actualPath=N,t.actualUnit=S},function(e,t,n){"use strict";function r(){return t.rt.getSchemaUtils()}function i(e){e.isUnion?e.addAdapter(new b(e)):e.range&&e.addAdapter(new S(e))}function a(e){return e.getSource&&"function"==typeof e.getSource}function o(e){var t=e;return t.genuineUserDefinedType&&t.isUserDefined&&t.isUserDefined()}function s(e,t,n,r,i){var a=new E(e,t);return a.withDomain(n,i).withRange(r)}var u=this&&this.__extends||function(){var e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();Object.defineProperty(t,"__esModule",{value:!0}),t.rt=n(57);var l=t.rt.nominalTypes;t.getSchemaUtils=r,t.TOP_LEVEL_EXTRA=t.rt.TOP_LEVEL_EXTRA,t.DEFINED_IN_TYPES_EXTRA=t.rt.DEFINED_IN_TYPES_EXTRA,t.USER_DEFINED_EXTRA=t.rt.USER_DEFINED_EXTRA,t.SOURCE_EXTRA=t.rt.SOURCE_EXTRA,t.tsInterfaces=t.rt.tsInterfaces,t.injector={inject:function(e){i(e)}},l.registerInjector(t.injector);var p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return u(t,e),t}(l.AbstractType);t.AbstractType=p;var c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return u(t,e),t}(l.ValueType);t.ValueType=c;var f=function(){function e(){}return e.isInstance=function(t){if(null!=t&&t.getClassIdentifier&&"function"==typeof t.getClassIdentifier)for(var n=0,r=t.getClassIdentifier();n<r.length;n++){var i=r[n];if(i==e.CLASS_IDENTIFIER)return!0}return!1},e.prototype.getClassIdentifier=function(){var t=[];return t.concat(e.CLASS_IDENTIFIER)},e.prototype.getSource=function(){return null},e.CLASS_IDENTIFIER="definitionSystem.SourceProvider",e}();t.SourceProvider=f,t.isSourceProvider=a;var h=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t.values=[],t}return u(t,e),t.isInstance=function(e){if(null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier)for(var n=0,r=e.getClassIdentifier();n<r.length;n++){var i=r[n];if(i==t.CLASS_IDENTIFIER)return!0}return!1},t.prototype.getClassIdentifier=function(){var e=[];return e.concat(t.CLASS_IDENTIFIER)},t.CLASS_IDENTIFIER="definitionSystem.EnumType",t}(c);t.EnumType=h;var d=function(e){function t(t,n,r,i){var a=e.call(this,t,i,n)||this;return a.referenceTo=r,a}return u(t,e),t.isInstance=function(e){if(null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier)for(var n=0,r=e.getClassIdentifier();n<r.length;n++){var i=r[n];if(i==t.CLASS_IDENTIFIER)return!0}return!1},t.prototype.getClassIdentifier=function(){var e=[];return e.concat(t.CLASS_IDENTIFIER)},t.prototype.getReferencedType=function(){return this.universe().type(this.referenceTo)},t.prototype.hasStructure=function(){return!0},t.CLASS_IDENTIFIER="definitionSystem.ReferenceType",t}(c);t.ReferenceType=d;var m=function(e){function t(t,n,r,i){return void 0===i&&(i=""),e.call(this,t,n,r)||this}return u(t,e),t.isInstance=function(e){if(null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier)for(var n=0,r=e.getClassIdentifier();n<r.length;n++){var i=r[n];if(i==t.CLASS_IDENTIFIER)return!0}return!1},t.prototype.getClassIdentifier=function(){var e=[];return e.concat(t.CLASS_IDENTIFIER)},t.prototype.allProperties=function(t){return void 0===t&&(t={}),e.prototype.allProperties.call(this,t)},t.CLASS_IDENTIFIER="definitionSystem.NodeClass",t}(l.StructuredType);t.NodeClass=m;var y=function(e){function t(t,n,r,i,a){var o=e.call(this,t,n,i,a)||this;return o.getAdapter(b).setDeclaringNode(r),o}return u(t,e),t.isInstance=function(e){if(null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier)for(var n=0,r=e.getClassIdentifier();n<r.length;n++){var i=r[n];if(i==t.CLASS_IDENTIFIER_UserDefinedClass)return!0}return!1},t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_UserDefinedClass)},t.prototype.key=function(){return null},t.prototype.isUserDefined=function(){return!0},t.prototype.typeId=function(){var e=this.nameId(),t=this.getAdapter(b).getDeclaringNode();if(t){e+=t.lowLevel().start();var n=t.lowLevel().unit();n&&(e+=n.absolutePath())}return e},t.prototype.hasValueTypeInHierarchy=function(){return!!this._value||(this.isAssignableFrom("ObjectTypeDeclaration"),!1)},t.prototype.isGenuineUserDefinedType=function(){return null!=this.genuineUserDefinedType()},t.prototype.genuineUserDefinedType=function(){var e=this.getAdapter(b).getDeclaringNode();return e?this:null},t.CLASS_IDENTIFIER_UserDefinedClass="definitionSystem.UserDefinedClass",t}(m);t.UserDefinedClass=y,t.isUserDefinedClass=o;var v=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return u(t,e),t.prototype.allProperties=function(e){void 0===e&&(e={});var t=this.superTypes()[0].allProperties();if(0==t.length){var n=this.getAdapter(b).getDeclaringNode(),r=new _("value",n);r.withDomain(this),r.withCanBeValue(),r.withRequired(!1),this.superTypes()[0],t=[],r.withRange(r.node().asElement().definition().universe().type("string")),t.push(r)}return t},t.prototype.isAnnotationType=function(){return!0},t}(y);t.AnnotationType=v;var g=function(e){function t(t,n,r,i){void 0===n&&(n=""),void 0===r&&(r=null),void 0===i&&(i="RAML08");var a=e.call(this,n)||this;return a._parent=r,a._classes=[],a._uversion="RAML08",a.aMap={},a.matchedObjects=t,a._uversion=i,a}return u(t,e),t.prototype.matched=function(){return this.matchedObjects?this.matchedObjects:this._parent?this._parent.matched():void 0},t.prototype.setTopLevel=function(e){this._topLevel=e},t.prototype.getTopLevel=function(){return this._topLevel},t.prototype.setOriginalTopLevelText=function(e){this._originalTopLevelText=e},t.prototype.getOriginalTopLevelText=function(){return this._originalTopLevelText},t.prototype.setTypedVersion=function(e){this._typedVersion=e},t.prototype.getTypedVersion=function(){return this._typedVersion},t.prototype.version=function(){return this._uversion},t.prototype.setUniverseVersion=function(e){this._uversion=e},t.prototype.types=function(){var e=[].concat(this._classes);return null!=this._parent&&(e=e.concat(this._parent.types())),e},t.prototype.type=function(e){if(this.aMap[e])return this.aMap[e];for(var t,n=0;n<this._classes.length;n++)if(this._classes[n].nameId()==e){t=this._classes[n];break}if(null==t&&this._parent){var t=this._parent.type(e);if(t instanceof p){var r=t;r._universe=this}}return t},t.prototype.register=function(e){return this._classes.push(e),e instanceof m&&this._classes.forEach(function(t){if(t instanceof m){var n=t;n.getAdapter(b).getExtendedType()==e&&e.getAdapter(b).getRuntimeExtenders().push(t)}}),this},t.prototype.registerAlias=function(e,t){this.aMap[e]=t},t.prototype.unregister=function(e){this._classes=this._classes.filter(function(t){return t!=e});var t=e.superTypes();return t.forEach(function(t){var n=t;n._superTypes=n._superTypes.filter(function(t){return t!=e})}),t=e.subTypes(),t.forEach(function(t){var n=t;n._subTypes=n._subTypes.filter(function(t){return t!=e})}),this},t.prototype.registerSuperClass=function(e,t){var n=e,r=t;n._superTypes.push(t),r._subTypes.push(e)},t}(l.Described);t.Universe=g,t.prop=s;var A=function(){function e(e,t){this.name=e,this.value=t}return e}();t.ChildValueConstraint=A;var E=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t._isFromParentValue=!1,t._isFromParentKey=!1,t._key=!1,t._declaresFields=!1,t._describes=null,t._canBeDuplicator=!1,t._allowsNull=!1,t._canBeValue=!1,t._isInherited=!1,t._selfNode=!1,t._noDirectParse=!1,t._contextReq=[],t.determinesChildValues=[],t}return u(t,e),t.isInstance=function(e){if(null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier)for(var n=0,r=e.getClassIdentifier();n<r.length;n++){var i=r[n];if(i==t.CLASS_IDENTIFIER_Property_def)return!0}return!1},t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_Property_def)},t.prototype.isPrimitive=function(){return this.range().isValueType()&&!(this.range()instanceof d)},t.prototype.withNoDirectParse=function(){this._noDirectParse=!0},t.prototype.isNoDirectParse=function(){return this._noDirectParse},t.prototype.withSelfNode=function(){this._selfNode=!0},t.prototype.isSelfNode=function(){return this._selfNode},t.prototype.matchKey=function(t){return null!=this._groupName?this.isAnnotation()?"("==t.charAt(0)&&")"==t.charAt(t.length-1):this._groupName==t:e.prototype.matchKey.call(this,t)},t.prototype.valueDocProvider=function(){return this._vprovider},t.prototype.setValueDocProvider=function(e){return this._vprovider=e,this},t.prototype.suggester=function(){return this._suggester},t.prototype.setValueSuggester=function(e){this._suggester=e},t.prototype.enumOptions=function(){return this._enumOptions&&"string"==typeof this._enumOptions?[this._enumOptions+""]:this._enumOptions},t.prototype.getOftenKeys=function(){return this._oftenKeys},t.prototype.withOftenKeys=function(e){return this._oftenKeys=e,this},t.prototype.withCanBeValue=function(){return this._canBeValue=!0,this},t.prototype.withInherited=function(e){this._isInherited=e},t.prototype.isInherited=function(){return this._isInherited},t.prototype.isAllowNull=function(){return this._allowsNull},t.prototype.withAllowNull=function(){this._allowsNull=!0},t.prototype.getCanBeDuplicator=function(){return this._canBeDuplicator},t.prototype.canBeValue=function(){return this._canBeValue},t.prototype.setCanBeDuplicator=function(){return this._canBeDuplicator=!0,!0},t.prototype.inheritedContextValue=function(){return this._inheritsValueFromContext},t.prototype.withInheritedContextValue=function(e){return this._inheritsValueFromContext=e,this},t.prototype.withContextRequirement=function(e,t){this._contextReq.push({name:e,value:t})},t.prototype.getContextRequirements=function(){return this._contextReq},t.prototype.withDescribes=function(e){return this._describes=e,this},t.prototype.describesAnnotation=function(){return null!=this._describes},t.prototype.describedAnnotation=function(){return this._describes},t.prototype.isReference=function(){return this.range()instanceof d},t.prototype.referencesTo=function(){return this.range().getReferencedType()},t.prototype.newInstanceName=function(){return this._newInstanceName?this._newInstanceName:this.range().nameId()},t.prototype.withThisPropertyDeclaresFields=function(e){return void 0===e&&(e=!0),this._declaresFields=e,this},t.prototype.isThisPropertyDeclaresTypeFields=function(){return this._declaresFields},t.prototype.withNewInstanceName=function(e){return this._newInstanceName=e,this},t.prototype.addChildValueConstraint=function(e){this.determinesChildValues.push(e)},t.prototype.getChildValueConstraints=function(){return this.determinesChildValues},t.prototype.childRestrictions=function(){return this.determinesChildValues},t.prototype.id=function(){return this._id?this._id:this._groupName?this.domain().getAdapter(b).getDeclaringNode()?null:(this._id=this._groupName+this.domain().nameId(),this._id):null},t.prototype.isAnnotation=function(){return"annotations"==this._groupName&&this.domain()&&!this.domain().isUserDefined()},t.prototype.withFromParentValue=function(e){return void 0===e&&(e=!0),this._isFromParentValue=e,this},t.prototype.withFromParentKey=function(e){return void 0===e&&(e=!0),this._isFromParentKey=e,this},t.prototype.isFromParentKey=function(){return this._isFromParentKey},t.prototype.isFromParentValue=function(){return this._isFromParentValue},t.prototype.withGroupName=function(e){return this._groupName=e,this},t.prototype.unmerge=function(){return this._groupName=this.nameId(),this},t.prototype.merge=function(){return this._groupName=null,this},t.prototype.withKey=function(e){return this._key=e,this},t.prototype.isKey=function(){return this._key},t.prototype.isMerged=function(){return null==this._groupName},t.prototype.groupName=function(){return this._groupName},t.prototype.key=function(){return null},t.CLASS_IDENTIFIER_Property_def="definitionSystem.Property",t}(l.Property);t.Property=E;var _=function(e){function t(t,n){var r=e.call(this,t)||this;return r._node=n,r}return u(t,e),t.isInstance=function(e){if(null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier)for(var n=e.getClassIdentifier(),r=0;r<n.length;r++)if(n[r]==t.CLASS_IDENTIFIER)return!0;return!1},t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER)},t.prototype.withDisplayName=function(e){this._displayName=e},t.prototype.getDisplayName=function(){return this._displayName},t.prototype.node=function(){return this._node||null==this.sourceProvider||(this._node=this.sourceProvider.getSource()),this._node},t.prototype.setSourceProvider=function(e){this.sourceProvider=e},t.CLASS_IDENTIFIER="definitionSystem.UserDefinedProp",t}(E);t.UserDefinedProp=_;var T=function(){function e(){}return e.prototype.setDocTableName=function(e){this._documentationTableName=e},e.prototype.docTableName=function(){return this._documentationTableName},e.prototype.setHidden=function(e){this._isHidden=e},e.prototype.isHidden=function(){return this._isHidden},e.prototype.setMarkdownDescription=function(e){this._markdownDescription=e},e.prototype.markdownDescription=function(){return this._markdownDescription},e.prototype.setValueDescription=function(e){this._valueDescription=e},e.prototype.valueDescription=function(){return this._valueDescription},e}();t.RAMLPropertyDocumentationService=T;var N=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return u(t,e),t.prototype.isSystem=function(){return this._isSystemProperty},t.prototype.withSystem=function(e){return this._isSystemProperty=e,this},t.prototype.isEmbedMap=function(){return this._isEmbededMap},t.prototype.withEmbedMap=function(){return this._isEmbededMap=!0,this},t}(T);t.RAMLPropertyParserService=N;var S=function(e){function t(t){var n=e.call(this)||this;if(n._property=t,n._meta={},!t)throw new Error;return n}return u(t,e),t.prototype.valueDocProvider=function(){return this._property.valueDocProvider()},t.prototype.withPropertyGrammarType=function(e){this._propertyGrammarType=e},t.prototype.getPropertyGrammarType=function(){return this._propertyGrammarType},t.prototype.id=function(){return this._property.nameId()},t.prototype.range=function(){return this._property.range()},t.prototype.domain=function(){return this._property.domain()},t.prototype.isAllowNull=function(){return this._property.isAllowNull()},t.prototype.referencesTo=function(){return this._property.referencesTo()},t.prototype.isReference=function(){return this._property.isReference()},t.prototype.nameId=function(){return this._property.nameId()},t.prototype.priority=function(){return this.isKey()?128:this.isReference()?64:this.isTypeExpr()?32:"example"==this.nameId()?0:-1024},t.prototype.isKey=function(){return this._property instanceof E&&this._property.isKey()},t.prototype.isMerged=function(){return this._property instanceof E&&this._property.isMerged()},t.prototype.isTypeExpr=function(){return this.texpr},t.prototype.isExampleProperty=function(){return this.example},t.prototype.setExample=function(e){this.example=e},t.prototype.setTypeExpression=function(e){this.texpr=e},t.prototype.isDescriminating=function(){return this._property.isDescriminator()},t.prototype.putMeta=function(e,t){this._meta[e]=t},t.prototype.meta=function(e){return this._meta[e]},t}(N);t.RAMLPropertyService=S;var b=function(){function e(e){this._allowsOptionalProperties=!1,this._possibleInterfaces=[],this._canInherit=[],this._declaredBy=[],this._aliases=[],this._defining=[],this._runtimeExtenders=[],this._declaresType=null,this._isTemplate=!1,this._contextRequirements=[],this._type=e}return e.prototype.withAllowQuestion=function(){this._allowsOptionalProperties=!0},e.prototype.getAllowQuestion=function(){return this._allowsOptionalProperties},e.prototype.withCanInherit=function(e){this._canInherit.push(e)},e.prototype.getReferenceIs=function(){return this._referenceIs},e.prototype.withReferenceIs=function(e){this._referenceIs=e},e.prototype.descriminatorValue=function(){return 0==this.valueRequirements().length?this.nameId():this.valueRequirements()[0].value},e.prototype.getCanInherit=function(){return this._canInherit},e.prototype.withAllowAny=function(){this._allowsAnyChildren=!0},e.prototype.getAllowAny=function(){return this._allowsAnyChildren||this._type.isExternal()},e.prototype.globallyDeclaredBy=function(){return this._declaredBy},e.prototype.setGloballyDeclaredBy=function(e){this._declaredBy.push(e)},e.prototype.setDeclaringNode=function(e){this._node=e},e.prototype.nameId=function(){return this._type.nameId()},e.prototype.universe=function(){return this._type.universe()},e.prototype.isAssignableFrom=function(e){return this._type.isAssignableFrom(e)},e.prototype.setConsumesRefs=function(e){this._consumesRef=e},e.prototype.definingPropertyIsEnough=function(e){this._defining.push(e)},e.prototype.getDefining=function(){return this._defining},e.prototype.getConsumesRefs=function(){return this._consumesRef},e.prototype.addAlias=function(e){this._aliases.push(e)},e.prototype.getAliases=function(){return this._aliases},e.prototype.valueRequirements=function(){return this._type.valueRequirements()},e.prototype.isAnnotation=function(){return this._annotationChecked?this._isAnnotation:(this._annotationChecked=!0,this._isAnnotation=this._type.allSuperTypes().some(function(e){return e.key()&&"AnnotationRef"==e.key().name}),this._isAnnotation)},e.prototype.allowValue=function(){return this._allowsValueSet?this._allowsValue:this._type.allProperties().some(function(e){return e.isFromParentValue()||e.canBeValue()})?(this._allowsValue=!0,this._allowsValueSet=!0,!0):(this._allowsValueSet=!0,!1)},e.prototype.key=function(){return this._type.key()},e.prototype.getRepresentationOf=function(){return this._representationOf},e.prototype.getPath=function(){return""},e.prototype.isDeclaration=function(){return!!(this._isTemplate||this._convertsToGlobal||this._declaresType||this.key()&&"Library"===this.key().name)},e.prototype.isGlobalDeclaration=function(){return!!this._actuallyExports||!!this._isTemplate||!!this._declaresType},e.prototype.isTypeSystemMember=function(){return null!=this._declaresType},e.prototype.getExtendedType=function(){return this.universe().type(this._declaresType)},e.prototype.setInlinedTemplates=function(e){return this._isTemplate=e,this},e.prototype.getRuntimeExtenders=function(){return this._runtimeExtenders},e.prototype.isInlinedTemplates=function(){return this._isTemplate},e.prototype.setExtendedTypeName=function(t){this._declaresType=t;var n=this.universe().type(t);if(n instanceof m){var r=n;r.getAdapter(e)._runtimeExtenders.push(this._type)}},e.prototype.getKeyProp=function(){for(var e=this._type.allProperties(),t=0;t<e.length;t++)if(e[t].getAdapter(S).isKey())return e[t];return null},e.prototype.withActuallyExports=function(e){this._actuallyExports=e},e.prototype.withConvertsToGlobal=function(e){this._convertsToGlobal=e},e.prototype.getConvertsToGlobal=function(){return this._convertsToGlobal},e.prototype.getActuallyExports=function(){return this._actuallyExports},e.prototype.isUserDefined=function(){return this._type instanceof m?this._type.isUserDefined():this._type instanceof p&&this._type.isUserDefined()},e.prototype.withContextRequirement=function(e,t){this._contextRequirements.push({name:e,value:t})},e.prototype.getContextRequirements=function(){return this._contextRequirements},e.prototype.findMembersDeterminer=function(){for(var e=this._type.allProperties(),t=0;t<e.length;t++)if(e[t].isThisPropertyDeclaresTypeFields())return e[t];return null},e.prototype.getDeclaringNode=function(){if(this._node)return this._node;if(this._type){var e=this._type.getExtra(t.SOURCE_EXTRA);return e?e instanceof f||e.getSource&&"function"==typeof e.getSource?e.getSource():e:null}return null},e.prototype.registerSupertypes=function(e){var t=this,n=this._type.universe();e.forEach(function(e){var r=n.type(e);r&&t._type.addSuperType(r)})},e.prototype.registerPossibleInterfaces=function(e){for(var t=this._type.universe(),n=0,r=e;n<r.length;n++){var i=r[n],a=t.type(i);if(!a)return;this._possibleInterfaces.push(a)}},e.prototype.possibleInterfaces=function(){return this._possibleInterfaces},e}();t.RAMLService=b;var I={},R=n(176),M=R.universeDumps,w=n(179),C=n(195);t.universesInfo=C,t.getUniverse=function(){var e=function(e){if(I[e])return I[e];var t=M[e],n=w.toDefSystem(t,"RAML08"==e?C.Universe08:C.Universe10);return n&&(n.setUniverseVersion(e),I[e]=n),n};return e.availableUniverses=function(){return Object.keys(M)},e}()},function(e,t,n){"use strict";function r(){return L}function i(e){return e instanceof N.AbstractType}function a(e,t){return void 0===t&&(t=N.builtInRegistry()),S.parseJSONTypeCollection(e,t)}function o(e){return S.parseJSON(null,e,N.builtInRegistry())}function s(e){return e.types||e.annotationTypes?S.parseJSONTypeCollection(e):S.parseJSON(null,e)}function u(e,t){return S.parseJSON(null,e,t?t.getTypeRegistry():N.builtInRegistry())}function l(e){return S.parseTypeCollection(e,N.builtInRegistry())}function p(e,t,n,r,i,a,o){if(void 0===r&&(r=!1),void 0===i&&(i=!1),void 0===a&&(a=!0),void 0===o&&(o=!1),a){var s;if(s=i?n.getAnnotationType(e):n.getType(e),null!=s)return s}return S.parse(e,t,n?n.getTypeRegistry():N.builtInRegistry(),r,i,a,o)}function c(e){return S.storeAsJSON(e)}function f(e,t,n){void 0===n&&(n=!1),N.autoCloseFlag=n;try{return t.validate(e,n)}finally{N.autoCloseFlag=!1}}function h(e,t){return e.validateType(t.getAnnotationTypeRegistry())}function d(e,t){return t.ac(e)}function m(e){return e.canDoAc()}function y(){return b.getInstance().allPrototypes()}function v(){return N.builtInRegistry()}function g(e){for(var t=[],n=1;n<arguments.length;n++)t[n-1]=arguments[n];return N.derive(e,t)}function A(e){for(var t=[],n=1;n<arguments.length;n++)t[n-1]=arguments[n];return N.union(e,t)}function E(e){C.setPropertyConstructor(e)}function _(e,t){return C.toNominal(e,t)}function T(e){return N.toValidationPath(e)}Object.defineProperty(t,"__esModule",{value:!0});var N=n(58);t.tsInterfaces=n(71);var S=n(169),b=n(133),I=n(73),R=n(75),M=n(75),w=n(75),C=n(172);t.nominalTypes=n(173),t.nominalInterfaces=n(174),t.typeExpressions=n(175);var L=n(60);t.TOP_LEVEL_EXTRA=t.tsInterfaces.TOP_LEVEL_EXTRA,t.DEFINED_IN_TYPES_EXTRA=t.tsInterfaces.DEFINED_IN_TYPES_EXTRA,t.USER_DEFINED_EXTRA=t.tsInterfaces.USER_DEFINED_EXTRA,t.SOURCE_EXTRA=t.tsInterfaces.SOURCE_EXTRA,t.getSchemaUtils=r,t.isParsedType=i,t.loadTypeCollection=a,t.loadType=o,t.parse=s,t.parseType=u;var P;!function(e){e[e.SCALAR=0]="SCALAR",e[e.ARRAY=1]="ARRAY",e[e.MAP=2]="MAP"}(P=t.NodeKind||(t.NodeKind={})),t.parseFromAST=l,t.parseTypeFromAST=p,t.dump=c,t.validate=f,t.validateTypeDefinition=h,t.performAC=d,t.checkACStatus=m,t.builtInFacets=y,t.builtInTypes=v,t.derive=g,t.unify=A;var O=function(){function e(e){this.target=e}return e.prototype.addProperty=function(e,t,n){return this.target.declareProperty(e,t,n),this},e.prototype.closeType=function(){return this.target.addMeta(new I.KnownPropertyRestriction(!1)),this},e.prototype.annotate=function(e,t){return this.target.addMeta(new R.Annotation(e,t,"("+t+")")),this},e.prototype.customFacet=function(e,t){return this.target.addMeta(new M.CustomFacet(e,t)),this},e.prototype.customFacetDeclaration=function(e,t,n){return void 0===n&&(n=!0),this.target.addMeta(new w.FacetDeclaration(e,t,n)),this},e.prototype.addSimpleFacet=function(e,t){return this.target.addMeta(b.getInstance().buildFacet(e,t)),this},e.prototype.getResult=function(){return this.target},e}();t.TypeConstructor=O,t.setPropertyConstructor=E,t.toNominal=_,
t.toValidationPath=T},function(e,t,n){"use strict";function r(){return new b(b.OK,"","",null)}function i(e,t,n,r,i){void 0===n&&(n={}),void 0===r&&(r=b.ERROR),void 0===i&&(i=!1);var a=I(e,n);return new b(r,e.code,a,t,i)}function a(){return ie}function o(e,t){return new ne(e,t)}function s(e,t){return new re(e,t)}function u(e,n){var r=new ee(e);return n.forEach(function(e){return r.addSuper(e)}),r.isSubTypeOf(t.NIL)&&(r.nullable=!0),r}function l(e){return u(e,[t.OBJECT])}function p(e,t,n){if(t.isScalar()&&n.isScalar()){if(-1!=t.allSubTypes().indexOf(n))return t;if(-1!=n.allSubTypes().indexOf(t))return n}var r=t.oneMeta(L.Discriminator),i=n.oneMeta(L.Discriminator);if(r&&i&&r.property===i.property){var a=t.descValue(),o=n.descValue();if(a!==o){var s=e[r.property];if(s===a)return t;if(s===o)return n}}return null}function c(e){return parseFloat(e)==parseInt(e)&&!isNaN(e)}function f(e){for(var t=[];null!=e;){if(null!=e.name()){t.push(e.name());break}if(!(e instanceof ee))break;var n=e.contextMeta();if(null==n)break;t.push(n.path()),e=n._owner}return t.reverse()}function h(e,n,a){var o=n.metaOfType(L.Discriminator);if(0==o.length)return null;var s=o[0].value(),u=T.find([n].concat(n.allSuperTypes()),function(e){return e.getExtra(t.GLOBAL)});if(!u)return null;var l=u.name(),p=n.metaOfType(L.DiscriminatorValue);if(0!=p.length&&(l=p[0].value()),l){if(e.hasOwnProperty(s)){var c=e[s];if(c!=l){var f=i(b.CODE_INCORRECT_DISCRIMINATOR,this,{rootType:u.name(),value:c,propName:s},b.WARNING);return d(f,{name:s,child:a}),f}return r()}var h=i(b.CODE_MISSING_DISCRIMINATOR,this,{rootType:u.name(),propName:s});return d(h,a),h}}function d(e,t){if(e.getValidationPath()){for(var n=m(t),r=n;r.child;)r=r.child;r.child=e.getValidationPath(),e.setValidationPath(n)}else e.setValidationPath(t);e.getSubStatuses().forEach(function(e){d(e,t)})}function m(e){if(e){for(var t=e,n=null,r=null;t;)if(n){var i={name:t.name};r.child=i,t=t.child,r=i}else n={name:t.name},r=n,t=t.child,r=n;return n}return null}function y(e){for(var t=S.getAnnotationValidationPlugins(),n=[],r=0,i=t;r<i.length;r++){var a=i[r],o=a.process(e);o&&o.forEach(function(t){n.push(g(t,a.id(),e.entry()))})}return n}function v(e,t){for(var n=S.getTypeValidationPlugins(),r=[],i=0,a=n;i<a.length;i++){var o=a[i],s=o.process(e,t);s&&s.forEach(function(t){r.push(g(t,o.id(),e))})}return r}function g(e,n,r){var i=e.isWarning?b.WARNING:b.ERROR,a=e.issueCode||n,o=e.message||I(t.messageRegistry.PLUGIN_REPORTS_AN_ERROR,{pluginId:n}),s=new b(i,a,o,r);return s.setValidationPath(e.path),s}function A(e){if(!e)return null;if(e=e.trim(),0==e.length)return null;if("#"==e.charAt(0)&&(e=e.substring(1)),"/"==e.charAt(0)&&(e=e.substring(1)),0==e.length)return null;for(var t=e.split("/"),n={name:t[0]},r=n,i=1;i<t.length;i++){var a={name:t[i]};r.child=a,r=a}return n}function E(e){return!e||e.isSubTypeOf(t.UNKNOWN)&&!e.oneMeta(L.SkipValidation)}var _=this&&this.__extends||function(){var e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();Object.defineProperty(t,"__esModule",{value:!0});var T=n(59),N=n(60),S=n(71);t.messageRegistry=n(72);var b=function(){function e(e,t,n,r,i){void 0===i&&(i=!1),this.takeNodeFromSource=i,this.subStatus=[],this.severity=e,this.code=t,this.message=n,this.source=r}return e.prototype.getValidationPath=function(){return this.vp},e.prototype.getValidationPathAsString=function(){if(!this.vp)return"";for(var e="",t=this.vp;t;)e+=t.name,t.child&&(e+="/"),t=t.child;return e},e.prototype.setValidationPath=function(e){this.vp=e},e.prototype.addSubStatus=function(t,n){if(void 0===n&&(n=null),t){n&&d(t,{name:n}),this.subStatus.push(t);var r=e.OK;t.isOk()||(t.isError()?r=e.ERROR:t.isWarning()?r=e.WARNING:t.isInfo()&&(r=e.INFO)),this.severity<r&&(this.severity=r,this.message=t.getMessage())}},e.prototype.getErrors=function(){if(this.isError()||this.isWarning()){if(this.subStatus.length>0){var e=[];return this.subStatus.forEach(function(t){return e=e.concat(t.getErrors())}),e}return[this]}return[]},e.prototype.getSubStatuses=function(){return this.subStatus},e.prototype.getSeverity=function(){return this.severity},e.prototype.getMessage=function(){return this.message},e.prototype.setMessage=function(e){this.message=e},e.prototype.getSource=function(){return this.source},e.prototype.getCode=function(){return this.code},e.prototype.setCode=function(e){this.code=e},e.prototype.isWarning=function(){return this.severity==e.WARNING},e.prototype.isError=function(){return this.severity==e.ERROR},e.prototype.isOk=function(){return this.severity===e.OK},e.prototype.isInfo=function(){return this.severity===e.INFO},e.prototype.setSource=function(e){this.source=e},e.prototype.toString=function(){return this.isOk()?"OK":this.message},e.prototype.getExtra=function(e){return this.takeNodeFromSource&&e==S.SOURCE_EXTRA&&this.source instanceof R?this.source.node():null},e.prototype.putExtra=function(e,t){},e.prototype.setInternalRange=function(e){this.internalRange=e},e.prototype.getInternalRange=function(){return this.internalRange},e.prototype.getInternalPath=function(){return this.internalPath},e.prototype.setInternalPath=function(e){this.internalPath=e},e.prototype.getFilePath=function(){return this.filePath},e.prototype.setFilePath=function(e){this.filePath=e},e.CODE_CONFLICTING_TYPE_KIND=4,e.CODE_INCORRECT_DISCRIMINATOR=t.messageRegistry.INCORRECT_DISCRIMINATOR,e.CODE_MISSING_DISCRIMINATOR=t.messageRegistry.MISSING_DISCRIMINATOR,e.ERROR=3,e.INFO=1,e.OK=0,e.WARNING=2,e}();t.Status=b,t.ok=r,t.SCHEMA_AND_TYPE=S.SCHEMA_AND_TYPE_EXTRA,t.GLOBAL=S.GLOBAL_EXTRA,t.TOPLEVEL=S.TOP_LEVEL_EXTRA,t.SOURCE_EXTRA=S.SOURCE_EXTRA;var I=function(e,n){for(var r="",i=e.message,a=0,o=i.indexOf("{{");o>=0;o=i.indexOf("{{",a)){if(r+=i.substring(a,o),a=i.indexOf("}}",o),0>a){a=o;break}o+="{{".length;var s=i.substring(o,a);a+="}}".length;var u=n[s];if(void 0===u)throw new Error(I(t.messageRegistry.MESSAGE_PARAMETER_NO_VALUE,{paramName:s}));r+=u}return r+=i.substring(a,i.length)};t.error=i;var R=function(){function e(e){this._inheritable=e,this._annotations=[]}return e.prototype.getClassIdentifier=function(){var t=[];return t.concat(e.CLASS_IDENTIFIER_TypeInformation)},e.isInstance=function(t){return null!=t&&t.getClassIdentifier&&"function"==typeof t.getClassIdentifier&&T.contains(t.getClassIdentifier(),e.CLASS_IDENTIFIER_TypeInformation)},e.prototype.node=function(){return this._node},e.prototype.setNode=function(e){this._node=e},e.prototype.owner=function(){return this._owner},e.prototype.isInheritable=function(){return this._inheritable},e.prototype.validateSelf=function(e){var t=r();if(this.node()&&this.node().getMeta("skipValidation"))return t;for(var n=0,i=this._annotations;n<i.length;n++){var a=i[n],o=a.validateSelf(e);o.isOk()||t.addSubStatus(o)}for(var s=new Ae(this,e),u=y(s),l=0,p=u;l<p.length;l++){var c=p[l];c.isOk()||t.addSubStatus(c)}return d(t,{name:this.facetName()}),this.validateSelfIndividual(t,e)},e.prototype.validateSelfIndividual=function(e,t){return e},e.prototype.requiredTypes=function(){return[]},e.prototype.annotations=function(){return this._annotations},e.prototype.addAnnotation=function(e){this._annotations.push(e)},e.prototype.isConstraint=function(){return!1},e.CLASS_IDENTIFIER_TypeInformation="typesystem.TypeInformation",e}();t.TypeInformation=R;var M=null,w=function(e){function t(t){return void 0===t&&(t=!0),e.call(this,t)||this}return _(t,e),t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_Constraint)},t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&T.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_Constraint)},t.prototype.intersect=function(e,n){var r=e.id()+""+n.id();if(t.intersections.hasOwnProperty(r))return t.intersections[r];var i=s(r,[e,n]);return t.intersections[r]=i,i},t.prototype.release=function(e){delete t.intersections[e.name()]},t.prototype.nothing=function(e,t){return void 0===t&&(t="Conflicting restrictions"),new se(M,t,e)},t.prototype.composeWith=function(e){return null},t.prototype.preoptimize=function(){null===M&&(M=new oe(null,null,"top")),M=M.push(this);try{return this.innerOptimize()}finally{M=M.pop()}},t.prototype.innerOptimize=function(){return this},t.prototype.tryCompose=function(e){null===M&&(M=new oe(null,null,"top")),M=M.push(this);try{return this.composeWith(e)}finally{M=M.pop()}},t.prototype.kind=function(){return S.MetaInformationKind.Constraint},t.prototype.conflictMessage=function(e,t){return null},t.prototype.isConstraint=function(){return!0},t.CLASS_IDENTIFIER_Constraint="typesystem.TypeInformation",t.intersections={},t}(R);t.Constraint=w;var C=n(73),L=n(75),P=n(133),O=n(73),D=n(75),U=n(75),x=n(73),k=n(73),F=n(134),B=n(75),V=n(73);t.autoCloseFlag=!1;var K=function(){function e(e,t,n){void 0===e&&(e=null),void 0===n&&(n=!1),this._parent=e,this._c=t,this.isAnnotationsReg=n,this._types={},this.typeList=[],this.chainedTypes={}}return e.prototype.getClassIdentifier=function(){var t=[];return t.concat(e.CLASS_IDENTIFIER_TypeRegistry)},e.isInstance=function(t){return null!=t&&t.getClassIdentifier&&"function"==typeof t.getClassIdentifier&&T.contains(t.getClassIdentifier(),e.CLASS_IDENTIFIER_TypeRegistry)},e.prototype.put=function(e,t){this._types[e]=t},e.prototype.addType=function(e){e.isAnonymous()||(this._types[e.name()]=e,this.typeList.push(e))},e.prototype.get=function(e){return this._types.hasOwnProperty(e)?this._types[e]:null!=this._parent?this._parent.get(e):null},e.prototype.getByChain=function(e){var t=this.get(e);return t||(t=this.chainedTypes[e]),t?t:(t=this.getTypeByChainFromCollection(e,this._c),t&&(this.chainedTypes[e]=t),t)},e.prototype.getTypeByChainFromCollection=function(e,t){var n=this.isAnnotationsReg?t.getAnnotationType(e):t.getType(e);if(n)return n;for(var r=e.indexOf(".");r>=0;r=e.indexOf(".",r+1)){var i=e.substring(0,r),a=e.substr(r+1),o=t.library(i);if(o&&(n=this.getTypeByChainFromCollection(a,o)))return n}return null},e.prototype.types=function(){return this.typeList},e.prototype.typeMap=function(){return this._types},e.prototype.parent=function(){return this._parent},e.CLASS_IDENTIFIER_TypeRegistry="typesystem.TypeRegistry",e}();t.TypeRegistry=K;var j=function(){function e(){}return e.prototype.getInfos=function(e){if(e.getExtra("PInfos"))return e.getExtra("PInfos");var t={};return e.meta().forEach(function(e){if(e instanceof C.HasProperty){var n=e.value();t[n]={name:n,type:null}}}),e.meta().forEach(function(e){if(e instanceof C.PropertyIs){var n=e.propertyName();t[n]&&(t[n].type=e.value())}}),e.putExtra("PInfos",t),t},e.prototype.validate=function(e,t){var n=this,r=this.getInfos(e),i=!1;return Object.keys(r).forEach(function(e){i=i||n.validateInfo(r[e],t)}),i},e.prototype.validateInfo=function(e,t){var n=this;if(t.some(function(t){return t==e}))return!0;if(e.type instanceof ne){var r=e.type,i=!0;return r.options().forEach(function(r){n.validate(r,[e].concat(t))||(i=!1)}),i}return e.type.isArray()?void 0:this.validate(e.type,[e].concat(t))},e.prototype.validateType=function(e){var t=this,n=this.getInfos(e),r=[];return Object.keys(n).forEach(function(e){t.validateInfo(n[e],[])&&r.push(e)}),r},e}(),W=function(e){function n(n,r,i){var a=e.call(this,b.ERROR,t.messageRegistry.RESTRICTIONS_CONFLICT.code,null,i)||this;return a._conflicting=n,a._stack=r,a.source=i,a.computeMessage(),a}return _(n,e),n.prototype.computeMessage=function(){var e=null;if(null!=this._stack&&this._stack.getRestriction()instanceof C.MinMaxRestriction){var t=this._stack.getRestriction();e=this._conflicting.conflictMessage(t.facetPath(),t.value())}null==e&&(e=this._conflicting+" and "+(null!=this._stack?this._stack.getRestriction().toString():""));var n="";if(this.source instanceof q){for(var r=[],i=this._stack;i;){var a=i.getRestriction();if(a instanceof x.PropertyIs){var o={name:a.propId()};r.length>0&&(o.child=r[r.length-1]),r.push(o)}i=i.pop()}d(this,r.pop());var s=C.anotherRestrictionComponent();n=s?" between types '"+f(this.source)+"' and '"+f(s)+"'":" in type '"+f(this.source)+"'"}this.message="Restrictions conflict"+n+": "+e},n.prototype.getConflictDescription=function(){var e="";return e+="Restrictions coflict:\n",e+=this._stack.getRestriction()+" conflicts with "+this._conflicting+"\n",e+="at\n",e+=this._stack.pop()},n.prototype.getConflicting=function(){return this._conflicting},n.prototype.getStack=function(){return this._stack},n.prototype.toRestriction=function(){return new se(this._stack,this.message,this._conflicting)},n}(b);t.RestrictionsConflict=W;var H=0;t.VALIDATED_TYPE=null;var Y=function(){function e(e){if(C.MatchesProperty.isInstance(e)){this._matches=e;var t=this._matches.facetName();"propertyIs"==t?this.isProp=!0:"mapPropertyIs"==t&&(this.isMap=!0)}else this.isFacet=!0,this._facetDecl=e}return e.prototype.name=function(){return this.isFacet?this._facetDecl.actualName():this._matches.propId()},e.prototype.isPattern=function(){return this.isMap},e.prototype.isAdditional=function(){return!this.isFacet&&!(this.isProp||this.isMap)},e.prototype.declaredAt=function(){return this.isFacet?this._facetDecl.owner():this._matches.owner()},e.prototype.range=function(){return this.isFacet?this._facetDecl.type():this._matches.range()},e.prototype.required=function(){return!!this.isProp&&!this.property().isOptional()},e.prototype.property=function(){return this.isProp?this._matches:null},e.prototype.mapProperty=function(){return this.isMap?this._matches:null},e}();t.PropertyInfo=Y;var q=function(){function e(e){this._name=e,this.metaInfo=[],this._subTypes=[],this.innerid=H++,this.extras={},this._locked=!1}return e.prototype.getClassIdentifier=function(){var t=[];return t.concat(e.CLASS_IDENTIFIER_AbstractType)},e.isInstance=function(t){return null!=t&&t.getClassIdentifier&&"function"==typeof t.getClassIdentifier&&T.contains(t.getClassIdentifier(),e.CLASS_IDENTIFIER_AbstractType)},e.prototype.annotation=function(e){for(var t=0,n=this.annotations();t<n.length;t++){var r=n[t];if(r.name()==e)return r.value()}return null},e.prototype.isAssignableFrom=function(e){if(-1!=e.allSuperTypes().indexOf(this))return!0;var t=this.restrictions().filter(function(e){return!L.DiscriminatorValue.isInstance(e)}),n=e.restrictions(),r=!0;return t.forEach(function(e){var t=!1;n.forEach(function(n){var r=e.composeWith(n);r==n&&(t=!0),ue.isInstance(n)&&null!=r&&r==e&&(t=!0)}),r=r&&t}),r},e.prototype.registry=function(){return this._collection},e.prototype.cloneWithFilter=function(e,t){var n=this.clone(),r=[];return this.metaInfo.forEach(function(t){var i=e(t,n);"boolean"==typeof i?i&&r.push(t):i&&r.push(i)}),n.metaInfo=r,n},e.prototype.options=function(){if(this.isUnion()){var e=[];return this.allSuperTypes().forEach(function(t){if(ne.isInstance(t)){var n=t.options();e=e.concat(n)}}),T.unique(e)}return[this]},e.prototype.allOptions=function(){if(this.isUnion()){var e=[];return this.allSuperTypes().forEach(function(t){if(ne.isInstance(t)){var n=t.allOptions();e=e.concat(n)}}),T.unique(e)}return[this]},e.prototype.examples=function(){return F.exampleFromInheritedType2(this)},e.prototype.getExtra=function(e){return this.extras[e]},e.prototype.putExtra=function(e,t){this.extras[e]=t},e.prototype.id=function(){return this.innerid},e.prototype.knownProperties=function(){return this.metaOfType(V.MatchesProperty)},e.prototype.lock=function(){this._locked=!0},e.prototype.isLocked=function(){return this._locked},e.prototype.patchName=function(e){this._name=e},e.prototype.allFacets=function(){return this.meta()},e.prototype.declaredFacets=function(){return this.declaredMeta()},e.prototype.isSubTypeOf=function(e){return e===t.ANY||this===e||this.superTypes().some(function(t){return t.isSubTypeOf(e)})},e.prototype.isSuperTypeOf=function(e){return this===e||-1!=this.allSubTypes().indexOf(e)},e.prototype.addMeta=function(e){this.metaInfo.push(e),e._owner=this,this.propertyInfos=null,this.propertiesMap=null,this.definedFacetInfos=null,this.definedFacetInfosMap=null},e.prototype.name=function(){return this._name},e.prototype.label=function(){return this._name},e.prototype.subTypes=function(){return this._subTypes},e.prototype.superTypes=function(){return[]},e.prototype.addSupertypeAnnotation=function(e,t){if(e&&0!=e.length){this.supertypeAnnotations||(this.supertypeAnnotations=[]);var n=this.supertypeAnnotations[t];n||(n={},this.supertypeAnnotations[t]=n);for(var r=0,i=e;r<i.length;r++){var a=i[r];n[a.facetName()]=a}}},e.prototype.validateType=function(e){var n=this;void 0===e&&(e=a());var r=new b(b.OK,"","",this);if(this.validateHierarchy(r),this.getExtra(S.PARSE_ERROR)&&r.addSubStatus(this.getExtra(S.PARSE_ERROR)),r.isOk()){if(r.addSubStatus(this.checkConfluent()),this.isExternal()&&"external"==this.kind()){var o=this;if(o.isJSON())try{var s=N.getJSONSchema(o.schema(),o.getContentProvider&&o.getContentProvider());s&&s.validateSelf()}catch(e){if("Maximum call stack size exceeded"==e.message)return i(t.messageRegistry.CIRCULAR_REFS_IN_JSON_SCHEMA,this);if(ge.isInstance(e)){var u=e,l=i(u.messageEntry,this,u.parameters,u.isWarning?b.WARNING:b.ERROR);l.setInternalRange(u.internalRange),l.setInternalPath(A(u.internalPath)),l.setFilePath(u.filePath),r.addSubStatus(l)}else r.addSubStatus(i(t.messageRegistry.JSON_SCHEMA_VALIDATION_EXCEPTION,this,{msg:e.message}))}}r.isOk()&&this.superTypes().forEach(function(t){if(t.isAnonymous()){var n=t.validateType(e);n.isOk()||(d(n,{name:"type"}),r.addSubStatus(n))}})}if(this.getExtra(t.SCHEMA_AND_TYPE)&&r.addSubStatus(i(t.messageRegistry.SCHEMA_AND_TYPE,this)),r.isOk()&&this.validateMeta(e).getErrors().forEach(function(e){return r.addSubStatus(e)}),this.isObject()){var p={};this.restrictions().forEach(function(e){e.owner()!=n&&e instanceof C.HasProperty&&(p[e.value()]=!0)}),this.declaredMeta().forEach(function(e){e instanceof C.HasProperty&&delete p[e.value()]}),this.declaredMeta().forEach(function(e){if(e instanceof C.PropertyIs){var a=e;p.hasOwnProperty(a.propertyName())&&r.addSubStatus(i(t.messageRegistry.REQUIRED_OVERRIDE_OPTIONAL,n,{propertyName:a.propertyName()}))}});var c=(new j).validateType(this);c.length>0&&c.forEach(function(e){var a=i(t.messageRegistry.CYCLIC_DEPENDENCY,n,{typeName:e});d(a,{name:e}),r.addSubStatus(a)})}if(this.supertypeAnnotations)for(var f=0;f<this.supertypeAnnotations.length;f++)for(var h=this.supertypeAnnotations[f],m=0,g=Object.keys(h);m<g.length;m++){var E=g[m],_=h[E],T=_.validateSelf(e);T.isOk()||(d(T,{name:"type",child:{name:f}}),r.addSubStatus(T))}for(var I=v(this,e),R=0,M=I;R<M.length;R++){var w=M[R];r.addSubStatus(w)}for(var L=new _e(this,e),P=y(L),O=0,D=P;O<D.length;O++){var w=D[O];r.addSubStatus(w)}return r},e.prototype.validateHierarchy=function(e){var n=this;if(this.isAnonymous()||this.getExtra(S.TOP_LEVEL_EXTRA)&&a().get(this.name())&&e.addSubStatus(i(t.messageRegistry.REDEFINIG_BUILDTIN,this,{typeName:this.name()})),this.isSubTypeOf(t.RECURRENT)&&e.addSubStatus(i(t.messageRegistry.RECURRENT_DEFINITION,this),"type"),E(this)){var r=this.metaOfType(L.ImportedByChain);if(r.length>0){var o=[];r.forEach(function(e){o.push(i(t.messageRegistry.INHERITING_TYPE_IMPORTED_THROUGH_LIBRARY_CHAIN,n,{typeName:e.value()}))}),o.forEach(function(t){return e.addSubStatus(t,"type")})}else e.addSubStatus(i(t.messageRegistry.INHERITING_UNKNOWN_TYPE,this),"type")}if(this.isUnion()){for(var s=this.typeFamily(),u=[],l=!1,p=!1,c=0,f=s;c<f.length;c++){var h=f[c];h.isSubTypeOf(t.RECURRENT)?l=!0:h.isSubTypeOf(t.UNKNOWN)&&(p=!0),h.metaOfType(L.ImportedByChain).forEach(function(e){return u.push(e)})}l&&e.addSubStatus(i(t.messageRegistry.RECURRENT_UNION_OPTION,this),"type"),p&&(u.length>0?(u=T.unique(u),u.length>0&&u.forEach(function(r){var a=r.value(),o=t.messageRegistry.UNION_OPTION_TYPE_DEPENDS_ON_TYPE_IMPORTED_THROUGH_LIBRARY_CHAIN;n.options().some(function(e){return e.name()==a})&&(o=t.messageRegistry.UNION_OPTION_TYPE_OPTION_IMPORTED_THROUGH_LIBRARY_CHAIN),e.addSubStatus(i(o,n,{typeName:a}),"type")})):e.addSubStatus(i(t.messageRegistry.UNKNOWN_UNION_OPTION,this),"type"))}if(this.isArray()){for(var m=this.familyWithArray(),y=this.getExtra(S.HAS_ITEMS)?"items":"type",v=[],l=!1,g=!1,A=0,_=m;A<_.length;A++){var h=_[A];h==this||h===t.RECURRENT?l=!0:h==t.UNKNOWN&&(g=!0),h.metaOfType(L.ImportedByChain).forEach(function(e){return v.push(e)})}if(l)e.addSubStatus(i(t.messageRegistry.RECURRENT_ARRAY_DEFINITION,this),y);else if(g){var N=this.oneMeta(k.ComponentShouldBeOfType).value().name();v.length>0?(v=T.unique(v),v.forEach(function(r){var a=N,o=t.messageRegistry.ARRAY_COMPONENT_TYPE_IMPORTED_THROUGH_LIBRARY_CHAIN;a?r.value()!=a&&(o=t.messageRegistry.ARRAY_COMPONENT_TYPE_DEPENDES_ON_TYPE_IMPORTED_THROUGH_LIBRARY_CHAIN,a=r.value()):N=r.value(),e.addSubStatus(i(o,n,{componentTypeName:N,typeName:a}),y)})):e.addSubStatus(i(t.messageRegistry.UNKNOWN_ARRAY_COMPONENT_TYPE,this,{componentTypeName:N}),y)}}var b=this.superTypes(),I=!1,R=!1;if(b.length>1&&b.forEach(function(e){e.isExternal()?I=!0:R=!0}),I&&R&&e.addSubStatus(i(t.messageRegistry.EXTERNALS_MIX,this)),this instanceof ne){var M=this;M.options().forEach(function(r){r.isExternal()&&e.addSubStatus(i(t.messageRegistry.EXTERNALS_MIX,n))})}if(this.isExternal()&&this.getExtra(S.HAS_FACETS)){var w=i(t.messageRegistry.EXTERNAL_FACET,this,{name:this.getExtra(S.HAS_FACETS)});d(w,{name:this.getExtra(S.HAS_FACETS)}),e.addSubStatus(w)}},e.prototype.familyWithArray=function(){if(this.oneMeta(L.SkipValidation))return[];var e=[];this.fillSuperTypes(e,!0);var t=this.oneMeta(k.ComponentShouldBeOfType);if(t){var n=t.value();n.oneMeta(L.SkipValidation)||(e=e.concat(n.familyWithArray().concat(n)))}return e},e.prototype.validateMeta=function(e){var t=new b(b.OK,"","",this);return this.declaredMeta().forEach(function(n){n.validateSelf(e).getErrors().forEach(function(e){return t.addSubStatus(e)})}),this.validateFacets(t),t},e.prototype.validateFacets=function(e){var n=this,r={},a={},o={};this.meta().forEach(function(e){if(e instanceof D.FacetDeclaration){var t=e;r[t.actualName()]=t,t.isOptional()||t.owner()!==n&&(o[t.actualName()]=t),t.owner()!=n&&(a[t.actualName()]=t)}}),this.declaredMeta().forEach(function(r){if(r instanceof D.FacetDeclaration){var o=r;if(o.owner()==n){var s=o.actualName();a.hasOwnProperty(s)&&e.addSubStatus(i(t.messageRegistry.OVERRIDE_FACET,n,{name:s}));var u=P.getInstance().facetPrototypeWithName(s);(u&&u.isApplicable(n)||"type"==s||"properties"==o.facetName()||"schema"==s||"facets"==s||"uses"==s)&&e.addSubStatus(i(t.messageRegistry.OVERRIDE_BUILTIN_FACET,n,{name:s})),"("==s.charAt(0)&&e.addSubStatus(i(t.messageRegistry.FACET_START_BRACKET,n,{name:s}))}}});var s={};this.meta().forEach(function(e){e instanceof x.PropertyIs&&(s[e.propId()]=!0)});for(var u=0,l=this.meta();u<l.length;u++){var p=l[u];if(p instanceof U.CustomFacet){var c=p;if(c.node()&&c.node().getMeta("skipValidation"))continue;var f=c.facetName();if(r.hasOwnProperty(f)){var h=r[f],m=h.value();if(h.owner()==this&&c.owner()==this){var y=i(t.messageRegistry.FACET_CAN_NOT_BE_FIXED_BY_THE_DECLARING_TYPE,c);y.setValidationPath({name:f}),e.addSubStatus(y)}else{for(var v=m.validateDirect(c.value(),!1,!1),g=0,A=v.getErrors();g<A.length;g++){var E=A[g];d(E,{name:f}),e.addSubStatus(E)}delete o[f]}}else this.isExternal()?e.addSubStatus(i(t.messageRegistry.FACET_PROHIBITED_FOR_EXTERNALS,c,{facetName:f},b.ERROR,!0)):e.addSubStatus(i(t.messageRegistry.UNKNOWN_FACET,c,{facetName:f},b.ERROR,!0))}}Object.getOwnPropertyNames(o).length>0&&e.addSubStatus(i(t.messageRegistry.MISSING_REQUIRED_FACETS,this,{facetsList:Object.keys(o).map(function(e){return"'"+e+"'"}).join(",")}))},e.prototype.allSuperTypes=function(){var e=[];return this.fillSuperTypes(e),e},e.prototype.fillSuperTypes=function(e,t){void 0===t&&(t=!1);for(var n=0,r=this.superTypes();n<r.length;n++){var i=r[n];t&&i.oneMeta(L.SkipValidation)||T.contains(e,i)||(e.push(i),i.fillSuperTypes(e))}},e.prototype.allSubTypes=function(){var e=[];return this.fillSubTypes(e),e},e.prototype.fillSubTypes=function(e){this.subTypes().forEach(function(t){T.contains(e,t)||(e.push(t),t.fillSubTypes(e))})},e.prototype.inherit=function(e){var t=new ee(e);return t.addSuper(this),t},e.prototype.isAnonymous=function(){return!this._name||0===this._name.length},e.prototype.isEmpty=function(){return!(this.metaInfo.length>2)&&0==this.metaInfo.filter(function(e){return!(e instanceof B.NotScalar)&&(!(e instanceof L.DiscriminatorValue)||e.isStrict())}).length},e.prototype.isArray=function(){return this===t.ARRAY||-1!=this.allSuperTypes().indexOf(t.ARRAY)},e.prototype.propertySet=function(){var e=[];return this.meta().forEach(function(t){if(t instanceof x.PropertyIs){var n=t;e.push(n.propertyName())}}),T.uniq(e)},e.prototype.checkConfluent=function(){if(this.oneMeta(L.SkipValidation))return r();if(this.computeConfluent)return r();this.computeConfluent=!0;var e=C.anotherRestrictionComponentsCount();try{var t=C.optimize(this.restrictions()),n=T.find(t,function(e){return e instanceof ae});if(n){var i=null,a=null;if(n instanceof se){var o=n;i=o.getStack(),a=o.another()}var s=new W(a,i,this);return s}return r()}finally{this.computeConfluent=!1,C.releaseAnotherRestrictionComponent(e)}},e.prototype.isObject=function(){return this==t.OBJECT||T.some(this.allSuperTypes(),function(e){return e.isObject()})},e.prototype.isExternal=function(){return this==t.EXTERNAL||-1!=this.allSuperTypes().indexOf(t.EXTERNAL)},e.prototype.isBoolean=function(){return this==t.BOOLEAN||-1!=this.allSuperTypes().indexOf(t.BOOLEAN)},e.prototype.isString=function(){return this==t.STRING||-1!=this.allSuperTypes().indexOf(t.STRING)},e.prototype.isNumber=function(){return this==t.NUMBER||-1!=this.allSuperTypes().indexOf(t.NUMBER)},e.prototype.isFile=function(){return this==t.FILE||-1!=this.allSuperTypes().indexOf(t.FILE)},e.prototype.isScalar=function(){return this==t.SCALAR||-1!=this.allSuperTypes().indexOf(t.SCALAR)},e.prototype.isDateTime=function(){return this==t.DATETIME||-1!=this.allSuperTypes().indexOf(t.DATETIME)},e.prototype.isDateOnly=function(){return this==t.DATE_ONLY||-1!=this.allSuperTypes().indexOf(t.DATE_ONLY)},e.prototype.isTimeOnly=function(){return this==t.TIME_ONLY||-1!=this.allSuperTypes().indexOf(t.TIME_ONLY)},e.prototype.isInteger=function(){return this==t.INTEGER||-1!=this.allSuperTypes().indexOf(t.INTEGER)},e.prototype.isDateTimeOnly=function(){return this==t.DATETIME_ONLY||-1!=this.allSuperTypes().indexOf(t.DATETIME_ONLY)},e.prototype.isUnknown=function(){return this==t.UNKNOWN||-1!=this.allSuperTypes().indexOf(t.UNKNOWN)},e.prototype.isRecurrent=function(){return this==t.RECURRENT||-1!=this.allSuperTypes().indexOf(t.RECURRENT)},e.prototype.isBuiltin=function(){return-1!=this.metaInfo.indexOf(Q)},e.prototype.exampleObject=function(){return F.example(this)},e.prototype.isPolymorphic=function(){return this.meta().some(function(e){return e instanceof X})},e.prototype.restrictions=function(e){if(void 0===e&&(e=!1),this.isUnion()){var t=[];return this.superTypes().forEach(function(e){t=t.concat(e.restrictions())}),t=t.concat(this.meta().filter(function(e){return e instanceof w}))}var n=[],r=null;return this.meta().forEach(function(t){if(t instanceof w){if(t instanceof ue&&e){if(r)return;r=t}n.push(t)}}),n},e.prototype.customFacets=function(){return this.declaredMeta().filter(function(e){return e instanceof L.CustomFacet})},e.prototype.allCustomFacets=function(){return this.meta().filter(function(e){return e instanceof L.CustomFacet})},e.prototype.isUnion=function(){var e=!1;return!this.isBuiltin()&&(this.allSuperTypes().forEach(function(t){return e=e||t instanceof ne}),e)},e.prototype.isIntersection=function(){var e=!1;return!this.isBuiltin()&&(this.allSuperTypes().forEach(function(t){return e=e||t instanceof re}),e)},e.prototype.meta=function(){return[].concat(this.metaInfo)},e.prototype.validateDirect=function(e,n,r,a){var o=this;void 0===n&&(n=!1),void 0===r&&(r=!0),void 0===a&&(a=null);var s=t.VALIDATED_TYPE;try{var u=t.autoCloseFlag;n&&(t.autoCloseFlag=!0),t.VALIDATED_TYPE=this;var l=new b(b.OK,"","",this);if(!(r||null!==e&&void 0!==e||this.nullable)){var p=null;return this.restrictions(!0).forEach(function(e){if(e instanceof le){if(p)return;p=e}}),p?i(t.messageRegistry.TYPE_EXPECTED,p,{expectedType:p.value(),actualType:"null"}):i(t.messageRegistry.OBJECT_EXPECTED,this)}if(this.restrictions(!0).forEach(function(t){return l.addSubStatus(t.check(e,a))}),(n||t.autoCloseFlag)&&this.isObject()&&!this.oneMeta(O.KnownPropertyRestriction)){var c=new O.KnownPropertyRestriction(!1);c.patchOwner(this),c.check(e).getErrors().forEach(function(e){var t=new b(b.WARNING,e.getCode(),e.getMessage(),o);d(t,e.getValidationPath()),l.addSubStatus(t)})}}finally{t.autoCloseFlag=u,t.VALIDATED_TYPE=s}return l},e.prototype.validate=function(e,n,a){void 0===n&&(n=!1),void 0===a&&(a=!0);var o=t.autoCloseFlag;if(!(a||null!==e&&void 0!==e||this.nullable))return i(t.messageRegistry.NULL_NOT_ALLOWED,this);n&&(t.autoCloseFlag=!0);try{for(var s,u=[],l=this.subTypes().concat(this),p=0,c=l;p<c.length;p++){var f=c[p],d=h(e,f),m=f.validateDirect(e,n||o);if(d){if(d.isOk())return m;u.push(d)}else if(m.isOk())return m;s=m}if(0==u.length)return s;var y=r();return u.forEach(function(e){return y.addSubStatus(e)}),u.pop()}finally{t.autoCloseFlag=o}},e.prototype.declareMapProperty=function(e,t){return null!=t&&this.addMeta(new C.MapPropertyIs(e,t)),t},e.prototype.closeUnknownProperties=function(){this.addMeta(new O.KnownPropertyRestriction(!1))},e.prototype.annotations=function(){return this.metaOfType(L.Annotation)},e.prototype.declaredAnnotations=function(){return this.declaredMeta().filter(function(e){return L.Annotation.isInstance(e)})},e.prototype.componentType=function(){var e=this.metaOfType(k.ComponentShouldBeOfType);if(0==e.length)return null;if(1==e.length)return e[0].value();var t=u(null,e.map(function(e){return e.value()}));return t},e.prototype.canDoAc=function(){for(var e=T.uniq(this.typeFamily()),t=new b(b.OK,"","",this),n=0;n<e.length;n++)for(var r=0;r<e.length;r++)if(n!=r){var i=e[n],a=e[r],o=this.emptyIntersectionOrDiscriminator(i,a);t.addSubStatus(o)}return t},e.prototype.emptyIntersectionOrDiscriminator=function(e,t){if(t===e)return r();if(t.isScalar()&&e.isScalar())return r();var n=s("",[e,t]),i=n.checkConfluent();return i.isOk()?this.checkDiscriminator(e,t):r()},e.prototype.properties=function(){if(null==this.propertyInfos){this.propertiesMap={},this.propertyInfos=[];for(var e=this.meta(),t=0,n=e;t<n.length;t++){var r=n[t];if(C.MatchesProperty.isInstance(r)){var i=new Y(r),a=i.name();this.propertiesMap[a]||(this.propertiesMap[a]=i),this.propertyInfos.push(i)}}}return this.propertyInfos},e.prototype.declaredProperties=function(){var e=this;return this.properties().filter(function(t){return t.declaredAt()==e})},e.prototype.allDefinedFacets=function(){if(null==this.definedFacetInfos){this.definedFacetInfosMap={},this.definedFacetInfos=[];for(var e=this.meta(),t=e.length-1;t>=0;t--)if(L.FacetDeclaration.isInstance(e[t])){var n=new Y(e[t]);this.definedFacetInfosMap[n.name()]=n,this.definedFacetInfos.push(n)}}return this.definedFacetInfos},e.prototype.definedFacets=function(){var e=this;return this.allDefinedFacets().filter(function(t){return t.declaredAt()==e})},e.prototype.property=function(e){return this.propertyInfos||this.properties(),this.propertiesMap[e]},e.prototype.checkDiscriminator=function(e,n){var a=i(t.messageRegistry.DISCRIMINATOR_NEEDED,this,{name1:e.name(),name2:n.name()}),o=e.oneMeta(L.Discriminator),s=n.oneMeta(L.Discriminator);if(null!=o&&null!=s&&o.value()===s.value()){var u=e.name(),l=n.name(),p=e.oneMeta(L.DiscriminatorValue);null!=p&&(u=p.value());var c=n.oneMeta(L.DiscriminatorValue);if(null!=c&&(l=c.value()),u!==l)return r();a=i(t.messageRegistry.SAME_DISCRIMINATOR_VALUE,this,{name1:e.name(),
name2:n.name()})}return a},e.prototype.ac=function(e){if(!this.isPolymorphic()&&!this.isUnion())return this;if(this.isBuiltin())return this;var n=T.uniq(this.typeFamily());if(0==n.length)return t.NOTHING;if(this.isScalar())return this.isNumber()?"number"==typeof e?this:t.NOTHING:this.isString()?"string"==typeof e?this:t.NOTHING:this.isBoolean()?"boolean"==typeof e?this:t.NOTHING:this;if(1===n.length)return n[0];var r=[];n.forEach(function(t){var n=t.validateDirect(e,!0);n.isOk()&&r.push(t)});var i=this.discriminate(e,r);return i?i:t.NOTHING},e.prototype.declareProperty=function(e,t,n){return n||this.addMeta(new C.HasProperty(e)),null!=t&&this.addMeta(new C.PropertyIs(e,t)),this},e.prototype.discriminate=function(e,t){for(var n=[].concat(t),r=[].concat(t);n.length>1;){var i=!1;e:for(var a=0;a<r.length;a++)for(var o=0;o<r.length;o++){var s=r[a],u=r[o];if(s!=u){var l=p(e,s,u);if(l===s){r=r.filter(function(e){return e!=u}),i=!0;break e}if(l===u){r=r.filter(function(e){return e!=s}),i=!0;break e}r=r.filter(function(e){return e!=s&&e!=u}),i=!0;break e}}n=r}return 1==n.length?n[0]:null},e.prototype.oneMeta=function(e){return T.find(this.meta(),function(t){return t instanceof e})},e.prototype.metaOfType=function(e){return this.meta().filter(function(t){return t instanceof e})},e.prototype.declaredMeta=function(){return this.metaInfo},e.prototype.descValue=function(){var e=this.oneMeta(L.DiscriminatorValue);return e?e.value():this.name()},e.prototype.isAbstractOrInternal=function(){return this.metaInfo.some(function(e){return e instanceof z||e instanceof $})},e.prototype.typeFamily=function(){if(this.isUnion()){var e=[];return this.allSuperTypes().forEach(function(t){if(t instanceof ne)for(var n=t.allOptions(),r=0;r<n.length;r++)e=e.concat(n[r].typeFamily())}),T.unique(e)}var t=[];return this.isAbstractOrInternal()||t.push(this),this.allSubTypes().forEach(function(e){e.isAbstractOrInternal()||t.push(e)}),T.unique(t)},e.prototype.hasPropertiesFacet=function(){return this.metaInfo.some(function(e){return e instanceof L.HasPropertiesFacet})},e.CLASS_IDENTIFIER_AbstractType="typesystem.AbstractType",e}();t.AbstractType=q;var G=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return _(n,e),n.prototype.requiredType=function(){return t.ANY},n.prototype.kind=function(){return S.MetaInformationKind.Modifier},n}(R);t.Modifier=G;var X=function(e){function t(){return e.call(this,!0)||this}return _(t,e),t.prototype.facetName=function(){return"polymorphic"},t.prototype.value=function(){return!0},t}(G);t.Polymorphic=X;var z=function(e){function t(){return e.call(this,!1)||this}return _(t,e),t.prototype.value=function(){return!0},t.prototype.facetName=function(){return"abstract"},t}(G);t.Abstract=z;var $=function(e){function t(){return e.call(this,!1)||this}return _(t,e),t.prototype.facetName=function(){return"abstract"},t.prototype.value=function(){return!0},t}(G);t.Internal=$;var J=function(e){function t(){return e.call(this,!1)||this}return _(t,e),t.prototype.facetName=function(){return"builtIn"},t.prototype.value=function(){return!0},t}(G),Q=new J,Z=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return _(t,e),t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_RootType)},t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&T.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_RootType)},t.prototype.kind=function(){return"root"},t.prototype.clone=function(){return this},t.CLASS_IDENTIFIER_RootType="typesystem.RootType",t}(q);t.RootType=Z;var ee=function(e){function n(){var t=null!==e&&e.apply(this,arguments)||this;return t._superTypes=[],t}return _(n,e),n.prototype.getClassIdentifier=function(){var t=e.prototype.getClassIdentifier.call(this);return t.concat(n.CLASS_IDENTIFIER_InheritedType)},n.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&T.contains(e.getClassIdentifier(),n.CLASS_IDENTIFIER_InheritedType)},n.prototype.superTypes=function(){return this._superTypes},n.prototype.clone=function(){if(this.isBuiltin())return this;var e=new n(this._name);return e._superTypes=this._superTypes,e},n.prototype.knownProperties=function(){var e=this.metaOfType(V.MatchesProperty);return this.superTypes().forEach(function(t){e=e.concat(t.knownProperties())}),e},n.prototype.kind=function(){return"inherited"},n.prototype.meta=function(){var t=this,n=e.prototype.meta.call(this),r=!1;return this.superTypes().forEach(function(e){e.meta().forEach(function(e){if(e instanceof O.KnownPropertyRestriction){if(r)return;var i=new O.KnownPropertyRestriction(!1);return i.patchOwner(t),void n.push(i)}e.isInheritable()&&n.push(e)})}),n},n.prototype.addSuper=function(e){this._superTypes.push(e),e.isLocked()||e._subTypes.push(this),e.nullable&&(this.nullable=!0)},n.prototype.label=function(){var t=this.metaOfType(k.ComponentShouldBeOfType);return t.length>0?t[0].value().label()+"[]":e.prototype.label.call(this)},n.prototype.contextMeta=function(){return this._contextMeta},n.prototype.setContextMeta=function(e){this._contextMeta=e},n.prototype.patch=function(e){for(var n in e)e.hasOwnProperty(n)&&(this[n]=e[n]);for(var r=0;r<this._superTypes.length;r++){var i=this._superTypes[r];(i==this||i.allSuperTypes().indexOf(this)>=0)&&(this._superTypes[r]=t.RECURRENT)}},n.CLASS_IDENTIFIER_InheritedType="typesystem.InheritedType",n}(q);t.InheritedType=ee;var te=function(e){function t(t,n){var r=e.call(this,t)||this;return r._options=n,r}return _(t,e),t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_DerivedType)},t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&T.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_DerivedType)},t.prototype.cloneWithFilter=function(e,t){var n=this.clone(),r=[];return t&&(n._options=this.options().map(function(e){return t(e)})),this.metaInfo.forEach(function(t){var i=e(t,n);"boolean"==typeof i?i&&r.push(t):i&&r.push(i)}),n.metaInfo=r,n},t.prototype.allOptions=function(){var e=this,t=[];return this._options.forEach(function(n){n.kind()==e.kind()?t=t.concat(n.allOptions()):t.push(n)}),T.unique(t)},t.prototype.options=function(){return this._options},t.CLASS_IDENTIFIER_DerivedType="typesystem.DerivedType",t}(q);t.DerivedType=te;var ne=function(e){function n(t,n){var r=e.call(this,t,n)||this;return r.options().forEach(function(e){e.nullable&&(r.nullable=!0)}),r}return _(n,e),n.prototype.getClassIdentifier=function(){var t=e.prototype.getClassIdentifier.call(this);return t.concat(n.CLASS_IDENTIFIER_UnionType)},n.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&T.contains(e.getClassIdentifier(),n.CLASS_IDENTIFIER_UnionType)},n.prototype.kind=function(){return"union"},n.prototype.clone=function(){return new n(this.name(),this.options())},n.prototype.isSubTypeOf=function(e){var t=!0;return this.allOptions().forEach(function(n){n.isSubTypeOf(e)||(t=!1)}),t},n.prototype.validate=function(e){return this.validateDirect(e)},n.prototype.typeFamily=function(){var e=[];return this.allOptions().forEach(function(t){e=e.concat(t.typeFamily())}),e},n.prototype.knownProperties=function(){var e=this.metaOfType(V.MatchesProperty);return this.options().forEach(function(t){e=e.concat(t.knownProperties())}),e},n.prototype.validateDirect=function(e,t){void 0===t&&(t=!1);var n=new b(b.OK,"","",this);return this.restrictions().forEach(function(t){return n.addSubStatus(t.check(e,null))}),n},n.prototype.isUnion=function(){return!0},n.prototype.isObject=function(){return T.all(this.allOptions(),function(e){return e.isObject()})},n.prototype.restrictions=function(){return[new he(this.allOptions().map(function(e){return new de(e.restrictions())}),t.messageRegistry.UNION_TYPE_FAILURE,t.messageRegistry.UNION_TYPE_FAILURE_DETAILS)]},n.prototype.label=function(){return this.options().map(function(e){return e.label()}).join("|")},n.CLASS_IDENTIFIER_UnionType="typesystem.UnionType",n}(te);t.UnionType=ne;var re=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return _(t,e),t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_IntersectionType)},t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&T.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_IntersectionType)},t.prototype.kind=function(){return"intersection"},t.prototype.clone=function(){return new t(this.name(),this.options())},t.prototype.restrictions=function(){var e=[];return this.allOptions().forEach(function(t){t.oneMeta(L.SkipValidation)||(e=e.concat(t.restrictions()))}),[new de(e)]},t.prototype.label=function(){return this.options().map(function(e){return e.label()}).join("&")},t.prototype.isIntersection=function(){return!0},t.CLASS_IDENTIFIER_IntersectionType="typesystem.IntersectionType",t}(te);t.IntersectionType=re;var ie=new K;t.builtInRegistry=a,t.union=o,t.intersect=s,t.derive=u,t.deriveObjectType=l;var ae=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return _(n,e),n.prototype.check=function(e){return null===e||void 0===e?r():i(t.messageRegistry.NOTHING,this)},n.prototype.requiredType=function(){return t.ANY},n.prototype.facetName=function(){return"nothing"},n.prototype.value=function(){return"!!!"},n}(w);t.NothingRestriction=ae;var oe=function(){function e(e,t,n){this._previous=e,this._restriction=t,this.id=n}return e.prototype.getRestriction=function(){return this._restriction},e.prototype.pop=function(){return this._previous},e.prototype.push=function(t){return new e(this,t,t.toString())},e}();t.RestrictionStackEntry=oe;var se=function(e){function t(t,n,r){var i=e.call(this)||this;return i._entry=t,i._message=n,i._another=r,i}return _(t,e),t.prototype.getMessage=function(){return this._message},t.prototype.getStack=function(){return this._entry},t.prototype.another=function(){return this._another},t}(ae);t.NothingRestrictionWithLocation=se;var ue=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return _(t,e),t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_GenericTypeOf)},t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&T.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_GenericTypeOf)},t.CLASS_IDENTIFIER_GenericTypeOf="typesystem.GenericTypeOf",t}(w);t.GenericTypeOf=ue;var le=function(e){function n(t){var n=e.call(this)||this;return n.val=t,n}return _(n,e),n.prototype.check=function(e){var n=typeof e;return null===e||void 0===e?r():(Array.isArray(e)&&(n="array"),n===this.val?r():i(t.messageRegistry.TYPE_EXPECTED,this,{expectedType:this.val,actualType:n}))},n.prototype.value=function(){return this.val},n.prototype.requiredType=function(){return t.ANY},n.prototype.facetName=function(){return"typeOf"},n.prototype.composeWith=function(e){if(e instanceof n){var t=e;return t.val==this.val?this:this.nothing(e)}return null},n.prototype.toString=function(){return"should be of type "+this.val},n}(ue);t.TypeOfRestriction=le;var pe=function(e){function n(){return e.call(this)||this}return _(n,e),n.prototype.check=function(e){return"number"==typeof e&&c(e)?r():i(t.messageRegistry.INTEGER_EXPECTED,this)},n.prototype.requiredType=function(){return t.ANY},n.prototype.value=function(){return!0},n.prototype.facetName=function(){return"should be integer"},n}(ue);t.IntegerRestriction=pe;var ce=function(e){function n(){return e.call(this)||this}return _(n,e),n.prototype.check=function(e){return null===e||void 0==e||"null"===e?r():i(t.messageRegistry.NULL_EXPECTED,this)},n.prototype.requiredType=function(){return t.ANY},n.prototype.value=function(){return!0},n.prototype.facetName=function(){return"should be null"},n}(ue);t.NullRestriction=ce;var fe=function(e){function n(){return e.call(this)||this}return _(n,e),n.prototype.check=function(e){return e?"number"==typeof e||"boolean"==typeof e||"string"==typeof e?r():i(t.messageRegistry.SCALAR_EXPECTED,this):r()},n.prototype.requiredType=function(){return t.ANY},n.prototype.facetName=function(){return t.messageRegistry.SHOULD_BE_SCALAR.message},n.prototype.value=function(){return!0},n}(ue);t.ScalarRestriction=fe;var he=function(e){function n(t,n,r){var i=e.call(this)||this;return i.val=t,i._extraMessage=n,i._extraOptionMessage=r,i}return _(n,e),n.prototype.check=function(e,t){for(var n=this,a=new b(b.OK,"","",this),o=[],s=0;s<this.val.length;s++){var u=this.val[s].check(e,t);if(u.isOk())return r();o.push(u)}if(o.length>0){for(var l=0,p=o;l<p.length;l++){var c=p[l],f=null,h=c.getSource();if(h instanceof R){var d=h.owner();d&&(f=d.label())}c.getErrors().forEach(function(e){var t=e.getMessage(),r=e.getCode();if(f&&(t=f+": "+t),n._extraOptionMessage){var o=i(n._extraOptionMessage,n,{msg:t});t=o.getMessage(),r=o.getCode()}e.setMessage(t),e.setCode(r),a.addSubStatus(e)})}if(this._extraMessage){var m=0;o.forEach(function(e){return m=Math.max(m,e.getSeverity())}),a.addSubStatus(new b(m,this._extraMessage.code,this._extraMessage.message,this))}}return a},n.prototype.value=function(){return this.val.map(function(e){return e.value()})},n.prototype.requiredType=function(){return t.ANY},n.prototype.facetName=function(){return"or"},n}(w);t.OrRestriction=he;var de=function(e){function n(t){var n=e.call(this)||this;return n.val=t,n}return _(n,e),n.prototype.value=function(){return this.val.map(function(e){return e.value()})},n.prototype.options=function(){return this.val},n.prototype.check=function(e,t){for(var n=0;n<this.val.length;n++){var i=this.val[n].check(e,t);if(!i.isOk())return i}return r()},n.prototype.requiredType=function(){return t.ANY},n.prototype.facetName=function(){return"and"},n}(w);t.AndRestriction=de,t.ANY=new Z("any"),t.SCALAR=t.ANY.inherit("scalar"),t.OBJECT=t.ANY.inherit("object"),t.ARRAY=t.ANY.inherit("array"),t.EXTERNAL=t.ANY.inherit("external"),t.NUMBER=t.SCALAR.inherit("number"),t.INTEGER=t.NUMBER.inherit("integer"),t.BOOLEAN=t.SCALAR.inherit("boolean"),t.STRING=t.SCALAR.inherit("string"),t.NIL=t.SCALAR.inherit("nil"),t.DATE_ONLY=t.SCALAR.inherit("date-only"),t.TIME_ONLY=t.SCALAR.inherit("time-only"),t.DATETIME_ONLY=t.SCALAR.inherit("datetime-only"),t.DATETIME=t.SCALAR.inherit("datetime"),t.FILE=t.SCALAR.inherit("file"),t.NOTHING=new Z("nothing"),t.UNION=t.ANY.inherit("union"),t.UNKNOWN=t.NOTHING.inherit("unknown"),t.REFERENCE=t.NOTHING.inherit("reference"),t.RECURRENT=t.NOTHING.inherit("recurrent"),t.ANY.addMeta(Q),t.NIL.addMeta(Q),t.UNION.addMeta(Q),t.SCALAR.addMeta(Q),t.OBJECT.addMeta(Q),t.ARRAY.addMeta(Q),t.NUMBER.addMeta(Q),t.INTEGER.addMeta(Q),t.BOOLEAN.addMeta(Q),t.STRING.addMeta(Q),t.EXTERNAL.addMeta(Q),t.UNKNOWN.addMeta(Q),t.RECURRENT.addMeta(Q),t.DATE_ONLY.addMeta(Q),t.TIME_ONLY.addMeta(Q),t.DATETIME_ONLY.addMeta(Q),t.DATETIME.addMeta(Q),t.FILE.addMeta(Q),t.UNKNOWN.addMeta(Q),t.UNKNOWN.lock(),t.RECURRENT.addMeta(Q),t.RECURRENT.lock(),t.EXTERNAL.lock(),t.UNION.lock(),t.REFERENCE.lock(),ie.addType(t.ANY),ie.addType(t.SCALAR),ie.addType(t.OBJECT),ie.addType(t.ARRAY),ie.addType(t.NUMBER),ie.addType(t.INTEGER),ie.addType(t.BOOLEAN),ie.addType(t.NIL),ie.addType(t.STRING),ie.addType(t.DATE_ONLY),ie.addType(t.TIME_ONLY),ie.addType(t.DATETIME_ONLY),ie.addType(t.DATETIME),ie.addType(t.FILE),t.NOTHING.addMeta(new ae),t.NUMBER.addMeta(new le("number")),t.NUMBER.addMeta(new D.FacetDeclaration("format",t.STRING,!0,!0)),t.BOOLEAN.addMeta(new le("boolean")),t.OBJECT.addMeta(new le("object")),t.ARRAY.addMeta(new le("array")),t.STRING.addMeta(new le("string")),t.INTEGER.addMeta(new pe),t.NIL.addMeta(new ce);var me=n(135);t.DATE_ONLY.addMeta(new me.DateOnlyR),t.TIME_ONLY.addMeta(new me.TimeOnlyR),t.DATETIME_ONLY.addMeta(new me.DateTimeOnlyR),t.DATETIME.addMeta(new me.DateTimeR),t.FILE.addMeta(new le("string"));var ye=t.ARRAY.inherit("");ye.addMeta(new k.ComponentShouldBeOfType(t.STRING)),t.FILE.addMeta(new D.FacetDeclaration("fileTypes",ye,!0,!0)),t.FILE.addMeta(new D.FacetDeclaration("minLength",t.INTEGER,!0,!0)),t.FILE.addMeta(new D.FacetDeclaration("maxLength",t.INTEGER,!0,!0)),t.DATETIME.addMeta(new D.FacetDeclaration("format",t.STRING,!0,!0)),t.NIL.nullable=!0,t.SCALAR.addMeta(new fe),ie.types().forEach(function(e){return e.lock()});var ve=function(e){function n(n,r,i,a,o){void 0===o&&(o=null);var s=e.call(this,n)||this;return s._content=r,s.json=i,s.provider=a,s.addMeta(new C.MatchToSchema(r,o?o:a)),s.addSuper(t.EXTERNAL),s}return _(n,e),n.prototype.getClassIdentifier=function(){var t=e.prototype.getClassIdentifier.call(this);return t.concat(n.CLASS_IDENTIFIER_ExternalType)},n.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&T.contains(e.getClassIdentifier(),n.CLASS_IDENTIFIER_ExternalType)},n.prototype.getContentProvider=function(){return this.provider},n.prototype.setContentProvider=function(e){this.provider=e},n.prototype.kind=function(){return"external"},n.prototype.isJSON=function(){return this.json},n.prototype.schema=function(){return this._content},n.CLASS_IDENTIFIER_ExternalType="typesystem.ExternalType",n}(ee);t.ExternalType=ve,t.typePath=f;var ge=function(e){function t(n,r){void 0===r&&(r={});var i=e.call(this)||this;return i.messageEntry=n,i.parameters=r,i.isWarning=!1,i.message=I(n,r),i.getClassIdentifier=t.prototype.getClassIdentifier,i}return _(t,e),t.prototype.getClassIdentifier=function(){var e=[];return e.concat(t.CLASS_IDENTIFIER_ValidationError)},t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&T.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_ValidationError)},t.CLASS_IDENTIFIER_ValidationError="linter.ValidationError",t}(Error);t.ValidationError=ge,t.setValidationPath=d,t.patchPath=m;var Ae=function(){function e(e,t){this._facet=e,this.reg=t}return e.prototype.kind=function(){return"AnnotatedFacet"},e.prototype.annotationsMap=function(){var e=this;return this._annotationsMap||(this._annotationsMap={},this.annotations().forEach(function(t){return e._annotationsMap[t.name()]=t})),this._annotationsMap},e.prototype.annotations=function(){var e=this;return this._annotations||(this._annotations=this._facet.annotations().map(function(t){return new Te(t,e.reg)})),this._annotations},e.prototype.value=function(){return this._facet.value()},e.prototype.name=function(){return this._facet.facetName()},e.prototype.entry=function(){return this._facet},e}();t.AnnotatedFacet=Ae;var Ee=n(169),_e=function(){function e(e,t){this._type=e,this.reg=t}return e.prototype.kind=function(){return"AnnotatedType"},e.prototype.annotationsMap=function(){var e=this;return this._annotationsMap||(this._annotationsMap={},this.annotations().forEach(function(t){var n=t.name(),r=n.lastIndexOf(".");r>=0&&(n=n.substring(r+1)),e._annotationsMap[n]=t})),this._annotationsMap},e.prototype.annotations=function(){var e=this;return this._annotations||(this._annotations=this._type.meta().filter(function(e){return e.kind()==S.MetaInformationKind.Annotation}).map(function(t){return new Te(t,e.reg)})),this._annotations},e.prototype.value=function(){return Ee.storeAsJSON(this._type)},e.prototype.name=function(){return this._type.name()},e.prototype.entry=function(){return this._type},e}();t.AnnotatedType=_e;var Te=function(){function e(e,t){this.actual=e}return e.prototype.name=function(){return this.actual.facetName()},e.prototype.value=function(){return this.actual.value()},e.prototype.definition=function(){var e=ie.get(this.actual.facetName());return e},e.prototype.annotation=function(){return this.actual},e}();t.AnnotationInstance=Te,t.applyAnnotationValidationPlugins=y,t.applyTypeValidationPlugins=v,t.toValidationPath=A,t.isUnknown=E},function(e,t,n){var r,i;(function(){function n(e){function t(t,n,r,i,a,o){for(;a>=0&&o>a;a+=e){var s=i?i[a]:a;r=n(r,t[s],s,t)}return r}return function(n,r,i,a){r=N(r,a,4);var o=!C(n)&&T.keys(n),s=(o||n).length,u=e>0?0:s-1;return arguments.length<3&&(i=n[o?o[u]:u],u+=e),t(n,r,i,o,u,s)}}function a(e){return function(t,n,r){n=S(n,r);for(var i=w(t),a=e>0?0:i-1;a>=0&&i>a;a+=e)if(n(t[a],a,t))return a;return-1}}function o(e,t,n){return function(r,i,a){var o=0,s=w(r);if("number"==typeof a)e>0?o=a>=0?a:Math.max(a+s,o):s=a>=0?Math.min(a+1,s):a+s+1;else if(n&&a&&s)return a=n(r,i),r[a]===i?a:-1;if(i!==i)return a=t(d.call(r,o,s),T.isNaN),a>=0?a+o:-1;for(a=e>0?o:s-1;a>=0&&s>a;a+=e)if(r[a]===i)return a;return-1}}function s(e,t){var n=U.length,r=e.constructor,i=T.isFunction(r)&&r.prototype||c,a="constructor";for(T.has(e,a)&&!T.contains(t,a)&&t.push(a);n--;)a=U[n],a in e&&e[a]!==i[a]&&!T.contains(t,a)&&t.push(a)}var u=this,l=u._,p=Array.prototype,c=Object.prototype,f=Function.prototype,h=p.push,d=p.slice,m=c.toString,y=c.hasOwnProperty,v=Array.isArray,g=Object.keys,A=f.bind,E=Object.create,_=function(){},T=function(e){return e instanceof T?e:this instanceof T?void(this._wrapped=e):new T(e)};"undefined"!=typeof e&&e.exports&&(t=e.exports=T),t._=T,T.VERSION="1.8.3";var N=function(e,t,n){if(void 0===t)return e;switch(null==n?3:n){case 1:return function(n){return e.call(t,n)};case 2:return function(n,r){return e.call(t,n,r)};case 3:return function(n,r,i){return e.call(t,n,r,i)};case 4:return function(n,r,i,a){return e.call(t,n,r,i,a)}}return function(){return e.apply(t,arguments)}},S=function(e,t,n){return null==e?T.identity:T.isFunction(e)?N(e,t,n):T.isObject(e)?T.matcher(e):T.property(e)};T.iteratee=function(e,t){return S(e,t,1/0)};var b=function(e,t){return function(n){var r=arguments.length;if(2>r||null==n)return n;for(var i=1;r>i;i++)for(var a=arguments[i],o=e(a),s=o.length,u=0;s>u;u++){var l=o[u];t&&void 0!==n[l]||(n[l]=a[l])}return n}},I=function(e){if(!T.isObject(e))return{};if(E)return E(e);_.prototype=e;var t=new _;return _.prototype=null,t},R=function(e){return function(t){return null==t?void 0:t[e]}},M=Math.pow(2,53)-1,w=R("length"),C=function(e){var t=w(e);return"number"==typeof t&&t>=0&&M>=t};T.each=T.forEach=function(e,t,n){t=N(t,n);var r,i;if(C(e))for(r=0,i=e.length;i>r;r++)t(e[r],r,e);else{var a=T.keys(e);for(r=0,i=a.length;i>r;r++)t(e[a[r]],a[r],e)}return e},T.map=T.collect=function(e,t,n){t=S(t,n);for(var r=!C(e)&&T.keys(e),i=(r||e).length,a=Array(i),o=0;i>o;o++){var s=r?r[o]:o;a[o]=t(e[s],s,e)}return a},T.reduce=T.foldl=T.inject=n(1),T.reduceRight=T.foldr=n(-1),T.find=T.detect=function(e,t,n){var r;return r=C(e)?T.findIndex(e,t,n):T.findKey(e,t,n),void 0!==r&&-1!==r?e[r]:void 0},T.filter=T.select=function(e,t,n){var r=[];return t=S(t,n),T.each(e,function(e,n,i){t(e,n,i)&&r.push(e)}),r},T.reject=function(e,t,n){return T.filter(e,T.negate(S(t)),n)},T.every=T.all=function(e,t,n){t=S(t,n);for(var r=!C(e)&&T.keys(e),i=(r||e).length,a=0;i>a;a++){var o=r?r[a]:a;if(!t(e[o],o,e))return!1}return!0},T.some=T.any=function(e,t,n){t=S(t,n);for(var r=!C(e)&&T.keys(e),i=(r||e).length,a=0;i>a;a++){var o=r?r[a]:a;if(t(e[o],o,e))return!0}return!1},T.contains=T.includes=T.include=function(e,t,n,r){return C(e)||(e=T.values(e)),("number"!=typeof n||r)&&(n=0),T.indexOf(e,t,n)>=0},T.invoke=function(e,t){var n=d.call(arguments,2),r=T.isFunction(t);return T.map(e,function(e){var i=r?t:e[t];return null==i?i:i.apply(e,n)})},T.pluck=function(e,t){return T.map(e,T.property(t))},T.where=function(e,t){return T.filter(e,T.matcher(t))},T.findWhere=function(e,t){return T.find(e,T.matcher(t))},T.max=function(e,t,n){var r,i,a=-(1/0),o=-(1/0);if(null==t&&null!=e){e=C(e)?e:T.values(e);for(var s=0,u=e.length;u>s;s++)r=e[s],r>a&&(a=r)}else t=S(t,n),T.each(e,function(e,n,r){i=t(e,n,r),(i>o||i===-(1/0)&&a===-(1/0))&&(a=e,o=i)});return a},T.min=function(e,t,n){var r,i,a=1/0,o=1/0;if(null==t&&null!=e){e=C(e)?e:T.values(e);for(var s=0,u=e.length;u>s;s++)r=e[s],a>r&&(a=r)}else t=S(t,n),T.each(e,function(e,n,r){i=t(e,n,r),(o>i||i===1/0&&a===1/0)&&(a=e,o=i)});return a},T.shuffle=function(e){for(var t,n=C(e)?e:T.values(e),r=n.length,i=Array(r),a=0;r>a;a++)t=T.random(0,a),t!==a&&(i[a]=i[t]),i[t]=n[a];return i},T.sample=function(e,t,n){return null==t||n?(C(e)||(e=T.values(e)),e[T.random(e.length-1)]):T.shuffle(e).slice(0,Math.max(0,t))},T.sortBy=function(e,t,n){return t=S(t,n),T.pluck(T.map(e,function(e,n,r){return{value:e,index:n,criteria:t(e,n,r)}}).sort(function(e,t){var n=e.criteria,r=t.criteria;if(n!==r){if(n>r||void 0===n)return 1;if(r>n||void 0===r)return-1}return e.index-t.index}),"value")};var L=function(e){return function(t,n,r){var i={};return n=S(n,r),T.each(t,function(r,a){var o=n(r,a,t);e(i,r,o)}),i}};T.groupBy=L(function(e,t,n){T.has(e,n)?e[n].push(t):e[n]=[t]}),T.indexBy=L(function(e,t,n){e[n]=t}),T.countBy=L(function(e,t,n){T.has(e,n)?e[n]++:e[n]=1}),T.toArray=function(e){return e?T.isArray(e)?d.call(e):C(e)?T.map(e,T.identity):T.values(e):[]},T.size=function(e){return null==e?0:C(e)?e.length:T.keys(e).length},T.partition=function(e,t,n){t=S(t,n);var r=[],i=[];return T.each(e,function(e,n,a){(t(e,n,a)?r:i).push(e)}),[r,i]},T.first=T.head=T.take=function(e,t,n){return null!=e?null==t||n?e[0]:T.initial(e,e.length-t):void 0},T.initial=function(e,t,n){return d.call(e,0,Math.max(0,e.length-(null==t||n?1:t)))},T.last=function(e,t,n){return null!=e?null==t||n?e[e.length-1]:T.rest(e,Math.max(0,e.length-t)):void 0},T.rest=T.tail=T.drop=function(e,t,n){return d.call(e,null==t||n?1:t)},T.compact=function(e){return T.filter(e,T.identity)};var P=function(e,t,n,r){for(var i=[],a=0,o=r||0,s=w(e);s>o;o++){var u=e[o];if(C(u)&&(T.isArray(u)||T.isArguments(u))){t||(u=P(u,t,n));var l=0,p=u.length;for(i.length+=p;p>l;)i[a++]=u[l++]}else n||(i[a++]=u)}return i};T.flatten=function(e,t){return P(e,t,!1)},T.without=function(e){return T.difference(e,d.call(arguments,1))},T.uniq=T.unique=function(e,t,n,r){T.isBoolean(t)||(r=n,n=t,t=!1),null!=n&&(n=S(n,r));for(var i=[],a=[],o=0,s=w(e);s>o;o++){var u=e[o],l=n?n(u,o,e):u;t?(o&&a===l||i.push(u),a=l):n?T.contains(a,l)||(a.push(l),i.push(u)):T.contains(i,u)||i.push(u)}return i},T.union=function(){return T.uniq(P(arguments,!0,!0))},T.intersection=function(e){for(var t=[],n=arguments.length,r=0,i=w(e);i>r;r++){var a=e[r];if(!T.contains(t,a)){for(var o=1;n>o&&T.contains(arguments[o],a);o++);o===n&&t.push(a)}}return t},T.difference=function(e){var t=P(arguments,!0,!0,1);return T.filter(e,function(e){return!T.contains(t,e)})},T.zip=function(){return T.unzip(arguments)},T.unzip=function(e){for(var t=e&&T.max(e,w).length||0,n=Array(t),r=0;t>r;r++)n[r]=T.pluck(e,r);return n},T.object=function(e,t){for(var n={},r=0,i=w(e);i>r;r++)t?n[e[r]]=t[r]:n[e[r][0]]=e[r][1];return n},T.findIndex=a(1),T.findLastIndex=a(-1),T.sortedIndex=function(e,t,n,r){n=S(n,r,1);for(var i=n(t),a=0,o=w(e);o>a;){var s=Math.floor((a+o)/2);n(e[s])<i?a=s+1:o=s}return a},T.indexOf=o(1,T.findIndex,T.sortedIndex),T.lastIndexOf=o(-1,T.findLastIndex),T.range=function(e,t,n){null==t&&(t=e||0,e=0),n=n||1;for(var r=Math.max(Math.ceil((t-e)/n),0),i=Array(r),a=0;r>a;a++,e+=n)i[a]=e;return i};var O=function(e,t,n,r,i){if(!(r instanceof t))return e.apply(n,i);var a=I(e.prototype),o=e.apply(a,i);return T.isObject(o)?o:a};T.bind=function(e,t){if(A&&e.bind===A)return A.apply(e,d.call(arguments,1));if(!T.isFunction(e))throw new TypeError("Bind must be called on a function");var n=d.call(arguments,2),r=function(){return O(e,r,t,this,n.concat(d.call(arguments)))};return r},T.partial=function(e){var t=d.call(arguments,1),n=function(){for(var r=0,i=t.length,a=Array(i),o=0;i>o;o++)a[o]=t[o]===T?arguments[r++]:t[o];for(;r<arguments.length;)a.push(arguments[r++]);return O(e,n,this,this,a)};return n},T.bindAll=function(e){var t,n,r=arguments.length;if(1>=r)throw new Error("bindAll must be passed function names");for(t=1;r>t;t++)n=arguments[t],e[n]=T.bind(e[n],e);return e},T.memoize=function(e,t){var n=function(r){var i=n.cache,a=""+(t?t.apply(this,arguments):r);return T.has(i,a)||(i[a]=e.apply(this,arguments)),i[a]};return n.cache={},n},T.delay=function(e,t){var n=d.call(arguments,2);return setTimeout(function(){return e.apply(null,n)},t)},T.defer=T.partial(T.delay,T,1),T.throttle=function(e,t,n){var r,i,a,o=null,s=0;n||(n={});var u=function(){s=n.leading===!1?0:T.now(),o=null,a=e.apply(r,i),o||(r=i=null)};return function(){var l=T.now();s||n.leading!==!1||(s=l);var p=t-(l-s);return r=this,i=arguments,0>=p||p>t?(o&&(clearTimeout(o),o=null),s=l,a=e.apply(r,i),o||(r=i=null)):o||n.trailing===!1||(o=setTimeout(u,p)),a}},T.debounce=function(e,t,n){var r,i,a,o,s,u=function(){var l=T.now()-o;t>l&&l>=0?r=setTimeout(u,t-l):(r=null,n||(s=e.apply(a,i),r||(a=i=null)))};return function(){a=this,i=arguments,o=T.now();var l=n&&!r;return r||(r=setTimeout(u,t)),l&&(s=e.apply(a,i),a=i=null),s}},T.wrap=function(e,t){return T.partial(t,e)},T.negate=function(e){return function(){return!e.apply(this,arguments)}},T.compose=function(){var e=arguments,t=e.length-1;return function(){for(var n=t,r=e[t].apply(this,arguments);n--;)r=e[n].call(this,r);return r}},T.after=function(e,t){return function(){return--e<1?t.apply(this,arguments):void 0}},T.before=function(e,t){var n;return function(){return--e>0&&(n=t.apply(this,arguments)),1>=e&&(t=null),n}},T.once=T.partial(T.before,2);var D=!{toString:null}.propertyIsEnumerable("toString"),U=["valueOf","isPrototypeOf","toString","propertyIsEnumerable","hasOwnProperty","toLocaleString"];T.keys=function(e){if(!T.isObject(e))return[];if(g)return g(e);var t=[];for(var n in e)T.has(e,n)&&t.push(n);return D&&s(e,t),t},T.allKeys=function(e){if(!T.isObject(e))return[];var t=[];for(var n in e)t.push(n);return D&&s(e,t),t},T.values=function(e){for(var t=T.keys(e),n=t.length,r=Array(n),i=0;n>i;i++)r[i]=e[t[i]];return r},T.mapObject=function(e,t,n){t=S(t,n);for(var r,i=T.keys(e),a=i.length,o={},s=0;a>s;s++)r=i[s],o[r]=t(e[r],r,e);return o},T.pairs=function(e){for(var t=T.keys(e),n=t.length,r=Array(n),i=0;n>i;i++)r[i]=[t[i],e[t[i]]];return r},T.invert=function(e){for(var t={},n=T.keys(e),r=0,i=n.length;i>r;r++)t[e[n[r]]]=n[r];return t},T.functions=T.methods=function(e){var t=[];for(var n in e)T.isFunction(e[n])&&t.push(n);return t.sort()},T.extend=b(T.allKeys),T.extendOwn=T.assign=b(T.keys),T.findKey=function(e,t,n){t=S(t,n);for(var r,i=T.keys(e),a=0,o=i.length;o>a;a++)if(r=i[a],t(e[r],r,e))return r},T.pick=function(e,t,n){var r,i,a={},o=e;if(null==o)return a;T.isFunction(t)?(i=T.allKeys(o),r=N(t,n)):(i=P(arguments,!1,!1,1),r=function(e,t,n){return t in n},o=Object(o));for(var s=0,u=i.length;u>s;s++){var l=i[s],p=o[l];r(p,l,o)&&(a[l]=p)}return a},T.omit=function(e,t,n){if(T.isFunction(t))t=T.negate(t);else{var r=T.map(P(arguments,!1,!1,1),String);t=function(e,t){return!T.contains(r,t)}}return T.pick(e,t,n)},T.defaults=b(T.allKeys,!0),T.create=function(e,t){var n=I(e);return t&&T.extendOwn(n,t),n},T.clone=function(e){return T.isObject(e)?T.isArray(e)?e.slice():T.extend({},e):e},T.tap=function(e,t){return t(e),e},T.isMatch=function(e,t){var n=T.keys(t),r=n.length;if(null==e)return!r;for(var i=Object(e),a=0;r>a;a++){var o=n[a];if(t[o]!==i[o]||!(o in i))return!1}return!0};var x=function(e,t,n,r){if(e===t)return 0!==e||1/e===1/t;if(null==e||null==t)return e===t;e instanceof T&&(e=e._wrapped),t instanceof T&&(t=t._wrapped);var i=m.call(e);if(i!==m.call(t))return!1;switch(i){case"[object RegExp]":case"[object String]":return""+e==""+t;case"[object Number]":return+e!==+e?+t!==+t:0===+e?1/+e===1/t:+e===+t;case"[object Date]":case"[object Boolean]":return+e===+t}var a="[object Array]"===i;if(!a){if("object"!=typeof e||"object"!=typeof t)return!1;var o=e.constructor,s=t.constructor;if(o!==s&&!(T.isFunction(o)&&o instanceof o&&T.isFunction(s)&&s instanceof s)&&"constructor"in e&&"constructor"in t)return!1}n=n||[],r=r||[];for(var u=n.length;u--;)if(n[u]===e)return r[u]===t;if(n.push(e),r.push(t),a){if(u=e.length,u!==t.length)return!1;for(;u--;)if(!x(e[u],t[u],n,r))return!1}else{var l,p=T.keys(e);if(u=p.length,
T.keys(t).length!==u)return!1;for(;u--;)if(l=p[u],!T.has(t,l)||!x(e[l],t[l],n,r))return!1}return n.pop(),r.pop(),!0};T.isEqual=function(e,t){return x(e,t)},T.isEmpty=function(e){return null==e||(C(e)&&(T.isArray(e)||T.isString(e)||T.isArguments(e))?0===e.length:0===T.keys(e).length)},T.isElement=function(e){return!(!e||1!==e.nodeType)},T.isArray=v||function(e){return"[object Array]"===m.call(e)},T.isObject=function(e){var t=typeof e;return"function"===t||"object"===t&&!!e},T.each(["Arguments","Function","String","Number","Date","RegExp","Error"],function(e){T["is"+e]=function(t){return m.call(t)==="[object "+e+"]"}}),T.isArguments(arguments)||(T.isArguments=function(e){return T.has(e,"callee")}),"function"!=typeof/./&&"object"!=typeof Int8Array&&(T.isFunction=function(e){return"function"==typeof e||!1}),T.isFinite=function(e){return isFinite(e)&&!isNaN(parseFloat(e))},T.isNaN=function(e){return T.isNumber(e)&&e!==+e},T.isBoolean=function(e){return e===!0||e===!1||"[object Boolean]"===m.call(e)},T.isNull=function(e){return null===e},T.isUndefined=function(e){return void 0===e},T.has=function(e,t){return null!=e&&y.call(e,t)},T.noConflict=function(){return u._=l,this},T.identity=function(e){return e},T.constant=function(e){return function(){return e}},T.noop=function(){},T.property=R,T.propertyOf=function(e){return null==e?function(){}:function(t){return e[t]}},T.matcher=T.matches=function(e){return e=T.extendOwn({},e),function(t){return T.isMatch(t,e)}},T.times=function(e,t,n){var r=Array(Math.max(0,e));t=N(t,n,1);for(var i=0;e>i;i++)r[i]=t(i);return r},T.random=function(e,t){return null==t&&(t=e,e=0),e+Math.floor(Math.random()*(t-e+1))},T.now=Date.now||function(){return(new Date).getTime()};var k={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},F=T.invert(k),B=function(e){var t=function(t){return e[t]},n="(?:"+T.keys(e).join("|")+")",r=RegExp(n),i=RegExp(n,"g");return function(e){return e=null==e?"":""+e,r.test(e)?e.replace(i,t):e}};T.escape=B(k),T.unescape=B(F),T.result=function(e,t,n){var r=null==e?void 0:e[t];return void 0===r&&(r=n),T.isFunction(r)?r.call(e):r};var V=0;T.uniqueId=function(e){var t=++V+"";return e?e+t:t},T.templateSettings={evaluate:/<%([\s\S]+?)%>/g,interpolate:/<%=([\s\S]+?)%>/g,escape:/<%-([\s\S]+?)%>/g};var K=/(.)^/,j={"'":"'","\\":"\\","\r":"r","\n":"n","\u2028":"u2028","\u2029":"u2029"},W=/\\|'|\r|\n|\u2028|\u2029/g,H=function(e){return"\\"+j[e]};T.template=function(e,t,n){!t&&n&&(t=n),t=T.defaults({},t,T.templateSettings);var r=RegExp([(t.escape||K).source,(t.interpolate||K).source,(t.evaluate||K).source].join("|")+"|$","g"),i=0,a="__p+='";e.replace(r,function(t,n,r,o,s){return a+=e.slice(i,s).replace(W,H),i=s+t.length,n?a+="'+\n((__t=("+n+"))==null?'':_.escape(__t))+\n'":r?a+="'+\n((__t=("+r+"))==null?'':__t)+\n'":o&&(a+="';\n"+o+"\n__p+='"),t}),a+="';\n",t.variable||(a="with(obj||{}){\n"+a+"}\n"),a="var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};\n"+a+"return __p;\n";try{var o=new Function(t.variable||"obj","_",a)}catch(e){throw e.source=a,e}var s=function(e){return o.call(this,e,T)},u=t.variable||"obj";return s.source="function("+u+"){\n"+a+"}",s},T.chain=function(e){var t=T(e);return t._chain=!0,t};var Y=function(e,t){return e._chain?T(t).chain():t};T.mixin=function(e){T.each(T.functions(e),function(t){var n=T[t]=e[t];T.prototype[t]=function(){var e=[this._wrapped];return h.apply(e,arguments),Y(this,n.apply(T,e))}})},T.mixin(T),T.each(["pop","push","reverse","shift","sort","splice","unshift"],function(e){var t=p[e];T.prototype[e]=function(){var n=this._wrapped;return t.apply(n,arguments),"shift"!==e&&"splice"!==e||0!==n.length||delete n[0],Y(this,n)}}),T.each(["concat","join","slice"],function(e){var t=p[e];T.prototype[e]=function(){return Y(this,t.apply(this._wrapped,arguments))}}),T.prototype.value=function(){return this._wrapped},T.prototype.valueOf=T.prototype.toJSON=T.prototype.value,T.prototype.toString=function(){return""+this._wrapped},r=[],i=function(){return T}.apply(t,r),!(void 0!==i&&(e.exports=i))}).call(this)},function(e,t,n){(function(e){"use strict";function r(e,t){var n=C(t,e),r=!!_&&S.getValue(n);if(r&&r.provider)return r;var i=new R(e,t);return S.setValue(n,i),i}function i(e,t){var n=(C(t,e),!!_&&S.getValue(e));if(n)return n;var r=new w(e,t);return _&&S.setValue(e,r),r}function a(e,t){var n=e&&e.trim().length>0&&"{"==e.trim().charAt(0),r=C(t,e),i=!!_&&S.getValue(r);if(i)return i;try{var a=new R(e,t);return _&&S.setValue(r,a),a}catch(i){if(_&&y.ValidationError.isInstance(i)&&n)return S.setValue(r,i),i;try{var a=new w(e,t);return S.setValue(r,a),a}catch(e){if(_){var o=new y.ValidationError(v.messageRegistry.CAN_NOT_PARSE_SCHEMA);return S.setValue(r,o),o}}}}function o(e,t,n){null==n&&(n=s(e)),n.length>0&&(n+=":");for(var r=e.getElementsByTagName(n+t),i=[],a=0;a<r.length;a++){var o=r[a];o.parentNode===e&&i.push(o)}return i}function s(e){var t="";if(e){var n=e;if(e.ownerDocument&&(n=e.ownerDocument),n){var r=n.documentElement;r&&(t=r.prefix)}}return t}function u(e,t){void 0===t&&(t=!1);var n,r,i=t?v.messageRegistry.CAN_NOT_PARSE_JSON:v.messageRegistry.INVALID_JSON_SCHEMA_DETAILS,a=L.length,o=P.length;if(e.substring(0,a)==L)n=L,r=a;else{if(e.substring(0,o)!=P)return new y.ValidationError(i,{msg:e});n=P,r=o}if(n&&r){var s=e.indexOf("\n",r);0>s&&(s=e.length);var u=e.substring(r).trim(),l=u.indexOf("<");0>l?l=0:l++;var p=u.indexOf("\n");0>p&&(p=u.length);var c=u.lastIndexOf("at",p);0>c?c=p:c+="at".length;var f=u.lastIndexOf(">",c);0>f&&(f=c);var h=u.substring(l,f),d=u.substring(c,p).trim(),m=d.indexOf(":");try{var g=parseInt(d.substring(0,m))-1,A=parseInt(d.substring(m+1,d.length))-1,E=n+" '"+h+"'",_=new y.ValidationError(i,{msg:E});return _.internalRange={start:{line:g,column:A,position:null},end:{line:g,column:A+h.length,position:null}},_}catch(e){}}return new y.ValidationError(v.messageRegistry.INVALID_JSON_SCHEMA_DETAILS,{msg:e})}function l(e,t,n){if(!n||"string"!=typeof n)return null;t=t||g(e,{verbose:!0}),"#"==n.charAt(0)&&(n=n.substring(1)),"/"==n.charAt(0)&&(n=n.substring(1));var r=t;if(n.length>0)for(var i=n.split("/"),a=0,o=i;a<o.length;a++){var s=o[a],u=p(r,s);if(null==u)break;r=u}var l=r.loc.start,c=r.loc.end;return{start:{line:l.line-1,column:l.column-1,position:l.offset},end:{line:c.line-1,column:c.column-1,position:c.offset}}}function p(e,t){return"property"==e.type&&(e=e.value),"object"==e.type?f.find(e.children,function(e){return e.key.value==t}):"array"==e.type?e.children[t]:"array"==e.type?e:null}function c(e,t){try{if("string"!=typeof e)return;g(e,{verbose:!0})}catch(e){var n=u(e.message,t);throw n}}Object.defineProperty(t,"__esModule",{value:!0});var f=n(61),h=n(62),d=n(64),m=n(66).DOMParser,y=n(58),v=n(58),g=n(69),A=function(){function e(){}return e}();t.ValidationResult=A;var E={errorHandler:{warning:function(){return null},error:function(){return null},fatalError:function(){return null}}},_=!0,T=5242880,N=function(){function e(){this.errors={},this.size=0}return e.prototype.getValue=function(e){var t=this.errors[e];return t?t.value:null},e.prototype.setValue=function(e,t){var n=this.errors[e];if(n)n.value=t;else for(n={key:e,value:t},this.top&&(this.top.next=n),this.top=n,this.last||(this.last=n),this.errors[e]=n,this.size+=e.length;this.size>T&&this.last;){var r=this.last.key;delete this.errors[r],this.size-=r.length,this.last=this.last.next}},e}(),S=new N;e.cleanCache=function(){S=new N};var b=function(){function e(){}return e.prototype.contextPath=function(){return""},e.prototype.normalizePath=function(e){return""},e.prototype.content=function(e){return""},e.prototype.hasAsyncRequests=function(){return!1},e.prototype.resolvePath=function(e,t){return""},e.prototype.isAbsolutePath=function(e){return!1},e.prototype.contentAsync=function(e){var t=this;return{then:function(n){return n(t.content(e))},resolve:function(){return null}}},e.prototype.promiseResolve=function(e){return{then:function(t){return t(e)},resolve:function(){return null}}},e}(),I=function(e,t,n){return"__EXAMPLE_"+e+t+n},R=function(){function e(e,t){if(this.schema=e,this.provider=t,this.EXAMPLE_ERROR_ENTRY=v.messageRegistry.CONTENT_DOES_NOT_MATCH_THE_SCHEMA,this.SCHEMA_ERROR_ENTRY=v.messageRegistry.INVALID_JSON_SCHEMA_DETAILS,t?this.provider=t:this.provider=new b,!e||0==e.trim().length||"{"!=e.trim().charAt(0))throw new y.ValidationError(v.messageRegistry.INVALID_JSON_SCHEMA);c(e,!1);var r=JSON.parse(e);if(r){try{var i=n(70);this.setupId(r,this.provider.contextPath());var a=""+r.$schema;-1==a.indexOf("http://json-schema.org/draft-04/")?r=i.v4(r):this.fixRequired(r)}catch(e){throw new y.ValidationError(v.messageRegistry.INVALID_JSON_SCHEMA_DETAILS,{msg:e.message})}delete r.$schema,this.jsonSchema=r}}return e.prototype.fixRequired=function(e){},e.prototype.getType=function(){return"source.json"},e.prototype.validateObject=function(e){this.validate(JSON.stringify(e))},e.prototype.getMissingReferences=function(e,t){var n=this;void 0===t&&(t=!1);var r=[],i=d.getValidator();e.forEach(function(e){return i.setRemoteReference(e.reference,e.content||{})});var a=null;if(this.jsonSchema.id&&"string"==typeof this.jsonSchema.id){a=this.jsonSchema.id;var o=a.indexOf("#");-1!=o&&(a=a.substr(0,o))}try{i.validateSchema(this.jsonSchema)}catch(e){return[]}var r=i.getMissingRemoteReferences(),s=[];return r&&(s=f.filter(r,function(e){return!i.isResourceLoaded(e)&&e!=a})),t?s.map(function(e){return n.provider.normalizePath(e)}):s},e.prototype.getSchemaPath=function(e,t){if(void 0===t&&(t=!1),!e)return"";if(!e.id)return"";var n=e.id.trim();if(n.lastIndexOf("#")!==n.length-1)return n;var r=n.substr(0,n.length-1);return t?this.provider.normalizePath(r):r},e.prototype.patchSchema=function(e){var t=this;if(!e)return e;if(!e.id)return e;var n=e.id.trim();n.lastIndexOf("#")!==n.length-1&&(n+="#",e.id=n);var r=n.substr(0,n.length-1);if(!this.provider.isAbsolutePath(r))return e;r=this.provider.normalizePath(r);var i=[];this.collectRefContainers(e,i),i.forEach(function(e){var n=e.$ref;if("string"==typeof n&&0!==n.indexOf("#")){-1===n.indexOf("#")&&(n+="#");var i;i=t.provider.isAbsolutePath(n)?t.toProperWebURL(n):t.provider.resolvePath(r,n),e.$ref=i}})},e.prototype.removeFragmentPartOfIDs=function(e){var t=this;if(e){if(Array.isArray(e))return void e.forEach(function(e){return t.removeFragmentPartOfIDs(e)});if("object"==typeof e){var n=e.id;if(n&&"string"==typeof e.id){var r=n.indexOf("#");r>=0&&(n=n.substring(0,r).trim(),n?e.id=n:delete e.id)}Object.keys(e).forEach(function(n){return t.removeFragmentPartOfIDs(e[n])})}}},e.prototype.collectRefContainers=function(e,t){var n=this;Object.keys(e).forEach(function(r){return"$ref"===r?void t.push(e):void(e[r]&&"object"==typeof e[r]&&n.collectRefContainers(e[r],t))})},e.prototype.validate=function(e,t){var r=this;void 0===t&&(t=[]);var i=I(e,this.schema,this.provider.contextPath()),a=S.getValue(i);if(a){if(a instanceof Error)throw a}else{if(0==t.length&&(c(e,!0),this.jsonSchema.id)){var o=this.jsonSchema.id;if("#"==o.charAt(o.length-1)){var s=o.substring(0,o.length-1);t.push({reference:s,content:this.jsonSchema})}}var u=JSON.parse(e),l=d.getValidator();t.forEach(function(e){return l.setRemoteReference(e.reference,e.content)}),l.validate(u,this.jsonSchema);var p=l.getMissingRemoteReferences().filter(function(e){return!f.find(t,function(t){return e===t.reference})});if(!p||0===p.length)return void this.acceptErrors(i,l.getLastErrors(),e,!0);var h=[];p.forEach(function(e){var t,i=r.decodeURL(e),a={reference:e};try{var o=n(70),s=r.provider.content(i);c(s,!0);var u=JSON.parse(s);r.setupId(u,r.provider.normalizePath(i)),t=o.v4(u),delete t.$schema,a.content=t}catch(e){if(y.ValidationError.isInstance(e))throw e.filePath=i,e;a.error=e}finally{h.push(a)}}),this.provider.hasAsyncRequests()||(h.forEach(function(e){t.push(e)}),this.validate(e,t))}},e.checkIfNonObjectAssignmentFailure=function(e){var t="__$validated",n="called on non-object";if(!e)return null;if(-1!=e.indexOf(t)){var r="Cannot assign to read only property '__$validated' of ",i="Cannot create property '__$validated' on string '";return 0==e.indexOf(r)&&e.length>r.length?e.substr(r.length,e.length-r.length):0==e.indexOf(i)&&e.length>i.length+1&&"'"==e.charAt(e.length-1)?e.substr(i.length,e.length-i.length-1):""}return-1!=e.indexOf(n)?"":null},e.prototype.validateSelf=function(t){var r=this;void 0===t&&(t=[]);var i=I("__SCHEMA_VALIDATION__",this.schema,this.provider.contextPath()),a=S.getValue(i);if(a){if(a instanceof Error)throw a}else{var o=d.getValidator();t.forEach(function(e){return o.setRemoteReference(e.reference,e.content)});try{delete this.jsonSchema.id,o.validateSchema(this.jsonSchema)}catch(t){var s=e.checkIfNonObjectAssignmentFailure(t.message);if(null!==s){var u=s,l="Assignment to non-object.";u&&(l="Unexpected value '"+u+"'"),this.acceptErrors(i,[{message:l,params:[]}],null,!0,!0)}throw t}var p=o.getMissingRemoteReferences().filter(function(e){return!f.find(t,function(t){return e===t.reference})});if(!p||0===p.length)return void this.acceptErrors(i,o.getLastErrors(),null,!0,!0);var h=[];p.forEach(function(e){var t,i=r.decodeURL(e),a={reference:e};try{var o=n(70),s=r.provider.content(i);c(s,!0);var u=JSON.parse(s);r.setupId(u,r.provider.normalizePath(i)),t=o.v4(u),delete t.$schema,a.content=t}catch(e){if(y.ValidationError.isInstance(e))throw e.filePath=i,e;a.error=e}finally{h.push(a)}}),this.provider.hasAsyncRequests()||(h.forEach(function(e){t.push(e)}),this.validateSelf(t))}},e.prototype.setupId=function(e,t){t&&e&&(this.removeFragmentPartOfIDs(e),e.id&&(this.provider.isAbsolutePath(e.id)||(e.id=this.provider.resolvePath(t,e.id))),e.id=t.replace(/\\/g,"/"),"#"!=e.id.charAt(e.id.length-1)&&(e.id=e.id+"#"),e.id=this.toProperWebURL(e.id),this.patchSchema(e))},e.prototype.toProperWebURL=function(e){if(null==e||0==e.trim().length)return e;var t="https://".length;if(e.length>=t&&"https://"==e.substring(0,t))return e;e=e.replace("//","__/DOUBLESLASH/__"),e=e.replace(/^([a-zA-Z]):/,"$1__/COLON/__");var n="https://__/APPENDED_PROTOCOL/__";return"/"!=e.charAt(0)&&(n+="/"),n+e},e.prototype.decodeURL=function(e){if(null==e||0==e.trim().length)return e;var t="https://__/APPENDED_PROTOCOL/__",n=t.length;return e.length<n||e.substring(0,n)!=t?e:(e=e.substring(n,e.length),e.indexOf("__/COLON/__")>0&&"/"==e.charAt(0)&&(e=e.substring(1)),e=e.replace("__/DOUBLESLASH/__","//").replace("__/COLON/__",":"))},e.prototype.acceptErrors=function(t,n,r,i,a){var o=this;void 0===i&&(i=!1),void 0===a&&(a=!1);var s=null!=r,u=null!=r?r:this.schema;if(n&&n.length>0){var p=g(u,{verbose:!0}),c=n.map(function(t){var n,i=s&&e.EXAMPLE_ERROR_CODES[t.code];n=i?o.EXAMPLE_ERROR_ENTRY:o.SCHEMA_ERROR_ENTRY;var c=new y.ValidationError(n,{msg:t.message});return(i||null==r)&&(c.internalRange=l(u,p,t.path)),c.isWarning=a,c.error=t,c.internalPath=t.path,c}),f=c[0];if(f.additionalErrors=c.slice(1),S.setValue(t,f),i)throw f}else S.setValue(t,1)},e.prototype.contentAsync=function(e){var t,r=this,i=this.decodeURL(e),a=n(70),o=this.provider.contentAsync(i);if(!o)return this.provider.promiseResolve({reference:i,content:null,error:new y.ValidationError(v.messageRegistry.REFERENCE_NOT_FOUND,{ref:i})});var s=o.then(function(n){var o={reference:e};try{c(n,!0);var s=JSON.parse(n);r.setupId(s,r.provider.normalizePath(i)),t=a.v4(s),delete t.$schema,o.content=t}catch(e){throw o.error=e,o.reference=i,e}return o});return s},e.SCHEMA_ERROR_CODES={KEYWORD_TYPE_EXPECTED:!0,KEYWORD_MUST_BE:!0,KEYWORD_DEPENDENCY:!0,KEYWORD_PATTERN:!0,KEYWORD_UNDEFINED_STRICT:!0,KEYWORD_VALUE_TYPE:!0,CUSTOM_MODE_FORCE_PROPERTIES:!0,UNKNOWN_FORMAT:!0,PARENT_SCHEMA_VALIDATION_FAILED:!0,REF_UNRESOLVED:!0,KEYWORD_UNEXPECTED:!0,SCHEMA_NOT_AN_OBJECT:!0,SCHEMA_NOT_REACHABLE:!0,UNRESOLVABLE_REFERENCE:!0},e.EXAMPLE_ERROR_CODES={MULTIPLE_OF:!0,MAXIMUM:!0,MAXIMUM_EXCLUSIVE:!0,MAX_LENGTH:!0,MIN_LENGTH:!0,PATTERN:!0,ARRAY_ADDITIONAL_ITEMS:!0,ARRAY_LENGTH_LONG:!0,ARRAY_LENGTH_SHORT:!0,ARRAY_UNIQUE:!0,OBJECT_PROPERTIES_MAXIMUM:!0,OBJECT_PROPERTIES_MINIMUM:!0,OBJECT_MISSING_REQUIRED_PROPERTY:!0,OBJECT_ADDITIONAL_PROPERTIES:!0,OBJECT_DEPENDENCY_KEY:!0,ENUM_MISMATCH:!0,ANY_OF_MISSING:!0,ONE_OF_MISSING:!0,ONE_OF_MULTIPLE:!0,NOT_PASSED:!0,INVALID_FORMAT:!0,UNKNOWN_FORMAT:!0,INVALID_TYPE:!0},e}();t.JSONSchemaObject=R;var M=10,w=function(){function e(e,t){if(this.schema=e,this.provider=t,this.extraElementData=null,this.references={},this.contentToResult={},t||(this.provider=new b),"<"!=e.charAt(0))throw new y.ValidationError(v.messageRegistry.INVALID_XML_SCHEMA);this.schemaString=this.handleReferenceElement(e)}return e.prototype.getType=function(){return"text.xml"},e.prototype.validateObject=function(e){if(this.extraElementData){var t=Object.keys(e)[0],n=new y.ValidationError(v.messageRegistry.EXTERNAL_TYPE_ERROR,{typeName:this.extraElementData.requestedName,objectName:t});if(!this.extraElementData.type&&!this.extraElementData.originalName)return void this.acceptErrors("key",[n],!0);if(this.extraElementData.originalName&&t!==this.extraElementData.originalName)return void this.acceptErrors("key",[n],!0);if(this.extraElementData.type){var r=e[t];delete e[t],e[this.extraElementData.name]=r}}this.validate(h.jsonToXml(e))},e.prototype.collectReferences=function(e,t,n){var r,i=this;r=new m(E).parseFromString(e);var a=o(r,"schema",this.namspacePrefix)[0],s=o(a,"import",this.namspacePrefix),u=o(a,"include",this.namspacePrefix),l=s.concat(u);return l.forEach(function(e){var r=e.getAttribute("schemaLocation");if(r){var a=i.provider.resolvePath(t,r),o=n[a];if(!o){var s,u=Object.keys(n).length,l=i.provider.content(a);try{s=i.collectReferences(l,a,n)}catch(e){s=l}o=h.createXmlSchemaReference(a,u,s),n[a]=o}e.setAttribute("schemaLocation","file_"+o.virtualIndex+".xsd")}}),r.toString()},e.prototype.getMissingReferences=function(){var e,t=this;e=new m(E).parseFromString(this.schemaString);var n=o(e,"schema",this.namspacePrefix)[0],r=o(n,"import",this.namspacePrefix),i=o(n,"include",this.namspacePrefix),a=r.concat(i),s=[];return a.forEach(function(e){var n=e.getAttribute("schemaLocation");if(n){var r=t.provider.resolvePath(t.provider.contextPath(),n);s.push(r)}}),s},e.prototype.collectReferencesAsync=function(e,t,n){var r,i=this;r=new m(E).parseFromString(e);var a=o(r,"schema",this.namspacePrefix)[0],s=o(a,"import",this.namspacePrefix),u=o(a,"include",this.namspacePrefix),l=s.concat(u);return Promise.all(l.map(function(e){var r=e.getAttribute("schemaLocation");if(r){var a=i.provider.resolvePath(t,r),o=n[a];return o?(e.setAttribute("schemaLocation","file_"+o.virtualIndex+".xsd"),{}):i.provider.contentAsync(a).then(function(t){return i.collectReferencesAsync(t,a,n).then(function(e){return e},function(e){return t}).then(function(t){var r=Object.keys(n).length;return o=h.createXmlSchemaReference(a,r,t),n[a]=o,e.setAttribute("schemaLocation","file_"+o.virtualIndex+".xsd"),{}})})}return{}})).then(function(e){return Promise.resolve(r.toString())})},e.prototype.loadSchemaReferencesAsync=function(){return this.collectReferencesAsync(this.schemaString,this.provider.contextPath(),{})},e.prototype.validate=function(e){try{var t=this.contentToResult[e];if(t===!1)return;if(t)throw t;var n={},r=this.collectReferences(this.schemaString,this.provider.contextPath(),n),i=h.getValidator(r);if(this.provider.hasAsyncRequests())return;var a=i.validate(e,Object.keys(n).map(function(e){return n[e]}));this.acceptErrors("key",a,!0),this.contentToResult[e]=!1,Object.keys(this.contentToResult).length>M&&(this.contentToResult={})}catch(t){throw this.contentToResult[e]=t,t}},e.prototype.handleReferenceElement=function(e){var t=new m(E).parseFromString(e);this.namspacePrefix=s(t);var n=o(t,"schema",this.namspacePrefix)[0],r=o(n,"element",this.namspacePrefix),i=f.find(r,function(e){return"true"===e.getAttribute("extraelement")});if(!i)return e;var a={};return a.name=i.getAttribute("name"),a.type=i.getAttribute("type"),a.originalName=i.getAttribute("originalname"),a.requestedName=i.getAttribute("requestedname"),a.type||n.removeChild(i),i.removeAttribute("originalname"),i.removeAttribute("requestedname"),i.removeAttribute("extraelement"),this.extraElementData=a,t.toString()},e.prototype.acceptErrors=function(e,t,n){if(void 0===n&&(n=!1),t&&t.length>0){var r=t.map(function(e){return e.message}).join(", "),i=new y.ValidationError(v.messageRegistry.CONTENT_DOES_NOT_MATCH_THE_SCHEMA,{msg:r});if(i.errors=t,S.setValue(e,i),n)throw i}},e}();t.XMLSchemaObject=w,t.getJSONSchema=r;var C=function(e,t){var n="";e&&(n=e.contextPath());var r="__SCHEMA_"+t+n;return r};t.getXMLSchema=i,t.createSchema=a;var L="Cannot tokenize symbol",P="Unexpected token";t.messageToValidationError=u,t.getJSONRange=l,t.tryParseJSON=c}).call(t,function(){return this}())},function(e,t,n){"use strict";function r(e,t){return o.find(e,t)}function i(e,t){return o.filter(e,t)}function a(e){return o.unique(e)}Object.defineProperty(t,"__esModule",{value:!0});var o=n(59);t.find=r,t.filter=i,t.unique=a},function(e,t,n){"use strict";function r(e,t,n){return{originalPath:e,virtualIndex:t,patchedContent:n}}function i(e){if(!e)return"";var t=Object.keys(e)[0],n=e[t];if("#text"==t)return n;if(!n&&""!==n)return"";var r="<"+t,a=n.$||{};return Object.keys(a).forEach(function(e){r=r+" "+e+'="'+a[e]+'"'}),r+=">","string"==typeof n?r+=n:Object.keys(n).forEach(function(e){if("$"!==e)if("object"!=typeof n[e]||n[e].length)if("string"!=typeof n[e]&&n[e]){if("object"==typeof n[e]&&n[e].length)for(var t=n[e],a=0;a<t.length;a++){var o=t[a],s={};s[e]=o,r+=i(s)}}else{var s={};s[e]=n[e]||"",r+=i(s)}else{var s={};s[e]=n[e],r+=i(s)}}),r=r+"</"+t+">"}function a(e){return new l(e)}function o(e){var t=e&&Object.keys(e)[0];if(t){var n=e[t];s(n)}return i(e)}function s(e){if(e&&"string"!=typeof e){var t=[];Object.keys(e).forEach(function(n){if("$"!=n)if(0===n.indexOf("@")){var r={key:n,value:e[n]};t.push(r)}else if(u(e[n])){var i=e[n];i.forEach(function(e){return s(e)})}else"string"!=typeof e[n]&&s(e[n])}),e.$||(e.$={});var n=e.$;t.forEach(function(t){delete e[t.key];var r=t.key.substring(1);n[r]=t.value})}}function u(e){return!!e&&"object"==typeof e&&"number"==typeof e.length}Object.defineProperty(t,"__esModule",{value:!0});var l;try{l=n(63).XMLValidator}catch(e){}if(!l){var p=function(){function e(e){}return e.prototype.validate=function(e,t){return[]},e}();l=p}t.createXmlSchemaReference=r,t.getValidator=a,t.jsonToXml=o},function(e,t){if("undefined"==typeof __WEBPACK_EXTERNAL_MODULE_63__){var n=new Error('Cannot find module "RAML.XmlValidation"');throw n.code="MODULE_NOT_FOUND",n}e.exports=__WEBPACK_EXTERNAL_MODULE_63__},function(e,t,n){"use strict";function r(){return new i}Object.defineProperty(t,"__esModule",{value:!0});var i;try{i=n(65).JSONValidator}catch(e){}if(!i){var a=function(){function e(){}return e.prototype.setRemoteReference=function(e,t){},e.prototype.validateSchema=function(e){},e.prototype.getMissingRemoteReferences=function(){return[]},e.prototype.isResourceLoaded=function(e){return!0},e.prototype.validate=function(e,t){},e.prototype.getLastErrors=function(){return[]},e}();i=a}t.getValidator=r},function(e,t){if("undefined"==typeof __WEBPACK_EXTERNAL_MODULE_65__){var n=new Error('Cannot find module "RAML.JsonValidation"');throw n.code="MODULE_NOT_FOUND",n}e.exports=__WEBPACK_EXTERNAL_MODULE_65__},function(e,t,n){function r(e){this.options=e||{locator:{}}}function i(e,t,n){function r(t){var r=e[t];!r&&o&&(r=2==e.length?function(n){e(t,n)}:e),i[t]=r&&function(e){r("[xmldom "+t+"]	"+e+s(n))}||function(){}}if(!e){if(t instanceof a)return t;e=t}var i={},o=e instanceof Function;return n=n||{},r("warning"),r("error"),r("fatalError"),i}function a(){this.cdata=!1}function o(e,t){t.lineNumber=e.lineNumber,t.columnNumber=e.columnNumber}function s(e){return e?"\n@"+(e.systemId||"")+"#[line:"+e.lineNumber+",col:"+e.columnNumber+"]":void 0}function u(e,t,n){return"string"==typeof e?e.substr(t,n):e.length>=t+n||t?new java.lang.String(e,t,n)+"":e}function l(e,t){e.currentElement?e.currentElement.appendChild(t):e.doc.appendChild(t)}r.prototype.parseFromString=function(e,t){var n=this.options,r=new p,o=n.domBuilder||new a,s=n.errorHandler,u=n.locator,l=n.xmlns||{},c={lt:"<",gt:">",amp:"&",quot:'"',apos:"'"};return u&&o.setDocumentLocator(u),r.errorHandler=i(s,o,u),r.domBuilder=n.domBuilder||o,/\/x?html?$/.test(t)&&(c.nbsp=" ",c.copy="©",l[""]="http://www.w3.org/1999/xhtml"),l.xml=l.xml||"http://www.w3.org/XML/1998/namespace",e?r.parse(e,l,c):r.errorHandler.error("invalid doc source"),o.doc},a.prototype={startDocument:function(){this.doc=(new c).createDocument(null,null,null),this.locator&&(this.doc.documentURI=this.locator.systemId)},startElement:function(e,t,n,r){var i=this.doc,a=i.createElementNS(e,n||t),s=r.length;l(this,a),this.currentElement=a,this.locator&&o(this.locator,a);for(var u=0;s>u;u++){var e=r.getURI(u),p=r.getValue(u),n=r.getQName(u),c=i.createAttributeNS(e,n);this.locator&&o(r.getLocator(u),c),c.value=c.nodeValue=p,a.setAttributeNode(c)}},endElement:function(e,t,n){var r=this.currentElement;r.tagName,this.currentElement=r.parentNode},startPrefixMapping:function(e,t){},endPrefixMapping:function(e){},processingInstruction:function(e,t){var n=this.doc.createProcessingInstruction(e,t);this.locator&&o(this.locator,n),l(this,n)},ignorableWhitespace:function(e,t,n){},characters:function(e,t,n){if(e=u.apply(this,arguments)){if(this.cdata)var r=this.doc.createCDATASection(e);else var r=this.doc.createTextNode(e);this.currentElement?this.currentElement.appendChild(r):/^\s*$/.test(e)&&this.doc.appendChild(r),this.locator&&o(this.locator,r)}},skippedEntity:function(e){},endDocument:function(){this.doc.normalize()},setDocumentLocator:function(e){(this.locator=e)&&(e.lineNumber=0)},comment:function(e,t,n){e=u.apply(this,arguments);var r=this.doc.createComment(e);this.locator&&o(this.locator,r),l(this,r)},startCDATA:function(){this.cdata=!0},endCDATA:function(){this.cdata=!1},startDTD:function(e,t,n){var r=this.doc.implementation;if(r&&r.createDocumentType){var i=r.createDocumentType(e,t,n);this.locator&&o(this.locator,i),l(this,i)}},warning:function(e){console.warn("[xmldom warning]	"+e,s(this.locator))},error:function(e){console.error("[xmldom error]	"+e,s(this.locator))},fatalError:function(e){throw console.error("[xmldom fatalError]	"+e,s(this.locator)),e}},"endDTD,startEntity,endEntity,attributeDecl,elementDecl,externalEntityDecl,internalEntityDecl,resolveEntity,getExternalSubset,notationDecl,unparsedEntityDecl".replace(/\w+/g,function(e){a.prototype[e]=function(){return null}});var p=n(67).XMLReader,c=t.DOMImplementation=n(68).DOMImplementation;t.XMLSerializer=n(68).XMLSerializer,t.DOMParser=r},function(e,t){function n(){}function r(e,t,n,r,l){function h(e){if(e>65535){e-=65536;var t=55296+(e>>10),n=56320+(1023&e);return String.fromCharCode(t,n)}return String.fromCharCode(e)}function d(e){var t=e.slice(1,-1);return t in n?n[t]:"#"===t.charAt(0)?h(parseInt(t.substr(1).replace("x","0x"))):(l.error("entity not found:"+e),e)}function m(t){if(t>N){var n=e.substring(N,t).replace(/&#?\w+;/g,d);E&&y(N),r.characters(n,0,t-N),N=t}}function y(t,n){for(;t>=g&&(n=A.exec(e));)v=n.index,g=v+n[0].length,E.lineNumber++;E.columnNumber=t-v+1}for(var v=0,g=0,A=/.*(?:\r\n?|\n)|.*$/g,E=r.locator,_=[{currentNSMap:t}],T={},N=0;;){try{var S=e.indexOf("<",N);if(0>S){if(!e.substr(N).match(/^\s*$/)){var b=r.doc,I=b.createTextNode(e.substr(N));b.appendChild(I),r.currentElement=I}return}switch(S>N&&m(S),e.charAt(S+1)){case"/":var R=e.indexOf(">",S+3),M=e.substring(S+2,R),w=_.pop();0>R?(M=e.substring(S+2).replace(/[\s<].*/,""),l.error("end tag name: "+M+" is not complete:"+w.tagName),R=S+1+M.length):M.match(/\s</)&&(M=M.replace(/[\s<].*/,""),l.error("end tag name: "+M+" maybe not complete"),R=S+1+M.length);var C=w.localNSMap,L=w.tagName==M,P=L||w.tagName&&w.tagName.toLowerCase()==M.toLowerCase();if(P){if(r.endElement(w.uri,w.localName,M),C)for(var O in C)r.endPrefixMapping(O);L||l.fatalError("end tag name: "+M+" is not match the current start tagName:"+w.tagName)}else _.push(w);R++;break;case"?":E&&y(S),R=c(e,S,r);break;case"!":E&&y(S),R=p(e,S,r,l);break;default:E&&y(S);var D=new f,U=_[_.length-1].currentNSMap,R=a(e,S,D,U,d,l),x=D.length;if(!D.closed&&u(e,R,D.tagName,T)&&(D.closed=!0,n.nbsp||l.warning("unclosed xml attribute")),E&&x){for(var k=i(E,{}),F=0;x>F;F++){var B=D[F];y(B.offset),B.locator=i(E,{})}r.locator=k,o(D,r,U)&&_.push(D),r.locator=E}else o(D,r,U)&&_.push(D);"http://www.w3.org/1999/xhtml"!==D.uri||D.closed?R++:R=s(e,R,D.tagName,d,r)}}catch(e){l.error("element parse error: "+e),R=-1}R>N?N=R:m(Math.max(S,N)+1)}}function i(e,t){return t.lineNumber=e.lineNumber,t.columnNumber=e.columnNumber,t}function a(e,t,n,r,i,a){for(var o,s,u=++t,l=g;;){var p=e.charAt(u);switch(p){case"=":if(l===A)o=e.slice(t,u),l=_;else{if(l!==E)throw new Error("attribute equal must after attrName");l=_}break;case"'":case'"':if(l===_||l===A){if(l===A&&(a.warning('attribute value must after "="'),o=e.slice(t,u)),t=u+1,u=e.indexOf(p,t),!(u>0))throw new Error("attribute value no end '"+p+"' match");s=e.slice(t,u).replace(/&#?\w+;/g,i),n.add(o,s,t-1),l=N}else{if(l!=T)throw new Error('attribute value must after "="');s=e.slice(t,u).replace(/&#?\w+;/g,i),n.add(o,s,t),a.warning('attribute "'+o+'" missed start quot('+p+")!!"),t=u+1,l=N}break;case"/":switch(l){case g:n.setTagName(e.slice(t,u));case N:case S:case b:l=b,n.closed=!0;case T:case A:case E:break;default:throw new Error("attribute invalid close char('/')")}break;case"":return a.error("unexpected end of input"),l==g&&n.setTagName(e.slice(t,u)),u;case">":switch(l){case g:n.setTagName(e.slice(t,u));case N:case S:case b:break;case T:case A:s=e.slice(t,u),"/"===s.slice(-1)&&(n.closed=!0,s=s.slice(0,-1));case E:l===E&&(s=o),l==T?(a.warning('attribute "'+s+'" missed quot(")!!'),n.add(o,s.replace(/&#?\w+;/g,i),t)):("http://www.w3.org/1999/xhtml"===r[""]&&s.match(/^(?:disabled|checked|selected)$/i)||a.warning('attribute "'+s+'" missed value!! "'+s+'" instead!!'),n.add(s,s,t));break;case _:throw new Error("attribute value missed!!")}return u;case"":p=" ";default:if(" ">=p)switch(l){case g:n.setTagName(e.slice(t,u)),l=S;break;case A:o=e.slice(t,u),l=E;break;case T:var s=e.slice(t,u).replace(/&#?\w+;/g,i);a.warning('attribute "'+s+'" missed quot(")!!'),n.add(o,s,t);case N:l=S}else switch(l){case E:n.tagName,"http://www.w3.org/1999/xhtml"===r[""]&&o.match(/^(?:disabled|checked|selected)$/i)||a.warning('attribute "'+o+'" missed value!! "'+o+'" instead2!!'),n.add(o,o,t),t=u,l=A;break;case N:a.warning('attribute space is required"'+o+'"!!');case S:l=A,t=u;break;case _:l=T,t=u;break;case b:throw new Error("elements closed character '/' and '>' must be connected to")}}u++}}function o(e,t,n){for(var r=e.tagName,i=null,a=e.length;a--;){var o=e[a],s=o.qName,u=o.value,p=s.indexOf(":");if(p>0)var c=o.prefix=s.slice(0,p),f=s.slice(p+1),h="xmlns"===c&&f;else f=s,c=null,h="xmlns"===s&&"";o.localName=f,h!==!1&&(null==i&&(i={},l(n,n={})),n[h]=i[h]=u,o.uri="http://www.w3.org/2000/xmlns/",t.startPrefixMapping(h,u))}for(var a=e.length;a--;){o=e[a];var c=o.prefix;c&&("xml"===c&&(o.uri="http://www.w3.org/XML/1998/namespace"),"xmlns"!==c&&(o.uri=n[c||""]))}var p=r.indexOf(":");p>0?(c=e.prefix=r.slice(0,p),f=e.localName=r.slice(p+1)):(c=null,f=e.localName=r);var d=e.uri=n[c||""];if(t.startElement(d,f,r,e),!e.closed)return e.currentNSMap=n,e.localNSMap=i,!0;if(t.endElement(d,f,r),i)for(c in i)t.endPrefixMapping(c)}function s(e,t,n,r,i){if(/^(?:script|textarea)$/i.test(n)){var a=e.indexOf("</"+n+">",t),o=e.substring(t+1,a);if(/[&<]/.test(o))return/^script$/i.test(n)?(i.characters(o,0,o.length),a):(o=o.replace(/&#?\w+;/g,r),i.characters(o,0,o.length),a)}return t+1}function u(e,t,n,r){var i=r[n];return null==i&&(i=e.lastIndexOf("</"+n+">"),t>i&&(i=e.lastIndexOf("</"+n)),r[n]=i),t>i}function l(e,t){for(var n in e)t[n]=e[n]}function p(e,t,n,r){var i=e.charAt(t+2);switch(i){case"-":if("-"===e.charAt(t+3)){var a=e.indexOf("-->",t+4);return a>t?(n.comment(e,t+4,a-t-4),a+3):(r.error("Unclosed comment"),
-1)}return-1;default:if("CDATA["==e.substr(t+3,6)){var a=e.indexOf("]]>",t+9);return n.startCDATA(),n.characters(e,t+9,a-t-9),n.endCDATA(),a+3}var o=d(e,t),s=o.length;if(s>1&&/!doctype/i.test(o[0][0])){var u=o[1][0],l=s>3&&/^public$/i.test(o[2][0])&&o[3][0],p=s>4&&o[4][0],c=o[s-1];return n.startDTD(u,l&&l.replace(/^(['"])(.*?)\1$/,"$2"),p&&p.replace(/^(['"])(.*?)\1$/,"$2")),n.endDTD(),c.index+c[0].length}}return-1}function c(e,t,n){var r=e.indexOf("?>",t);if(r){var i=e.substring(t,r).match(/^<\?(\S*)\s*([\s\S]*?)\s*$/);return i?(i[0].length,n.processingInstruction(i[1],i[2]),r+2):-1}return-1}function f(e){}function h(e,t){return e.__proto__=t,e}function d(e,t){var n,r=[],i=/'[^']+'|"[^"]+"|[^\s<>\/=]+=?|(\/?\s*>|<)/g;for(i.lastIndex=t,i.exec(e);n=i.exec(e);)if(r.push(n),n[1])return r}var m=/[A-Z_a-z\xC0-\xD6\xD8-\xF6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/,y=new RegExp("[\\-\\.0-9"+m.source.slice(1,-1)+"\\u00B7\\u0300-\\u036F\\u203F-\\u2040]"),v=new RegExp("^"+m.source+y.source+"*(?::"+m.source+y.source+"*)?$"),g=0,A=1,E=2,_=3,T=4,N=5,S=6,b=7;n.prototype={parse:function(e,t,n){var i=this.domBuilder;i.startDocument(),l(t,t={}),r(e,t,n,i,this.errorHandler),i.endDocument()}},f.prototype={setTagName:function(e){if(!v.test(e))throw new Error("invalid tagName:"+e);this.tagName=e},add:function(e,t,n){if(!v.test(e))throw new Error("invalid attribute:"+e);this[this.length++]={qName:e,value:t,offset:n}},length:0,getLocalName:function(e){return this[e].localName},getLocator:function(e){return this[e].locator},getQName:function(e){return this[e].qName},getURI:function(e){return this[e].uri},getValue:function(e){return this[e].value}},h({},h.prototype)instanceof h||(h=function(e,t){function n(){}n.prototype=t,n=new n;for(t in e)n[t]=e[t];return n}),t.XMLReader=n},function(e,t){function n(e,t){for(var n in e)t[n]=e[n]}function r(e,t){function r(){}var i=e.prototype;if(Object.create){var a=Object.create(t.prototype);i.__proto__=a}i instanceof t||(r.prototype=t.prototype,r=new r,n(i,r),e.prototype=i=r),i.constructor!=e&&("function"!=typeof e&&console.error("unknow Class:"+e),i.constructor=e)}function i(e,t){if(t instanceof Error)var n=t;else n=this,Error.call(this,ie[e]),this.message=ie[e],Error.captureStackTrace&&Error.captureStackTrace(this,i);return n.code=e,t&&(this.message=this.message+": "+t),n}function a(){}function o(e,t){this._node=e,this._refresh=t,s(this)}function s(e){var t=e._node._inc||e._node.ownerDocument._inc;if(e._inc!=t){var r=e._refresh(e._node);K(e,"length",r.length),n(r,e),e._inc=t}}function u(){}function l(e,t){for(var n=e.length;n--;)if(e[n]===t)return n}function p(e,t,n,r){if(r?t[l(t,r)]=n:t[t.length++]=n,e){n.ownerElement=e;var i=e.ownerDocument;i&&(r&&g(i,e,r),v(i,e,n))}}function c(e,t,n){var r=l(t,n);if(!(r>=0))throw i(oe,new Error(e.tagName+"@"+n));for(var a=t.length-1;a>r;)t[r]=t[++r];if(t.length=a,e){var o=e.ownerDocument;o&&(g(o,e,n),n.ownerElement=null)}}function f(e){if(this._features={},e)for(var t in e)this._features=e[t]}function h(){}function d(e){return"<"==e&&"&lt;"||">"==e&&"&gt;"||"&"==e&&"&amp;"||'"'==e&&"&quot;"||"&#"+e.charCodeAt()+";"}function m(e,t){if(t(e))return!0;if(e=e.firstChild)do if(m(e,t))return!0;while(e=e.nextSibling)}function y(){}function v(e,t,n){e&&e._inc++;var r=n.namespaceURI;"http://www.w3.org/2000/xmlns/"==r&&(t._nsMap[n.prefix?n.localName:""]=n.value)}function g(e,t,n,r){e&&e._inc++;var i=n.namespaceURI;"http://www.w3.org/2000/xmlns/"==i&&delete t._nsMap[n.prefix?n.localName:""]}function A(e,t,n){if(e&&e._inc){e._inc++;var r=t.childNodes;if(n)r[r.length++]=n;else{for(var i=t.firstChild,a=0;i;)r[a++]=i,i=i.nextSibling;r.length=a}}}function E(e,t){var n=t.previousSibling,r=t.nextSibling;return n?n.nextSibling=r:e.firstChild=r,r?r.previousSibling=n:e.lastChild=n,A(e.ownerDocument,e),t}function _(e,t,n){var r=t.parentNode;if(r&&r.removeChild(t),t.nodeType===te){var i=t.firstChild;if(null==i)return t;var a=t.lastChild}else i=a=t;var o=n?n.previousSibling:e.lastChild;i.previousSibling=o,a.nextSibling=n,o?o.nextSibling=i:e.firstChild=i,null==n?e.lastChild=a:n.previousSibling=a;do i.parentNode=e;while(i!==a&&(i=i.nextSibling));return A(e.ownerDocument||e,e),t.nodeType==te&&(t.firstChild=t.lastChild=null),t}function T(e,t){var n=t.parentNode;if(n){var r=e.lastChild;n.removeChild(t);var r=e.lastChild}var r=e.lastChild;return t.parentNode=e,t.previousSibling=r,t.nextSibling=null,r?r.nextSibling=t:e.firstChild=t,e.lastChild=t,A(e.ownerDocument,e,t),t}function N(){this._nsMap={}}function S(){}function b(){}function I(){}function R(){}function M(){}function w(){}function C(){}function L(){}function P(){}function O(){}function D(){}function U(){}function x(e,t){var n=[],r=9==this.nodeType?this.documentElement:this,i=r.prefix,a=r.namespaceURI;if(a&&null==i){var i=r.lookupPrefix(a);if(null==i)var o=[{namespace:a,prefix:null}]}return F(this,n,e,t,o),n.join("")}function k(e,t,n){var r=e.prefix||"",i=e.namespaceURI;if(!r&&!i)return!1;if("xml"===r&&"http://www.w3.org/XML/1998/namespace"===i||"http://www.w3.org/2000/xmlns/"==i)return!1;for(var a=n.length;a--;){var o=n[a];if(o.prefix==r)return o.namespace!=i}return!0}function F(e,t,n,r,i){if(r){if(e=r(e),!e)return;if("string"==typeof e)return void t.push(e)}switch(e.nodeType){case Y:i||(i=[]);var a=(i.length,e.attributes),o=a.length,s=e.firstChild,u=e.tagName;n=W===e.namespaceURI||n,t.push("<",u);for(var l=0;o>l;l++){var p=a.item(l);"xmlns"==p.prefix?i.push({prefix:p.localName,namespace:p.value}):"xmlns"==p.nodeName&&i.push({prefix:"",namespace:p.value})}for(var l=0;o>l;l++){var p=a.item(l);if(k(p,n,i)){var c=p.prefix||"",f=p.namespaceURI,h=c?" xmlns:"+c:" xmlns";t.push(h,'="',f,'"'),i.push({prefix:c,namespace:f})}F(p,t,n,r,i)}if(k(e,n,i)){var c=e.prefix||"",f=e.namespaceURI,h=c?" xmlns:"+c:" xmlns";t.push(h,'="',f,'"'),i.push({prefix:c,namespace:f})}if(s||n&&!/^(?:meta|link|img|br|hr|input)$/i.test(u)){if(t.push(">"),n&&/^script$/i.test(u))for(;s;)s.data?t.push(s.data):F(s,t,n,r,i),s=s.nextSibling;else for(;s;)F(s,t,n,r,i),s=s.nextSibling;t.push("</",u,">")}else t.push("/>");return;case Z:case te:for(var s=e.firstChild;s;)F(s,t,n,r,i),s=s.nextSibling;return;case q:return t.push(" ",e.name,'="',e.value.replace(/[<&"]/g,d),'"');case G:return t.push(e.data.replace(/[<&]/g,d));case X:return t.push("<![CDATA[",e.data,"]]>");case Q:return t.push("<!--",e.data,"-->");case ee:var m=e.publicId,y=e.systemId;if(t.push("<!DOCTYPE ",e.name),m)t.push(' PUBLIC "',m),y&&"."!=y&&t.push('" "',y),t.push('">');else if(y&&"."!=y)t.push(' SYSTEM "',y,'">');else{var v=e.internalSubset;v&&t.push(" [",v,"]"),t.push(">")}return;case J:return t.push("<?",e.target," ",e.data,"?>");case z:return t.push("&",e.nodeName,";");default:t.push("??",e.nodeName)}}function B(e,t,n){var r;switch(t.nodeType){case Y:r=t.cloneNode(!1),r.ownerDocument=e;case te:break;case q:n=!0}if(r||(r=t.cloneNode(!1)),r.ownerDocument=e,r.parentNode=null,n)for(var i=t.firstChild;i;)r.appendChild(B(e,i,n)),i=i.nextSibling;return r}function V(e,t,n){var r=new t.constructor;for(var i in t){var o=t[i];"object"!=typeof o&&o!=r[i]&&(r[i]=o)}switch(t.childNodes&&(r.childNodes=new a),r.ownerDocument=e,r.nodeType){case Y:var s=t.attributes,l=r.attributes=new u,p=s.length;l._ownerElement=r;for(var c=0;p>c;c++)r.setAttributeNode(V(e,s.item(c),!0));break;case q:n=!0}if(n)for(var f=t.firstChild;f;)r.appendChild(V(e,f,n)),f=f.nextSibling;return r}function K(e,t,n){e[t]=n}function j(e){switch(e.nodeType){case Y:case te:var t=[];for(e=e.firstChild;e;)7!==e.nodeType&&8!==e.nodeType&&t.push(j(e)),e=e.nextSibling;return t.join("");default:return e.nodeValue}}var W="http://www.w3.org/1999/xhtml",H={},Y=H.ELEMENT_NODE=1,q=H.ATTRIBUTE_NODE=2,G=H.TEXT_NODE=3,X=H.CDATA_SECTION_NODE=4,z=H.ENTITY_REFERENCE_NODE=5,$=H.ENTITY_NODE=6,J=H.PROCESSING_INSTRUCTION_NODE=7,Q=H.COMMENT_NODE=8,Z=H.DOCUMENT_NODE=9,ee=H.DOCUMENT_TYPE_NODE=10,te=H.DOCUMENT_FRAGMENT_NODE=11,ne=H.NOTATION_NODE=12,re={},ie={},ae=(re.INDEX_SIZE_ERR=(ie[1]="Index size error",1),re.DOMSTRING_SIZE_ERR=(ie[2]="DOMString size error",2),re.HIERARCHY_REQUEST_ERR=(ie[3]="Hierarchy request error",3)),oe=(re.WRONG_DOCUMENT_ERR=(ie[4]="Wrong document",4),re.INVALID_CHARACTER_ERR=(ie[5]="Invalid character",5),re.NO_DATA_ALLOWED_ERR=(ie[6]="No data allowed",6),re.NO_MODIFICATION_ALLOWED_ERR=(ie[7]="No modification allowed",7),re.NOT_FOUND_ERR=(ie[8]="Not found",8)),se=(re.NOT_SUPPORTED_ERR=(ie[9]="Not supported",9),re.INUSE_ATTRIBUTE_ERR=(ie[10]="Attribute in use",10));re.INVALID_STATE_ERR=(ie[11]="Invalid state",11),re.SYNTAX_ERR=(ie[12]="Syntax error",12),re.INVALID_MODIFICATION_ERR=(ie[13]="Invalid modification",13),re.NAMESPACE_ERR=(ie[14]="Invalid namespace",14),re.INVALID_ACCESS_ERR=(ie[15]="Invalid access",15),i.prototype=Error.prototype,n(re,i),a.prototype={length:0,item:function(e){return this[e]||null},toString:function(e,t){for(var n=[],r=0;r<this.length;r++)F(this[r],n,e,t);return n.join("")}},o.prototype.item=function(e){return s(this),this[e]},r(o,a),u.prototype={length:0,item:a.prototype.item,getNamedItem:function(e){for(var t=this.length;t--;){var n=this[t];if(n.nodeName==e)return n}},setNamedItem:function(e){var t=e.ownerElement;if(t&&t!=this._ownerElement)throw new i(se);var n=this.getNamedItem(e.nodeName);return p(this._ownerElement,this,e,n),n},setNamedItemNS:function(e){var t,n=e.ownerElement;if(n&&n!=this._ownerElement)throw new i(se);return t=this.getNamedItemNS(e.namespaceURI,e.localName),p(this._ownerElement,this,e,t),t},removeNamedItem:function(e){var t=this.getNamedItem(e);return c(this._ownerElement,this,t),t},removeNamedItemNS:function(e,t){var n=this.getNamedItemNS(e,t);return c(this._ownerElement,this,n),n},getNamedItemNS:function(e,t){for(var n=this.length;n--;){var r=this[n];if(r.localName==t&&r.namespaceURI==e)return r}return null}},f.prototype={hasFeature:function(e,t){var n=this._features[e.toLowerCase()];return!(!n||t&&!(t in n))},createDocument:function(e,t,n){var r=new y;if(r.implementation=this,r.childNodes=new a,r.doctype=n,n&&r.appendChild(n),t){var i=r.createElementNS(e,t);r.appendChild(i)}return r},createDocumentType:function(e,t,n){var r=new w;return r.name=e,r.nodeName=e,r.publicId=t,r.systemId=n,r}},h.prototype={firstChild:null,lastChild:null,previousSibling:null,nextSibling:null,attributes:null,parentNode:null,childNodes:null,ownerDocument:null,nodeValue:null,namespaceURI:null,prefix:null,localName:null,insertBefore:function(e,t){return _(this,e,t)},replaceChild:function(e,t){this.insertBefore(e,t),t&&this.removeChild(t)},removeChild:function(e){return E(this,e)},appendChild:function(e){return this.insertBefore(e,null)},hasChildNodes:function(){return null!=this.firstChild},cloneNode:function(e){return V(this.ownerDocument||this,this,e)},normalize:function(){for(var e=this.firstChild;e;){var t=e.nextSibling;t&&t.nodeType==G&&e.nodeType==G?(this.removeChild(t),e.appendData(t.data)):(e.normalize(),e=t)}},isSupported:function(e,t){return this.ownerDocument.implementation.hasFeature(e,t)},hasAttributes:function(){return this.attributes.length>0},lookupPrefix:function(e){for(var t=this;t;){var n=t._nsMap;if(n)for(var r in n)if(n[r]==e)return r;t=t.nodeType==q?t.ownerDocument:t.parentNode}return null},lookupNamespaceURI:function(e){for(var t=this;t;){var n=t._nsMap;if(n&&e in n)return n[e];t=t.nodeType==q?t.ownerDocument:t.parentNode}return null},isDefaultNamespace:function(e){var t=this.lookupPrefix(e);return null==t}},n(H,h),n(H,h.prototype),y.prototype={nodeName:"#document",nodeType:Z,doctype:null,documentElement:null,_inc:1,insertBefore:function(e,t){if(e.nodeType==te){for(var n=e.firstChild;n;){var r=n.nextSibling;this.insertBefore(n,t),n=r}return e}return null==this.documentElement&&e.nodeType==Y&&(this.documentElement=e),_(this,e,t),e.ownerDocument=this,e},removeChild:function(e){return this.documentElement==e&&(this.documentElement=null),E(this,e)},importNode:function(e,t){return B(this,e,t)},getElementById:function(e){var t=null;return m(this.documentElement,function(n){return n.nodeType==Y&&n.getAttribute("id")==e?(t=n,!0):void 0}),t},createElement:function(e){var t=new N;t.ownerDocument=this,t.nodeName=e,t.tagName=e,t.childNodes=new a;var n=t.attributes=new u;return n._ownerElement=t,t},createDocumentFragment:function(){var e=new O;return e.ownerDocument=this,e.childNodes=new a,e},createTextNode:function(e){var t=new I;return t.ownerDocument=this,t.appendData(e),t},createComment:function(e){var t=new R;return t.ownerDocument=this,t.appendData(e),t},createCDATASection:function(e){var t=new M;return t.ownerDocument=this,t.appendData(e),t},createProcessingInstruction:function(e,t){var n=new D;return n.ownerDocument=this,n.tagName=n.target=e,n.nodeValue=n.data=t,n},createAttribute:function(e){var t=new S;return t.ownerDocument=this,t.name=e,t.nodeName=e,t.localName=e,t.specified=!0,t},createEntityReference:function(e){var t=new P;return t.ownerDocument=this,t.nodeName=e,t},createElementNS:function(e,t){var n=new N,r=t.split(":"),i=n.attributes=new u;return n.childNodes=new a,n.ownerDocument=this,n.nodeName=t,n.tagName=t,n.namespaceURI=e,2==r.length?(n.prefix=r[0],n.localName=r[1]):n.localName=t,i._ownerElement=n,n},createAttributeNS:function(e,t){var n=new S,r=t.split(":");return n.ownerDocument=this,n.nodeName=t,n.name=t,n.namespaceURI=e,n.specified=!0,2==r.length?(n.prefix=r[0],n.localName=r[1]):n.localName=t,n}},r(y,h),N.prototype={nodeType:Y,hasAttribute:function(e){return null!=this.getAttributeNode(e)},getAttribute:function(e){var t=this.getAttributeNode(e);return t&&t.value||""},getAttributeNode:function(e){return this.attributes.getNamedItem(e)},setAttribute:function(e,t){var n=this.ownerDocument.createAttribute(e);n.value=n.nodeValue=""+t,this.setAttributeNode(n)},removeAttribute:function(e){var t=this.getAttributeNode(e);t&&this.removeAttributeNode(t)},appendChild:function(e){return e.nodeType===te?this.insertBefore(e,null):T(this,e)},setAttributeNode:function(e){return this.attributes.setNamedItem(e)},setAttributeNodeNS:function(e){return this.attributes.setNamedItemNS(e)},removeAttributeNode:function(e){return this.attributes.removeNamedItem(e.nodeName)},removeAttributeNS:function(e,t){var n=this.getAttributeNodeNS(e,t);n&&this.removeAttributeNode(n)},hasAttributeNS:function(e,t){return null!=this.getAttributeNodeNS(e,t)},getAttributeNS:function(e,t){var n=this.getAttributeNodeNS(e,t);return n&&n.value||""},setAttributeNS:function(e,t,n){var r=this.ownerDocument.createAttributeNS(e,t);r.value=r.nodeValue=""+n,this.setAttributeNode(r)},getAttributeNodeNS:function(e,t){return this.attributes.getNamedItemNS(e,t)},getElementsByTagName:function(e){return new o(this,function(t){var n=[];return m(t,function(r){r===t||r.nodeType!=Y||"*"!==e&&r.tagName!=e||n.push(r)}),n})},getElementsByTagNameNS:function(e,t){return new o(this,function(n){var r=[];return m(n,function(i){i===n||i.nodeType!==Y||"*"!==e&&i.namespaceURI!==e||"*"!==t&&i.localName!=t||r.push(i)}),r})}},y.prototype.getElementsByTagName=N.prototype.getElementsByTagName,y.prototype.getElementsByTagNameNS=N.prototype.getElementsByTagNameNS,r(N,h),S.prototype.nodeType=q,r(S,h),b.prototype={data:"",substringData:function(e,t){return this.data.substring(e,e+t)},appendData:function(e){e=this.data+e,this.nodeValue=this.data=e,this.length=e.length},insertData:function(e,t){this.replaceData(e,0,t)},appendChild:function(e){throw new Error(ie[ae])},deleteData:function(e,t){this.replaceData(e,t,"")},replaceData:function(e,t,n){var r=this.data.substring(0,e),i=this.data.substring(e+t);n=r+n+i,this.nodeValue=this.data=n,this.length=n.length}},r(b,h),I.prototype={nodeName:"#text",nodeType:G,splitText:function(e){var t=this.data,n=t.substring(e);t=t.substring(0,e),this.data=this.nodeValue=t,this.length=t.length;var r=this.ownerDocument.createTextNode(n);return this.parentNode&&this.parentNode.insertBefore(r,this.nextSibling),r}},r(I,b),R.prototype={nodeName:"#comment",nodeType:Q},r(R,b),M.prototype={nodeName:"#cdata-section",nodeType:X},r(M,b),w.prototype.nodeType=ee,r(w,h),C.prototype.nodeType=ne,r(C,h),L.prototype.nodeType=$,r(L,h),P.prototype.nodeType=z,r(P,h),O.prototype.nodeName="#document-fragment",O.prototype.nodeType=te,r(O,h),D.prototype.nodeType=J,r(D,h),U.prototype.serializeToString=function(e,t,n){return x.call(e,t,n)},h.prototype.toString=x;try{Object.defineProperty&&(Object.defineProperty(o.prototype,"length",{get:function(){return s(this),this.$$length}}),Object.defineProperty(h.prototype,"textContent",{get:function(){return j(this)},set:function(e){switch(this.nodeType){case Y:case te:for(;this.firstChild;)this.removeChild(this.firstChild);(e||String(e))&&this.appendChild(this.ownerDocument.createTextNode(e));break;default:this.data=e,this.value=e,this.nodeValue=e}}}),K=function(e,t,n){e["$$"+t]=n})}catch(e){}t.DOMImplementation=f,t.XMLSerializer=U},function(e,t,n){var r,i,a;!function(n,o){i=[e],r=o,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a))}(this,function(e){"use strict";function t(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function n(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t}function r(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}function i(e,t,n){var r=e.split(/\n|\r\n?|\f/),i=r[t-1],a=new Array(n).join(" ")+"^";return i+"\n"+a}function a(e){return e>="1"&&"9">=e}function o(e){return e>="0"&&"9">=e}function s(e){return o(e)||e>="a"&&"f">=e||e>="A"&&"F">=e}function u(e){return"e"===e||"E"===e}function l(e,t,n,r){var i=e.charAt(t);if("\r"===i)t++,n++,r=1,"\n"===e.charAt(t)&&t++;else if("\n"===i)t++,n++,r=1;else{if("	"!==i&&" "!==i)return null;t++,r++}return{index:t,line:n,column:r}}function p(e,t,n,r){var i=e.charAt(t);return i in R?{type:R[i],line:n,column:r+1,index:t+1,value:null}:null}function c(e,t,n,r){for(var i in M)if(M.hasOwnProperty(i)&&e.substr(t,i.length)===i){var a=M[i],o=a.type,s=a.value;return{type:o,line:n,column:r+i.length,index:t+i.length,value:s}}return null}function f(e,t,n,r){for(var i=t,a="",o=w._START_;t<e.length;){var u=e.charAt(t);switch(o){case w._START_:if('"'!==u)return null;o=w.START_QUOTE_OR_CHAR,t++;break;case w.START_QUOTE_OR_CHAR:if("\\"===u)o=w.ESCAPE,a+=u,t++;else{if('"'===u)return t++,{type:I.STRING,line:n,column:r+t-i,index:t,value:a};a+=u,t++}break;case w.ESCAPE:if(!(u in C))return null;if(a+=u,t++,"u"===u)for(var l=0;4>l;l++){var p=e.charAt(t);if(!p||!s(p))return null;a+=p,t++}o=w.START_QUOTE_OR_CHAR}}}function h(e,t,n,r){var i=t,s=t,l=L._START_;e:for(;t<e.length;){var p=e.charAt(t);switch(l){case L._START_:if("-"===p)l=L.MINUS;else if("0"===p)s=t+1,l=L.ZERO;else{if(!a(p))return null;s=t+1,l=L.DIGIT}break;case L.MINUS:if("0"===p)s=t+1,l=L.ZERO;else{if(!a(p))return null;s=t+1,l=L.DIGIT}break;case L.ZERO:if("."===p)l=L.POINT;else{if(!u(p))break e;l=L.EXP}break;case L.DIGIT:if(o(p))s=t+1;else if("."===p)l=L.POINT;else{if(!u(p))break e;l=L.EXP}break;case L.POINT:if(!o(p))break e;s=t+1,l=L.DIGIT_FRACTION;break;case L.DIGIT_FRACTION:if(o(p))s=t+1;else{if(!u(p))break e;l=L.EXP}break;case L.EXP:if("+"===p||"-"===p)l=L.EXP_DIGIT_OR_SIGN;else{if(!o(p))break e;s=t+1,l=L.EXP_DIGIT_OR_SIGN}break;case L.EXP_DIGIT_OR_SIGN:if(!o(p))break e;s=t+1}t++}return s>0?{type:I.NUMBER,line:n,column:r+s-i,index:s,value:parseFloat(e.substring(i,s))}:null}function d(e,t){for(var n=1,r=1,i=0,a=[];i<e.length;){var o=[e,i,n,r],s=l.apply(void 0,o);if(s)i=s.index,n=s.line,r=s.column;else{var u=p.apply(void 0,o)||c.apply(void 0,o)||f.apply(void 0,o)||h.apply(void 0,o);if(u){var d={type:u.type,value:u.value,loc:_(n,r,i,u.line,u.column,u.index,t.source)};a.push(d),i=u.index,n=u.line,r=u.column}else N(b.cannotTokenizeSymbol(e.charAt(i),n,r),e,n,r)}}return a}function m(e,t,n,r){for(var i=void 0,a={type:"object",children:[]},o=O._START_;n<t.length;){var s=t[n];switch(o){case O._START_:if(s.type!==I.LEFT_BRACE)return null;i=s,o=O.OPEN_OBJECT,n++;break;case O.OPEN_OBJECT:if(s.type===I.RIGHT_BRACE)return r.verbose&&(a.loc=_(i.loc.start.line,i.loc.start.column,i.loc.start.offset,s.loc.end.line,s.loc.end.column,s.loc.end.offset,r.source)),{value:a,index:n+1};var u=y(e,t,n,r);a.children.push(u.value),o=O.PROPERTY,n=u.index;break;case O.PROPERTY:if(s.type===I.RIGHT_BRACE)return r.verbose&&(a.loc=_(i.loc.start.line,i.loc.start.column,i.loc.start.offset,s.loc.end.line,s.loc.end.column,s.loc.end.offset,r.source)),{value:a,index:n+1};s.type===I.COMMA?(o=O.COMMA,n++):N(S.unexpectedToken(e.substring(s.loc.start.offset,s.loc.end.offset),s.loc.start.line,s.loc.start.column),e,s.loc.start.line,s.loc.start.column);break;case O.COMMA:var l=y(e,t,n,r);l?(n=l.index,a.children.push(l.value),o=O.PROPERTY):N(S.unexpectedToken(e.substring(s.loc.start.offset,s.loc.end.offset),s.loc.start.line,s.loc.start.column),e,s.loc.start.line,s.loc.start.column)}}N(S.unexpectedEnd())}function y(e,t,n,r){for(var i=void 0,a={type:"property",key:null,value:null},o=O._START_;n<t.length;){var s=t[n];switch(o){case D._START_:if(s.type!==I.STRING)return null;var u={type:"identifier",value:s.value};r.verbose&&(u.loc=s.loc),i=s,a.key=u,o=D.KEY,n++;break;case D.KEY:s.type===I.COLON?(o=D.COLON,n++):N(S.unexpectedToken(e.substring(s.loc.start.offset,s.loc.end.offset),s.loc.start.line,s.loc.start.column),e,s.loc.start.line,s.loc.start.column);break;case D.COLON:var l=A(e,t,n,r);return a.value=l.value,r.verbose&&(a.loc=_(i.loc.start.line,i.loc.start.column,i.loc.start.offset,l.value.loc.end.line,l.value.loc.end.column,l.value.loc.end.offset,r.source)),{value:a,index:l.index}}}}function v(e,t,n,r){for(var i=void 0,a={type:"array",children:[]},o=U._START_,s=void 0;n<t.length;)switch(s=t[n],o){case U._START_:if(s.type!==I.LEFT_BRACKET)return null;i=s,o=U.OPEN_ARRAY,n++;break;case U.OPEN_ARRAY:if(s.type===I.RIGHT_BRACKET)return r.verbose&&(a.loc=_(i.loc.start.line,i.loc.start.column,i.loc.start.offset,s.loc.end.line,s.loc.end.column,s.loc.end.offset,r.source)),{value:a,index:n+1};var u=A(e,t,n,r);n=u.index,a.children.push(u.value),o=U.VALUE;break;case U.VALUE:if(s.type===I.RIGHT_BRACKET)return r.verbose&&(a.loc=_(i.loc.start.line,i.loc.start.column,i.loc.start.offset,s.loc.end.line,s.loc.end.column,s.loc.end.offset,r.source)),n++,{value:a,index:n};s.type===I.COMMA?(o=U.COMMA,n++):N(S.unexpectedToken(e.substring(s.loc.start.offset,s.loc.end.offset),s.loc.start.line,s.loc.start.column),e,s.loc.start.line,s.loc.start.column);break;case U.COMMA:var l=A(e,t,n,r);n=l.index,a.children.push(l.value),o=U.VALUE}N(S.unexpectedEnd())}function g(e,t,n,r){var i=t[n],a=-1!==P.indexOf(i.type);if(a){var o={type:"literal",value:i.value,rawValue:e.substring(i.loc.start.offset,i.loc.end.offset)};return r.verbose&&(o.loc=i.loc),{value:o,index:n+1}}return null}function A(e,t,n,r){var i=t[n],a=g.apply(void 0,arguments)||m.apply(void 0,arguments)||v.apply(void 0,arguments);return a?a:void N(S.unexpectedToken(e.substring(i.loc.start.offset,i.loc.end.offset),i.loc.start.line,i.loc.start.column),e,i.loc.start.line,i.loc.start.column)}var E=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},_=function(e,t,n,r,i,a,o){return{start:{line:e,column:t,offset:n},end:{line:r,column:i,offset:a},source:o||null}},T=function(e){function a(e,r,o,s){t(this,a);var u=o?e+"\n"+i(r,o,s):e,l=n(this,Object.getPrototypeOf(a).call(this,u));return l.rawMessage=e,l}return r(a,e),a}(SyntaxError),N=function(e,t,n,r){throw new T(e,t,n,r)},S={unexpectedEnd:function(){return"Unexpected end of JSON input"},unexpectedToken:function(e,t,n){return"Unexpected token <"+e+"> at "+t+":"+n}},b={cannotTokenizeSymbol:function(e,t,n){return"Cannot tokenize symbol <"+e+"> at "+t+":"+n}},I={LEFT_BRACE:0,RIGHT_BRACE:1,LEFT_BRACKET:2,RIGHT_BRACKET:3,COLON:4,COMMA:5,STRING:6,NUMBER:7,TRUE:8,FALSE:9,NULL:10},R={"{":I.LEFT_BRACE,"}":I.RIGHT_BRACE,"[":I.LEFT_BRACKET,"]":I.RIGHT_BRACKET,":":I.COLON,",":I.COMMA},M={"true":{type:I.TRUE,value:!0},"false":{type:I.FALSE,value:!1},"null":{type:I.NULL,value:null}},w={_START_:0,START_QUOTE_OR_CHAR:1,ESCAPE:2},C={'"':0,"\\":1,"/":2,b:3,f:4,n:5,r:6,t:7,u:8},L={_START_:0,MINUS:1,ZERO:2,DIGIT:3,POINT:4,DIGIT_FRACTION:5,EXP:6,EXP_DIGIT_OR_SIGN:7},P=[I.STRING,I.NUMBER,I.TRUE,I.FALSE,I.NULL],O={_START_:0,OPEN_OBJECT:1,PROPERTY:2,COMMA:3},D={_START_:0,KEY:1,COLON:2},U={_START_:0,OPEN_ARRAY:1,VALUE:2,COMMA:3},x={verbose:!0,source:null},k=function(e,t){t=E({},x,t);var n=d(e,t);0===n.length&&N(S.unexpectedEnd());var r=A(e,n,0,t);if(r.index===n.length)return r.value;var i=n[r.index];N(S.unexpectedToken(e.substring(i.loc.start.offset,i.loc.end.offset),i.loc.start.line,i.loc.start.column),e,i.loc.start.line,i.loc.start.column)};e.exports=k})},function(e,t,n){!function(){function t(e,t){Array.isArray(e)||(e=[e]);for(var n=!!t,r=[],i=0;i<e.length;i++){var a=e[i];"object"==typeof a?(r.push(a),n=!0):r.push({type:a})}return n&&r}function n(e){if(e.type)if("string"!=typeof e.type){var r=t(e.type);r&&(e.anyOf=r,delete e.type)}else"any"==e.type&&delete e.type;if(e["extends"]){var i=e["extends"];Array.isArray(i)||(i=[i]),e.allOf=i,delete e["extends"]}if(e.disallow&&("string"==typeof e.disallow?e.not={type:e.disallow}:e.not={anyOf:t(e.disallow,!0)},delete e.disallow),e.properties){var a=Array.isArray(e.required)?e.required:[];for(var o in e.properties){var s=e.properties[o];s&&"boolean"==typeof s.required&&(s.required&&a.push(o),delete s.required)}a.length&&(e.required=a)}if(e.dependencies)for(var o in e.dependencies)"string"==typeof e.dependencies[o]&&(e.dependencies[o]=[e.dependencies[o]]);"boolean"==typeof e.required&&delete e.required,"undefined"!=typeof e.divisibleBy&&(e.multipleOf=e.divisibleBy,delete e.divisibleBy);for(var o in e)if("properties"===o||"patternProperties"===o||"dependencies"===o)for(var u in e[o])e[o][u]=n(e[o][u]);else if("enum"!==o)if(Array.isArray(e[o]))for(var l=0;l<e[o].length;l++)e[o][l]=n(e[o][l]);else"object"==typeof e[o]&&(e[o]=n(e[o]));return e}var r={v4:n};return e.exports=r,r}()},function(e,t){(function(e){"use strict";function n(){var t=e.ramlValidation;if(t){var n=t.typeValidators;if(Array.isArray(n))return n}return[]}function r(){var t=e.ramlValidation;if(t){var n=t.typesystemAnnotationValidators;if(Array.isArray(n))return n}return[]}Object.defineProperty(t,"__esModule",{value:!0}),t.REPEAT="repeat",t.PARSE_ERROR="parseError",t.TOP_LEVEL_EXTRA="topLevel",t.DEFINED_IN_TYPES_EXTRA="definedInTypes",t.USER_DEFINED_EXTRA="USER_DEFINED",t.SOURCE_EXTRA="SOURCE",t.SCHEMA_AND_TYPE_EXTRA="SCHEMA",t.GLOBAL_EXTRA="GLOBAL",t.HAS_FACETS="HAS_FACETS",t.HAS_ITEMS="HAS_ITEMS";var i;!function(e){e[e.Description=0]="Description",e[e.NotScalar=1]="NotScalar",e[e.ImportedByChain=2]="ImportedByChain",e[e.AcceptAllScalarsAsStrings=3]="AcceptAllScalarsAsStrings",e[e.SkipValidation=4]="SkipValidation",e[e.DisplayName=5]="DisplayName",e[e.Usage=6]="Usage",e[e.Annotation=7]="Annotation",e[e.FacetDeclaration=8]="FacetDeclaration",e[e.CustomFacet=9]="CustomFacet",e[e.Example=10]="Example",e[e.Required=11]="Required",e[e.HasPropertiesFacet=12]="HasPropertiesFacet",e[e.AllowedTargets=13]="AllowedTargets",e[e.Examples=14]="Examples",e[e.XMLInfo=15]="XMLInfo",e[e.Default=16]="Default",e[e.Constraint=17]="Constraint",e[e.Modifier=18]="Modifier",e[e.Discriminator=19]="Discriminator",e[e.DiscriminatorValue=20]="DiscriminatorValue"}(i=t.MetaInformationKind||(t.MetaInformationKind={})),t.getTypeValidationPlugins=n,t.getAnnotationValidationPlugins=r}).call(t,function(){return this}())},function(e,t){e.exports={12:{code:"12",message:""},24:{code:"24",message:""},25:{code:"25",message:""},SCHEMA_AND_TYPE:{code:"SCHEMA_AND_TYPE",message:"'schema' and 'type' are mutually exclusive"},REQUIRED_OVERRIDE_OPTIONAL:{code:"REQUIRED_OVERRIDE_OPTIONAL",message:"Can not override required property '{{propertyName}}' to be optional"},CYCLIC_DEPENDENCY:{code:"CYCLIC_DEPENDENCY",message:"'{{typeName}}' has cyclic dependency"},REDEFINIG_BUILDTIN:{code:"REDEFINIG_BUILDTIN",message:"Redefining a built in type: {{typeName}}"},RECURRENT_DEFINITION:{code:"RECURRENT_DEFINITION",message:"Recurrent type definition"},INHERITING_UNKNOWN_TYPE:{code:"INHERITING_UNKNOWN_TYPE",message:"Inheriting from unknown type"},INHERITING_TYPE_IMPORTED_THROUGH_LIBRARY_CHAIN:{code:"INHERITING_TYPE_IMPORTED_THROUGH_LIBRARY_CHAIN",message:"Inheriting the '{{typeName}}' type imported through a library chain. Library chaining is not allowed."},RECURRENT_UNION_OPTION:{code:"RECURRENT_UNION_OPTION",message:"Recurrent type as an option of union type"},UNKNOWN_UNION_OPTION:{code:"UNKNOWN_UNION_OPTION",message:"Unknown type as an option of union type"},UNION_OPTION_TYPE_OPTION_IMPORTED_THROUGH_LIBRARY_CHAIN:{code:"UNION_OPTION_TYPE_OPTION_IMPORTED_THROUGH_LIBRARY_CHAIN",message:"Union type option '{{typeName}}' imported through a library chain. Library chaining is not allowed."},UNION_OPTION_TYPE_DEPENDS_ON_TYPE_IMPORTED_THROUGH_LIBRARY_CHAIN:{code:"UNION_OPTION_TYPE_OPTION_DEPENDS_ON_TYPE_IMPORTED_THROUGH_LIBRARY_CHAIN",message:"Union type depends on '{{typeName}}' type imported through a library chain. Library chaining is not allowed."},RECURRENT_ARRAY_DEFINITION:{code:"RECURRENT_ARRAY_DEFINITION",message:"Recurrent array type definition"},UNKNOWN_ARRAY_COMPONENT_TYPE:{code:"UNKNOWN_ARRAY_COMPONENT",message:"Referring to unknown type '{{componentTypeName}}' as an array component type"},ARRAY_COMPONENT_TYPE_IMPORTED_THROUGH_LIBRARY_CHAIN:{code:"ARRAY_COMPONENT_TYPE_IMPORTED_THROUGH_LIBRARY_CHAIN",message:"Array component type '{{componentTypeName}}' imported through a library chain. Library chaining is not allowed."},ARRAY_COMPONENT_TYPE_DEPENDES_ON_TYPE_IMPORTED_THROUGH_LIBRARY_CHAIN:{code:"ARRAY_COMPONENT_TYPE_DEPENDES_ON_TYPE_IMPORTED_THROUGH_LIBRARY_CHAIN",message:"Array component type '{{componentTypeName}}' inherits the '{{typeName}}' type imported through a library chain. Library chaining is not allowed."},EXTERNALS_MIX:{code:"EXTERNALS_MIX",message:"It is not allowed to mix RAML types with externals"},EXTERNAL_FACET:{code:"EXTERNAL_FACET",message:"External types can not declare facet '{{name}}'"},OVERRIDE_FACET:{code:"OVERRIDE_FACET",message:"Facet '{{name}}' can not be overriden"},OVERRIDE_BUILTIN_FACET:{code:"OVERRIDE_BUILTIN_FACET",message:"Built in facet '{{name}}' can not be overriden"},FACET_START_BRACKET:{code:"FACET_START_BRACKET",message:"Facet '{{name}}' can not start from '('"},FACET_PROHIBITED_FOR_EXTERNALS:{code:"FACET_PROHIBITED_FOR_EXTERNALS",message:"'{{facetName}}' facet is prohibited for external types"},UNKNOWN_FACET:{code:"UNKNOWN_FACET",message:"Specifying unknown facet: '{{facetName}}'"},MISSING_REQUIRED_FACETS:{code:"MISSING_REQUIRED_FACETS",message:"Missing required facets: {{facetsList}}"},OBJECT_EXPECTED:{code:"OBJECT_EXPECTED",message:"object is expected"},NULL_NOT_ALLOWED:{code:"NULL_NOT_ALLOWED",message:"Null or undefined value is not allowed"},DISCRIMINATOR_NEEDED:{code:"DISCRIMINATOR_NEEDED",message:"Can not discriminate types '{{name1}}' and '{{name2}}' without discriminator"},SAME_DISCRIMINATOR_VALUE:{code:"SAME_DISCRIMINATOR_VALUE",message:"Types '{{name1}}' and '{{name2}}' have same discriminator value"},NOTHING:{code:"NOTHING",message:"nothing"},TYPE_EXPECTED:{code:"TYPE_EXPECTED",message:"Expected type '{{expectedType}}' but got '{{actualType}}'"},INTEGER_EXPECTED:{code:"INTEGER_EXPECTED",message:"integer is expected"},NULL_EXPECTED:{code:"NULL_EXPECTED",message:"null is expected"},SCALAR_EXPECTED:{code:"SCALAR_EXPECTED",message:"scalar is expected"},INCORRECT_DISCRIMINATOR:{code:"INCORRECT_DISCRIMINATOR",message:"None of the '{{rootType}}' type known subtypes declare '{{value}}' as value of discriminating property '{{propName}}'."
},MISSING_DISCRIMINATOR:{code:"MISSING_DISCRIMINATOR",message:"Instance of '{{rootType}}' subtype misses value of the discriminating property '{{propName}}'."},INVALID_DATEONLY:{code:"INVALID_DATEONLY",message:"'date-only' instance should match 'yyyy-mm-dd' pattern"},INVALID_TIMEONLY:{code:"INVALID_TIMEONLY",message:"'time-only' instance should match 'hh:mm:ss[.ff...]' pattern"},INVALID_DATETIMEONLY:{code:"INVALID_DATETIMEONLY",message:"'datetime-only' instance should match 'yyyy-mm-ddThh:mm:ss[.ff...]' pattern"},INVALID_RFC3339:{code:"INVALID_RFC3339",message:"Valid rfc3339 formatted string is expected"},INVALID_RFC2616:{code:"INVALID_RFC2616",message:"Valid rfc2616 formatted string is expected"},INVALID_DATTIME:{code:"INVALID_DATTIME",message:"Valid datetime formatted string is expected"},UNKNOWN_ANNOTATION_TYPE:{code:"UNKNOWN_ANNOTATION_TYPE",message:"Using unknown annotation type: '{{typeName}}'"},LIBRARY_CHAINIG_IN_ANNOTATION_TYPE:{code:"LIBRARY_CHAINIG_IN_ANNOTATION_TYPE",message:"Annotation type '{{typeName}}' imported through a library chain. Library chainig is not allowed."},LIBRARY_CHAINIG_IN_ANNOTATION_TYPE_SUPERTYPE:{code:"LIBRARY_CHAINIG_IN_ANNOTATION_TYPE_SUPERTYPE",message:"Annotation type '{{typeName}}' depends on '{{chainedType}}' imported through a library chain. Library chainig is not allowed."},INVALID_ANNOTATION_VALUE:{code:"INVALID_ANNOTATION_VALUE",message:"Invalid annotation value {{msg}}"},CAN_NOT_PARSE_JSON:{code:"CAN_NOT_PARSE_JSON",message:"Can not parse JSON example: {{msg}}"},INVALID_XML:{code:"INVALID_XML",message:"Invalid XML."},STRICT_BOOLEAN:{code:"STRICT_BOOLEAN",message:"'strict' should be boolean"},DISPLAY_NAME_STRING:{code:"DISPLAY_NAME_STRING",message:"'displayName' should be string"},DESCRIPTION_STRING:{code:"DESCRIPTION_STRING",message:"'description' should be string"},INVALID_EXMAPLE:{code:"INVALID_EXMAPLE",message:"Using invalid 'example': {{msg}}"},ADDITIONAL_PROPERTIES_BOOLEAN:{code:"REQUIRED_BOOLEAN",message:"Value of 'additionalProperties' facet should be boolean"},REQUIRED_BOOLEAN:{code:"REQUIRED_BOOLEAN",message:"Value of 'required' facet should be boolean"},UNIQUE_ITEMS_BOOLEAN:{code:"UNIQUE_ITEMS_BOOLEAN",message:"Value of 'uniqueItems' facet should be boolean"},EXMAPLES_MAP:{code:"EXMAPLES_MAP",message:"'examples' value should be a map"},INVALID_DEFAULT_VALUE:{code:"INVALID_DEFAULT_VALUE",message:"Using invalid 'defaultValue': {{msg}}"},DISCRIMINATOR_FOR_UNION:{code:"DISCRIMINATOR_FOR_UNION",message:"You can not specify 'discriminator' for union types"},DISCRIMINATOR_FOR_OBJECT:{code:"DISCRIMINATOR_FOR_OBJECT",message:"You only can use 'discriminator' with object types"},DISCRIMINATOR_FOR_INLINE:{code:"DISCRIMINATOR_FOR_INLINE",message:"You can not specify 'discriminator' for inline type declarations"},UNKNOWN_FOR_DISCRIMINATOR:{code:"UNKNOWN_FOR_DISCRIMINATOR",message:"Using unknown property '{{value}}' as discriminator"},SCALAR_FOR_DISCRIMINATOR:{code:"SCALAR_FOR_DISCRIMINATOR",message:"It is only allowed to use scalar properties as discriminators"},DISCRIMINATOR_VALUE_WITHOUT_DISCRIMINATOR:{code:"DISCRIMINATOR_VALUE_WITHOUT_DISCRIMINATOR",message:"You can not use 'discriminatorValue' without declaring 'discriminator'"},INVALID_DISCRIMINATOR_VALUE:{code:"INVALID_DISCRIMINATOR_VALUE",message:"Using invalid 'disciminatorValue': {{msg}}"},PROPERTIES_MAP:{code:"PROPERTIES_MAP",message:"'properties' should be a map"},FACETS_MAP:{code:"FACETS_MAP",message:"'facets' should be a map"},VALIDATING_AGAINST_UNKNOWN:{code:"VALIDATING_AGAINST_UNKNOWN",message:"Validating instance against unknown type: '{{typeName}}'"},EXTERNAL_IN_PROPERTY_DEFINITION:{code:"EXTERNAL_IN_PROPERTY_DEFINITION",message:"It is not allowed to use external types in property definitions"},EXTERNAL_IN_FACET_DEFINITION:{code:"EXTERNAL_IN_FACET_DEFINITION",message:"It is not allowed to use external types in facet definitions"},UNKNOWN_IN_PROPERTY_DEFINITION:{code:"UNKNOWN_IN_PROPERTY_DEFINITION",message:"Property '{{propName}}' refers to unknown type '{{typeName}}'"},LIBRARY_CHAINIG_IN_PROPERTY_TYPE:{code:"LIBRARY_CHAINIG_IN_PROPERTY_TYPE",message:"Property '{{propName}}' refers to type '{{typeName}}' imported through a library chain. Library chainig is not allowed."},LIBRARY_CHAINIG_IN_PROPERTY_TYPE_SUPERTYPE:{code:"LIBRARY_CHAINIG_IN_PROPERTY_TYPE_SUPERTYPE",message:"Property '{{propName}}' type depends on '{{typeName}}' type imported through a library chain. Library chainig is not allowed."},UNKNOWN_IN_FACET_DEFINITION:{code:"UNKNOWN_IN_FACET_DEFINITION",message:"Facet '{{facetName}}' refers to unknown type '{{typeName}}'"},LIBRARY_CHAINIG_IN_FACET_TYPE:{code:"LIBRARY_CHAINIG_IN_FACET_TYPE",message:"Facet '{{propName}}' refers to type '{{typeName}}' imported through a library chain. Library chainig is not allowed."},LIBRARY_CHAINIG_IN_FACET_TYPE_SUPERTYPE:{code:"LIBRARY_CHAINIG_IN_FACET_TYPE_SUPERTYPE",message:"Facet '{{propName}}' type depends on '{{typeName}}' type imported through a library chain. Library chainig is not allowed."},ERROR_IN_RANGE:{code:"ERROR_IN_RANGE",message:"Property '{{propName}}' range type has error: {{msg}}"},ERROR_IN_FACET_RANGE:{code:"ERROR_IN_FACET_RANGE",message:"Facet '{{facetName}}' range type has error: {{msg}}"},INCORRECT_SCHEMA:{code:"INCORRECT_SCHEMA",message:"Incorrect schema: {{msg}}"},UNABLE_TO_VALIDATE_XML:{code:"UNABLE_TO_VALIDATE_XML",message:"Unable to validate example against schema (xmllint)"},CIRCULAR_REFS_IN_JSON_SCHEMA:{code:"CIRCULAR_REFS_IN_JSON_SCHEMA",message:"JSON schema contains circular references"},EXAMPLE_SCHEMA_FAILURE:{code:"EXAMPLE_SCHEMA_FAILURE",message:"Example does not conform to schema: {{msg}}"},JOSN_EXAMPLE_VALIDATION_EXCEPTION:{code:"JOSN_EXAMPLE_VALIDATION_EXCEPTION",message:"Validating example against schema caused an exception: {{msg}}"},UNKNOWN_PROPERTY:{code:"UNKNOWN_PROPERTY",message:"Unknown property: '{{propName}}'"},REQUIRED_PROPERTY_MISSING:{code:"REQUIRED_PROPERTY_MISSING",message:"Required property '{{propName}}' is missing"},INVALID_REGEXP:{code:"INVALID_REGEXP",message:"{{msg}}"},FACET_USAGE_RESTRICTION:{code:"FACET_USAGE_RESTRICTION",message:"{{facetName}} facet can only be used with {{typeNames}} types"},FACET_REQUIRE_NUMBER:{code:"FACET_REQUIRE_NUMBER",message:"'{{facetName}}' value should be a number"},FACET_REQUIRE_INTEGER:{code:"FACET_REQUIRE_INTEGER",message:"'{{facetName}}' value should be an integer"},MIN_VALUE:{code:"MIN_VALUE",message:"'{{facetName}}' value should be at least {{minValue}}"},EVEN_RATIO:{code:"EVEN_RATIO",message:"result of division of {{val1}} on {{val2}} should be integer"},MUST_BE_UNIQUE:{code:"MUST_BE_UNIQUE",message:"items should be unique"},ARRAY_AGAINST_UNKNOWN:{code:"ARRAY_AGAINST_UNKNOWN",message:"Array instance is validated against unknown type: '{{typeName}}'"},INVALID_COMPONENT_TYPE:{code:"INVALID_COMPONENT_TYPE",message:"Component type has error: {{msg}}"},EXTERNAL_AS_COMPONENT:{code:"EXTERNAL_AS_COMPONENT",message:"It is not allowed to use external types in component type definitions"},PATTERN_VIOLATION:{code:"PATTERN_VIOLATION",message:"String should match to '{{value}}'"},ALLOWED_FORMAT_VALUES:{code:"ALLOWED_FORMAT_VALUES",message:"Following format values are allowed: {{allowedValues}}"},ENUM_RESTRICTION:{code:"ENUM_RESTRICTION",message:"value should be one of: {{values}}"},ENUM_OWNER_TYPES:{code:"ENUM_OWNER_TYPES",message:"'enum' facet can only be used with: {{typeNames}}"},ENUM_ARRAY:{code:"ENUM_ARRAY",message:"'enum' facet value must be defined by array"},RESTRICTIONS_CONFLICT:{code:"RESTRICTIONS_CONFLICT",message:null},MINMAX_RESTRICTION_VIOLATION:{code:"MINMAX_RESTRICTION_VIOLATION",message:null},UNION_TYPE_FAILURE:{code:"UNION_TYPE_FAILURE",message:"Union type options do not pass validation"},UNION_TYPE_FAILURE_DETAILS:{code:"UNION_TYPE_FAILURE_DETAILS",message:"Union type option does not pass validation ({{msg}})"},INVALID_JSON_SCHEMA_DETAILS:{code:"INVALID_JSON_SCHEMA_DETAILS",message:"Invalid JSON schema: {{msg}}"},INVALID_JSON_SCHEMA:{code:"INVALID_JSON_SCHEMA",message:"Invalid JSON schema"},JSON_SCHEMA_VALIDATION_EXCEPTION:{code:"JSON_SCHEMA_VALIDATION_EXCEPTION",message:"Schema validation exception: {{msg}}"},REFERENCE_NOT_FOUND:{code:"REFERENCE_NOT_FOUND",message:"Reference not found: {{ref}}"},INVALID_XML_SCHEMA:{code:"INVALID_XML_SCHEMA",message:"Invalid XML schema content"},INVALID_ANNOTATION_LOCATION:{code:"INVALID_ANNOTATION_LOCATION",message:"Annotation '{{aName}}' can not be placed at this location, allowed targets are: {{aValues}}"},CONTENT_DOES_NOT_MATCH_THE_SCHEMA:{code:"CONTENT_DOES_NOT_MATCH_THE_SCHEMA",message:"Content is not valid according to schema: {{msg}}"},EXTERNAL_TYPE_ERROR:{code:"EXTERNAL_TYPE_ERROR",message:"Referenced type '{{typeName}}' does not match '{{objectName}}' root node"},CAN_NOT_PARSE_SCHEMA:{code:"CAN_NOT_PARSE_SCHEMA",message:"Can not parse schema"},FILE_TYPES_SHOULD_BE_AN_ARRAY:{code:"FILE_TYPES_SHOULD_BE_AN_ARRAY",message:"'fileTypes' value should be an array of strings"},FACET_CAN_NOT_BE_FIXED_BY_THE_DECLARING_TYPE:{code:"FACET_CAN_NOT_BE_FIXED_BY_THE_DECLARING_TYPE",message:"A facet  can not be fixed by the declaring type"},ITEMS_SHOULD_BE_REFERENCE_OR_INLINE_TYPE:{code:"ITEMS_SHOULD_BE_REFERENCE_OR_INLINE_TYPE",message:"The 'items' property value should be either a reference to an existing type or an inline type declaration"},VALUE_SHOULD_BE_POSITIVE:{code:"VALUE_SHOULD_BE_POSITIVE",message:"Value of the '{{facetName}}' facet should be positive"},PLUGIN_REPORTS_AN_ERROR:{code:"PLUGIN_REPORTS_AN_ERROR",message:"The {{pluginId}} plugin reports an error"},MESSAGE_PARAMETER_NO_VALUE:{code:"MESSAGE_PARAMETER_NO_VALUE",message:"Message parameter '{{paramName}}' has no value specified."},VALIDATE_ONLY_ON_RUNTIME_TYPES_INSTANCES:{code:"VALIDATE_ONLY_ON_RUNTIME_TYPES_INSTANCES",message:"Validate can be used only on runtime types instances"},SHOULD_BE_ALREADY_OWNED:{code:"SHOULD_BE_ALREADY_OWNED",message:"Should be already owned by this"},ALREADY_INCLUDED:{code:"ALREADY_INCLUDED",message:"Already included"},SHOULD_BE_NEVER_CALLED:{code:"SHOULD_BE_NEVER_CALLED",message:"Should be never called"},VALUE_SHOULD_NOT_BE_MORE:{code:"VALUE_SHOULD_NOT_BE_MORE",message:"value should not be more than"},VALUE_SHOULD_NOT_BE_LESS:{code:"VALUE_SHOULD_NOT_BE_LESS",message:"value should not be less than"},ARRAY_ITEMS_COUNT_SHOULD_NOT_BE_MORE:{code:"ARRAY_ITEMS_COUNT_SHOULD_NOT_BE_MORE",message:"array items count should not be more than"},ARRAY_ITEMS_COUNT_SHOULD_NOT_BE_LESS:{code:"ARRAY_ITEMS_COUNT_SHOULD_NOT_BE_LESS",message:"array items count should not be less than"},STRING_SHOULD_NOT_BE_MORE:{code:"STRING_SHOULD_NOT_BE_MORE",message:"string length should not be more than"},STRING_SHOULD_NOT_BE_LESS:{code:"STRING_SHOULD_NOT_BE_LESS",message:"string length should not be less than"},OBJECT_PROPERTIES_SHOULD_NOT_BE_MORE:{code:"OBJECT_PROPERTIES_SHOULD_NOT_BE_MORE",message:"object properties count should not be more than"},OBJECT_PROPERTIES_SHOULD_NOT_BE_LESS:{code:"OBJECT_PROPERTIES_SHOULD_NOT_BE_LESS",message:"object properties count should not be less than"},ITEMS_SHOULD_BE_OF_TYPE:{code:"ITEMS_SHOULD_BE_OF_TYPE",message:"items should be of type {{type}}"},RESTRICTIONS_CANNT_BE_COMPOSED:{code:"RESTRICTIONS_CANNT_BE_COMPOSED",message:"{{name}} can not be composed at one type"},SHOULD_PASS_REXEXP:{code:"SHOULD_PASS_REXEXP",message:"should pass reg exp:{{rexexp}}"},NO_COMMON_FILE_TYPES:{code:"NO_COMMON_FILE_TYPES",message:"no common file types"},INVALID_FILETYPES_FACET_VALUE:{code:"INVALID_FILETYPES_FACET_VALUE",message:"invalid 'fileTypes' facet value"},SUPPORTED_FILE_TYPES:{code:"SUPPORTED_FILE_TYPES",message:"supported file types: {{types}}"},SHOULD_BE_SCALAR:{code:"SHOULD_BE_SCALAR",message:"should be scalar"}}},function(e,t,n){"use strict";function r(){return I.length>0?I[I.length-1]:null}function i(e){for(var t;e;)t=e.owner(),e=t instanceof c.InheritedType?t.contextMeta():null;I.push(t)}function a(e){for(void 0===e&&(e=0);I.length>e;)I.pop()}function o(){return I.length}function s(e){e=e.map(function(e){return e.preoptimize()});var t=[];e.forEach(function(e){if(e instanceof y.AndRestriction){var n=e;n.options().forEach(function(e){t.push(e)})}else t.push(e)});for(var n=!0;n;){n=!1;for(var r=0;r<t.length;r++){for(var i=0;i<t.length;i++){var a=t[r],o=t[i];if(a!==o){var s=a.tryCompose(o);if(s){var u=t.filter(function(e){return e!==a&&e!==o});u.push(s),n=!0,t=u;break}}}if(n)break}}return t}function u(e){if(!c.isUnknown(e))return null;if(null!=e.name())return e;for(var t=0,n=e.superTypes();t<n.length;t++){var r=n[t],i=u(r);if(null!=i)return i}return e}function l(e,t,n,r,i){if(void 0===i&&(i=!1),e.isExternal()){var a=void 0;return a=i?c.error(h.EXTERNAL_IN_FACET_DEFINITION,r):c.error(h.EXTERNAL_IN_PROPERTY_DEFINITION,r),c.setValidationPath(a,{name:t}),a}if(c.isUnknown(e)||e.isSubTypeOf(c.RECURRENT)){var o=u(e),a=void 0,s=e.metaOfType(g.ImportedByChain),l=[];if(i?s.length>0?s.forEach(function(e){var n=h.LIBRARY_CHAINIG_IN_FACET_TYPE,i=o.name();e.value()!=i&&(n=h.LIBRARY_CHAINIG_IN_FACET_TYPE_SUPERTYPE,i=e.value());var a=c.error(n,r,{propName:t,typeName:i});l.push(a)}):(f=c.error(h.UNKNOWN_IN_FACET_DEFINITION,r,{facetName:t,msg:o.name()}),l.push(f)):s.length>0?s.forEach(function(e){var n=h.LIBRARY_CHAINIG_IN_PROPERTY_TYPE,i=o.name();e.value()!=i&&(n=h.LIBRARY_CHAINIG_IN_PROPERTY_TYPE_SUPERTYPE,i=e.value());var a=c.error(n,r,{propName:t,typeName:i});l.push(a)}):(f=c.error(h.UNKNOWN_IN_PROPERTY_DEFINITION,r,{propName:t,typeName:o.name()}),l.push(f)),l.forEach(function(e){return c.setValidationPath(e,{name:t,child:{name:"type"}})}),1==l.length)return l[0];var p=c.ok();return l.forEach(function(e){return p.addSubStatus(e)}),p}if(e.isAnonymous()){var f=e.validateType(n);if(!f.isOk()){var d;return d=i?c.error(h.ERROR_IN_FACET_RANGE,r,{facetName:t,msg:f.getMessage()}):c.error(h.ERROR_IN_RANGE,r,{propName:t,msg:f.getMessage()}),f.getErrors().forEach(function(e){d.addSubStatus(e)}),c.setValidationPath(d,{name:t}),d}return f}if(e.isUnion()){var y=m.find(e.typeFamily(),function(e){return c.isUnknown(e)});if(y){var a=void 0;return a=i?c.error(h.UNKNOWN_IN_FACET_DEFINITION,r,{facetName:t,msg:y.name()}):c.error(h.UNKNOWN_IN_PROPERTY_DEFINITION,r,{propName:t,typeName:y.name()}),c.setValidationPath(a,{name:t}),a}}return c.ok()}var p=this&&this.__extends||function(){var e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();Object.defineProperty(t,"__esModule",{value:!0});var c=n(58),f=n(74),h=c.messageRegistry,d=n(60),m=n(59),y=n(58),v=n(58),g=n(75),A=n(75),E=n(75),_=function(e){function t(t){var n=e.call(this)||this;return n._type=t,n}return p(t,e),t.prototype.matches=function(e){return!1},t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_MatchesProperty)},t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&m.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_MatchesProperty)},t.prototype.check=function(e,t){throw new Error(h.SHOULD_BE_NEVER_CALLED.message)},t.prototype.patchPath=function(e,t){if(e){for(var n=e,r=null,i=null;n;)if(r){var a={name:n.name};i.child=a,n=n.child,i=a}else r={name:n.name},i=r;return r.child={name:t},r}return{name:t}},t.prototype.validateProp=function(e,t,n,r){var i=e[t],a=n.validate(i,!1,!1);if(!a.isOk()){if(n.isUnknown()||n.isRecurrent()){var o=c.error(h.VALIDATING_AGAINST_UNKNOWN,this,{typeName:n.name()});return c.setValidationPath(o,this.patchPath(r,t)),o}var o=new v.Status(v.Status.OK,"","",this);return a.getErrors().forEach(function(e){return o.addSubStatus(e)}),c.setValidationPath(o,this.patchPath(r,t)),o}return c.ok()},t.prototype.validateSelfIndividual=function(e,t){return l(this._type,this.propId(),t,this,!1)},t.prototype.range=function(){return this._type},t.CLASS_IDENTIFIER_MatchesProperty="restrictions.MatchesProperty",t}(c.Constraint);t.MatchesProperty=_;var T=function(e){function t(t,n){var r=e.call(this)||this;return r._value=t,r.provider=n,r}return p(t,e),t.prototype.value=function(){return this._value},t.prototype.check=function(e){var t=null,n=this.value();if("{"==n.charAt(0))try{t=d.getJSONSchema(n,this.provider)}catch(e){if(c.ValidationError.isInstance(e)){var r=e,i=r.isWarning?c.Status.WARNING:c.Status.ERROR,a=c.error(r.messageEntry,this,r.parameters,i,r.parameters);return a}return c.error(h.INCORRECT_SCHEMA,this,{msg:e.message})}if("<"==n.charAt(0))try{t=d.getXMLSchema(n,this.provider)}catch(e){return c.ok()}if(t)try{"string"==typeof e?t.validate(e):t.validateObject(e)}catch(e){if(c.ValidationError.isInstance(e)){var r=e,o=c.Status.ERROR;r.isWarning&&(o=c.Status.WARNING);var s=c.error(r.messageEntry,this,r.parameters,o);if(s.setInternalRange(r.internalRange),s.setInternalPath(c.toValidationPath(r.internalPath)),s.setFilePath(r.filePath),!r.additionalErrors||0==r.additionalErrors.length)return s;var u=c.ok();u.addSubStatus(s);for(var l=0,p=r.additionalErrors;l<p.length;l++){var f=p[l],m=c.error(f.messageEntry,this,f.parameters,o);m.setInternalRange(f.internalRange),m.setInternalPath(c.toValidationPath(f.internalPath)),m.setFilePath(f.filePath),u.addSubStatus(m)}return u}return"!_PERF_!"==e.message?c.error(h.UNABLE_TO_VALIDATE_XML,this,{},c.Status.WARNING):"Maximum call stack size exceeded"==e.message?c.error(h.CIRCULAR_REFS_IN_JSON_SCHEMA,this):c.error(h.EXAMPLE_SCHEMA_FAILURE,this,{msg:e.message})}return c.ok()},t.prototype.facetName=function(){return"schema"},t.prototype.requiredType=function(){return c.EXTERNAL},t}(c.Constraint);t.MatchToSchema=T;var N=function(e){function t(t){var n=e.call(this)||this;return n._value=t,n}return p(t,e),t.prototype.facetName=function(){return"closed"},t.prototype.requiredType=function(){return c.OBJECT},t.prototype.value=function(){return this._value},t.prototype.patchOwner=function(e){this._owner=e},t.prototype.check=function(e){var t=this;if(this._value===!1&&e&&"object"==typeof e&&!Array.isArray(e)){var n={};Object.getOwnPropertyNames(e).forEach(function(e){return n[e]=!0});var r=this.owner().knownProperties();Object.getOwnPropertyNames(e).forEach(function(e){r.forEach(function(t){t.matches(e)&&delete n[e]})});var i=Object.keys(n);if((this.owner().hasPropertiesFacet()||r.length>0)&&i.length>0){var a=new c.Status(c.Status.OK,"","",this);return i.forEach(function(e){var n=c.error(h.UNKNOWN_PROPERTY,t,{propName:e});c.setValidationPath(n,{name:e}),a.addSubStatus(n)}),a}}return c.ok()},t.prototype.composeWith=function(e){if(!this._value)return null;if(e instanceof t){var n=e;if(m.isEqual(this.owner().propertySet(),n.owner().propertySet()))return n}if(e instanceof S){var r=e,i=r.value(),a=this.owner().propertySet();if(-1==a.indexOf(i))return this.nothing(r)}},t}(c.Constraint);t.KnownPropertyRestriction=N;var S=function(e){function t(t){var n=e.call(this)||this;return n.name=t,n}return p(t,e),t.prototype.check=function(e){return e&&"object"==typeof e&&!Array.isArray(e)?e.hasOwnProperty(this.name)?c.ok():c.error(h.REQUIRED_PROPERTY_MISSING,this,{propName:this.name}):c.ok()},t.prototype.requiredType=function(){return c.OBJECT},t.prototype.facetName=function(){return"hasProperty"},t.prototype.value=function(){return this.name},t.prototype.composeWith=function(e){if(e instanceof t){var n=e;if(n.name===this.name)return this}return null},t}(c.Constraint);t.HasProperty=S;var b=function(e){function t(t,n,r){void 0===r&&(r=!1);var i=e.call(this,n)||this;return i.name=t,i.type=n,i.optional=r,i}return p(t,e),t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_PropertyIs)},t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&m.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_PropertyIs)},t.prototype.matches=function(e){return e===this.name},t.prototype.path=function(){return this.name},t.prototype.check=function(e,t){if(e&&"object"==typeof e&&e.hasOwnProperty(this.name)){var n=this.validateProp(e,this.name,this.type,t);return!n.isOk()&&this.optional&&null==e[this.name]?c.ok():n}return c.ok()},t.prototype.requiredType=function(){return c.OBJECT},t.prototype.propId=function(){return this.name},t.prototype.propertyName=function(){return this.name},t.prototype.facetName=function(){return"propertyIs"},t.prototype.value=function(){return this.type},t.prototype.composeWith=function(e){if(e instanceof t){var n=e;if(n.name===this.name){if(-1!=this.type.typeFamily().indexOf(n.type))return n;if(-1!=n.type.typeFamily().indexOf(this.type))return this;i(e);var r=this.intersect(this.type,n.type);try{var a=r.checkConfluent();if(!a.isOk()){var o=a;return o.toRestriction()}return new t(this.name,r)}finally{this.release(r)}}}return null},t.prototype.isOptional=function(){return this.optional},t.CLASS_IDENTIFIER_PropertyIs="restrictions.PropertyIs",t}(_);t.PropertyIs=b;var I=[];t.anotherRestrictionComponent=r,t.releaseAnotherRestrictionComponent=a,t.anotherRestrictionComponentsCount=o;var R=function(e){function t(t,n){var r=e.call(this,n)||this;return r.regexp=t,r.type=n,r}return p(t,e),t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_MapPropertyIs)},t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&m.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_MapPropertyIs)},t.prototype.path=function(){return"/"+this.regexp+"/"},t.prototype.matches=function(e){return!!e.match(this.regexp)},t.prototype.requiredType=function(){return c.OBJECT},t.prototype.propId=function(){return"["+this.regexp+"]"},t.prototype.facetName=function(){return"mapPropertyIs"},t.prototype.value=function(){return this.type},t.prototype.regexpValue=function(){return this.regexp},t.prototype.validateSelfIndividual=function(t,n){var r=this.checkValue();return r?c.error(h.INVALID_REGEXP,this,{msg:r}):e.prototype.validateSelfIndividual.call(this,t,n)},t.prototype.checkValue=function(){try{new RegExp(this.regexp)}catch(e){return e.message}return null},t.prototype.composeWith=function(e){if(e instanceof t){var n=e;if(n.regexp===this.regexp){if(-1!=this.type.typeFamily().indexOf(n.type))return n;if(-1!=n.type.typeFamily().indexOf(this.type))return this;var r=this.intersect(this.type,n.type);try{var i=r.checkConfluent();if(!i.isOk()){var a=i;return a.toRestriction()}return new t(this.regexp,r)}finally{this.release(r)}}}return null},t.prototype.check=function(e,t){if(e&&"object"==typeof e){var n={};null!=this._owner&&this._owner.meta().filter(function(e){return e instanceof b}).forEach(function(e){n[e.propertyName()]=!0});for(var r=new c.Status(c.Status.OK,"","",this),i=0,a=Object.getOwnPropertyNames(e);i<a.length;i++){var o=a[i];if(!n[o]&&o.match(this.regexp)){var s=this.validateProp(e,o,this.type,t);s.isOk()||r.addSubStatus(s)}}return r}return c.ok()},t.CLASS_IDENTIFIER_MapPropertyIs="restrictions.MapPropertyIs",t}(_);t.MapPropertyIs=R;var M=function(e){function t(t){var n=e.call(this,t)||this;return n.type=t,n}return p(t,e),t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_AdditionalPropertyIs)},t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&m.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_AdditionalPropertyIs)},t.prototype.path=function(){return this.facetName()},t.prototype.matches=function(e){return!0},t.prototype.requiredType=function(){return c.OBJECT},t.prototype.propId=function(){return"[]"},t.prototype.facetName=function(){return"additionalProperties"},t.prototype.value=function(){return this.type},t.prototype.match=function(e){for(var t=this.owner().metaOfType(b),n=this.owner().metaOfType(R),r=0;r<t.length;r++)if(t[r].matches(e))return!0;for(var r=0;r<n.length;r++)if(n[r].matches(e))return!0;return!1},t.prototype.composeWith=function(e){if(e instanceof t){var n=e;if(-1!=this.type.typeFamily().indexOf(n.type))return n;if(-1!=n.type.typeFamily().indexOf(this.type))return this;var r=this.intersect(this.type,n.type);try{var i=r.checkConfluent();if(!i.isOk()){var a=i;return a.toRestriction()}return new t(r)}finally{this.release(r)}}return null},t.prototype.check=function(e,t){var n=this,r=this.type,i=new c.Status(c.Status.OK,"","",this);return e&&"object"==typeof e&&Object.getOwnPropertyNames(e).forEach(function(a){if(!n.match(a)){var o=n.validateProp(e,a,r,t);o.isOk()||i.addSubStatus(o)}}),i},t.CLASS_IDENTIFIER_AdditionalPropertyIs="restrictions.AdditionalPropertyIs",t}(_);t.AdditionalPropertyIs=M;var w=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return p(t,e),t.prototype.requiredTypes=function(){return[]},t.prototype.checkOwner=function(e){if(this.owner().oneMeta(A.SkipValidation))return!0;var t=!1;if(e.isUnion())for(var n=e.typeFamily(),r=0,i=n;r<i.length;r++){var a=i[r];if(this.owner().isSubTypeOf(a)){t=!0;break}}else t=this.owner().isSubTypeOf(e);return t},t.prototype.validateSelfIndividual=function(e,t){var n=this,r=!1;if(this.checkOwner(this.requiredType()))if(this.requiredTypes()&&this.requiredTypes().length>0){var i=(this.owner(),m.find(this.requiredTypes(),function(e){return n.checkOwner(e)}));i&&(r=!0)}else r=!0;var a;if(r)a=this.checkValue();else{var o=this.requiredType().name();this.requiredTypes()&&this.requiredTypes().length>0&&(o="["+this.requiredTypes().map(function(e){return e.name()}).join()+"]");var a=c.error(h.FACET_USAGE_RESTRICTION,this,{facetName:this.facetName(),typeNames:o})}if(a&&!a.isOk())return c.setValidationPath(a,{name:this.facetName()}),a;var s=[e,a].filter(function(e){return e&&!e.isOk()});if(0==s.length)return c.ok();if(1==s.length)return s[0];for(var u=c.ok(),l=0,p=s;l<p.length;l++){var f=p[l];u.addSubStatus(f)}return u},t}(c.Constraint);t.FacetRestriction=w;var C=function(e){function t(t,n,r,i,a,o){var s=e.call(this)||this;return s._facetName=t,s._value=n,s._max=r,s._opposite=i,s._requiredType=a,s._isInt=o,s}return p(t,e),t.prototype.facetName=function(){return this._facetName},t.prototype.isIntConstraint=function(){return this._isInt},t.prototype.isMax=function(){return this._max},t.prototype.value=function(){return this._value},t.prototype.check=function(e){var t=this.extractValue(e);if("number"==typeof t)if(this.isMax()){if(this.value()<t)return this.createError()}else if(this.value()>t)return this.createError();return c.ok()},t.prototype.createError=function(){return new v.Status(v.Status.ERROR,h.MINMAX_RESTRICTION_VIOLATION.code,this.toString(),this)},t.prototype.minValue=function(){return this._isInt?0:Number.NEGATIVE_INFINITY},t.prototype.requiredType=function(){return this._requiredType},t.prototype.checkValue=function(){return"number"!=typeof this._value?c.error(h.FACET_REQUIRE_NUMBER,this,{facetName:this.facetName()},c.Status.ERROR,!0):this.isIntConstraint()&&!new f.BigNumber(this.value().toString()).isInteger()?c.error(h.FACET_REQUIRE_INTEGER,this,{facetName:this.facetName()},c.Status.ERROR,!0):this.value()<this.minValue()?c.error(h.MIN_VALUE,this,{facetName:this.facetName(),minValue:this.minValue()},c.Status.ERROR,!0):void 0},t.prototype.composeWith=function(e){if(e instanceof t){var n=e;if(n.facetName()==this.facetName()&&n.isMax()==this.isMax())return this.isMax()?this.value()>n.value()?n:this:this.value()<n.value()?n:this;if(n.facetName()===this._opposite)if(this.isMax()){if(n.value()>this.value())return this.nothing(e)}else if(n.value()<this.value())return this.nothing(e)}return null},t.prototype.facetPath=function(){var e=[this.facetName()],t=this._owner;if(null!=t&&t instanceof c.InheritedType){var n=t;e=c.typePath(n).concat(e)}return e.join(".")},t.prototype.toString=function(){return"'"+this.facetPath()+"="+this.value()+"' i.e. "+this.textMessagePart()+" "+this.value()},t.prototype.conflictMessage=function(e,t){var n=this.isMax()?["less","higher"]:["higher","less"];return"['"+this.facetPath()+"="+this.value()+"' is "+n[0]+" than '"+e+"="+t+"'. The "+this._opposite+" cannot be "+n[1]+" than the "+this.facetName()+".]"},t}(w);t.MinMaxRestriction=C;var L=function(e){function t(t){var n=e.call(this)||this;return n._value=t,n}return p(t,e),t.prototype.value=function(){return this._value},t.prototype.check=function(e){if("number"==typeof e){var t=new f.BigNumber(e.toString()),n=new f.BigNumber(this.value().toString()),r=t.dividedBy(n);if(!r.isInteger())return c.error(h.EVEN_RATIO,this,{val1:e,val2:this.value()})}return c.ok()},t.prototype.composeWith=function(e){return null},t.prototype.facetName=function(){return"multipleOf"},t.prototype.checkValue=function(){return"number"!=typeof this._value?c.error(h.FACET_REQUIRE_NUMBER,this,{facetName:this.facetName()},c.Status.ERROR,!0):this._value<=0?c.error(h.VALUE_SHOULD_BE_POSITIVE,this,{facetName:this.facetName()},c.Status.ERROR,!0):null},t.prototype.requiredType=function(){return c.NUMBER},t}(w);t.MultipleOf=L;var P=function(e){function t(t){return e.call(this,"maximum",t,!0,"minimum",c.NUMBER,!1)||this}return p(t,e),t.prototype.extractValue=function(e){return e},t.prototype.textMessagePart=function(){return h.VALUE_SHOULD_NOT_BE_MORE.message},t}(C);t.Maximum=P;var O=function(e){function t(t){return e.call(this,"minimum",t,!1,"maximum",c.NUMBER,!1)||this}return p(t,e),t.prototype.extractValue=function(e){return e},t.prototype.textMessagePart=function(){return h.VALUE_SHOULD_NOT_BE_LESS.message},t}(C);t.Minimum=O;var D=function(e){function t(t){return e.call(this,"maxItems",t,!0,"minItems",c.ARRAY,!0)||this}return p(t,e),t.prototype.extractValue=function(e){return Array.isArray(e)?e.length:void 0},t.prototype.textMessagePart=function(){return h.ARRAY_ITEMS_COUNT_SHOULD_NOT_BE_MORE.message},t}(C);t.MaxItems=D;var U=function(e){function t(t){return e.call(this,"minItems",t,!1,"maxItems",c.ARRAY,!0)||this}return p(t,e),t.prototype.extractValue=function(e){return Array.isArray(e)?e.length:void 0},t.prototype.textMessagePart=function(){return h.ARRAY_ITEMS_COUNT_SHOULD_NOT_BE_LESS.message},t}(C);t.MinItems=U;var x=function(e){function t(t){return e.call(this,"maxLength",t,!0,"minLength",new c.UnionType("string and file",[c.STRING,c.FILE]),!0)||this}return p(t,e),t.prototype.extractValue=function(e){return"string"==typeof e?e.length:0},t.prototype.textMessagePart=function(){return h.STRING_SHOULD_NOT_BE_MORE.message},t}(C);t.MaxLength=x;var k=function(e){function t(t){return e.call(this,"minLength",t,!1,"maxLength",new c.UnionType("string and file",[c.STRING,c.FILE]),!0)||this}return p(t,e),t.prototype.extractValue=function(e){return"string"==typeof e?e.length:0},t.prototype.textMessagePart=function(){return h.STRING_SHOULD_NOT_BE_LESS.message},t}(C);t.MinLength=k;var F=function(e){function t(t){return e.call(this,"maxProperties",t,!0,"minProperties",c.OBJECT,!0)||this}return p(t,e),t.prototype.extractValue=function(e){return Object.keys(e).length},t.prototype.textMessagePart=function(){return h.OBJECT_PROPERTIES_SHOULD_NOT_BE_MORE.message},t}(C);t.MaxProperties=F;var B=function(e){function t(t){return e.call(this,"minProperties",t,!1,"maxProperties",c.OBJECT,!0)||this}return p(t,e),t.prototype.extractValue=function(e){return Object.keys(e).length},t.prototype.textMessagePart=function(){return h.OBJECT_PROPERTIES_SHOULD_NOT_BE_LESS.message},t}(C);t.MinProperties=B;var V=function(e){function t(t){var n=e.call(this)||this;return n._value=t,n}return p(t,e),t.prototype.facetName=function(){return"uniqueItems"},t.prototype.requiredType=function(){return c.ARRAY},t.prototype.check=function(e){if(!this._value)return c.ok();if(Array.isArray(e)){var t=e;if(m.unique(t).length!=t.length)return c.error(h.MUST_BE_UNIQUE,this)}return c.ok()},t.prototype.composeWith=function(e){if(e instanceof t){
var n=e;if(n._value==this._value)return this}return null},t.prototype.value=function(){return this._value},t.prototype.checkValue=function(){return"boolean"!=typeof this._value?c.error(h.UNIQUE_ITEMS_BOOLEAN,this):null},t.prototype.toString=function(){return h.MUST_BE_UNIQUE.message},t}(w);t.UniqueItems=V;var K=function(e){function t(t){var n=e.call(this)||this;return n.type=t,n}return p(t,e),t.prototype.facetName=function(){return"items"},t.prototype.requiredType=function(){return c.ARRAY},t.prototype.toString=function(){return c.error(h.ITEMS_SHOULD_BE_OF_TYPE,this,{type:this.type}).getMessage()},t.prototype.check=function(e){var t=new c.Status(c.Status.OK,"","",this);if(Array.isArray(e))for(var n=e,r=0;r<n.length;r++){var i=this.type.validate(n[r],!1,!1);if(!i.isOk()){var a=this.type;if(a.isUnknown()||a.isRecurrent()){var o=c.error(h.ARRAY_AGAINST_UNKNOWN,this,{typeName:a.name()});return o}}c.setValidationPath(i,{name:""+r}),t.addSubStatus(i)}return t},t.prototype.validateSelfIndividual=function(e,t){var n=this;if(this.type.isAnonymous()){var r=this.type.validateType(t);return r.isOk()||e.addSubStatus(c.error(h.INVALID_COMPONENT_TYPE,this,{msg:e.getMessage()})),e}var i=this.type.metaOfType(g.ImportedByChain);if(i.length>0)i.forEach(function(t){var r=n.type.name(),i=null,a=h.ARRAY_COMPONENT_TYPE_IMPORTED_THROUGH_LIBRARY_CHAIN;t.value()!=i&&(a=h.ARRAY_COMPONENT_TYPE_DEPENDES_ON_TYPE_IMPORTED_THROUGH_LIBRARY_CHAIN,i=t.value()),e.addSubStatus(c.error(a,n,{componentTypeName:r,typeName:i}))});else if(this.type.isExternal())e.addSubStatus(c.error(h.EXTERNAL_AS_COMPONENT,this));else if(c.isUnknown(this.type)||this.type.isSubTypeOf(c.RECURRENT))e.addSubStatus(c.error(h.UNKNOWN_ARRAY_COMPONENT_TYPE,this,{componentTypeName:this.type.name()}));else if(this.type.isUnion()){var a=m.find(this.type.typeFamily(),function(e){return c.isUnknown(e)});a&&e.addSubStatus(c.error(h.UNKNOWN_ARRAY_COMPONENT_TYPE,this,{componentTypeName:a.name()}))}return e},t.prototype.composeWith=function(e){if(e instanceof t){var n=e;if(-1!=this.type.typeFamily().indexOf(n.type))return n;if(-1!=n.type.typeFamily().indexOf(this.type))return this;var r=this.intersect(this.type,n.type);try{var i=r.checkConfluent();if(!i.isOk()){var a=i;return a.toRestriction()}return new t(r)}finally{this.release(r)}}return null},t.prototype.checkValue=function(){return null},t.prototype.value=function(){return this.type},t}(w);t.ComponentShouldBeOfType=K;var j=function(e){function t(t){var n=e.call(this)||this;return n._value=t,n}return p(t,e),t.prototype.facetName=function(){return"pattern"},t.prototype.requiredType=function(){return c.STRING},t.prototype.check=function(e){if("string"==typeof e){var t=e;try{var n=t.match(this._value),r=!1;if(n)for(var i=0,a=n;i<a.length;i++){var o=a[i];if(o.length==t.length){r=!0;break}}if(!r)return c.error(h.PATTERN_VIOLATION,this,{value:this.value()})}catch(e){}}return c.ok()},t.prototype.composeWith=function(e){if(e instanceof t){var n=e;return n._value===this._value?this:this.nothing(e,c.error(h.SHOULD_PASS_REXEXP,this,{name:"pattern restrictions"}).getMessage())}return null},t.prototype.value=function(){return this._value},t.prototype.checkValue=function(){try{new RegExp(this._value)}catch(e){return c.error(h.INVALID_REGEXP,this,{msg:e.message},c.Status.ERROR,!0)}return null},t.prototype.toString=function(){return c.error(h.SHOULD_PASS_REXEXP,this,{rexexp:this.value}).getMessage()},t}(w);t.Pattern=j;var W=function(e){function t(t){var n=e.call(this)||this;return n._value=t,n}return p(t,e),t.prototype.facetName=function(){return"fileTypes"},t.prototype.requiredType=function(){return c.FILE},t.prototype.check=function(e){return c.ok()},t.prototype.composeWith=function(e){if(e instanceof t){var n=e,r=m.intersection(this._value,n._value);return r.length>0?new t(r):this.nothing(e,h.NO_COMMON_FILE_TYPES.message)}return null},t.prototype.value=function(){return this._value},t.prototype.checkValue=function(){if(!Array.isArray(this._value))return c.error(h.FILE_TYPES_SHOULD_BE_AN_ARRAY,this);for(var e=0,t=this._value;e<t.length;e++){var n=t[e];if("string"!=typeof n)return c.error(h.FILE_TYPES_SHOULD_BE_AN_ARRAY,this)}return c.ok()},t.prototype.toString=function(){return this.checkValue().isOk()?c.error(h.SUPPORTED_FILE_TYPES,this,{types:this._value.join(", ")}).getMessage():h.INVALID_FILETYPES_FACET_VALUE.message},t}(w);t.FileTypes=W;var H=function(e){function t(t){var n=e.call(this)||this;return n._value=t,n}return p(t,e),t.prototype.facetName=function(){return"format"},t.prototype.requiredType=function(){return c.SCALAR},t.prototype.requiredTypes=function(){return[c.NUMBER,c.INTEGER,c.DATETIME]},t.prototype.check=function(e){return c.ok()},t.prototype.composeWith=function(e){if(e instanceof t){var n=e;return n._value===this._value?this:this.nothing(e,c.error(h.SHOULD_PASS_REXEXP,this,{name:"Format"}).getMessage())}return null},t.prototype.value=function(){return this._value},t.prototype.checkValue=function(){var e=this;try{var t=[];if(this.owner().isSubTypeOf(c.INTEGER))t=["int32","int64","int","long","int16","int8"];else if(this.owner().isSubTypeOf(c.NUMBER))t=["int32","int64","int","long","float","double","int16","int8"];else{if(!this.owner().isSubTypeOf(c.DATETIME))return null;t=["rfc3339","rfc2616"]}var n=m.find(t,function(t){return t==e.value()});if(!n)return c.error(h.ALLOWED_FORMAT_VALUES,this,{allowedValues:t.map(function(e){return"'"+e+"'"}).join(", ")},c.Status.ERROR,!0)}catch(e){return new v.Status(v.Status.ERROR,"",e.message,this)}return null},t.prototype.toString=function(){return"should have format:"+this.value},t}(w);t.Format=H;var Y=function(e){function t(t){var n=e.call(this)||this;return n._value=t,n}return p(t,e),t.prototype.facetName=function(){return"enum"},t.prototype.requiredType=function(){return c.ANY},t.prototype.check=function(e){if(!this.checkStatus){var t=this.value();if(this.owner().oneMeta(E.AcceptAllScalarsAsStrings)&&null!=e&&(t=t.concat(t.map(function(e){return""+e}))),Array.isArray(t)||(t=[t]),!t.some(function(t){return t==e})){var n=Array.isArray(this._value)?this._value.map(function(e){return"'"+e+"'"}).join(", "):"'"+this._value+"'";return c.error(h.ENUM_RESTRICTION,this,{values:n})}}return c.ok()},t.prototype.composeWith=function(e){if(e instanceof t){var n=e,r=m.intersection(this._value,n._value);return 0==r.length?this.nothing(e):new t(r)}return null},t.prototype.value=function(){return this._value},t.prototype.checkValue=function(){var e=this;if(!this.owner().isSubTypeOf(this.requiredType()))return c.error(h.ENUM_OWNER_TYPES,this,{typeNames:this.requiredType().name()},c.Status.ERROR,!0);if(this.requiredTypes()&&this.requiredTypes().length>0){var t=this.owner(),n=m.find(this.requiredTypes(),function(e){return t.isSubTypeOf(e)});if(!n){var r="["+this.requiredTypes().map(function(e){return"'"+e.name()+"'"}).join(", ")+"]";return c.error(h.ENUM_OWNER_TYPES,this,{typeNames:r},c.Status.ERROR,!0)}}if(!Array.isArray(this._value))return c.error(h.ENUM_ARRAY,this,{},c.Status.ERROR,!0);var i=c.ok();this.checkStatus=!0;try{this._value.forEach(function(t,n){var r=e.owner().validate(t);r.isOk()||(c.setValidationPath(r,{name:n}),i.addSubStatus(r))})}finally{this.checkStatus=!1}return i},t.prototype.toString=function(){var e=Array.isArray(this._value)?this._value.map(function(e){return"'"+e+"'"}).join(", "):"'"+this._value+"'";return"value should be one of: "+e},t}(w);t.Enum=Y,t.optimize=s,t.validatePropertyType=l},function(e,t,n){var r;!function(i){"use strict";function a(e){function t(e,r){var i,a,o,s,u,l,p=this;if(!(p instanceof t))return W&&C(26,"constructor call without new",e),new t(e,r);if(null!=r&&H(r,2,64,D,"base")){if(r|=0,l=e+"",10==r)return p=new t(e instanceof t?e:l),L(p,k+p.e+1,F);if((s="number"==typeof e)&&0*e!=0||!new RegExp("^-?"+(i="["+T.slice(0,r)+"]+")+"(?:\\."+i+")?$",37>r?"i":"").test(l))return O(p,l,s,r);s?(p.s=0>1/e?(l=l.slice(1),-1):1,W&&l.replace(/^0\.0*|\./,"").length>15&&C(D,_,e),s=!1):p.s=45===l.charCodeAt(0)?(l=l.slice(1),-1):1,l=n(l,10,r,p.s)}else{if(e instanceof t)return p.s=e.s,p.e=e.e,p.c=(e=e.c)?e.slice():e,void(D=0);if((s="number"==typeof e)&&0*e==0){if(p.s=0>1/e?(e=-e,-1):1,e===~~e){for(a=0,o=e;o>=10;o/=10,a++);return p.e=a,p.c=[e],void(D=0)}l=e+""}else{if(!y.test(l=e+""))return O(p,l,s);p.s=45===l.charCodeAt(0)?(l=l.slice(1),-1):1}}for((a=l.indexOf("."))>-1&&(l=l.replace(".","")),(o=l.search(/e/i))>0?(0>a&&(a=o),a+=+l.slice(o+1),l=l.substring(0,o)):0>a&&(a=l.length),o=0;48===l.charCodeAt(o);o++);for(u=l.length;48===l.charCodeAt(--u););if(l=l.slice(o,u+1))if(u=l.length,s&&W&&u>15&&(e>b||e!==g(e))&&C(D,_,p.s*e),a=a-o-1,a>j)p.c=p.e=null;else if(K>a)p.c=[p.e=0];else{if(p.e=a,p.c=[],o=(a+1)%S,0>a&&(o+=S),u>o){for(o&&p.c.push(+l.slice(0,o)),u-=S;u>o;)p.c.push(+l.slice(o,o+=S));l=l.slice(o),o=S-l.length}else o-=u;for(;o--;l+="0");p.c.push(+l)}else p.c=[p.e=0];D=0}function n(e,n,r,i){var a,o,u,l,p,f,d,m=e.indexOf("."),y=k,v=F;for(37>r&&(e=e.toLowerCase()),m>=0&&(u=G,G=0,e=e.replace(".",""),d=new t(r),p=d.pow(e.length-m),G=u,d.c=c(h(s(p.c),p.e),10,n),d.e=d.c.length),f=c(e,r,n),o=u=f.length;0==f[--u];f.pop());if(!f[0])return"0";if(0>m?--o:(p.c=f,p.e=o,p.s=i,p=P(p,d,y,v,n),f=p.c,l=p.r,o=p.e),a=o+y+1,m=f[a],u=n/2,l=l||0>a||null!=f[a+1],l=4>v?(null!=m||l)&&(0==v||v==(p.s<0?3:2)):m>u||m==u&&(4==v||l||6==v&&1&f[a-1]||v==(p.s<0?8:7)),1>a||!f[0])e=l?h("1",-y):"0";else{if(f.length=a,l)for(--n;++f[--a]>n;)f[a]=0,a||(++o,f=[1].concat(f));for(u=f.length;!f[--u];);for(m=0,e="";u>=m;e+=T.charAt(f[m++]));e=h(e,o)}return e}function r(e,n,r,i){var a,o,u,l,p;if(r=null!=r&&H(r,0,8,i,E)?0|r:F,!e.c)return e.toString();if(a=e.c[0],u=e.e,null==n)p=s(e.c),p=19==i||24==i&&B>=u?f(p,u):h(p,u);else if(e=L(new t(e),n,r),o=e.e,p=s(e.c),l=p.length,19==i||24==i&&(o>=n||B>=o)){for(;n>l;p+="0",l++);p=f(p,o)}else if(n-=u,p=h(p,o),o+1>l){if(--n>0)for(p+=".";n--;p+="0");}else if(n+=o-l,n>0)for(o+1==l&&(p+=".");n--;p+="0");return e.s<0&&a?"-"+p:p}function i(e,n){var r,i,a=0;for(p(e[0])&&(e=e[0]),r=new t(e[0]);++a<e.length;){if(i=new t(e[a]),!i.s){r=i;break}n.call(r,i)&&(r=i)}return r}function m(e,t,n,r,i){return(t>e||e>n||e!=d(e))&&C(r,(i||"decimal places")+(t>e||e>n?" out of range":" not an integer"),e),!0}function w(e,t,n){for(var r=1,i=t.length;!t[--i];t.pop());for(i=t[0];i>=10;i/=10,r++);return(n=r+n*S-1)>j?e.c=e.e=null:K>n?e.c=[e.e=0]:(e.e=n,e.c=t),e}function C(e,t,n){var r=new Error(["new BigNumber","cmp","config","div","divToInt","eq","gt","gte","lt","lte","minus","mod","plus","precision","random","round","shift","times","toDigits","toExponential","toFixed","toFormat","toFraction","pow","toPrecision","toString","BigNumber"][e]+"() "+t+": "+n);throw r.name="BigNumber Error",D=0,r}function L(e,t,n,r){var i,a,o,s,u,l,p,c=e.c,f=I;if(c){e:{for(i=1,s=c[0];s>=10;s/=10,i++);if(a=t-i,0>a)a+=S,o=t,u=c[l=0],p=u/f[i-o-1]%10|0;else if(l=v((a+1)/S),l>=c.length){if(!r)break e;for(;c.length<=l;c.push(0));u=p=0,i=1,a%=S,o=a-S+1}else{for(u=s=c[l],i=1;s>=10;s/=10,i++);a%=S,o=a-S+i,p=0>o?0:u/f[i-o-1]%10|0}if(r=r||0>t||null!=c[l+1]||(0>o?u:u%f[i-o-1]),r=4>n?(p||r)&&(0==n||n==(e.s<0?3:2)):p>5||5==p&&(4==n||r||6==n&&(a>0?o>0?u/f[i-o]:0:c[l-1])%10&1||n==(e.s<0?8:7)),1>t||!c[0])return c.length=0,r?(t-=e.e+1,c[0]=f[(S-t%S)%S],e.e=-t||0):c[0]=e.e=0,e;if(0==a?(c.length=l,s=1,l--):(c.length=l+1,s=f[S-a],c[l]=o>0?g(u/f[i-o]%f[o])*s:0),r)for(;;){if(0==l){for(a=1,o=c[0];o>=10;o/=10,a++);for(o=c[0]+=s,s=1;o>=10;o/=10,s++);a!=s&&(e.e++,c[0]==N&&(c[0]=1));break}if(c[l]+=s,c[l]!=N)break;c[l--]=0,s=1}for(a=c.length;0===c[--a];c.pop());}e.e>j?e.c=e.e=null:e.e<K&&(e.c=[e.e=0])}return e}var P,O,D=0,U=t.prototype,x=new t(1),k=20,F=4,B=-7,V=21,K=-1e7,j=1e7,W=!0,H=m,Y=!1,q=1,G=0,X={decimalSeparator:".",groupSeparator:",",groupSize:3,secondaryGroupSize:0,fractionGroupSeparator:" ",fractionGroupSize:0};return t.another=a,t.ROUND_UP=0,t.ROUND_DOWN=1,t.ROUND_CEIL=2,t.ROUND_FLOOR=3,t.ROUND_HALF_UP=4,t.ROUND_HALF_DOWN=5,t.ROUND_HALF_EVEN=6,t.ROUND_HALF_CEIL=7,t.ROUND_HALF_FLOOR=8,t.EUCLID=9,t.config=t.set=function(){var e,t,n=0,r={},i=arguments,a=i[0],o=a&&"object"==typeof a?function(){return a.hasOwnProperty(t)?null!=(e=a[t]):void 0}:function(){return i.length>n?null!=(e=i[n++]):void 0};return o(t="DECIMAL_PLACES")&&H(e,0,M,2,t)&&(k=0|e),r[t]=k,o(t="ROUNDING_MODE")&&H(e,0,8,2,t)&&(F=0|e),r[t]=F,o(t="EXPONENTIAL_AT")&&(p(e)?H(e[0],-M,0,2,t)&&H(e[1],0,M,2,t)&&(B=0|e[0],V=0|e[1]):H(e,-M,M,2,t)&&(B=-(V=0|(0>e?-e:e)))),r[t]=[B,V],o(t="RANGE")&&(p(e)?H(e[0],-M,-1,2,t)&&H(e[1],1,M,2,t)&&(K=0|e[0],j=0|e[1]):H(e,-M,M,2,t)&&(0|e?K=-(j=0|(0>e?-e:e)):W&&C(2,t+" cannot be zero",e))),r[t]=[K,j],o(t="ERRORS")&&(e===!!e||1===e||0===e?(D=0,H=(W=!!e)?m:l):W&&C(2,t+A,e)),r[t]=W,o(t="CRYPTO")&&(e===!0||e===!1||1===e||0===e?e?(e="undefined"==typeof crypto,!e&&crypto&&(crypto.getRandomValues||crypto.randomBytes)?Y=!0:W?C(2,"crypto unavailable",e?void 0:crypto):Y=!1):Y=!1:W&&C(2,t+A,e)),r[t]=Y,o(t="MODULO_MODE")&&H(e,0,9,2,t)&&(q=0|e),r[t]=q,o(t="POW_PRECISION")&&H(e,0,M,2,t)&&(G=0|e),r[t]=G,o(t="FORMAT")&&("object"==typeof e?X=e:W&&C(2,t+" not an object",e)),r[t]=X,r},t.max=function(){return i(arguments,U.lt)},t.min=function(){return i(arguments,U.gt)},t.random=function(){var e=9007199254740992,n=Math.random()*e&2097151?function(){return g(Math.random()*e)}:function(){return 8388608*(1073741824*Math.random()|0)+(8388608*Math.random()|0)};return function(e){var r,i,a,o,s,u=0,l=[],p=new t(x);if(e=null!=e&&H(e,0,M,14)?0|e:k,o=v(e/S),Y)if(crypto.getRandomValues){for(r=crypto.getRandomValues(new Uint32Array(o*=2));o>u;)s=131072*r[u]+(r[u+1]>>>11),s>=9e15?(i=crypto.getRandomValues(new Uint32Array(2)),r[u]=i[0],r[u+1]=i[1]):(l.push(s%1e14),u+=2);u=o/2}else if(crypto.randomBytes){for(r=crypto.randomBytes(o*=7);o>u;)s=281474976710656*(31&r[u])+1099511627776*r[u+1]+4294967296*r[u+2]+16777216*r[u+3]+(r[u+4]<<16)+(r[u+5]<<8)+r[u+6],s>=9e15?crypto.randomBytes(7).copy(r,u):(l.push(s%1e14),u+=7);u=o/7}else Y=!1,W&&C(14,"crypto unavailable",crypto);if(!Y)for(;o>u;)s=n(),9e15>s&&(l[u++]=s%1e14);for(o=l[--u],e%=S,o&&e&&(s=I[S-e],l[u]=g(o/s)*s);0===l[u];l.pop(),u--);if(0>u)l=[a=0];else{for(a=-1;0===l[0];l.splice(0,1),a-=S);for(u=1,s=l[0];s>=10;s/=10,u++);S>u&&(a-=S-u)}return p.e=a,p.c=l,p}}(),P=function(){function e(e,t,n){var r,i,a,o,s=0,u=e.length,l=t%R,p=t/R|0;for(e=e.slice();u--;)a=e[u]%R,o=e[u]/R|0,r=p*a+o*l,i=l*a+r%R*R+s,s=(i/n|0)+(r/R|0)+p*o,e[u]=i%n;return s&&(e=[s].concat(e)),e}function n(e,t,n,r){var i,a;if(n!=r)a=n>r?1:-1;else for(i=a=0;n>i;i++)if(e[i]!=t[i]){a=e[i]>t[i]?1:-1;break}return a}function r(e,t,n,r){for(var i=0;n--;)e[n]-=i,i=e[n]<t[n]?1:0,e[n]=i*r+e[n]-t[n];for(;!e[0]&&e.length>1;e.splice(0,1));}return function(i,a,s,u,l){var p,c,f,h,d,m,y,v,A,E,_,T,b,I,R,M,w,C=i.s==a.s?1:-1,P=i.c,O=a.c;if(!(P&&P[0]&&O&&O[0]))return new t(i.s&&a.s&&(P?!O||P[0]!=O[0]:O)?P&&0==P[0]||!O?0*C:C/0:NaN);for(v=new t(C),A=v.c=[],c=i.e-a.e,C=s+c+1,l||(l=N,c=o(i.e/S)-o(a.e/S),C=C/S|0),f=0;O[f]==(P[f]||0);f++);if(O[f]>(P[f]||0)&&c--,0>C)A.push(1),h=!0;else{for(I=P.length,M=O.length,f=0,C+=2,d=g(l/(O[0]+1)),d>1&&(O=e(O,d,l),P=e(P,d,l),M=O.length,I=P.length),b=M,E=P.slice(0,M),_=E.length;M>_;E[_++]=0);w=O.slice(),w=[0].concat(w),R=O[0],O[1]>=l/2&&R++;do{if(d=0,p=n(O,E,M,_),0>p){if(T=E[0],M!=_&&(T=T*l+(E[1]||0)),d=g(T/R),d>1)for(d>=l&&(d=l-1),m=e(O,d,l),y=m.length,_=E.length;1==n(m,E,y,_);)d--,r(m,y>M?w:O,y,l),y=m.length,p=1;else 0==d&&(p=d=1),m=O.slice(),y=m.length;if(_>y&&(m=[0].concat(m)),r(E,m,_,l),_=E.length,-1==p)for(;n(O,E,M,_)<1;)d++,r(E,_>M?w:O,_,l),_=E.length}else 0===p&&(d++,E=[0]);A[f++]=d,E[0]?E[_++]=P[b]||0:(E=[P[b]],_=1)}while((b++<I||null!=E[0])&&C--);h=null!=E[0],A[0]||A.splice(0,1)}if(l==N){for(f=1,C=A[0];C>=10;C/=10,f++);L(v,s+(v.e=f+c*S-1)+1,u,h)}else v.e=c,v.r=+h;return v}}(),O=function(){var e=/^(-?)0([xbo])(?=\w[\w.]*$)/i,n=/^([^.]+)\.$/,r=/^\.([^.]+)$/,i=/^-?(Infinity|NaN)$/,a=/^\s*\+(?=[\w.])|^\s+|\s+$/g;return function(o,s,u,l){var p,c=u?s:s.replace(a,"");if(i.test(c))o.s=isNaN(c)?null:0>c?-1:1;else{if(!u&&(c=c.replace(e,function(e,t,n){return p="x"==(n=n.toLowerCase())?16:"b"==n?2:8,l&&l!=p?e:t}),l&&(p=l,c=c.replace(n,"$1").replace(r,"0.$1")),s!=c))return new t(c,p);W&&C(D,"not a"+(l?" base "+l:"")+" number",s),o.s=null}o.c=o.e=null,D=0}}(),U.absoluteValue=U.abs=function(){var e=new t(this);return e.s<0&&(e.s=1),e},U.ceil=function(){return L(new t(this),this.e+1,2)},U.comparedTo=U.cmp=function(e,n){return D=1,u(this,new t(e,n))},U.decimalPlaces=U.dp=function(){var e,t,n=this.c;if(!n)return null;if(e=((t=n.length-1)-o(this.e/S))*S,t=n[t])for(;t%10==0;t/=10,e--);return 0>e&&(e=0),e},U.dividedBy=U.div=function(e,n){return D=3,P(this,new t(e,n),k,F)},U.dividedToIntegerBy=U.divToInt=function(e,n){return D=4,P(this,new t(e,n),0,1)},U.equals=U.eq=function(e,n){return D=5,0===u(this,new t(e,n))},U.floor=function(){return L(new t(this),this.e+1,3)},U.greaterThan=U.gt=function(e,n){return D=6,u(this,new t(e,n))>0},U.greaterThanOrEqualTo=U.gte=function(e,n){return D=7,1===(n=u(this,new t(e,n)))||0===n},U.isFinite=function(){return!!this.c},U.isInteger=U.isInt=function(){return!!this.c&&o(this.e/S)>this.c.length-2},U.isNaN=function(){return!this.s},U.isNegative=U.isNeg=function(){return this.s<0},U.isZero=function(){return!!this.c&&0==this.c[0]},U.lessThan=U.lt=function(e,n){return D=8,u(this,new t(e,n))<0},U.lessThanOrEqualTo=U.lte=function(e,n){return D=9,-1===(n=u(this,new t(e,n)))||0===n},U.minus=U.sub=function(e,n){var r,i,a,s,u=this,l=u.s;if(D=10,e=new t(e,n),n=e.s,!l||!n)return new t(NaN);if(l!=n)return e.s=-n,u.plus(e);var p=u.e/S,c=e.e/S,f=u.c,h=e.c;if(!p||!c){if(!f||!h)return f?(e.s=-n,e):new t(h?u:NaN);if(!f[0]||!h[0])return h[0]?(e.s=-n,e):new t(f[0]?u:3==F?-0:0)}if(p=o(p),c=o(c),f=f.slice(),l=p-c){for((s=0>l)?(l=-l,a=f):(c=p,a=h),a.reverse(),n=l;n--;a.push(0));a.reverse()}else for(i=(s=(l=f.length)<(n=h.length))?l:n,l=n=0;i>n;n++)if(f[n]!=h[n]){s=f[n]<h[n];break}if(s&&(a=f,f=h,h=a,e.s=-e.s),n=(i=h.length)-(r=f.length),n>0)for(;n--;f[r++]=0);for(n=N-1;i>l;){if(f[--i]<h[i]){for(r=i;r&&!f[--r];f[r]=n);--f[r],f[i]+=N}f[i]-=h[i]}for(;0==f[0];f.splice(0,1),--c);return f[0]?w(e,f,c):(e.s=3==F?-1:1,e.c=[e.e=0],e)},U.modulo=U.mod=function(e,n){var r,i,a=this;return D=11,e=new t(e,n),!a.c||!e.s||e.c&&!e.c[0]?new t(NaN):!e.c||a.c&&!a.c[0]?new t(a):(9==q?(i=e.s,e.s=1,r=P(a,e,0,3),e.s=i,r.s*=i):r=P(a,e,0,q),a.minus(r.times(e)))},U.negated=U.neg=function(){var e=new t(this);return e.s=-e.s||null,e},U.plus=U.add=function(e,n){var r,i=this,a=i.s;if(D=12,e=new t(e,n),n=e.s,!a||!n)return new t(NaN);if(a!=n)return e.s=-n,i.minus(e);var s=i.e/S,u=e.e/S,l=i.c,p=e.c;if(!s||!u){if(!l||!p)return new t(a/0);if(!l[0]||!p[0])return p[0]?e:new t(l[0]?i:0*a)}if(s=o(s),u=o(u),l=l.slice(),a=s-u){for(a>0?(u=s,r=p):(a=-a,r=l),r.reverse();a--;r.push(0));r.reverse()}for(a=l.length,n=p.length,0>a-n&&(r=p,p=l,l=r,n=a),a=0;n;)a=(l[--n]=l[n]+p[n]+a)/N|0,l[n]=N===l[n]?0:l[n]%N;return a&&(l=[a].concat(l),++u),w(e,l,u)},U.precision=U.sd=function(e){var t,n,r=this,i=r.c;if(null!=e&&e!==!!e&&1!==e&&0!==e&&(W&&C(13,"argument"+A,e),e!=!!e&&(e=null)),!i)return null;if(n=i.length-1,t=n*S+1,n=i[n]){for(;n%10==0;n/=10,t--);for(n=i[0];n>=10;n/=10,t++);}return e&&r.e+1>t&&(t=r.e+1),t},U.round=function(e,n){var r=new t(this);return(null==e||H(e,0,M,15))&&L(r,~~e+this.e+1,null!=n&&H(n,0,8,15,E)?0|n:F),r},U.shift=function(e){var n=this;return H(e,-b,b,16,"argument")?n.times("1e"+d(e)):new t(n.c&&n.c[0]&&(-b>e||e>b)?n.s*(0>e?0:1/0):n)},U.squareRoot=U.sqrt=function(){var e,n,r,i,a,u=this,l=u.c,p=u.s,c=u.e,f=k+4,h=new t("0.5");if(1!==p||!l||!l[0])return new t(!p||0>p&&(!l||l[0])?NaN:l?u:1/0);if(p=Math.sqrt(+u),0==p||p==1/0?(n=s(l),(n.length+c)%2==0&&(n+="0"),p=Math.sqrt(n),c=o((c+1)/2)-(0>c||c%2),p==1/0?n="1e"+c:(n=p.toExponential(),n=n.slice(0,n.indexOf("e")+1)+c),r=new t(n)):r=new t(p+""),r.c[0])for(c=r.e,p=c+f,3>p&&(p=0);;)if(a=r,r=h.times(a.plus(P(u,a,f,1))),s(a.c).slice(0,p)===(n=s(r.c)).slice(0,p)){if(r.e<c&&--p,n=n.slice(p-3,p+1),"9999"!=n&&(i||"4999"!=n)){+n&&(+n.slice(1)||"5"!=n.charAt(0))||(L(r,r.e+k+2,1),e=!r.times(r).eq(u));break}if(!i&&(L(a,a.e+k+2,0),a.times(a).eq(u))){r=a;break}f+=4,p+=4,i=1}return L(r,r.e+k+1,F,e)},U.times=U.mul=function(e,n){var r,i,a,s,u,l,p,c,f,h,d,m,y,v,g,A=this,E=A.c,_=(D=17,e=new t(e,n)).c;if(!(E&&_&&E[0]&&_[0]))return!A.s||!e.s||E&&!E[0]&&!_||_&&!_[0]&&!E?e.c=e.e=e.s=null:(e.s*=A.s,E&&_?(e.c=[0],e.e=0):e.c=e.e=null),e;for(i=o(A.e/S)+o(e.e/S),e.s*=A.s,p=E.length,h=_.length,h>p&&(y=E,E=_,_=y,a=p,p=h,h=a),a=p+h,y=[];a--;y.push(0));for(v=N,g=R,a=h;--a>=0;){for(r=0,d=_[a]%g,m=_[a]/g|0,u=p,s=a+u;s>a;)c=E[--u]%g,f=E[u]/g|0,l=m*c+f*d,c=d*c+l%g*g+y[s]+r,r=(c/v|0)+(l/g|0)+m*f,y[s--]=c%v;y[s]=r}return r?++i:y.splice(0,1),w(e,y,i)},U.toDigits=function(e,n){var r=new t(this);return e=null!=e&&H(e,1,M,18,"precision")?0|e:null,n=null!=n&&H(n,0,8,18,E)?0|n:F,e?L(r,e,n):r},U.toExponential=function(e,t){return r(this,null!=e&&H(e,0,M,19)?~~e+1:null,t,19)},U.toFixed=function(e,t){return r(this,null!=e&&H(e,0,M,20)?~~e+this.e+1:null,t,20)},U.toFormat=function(e,t){var n=r(this,null!=e&&H(e,0,M,21)?~~e+this.e+1:null,t,21);if(this.c){var i,a=n.split("."),o=+X.groupSize,s=+X.secondaryGroupSize,u=X.groupSeparator,l=a[0],p=a[1],c=this.s<0,f=c?l.slice(1):l,h=f.length;if(s&&(i=o,o=s,s=i,h-=i),o>0&&h>0){for(i=h%o||o,l=f.substr(0,i);h>i;i+=o)l+=u+f.substr(i,o);s>0&&(l+=u+f.slice(i)),c&&(l="-"+l)}n=p?l+X.decimalSeparator+((s=+X.fractionGroupSize)?p.replace(new RegExp("\\d{"+s+"}\\B","g"),"$&"+X.fractionGroupSeparator):p):l}return n},U.toFraction=function(e){var n,r,i,a,o,u,l,p,c,f=W,h=this,d=h.c,m=new t(x),y=r=new t(x),v=l=new t(x);if(null!=e&&(W=!1,u=new t(e),W=f,(f=u.isInt())&&!u.lt(x)||(W&&C(22,"max denominator "+(f?"out of range":"not an integer"),e),e=!f&&u.c&&L(u,u.e+1,1).gte(x)?u:null)),!d)return h.toString();for(c=s(d),a=m.e=c.length-h.e-1,m.c[0]=I[(o=a%S)<0?S+o:o],e=!e||u.cmp(m)>0?a>0?m:y:u,o=j,j=1/0,u=new t(c),l.c[0]=0;p=P(u,m,0,1),i=r.plus(p.times(v)),1!=i.cmp(e);)r=v,v=i,y=l.plus(p.times(i=y)),l=i,m=u.minus(p.times(i=m)),u=i;return i=P(e.minus(r),v,0,1),l=l.plus(i.times(y)),r=r.plus(i.times(v)),l.s=y.s=h.s,a*=2,n=P(y,v,a,F).minus(h).abs().cmp(P(l,r,a,F).minus(h).abs())<1?[y.toString(),v.toString()]:[l.toString(),r.toString()],j=o,n},U.toNumber=function(){return+this},U.toPower=U.pow=function(e,n){var r,i,a,o=g(0>e?-e:+e),s=this;if(null!=n&&(D=23,n=new t(n)),!H(e,-b,b,23,"exponent")&&(!isFinite(e)||o>b&&(e/=0)||parseFloat(e)!=e&&!(e=NaN))||0==e)return r=Math.pow(+s,e),new t(n?r%n:r);for(n?e>1&&s.gt(x)&&s.isInt()&&n.gt(x)&&n.isInt()?s=s.mod(n):(a=n,n=null):G&&(r=v(G/S+2)),i=new t(x);;){if(o%2){if(i=i.times(s),!i.c)break;r?i.c.length>r&&(i.c.length=r):n&&(i=i.mod(n))}if(o=g(o/2),!o)break;s=s.times(s),r?s.c&&s.c.length>r&&(s.c.length=r):n&&(s=s.mod(n))}return n?i:(0>e&&(i=x.div(i)),a?i.mod(a):r?L(i,G,F):i)},U.toPrecision=function(e,t){return r(this,null!=e&&H(e,1,M,24,"precision")?0|e:null,t,24)},U.toString=function(e){var t,r=this,i=r.s,a=r.e;return null===a?i?(t="Infinity",0>i&&(t="-"+t)):t="NaN":(t=s(r.c),t=null!=e&&H(e,2,64,25,"base")?n(h(t,a),0|e,10,i):B>=a||a>=V?f(t,a):h(t,a),0>i&&r.c[0]&&(t="-"+t)),t},U.truncated=U.trunc=function(){return L(new t(this),this.e+1,1)},U.valueOf=U.toJSON=function(){var e,t=this,n=t.e;return null===n?t.toString():(e=s(t.c),e=B>=n||n>=V?f(e,n):h(e,n),t.s<0?"-"+e:e)},U.isBigNumber=!0,null!=e&&t.config(e),t}function o(e){var t=0|e;return e>0||e===t?t:t-1}function s(e){for(var t,n,r=1,i=e.length,a=e[0]+"";i>r;){for(t=e[r++]+"",n=S-t.length;n--;t="0"+t);a+=t}for(i=a.length;48===a.charCodeAt(--i););return a.slice(0,i+1||1)}function u(e,t){var n,r,i=e.c,a=t.c,o=e.s,s=t.s,u=e.e,l=t.e;if(!o||!s)return null;if(n=i&&!i[0],r=a&&!a[0],n||r)return n?r?0:-s:o;if(o!=s)return o;if(n=0>o,r=u==l,!i||!a)return r?0:!i^n?1:-1;if(!r)return u>l^n?1:-1;for(s=(u=i.length)<(l=a.length)?u:l,o=0;s>o;o++)if(i[o]!=a[o])return i[o]>a[o]^n?1:-1;return u==l?0:u>l^n?1:-1}function l(e,t,n){return(e=d(e))>=t&&n>=e}function p(e){return"[object Array]"==Object.prototype.toString.call(e)}function c(e,t,n){for(var r,i,a=[0],o=0,s=e.length;s>o;){for(i=a.length;i--;a[i]*=t);for(a[r=0]+=T.indexOf(e.charAt(o++));r<a.length;r++)a[r]>n-1&&(null==a[r+1]&&(a[r+1]=0),a[r+1]+=a[r]/n|0,a[r]%=n)}return a.reverse()}function f(e,t){return(e.length>1?e.charAt(0)+"."+e.slice(1):e)+(0>t?"e":"e+")+t}function h(e,t){var n,r;if(0>t){for(r="0.";++t;r+="0");e=r+e}else if(n=e.length,++t>n){for(r="0",t-=n;--t;r+="0");e+=r}else n>t&&(e=e.slice(0,t)+"."+e.slice(t));return e}function d(e){return e=parseFloat(e),0>e?v(e):g(e)}var m,y=/^-?(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i,v=Math.ceil,g=Math.floor,A=" not a boolean or binary digit",E="rounding mode",_="number type has more than 15 significant digits",T="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$_",N=1e14,S=14,b=9007199254740991,I=[1,10,100,1e3,1e4,1e5,1e6,1e7,1e8,1e9,1e10,1e11,1e12,1e13],R=1e7,M=1e9;m=a(),m["default"]=m.BigNumber=m,r=function(){return m}.call(t,n,t,e),!(void 0!==r&&(e.exports=r))}(this)},function(e,t,n){"use strict";function r(e,t){return h.serializeToXML(e,t)}function i(e,t){if("string"==typeof e&&(t.isObject()||t.isArray()||t.isExternal()||t.isUnion())){var n=e,r=n.trim().charAt(0);if(!t.isExternal()&&("{"==r||"["==r||"null"==n.trim()))try{return JSON.parse(n)}catch(e){if(t.isObject()||t.isArray()){var i=s.error(u.CAN_NOT_PARSE_JSON,this,{msg:e.message});return i}}if("<"==r)try{var a=h.readObject(n,t),o=h.getXmlErrors(a);if(o){var l=s.error(u.INVALID_XML,null);return o.forEach(function(e){return l.addSubStatus(e)}),l}return a}catch(e){}}return t.getExtra(d.REPEAT)&&(e=[e]),e}function a(e,t,n){t?s.setValidationPath(e,{name:"examples",child:{name:n}}):s.setValidationPath(e,{name:"examples",child:{name:n,child:{name:"value"}}})}var o=this&&this.__extends||function(){var e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();Object.defineProperty(t,"__esModule",{value:!0});var s=n(58),u=s.messageRegistry,l=n(58),p=n(73),c=n(73),f=n(59),h=n(76),d=n(71),m=function(e){function t(t,n,r){void 0===r&&(r=!1);var i=e.call(this,r)||this;return i._name=t,i._value=n,i}return o(t,e),t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_MetaInfo)},t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&f.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_MetaInfo)},t.prototype.value=function(){return this._value},t.prototype.requiredType=function(){return s.ANY},t.prototype.facetName=function(){return this._name},t.prototype.kind=function(){return null},t.CLASS_IDENTIFIER_MetaInfo="metainfo.MetaInfo",t}(s.TypeInformation);t.MetaInfo=m;var y=function(e){function t(t){return e.call(this,"description",t)||this}return o(t,e),t.prototype.kind=function(){return d.MetaInformationKind.Description},t}(m);t.Description=y;var v=function(e){function t(){return e.call(this,"notScalar",!0)||this}return o(t,e),t.prototype.kind=function(){return d.MetaInformationKind.NotScalar},t}(m);t.NotScalar=v;var g=function(e){function t(t){var n=e.call(this,"importedByChain",t,!0)||this;return n._typeName=t,n}return o(t,e),t.prototype.kind=function(){return d.MetaInformationKind.ImportedByChain},t}(m);t.ImportedByChain=g;var A=function(e){function t(){return e.call(this,"acceptAllScalarsAsStrings",null,!0)||this}return o(t,e),t.prototype.kind=function(){return d.MetaInformationKind.AcceptAllScalarsAsStrings},t}(m);t.AcceptAllScalarsAsStrings=A;var E=function(e){function t(){return e.call(this,"skipValidation",null,!0)||this}return o(t,e),t.prototype.kind=function(){return d.MetaInformationKind.SkipValidation},t}(m);t.SkipValidation=E;var _=function(e){function t(t){return e.call(this,"displayName",t)||this}return o(t,e),t.prototype.kind=function(){return d.MetaInformationKind.DisplayName},t}(m);t.DisplayName=_;var T=function(e){function t(t){return e.call(this,"usage",t)||this}return o(t,e),t.prototype.kind=function(){return d.MetaInformationKind.Usage},t}(m);t.Usage=T;var N=function(e){function t(t,n,r,i){void 0===i&&(i=!1);var a=e.call(this,t,n)||this;return a.path=r,a.ofExample=i,a}return o(t,e),t.prototype.name=function(){return this.facetName()},t.prototype.validateSelfIndividual=function(t,n){var r=n.get(this.facetName());if(!r){var i=void 0;return i=n.getByChain(this.facetName())?s.error(u.LIBRARY_CHAINIG_IN_ANNOTATION_TYPE,this,{typeName:this.facetName()}):s.error(u.UNKNOWN_ANNOTATION_TYPE,this,{typeName:this.facetName()}),i.setValidationPath({name:this.path}),i}var a=s.ok(),o=this.value();o||r.isString()&&(o="");var l=r.metaOfType(C),p=this.ofExample?"Example":"TypeDeclaration";if(l.length>0){var c=[],f=l.filter(function(e){var t=e.value();return Array.isArray(t)?(c=c.concat(t),t.indexOf(p)>=0):(c.push(t),t==p)});if(0==f.length){var h=c.map(function(e){return"'"+e+"'"}).join(", "),d=s.error(u.INVALID_ANNOTATION_LOCATION,this,{aName:e.prototype.facetName.call(this),aValues:h});a.addSubStatus(d)}}var m,y=r.metaOfType(g);if(y.length>0&&s.isUnknown(r)&&n.getByChain(r.name())){var v=y[0].value();m=s.error(u.LIBRARY_CHAINIG_IN_ANNOTATION_TYPE_SUPERTYPE,this,{typeName:this.facetName(),chainedType:v})}else{var A=r.validateDirect(o,!0,!1);A.isOk()||(m=s.error(u.INVALID_ANNOTATION_VALUE,this,{msg:A.getMessage()}),m.addSubStatus(A))}return m&&a.addSubStatus(m),s.setValidationPath(a,{name:this.path}),a},t.prototype.kind=function(){return d.MetaInformationKind.Annotation},t.prototype.ownerFacet=function(){return this._ownerFacet},t.prototype.setOwnerFacet=function(e){this._ownerFacet=e},t}(m);t.Annotation=N;var S=function(e){function t(t,n,r,i){void 0===i&&(i=!1);var a=e.call(this,t,n,!0)||this;return a.name=t,a._type=n,a.optional=r,a.builtIn=i,a}return o(t,e),t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_FacetDeclaration)},t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&f.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_FacetDeclaration)},t.prototype.actualName=function(){return"?"==this.name.charAt(this.name.length-1)?this.name.substr(0,this.name.length-1):this.name},t.prototype.isOptional=function(){return this.optional},t.prototype.type=function(){return this._type},t.prototype.kind=function(){return d.MetaInformationKind.FacetDeclaration},t.prototype.isBuiltIn=function(){return this.builtIn},t.prototype.validateSelfIndividual=function(e,t){return c.validatePropertyType(this._type,this.name,t,this,!1)},t.CLASS_IDENTIFIER_FacetDeclaration="metainfo.FacetDeclaration",t}(m);t.FacetDeclaration=S;var b=function(e){function t(t,n){return e.call(this,t,n,!0)||this}return o(t,e),t.prototype.kind=function(){return d.MetaInformationKind.CustomFacet},t}(m);t.CustomFacet=b;var I=[{propName:"strict",propType:"boolean",messageEntry:u.STRICT_BOOLEAN},{propName:"displayName",propType:"string",messageEntry:u.DISPLAY_NAME_STRING},{propName:"description",propType:"string",messageEntry:u.DESCRIPTION_STRING}],R=function(e){function t(t){return e.call(this,"example",t)||this}return o(t,e),t.prototype.validateSelfIndividual=function(e,t){var n=s.ok();n.addSubStatus(this.validateValue(t));var r=this.validateAnnotations(t);return s.setValidationPath(r,{name:this.facetName()}),n.addSubStatus(r),n},t.prototype.validateValue=function(e){if(!this.owner().oneMeta(E)){var t=this.value(),n=!1,r=s.ok();if("object"==typeof t&&t&&t.hasOwnProperty("value")){for(var a=0,o=I;a<o.length;a++){var l=o[a],p=l.propName,c=l.propType,f=t[p];if(f&&typeof f!=c&&("object"==typeof f&&Object.keys(f).forEach(function(t){if("("==t.charAt(0)&&")"==t.charAt(t.length-1)){var n=new N(t.substring(1,t.length-1),f[t],t,!0),i=n.validateSelf(e);s.setValidationPath(i,{name:"example",child:{name:p,child:{name:t}}}),r.addSubStatus(i)}}),!f.value&&typeof f.value!=c)){
var h=s.error(l.messageEntry,this),d=f.value?{name:"value"}:null;s.setValidationPath(h,{name:"example",child:{name:p,child:d}}),r.addSubStatus(h)}}if(t.strict===!1||"object"==typeof t.strict&&t.strict.value===!1)return r;t=t.value,n=!0}var m=t;if(m=i(t,this.owner()),m instanceof s.Status&&!m.isOk())return s.setValidationPath(m,{name:"example"}),r.addSubStatus(m),r;var y=this.owner().validateDirect(m,!0,!1);if(!y.isOk()){"string"==typeof this.value();var v=s.error(u.INVALID_EXMAPLE,this,{msg:y.getMessage()});y.getErrors().forEach(function(e){v.addSubStatus(e),n?s.setValidationPath(e,{name:"example",child:{name:"value"}}):s.setValidationPath(e,{name:"example"})}),r.addSubStatus(v)}return r}},t.prototype.validateAnnotations=function(e){var t=s.ok(),n=this.value();if("object"==typeof n&&n&&n.value)for(var r=Object.keys(n).filter(function(e){return e.length>2&&"("==e.charAt(0)&&")"==e.charAt(e.length-1)}),i=0,a=r;i<a.length;i++){var o=a[i],u=n[o],l=o.substring(1,o.length-1),p=new N(l,u,o,!0);t.addSubStatus(p.validateSelf(e))}return t},t.prototype.example=function(){var e=this.value();return"object"==typeof e&&e&&e.value&&(e=e.value),i(e,this.owner())},t.prototype.asXMLString=function(){var e=this.value();if("string"==typeof e&&0===e.trim().indexOf("<"))return e;var t=i(e,this.owner());return r(t,this.owner())},t.prototype.kind=function(){return d.MetaInformationKind.Example},t}(m);t.Example=R;var M=function(e){function t(t){return e.call(this,"required",t)||this}return o(t,e),t.prototype.validateSelfIndividual=function(e,t){return"boolean"!=typeof this.value()&&(e=s.error(u.REQUIRED_BOOLEAN,this),s.setValidationPath(e,{name:this.facetName()})),e},t.prototype.kind=function(){return d.MetaInformationKind.Required},t}(m);t.Required=M;var w=function(e){function t(){return e.call(this,"hasPropertiesFacet",null)||this}return o(t,e),t.prototype.kind=function(){return d.MetaInformationKind.HasPropertiesFacet},t}(m);t.HasPropertiesFacet=w;var C=function(e){function t(t){return e.call(this,"allowedTargets",t)||this}return o(t,e),t.prototype.kind=function(){return d.MetaInformationKind.AllowedTargets},t}(m);t.AllowedTargets=C;var L=function(e){function t(t){return e.call(this,"examples",t)||this}return o(t,e),t.prototype.examples=function(){var e=this,t=this.value(),n=[];return Object.keys(t).forEach(function(r){if("object"==typeof t[r]&&t[r]){var a=t[r].value;a||(a=t[r]);var o=i(a,e.owner());n.push(o)}}),n},t.prototype.asXMLStrings=function(){var e=this,t=this.value(),n={};return Object.keys(t).forEach(function(a){var o=t[a];if("string"==typeof o&&0===o.trim().indexOf("<"))return void(n[a]=o);var s=i(o,e.owner());n[a]=r(s,e.owner())}),n},t.prototype.validateSelfIndividual=function(e,t){var n=this;if("object"==typeof this.value()){var r=new l.Status(l.Status.OK,"","",this),o=this.value();return o&&Object.keys(o).forEach(function(e){var u=o[e];if(void 0!==u){var l=null!=u&&"object"==typeof u&&u.hasOwnProperty("value");l&&Object.keys(u).forEach(function(n){if("("==n.charAt(0)&&")"==n.charAt(n.length-1)){var i=new N(n.substring(1,n.length-1),o[e][n],n,!0),a=i.validateSelf(t);s.setValidationPath(a,{name:"examples",child:{name:e,child:{name:n}}}),r.addSubStatus(a)}});var p=u;if(l){p=u.value;for(var c=0,f=I;c<f.length;c++){var h=f[c];n.checkScalarProperty(u,e,h,t,r)}if(u.strict===!1||"object"==typeof u.strict&&u.strict.value===!1)return}var d=p;if(!n.owner().isExternal()&&(d=i(p,n.owner()),d instanceof s.Status))return a(d,!l,e),void r.addSubStatus(d);var m=n.owner().validate(d,!0,!1);m.getErrors().forEach(function(t){r.addSubStatus(t),a(t,!l,e)})}}),r}return s.error(u.EXMAPLES_MAP,this)},t.prototype.checkScalarProperty=function(e,t,n,r,i){var a=n.propName,o=n.propType,u=e[a];if(u&&typeof u!=o){var l=null;if("object"==typeof u&&(l={name:"value"},Object.keys(u).forEach(function(n){if("("==n.charAt(0)&&")"==n.charAt(n.length-1)){var o=new N(n.substring(1,n.length-1),e[a][n],n,!0),u=o.validateSelf(r);s.setValidationPath(u,{name:"examples",child:{name:t,child:{name:a,child:{name:n}}}}),i.addSubStatus(u)}})),!u.value&&typeof u.value!=o){var p=s.error(n.messageEntry,this);s.setValidationPath(p,{name:"examples",child:{name:t,child:{name:a,child:l}}}),i.addSubStatus(p)}}},t.prototype.kind=function(){return d.MetaInformationKind.Examples},t}(m);t.Examples=L;var P=function(e){function t(t){return e.call(this,"xml",t)||this}return o(t,e),t.prototype.kind=function(){return d.MetaInformationKind.XMLInfo},t}(m);t.XMLInfo=P;var O=function(e){function t(t){return e.call(this,"default",t)||this}return o(t,e),t.prototype.validateSelfIndividual=function(e,t){var n=this,r=this.owner().validateDirect(this.value(),!0);if(!r.isOk()){var i=s.error(u.INVALID_DEFAULT_VALUE,this,{msg:r.getMessage()});r.getErrors().forEach(function(e){i.addSubStatus(e),s.setValidationPath(e,{name:n.facetName()})}),e.addSubStatus(i)}return e},t.prototype.kind=function(){return d.MetaInformationKind.Default},t}(m);t.Default=O;var D=function(e){function t(t){var n=e.call(this,!0)||this;return n.property=t,n}return o(t,e),t.prototype.requiredType=function(){return s.OBJECT},t.prototype.value=function(){return this.property},t.prototype.facetName=function(){return"discriminator"},t.prototype.validateSelfIndividual=function(e,t){var n=this;if(this.owner().isUnion())e=s.error(u.DISCRIMINATOR_FOR_UNION,this);else if(this.owner().isSubTypeOf(s.OBJECT))if(this.owner().getExtra(s.GLOBAL)===!1)e=s.error(u.DISCRIMINATOR_FOR_INLINE,this);else{var r=f.find(this.owner().meta(),function(e){return e instanceof p.PropertyIs&&e.propertyName()==n.value()});r?r.value().isScalar()||(e=s.error(u.SCALAR_FOR_DISCRIMINATOR,this)):e=s.error(u.UNKNOWN_FOR_DISCRIMINATOR,this,{value:this.value()},s.Status.WARNING)}else e=s.error(u.DISCRIMINATOR_FOR_OBJECT,this);return e.getValidationPath()||s.setValidationPath(e,{name:this.facetName()}),e},t.prototype.kind=function(){return d.MetaInformationKind.Discriminator},t}(s.TypeInformation);t.Discriminator=D;var U=function(e){function t(t,n){void 0===n&&(n=!0);var r=e.call(this,!1)||this;return r._value=t,r.strict=n,r}return o(t,e),t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_DiscriminatorValue)},t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&f.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_DiscriminatorValue)},t.prototype.check=function(e,n){var r=this.owner(),i=this.value(),a=r.metaOfType(D);if(0==a.length)return s.ok();var o=a[0].value();if(i){if(e.hasOwnProperty(o)){for(var u=this.owner().allSubTypes().concat(this.owner()),p={},c=0,f=u;c<f.length;c++){var h=f[c],d=h.metaOfType(t);d&&d.length>0&&d.forEach(function(e){return p[e.value()]=!0})}var m=e[o];if(!p[m]){var y=s.error(l.Status.CODE_INCORRECT_DISCRIMINATOR,this,{rootType:r.name(),value:m,propName:o},l.Status.WARNING);return s.setValidationPath(y,{name:o,child:n}),y}return s.ok()}var v=s.error(l.Status.CODE_MISSING_DISCRIMINATOR,this,{rootType:r.name(),propName:o});return s.setValidationPath(v,n),v}return s.ok()},t.prototype.facetName=function(){return"discriminatorValue"},t.prototype.validateSelfIndividual=function(e,t){if(this.strict){var n=this.owner().oneMeta(D);if(this.owner().isSubTypeOf(s.OBJECT))if(this.owner().getExtra(s.GLOBAL)===!1)e.addSubStatus(s.error(u.DISCRIMINATOR_FOR_INLINE,this));else if(n){var r=f.find(this.owner().meta(),function(e){return e instanceof p.PropertyIs&&e.propertyName()==n.value()});if(r){var i=r.value().validate(this.value());i.isOk()||e.addSubStatus(s.error(u.INVALID_DISCRIMINATOR_VALUE,this,{msg:i.getMessage()}))}}else e.addSubStatus(s.error(u.DISCRIMINATOR_VALUE_WITHOUT_DISCRIMINATOR,this));else e.addSubStatus(s.error(u.DISCRIMINATOR_FOR_OBJECT,this))}return e.getValidationPath()||s.setValidationPath(e,{name:this.facetName()}),e},t.prototype.requiredType=function(){return s.OBJECT},t.prototype.value=function(){return this._value},t.prototype.kind=function(){return d.MetaInformationKind.DiscriminatorValue},t.prototype.isStrict=function(){return this.strict},t.CLASS_IDENTIFIER_DiscriminatorValue="metainfo.DiscriminatorValue",t}(s.Constraint);t.DiscriminatorValue=U},function(e,t,n){"use strict";function r(e,t,n,r){void 0===n&&(n=0),void 0===r&&(r=!0);for(var i="<"+e,a=0;n>a;a++)i="    "+i;return t&&Object.keys(t).length>0&&Object.keys(t).forEach(function(e){"string"==typeof t[e]&&(i=i+" "+e+'="'+t[e]+'"')}),i=i+">"+(r?"\n":"")}function i(e,t){void 0===t&&(t=0);for(var n="</"+e,r=0;t>r&&r>-1;r++)n="    "+n;var n=(t>-1?"\n":"")+n+">\n";return n}function a(e,t){t=h(t);var n=w(t),a=T(t),s=r(n,o(e,a)),u={};u[n]=e,t.isArray()?(t.meta().filter(function(e){return e instanceof U.ComponentShouldBeOfType})[0],s+=p(u,t,1,!0)):s+=l(e,a,1);var s=s+i(n);return s}function o(e,t){var n={},r=D.filter(t,function(e){return C(e.value()).attribute});return r.forEach(function(t){var r=t.propId(),i=M(t);e[r]&&(n[i]=e[r].toString())}),n}function s(e,t,n){var a=Object.keys(e)[0],p=e[a],c=null;if(t.isScalar()){var f=T(t);c=r(a,o(p,f),n,!t.isScalar())+p.toString()}else{if(t.isUnion())return s(e,u(p,t),n);var f=T(t);c=r(a,o(p,f),n,!t.isScalar())+l(p,f,n+1)}return c+=i(a,t.isScalar()?-1:n)}function u(e,t){var n=t.typeFamily(),r=[],i=null;return n.forEach(function(t){var n=a(e,t);if(n){var i=c(n,t);if(i){var o=f(i);r.push({type:t,errors:o&&o.length||0})}}}),i=r.length>0?r[0]:{type:n[0]},r.forEach(function(e){e.errors<i.errors&&(i=e)}),i.type}function l(e,t,n){var r=D.filter(t,function(e){return!C(e.value()).attribute}),i="";return r.forEach(function(t){var r=M(t),a=t.propId(),o={};o[r]=e[a],i+=t.value().isArray()?p(o,t.value(),n):e[a]||""===e[a]?s(o,t.value(),n):""}),i}function p(e,t,n,a){void 0===a&&(a=!1);var o=Object.keys(e)[0],u=e[o],l=C(t),p=a||l.wrapped,c="",f=R(t),h=f&&f.name(),d=n;return p&&!a&&(c=r(o,null,n),d+=1),u&&P(u)&&u.forEach(function(e){var t={};t[p?h:o]=e,c+=s(t,f,d)}),p&&(c+=i(o,n)),c}function c(e,t){var n=null,r={};return r.explicitChildren=!1,r.explicitArray=!1,r.explicitRoot=m(t)||!t.isExternal(),O.parseString(e,r,function(e,t){if(n=t,e)throw new Error}),n=m(t)?n:v(n,h(t))}function f(e){var t=e[F];return delete e[F],t&&0!==t.length?t.map(function(e){return new k.Status(k.Status.ERROR,"",e,{})}):null}function h(e){return e&&d(e)&&e.superTypes()&&0!==e.superTypes().length?1===e.superTypes().length?e.superTypes()[0]:D.find(e.allSuperTypes(),function(e){return"object"===e.name()})||e:e}function d(e){return!!e&&!!D.find(B,function(t){return e.name()===t})}function m(e){return!!y(e)||!!D.find(e.allSuperTypes(),function(e){return y(e)})}function y(e){return!(!e.isExternal()||!e._content||"string"!=typeof e._content||0!==e._content.trim().indexOf("<"))}function v(e,t){var n,r=Object.keys(e)[0],i=e[r],a=[];if(w(t),t.isArray()){var o=[],s=[],u=t.meta().filter(function(e){return e instanceof U.ComponentShouldBeOfType})[0],l=u&&u.value().name();s.push(l),n=b(i,t,a,!0),_(i,a,o,s)}else n=E(i,t.isUnion()?A(i,t):t,a);return n[F]=a,n}function g(e,t){var n,r=[];n=E(e,t,r);var i=t.validateDirect(n,!0,!1).getErrors();return r.length+(i&&i.length)}function A(e,t){var n=[];if(t.typeFamily().forEach(function(t){return n.push({type:t,errors:g(JSON.parse(JSON.stringify(e)),t)})}),0===n.length)return t;var r=n[0];return n.forEach(function(e){e.errors<r.errors&&(r=e)}),r.type}function E(e,t,n){var r={};if(!t)return e;if(t.isScalar())return L(t,e,n);if(t.isUnion())return E(e,A(e,t),n);var i=T(t),a=[],o=[];return N(e,i,a).forEach(function(e){return r[Object.keys(e)[0]]=e[Object.keys(e)[0]]}),S(e,i,o,n).forEach(function(e){return r[Object.keys(e)[0]]=e[Object.keys(e)[0]]}),_(e,n,a,o),r}function _(e,t,n,r,i){if(void 0===i&&(i=!1),"object"==typeof e){e.$||(e.$={}),n.forEach(function(t){delete e.$[t]}),r.forEach(function(t){delete e[t]});var a=Object.keys(e.$);delete e.$;var o=Object.keys(e);a.forEach(function(e){t.push('Unexpected attribute "'+e+'".')}),o.forEach(function(n){t.push('Unexpected element "'+n+'".'),i&&delete e[n]})}}function T(e){return e.meta().filter(function(e){return e instanceof U.PropertyIs}).map(function(e){return e})||[]}function N(e,t,n){var r=e.$;if(!r)return[];var i=D.filter(t,function(e){return C(e.value()).attribute});return i.map(function(e){var t={},i=e.propId(),a=M(e);n.push(a);var o=r[a];return t[i]=L(e.value(),o),null===t[i]?null:t}).filter(function(e){return e})}function S(e,t,n,r){var i=D.filter(t,function(e){return!C(e.value()).attribute});return i.map(function(t){var i={},a=(C(t.value()),t.propId()),o=M(t);n.push(o);var s=e[o];return t.value().isArray()?i[a]=b(e[o],t.value(),r):i[a]=s||""===s?E(s,t.value(),r):null,null===i[a]?null:i}).filter(function(e){return e})}function b(e,t,n,r){void 0===r&&(r=!1);var i=C(t),a=r||i.wrapped,o=R(t),s=o&&o.name();if(a){var u=e;e=e&&e[s],_(u,n,[],[s],!0)}return e?(e=I(e),e=P(e)?e.map(function(e){return E(e,o,n)}):"object"==typeof e&&e||[]):[]}function I(e){return P(e)?e:"object"==typeof e?[e]:[]}function R(e){if(!e||!e.isArray())return null;var t=e.meta().filter(function(e){return e instanceof U.ComponentShouldBeOfType});return t&&t.length>0&&t[0].value()}function M(e){var t=C(e.value()),n=e.propId(),r=t.name||n;return t.namespace&&(r=t.namespace+":"+r),(t.prefix||"")+r}function w(e){var t=C(e),n=e.name();""===n&&e.isUnion()&&(n="object");var r=t.name||n;return(t.prefix||"")+r}function C(e){var t=e.meta().filter(function(e){return e instanceof x.XMLInfo}).map(function(e){return e})[0],n={attribute:!1,wrapped:!1,name:!1,namespace:!1,prefix:!1};if(!t)return n;var r=t.value();return r?(Object.keys(n).forEach(function(e){n[e]=r[e]||n[e]}),n):n}function L(e,t,n){if(void 0===n&&(n=[]),"object"==typeof t){var r=L(e,t._);return delete t._,_(t,n,[],[],!0),r}if(!t&&""!==t.trim())return null;if(e.isNumber()){var i=parseFloat(t);if(!isNaN(i))return i}if(e.isBoolean()){if("true"===t)return!0;if("false"===t)return!1}return"string"==typeof t?t:null}function P(e){return!!e&&"object"==typeof e&&"number"==typeof e.length}Object.defineProperty(t,"__esModule",{value:!0});var O=n(77),D=n(59),U=n(73),x=n(75),k=n(58),F="@unexpected_root_attributes_and_elements",B=["application/x-www-form-urlencoded","application/json","application/xml","multipart/form-data"];t.serializeToXML=a,t.readObject=c,t.getXmlErrors=f},function(e,t,n){(function(){"use strict";var e,r,i,a,o=function(e,t){function n(){this.constructor=e}for(var r in t)s.call(t,r)&&(e[r]=t[r]);return n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype,e},s={}.hasOwnProperty;r=n(78),e=n(79),i=n(102),a=n(132),t.defaults=r.defaults,t.processors=a,t.ValidationError=function(e){function t(e){this.message=e}return o(t,e),t}(Error),t.Builder=e.Builder,t.Parser=i.Parser,t.parseString=i.parseString}).call(this)},function(e,t){(function(){t.defaults={.1:{explicitCharkey:!1,trim:!0,normalize:!0,normalizeTags:!1,attrkey:"@",charkey:"#",explicitArray:!1,ignoreAttrs:!1,mergeAttrs:!1,explicitRoot:!1,validator:null,xmlns:!1,explicitChildren:!1,childkey:"@@",charsAsChildren:!1,includeWhiteChars:!1,async:!1,strict:!0,attrNameProcessors:null,attrValueProcessors:null,tagNameProcessors:null,valueProcessors:null,emptyTag:""},.2:{explicitCharkey:!1,trim:!1,normalize:!1,normalizeTags:!1,attrkey:"$",charkey:"_",explicitArray:!0,ignoreAttrs:!1,mergeAttrs:!1,explicitRoot:!0,validator:null,xmlns:!1,explicitChildren:!1,preserveChildrenOrder:!1,childkey:"$$",charsAsChildren:!1,includeWhiteChars:!1,async:!1,strict:!0,attrNameProcessors:null,attrValueProcessors:null,tagNameProcessors:null,valueProcessors:null,rootName:"root",xmldec:{version:"1.0",encoding:"UTF-8",standalone:!0},doctype:null,renderOpts:{pretty:!0,indent:"  ",newline:"\n"},headless:!1,chunkSize:1e4,emptyTag:"",cdata:!1}}}).call(this)},function(e,t,n){(function(){"use strict";var e,r,i,a,o,s={}.hasOwnProperty;e=n(80),r=n(78).defaults,a=function(e){return"string"==typeof e&&(e.indexOf("&")>=0||e.indexOf(">")>=0||e.indexOf("<")>=0)},o=function(e){return"<![CDATA["+i(e)+"]]>"},i=function(e){return e.replace("]]>","]]]]><![CDATA[>")},t.Builder=function(){function t(e){var t,n,i;this.options={},n=r[.2];for(t in n)s.call(n,t)&&(i=n[t],this.options[t]=i);for(t in e)s.call(e,t)&&(i=e[t],this.options[t]=i)}return t.prototype.buildObject=function(t){var n,i,u,l,p;return n=this.options.attrkey,i=this.options.charkey,1===Object.keys(t).length&&this.options.rootName===r[.2].rootName?(p=Object.keys(t)[0],t=t[p]):p=this.options.rootName,u=function(e){return function(t,r){var l,p,c,f,h,d;if("object"!=typeof r)e.options.cdata&&a(r)?t.raw(o(r)):t.txt(r);else if(Array.isArray(r)){for(f in r)if(s.call(r,f)){p=r[f];for(h in p)c=p[h],t=u(t.ele(h),c).up()}}else for(h in r)if(s.call(r,h))if(p=r[h],h===n){if("object"==typeof p)for(l in p)d=p[l],t=t.att(l,d)}else if(h===i)t=e.options.cdata&&a(p)?t.raw(o(p)):t.txt(p);else if(Array.isArray(p))for(f in p)s.call(p,f)&&(c=p[f],t="string"==typeof c?e.options.cdata&&a(c)?t.ele(h).raw(o(c)).up():t.ele(h,c).up():u(t.ele(h),c).up());else"object"==typeof p?t=u(t.ele(h),p).up():"string"==typeof p&&e.options.cdata&&a(p)?t=t.ele(h).raw(o(p)).up():(null==p&&(p=""),t=t.ele(h,p.toString()).up());return t}}(this),l=e.create(p,this.options.xmldec,this.options.doctype,{headless:this.options.headless,allowSurrogateChars:this.options.allowSurrogateChars}),u(l,t).end(this.options.renderOpts)},t}()}).call(this)},function(e,t,n){(function(){var t,r,i,a,o,s,u;u=n(81),o=u.assign,s=u.isFunction,t=n(82),r=n(100),a=n(98),i=n(101),e.exports.create=function(e,n,r,i){var a,s;if(null==e)throw new Error("Root element needs a name");return i=o({},n,r,i),a=new t(i),s=a.element(e),i.headless||(a.declaration(i),null==i.pubID&&null==i.sysID||a.doctype(i)),s},e.exports.begin=function(e,n,i){var a;return s(e)&&(a=[e,n],n=a[0],i=a[1],e={}),n?new r(e,n,i):new t(e)},e.exports.stringWriter=function(e){return new a(e)},e.exports.streamWriter=function(e,t){return new i(e,t)}}).call(this)},function(e,t){(function(){var t,n,r,i,a,o,s=[].slice,u={}.hasOwnProperty;t=function(){var e,t,n,r,a,o;if(o=arguments[0],a=2<=arguments.length?s.call(arguments,1):[],i(Object.assign))Object.assign.apply(null,arguments);else for(e=0,n=a.length;n>e;e++)if(r=a[e],null!=r)for(t in r)u.call(r,t)&&(o[t]=r[t]);return o},i=function(e){return!!e&&"[object Function]"===Object.prototype.toString.call(e)},a=function(e){var t;return!!e&&("function"==(t=typeof e)||"object"===t)},n=function(e){return i(Array.isArray)?Array.isArray(e):"[object Array]"===Object.prototype.toString.call(e)},r=function(e){var t;if(n(e))return!e.length;for(t in e)if(u.call(e,t))return!1;return!0},o=function(e){var t,n;return a(e)&&(n=Object.getPrototypeOf(e))&&(t=n.constructor)&&"function"==typeof t&&t instanceof t&&Function.prototype.toString.call(t)===Function.prototype.toString.call(Object)},e.exports.assign=t,e.exports.isFunction=i,e.exports.isObject=a,e.exports.isArray=n,e.exports.isEmpty=r,e.exports.isPlainObject=o}).call(this)},function(e,t,n){(function(){var t,r,i,a,o,s=function(e,t){function n(){this.constructor=e}for(var r in t)u.call(t,r)&&(e[r]=t[r]);return n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype,e},u={}.hasOwnProperty;o=n(81).isPlainObject,r=n(83),a=n(97),i=n(98),e.exports=t=function(e){function t(e){t.__super__.constructor.call(this,null),e||(e={}),e.writer||(e.writer=new i),this.options=e,this.stringify=new a(e),this.isDocument=!0}return s(t,e),t.prototype.end=function(e){var t;return e?o(e)&&(t=e,e=this.options.writer.set(t)):e=this.options.writer,e.document(this)},t.prototype.toString=function(e){return this.options.writer.set(e).document(this)},t}(r)}).call(this)},function(e,t,n){(function(){var t,r,i,a,o,s,u,l,p,c,f,h,d,m={}.hasOwnProperty;d=n(81),h=d.isObject,f=d.isFunction,c=d.isEmpty,o=null,t=null,r=null,i=null,a=null,l=null,p=null,u=null,e.exports=s=function(){function e(e){this.parent=e,this.parent&&(this.options=this.parent.options,this.stringify=this.parent.stringify),this.children=[],o||(o=n(84),t=n(86),r=n(87),i=n(88),a=n(89),l=n(94),p=n(95),u=n(96))}return e.prototype.element=function(e,t,n){var r,i,a,o,s,u,l,p,d,y;if(u=null,null==t&&(t={}),t=t.valueOf(),h(t)||(d=[t,n],n=d[0],t=d[1]),null!=e&&(e=e.valueOf()),Array.isArray(e))for(a=0,l=e.length;l>a;a++)i=e[a],u=this.element(i);else if(f(e))u=this.element(e.apply());else if(h(e)){for(s in e)if(m.call(e,s))if(y=e[s],f(y)&&(y=y.apply()),h(y)&&c(y)&&(y=null),!this.options.ignoreDecorators&&this.stringify.convertAttKey&&0===s.indexOf(this.stringify.convertAttKey))u=this.attribute(s.substr(this.stringify.convertAttKey.length),y);else if(!this.options.separateArrayItems&&Array.isArray(y))for(o=0,p=y.length;p>o;o++)i=y[o],r={},r[s]=i,u=this.element(r);else h(y)?(u=this.element(s),u.element(y)):u=this.element(s,y)}else u=!this.options.ignoreDecorators&&this.stringify.convertTextKey&&0===e.indexOf(this.stringify.convertTextKey)?this.text(n):!this.options.ignoreDecorators&&this.stringify.convertCDataKey&&0===e.indexOf(this.stringify.convertCDataKey)?this.cdata(n):!this.options.ignoreDecorators&&this.stringify.convertCommentKey&&0===e.indexOf(this.stringify.convertCommentKey)?this.comment(n):!this.options.ignoreDecorators&&this.stringify.convertRawKey&&0===e.indexOf(this.stringify.convertRawKey)?this.raw(n):!this.options.ignoreDecorators&&this.stringify.convertPIKey&&0===e.indexOf(this.stringify.convertPIKey)?this.instruction(e.substr(this.stringify.convertPIKey.length),n):this.node(e,t,n);if(null==u)throw new Error("Could not create any elements with: "+e);return u},e.prototype.insertBefore=function(e,t,n){var r,i,a;if(this.isRoot)throw new Error("Cannot insert elements at root level");return i=this.parent.children.indexOf(this),a=this.parent.children.splice(i),r=this.parent.element(e,t,n),Array.prototype.push.apply(this.parent.children,a),r},e.prototype.insertAfter=function(e,t,n){var r,i,a;if(this.isRoot)throw new Error("Cannot insert elements at root level");return i=this.parent.children.indexOf(this),a=this.parent.children.splice(i+1),r=this.parent.element(e,t,n),Array.prototype.push.apply(this.parent.children,a),r},e.prototype.remove=function(){var e,t;if(this.isRoot)throw new Error("Cannot remove the root element");return e=this.parent.children.indexOf(this),[].splice.apply(this.parent.children,[e,e-e+1].concat(t=[])),this.parent},e.prototype.node=function(e,t,n){var r,i;return null!=e&&(e=e.valueOf()),t||(t={}),t=t.valueOf(),h(t)||(i=[t,n],n=i[0],t=i[1]),r=new o(this,e,t),null!=n&&r.text(n),this.children.push(r),r},e.prototype.text=function(e){var t;return t=new p(this,e),this.children.push(t),this},e.prototype.cdata=function(e){var n;return n=new t(this,e),this.children.push(n),this},e.prototype.comment=function(e){var t;return t=new r(this,e),this.children.push(t),this},e.prototype.commentBefore=function(e){var t,n,r;return n=this.parent.children.indexOf(this),r=this.parent.children.splice(n),t=this.parent.comment(e),Array.prototype.push.apply(this.parent.children,r),this},e.prototype.commentAfter=function(e){var t,n,r;return n=this.parent.children.indexOf(this),r=this.parent.children.splice(n+1),t=this.parent.comment(e),Array.prototype.push.apply(this.parent.children,r),this},e.prototype.raw=function(e){var t;return t=new l(this,e),this.children.push(t),this},e.prototype.instruction=function(e,t){var n,r,i,a,o;if(null!=e&&(e=e.valueOf()),null!=t&&(t=t.valueOf()),Array.isArray(e))for(a=0,o=e.length;o>a;a++)n=e[a],this.instruction(n);else if(h(e))for(n in e)m.call(e,n)&&(r=e[n],this.instruction(n,r));else f(t)&&(t=t.apply()),i=new u(this,e,t),this.children.push(i);return this},e.prototype.instructionBefore=function(e,t){var n,r,i;return r=this.parent.children.indexOf(this),i=this.parent.children.splice(r),n=this.parent.instruction(e,t),Array.prototype.push.apply(this.parent.children,i),this},e.prototype.instructionAfter=function(e,t){var n,r,i;return r=this.parent.children.indexOf(this),i=this.parent.children.splice(r+1),n=this.parent.instruction(e,t),Array.prototype.push.apply(this.parent.children,i),this},e.prototype.declaration=function(e,t,n){var r,a;return r=this.document(),a=new i(r,e,t,n),r.children[0]instanceof i?r.children[0]=a:r.children.unshift(a),r.root()||r},e.prototype.doctype=function(e,t){var n,r,i,o,s,u,l,p,c,f;for(r=this.document(),i=new a(r,e,t),c=r.children,o=s=0,l=c.length;l>s;o=++s)if(n=c[o],n instanceof a)return r.children[o]=i,i;for(f=r.children,o=u=0,p=f.length;p>u;o=++u)if(n=f[o],n.isRoot)return r.children.splice(o,0,i),i;return r.children.push(i),i},e.prototype.up=function(){if(this.isRoot)throw new Error("The root node has no parent. Use doc() if you need to get the document object.");return this.parent},e.prototype.root=function(){var e;for(e=this;e;){if(e.isDocument)return e.rootObject;if(e.isRoot)return e;e=e.parent}},e.prototype.document=function(){var e;for(e=this;e;){if(e.isDocument)return e;e=e.parent}},e.prototype.end=function(e){return this.document().end(e)},e.prototype.prev=function(){var e;if(e=this.parent.children.indexOf(this),1>e)throw new Error("Already at the first node");return this.parent.children[e-1]},e.prototype.next=function(){var e;if(e=this.parent.children.indexOf(this),-1===e||e===this.parent.children.length-1)throw new Error("Already at the last node");return this.parent.children[e+1]},e.prototype.importDocument=function(e){var t;return t=e.root().clone(),t.parent=this,t.isRoot=!1,this.children.push(t),this},e.prototype.ele=function(e,t,n){return this.element(e,t,n)},e.prototype.nod=function(e,t,n){return this.node(e,t,n)},e.prototype.txt=function(e){return this.text(e)},e.prototype.dat=function(e){return this.cdata(e)},e.prototype.com=function(e){return this.comment(e)},e.prototype.ins=function(e,t){return this.instruction(e,t)},e.prototype.doc=function(){return this.document()},e.prototype.dec=function(e,t,n){return this.declaration(e,t,n)},e.prototype.dtd=function(e,t){return this.doctype(e,t)},e.prototype.e=function(e,t,n){return this.element(e,t,n)},e.prototype.n=function(e,t,n){return this.node(e,t,n)},e.prototype.t=function(e){return this.text(e)},e.prototype.d=function(e){return this.cdata(e)},e.prototype.c=function(e){return this.comment(e)},e.prototype.r=function(e){return this.raw(e)},e.prototype.i=function(e,t){return this.instruction(e,t)},e.prototype.u=function(){return this.up()},e.prototype.importXMLBuilder=function(e){return this.importDocument(e)},e}()}).call(this)},function(e,t,n){(function(){var t,r,i,a,o,s,u=function(e,t){function n(){this.constructor=e}for(var r in t)l.call(t,r)&&(e[r]=t[r]);return n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype,e},l={}.hasOwnProperty;s=n(81),o=s.isObject,a=s.isFunction,i=n(83),t=n(85),e.exports=r=function(e){function n(e,t,r){if(n.__super__.constructor.call(this,e),null==t)throw new Error("Missing element name");this.name=this.stringify.eleName(t),this.attributes={},null!=r&&this.attribute(r),e.isDocument&&(this.isRoot=!0,this.documentObject=e,e.rootObject=this)}return u(n,e),n.prototype.clone=function(){var e,t,n,r;n=Object.create(this),n.isRoot&&(n.documentObject=null),n.attributes={},r=this.attributes;for(t in r)l.call(r,t)&&(e=r[t],n.attributes[t]=e.clone());return n.children=[],this.children.forEach(function(e){var t;return t=e.clone(),t.parent=n,n.children.push(t)}),n},n.prototype.attribute=function(e,n){var r,i;if(null!=e&&(e=e.valueOf()),o(e))for(r in e)l.call(e,r)&&(i=e[r],this.attribute(r,i));else a(n)&&(n=n.apply()),this.options.skipNullAttributes&&null==n||(this.attributes[e]=new t(this,e,n));return this},n.prototype.removeAttribute=function(e){var t,n,r;if(null==e)throw new Error("Missing attribute name");if(e=e.valueOf(),Array.isArray(e))for(n=0,r=e.length;r>n;n++)t=e[n],delete this.attributes[t];else delete this.attributes[e];return this},n.prototype.toString=function(e){return this.options.writer.set(e).element(this)},n.prototype.att=function(e,t){return this.attribute(e,t)},n.prototype.a=function(e,t){return this.attribute(e,t)},n}(i)}).call(this)},function(e,t){(function(){var t;e.exports=t=function(){function e(e,t,n){if(this.options=e.options,this.stringify=e.stringify,null==t)throw new Error("Missing attribute name of element "+e.name);if(null==n)throw new Error("Missing attribute value for attribute "+t+" of element "+e.name);this.name=this.stringify.attName(t),this.value=this.stringify.attValue(n)}return e.prototype.clone=function(){return Object.create(this)},e.prototype.toString=function(e){return this.options.writer.set(e).attribute(this)},e}()}).call(this)},function(e,t,n){(function(){var t,r,i=function(e,t){function n(){this.constructor=e}for(var r in t)a.call(t,r)&&(e[r]=t[r]);return n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype,e},a={}.hasOwnProperty;r=n(83),e.exports=t=function(e){function t(e,n){if(t.__super__.constructor.call(this,e),null==n)throw new Error("Missing CDATA text");this.text=this.stringify.cdata(n)}return i(t,e),t.prototype.clone=function(){return Object.create(this)},t.prototype.toString=function(e){return this.options.writer.set(e).cdata(this)},t}(r)}).call(this)},function(e,t,n){(function(){var t,r,i=function(e,t){function n(){this.constructor=e}for(var r in t)a.call(t,r)&&(e[r]=t[r]);return n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype,e},a={}.hasOwnProperty;r=n(83),e.exports=t=function(e){function t(e,n){if(t.__super__.constructor.call(this,e),null==n)throw new Error("Missing comment text");this.text=this.stringify.comment(n)}return i(t,e),t.prototype.clone=function(){return Object.create(this)},t.prototype.toString=function(e){return this.options.writer.set(e).comment(this)},t}(r)}).call(this)},function(e,t,n){(function(){var t,r,i,a=function(e,t){function n(){this.constructor=e}for(var r in t)o.call(t,r)&&(e[r]=t[r]);return n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype,e},o={}.hasOwnProperty;i=n(81).isObject,r=n(83),e.exports=t=function(e){function t(e,n,r,a){var o;t.__super__.constructor.call(this,e),i(n)&&(o=n,n=o.version,r=o.encoding,a=o.standalone),n||(n="1.0"),this.version=this.stringify.xmlVersion(n),null!=r&&(this.encoding=this.stringify.xmlEncoding(r)),null!=a&&(this.standalone=this.stringify.xmlStandalone(a))}return a(t,e),t.prototype.toString=function(e){return this.options.writer.set(e).declaration(this)},t}(r)}).call(this)},function(e,t,n){(function(){var t,r,i,a,o,s,u,l=function(e,t){function n(){this.constructor=e}for(var r in t)p.call(t,r)&&(e[r]=t[r]);return n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype,e},p={}.hasOwnProperty;u=n(81).isObject,s=n(83),t=n(90),i=n(91),r=n(92),a=n(93),e.exports=o=function(e){function n(e,t,r){var i,a;n.__super__.constructor.call(this,e),this.documentObject=e,u(t)&&(i=t,t=i.pubID,r=i.sysID),null==r&&(a=[t,r],r=a[0],t=a[1]),null!=t&&(this.pubID=this.stringify.dtdPubID(t)),null!=r&&(this.sysID=this.stringify.dtdSysID(r))}return l(n,e),n.prototype.element=function(e,t){var n;return n=new r(this,e,t),this.children.push(n),this},n.prototype.attList=function(e,n,r,i,a){var o;return o=new t(this,e,n,r,i,a),this.children.push(o),this},n.prototype.entity=function(e,t){var n;return n=new i(this,!1,e,t),this.children.push(n),this},n.prototype.pEntity=function(e,t){var n;return n=new i(this,!0,e,t),this.children.push(n),this},n.prototype.notation=function(e,t){var n;return n=new a(this,e,t),this.children.push(n),this},n.prototype.toString=function(e){return this.options.writer.set(e).docType(this)},n.prototype.ele=function(e,t){return this.element(e,t)},n.prototype.att=function(e,t,n,r,i){return this.attList(e,t,n,r,i)},n.prototype.ent=function(e,t){return this.entity(e,t)},n.prototype.pent=function(e,t){return this.pEntity(e,t)},n.prototype.not=function(e,t){return this.notation(e,t)},n.prototype.up=function(){return this.root()||this.documentObject},n}(s)}).call(this)},function(e,t,n){(function(){var t,r,i=function(e,t){function n(){this.constructor=e}for(var r in t)a.call(t,r)&&(e[r]=t[r]);return n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype,e},a={}.hasOwnProperty;
r=n(83),e.exports=t=function(e){function t(e,n,r,i,a,o){if(t.__super__.constructor.call(this,e),null==n)throw new Error("Missing DTD element name");if(null==r)throw new Error("Missing DTD attribute name");if(!i)throw new Error("Missing DTD attribute type");if(!a)throw new Error("Missing DTD attribute default");if(0!==a.indexOf("#")&&(a="#"+a),!a.match(/^(#REQUIRED|#IMPLIED|#FIXED|#DEFAULT)$/))throw new Error("Invalid default value type; expected: #REQUIRED, #IMPLIED, #FIXED or #DEFAULT");if(o&&!a.match(/^(#FIXED|#DEFAULT)$/))throw new Error("Default value only applies to #FIXED or #DEFAULT");this.elementName=this.stringify.eleName(n),this.attributeName=this.stringify.attName(r),this.attributeType=this.stringify.dtdAttType(i),this.defaultValue=this.stringify.dtdAttDefault(o),this.defaultValueType=a}return i(t,e),t.prototype.toString=function(e){return this.options.writer.set(e).dtdAttList(this)},t}(r)}).call(this)},function(e,t,n){(function(){var t,r,i,a=function(e,t){function n(){this.constructor=e}for(var r in t)o.call(t,r)&&(e[r]=t[r]);return n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype,e},o={}.hasOwnProperty;i=n(81).isObject,r=n(83),e.exports=t=function(e){function t(e,n,r,a){if(t.__super__.constructor.call(this,e),null==r)throw new Error("Missing entity name");if(null==a)throw new Error("Missing entity value");if(this.pe=!!n,this.name=this.stringify.eleName(r),i(a)){if(!a.pubID&&!a.sysID)throw new Error("Public and/or system identifiers are required for an external entity");if(a.pubID&&!a.sysID)throw new Error("System identifier is required for a public external entity");if(null!=a.pubID&&(this.pubID=this.stringify.dtdPubID(a.pubID)),null!=a.sysID&&(this.sysID=this.stringify.dtdSysID(a.sysID)),null!=a.nData&&(this.nData=this.stringify.dtdNData(a.nData)),this.pe&&this.nData)throw new Error("Notation declaration is not allowed in a parameter entity")}else this.value=this.stringify.dtdEntityValue(a)}return a(t,e),t.prototype.toString=function(e){return this.options.writer.set(e).dtdEntity(this)},t}(r)}).call(this)},function(e,t,n){(function(){var t,r,i=function(e,t){function n(){this.constructor=e}for(var r in t)a.call(t,r)&&(e[r]=t[r]);return n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype,e},a={}.hasOwnProperty;r=n(83),e.exports=t=function(e){function t(e,n,r){if(t.__super__.constructor.call(this,e),null==n)throw new Error("Missing DTD element name");r||(r="(#PCDATA)"),Array.isArray(r)&&(r="("+r.join(",")+")"),this.name=this.stringify.eleName(n),this.value=this.stringify.dtdElementValue(r)}return i(t,e),t.prototype.toString=function(e){return this.options.writer.set(e).dtdElement(this)},t}(r)}).call(this)},function(e,t,n){(function(){var t,r,i=function(e,t){function n(){this.constructor=e}for(var r in t)a.call(t,r)&&(e[r]=t[r]);return n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype,e},a={}.hasOwnProperty;r=n(83),e.exports=t=function(e){function t(e,n,r){if(t.__super__.constructor.call(this,e),null==n)throw new Error("Missing notation name");if(!r.pubID&&!r.sysID)throw new Error("Public or system identifiers are required for an external entity");this.name=this.stringify.eleName(n),null!=r.pubID&&(this.pubID=this.stringify.dtdPubID(r.pubID)),null!=r.sysID&&(this.sysID=this.stringify.dtdSysID(r.sysID))}return i(t,e),t.prototype.toString=function(e){return this.options.writer.set(e).dtdNotation(this)},t}(r)}).call(this)},function(e,t,n){(function(){var t,r,i=function(e,t){function n(){this.constructor=e}for(var r in t)a.call(t,r)&&(e[r]=t[r]);return n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype,e},a={}.hasOwnProperty;t=n(83),e.exports=r=function(e){function t(e,n){if(t.__super__.constructor.call(this,e),null==n)throw new Error("Missing raw text");this.value=this.stringify.raw(n)}return i(t,e),t.prototype.clone=function(){return Object.create(this)},t.prototype.toString=function(e){return this.options.writer.set(e).raw(this)},t}(t)}).call(this)},function(e,t,n){(function(){var t,r,i=function(e,t){function n(){this.constructor=e}for(var r in t)a.call(t,r)&&(e[r]=t[r]);return n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype,e},a={}.hasOwnProperty;t=n(83),e.exports=r=function(e){function t(e,n){if(t.__super__.constructor.call(this,e),null==n)throw new Error("Missing element text");this.value=this.stringify.eleText(n)}return i(t,e),t.prototype.clone=function(){return Object.create(this)},t.prototype.toString=function(e){return this.options.writer.set(e).text(this)},t}(t)}).call(this)},function(e,t,n){(function(){var t,r,i=function(e,t){function n(){this.constructor=e}for(var r in t)a.call(t,r)&&(e[r]=t[r]);return n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype,e},a={}.hasOwnProperty;t=n(83),e.exports=r=function(e){function t(e,n,r){if(t.__super__.constructor.call(this,e),null==n)throw new Error("Missing instruction target");this.target=this.stringify.insTarget(n),r&&(this.value=this.stringify.insValue(r))}return i(t,e),t.prototype.clone=function(){return Object.create(this)},t.prototype.toString=function(e){return this.options.writer.set(e).processingInstruction(this)},t}(t)}).call(this)},function(e,t){(function(){var t,n=function(e,t){return function(){return e.apply(t,arguments)}},r={}.hasOwnProperty;e.exports=t=function(){function e(e){this.assertLegalChar=n(this.assertLegalChar,this);var t,i,a;e||(e={}),this.noDoubleEncoding=e.noDoubleEncoding,i=e.stringify||{};for(t in i)r.call(i,t)&&(a=i[t],this[t]=a)}return e.prototype.eleName=function(e){return e=""+e||"",this.assertLegalChar(e)},e.prototype.eleText=function(e){return e=""+e||"",this.assertLegalChar(this.elEscape(e))},e.prototype.cdata=function(e){return e=""+e||"",e=e.replace("]]>","]]]]><![CDATA[>"),this.assertLegalChar(e)},e.prototype.comment=function(e){if(e=""+e||"",e.match(/--/))throw new Error("Comment text cannot contain double-hypen: "+e);return this.assertLegalChar(e)},e.prototype.raw=function(e){return""+e||""},e.prototype.attName=function(e){return e=""+e||""},e.prototype.attValue=function(e){return e=""+e||"",this.attEscape(e)},e.prototype.insTarget=function(e){return""+e||""},e.prototype.insValue=function(e){if(e=""+e||"",e.match(/\?>/))throw new Error("Invalid processing instruction value: "+e);return e},e.prototype.xmlVersion=function(e){if(e=""+e||"",!e.match(/1\.[0-9]+/))throw new Error("Invalid version number: "+e);return e},e.prototype.xmlEncoding=function(e){if(e=""+e||"",!e.match(/^[A-Za-z](?:[A-Za-z0-9._-]|-)*$/))throw new Error("Invalid encoding: "+e);return e},e.prototype.xmlStandalone=function(e){return e?"yes":"no"},e.prototype.dtdPubID=function(e){return""+e||""},e.prototype.dtdSysID=function(e){return""+e||""},e.prototype.dtdElementValue=function(e){return""+e||""},e.prototype.dtdAttType=function(e){return""+e||""},e.prototype.dtdAttDefault=function(e){return null!=e?""+e||"":e},e.prototype.dtdEntityValue=function(e){return""+e||""},e.prototype.dtdNData=function(e){return""+e||""},e.prototype.convertAttKey="@",e.prototype.convertPIKey="?",e.prototype.convertTextKey="#text",e.prototype.convertCDataKey="#cdata",e.prototype.convertCommentKey="#comment",e.prototype.convertRawKey="#raw",e.prototype.assertLegalChar=function(e){var t;if(t=e.match(/[\0\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/))throw new Error("Invalid character in string: "+e+" at index "+t.index);return e},e.prototype.elEscape=function(e){var t;return t=this.noDoubleEncoding?/(?!&\S+;)&/g:/&/g,e.replace(t,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/\r/g,"&#xD;")},e.prototype.attEscape=function(e){var t;return t=this.noDoubleEncoding?/(?!&\S+;)&/g:/&/g,e.replace(t,"&amp;").replace(/</g,"&lt;").replace(/"/g,"&quot;").replace(/\t/g,"&#x9;").replace(/\n/g,"&#xA;").replace(/\r/g,"&#xD;")},e}()}).call(this)},function(e,t,n){(function(){var t,r,i,a,o,s,u,l,p,c,f,h,d,m,y=function(e,t){function n(){this.constructor=e}for(var r in t)v.call(t,r)&&(e[r]=t[r]);return n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype,e},v={}.hasOwnProperty;u=n(88),l=n(89),t=n(86),r=n(87),p=n(84),f=n(94),d=n(95),c=n(96),i=n(90),a=n(92),o=n(91),s=n(93),m=n(99),e.exports=h=function(e){function n(e){n.__super__.constructor.call(this,e)}return y(n,e),n.prototype.document=function(e){var t,n,i,a,o;for(this.textispresent=!1,a="",o=e.children,n=0,i=o.length;i>n;n++)t=o[n],a+=function(){switch(!1){case!(t instanceof u):return this.declaration(t);case!(t instanceof l):return this.docType(t);case!(t instanceof r):return this.comment(t);case!(t instanceof c):return this.processingInstruction(t);default:return this.element(t,0)}}.call(this);return this.pretty&&a.slice(-this.newline.length)===this.newline&&(a=a.slice(0,-this.newline.length)),a},n.prototype.attribute=function(e){return" "+e.name+'="'+e.value+'"'},n.prototype.cdata=function(e,t){return this.space(t)+"<![CDATA["+e.text+"]]>"+this.newline},n.prototype.comment=function(e,t){return this.space(t)+"<!-- "+e.text+" -->"+this.newline},n.prototype.declaration=function(e,t){var n;return n=this.space(t),n+='<?xml version="'+e.version+'"',null!=e.encoding&&(n+=' encoding="'+e.encoding+'"'),null!=e.standalone&&(n+=' standalone="'+e.standalone+'"'),n+=this.spacebeforeslash+"?>",n+=this.newline},n.prototype.docType=function(e,n){var u,l,p,f,h;if(n||(n=0),f=this.space(n),f+="<!DOCTYPE "+e.root().name,e.pubID&&e.sysID?f+=' PUBLIC "'+e.pubID+'" "'+e.sysID+'"':e.sysID&&(f+=' SYSTEM "'+e.sysID+'"'),e.children.length>0){for(f+=" [",f+=this.newline,h=e.children,l=0,p=h.length;p>l;l++)u=h[l],f+=function(){switch(!1){case!(u instanceof i):return this.dtdAttList(u,n+1);case!(u instanceof a):return this.dtdElement(u,n+1);case!(u instanceof o):return this.dtdEntity(u,n+1);case!(u instanceof s):return this.dtdNotation(u,n+1);case!(u instanceof t):return this.cdata(u,n+1);case!(u instanceof r):return this.comment(u,n+1);case!(u instanceof c):return this.processingInstruction(u,n+1);default:throw new Error("Unknown DTD node type: "+u.constructor.name)}}.call(this);f+="]"}return f+=this.spacebeforeslash+">",f+=this.newline},n.prototype.element=function(e,n){var i,a,o,s,u,l,h,m,y,g,A,E,_;n||(n=0),_=!1,this.textispresent?(this.newline="",this.pretty=!1):(this.newline=this.newlinedefault,this.pretty=this.prettydefault),E=this.space(n),m="",m+=E+"<"+e.name,y=e.attributes;for(h in y)v.call(y,h)&&(i=y[h],m+=this.attribute(i));if(0===e.children.length||e.children.every(function(e){return""===e.value}))m+=this.allowEmpty?"></"+e.name+">"+this.newline:this.spacebeforeslash+"/>"+this.newline;else if(this.pretty&&1===e.children.length&&null!=e.children[0].value)m+=">",m+=e.children[0].value,m+="</"+e.name+">"+this.newline;else{if(this.dontprettytextnodes)for(g=e.children,o=0,u=g.length;u>o;o++)if(a=g[o],null!=a.value){this.textispresent++,_=!0;break}for(this.textispresent&&(this.newline="",this.pretty=!1,E=this.space(n)),m+=">"+this.newline,A=e.children,s=0,l=A.length;l>s;s++)a=A[s],m+=function(){switch(!1){case!(a instanceof t):return this.cdata(a,n+1);case!(a instanceof r):return this.comment(a,n+1);case!(a instanceof p):return this.element(a,n+1);case!(a instanceof f):return this.raw(a,n+1);case!(a instanceof d):return this.text(a,n+1);case!(a instanceof c):return this.processingInstruction(a,n+1);default:throw new Error("Unknown XML node type: "+a.constructor.name)}}.call(this);_&&this.textispresent--,this.textispresent||(this.newline=this.newlinedefault,this.pretty=this.prettydefault),m+=E+"</"+e.name+">"+this.newline}return m},n.prototype.processingInstruction=function(e,t){var n;return n=this.space(t)+"<?"+e.target,e.value&&(n+=" "+e.value),n+=this.spacebeforeslash+"?>"+this.newline},n.prototype.raw=function(e,t){return this.space(t)+e.value+this.newline},n.prototype.text=function(e,t){return this.space(t)+e.value+this.newline},n.prototype.dtdAttList=function(e,t){var n;return n=this.space(t)+"<!ATTLIST "+e.elementName+" "+e.attributeName+" "+e.attributeType,"#DEFAULT"!==e.defaultValueType&&(n+=" "+e.defaultValueType),e.defaultValue&&(n+=' "'+e.defaultValue+'"'),n+=this.spacebeforeslash+">"+this.newline},n.prototype.dtdElement=function(e,t){return this.space(t)+"<!ELEMENT "+e.name+" "+e.value+this.spacebeforeslash+">"+this.newline},n.prototype.dtdEntity=function(e,t){var n;return n=this.space(t)+"<!ENTITY",e.pe&&(n+=" %"),n+=" "+e.name,e.value?n+=' "'+e.value+'"':(e.pubID&&e.sysID?n+=' PUBLIC "'+e.pubID+'" "'+e.sysID+'"':e.sysID&&(n+=' SYSTEM "'+e.sysID+'"'),e.nData&&(n+=" NDATA "+e.nData)),n+=this.spacebeforeslash+">"+this.newline},n.prototype.dtdNotation=function(e,t){var n;return n=this.space(t)+"<!NOTATION "+e.name,e.pubID&&e.sysID?n+=' PUBLIC "'+e.pubID+'" "'+e.sysID+'"':e.pubID?n+=' PUBLIC "'+e.pubID+'"':e.sysID&&(n+=' SYSTEM "'+e.sysID+'"'),n+=this.spacebeforeslash+">"+this.newline},n.prototype.openNode=function(e,t){var n,r,i,a;if(t||(t=0),e instanceof p){i=this.space(t)+"<"+e.name,a=e.attributes;for(r in a)v.call(a,r)&&(n=a[r],i+=this.attribute(n));return i+=(e.children?">":"/>")+this.newline}return i=this.space(t)+"<!DOCTYPE "+e.rootNodeName,e.pubID&&e.sysID?i+=' PUBLIC "'+e.pubID+'" "'+e.sysID+'"':e.sysID&&(i+=' SYSTEM "'+e.sysID+'"'),i+=(e.children?" [":">")+this.newline},n.prototype.closeNode=function(e,t){switch(t||(t=0),!1){case!(e instanceof p):return this.space(t)+"</"+e.name+">"+this.newline;case!(e instanceof l):return this.space(t)+"]>"+this.newline}},n}(m)}).call(this)},function(e,t){(function(){var t,n={}.hasOwnProperty;e.exports=t=function(){function e(e){var t,r,i,a,o,s,u,l,p;e||(e={}),this.pretty=e.pretty||!1,this.allowEmpty=null!=(r=e.allowEmpty)&&r,this.pretty?(this.indent=null!=(i=e.indent)?i:"  ",this.newline=null!=(a=e.newline)?a:"\n",this.offset=null!=(o=e.offset)?o:0,this.dontprettytextnodes=null!=(s=e.dontprettytextnodes)?s:0):(this.indent="",this.newline="",this.offset=0,this.dontprettytextnodes=0),this.spacebeforeslash=null!=(u=e.spacebeforeslash)?u:"",this.spacebeforeslash===!0&&(this.spacebeforeslash=" "),this.newlinedefault=this.newline,this.prettydefault=this.pretty,l=e.writer||{};for(t in l)n.call(l,t)&&(p=l[t],this[t]=p)}return e.prototype.set=function(e){var t,r,i;e||(e={}),"pretty"in e&&(this.pretty=e.pretty),"allowEmpty"in e&&(this.allowEmpty=e.allowEmpty),this.pretty?(this.indent="indent"in e?e.indent:"  ",this.newline="newline"in e?e.newline:"\n",this.offset="offset"in e?e.offset:0,this.dontprettytextnodes="dontprettytextnodes"in e?e.dontprettytextnodes:0):(this.indent="",this.newline="",this.offset=0,this.dontprettytextnodes=0),this.spacebeforeslash="spacebeforeslash"in e?e.spacebeforeslash:"",this.spacebeforeslash===!0&&(this.spacebeforeslash=" "),this.newlinedefault=this.newline,this.prettydefault=this.pretty,r=e.writer||{};for(t in r)n.call(r,t)&&(i=r[t],this[t]=i);return this},e.prototype.space=function(e){var t;return this.pretty?(t=(e||0)+this.offset+1,t>0?new Array(t).join(this.indent):""):""},e}()}).call(this)},function(e,t,n){(function(){var t,r,i,a,o,s,u,l,p,c,f,h,d,m,y,v,g,A,E,_,T={}.hasOwnProperty;_=n(81),A=_.isObject,g=_.isFunction,E=_.isPlainObject,f=n(84),r=n(86),i=n(87),d=n(94),v=n(95),h=n(96),l=n(88),p=n(89),a=n(90),s=n(91),o=n(92),u=n(93),t=n(85),y=n(97),m=n(98),e.exports=c=function(){function e(e,t,n){var r;e||(e={}),e.writer?E(e.writer)&&(r=e.writer,e.writer=new m(r)):e.writer=new m(e),this.options=e,this.writer=e.writer,this.stringify=new y(e),this.onDataCallback=t||function(){},this.onEndCallback=n||function(){},this.currentNode=null,this.currentLevel=-1,this.openTags={},this.documentStarted=!1,this.documentCompleted=!1,this.root=null}return e.prototype.node=function(e,t,n){var r;if(null==e)throw new Error("Missing node name");if(this.root&&-1===this.currentLevel)throw new Error("Document can only have one root node");return this.openCurrent(),e=e.valueOf(),null==t&&(t={}),t=t.valueOf(),A(t)||(r=[t,n],n=r[0],t=r[1]),this.currentNode=new f(this,e,t),this.currentNode.children=!1,this.currentLevel++,this.openTags[this.currentLevel]=this.currentNode,null!=n&&this.text(n),this},e.prototype.element=function(e,t,n){return this.currentNode&&this.currentNode instanceof p?this.dtdElement.apply(this,arguments):this.node(e,t,n)},e.prototype.attribute=function(e,n){var r,i;if(!this.currentNode||this.currentNode.children)throw new Error("att() can only be used immediately after an ele() call in callback mode");if(null!=e&&(e=e.valueOf()),A(e))for(r in e)T.call(e,r)&&(i=e[r],this.attribute(r,i));else g(n)&&(n=n.apply()),this.options.skipNullAttributes&&null==n||(this.currentNode.attributes[e]=new t(this,e,n));return this},e.prototype.text=function(e){var t;return this.openCurrent(),t=new v(this,e),this.onData(this.writer.text(t,this.currentLevel+1)),this},e.prototype.cdata=function(e){var t;return this.openCurrent(),t=new r(this,e),this.onData(this.writer.cdata(t,this.currentLevel+1)),this},e.prototype.comment=function(e){var t;return this.openCurrent(),t=new i(this,e),this.onData(this.writer.comment(t,this.currentLevel+1)),this},e.prototype.raw=function(e){var t;return this.openCurrent(),t=new d(this,e),this.onData(this.writer.raw(t,this.currentLevel+1)),this},e.prototype.instruction=function(e,t){var n,r,i,a,o;if(this.openCurrent(),null!=e&&(e=e.valueOf()),null!=t&&(t=t.valueOf()),Array.isArray(e))for(n=0,a=e.length;a>n;n++)r=e[n],this.instruction(r);else if(A(e))for(r in e)T.call(e,r)&&(i=e[r],this.instruction(r,i));else g(t)&&(t=t.apply()),o=new h(this,e,t),this.onData(this.writer.processingInstruction(o,this.currentLevel+1));return this},e.prototype.declaration=function(e,t,n){var r;if(this.openCurrent(),this.documentStarted)throw new Error("declaration() must be the first node");return r=new l(this,e,t,n),this.onData(this.writer.declaration(r,this.currentLevel+1)),this},e.prototype.doctype=function(e,t,n){if(this.openCurrent(),null==e)throw new Error("Missing root node name");if(this.root)throw new Error("dtd() must come before the root node");return this.currentNode=new p(this,t,n),this.currentNode.rootNodeName=e,this.currentNode.children=!1,this.currentLevel++,this.openTags[this.currentLevel]=this.currentNode,this},e.prototype.dtdElement=function(e,t){var n;return this.openCurrent(),n=new o(this,e,t),this.onData(this.writer.dtdElement(n,this.currentLevel+1)),this},e.prototype.attList=function(e,t,n,r,i){var o;return this.openCurrent(),o=new a(this,e,t,n,r,i),this.onData(this.writer.dtdAttList(o,this.currentLevel+1)),this},e.prototype.entity=function(e,t){var n;return this.openCurrent(),n=new s(this,!1,e,t),this.onData(this.writer.dtdEntity(n,this.currentLevel+1)),this},e.prototype.pEntity=function(e,t){var n;return this.openCurrent(),n=new s(this,!0,e,t),this.onData(this.writer.dtdEntity(n,this.currentLevel+1)),this},e.prototype.notation=function(e,t){var n;return this.openCurrent(),n=new u(this,e,t),this.onData(this.writer.dtdNotation(n,this.currentLevel+1)),this},e.prototype.up=function(){if(this.currentLevel<0)throw new Error("The document node has no parent");return this.currentNode?(this.currentNode.children?this.closeNode(this.currentNode):this.openNode(this.currentNode),this.currentNode=null):this.closeNode(this.openTags[this.currentLevel]),delete this.openTags[this.currentLevel],this.currentLevel--,this},e.prototype.end=function(){for(;this.currentLevel>=0;)this.up();return this.onEnd()},e.prototype.openCurrent=function(){return this.currentNode?(this.currentNode.children=!0,this.openNode(this.currentNode)):void 0},e.prototype.openNode=function(e){return e.isOpen?void 0:(!this.root&&0===this.currentLevel&&e instanceof f&&(this.root=e),this.onData(this.writer.openNode(e,this.currentLevel)),e.isOpen=!0)},e.prototype.closeNode=function(e){return e.isClosed?void 0:(this.onData(this.writer.closeNode(e,this.currentLevel)),e.isClosed=!0)},e.prototype.onData=function(e){return this.documentStarted=!0,this.onDataCallback(e)},e.prototype.onEnd=function(){return this.documentCompleted=!0,this.onEndCallback()},e.prototype.ele=function(){return this.element.apply(this,arguments)},e.prototype.nod=function(e,t,n){return this.node(e,t,n)},e.prototype.txt=function(e){return this.text(e)},e.prototype.dat=function(e){return this.cdata(e)},e.prototype.com=function(e){return this.comment(e)},e.prototype.ins=function(e,t){return this.instruction(e,t)},e.prototype.dec=function(e,t,n){return this.declaration(e,t,n)},e.prototype.dtd=function(e,t,n){return this.doctype(e,t,n)},e.prototype.e=function(e,t,n){return this.element(e,t,n)},e.prototype.n=function(e,t,n){return this.node(e,t,n)},e.prototype.t=function(e){return this.text(e)},e.prototype.d=function(e){return this.cdata(e)},e.prototype.c=function(e){return this.comment(e)},e.prototype.r=function(e){return this.raw(e)},e.prototype.i=function(e,t){return this.instruction(e,t)},e.prototype.att=function(){return this.currentNode&&this.currentNode instanceof p?this.attList.apply(this,arguments):this.attribute.apply(this,arguments)},e.prototype.a=function(){return this.currentNode&&this.currentNode instanceof p?this.attList.apply(this,arguments):this.attribute.apply(this,arguments)},e.prototype.ent=function(e,t){return this.entity(e,t)},e.prototype.pent=function(e,t){return this.pEntity(e,t)},e.prototype.not=function(e,t){return this.notation(e,t)},e}()}).call(this)},function(e,t,n){(function(){var t,r,i,a,o,s,u,l,p,c,f,h,d,m,y=function(e,t){function n(){this.constructor=e}for(var r in t)v.call(t,r)&&(e[r]=t[r]);return n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype,e},v={}.hasOwnProperty;u=n(88),l=n(89),t=n(86),r=n(87),p=n(84),f=n(94),d=n(95),c=n(96),i=n(90),a=n(92),o=n(91),s=n(93),m=n(99),e.exports=h=function(e){function n(e,t){this.stream=e,n.__super__.constructor.call(this,t)}return y(n,e),n.prototype.document=function(e){var t,n,i,a,o,s,p,f;for(s=e.children,n=0,a=s.length;a>n;n++)t=s[n],t.isLastRootNode=!1;for(e.children[e.children.length-1].isLastRootNode=!0,p=e.children,f=[],i=0,o=p.length;o>i;i++)switch(t=p[i],!1){case!(t instanceof u):f.push(this.declaration(t));break;case!(t instanceof l):f.push(this.docType(t));break;case!(t instanceof r):f.push(this.comment(t));break;case!(t instanceof c):f.push(this.processingInstruction(t));break;default:f.push(this.element(t))}return f},n.prototype.attribute=function(e){return this.stream.write(" "+e.name+'="'+e.value+'"')},n.prototype.cdata=function(e,t){return this.stream.write(this.space(t)+"<![CDATA["+e.text+"]]>"+this.endline(e))},n.prototype.comment=function(e,t){return this.stream.write(this.space(t)+"<!-- "+e.text+" -->"+this.endline(e))},n.prototype.declaration=function(e,t){return this.stream.write(this.space(t)),this.stream.write('<?xml version="'+e.version+'"'),null!=e.encoding&&this.stream.write(' encoding="'+e.encoding+'"'),null!=e.standalone&&this.stream.write(' standalone="'+e.standalone+'"'),this.stream.write(this.spacebeforeslash+"?>"),this.stream.write(this.endline(e))},n.prototype.docType=function(e,n){var u,l,p,f;if(n||(n=0),this.stream.write(this.space(n)),this.stream.write("<!DOCTYPE "+e.root().name),e.pubID&&e.sysID?this.stream.write(' PUBLIC "'+e.pubID+'" "'+e.sysID+'"'):e.sysID&&this.stream.write(' SYSTEM "'+e.sysID+'"'),e.children.length>0){for(this.stream.write(" ["),this.stream.write(this.endline(e)),f=e.children,l=0,p=f.length;p>l;l++)switch(u=f[l],!1){case!(u instanceof i):this.dtdAttList(u,n+1);break;case!(u instanceof a):this.dtdElement(u,n+1);break;case!(u instanceof o):this.dtdEntity(u,n+1);break;case!(u instanceof s):this.dtdNotation(u,n+1);break;case!(u instanceof t):this.cdata(u,n+1);break;case!(u instanceof r):this.comment(u,n+1);break;case!(u instanceof c):this.processingInstruction(u,n+1);break;default:throw new Error("Unknown DTD node type: "+u.constructor.name)}this.stream.write("]")}return this.stream.write(this.spacebeforeslash+">"),this.stream.write(this.endline(e))},n.prototype.element=function(e,n){var i,a,o,s,u,l,h,m;n||(n=0),m=this.space(n),this.stream.write(m+"<"+e.name),l=e.attributes;for(u in l)v.call(l,u)&&(i=l[u],this.attribute(i));if(0===e.children.length||e.children.every(function(e){return""===e.value}))this.allowEmpty?this.stream.write("></"+e.name+">"):this.stream.write(this.spacebeforeslash+"/>");else if(this.pretty&&1===e.children.length&&null!=e.children[0].value)this.stream.write(">"),this.stream.write(e.children[0].value),this.stream.write("</"+e.name+">");else{for(this.stream.write(">"+this.newline),h=e.children,o=0,s=h.length;s>o;o++)switch(a=h[o],!1){case!(a instanceof t):this.cdata(a,n+1);break;case!(a instanceof r):this.comment(a,n+1);break;case!(a instanceof p):this.element(a,n+1);break;case!(a instanceof f):this.raw(a,n+1);break;case!(a instanceof d):this.text(a,n+1);break;case!(a instanceof c):this.processingInstruction(a,n+1);break;default:throw new Error("Unknown XML node type: "+a.constructor.name)}this.stream.write(m+"</"+e.name+">")}return this.stream.write(this.endline(e))},n.prototype.processingInstruction=function(e,t){return this.stream.write(this.space(t)+"<?"+e.target),e.value&&this.stream.write(" "+e.value),this.stream.write(this.spacebeforeslash+"?>"+this.endline(e))},n.prototype.raw=function(e,t){return this.stream.write(this.space(t)+e.value+this.endline(e))},n.prototype.text=function(e,t){return this.stream.write(this.space(t)+e.value+this.endline(e))},n.prototype.dtdAttList=function(e,t){return this.stream.write(this.space(t)+"<!ATTLIST "+e.elementName+" "+e.attributeName+" "+e.attributeType),"#DEFAULT"!==e.defaultValueType&&this.stream.write(" "+e.defaultValueType),e.defaultValue&&this.stream.write(' "'+e.defaultValue+'"'),this.stream.write(this.spacebeforeslash+">"+this.endline(e))},n.prototype.dtdElement=function(e,t){return this.stream.write(this.space(t)+"<!ELEMENT "+e.name+" "+e.value),this.stream.write(this.spacebeforeslash+">"+this.endline(e))},n.prototype.dtdEntity=function(e,t){return this.stream.write(this.space(t)+"<!ENTITY"),e.pe&&this.stream.write(" %"),this.stream.write(" "+e.name),e.value?this.stream.write(' "'+e.value+'"'):(e.pubID&&e.sysID?this.stream.write(' PUBLIC "'+e.pubID+'" "'+e.sysID+'"'):e.sysID&&this.stream.write(' SYSTEM "'+e.sysID+'"'),e.nData&&this.stream.write(" NDATA "+e.nData)),this.stream.write(this.spacebeforeslash+">"+this.endline(e))},n.prototype.dtdNotation=function(e,t){return this.stream.write(this.space(t)+"<!NOTATION "+e.name),e.pubID&&e.sysID?this.stream.write(' PUBLIC "'+e.pubID+'" "'+e.sysID+'"'):e.pubID?this.stream.write(' PUBLIC "'+e.pubID+'"'):e.sysID&&this.stream.write(' SYSTEM "'+e.sysID+'"'),this.stream.write(this.spacebeforeslash+">"+this.endline(e))},n.prototype.endline=function(e){return e.isLastRootNode?"":this.newline},n}(m)}).call(this)},function(e,t,n){(function(){"use strict";var e,r,i,a,o,s,u,l,p=function(e,t){return function(){return e.apply(t,arguments)}},c=function(e,t){function n(){this.constructor=e}for(var r in t)f.call(t,r)&&(e[r]=t[r]);return n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype,e},f={}.hasOwnProperty;u=n(103),i=n(105),e=n(131),s=n(132),l=n(120).setImmediate,r=n(78).defaults,a=function(e){return"object"==typeof e&&null!=e&&0===Object.keys(e).length},o=function(e,t,n){var r,i,a;for(r=0,i=e.length;i>r;r++)a=e[r],t=a(t,n);return t},t.Parser=function(n){function i(e){this.parseString=p(this.parseString,this),this.reset=p(this.reset,this),this.assignOrPush=p(this.assignOrPush,this),this.processAsync=p(this.processAsync,this);var n,i,a;if(!(this instanceof t.Parser))return new t.Parser(e);this.options={},i=r[.2];for(n in i)f.call(i,n)&&(a=i[n],this.options[n]=a);for(n in e)f.call(e,n)&&(a=e[n],this.options[n]=a);this.options.xmlns&&(this.options.xmlnskey=this.options.attrkey+"ns"),this.options.normalizeTags&&(this.options.tagNameProcessors||(this.options.tagNameProcessors=[]),this.options.tagNameProcessors.unshift(s.normalize)),this.reset()}return c(i,n),i.prototype.processAsync=function(){var e,t;try{return this.remaining.length<=this.options.chunkSize?(e=this.remaining,this.remaining="",this.saxParser=this.saxParser.write(e),this.saxParser.close()):(e=this.remaining.substr(0,this.options.chunkSize),this.remaining=this.remaining.substr(this.options.chunkSize,this.remaining.length),this.saxParser=this.saxParser.write(e),l(this.processAsync))}catch(e){if(t=e,!this.saxParser.errThrown)return this.saxParser.errThrown=!0,this.emit(t)}},i.prototype.assignOrPush=function(e,t,n){return t in e?(e[t]instanceof Array||(e[t]=[e[t]]),e[t].push(n)):this.options.explicitArray?e[t]=[n]:e[t]=n},i.prototype.reset=function(){var e,t,n,r;return this.removeAllListeners(),this.saxParser=u.parser(this.options.strict,{trim:!1,normalize:!1,xmlns:this.options.xmlns}),this.saxParser.errThrown=!1,this.saxParser.onerror=function(e){return function(t){return e.saxParser.resume(),e.saxParser.errThrown?void 0:(e.saxParser.errThrown=!0,e.emit("error",t))}}(this),this.saxParser.onend=function(e){return function(){return e.saxParser.ended?void 0:(e.saxParser.ended=!0,e.emit("end",e.resultObject))}}(this),this.saxParser.ended=!1,this.EXPLICIT_CHARKEY=this.options.explicitCharkey,this.resultObject=null,r=[],e=this.options.attrkey,t=this.options.charkey,this.saxParser.onopentag=function(n){return function(i){var a,s,u,l,p;if(u={},u[t]="",!n.options.ignoreAttrs){p=i.attributes;for(a in p)f.call(p,a)&&(e in u||n.options.mergeAttrs||(u[e]={}),s=n.options.attrValueProcessors?o(n.options.attrValueProcessors,i.attributes[a],a):i.attributes[a],l=n.options.attrNameProcessors?o(n.options.attrNameProcessors,a):a,n.options.mergeAttrs?n.assignOrPush(u,l,s):u[e][l]=s)}return u["#name"]=n.options.tagNameProcessors?o(n.options.tagNameProcessors,i.name):i.name,n.options.xmlns&&(u[n.options.xmlnskey]={uri:i.uri,local:i.local}),r.push(u)}}(this),this.saxParser.onclosetag=function(e){return function(){var n,i,s,u,l,p,c,h,d,m;if(p=r.pop(),l=p["#name"],e.options.explicitChildren&&e.options.preserveChildrenOrder||delete p["#name"],p.cdata===!0&&(n=p.cdata,delete p.cdata),d=r[r.length-1],p[t].match(/^\s*$/)&&!n?(i=p[t],delete p[t]):(e.options.trim&&(p[t]=p[t].trim()),e.options.normalize&&(p[t]=p[t].replace(/\s{2,}/g," ").trim()),p[t]=e.options.valueProcessors?o(e.options.valueProcessors,p[t],l):p[t],1===Object.keys(p).length&&t in p&&!e.EXPLICIT_CHARKEY&&(p=p[t])),a(p)&&(p=""!==e.options.emptyTag?e.options.emptyTag:i),null!=e.options.validator&&(m="/"+function(){var e,t,n;for(n=[],e=0,t=r.length;t>e;e++)u=r[e],n.push(u["#name"]);return n}().concat(l).join("/"),function(){var t;try{return p=e.options.validator(m,d&&d[l],p)}catch(n){return t=n,e.emit("error",t)}}()),e.options.explicitChildren&&!e.options.mergeAttrs&&"object"==typeof p)if(e.options.preserveChildrenOrder){if(d){d[e.options.childkey]=d[e.options.childkey]||[],c={};for(s in p)f.call(p,s)&&(c[s]=p[s]);d[e.options.childkey].push(c),delete p["#name"],1===Object.keys(p).length&&t in p&&!e.EXPLICIT_CHARKEY&&(p=p[t])}}else u={},e.options.attrkey in p&&(u[e.options.attrkey]=p[e.options.attrkey],delete p[e.options.attrkey]),!e.options.charsAsChildren&&e.options.charkey in p&&(u[e.options.charkey]=p[e.options.charkey],delete p[e.options.charkey]),Object.getOwnPropertyNames(p).length>0&&(u[e.options.childkey]=p),p=u;return r.length>0?e.assignOrPush(d,l,p):(e.options.explicitRoot&&(h=p,p={},p[l]=h),e.resultObject=p,e.saxParser.ended=!0,e.emit("end",e.resultObject))}}(this),n=function(e){return function(n){var i,a;return(a=r[r.length-1])?(a[t]+=n,e.options.explicitChildren&&e.options.preserveChildrenOrder&&e.options.charsAsChildren&&(e.options.includeWhiteChars||""!==n.replace(/\\n/g,"").trim())&&(a[e.options.childkey]=a[e.options.childkey]||[],i={"#name":"__text__"},i[t]=n,e.options.normalize&&(i[t]=i[t].replace(/\s{2,}/g," ").trim()),a[e.options.childkey].push(i)),a):void 0}}(this),this.saxParser.ontext=n,this.saxParser.oncdata=function(e){return function(e){var t;return(t=n(e))?t.cdata=!0:void 0}}(this)},i.prototype.parseString=function(t,n){var r;null!=n&&"function"==typeof n&&(this.on("end",function(e){return this.reset(),n(null,e)}),
this.on("error",function(e){return this.reset(),n(e)}));try{return t=t.toString(),""===t.trim()?(this.emit("end",null),!0):(t=e.stripBOM(t),this.options.async?(this.remaining=t,l(this.processAsync),this.saxParser):this.saxParser.write(t).close())}catch(e){if(r=e,!this.saxParser.errThrown&&!this.saxParser.ended)return this.emit("error",r),this.saxParser.errThrown=!0;if(this.saxParser.ended)throw r}},i}(i.EventEmitter),t.parseString=function(e,n,r){var i,a,o;return null!=r?("function"==typeof r&&(i=r),"object"==typeof n&&(a=n)):("function"==typeof n&&(i=n),a={}),o=new t.Parser(a),o.parseString(e,i)}}).call(this)},function(e,t,n){(function(e){!function(t){function r(e,n){if(!(this instanceof r))return new r(e,n);var i=this;a(i),i.q=i.c="",i.bufferCheckPosition=t.MAX_BUFFER_LENGTH,i.opt=n||{},i.opt.lowercase=i.opt.lowercase||i.opt.lowercasetags,i.looseCase=i.opt.lowercase?"toLowerCase":"toUpperCase",i.tags=[],i.closed=i.closedRoot=i.sawRoot=!1,i.tag=i.error=null,i.strict=!!e,i.noscript=!(!e&&!i.opt.noscript),i.state=j.BEGIN,i.strictEntities=i.opt.strictEntities,i.ENTITIES=i.strictEntities?Object.create(t.XML_ENTITIES):Object.create(t.ENTITIES),i.attribList=[],i.opt.xmlns&&(i.ns=Object.create(k)),i.trackPosition=i.opt.position!==!1,i.trackPosition&&(i.position=i.line=i.column=0),d(i,"onready")}function i(e){for(var n=Math.max(t.MAX_BUFFER_LENGTH,10),r=0,i=0,a=C.length;a>i;i++){var o=e[C[i]].length;if(o>n)switch(C[i]){case"textNode":y(e);break;case"cdata":m(e,"oncdata",e.cdata),e.cdata="";break;case"script":m(e,"onscript",e.script),e.script="";break;default:g(e,"Max buffer length exceeded: "+C[i])}r=Math.max(r,o)}var s=t.MAX_BUFFER_LENGTH-r;e.bufferCheckPosition=s+e.position}function a(e){for(var t=0,n=C.length;n>t;t++)e[C[t]]=""}function o(e){y(e),""!==e.cdata&&(m(e,"oncdata",e.cdata),e.cdata=""),""!==e.script&&(m(e,"onscript",e.script),e.script="")}function s(e,t){return new u(e,t)}function u(e,t){if(!(this instanceof u))return new u(e,t);L.apply(this),this._parser=new r(e,t),this.writable=!0,this.readable=!0;var n=this;this._parser.onend=function(){n.emit("end")},this._parser.onerror=function(e){n.emit("error",e),n._parser.error=null},this._decoder=null,P.forEach(function(e){Object.defineProperty(n,"on"+e,{get:function(){return n._parser["on"+e]},set:function(t){return t?void n.on(e,t):(n.removeAllListeners(e),n._parser["on"+e]=t,t)},enumerable:!0,configurable:!1})})}function l(e){return" "===e||"\n"===e||"\r"===e||"	"===e}function p(e){return'"'===e||"'"===e}function c(e){return">"===e||l(e)}function f(e,t){return e.test(t)}function h(e,t){return!f(e,t)}function d(e,t,n){e[t]&&e[t](n)}function m(e,t,n){e.textNode&&y(e),d(e,t,n)}function y(e){e.textNode=v(e.opt,e.textNode),e.textNode&&d(e,"ontext",e.textNode),e.textNode=""}function v(e,t){return e.trim&&(t=t.trim()),e.normalize&&(t=t.replace(/\s+/g," ")),t}function g(e,t){return y(e),e.trackPosition&&(t+="\nLine: "+e.line+"\nColumn: "+e.column+"\nChar: "+e.c),t=new Error(t),e.error=t,d(e,"onerror",t),e}function A(e){return e.sawRoot&&!e.closedRoot&&E(e,"Unclosed root tag"),e.state!==j.BEGIN&&e.state!==j.BEGIN_WHITESPACE&&e.state!==j.TEXT&&g(e,"Unexpected end"),y(e),e.c="",e.closed=!0,d(e,"onend"),r.call(e,e.strict,e.opt),e}function E(e,t){if("object"!=typeof e||!(e instanceof r))throw new Error("bad call to strictFail");e.strict&&g(e,t)}function _(e){e.strict||(e.tagName=e.tagName[e.looseCase]());var t=e.tags[e.tags.length-1]||e,n=e.tag={name:e.tagName,attributes:{}};e.opt.xmlns&&(n.ns=t.ns),e.attribList.length=0,m(e,"onopentagstart",n)}function T(e,t){var n=e.indexOf(":"),r=0>n?["",e]:e.split(":"),i=r[0],a=r[1];return t&&"xmlns"===e&&(i="xmlns",a=""),{prefix:i,local:a}}function N(e){if(e.strict||(e.attribName=e.attribName[e.looseCase]()),-1!==e.attribList.indexOf(e.attribName)||e.tag.attributes.hasOwnProperty(e.attribName))return void(e.attribName=e.attribValue="");if(e.opt.xmlns){var t=T(e.attribName,!0),n=t.prefix,r=t.local;if("xmlns"===n)if("xml"===r&&e.attribValue!==U)E(e,"xml: prefix must be bound to "+U+"\nActual: "+e.attribValue);else if("xmlns"===r&&e.attribValue!==x)E(e,"xmlns: prefix must be bound to "+x+"\nActual: "+e.attribValue);else{var i=e.tag,a=e.tags[e.tags.length-1]||e;i.ns===a.ns&&(i.ns=Object.create(a.ns)),i.ns[r]=e.attribValue}e.attribList.push([e.attribName,e.attribValue])}else e.tag.attributes[e.attribName]=e.attribValue,m(e,"onattribute",{name:e.attribName,value:e.attribValue});e.attribName=e.attribValue=""}function S(e,t){if(e.opt.xmlns){var n=e.tag,r=T(e.tagName);n.prefix=r.prefix,n.local=r.local,n.uri=n.ns[r.prefix]||"",n.prefix&&!n.uri&&(E(e,"Unbound namespace prefix: "+JSON.stringify(e.tagName)),n.uri=r.prefix);var i=e.tags[e.tags.length-1]||e;n.ns&&i.ns!==n.ns&&Object.keys(n.ns).forEach(function(t){m(e,"onopennamespace",{prefix:t,uri:n.ns[t]})});for(var a=0,o=e.attribList.length;o>a;a++){var s=e.attribList[a],u=s[0],l=s[1],p=T(u,!0),c=p.prefix,f=p.local,h=""===c?"":n.ns[c]||"",d={name:u,value:l,prefix:c,local:f,uri:h};c&&"xmlns"!==c&&!h&&(E(e,"Unbound namespace prefix: "+JSON.stringify(c)),d.uri=c),e.tag.attributes[u]=d,m(e,"onattribute",d)}e.attribList.length=0}e.tag.isSelfClosing=!!t,e.sawRoot=!0,e.tags.push(e.tag),m(e,"onopentag",e.tag),t||(e.noscript||"script"!==e.tagName.toLowerCase()?e.state=j.TEXT:e.state=j.SCRIPT,e.tag=null,e.tagName=""),e.attribName=e.attribValue="",e.attribList.length=0}function b(e){if(!e.tagName)return E(e,"Weird empty close tag."),e.textNode+="</>",void(e.state=j.TEXT);if(e.script){if("script"!==e.tagName)return e.script+="</"+e.tagName+">",e.tagName="",void(e.state=j.SCRIPT);m(e,"onscript",e.script),e.script=""}var t=e.tags.length,n=e.tagName;e.strict||(n=n[e.looseCase]());for(var r=n;t--;){var i=e.tags[t];if(i.name===r)break;E(e,"Unexpected close tag")}if(0>t)return E(e,"Unmatched closing tag: "+e.tagName),e.textNode+="</"+e.tagName+">",void(e.state=j.TEXT);e.tagName=n;for(var a=e.tags.length;a-->t;){var o=e.tag=e.tags.pop();e.tagName=e.tag.name,m(e,"onclosetag",e.tagName);var s={};for(var u in o.ns)s[u]=o.ns[u];var l=e.tags[e.tags.length-1]||e;e.opt.xmlns&&o.ns!==l.ns&&Object.keys(o.ns).forEach(function(t){var n=o.ns[t];m(e,"onclosenamespace",{prefix:t,uri:n})})}0===t&&(e.closedRoot=!0),e.tagName=e.attribValue=e.attribName="",e.attribList.length=0,e.state=j.TEXT}function I(e){var t,n=e.entity,r=n.toLowerCase(),i="";return e.ENTITIES[n]?e.ENTITIES[n]:e.ENTITIES[r]?e.ENTITIES[r]:(n=r,"#"===n.charAt(0)&&("x"===n.charAt(1)?(n=n.slice(2),t=parseInt(n,16),i=t.toString(16)):(n=n.slice(1),t=parseInt(n,10),i=t.toString(10))),n=n.replace(/^0+/,""),isNaN(t)||i.toLowerCase()!==n?(E(e,"Invalid character entity"),"&"+e.entity+";"):String.fromCodePoint(t))}function R(e,t){"<"===t?(e.state=j.OPEN_WAKA,e.startTagPosition=e.position):l(t)||(E(e,"Non-whitespace before first tag."),e.textNode=t,e.state=j.TEXT)}function M(e,t){var n="";return t<e.length&&(n=e.charAt(t)),n}function w(e){var t=this;if(this.error)throw this.error;if(t.closed)return g(t,"Cannot write after close. Assign an onready handler.");if(null===e)return A(t);"object"==typeof e&&(e=e.toString());for(var n=0,r="";r=M(e,n++),t.c=r,r;)switch(t.trackPosition&&(t.position++,"\n"===r?(t.line++,t.column=0):t.column++),t.state){case j.BEGIN:if(t.state=j.BEGIN_WHITESPACE,"\ufeff"===r)continue;R(t,r);continue;case j.BEGIN_WHITESPACE:R(t,r);continue;case j.TEXT:if(t.sawRoot&&!t.closedRoot){for(var a=n-1;r&&"<"!==r&&"&"!==r;)r=M(e,n++),r&&t.trackPosition&&(t.position++,"\n"===r?(t.line++,t.column=0):t.column++);t.textNode+=e.substring(a,n-1)}"<"!==r||t.sawRoot&&t.closedRoot&&!t.strict?(l(r)||t.sawRoot&&!t.closedRoot||E(t,"Text data outside of root node."),"&"===r?t.state=j.TEXT_ENTITY:t.textNode+=r):(t.state=j.OPEN_WAKA,t.startTagPosition=t.position);continue;case j.SCRIPT:"<"===r?t.state=j.SCRIPT_ENDING:t.script+=r;continue;case j.SCRIPT_ENDING:"/"===r?t.state=j.CLOSE_TAG:(t.script+="<"+r,t.state=j.SCRIPT);continue;case j.OPEN_WAKA:if("!"===r)t.state=j.SGML_DECL,t.sgmlDecl="";else if(l(r));else if(f(F,r))t.state=j.OPEN_TAG,t.tagName=r;else if("/"===r)t.state=j.CLOSE_TAG,t.tagName="";else if("?"===r)t.state=j.PROC_INST,t.procInstName=t.procInstBody="";else{if(E(t,"Unencoded <"),t.startTagPosition+1<t.position){var o=t.position-t.startTagPosition;r=new Array(o).join(" ")+r}t.textNode+="<"+r,t.state=j.TEXT}continue;case j.SGML_DECL:(t.sgmlDecl+r).toUpperCase()===O?(m(t,"onopencdata"),t.state=j.CDATA,t.sgmlDecl="",t.cdata=""):t.sgmlDecl+r==="--"?(t.state=j.COMMENT,t.comment="",t.sgmlDecl=""):(t.sgmlDecl+r).toUpperCase()===D?(t.state=j.DOCTYPE,(t.doctype||t.sawRoot)&&E(t,"Inappropriately located doctype declaration"),t.doctype="",t.sgmlDecl=""):">"===r?(m(t,"onsgmldeclaration",t.sgmlDecl),t.sgmlDecl="",t.state=j.TEXT):p(r)?(t.state=j.SGML_DECL_QUOTED,t.sgmlDecl+=r):t.sgmlDecl+=r;continue;case j.SGML_DECL_QUOTED:r===t.q&&(t.state=j.SGML_DECL,t.q=""),t.sgmlDecl+=r;continue;case j.DOCTYPE:">"===r?(t.state=j.TEXT,m(t,"ondoctype",t.doctype),t.doctype=!0):(t.doctype+=r,"["===r?t.state=j.DOCTYPE_DTD:p(r)&&(t.state=j.DOCTYPE_QUOTED,t.q=r));continue;case j.DOCTYPE_QUOTED:t.doctype+=r,r===t.q&&(t.q="",t.state=j.DOCTYPE);continue;case j.DOCTYPE_DTD:t.doctype+=r,"]"===r?t.state=j.DOCTYPE:p(r)&&(t.state=j.DOCTYPE_DTD_QUOTED,t.q=r);continue;case j.DOCTYPE_DTD_QUOTED:t.doctype+=r,r===t.q&&(t.state=j.DOCTYPE_DTD,t.q="");continue;case j.COMMENT:"-"===r?t.state=j.COMMENT_ENDING:t.comment+=r;continue;case j.COMMENT_ENDING:"-"===r?(t.state=j.COMMENT_ENDED,t.comment=v(t.opt,t.comment),t.comment&&m(t,"oncomment",t.comment),t.comment=""):(t.comment+="-"+r,t.state=j.COMMENT);continue;case j.COMMENT_ENDED:">"!==r?(E(t,"Malformed comment"),t.comment+="--"+r,t.state=j.COMMENT):t.state=j.TEXT;continue;case j.CDATA:"]"===r?t.state=j.CDATA_ENDING:t.cdata+=r;continue;case j.CDATA_ENDING:"]"===r?t.state=j.CDATA_ENDING_2:(t.cdata+="]"+r,t.state=j.CDATA);continue;case j.CDATA_ENDING_2:">"===r?(t.cdata&&m(t,"oncdata",t.cdata),m(t,"onclosecdata"),t.cdata="",t.state=j.TEXT):"]"===r?t.cdata+="]":(t.cdata+="]]"+r,t.state=j.CDATA);continue;case j.PROC_INST:"?"===r?t.state=j.PROC_INST_ENDING:l(r)?t.state=j.PROC_INST_BODY:t.procInstName+=r;continue;case j.PROC_INST_BODY:if(!t.procInstBody&&l(r))continue;"?"===r?t.state=j.PROC_INST_ENDING:t.procInstBody+=r;continue;case j.PROC_INST_ENDING:">"===r?(m(t,"onprocessinginstruction",{name:t.procInstName,body:t.procInstBody}),t.procInstName=t.procInstBody="",t.state=j.TEXT):(t.procInstBody+="?"+r,t.state=j.PROC_INST_BODY);continue;case j.OPEN_TAG:f(B,r)?t.tagName+=r:(_(t),">"===r?S(t):"/"===r?t.state=j.OPEN_TAG_SLASH:(l(r)||E(t,"Invalid character in tag name"),t.state=j.ATTRIB));continue;case j.OPEN_TAG_SLASH:">"===r?(S(t,!0),b(t)):(E(t,"Forward-slash in opening tag not followed by >"),t.state=j.ATTRIB);continue;case j.ATTRIB:if(l(r))continue;">"===r?S(t):"/"===r?t.state=j.OPEN_TAG_SLASH:f(F,r)?(t.attribName=r,t.attribValue="",t.state=j.ATTRIB_NAME):E(t,"Invalid attribute name");continue;case j.ATTRIB_NAME:"="===r?t.state=j.ATTRIB_VALUE:">"===r?(E(t,"Attribute without value"),t.attribValue=t.attribName,N(t),S(t)):l(r)?t.state=j.ATTRIB_NAME_SAW_WHITE:f(B,r)?t.attribName+=r:E(t,"Invalid attribute name");continue;case j.ATTRIB_NAME_SAW_WHITE:if("="===r)t.state=j.ATTRIB_VALUE;else{if(l(r))continue;E(t,"Attribute without value"),t.tag.attributes[t.attribName]="",t.attribValue="",m(t,"onattribute",{name:t.attribName,value:""}),t.attribName="",">"===r?S(t):f(F,r)?(t.attribName=r,t.state=j.ATTRIB_NAME):(E(t,"Invalid attribute name"),t.state=j.ATTRIB)}continue;case j.ATTRIB_VALUE:if(l(r))continue;p(r)?(t.q=r,t.state=j.ATTRIB_VALUE_QUOTED):(E(t,"Unquoted attribute value"),t.state=j.ATTRIB_VALUE_UNQUOTED,t.attribValue=r);continue;case j.ATTRIB_VALUE_QUOTED:if(r!==t.q){"&"===r?t.state=j.ATTRIB_VALUE_ENTITY_Q:t.attribValue+=r;continue}N(t),t.q="",t.state=j.ATTRIB_VALUE_CLOSED;continue;case j.ATTRIB_VALUE_CLOSED:l(r)?t.state=j.ATTRIB:">"===r?S(t):"/"===r?t.state=j.OPEN_TAG_SLASH:f(F,r)?(E(t,"No whitespace between attributes"),t.attribName=r,t.attribValue="",t.state=j.ATTRIB_NAME):E(t,"Invalid attribute name");continue;case j.ATTRIB_VALUE_UNQUOTED:if(!c(r)){"&"===r?t.state=j.ATTRIB_VALUE_ENTITY_U:t.attribValue+=r;continue}N(t),">"===r?S(t):t.state=j.ATTRIB;continue;case j.CLOSE_TAG:if(t.tagName)">"===r?b(t):f(B,r)?t.tagName+=r:t.script?(t.script+="</"+t.tagName,t.tagName="",t.state=j.SCRIPT):(l(r)||E(t,"Invalid tagname in closing tag"),t.state=j.CLOSE_TAG_SAW_WHITE);else{if(l(r))continue;h(F,r)?t.script?(t.script+="</"+r,t.state=j.SCRIPT):E(t,"Invalid tagname in closing tag."):t.tagName=r}continue;case j.CLOSE_TAG_SAW_WHITE:if(l(r))continue;">"===r?b(t):E(t,"Invalid characters in closing tag");continue;case j.TEXT_ENTITY:case j.ATTRIB_VALUE_ENTITY_Q:case j.ATTRIB_VALUE_ENTITY_U:var s,u;switch(t.state){case j.TEXT_ENTITY:s=j.TEXT,u="textNode";break;case j.ATTRIB_VALUE_ENTITY_Q:s=j.ATTRIB_VALUE_QUOTED,u="attribValue";break;case j.ATTRIB_VALUE_ENTITY_U:s=j.ATTRIB_VALUE_UNQUOTED,u="attribValue"}";"===r?(t[u]+=I(t),t.entity="",t.state=s):f(t.entity.length?K:V,r)?t.entity+=r:(E(t,"Invalid character in entity name"),t[u]+="&"+t.entity+r,t.entity="",t.state=s);continue;default:throw new Error(t,"Unknown state: "+t.state)}return t.position>=t.bufferCheckPosition&&i(t),t}t.parser=function(e,t){return new r(e,t)},t.SAXParser=r,t.SAXStream=u,t.createStream=s,t.MAX_BUFFER_LENGTH=65536;var C=["comment","sgmlDecl","textNode","tagName","doctype","procInstName","procInstBody","entity","attribName","attribValue","cdata","script"];t.EVENTS=["text","processinginstruction","sgmldeclaration","doctype","comment","opentagstart","attribute","opentag","closetag","opencdata","cdata","closecdata","error","end","ready","script","opennamespace","closenamespace"],Object.create||(Object.create=function(e){function t(){}t.prototype=e;var n=new t;return n}),Object.keys||(Object.keys=function(e){var t=[];for(var n in e)e.hasOwnProperty(n)&&t.push(n);return t}),r.prototype={end:function(){A(this)},write:w,resume:function(){return this.error=null,this},close:function(){return this.write(null)},flush:function(){o(this)}};var L;try{L=n(104).Stream}catch(e){L=function(){}}var P=t.EVENTS.filter(function(e){return"error"!==e&&"end"!==e});u.prototype=Object.create(L.prototype,{constructor:{value:u}}),u.prototype.write=function(t){if("function"==typeof e&&"function"==typeof e.isBuffer&&e.isBuffer(t)){if(!this._decoder){var r=n(130).StringDecoder;this._decoder=new r("utf8")}t=this._decoder.write(t)}return this._parser.write(t.toString()),this.emit("data",t),!0},u.prototype.end=function(e){return e&&e.length&&this.write(e),this._parser.end(),!0},u.prototype.on=function(e,t){var n=this;return n._parser["on"+e]||-1===P.indexOf(e)||(n._parser["on"+e]=function(){var t=1===arguments.length?[arguments[0]]:Array.apply(null,arguments);t.splice(0,0,e),n.emit.apply(n,t)}),L.prototype.on.call(n,e,t)};var O="[CDATA[",D="DOCTYPE",U="http://www.w3.org/XML/1998/namespace",x="http://www.w3.org/2000/xmlns/",k={xml:U,xmlns:x},F=/[:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/,B=/[:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\u00B7\u0300-\u036F\u203F-\u2040.\d-]/,V=/[#:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/,K=/[#:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\u00B7\u0300-\u036F\u203F-\u2040.\d-]/,j=0;t.STATE={BEGIN:j++,BEGIN_WHITESPACE:j++,TEXT:j++,TEXT_ENTITY:j++,OPEN_WAKA:j++,SGML_DECL:j++,SGML_DECL_QUOTED:j++,DOCTYPE:j++,DOCTYPE_QUOTED:j++,DOCTYPE_DTD:j++,DOCTYPE_DTD_QUOTED:j++,COMMENT_STARTING:j++,COMMENT:j++,COMMENT_ENDING:j++,COMMENT_ENDED:j++,CDATA:j++,CDATA_ENDING:j++,CDATA_ENDING_2:j++,PROC_INST:j++,PROC_INST_BODY:j++,PROC_INST_ENDING:j++,OPEN_TAG:j++,OPEN_TAG_SLASH:j++,ATTRIB:j++,ATTRIB_NAME:j++,ATTRIB_NAME_SAW_WHITE:j++,ATTRIB_VALUE:j++,ATTRIB_VALUE_QUOTED:j++,ATTRIB_VALUE_CLOSED:j++,ATTRIB_VALUE_UNQUOTED:j++,ATTRIB_VALUE_ENTITY_Q:j++,ATTRIB_VALUE_ENTITY_U:j++,CLOSE_TAG:j++,CLOSE_TAG_SAW_WHITE:j++,SCRIPT:j++,SCRIPT_ENDING:j++},t.XML_ENTITIES={amp:"&",gt:">",lt:"<",quot:'"',apos:"'"},t.ENTITIES={amp:"&",gt:">",lt:"<",quot:'"',apos:"'",AElig:198,Aacute:193,Acirc:194,Agrave:192,Aring:197,Atilde:195,Auml:196,Ccedil:199,ETH:208,Eacute:201,Ecirc:202,Egrave:200,Euml:203,Iacute:205,Icirc:206,Igrave:204,Iuml:207,Ntilde:209,Oacute:211,Ocirc:212,Ograve:210,Oslash:216,Otilde:213,Ouml:214,THORN:222,Uacute:218,Ucirc:219,Ugrave:217,Uuml:220,Yacute:221,aacute:225,acirc:226,aelig:230,agrave:224,aring:229,atilde:227,auml:228,ccedil:231,eacute:233,ecirc:234,egrave:232,eth:240,euml:235,iacute:237,icirc:238,igrave:236,iuml:239,ntilde:241,oacute:243,ocirc:244,ograve:242,oslash:248,otilde:245,ouml:246,szlig:223,thorn:254,uacute:250,ucirc:251,ugrave:249,uuml:252,yacute:253,yuml:255,copy:169,reg:174,nbsp:160,iexcl:161,cent:162,pound:163,curren:164,yen:165,brvbar:166,sect:167,uml:168,ordf:170,laquo:171,not:172,shy:173,macr:175,deg:176,plusmn:177,sup1:185,sup2:178,sup3:179,acute:180,micro:181,para:182,middot:183,cedil:184,ordm:186,raquo:187,frac14:188,frac12:189,frac34:190,iquest:191,times:215,divide:247,OElig:338,oelig:339,Scaron:352,scaron:353,Yuml:376,fnof:402,circ:710,tilde:732,Alpha:913,Beta:914,Gamma:915,Delta:916,Epsilon:917,Zeta:918,Eta:919,Theta:920,Iota:921,Kappa:922,Lambda:923,Mu:924,Nu:925,Xi:926,Omicron:927,Pi:928,Rho:929,Sigma:931,Tau:932,Upsilon:933,Phi:934,Chi:935,Psi:936,Omega:937,alpha:945,beta:946,gamma:947,delta:948,epsilon:949,zeta:950,eta:951,theta:952,iota:953,kappa:954,lambda:955,mu:956,nu:957,xi:958,omicron:959,pi:960,rho:961,sigmaf:962,sigma:963,tau:964,upsilon:965,phi:966,chi:967,psi:968,omega:969,thetasym:977,upsih:978,piv:982,ensp:8194,emsp:8195,thinsp:8201,zwnj:8204,zwj:8205,lrm:8206,rlm:8207,ndash:8211,mdash:8212,lsquo:8216,rsquo:8217,sbquo:8218,ldquo:8220,rdquo:8221,bdquo:8222,dagger:8224,Dagger:8225,bull:8226,hellip:8230,permil:8240,prime:8242,Prime:8243,lsaquo:8249,rsaquo:8250,oline:8254,frasl:8260,euro:8364,image:8465,weierp:8472,real:8476,trade:8482,alefsym:8501,larr:8592,uarr:8593,rarr:8594,darr:8595,harr:8596,crarr:8629,lArr:8656,uArr:8657,rArr:8658,dArr:8659,hArr:8660,forall:8704,part:8706,exist:8707,empty:8709,nabla:8711,isin:8712,notin:8713,ni:8715,prod:8719,sum:8721,minus:8722,lowast:8727,radic:8730,prop:8733,infin:8734,ang:8736,and:8743,or:8744,cap:8745,cup:8746,"int":8747,there4:8756,sim:8764,cong:8773,asymp:8776,ne:8800,equiv:8801,le:8804,ge:8805,sub:8834,sup:8835,nsub:8836,sube:8838,supe:8839,oplus:8853,otimes:8855,perp:8869,sdot:8901,lceil:8968,rceil:8969,lfloor:8970,rfloor:8971,lang:9001,rang:9002,loz:9674,spades:9824,clubs:9827,hearts:9829,diams:9830},Object.keys(t.ENTITIES).forEach(function(e){var n=t.ENTITIES[e],r="number"==typeof n?String.fromCharCode(n):n;t.ENTITIES[e]=r});for(var W in t.STATE)t.STATE[t.STATE[W]]=W;j=t.STATE,String.fromCodePoint||!function(){var e=String.fromCharCode,t=Math.floor,n=function(){var n,r,i=16384,a=[],o=-1,s=arguments.length;if(!s)return"";for(var u="";++o<s;){var l=Number(arguments[o]);if(!isFinite(l)||0>l||l>1114111||t(l)!==l)throw RangeError("Invalid code point: "+l);65535>=l?a.push(l):(l-=65536,n=(l>>10)+55296,r=l%1024+56320,a.push(n,r)),(o+1===s||a.length>i)&&(u+=e.apply(null,a),a.length=0)}return u};Object.defineProperty?Object.defineProperty(String,"fromCodePoint",{value:n,configurable:!0,writable:!0}):String.fromCodePoint=n}()}(t)}).call(t,n(43).Buffer)},function(e,t,n){function r(){i.call(this)}e.exports=r;var i=n(105).EventEmitter,a=n(106);a(r,i),r.Readable=n(107),r.Writable=n(126),r.Duplex=n(127),r.Transform=n(128),r.PassThrough=n(129),r.Stream=r,r.prototype.pipe=function(e,t){function n(t){e.writable&&!1===e.write(t)&&l.pause&&l.pause()}function r(){l.readable&&l.resume&&l.resume()}function a(){p||(p=!0,e.end())}function o(){p||(p=!0,"function"==typeof e.destroy&&e.destroy())}function s(e){if(u(),0===i.listenerCount(this,"error"))throw e}function u(){l.removeListener("data",n),e.removeListener("drain",r),l.removeListener("end",a),l.removeListener("close",o),l.removeListener("error",s),e.removeListener("error",s),l.removeListener("end",u),l.removeListener("close",u),e.removeListener("close",u)}var l=this;l.on("data",n),e.on("drain",r),e._isStdio||t&&t.end===!1||(l.on("end",a),l.on("close",o));var p=!1;return l.on("error",s),e.on("error",s),l.on("end",u),l.on("close",u),e.on("close",u),e.emit("pipe",l),e}},function(e,t){function n(){this._events=this._events||{},this._maxListeners=this._maxListeners||void 0}function r(e){return"function"==typeof e}function i(e){return"number"==typeof e}function a(e){return"object"==typeof e&&null!==e}function o(e){return void 0===e}e.exports=n,n.EventEmitter=n,n.prototype._events=void 0,n.prototype._maxListeners=void 0,n.defaultMaxListeners=10,n.prototype.setMaxListeners=function(e){if(!i(e)||0>e||isNaN(e))throw TypeError("n must be a positive number");return this._maxListeners=e,this},n.prototype.emit=function(e){var t,n,i,s,u,l;if(this._events||(this._events={}),"error"===e&&(!this._events.error||a(this._events.error)&&!this._events.error.length)){if(t=arguments[1],t instanceof Error)throw t;var p=new Error('Uncaught, unspecified "error" event. ('+t+")");throw p.context=t,p}if(n=this._events[e],o(n))return!1;if(r(n))switch(arguments.length){case 1:n.call(this);break;case 2:n.call(this,arguments[1]);break;case 3:n.call(this,arguments[1],arguments[2]);break;default:s=Array.prototype.slice.call(arguments,1),n.apply(this,s)}else if(a(n))for(s=Array.prototype.slice.call(arguments,1),l=n.slice(),i=l.length,u=0;i>u;u++)l[u].apply(this,s);return!0},n.prototype.addListener=function(e,t){var i;if(!r(t))throw TypeError("listener must be a function");return this._events||(this._events={}),this._events.newListener&&this.emit("newListener",e,r(t.listener)?t.listener:t),this._events[e]?a(this._events[e])?this._events[e].push(t):this._events[e]=[this._events[e],t]:this._events[e]=t,a(this._events[e])&&!this._events[e].warned&&(i=o(this._maxListeners)?n.defaultMaxListeners:this._maxListeners,i&&i>0&&this._events[e].length>i&&(this._events[e].warned=!0,console.error("(node) warning: possible EventEmitter memory leak detected. %d listeners added. Use emitter.setMaxListeners() to increase limit.",this._events[e].length),"function"==typeof console.trace&&console.trace())),this},n.prototype.on=n.prototype.addListener,n.prototype.once=function(e,t){function n(){this.removeListener(e,n),i||(i=!0,t.apply(this,arguments))}if(!r(t))throw TypeError("listener must be a function");var i=!1;return n.listener=t,this.on(e,n),this},n.prototype.removeListener=function(e,t){var n,i,o,s;if(!r(t))throw TypeError("listener must be a function");if(!this._events||!this._events[e])return this;if(n=this._events[e],o=n.length,i=-1,n===t||r(n.listener)&&n.listener===t)delete this._events[e],this._events.removeListener&&this.emit("removeListener",e,t);else if(a(n)){for(s=o;s-->0;)if(n[s]===t||n[s].listener&&n[s].listener===t){i=s;break}if(0>i)return this;1===n.length?(n.length=0,delete this._events[e]):n.splice(i,1),this._events.removeListener&&this.emit("removeListener",e,t)}return this},n.prototype.removeAllListeners=function(e){var t,n;if(!this._events)return this;if(!this._events.removeListener)return 0===arguments.length?this._events={}:this._events[e]&&delete this._events[e],this;if(0===arguments.length){for(t in this._events)"removeListener"!==t&&this.removeAllListeners(t);return this.removeAllListeners("removeListener"),this._events={},this}if(n=this._events[e],r(n))this.removeListener(e,n);else if(n)for(;n.length;)this.removeListener(e,n[n.length-1]);return delete this._events[e],this},n.prototype.listeners=function(e){var t;return t=this._events&&this._events[e]?r(this._events[e])?[this._events[e]]:this._events[e].slice():[]},n.prototype.listenerCount=function(e){if(this._events){var t=this._events[e];if(r(t))return 1;if(t)return t.length}return 0},n.listenerCount=function(e,t){return e.listenerCount(t)}},function(e,t){"function"==typeof Object.create?e.exports=function(e,t){e.super_=t,e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}})}:e.exports=function(e,t){e.super_=t;var n=function(){};n.prototype=t.prototype,e.prototype=new n,e.prototype.constructor=e}},function(e,t,n){t=e.exports=n(108),t.Stream=t,t.Readable=t,t.Writable=n(119),t.Duplex=n(118),t.Transform=n(124),t.PassThrough=n(125)},function(e,t,n){(function(t,r){"use strict";function i(e){return k.from(e)}function a(e){return k.isBuffer(e)||e instanceof F}function o(e,t,n){return"function"==typeof e.prependListener?e.prependListener(t,n):void(e._events&&e._events[t]?D(e._events[t])?e._events[t].unshift(n):e._events[t]=[n,e._events[t]]:e.on(t,n))}function s(e,t){O=O||n(118),e=e||{},this.objectMode=!!e.objectMode,t instanceof O&&(this.objectMode=this.objectMode||!!e.readableObjectMode);var r=e.highWaterMark,i=this.objectMode?16:16384;this.highWaterMark=r||0===r?r:i,this.highWaterMark=Math.floor(this.highWaterMark),this.buffer=new W,this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.resumeScheduled=!1,this.destroyed=!1,this.defaultEncoding=e.defaultEncoding||"utf8",this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,e.encoding&&(j||(j=n(123).StringDecoder),this.decoder=new j(e.encoding),this.encoding=e.encoding)}function u(e){return O=O||n(118),this instanceof u?(this._readableState=new s(e,this),this.readable=!0,e&&("function"==typeof e.read&&(this._read=e.read),"function"==typeof e.destroy&&(this._destroy=e.destroy)),void x.call(this)):new u(e)}function l(e,t,n,r,a){var o=e._readableState;if(null===t)o.reading=!1,m(e,o);else{var s;a||(s=c(o,t)),s?e.emit("error",s):o.objectMode||t&&t.length>0?("string"==typeof t||o.objectMode||Object.getPrototypeOf(t)===k.prototype||(t=i(t)),r?o.endEmitted?e.emit("error",new Error("stream.unshift() after end event")):p(e,o,t,!0):o.ended?e.emit("error",new Error("stream.push() after EOF")):(o.reading=!1,o.decoder&&!n?(t=o.decoder.write(t),o.objectMode||0!==t.length?p(e,o,t,!1):g(e,o)):p(e,o,t,!1))):r||(o.reading=!1)}return f(o)}function p(e,t,n,r){t.flowing&&0===t.length&&!t.sync?(e.emit("data",n),e.read(0)):(t.length+=t.objectMode?1:n.length,r?t.buffer.unshift(n):t.buffer.push(n),t.needReadable&&y(e)),g(e,t)}function c(e,t){var n;return a(t)||"string"==typeof t||void 0===t||e.objectMode||(n=new TypeError("Invalid non-string/buffer chunk")),n}function f(e){return!e.ended&&(e.needReadable||e.length<e.highWaterMark||0===e.length)}function h(e){return e>=q?e=q:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}function d(e,t){return 0>=e||0===t.length&&t.ended?0:t.objectMode?1:e!==e?t.flowing&&t.length?t.buffer.head.data.length:t.length:(e>t.highWaterMark&&(t.highWaterMark=h(e)),e<=t.length?e:t.ended?t.length:(t.needReadable=!0,0))}function m(e,t){if(!t.ended){if(t.decoder){var n=t.decoder.end();n&&n.length&&(t.buffer.push(n),t.length+=t.objectMode?1:n.length)}t.ended=!0,y(e)}}function y(e){var t=e._readableState;t.needReadable=!1,t.emittedReadable||(K("emitReadable",t.flowing),t.emittedReadable=!0,t.sync?P(v,e):v(e))}function v(e){K("emit readable"),e.emit("readable"),S(e)}function g(e,t){t.readingMore||(t.readingMore=!0,P(A,e,t))}function A(e,t){for(var n=t.length;!t.reading&&!t.flowing&&!t.ended&&t.length<t.highWaterMark&&(K("maybeReadMore read 0"),e.read(0),n!==t.length);)n=t.length;t.readingMore=!1}function E(e){return function(){var t=e._readableState;K("pipeOnDrain",t.awaitDrain),t.awaitDrain&&t.awaitDrain--,0===t.awaitDrain&&U(e,"data")&&(t.flowing=!0,S(e))}}function _(e){K("readable nexttick read 0"),e.read(0)}function T(e,t){t.resumeScheduled||(t.resumeScheduled=!0,P(N,e,t))}function N(e,t){t.reading||(K("resume read 0"),e.read(0)),t.resumeScheduled=!1,t.awaitDrain=0,e.emit("resume"),S(e),t.flowing&&!t.reading&&e.read(0)}function S(e){var t=e._readableState;for(K("flow",t.flowing);t.flowing&&null!==e.read(););}function b(e,t){if(0===t.length)return null;var n;return t.objectMode?n=t.buffer.shift():!e||e>=t.length?(n=t.decoder?t.buffer.join(""):1===t.buffer.length?t.buffer.head.data:t.buffer.concat(t.length),t.buffer.clear()):n=I(e,t.buffer,t.decoder),n}function I(e,t,n){var r;return e<t.head.data.length?(r=t.head.data.slice(0,e),t.head.data=t.head.data.slice(e)):r=e===t.head.data.length?t.shift():n?R(e,t):M(e,t),r}function R(e,t){var n=t.head,r=1,i=n.data;for(e-=i.length;n=n.next;){var a=n.data,o=e>a.length?a.length:e;if(i+=o===a.length?a:a.slice(0,e),e-=o,0===e){o===a.length?(++r,n.next?t.head=n.next:t.head=t.tail=null):(t.head=n,n.data=a.slice(o));break}++r}return t.length-=r,i}function M(e,t){var n=k.allocUnsafe(e),r=t.head,i=1;for(r.data.copy(n),e-=r.data.length;r=r.next;){var a=r.data,o=e>a.length?a.length:e;if(a.copy(n,n.length-e,0,o),e-=o,0===e){o===a.length?(++i,r.next?t.head=r.next:t.head=t.tail=null):(t.head=r,r.data=a.slice(o));break}++i}return t.length-=i,n}function w(e){var t=e._readableState;if(t.length>0)throw new Error('"endReadable()" called on non-empty stream');t.endEmitted||(t.ended=!0,P(C,t,e))}function C(e,t){e.endEmitted||0!==e.length||(e.endEmitted=!0,t.readable=!1,t.emit("end"))}function L(e,t){for(var n=0,r=e.length;r>n;n++)if(e[n]===t)return n;return-1}var P=n(109);e.exports=u;var O,D=n(110);u.ReadableState=s;var U=(n(105).EventEmitter,function(e,t){return e.listeners(t).length}),x=n(111),k=n(112).Buffer,F=t.Uint8Array||function(){},B=n(113);B.inherits=n(114);var V=n(115),K=void 0;K=V&&V.debuglog?V.debuglog("stream"):function(){};var j,W=n(116),H=n(117);B.inherits(u,x);var Y=["error","close","destroy","pause","resume"];Object.defineProperty(u.prototype,"destroyed",{get:function(){return void 0!==this._readableState&&this._readableState.destroyed},set:function(e){this._readableState&&(this._readableState.destroyed=e)}}),u.prototype.destroy=H.destroy,u.prototype._undestroy=H.undestroy,u.prototype._destroy=function(e,t){this.push(null),t(e)},u.prototype.push=function(e,t){var n,r=this._readableState;return r.objectMode?n=!0:"string"==typeof e&&(t=t||r.defaultEncoding,t!==r.encoding&&(e=k.from(e,t),t=""),n=!0),l(this,e,t,!1,n)},u.prototype.unshift=function(e){return l(this,e,null,!0,!1)},u.prototype.isPaused=function(){return this._readableState.flowing===!1},u.prototype.setEncoding=function(e){return j||(j=n(123).StringDecoder),this._readableState.decoder=new j(e),this._readableState.encoding=e,this};var q=8388608;u.prototype.read=function(e){K("read",e),e=parseInt(e,10);var t=this._readableState,n=e;if(0!==e&&(t.emittedReadable=!1),0===e&&t.needReadable&&(t.length>=t.highWaterMark||t.ended))return K("read: emitReadable",t.length,t.ended),0===t.length&&t.ended?w(this):y(this),null;if(e=d(e,t),0===e&&t.ended)return 0===t.length&&w(this),null;var r=t.needReadable;K("need readable",r),(0===t.length||t.length-e<t.highWaterMark)&&(r=!0,K("length less than watermark",r)),t.ended||t.reading?(r=!1,K("reading or ended",r)):r&&(K("do read"),t.reading=!0,t.sync=!0,0===t.length&&(t.needReadable=!0),this._read(t.highWaterMark),t.sync=!1,t.reading||(e=d(n,t)));var i;return i=e>0?b(e,t):null,null===i?(t.needReadable=!0,e=0):t.length-=e,0===t.length&&(t.ended||(t.needReadable=!0),n!==e&&t.ended&&w(this)),null!==i&&this.emit("data",i),i},u.prototype._read=function(e){this.emit("error",new Error("_read() is not implemented"))},u.prototype.pipe=function(e,t){function n(e,t){K("onunpipe"),e===f&&t&&t.hasUnpiped===!1&&(t.hasUnpiped=!0,a())}function i(){K("onend"),e.end()}function a(){K("cleanup"),e.removeListener("close",l),e.removeListener("finish",p),e.removeListener("drain",y),e.removeListener("error",u),
e.removeListener("unpipe",n),f.removeListener("end",i),f.removeListener("end",c),f.removeListener("data",s),v=!0,!h.awaitDrain||e._writableState&&!e._writableState.needDrain||y()}function s(t){K("ondata"),g=!1;var n=e.write(t);!1!==n||g||((1===h.pipesCount&&h.pipes===e||h.pipesCount>1&&-1!==L(h.pipes,e))&&!v&&(K("false write response, pause",f._readableState.awaitDrain),f._readableState.awaitDrain++,g=!0),f.pause())}function u(t){K("onerror",t),c(),e.removeListener("error",u),0===U(e,"error")&&e.emit("error",t)}function l(){e.removeListener("finish",p),c()}function p(){K("onfinish"),e.removeListener("close",l),c()}function c(){K("unpipe"),f.unpipe(e)}var f=this,h=this._readableState;switch(h.pipesCount){case 0:h.pipes=e;break;case 1:h.pipes=[h.pipes,e];break;default:h.pipes.push(e)}h.pipesCount+=1,K("pipe count=%d opts=%j",h.pipesCount,t);var d=(!t||t.end!==!1)&&e!==r.stdout&&e!==r.stderr,m=d?i:c;h.endEmitted?P(m):f.once("end",m),e.on("unpipe",n);var y=E(f);e.on("drain",y);var v=!1,g=!1;return f.on("data",s),o(e,"error",u),e.once("close",l),e.once("finish",p),e.emit("pipe",f),h.flowing||(K("pipe resume"),f.resume()),e},u.prototype.unpipe=function(e){var t=this._readableState,n={hasUnpiped:!1};if(0===t.pipesCount)return this;if(1===t.pipesCount)return e&&e!==t.pipes?this:(e||(e=t.pipes),t.pipes=null,t.pipesCount=0,t.flowing=!1,e&&e.emit("unpipe",this,n),this);if(!e){var r=t.pipes,i=t.pipesCount;t.pipes=null,t.pipesCount=0,t.flowing=!1;for(var a=0;i>a;a++)r[a].emit("unpipe",this,n);return this}var o=L(t.pipes,e);return-1===o?this:(t.pipes.splice(o,1),t.pipesCount-=1,1===t.pipesCount&&(t.pipes=t.pipes[0]),e.emit("unpipe",this,n),this)},u.prototype.on=function(e,t){var n=x.prototype.on.call(this,e,t);if("data"===e)this._readableState.flowing!==!1&&this.resume();else if("readable"===e){var r=this._readableState;r.endEmitted||r.readableListening||(r.readableListening=r.needReadable=!0,r.emittedReadable=!1,r.reading?r.length&&y(this):P(_,this))}return n},u.prototype.addListener=u.prototype.on,u.prototype.resume=function(){var e=this._readableState;return e.flowing||(K("resume"),e.flowing=!0,T(this,e)),this},u.prototype.pause=function(){return K("call pause flowing=%j",this._readableState.flowing),!1!==this._readableState.flowing&&(K("pause"),this._readableState.flowing=!1,this.emit("pause")),this},u.prototype.wrap=function(e){var t=this._readableState,n=!1,r=this;e.on("end",function(){if(K("wrapped end"),t.decoder&&!t.ended){var e=t.decoder.end();e&&e.length&&r.push(e)}r.push(null)}),e.on("data",function(i){if(K("wrapped data"),t.decoder&&(i=t.decoder.write(i)),(!t.objectMode||null!==i&&void 0!==i)&&(t.objectMode||i&&i.length)){var a=r.push(i);a||(n=!0,e.pause())}});for(var i in e)void 0===this[i]&&"function"==typeof e[i]&&(this[i]=function(t){return function(){return e[t].apply(e,arguments)}}(i));for(var a=0;a<Y.length;a++)e.on(Y[a],r.emit.bind(r,Y[a]));return r._read=function(t){K("wrapped _read",t),n&&(n=!1,e.resume())},r},u._fromList=b}).call(t,function(){return this}(),n(7))},function(e,t,n){(function(t){"use strict";function n(e,n,r,i){if("function"!=typeof e)throw new TypeError('"callback" argument must be a function');var a,o,s=arguments.length;switch(s){case 0:case 1:return t.nextTick(e);case 2:return t.nextTick(function(){e.call(null,n)});case 3:return t.nextTick(function(){e.call(null,n,r)});case 4:return t.nextTick(function(){e.call(null,n,r,i)});default:for(a=new Array(s-1),o=0;o<a.length;)a[o++]=arguments[o];return t.nextTick(function(){e.apply(null,a)})}}!t.version||0===t.version.indexOf("v0.")||0===t.version.indexOf("v1.")&&0!==t.version.indexOf("v1.8.")?e.exports=n:e.exports=t.nextTick}).call(t,n(7))},function(e,t){var n={}.toString;e.exports=Array.isArray||function(e){return"[object Array]"==n.call(e)}},function(e,t,n){e.exports=n(105).EventEmitter},function(e,t,n){function r(e,t){for(var n in e)t[n]=e[n]}function i(e,t,n){return o(e,t,n)}var a=n(43),o=a.Buffer;o.from&&o.alloc&&o.allocUnsafe&&o.allocUnsafeSlow?e.exports=a:(r(a,t),t.Buffer=i),r(o,i),i.from=function(e,t,n){if("number"==typeof e)throw new TypeError("Argument must not be a number");return o(e,t,n)},i.alloc=function(e,t,n){if("number"!=typeof e)throw new TypeError("Argument must be a number");var r=o(e);return void 0!==t?"string"==typeof n?r.fill(t,n):r.fill(t):r.fill(0),r},i.allocUnsafe=function(e){if("number"!=typeof e)throw new TypeError("Argument must be a number");return o(e)},i.allocUnsafeSlow=function(e){if("number"!=typeof e)throw new TypeError("Argument must be a number");return a.SlowBuffer(e)}},function(e,t,n){(function(e){function n(e){return Array.isArray?Array.isArray(e):"[object Array]"===y(e)}function r(e){return"boolean"==typeof e}function i(e){return null===e}function a(e){return null==e}function o(e){return"number"==typeof e}function s(e){return"string"==typeof e}function u(e){return"symbol"==typeof e}function l(e){return void 0===e}function p(e){return"[object RegExp]"===y(e)}function c(e){return"object"==typeof e&&null!==e}function f(e){return"[object Date]"===y(e)}function h(e){return"[object Error]"===y(e)||e instanceof Error}function d(e){return"function"==typeof e}function m(e){return null===e||"boolean"==typeof e||"number"==typeof e||"string"==typeof e||"symbol"==typeof e||"undefined"==typeof e}function y(e){return Object.prototype.toString.call(e)}t.isArray=n,t.isBoolean=r,t.isNull=i,t.isNullOrUndefined=a,t.isNumber=o,t.isString=s,t.isSymbol=u,t.isUndefined=l,t.isRegExp=p,t.isObject=c,t.isDate=f,t.isError=h,t.isFunction=d,t.isPrimitive=m,t.isBuffer=e.isBuffer}).call(t,n(43).Buffer)},function(e,t){"function"==typeof Object.create?e.exports=function(e,t){e.super_=t,e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}})}:e.exports=function(e,t){e.super_=t;var n=function(){};n.prototype=t.prototype,e.prototype=new n,e.prototype.constructor=e}},function(e,t){},function(e,t,n){"use strict";function r(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function i(e,t,n){e.copy(t,n)}var a=n(112).Buffer;e.exports=function(){function e(){r(this,e),this.head=null,this.tail=null,this.length=0}return e.prototype.push=function(e){var t={data:e,next:null};this.length>0?this.tail.next=t:this.head=t,this.tail=t,++this.length},e.prototype.unshift=function(e){var t={data:e,next:this.head};0===this.length&&(this.tail=t),this.head=t,++this.length},e.prototype.shift=function(){if(0!==this.length){var e=this.head.data;return 1===this.length?this.head=this.tail=null:this.head=this.head.next,--this.length,e}},e.prototype.clear=function(){this.head=this.tail=null,this.length=0},e.prototype.join=function(e){if(0===this.length)return"";for(var t=this.head,n=""+t.data;t=t.next;)n+=e+t.data;return n},e.prototype.concat=function(e){if(0===this.length)return a.alloc(0);if(1===this.length)return this.head.data;for(var t=a.allocUnsafe(e>>>0),n=this.head,r=0;n;)i(n.data,t,r),r+=n.data.length,n=n.next;return t},e}()},function(e,t,n){"use strict";function r(e,t){var n=this,r=this._readableState&&this._readableState.destroyed,i=this._writableState&&this._writableState.destroyed;return r||i?void(t?t(e):!e||this._writableState&&this._writableState.errorEmitted||o(a,this,e)):(this._readableState&&(this._readableState.destroyed=!0),this._writableState&&(this._writableState.destroyed=!0),void this._destroy(e||null,function(e){!t&&e?(o(a,n,e),n._writableState&&(n._writableState.errorEmitted=!0)):t&&t(e)}))}function i(){this._readableState&&(this._readableState.destroyed=!1,this._readableState.reading=!1,this._readableState.ended=!1,this._readableState.endEmitted=!1),this._writableState&&(this._writableState.destroyed=!1,this._writableState.ended=!1,this._writableState.ending=!1,this._writableState.finished=!1,this._writableState.errorEmitted=!1)}function a(e,t){e.emit("error",t)}var o=n(109);e.exports={destroy:r,undestroy:i}},function(e,t,n){"use strict";function r(e){return this instanceof r?(l.call(this,e),p.call(this,e),e&&e.readable===!1&&(this.readable=!1),e&&e.writable===!1&&(this.writable=!1),this.allowHalfOpen=!0,e&&e.allowHalfOpen===!1&&(this.allowHalfOpen=!1),void this.once("end",i)):new r(e)}function i(){this.allowHalfOpen||this._writableState.ended||o(a,this)}function a(e){e.end()}var o=n(109),s=Object.keys||function(e){var t=[];for(var n in e)t.push(n);return t};e.exports=r;var u=n(113);u.inherits=n(114);var l=n(108),p=n(119);u.inherits(r,l);for(var c=s(p.prototype),f=0;f<c.length;f++){var h=c[f];r.prototype[h]||(r.prototype[h]=p.prototype[h])}Object.defineProperty(r.prototype,"destroyed",{get:function(){return void 0!==this._readableState&&void 0!==this._writableState&&this._readableState.destroyed&&this._writableState.destroyed},set:function(e){void 0!==this._readableState&&void 0!==this._writableState&&(this._readableState.destroyed=e,this._writableState.destroyed=e)}}),r.prototype._destroy=function(e,t){this.push(null),this.end(),o(t,e)}},function(e,t,n){(function(t,r,i){"use strict";function a(e){var t=this;this.next=null,this.entry=null,this.finish=function(){R(t,e)}}function o(e){return D.from(e)}function s(e){return D.isBuffer(e)||e instanceof U}function u(){}function l(e,t){w=w||n(118),e=e||{},this.objectMode=!!e.objectMode,t instanceof w&&(this.objectMode=this.objectMode||!!e.writableObjectMode);var r=e.highWaterMark,i=this.objectMode?16:16384;this.highWaterMark=r||0===r?r:i,this.highWaterMark=Math.floor(this.highWaterMark),this.finalCalled=!1,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1,this.destroyed=!1;var o=e.decodeStrings===!1;this.decodeStrings=!o,this.defaultEncoding=e.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(e){g(t,e)},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.bufferedRequestCount=0,this.corkedRequestsFree=new a(this)}function p(e){return w=w||n(118),k.call(p,this)||this instanceof w?(this._writableState=new l(e,this),this.writable=!0,e&&("function"==typeof e.write&&(this._write=e.write),"function"==typeof e.writev&&(this._writev=e.writev),"function"==typeof e.destroy&&(this._destroy=e.destroy),"function"==typeof e["final"]&&(this._final=e["final"])),void O.call(this)):new p(e)}function c(e,t){var n=new Error("write after end");e.emit("error",n),M(t,n)}function f(e,t,n,r){var i=!0,a=!1;return null===n?a=new TypeError("May not write null values to stream"):"string"==typeof n||void 0===n||t.objectMode||(a=new TypeError("Invalid non-string/buffer chunk")),a&&(e.emit("error",a),M(r,a),i=!1),i}function h(e,t,n){return e.objectMode||e.decodeStrings===!1||"string"!=typeof t||(t=D.from(t,n)),t}function d(e,t,n,r,i,a){if(!n){var o=h(t,r,i);r!==o&&(n=!0,i="buffer",r=o)}var s=t.objectMode?1:r.length;t.length+=s;var u=t.length<t.highWaterMark;if(u||(t.needDrain=!0),t.writing||t.corked){var l=t.lastBufferedRequest;t.lastBufferedRequest={chunk:r,encoding:i,isBuf:n,callback:a,next:null},l?l.next=t.lastBufferedRequest:t.bufferedRequest=t.lastBufferedRequest,t.bufferedRequestCount+=1}else m(e,t,!1,s,r,i,a);return u}function m(e,t,n,r,i,a,o){t.writelen=r,t.writecb=o,t.writing=!0,t.sync=!0,n?e._writev(i,t.onwrite):e._write(i,a,t.onwrite),t.sync=!1}function y(e,t,n,r,i){--t.pendingcb,n?(M(i,r),M(b,e,t),e._writableState.errorEmitted=!0,e.emit("error",r)):(i(r),e._writableState.errorEmitted=!0,e.emit("error",r),b(e,t))}function v(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}function g(e,t){var n=e._writableState,r=n.sync,i=n.writecb;if(v(n),t)y(e,n,r,t,i);else{var a=T(n);a||n.corked||n.bufferProcessing||!n.bufferedRequest||_(e,n),r?C(A,e,n,a,i):A(e,n,a,i)}}function A(e,t,n,r){n||E(e,t),t.pendingcb--,r(),b(e,t)}function E(e,t){0===t.length&&t.needDrain&&(t.needDrain=!1,e.emit("drain"))}function _(e,t){t.bufferProcessing=!0;var n=t.bufferedRequest;if(e._writev&&n&&n.next){var r=t.bufferedRequestCount,i=new Array(r),o=t.corkedRequestsFree;o.entry=n;for(var s=0,u=!0;n;)i[s]=n,n.isBuf||(u=!1),n=n.next,s+=1;i.allBuffers=u,m(e,t,!0,t.length,i,"",o.finish),t.pendingcb++,t.lastBufferedRequest=null,o.next?(t.corkedRequestsFree=o.next,o.next=null):t.corkedRequestsFree=new a(t)}else{for(;n;){var l=n.chunk,p=n.encoding,c=n.callback,f=t.objectMode?1:l.length;if(m(e,t,!1,f,l,p,c),n=n.next,t.writing)break}null===n&&(t.lastBufferedRequest=null)}t.bufferedRequestCount=0,t.bufferedRequest=n,t.bufferProcessing=!1}function T(e){return e.ending&&0===e.length&&null===e.bufferedRequest&&!e.finished&&!e.writing}function N(e,t){e._final(function(n){t.pendingcb--,n&&e.emit("error",n),t.prefinished=!0,e.emit("prefinish"),b(e,t)})}function S(e,t){t.prefinished||t.finalCalled||("function"==typeof e._final?(t.pendingcb++,t.finalCalled=!0,M(N,e,t)):(t.prefinished=!0,e.emit("prefinish")))}function b(e,t){var n=T(t);return n&&(S(e,t),0===t.pendingcb&&(t.finished=!0,e.emit("finish"))),n}function I(e,t,n){t.ending=!0,b(e,t),n&&(t.finished?M(n):e.once("finish",n)),t.ended=!0,e.writable=!1}function R(e,t,n){var r=e.entry;for(e.entry=null;r;){var i=r.callback;t.pendingcb--,i(n),r=r.next}t.corkedRequestsFree?t.corkedRequestsFree.next=e:t.corkedRequestsFree=e}var M=n(109);e.exports=p;var w,C=!t.browser&&["v0.10","v0.9."].indexOf(t.version.slice(0,5))>-1?r:M;p.WritableState=l;var L=n(113);L.inherits=n(114);var P={deprecate:n(122)},O=n(111),D=n(112).Buffer,U=i.Uint8Array||function(){},x=n(117);L.inherits(p,O),l.prototype.getBuffer=function(){for(var e=this.bufferedRequest,t=[];e;)t.push(e),e=e.next;return t},function(){try{Object.defineProperty(l.prototype,"buffer",{get:P.deprecate(function(){return this.getBuffer()},"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.","DEP0003")})}catch(e){}}();var k;"function"==typeof Symbol&&Symbol.hasInstance&&"function"==typeof Function.prototype[Symbol.hasInstance]?(k=Function.prototype[Symbol.hasInstance],Object.defineProperty(p,Symbol.hasInstance,{value:function(e){return!!k.call(this,e)||e&&e._writableState instanceof l}})):k=function(e){return e instanceof this},p.prototype.pipe=function(){this.emit("error",new Error("Cannot pipe, not readable"))},p.prototype.write=function(e,t,n){var r=this._writableState,i=!1,a=s(e)&&!r.objectMode;return a&&!D.isBuffer(e)&&(e=o(e)),"function"==typeof t&&(n=t,t=null),a?t="buffer":t||(t=r.defaultEncoding),"function"!=typeof n&&(n=u),r.ended?c(this,n):(a||f(this,r,e,n))&&(r.pendingcb++,i=d(this,r,a,e,t,n)),i},p.prototype.cork=function(){var e=this._writableState;e.corked++},p.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,e.writing||e.corked||e.finished||e.bufferProcessing||!e.bufferedRequest||_(this,e))},p.prototype.setDefaultEncoding=function(e){if("string"==typeof e&&(e=e.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((e+"").toLowerCase())>-1))throw new TypeError("Unknown encoding: "+e);return this._writableState.defaultEncoding=e,this},p.prototype._write=function(e,t,n){n(new Error("_write() is not implemented"))},p.prototype._writev=null,p.prototype.end=function(e,t,n){var r=this._writableState;"function"==typeof e?(n=e,e=null,t=null):"function"==typeof t&&(n=t,t=null),null!==e&&void 0!==e&&this.write(e,t),r.corked&&(r.corked=1,this.uncork()),r.ending||r.finished||I(this,r,n)},Object.defineProperty(p.prototype,"destroyed",{get:function(){return void 0!==this._writableState&&this._writableState.destroyed},set:function(e){this._writableState&&(this._writableState.destroyed=e)}}),p.prototype.destroy=x.destroy,p.prototype._undestroy=x.undestroy,p.prototype._destroy=function(e,t){this.end(),t(e)}}).call(t,n(7),n(120).setImmediate,function(){return this}())},function(e,t,n){function r(e,t){this._id=e,this._clearFn=t}var i=Function.prototype.apply;t.setTimeout=function(){return new r(i.call(setTimeout,window,arguments),clearTimeout)},t.setInterval=function(){return new r(i.call(setInterval,window,arguments),clearInterval)},t.clearTimeout=t.clearInterval=function(e){e&&e.close()},r.prototype.unref=r.prototype.ref=function(){},r.prototype.close=function(){this._clearFn.call(window,this._id)},t.enroll=function(e,t){clearTimeout(e._idleTimeoutId),e._idleTimeout=t},t.unenroll=function(e){clearTimeout(e._idleTimeoutId),e._idleTimeout=-1},t._unrefActive=t.active=function(e){clearTimeout(e._idleTimeoutId);var t=e._idleTimeout;t>=0&&(e._idleTimeoutId=setTimeout(function(){e._onTimeout&&e._onTimeout()},t))},n(121),t.setImmediate=setImmediate,t.clearImmediate=clearImmediate},function(e,t,n){(function(e,t){!function(e,n){"use strict";function r(e){"function"!=typeof e&&(e=new Function(""+e));for(var t=new Array(arguments.length-1),n=0;n<t.length;n++)t[n]=arguments[n+1];var r={callback:e,args:t};return m[d]=r,h(d),d++}function i(e){delete m[e]}function a(e){var t=e.callback,r=e.args;switch(r.length){case 0:t();break;case 1:t(r[0]);break;case 2:t(r[0],r[1]);break;case 3:t(r[0],r[1],r[2]);break;default:t.apply(n,r)}}function o(e){if(y)setTimeout(o,0,e);else{var t=m[e];if(t){y=!0;try{a(t)}finally{i(e),y=!1}}}}function s(){h=function(e){t.nextTick(function(){o(e)})}}function u(){if(e.postMessage&&!e.importScripts){var t=!0,n=e.onmessage;return e.onmessage=function(){t=!1},e.postMessage("","*"),e.onmessage=n,t}}function l(){var t="setImmediate$"+Math.random()+"$",n=function(n){n.source===e&&"string"==typeof n.data&&0===n.data.indexOf(t)&&o(+n.data.slice(t.length))};e.addEventListener?e.addEventListener("message",n,!1):e.attachEvent("onmessage",n),h=function(n){e.postMessage(t+n,"*")}}function p(){var e=new MessageChannel;e.port1.onmessage=function(e){var t=e.data;o(t)},h=function(t){e.port2.postMessage(t)}}function c(){var e=v.documentElement;h=function(t){var n=v.createElement("script");n.onreadystatechange=function(){o(t),n.onreadystatechange=null,e.removeChild(n),n=null},e.appendChild(n)}}function f(){h=function(e){setTimeout(o,0,e)}}if(!e.setImmediate){var h,d=1,m={},y=!1,v=e.document,g=Object.getPrototypeOf&&Object.getPrototypeOf(e);g=g&&g.setTimeout?g:e,"[object process]"==={}.toString.call(e.process)?s():u()?l():e.MessageChannel?p():v&&"onreadystatechange"in v.createElement("script")?c():f(),g.setImmediate=r,g.clearImmediate=i}}("undefined"==typeof self?"undefined"==typeof e?this:e:self)}).call(t,function(){return this}(),n(7))},function(e,t){(function(t){function n(e,t){function n(){if(!i){if(r("throwDeprecation"))throw new Error(t);r("traceDeprecation")?console.trace(t):console.warn(t),i=!0}return e.apply(this,arguments)}if(r("noDeprecation"))return e;var i=!1;return n}function r(e){try{if(!t.localStorage)return!1}catch(e){return!1}var n=t.localStorage[e];return null!=n&&"true"===String(n).toLowerCase()}e.exports=n}).call(t,function(){return this}())},function(e,t,n){"use strict";function r(e){if(!e)return"utf8";for(var t;;)switch(e){case"utf8":case"utf-8":return"utf8";case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return"utf16le";case"latin1":case"binary":return"latin1";case"base64":case"ascii":case"hex":return e;default:if(t)return;e=(""+e).toLowerCase(),t=!0}}function i(e){var t=r(e);if("string"!=typeof t&&(g.isEncoding===A||!A(e)))throw new Error("Unknown encoding: "+e);return t||e}function a(e){this.encoding=i(e);var t;switch(this.encoding){case"utf16le":this.text=f,this.end=h,t=4;break;case"utf8":this.fillLast=l,t=4;break;case"base64":this.text=d,this.end=m,t=3;break;default:return this.write=y,void(this.end=v)}this.lastNeed=0,this.lastTotal=0,this.lastChar=g.allocUnsafe(t)}function o(e){return 127>=e?0:e>>5===6?2:e>>4===14?3:e>>3===30?4:-1}function s(e,t,n){var r=t.length-1;if(n>r)return 0;var i=o(t[r]);return i>=0?(i>0&&(e.lastNeed=i-1),i):--r<n?0:(i=o(t[r]),i>=0?(i>0&&(e.lastNeed=i-2),i):--r<n?0:(i=o(t[r]),i>=0?(i>0&&(2===i?i=0:e.lastNeed=i-3),i):0))}function u(e,t,n){if(128!==(192&t[0]))return e.lastNeed=0,"�".repeat(n);if(e.lastNeed>1&&t.length>1){if(128!==(192&t[1]))return e.lastNeed=1,"�".repeat(n+1);if(e.lastNeed>2&&t.length>2&&128!==(192&t[2]))return e.lastNeed=2,"�".repeat(n+2)}}function l(e){var t=this.lastTotal-this.lastNeed,n=u(this,e,t);return void 0!==n?n:this.lastNeed<=e.length?(e.copy(this.lastChar,t,0,this.lastNeed),this.lastChar.toString(this.encoding,0,this.lastTotal)):(e.copy(this.lastChar,t,0,e.length),void(this.lastNeed-=e.length))}function p(e,t){var n=s(this,e,t);if(!this.lastNeed)return e.toString("utf8",t);this.lastTotal=n;var r=e.length-(n-this.lastNeed);return e.copy(this.lastChar,0,r),e.toString("utf8",t,r)}function c(e){var t=e&&e.length?this.write(e):"";return this.lastNeed?t+"�".repeat(this.lastTotal-this.lastNeed):t}function f(e,t){if((e.length-t)%2===0){var n=e.toString("utf16le",t);if(n){var r=n.charCodeAt(n.length-1);if(r>=55296&&56319>=r)return this.lastNeed=2,this.lastTotal=4,this.lastChar[0]=e[e.length-2],this.lastChar[1]=e[e.length-1],n.slice(0,-1)}return n}return this.lastNeed=1,this.lastTotal=2,this.lastChar[0]=e[e.length-1],e.toString("utf16le",t,e.length-1)}function h(e){var t=e&&e.length?this.write(e):"";if(this.lastNeed){var n=this.lastTotal-this.lastNeed;return t+this.lastChar.toString("utf16le",0,n)}return t}function d(e,t){var n=(e.length-t)%3;return 0===n?e.toString("base64",t):(this.lastNeed=3-n,this.lastTotal=3,1===n?this.lastChar[0]=e[e.length-1]:(this.lastChar[0]=e[e.length-2],this.lastChar[1]=e[e.length-1]),e.toString("base64",t,e.length-n))}function m(e){var t=e&&e.length?this.write(e):"";return this.lastNeed?t+this.lastChar.toString("base64",0,3-this.lastNeed):t}function y(e){return e.toString(this.encoding)}function v(e){return e&&e.length?this.write(e):""}var g=n(112).Buffer,A=g.isEncoding||function(e){switch(e=""+e,e&&e.toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":case"raw":return!0;default:return!1}};t.StringDecoder=a,a.prototype.write=function(e){if(0===e.length)return"";var t,n;if(this.lastNeed){if(t=this.fillLast(e),void 0===t)return"";n=this.lastNeed,this.lastNeed=0}else n=0;return n<e.length?t?t+this.text(e,n):this.text(e,n):t||""},a.prototype.end=c,a.prototype.text=p,a.prototype.fillLast=function(e){return this.lastNeed<=e.length?(e.copy(this.lastChar,this.lastTotal-this.lastNeed,0,this.lastNeed),this.lastChar.toString(this.encoding,0,this.lastTotal)):(e.copy(this.lastChar,this.lastTotal-this.lastNeed,0,e.length),void(this.lastNeed-=e.length))}},function(e,t,n){"use strict";function r(e){this.afterTransform=function(t,n){return i(e,t,n)},this.needTransform=!1,this.transforming=!1,this.writecb=null,this.writechunk=null,this.writeencoding=null}function i(e,t,n){var r=e._transformState;r.transforming=!1;var i=r.writecb;if(!i)return e.emit("error",new Error("write callback called multiple times"));r.writechunk=null,r.writecb=null,null!==n&&void 0!==n&&e.push(n),i(t);var a=e._readableState;a.reading=!1,(a.needReadable||a.length<a.highWaterMark)&&e._read(a.highWaterMark)}function a(e){if(!(this instanceof a))return new a(e);s.call(this,e),this._transformState=new r(this);var t=this;this._readableState.needReadable=!0,this._readableState.sync=!1,e&&("function"==typeof e.transform&&(this._transform=e.transform),"function"==typeof e.flush&&(this._flush=e.flush)),this.once("prefinish",function(){"function"==typeof this._flush?this._flush(function(e,n){o(t,e,n)}):o(t)})}function o(e,t,n){if(t)return e.emit("error",t);null!==n&&void 0!==n&&e.push(n);var r=e._writableState,i=e._transformState;if(r.length)throw new Error("Calling transform done when ws.length != 0");if(i.transforming)throw new Error("Calling transform done when still transforming");return e.push(null)}e.exports=a;var s=n(118),u=n(113);u.inherits=n(114),u.inherits(a,s),a.prototype.push=function(e,t){return this._transformState.needTransform=!1,s.prototype.push.call(this,e,t)},a.prototype._transform=function(e,t,n){throw new Error("_transform() is not implemented")},a.prototype._write=function(e,t,n){var r=this._transformState;if(r.writecb=n,r.writechunk=e,r.writeencoding=t,!r.transforming){var i=this._readableState;(r.needTransform||i.needReadable||i.length<i.highWaterMark)&&this._read(i.highWaterMark)}},a.prototype._read=function(e){var t=this._transformState;null!==t.writechunk&&t.writecb&&!t.transforming?(t.transforming=!0,this._transform(t.writechunk,t.writeencoding,t.afterTransform)):t.needTransform=!0},a.prototype._destroy=function(e,t){var n=this;s.prototype._destroy.call(this,e,function(e){t(e),n.emit("close")})}},function(e,t,n){"use strict";function r(e){return this instanceof r?void i.call(this,e):new r(e)}e.exports=r;var i=n(124),a=n(113);a.inherits=n(114),a.inherits(r,i),r.prototype._transform=function(e,t,n){n(null,e)}},function(e,t,n){e.exports=n(119)},function(e,t,n){e.exports=n(118)},function(e,t,n){e.exports=n(107).Transform},function(e,t,n){e.exports=n(107).PassThrough},function(e,t,n){function r(e){if(e&&!u(e))throw new Error("Unknown encoding: "+e)}function i(e){return e.toString(this.encoding)}function a(e){this.charReceived=e.length%2,this.charLength=this.charReceived?2:0}function o(e){this.charReceived=e.length%3,this.charLength=this.charReceived?3:0}var s=n(43).Buffer,u=s.isEncoding||function(e){switch(e&&e.toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":case"raw":return!0;default:return!1}},l=t.StringDecoder=function(e){switch(this.encoding=(e||"utf8").toLowerCase().replace(/[-_]/,""),r(e),this.encoding){case"utf8":this.surrogateSize=3;break;case"ucs2":case"utf16le":this.surrogateSize=2,this.detectIncompleteChar=a;break;case"base64":this.surrogateSize=3,this.detectIncompleteChar=o;break;default:return void(this.write=i)}this.charBuffer=new s(6),this.charReceived=0,this.charLength=0};l.prototype.write=function(e){for(var t="";this.charLength;){var n=e.length>=this.charLength-this.charReceived?this.charLength-this.charReceived:e.length;if(e.copy(this.charBuffer,this.charReceived,0,n),this.charReceived+=n,this.charReceived<this.charLength)return"";e=e.slice(n,e.length),t=this.charBuffer.slice(0,this.charLength).toString(this.encoding);var r=t.charCodeAt(t.length-1);if(!(r>=55296&&56319>=r)){if(this.charReceived=this.charLength=0,0===e.length)return t;break}this.charLength+=this.surrogateSize,t=""}this.detectIncompleteChar(e);var i=e.length;this.charLength&&(e.copy(this.charBuffer,0,e.length-this.charReceived,i),i-=this.charReceived),t+=e.toString(this.encoding,0,i);var i=t.length-1,r=t.charCodeAt(i);if(r>=55296&&56319>=r){var a=this.surrogateSize;return this.charLength+=a,this.charReceived+=a,this.charBuffer.copy(this.charBuffer,a,0,a),e.copy(this.charBuffer,0,0,a),t.substring(0,i)}return t},l.prototype.detectIncompleteChar=function(e){for(var t=e.length>=3?3:e.length;t>0;t--){var n=e[e.length-t];if(1==t&&n>>5==6){this.charLength=2;break}if(2>=t&&n>>4==14){this.charLength=3;break}if(3>=t&&n>>3==30){this.charLength=4;break}}this.charReceived=t},l.prototype.end=function(e){var t="";if(e&&e.length&&(t=this.write(e)),this.charReceived){var n=this.charReceived,r=this.charBuffer,i=this.encoding;t+=r.slice(0,n).toString(i)}return t}},function(e,t){(function(){"use strict";t.stripBOM=function(e){return"\ufeff"===e[0]?e.substring(1):e}}).call(this)},function(e,t){(function(){"use strict";var e;e=new RegExp(/(?!xmlns)^.*:/),t.normalize=function(e){return e.toLowerCase()},t.firstCharLowerCase=function(e){return e.charAt(0).toLowerCase()+e.slice(1)},t.stripPrefix=function(t){return t.replace(e,"")},t.parseNumbers=function(e){return isNaN(e)||(e=e%1===0?parseInt(e,10):parseFloat(e)),e},t.parseBooleans=function(e){return/^(?:true|false)$/i.test(e)&&(e="true"===e.toLowerCase()),e}}).call(this)},function(e,t,n){"use strict";function r(){return d?d:d=new h}Object.defineProperty(t,"__esModule",{value:!0});var i=n(58),a=n(75),o=n(58),s=n(73),u=n(75),l=n(75),p=n(75),c=n(73),f=function(){function e(e,t){this._construct=e,this._constructWithValue=t}return e.prototype.isSimple=function(){return null!=this._constructWithValue},e.prototype.newInstance=function(){return this._construct()},e.prototype.createWithValue=function(e){return this._constructWithValue(e)},e.prototype.isApplicable=function(e){var t=this.newInstance(),n=t.requiredType(),r=t.requiredTypes();return r&&r.length>0?r.some(function(t){return e.isSubTypeOf(t)}):e.isSubTypeOf(n)},e.prototype.isInheritable=function(){return this.newInstance().isInheritable()},e.prototype.isConstraint=function(){return this.newInstance()instanceof i.Constraint},e.prototype.isMeta=function(){return!this.isConstraint()},e.prototype.name=function(){return this.newInstance().facetName()},e}();t.FacetPrototype=f;var h=function(){function e(){var e=this;this.constraints=[new f(function(){return new s.MinProperties(1)},function(e){return new s.MinProperties(e)}),new f(function(){return new s.MaxProperties(1)},function(e){return new s.MaxProperties(e)}),new f(function(){return new s.MinItems(1)},function(e){return new s.MinItems(e)}),new f(function(){return new s.MaxItems(1)},function(e){return new s.MaxItems(e)}),new f(function(){return new s.MinLength(1)},function(e){return new s.MinLength(e)}),new f(function(){return new s.MaxLength(1)},function(e){return new s.MaxLength(e)}),new f(function(){return new s.Minimum(1)},function(e){return new s.Minimum(e)}),new f(function(){return new c.MultipleOf(1)},function(e){return new c.MultipleOf(e)}),new f(function(){return new s.Maximum(1)},function(e){return new s.Maximum(e)}),new f(function(){return new s.Enum([""])},function(e){return new s.Enum(e)}),new f(function(){return new s.Pattern(".")},function(e){return new s.Pattern(e)}),new f(function(){return new s.Format("")},function(e){return new s.Format(e)}),new f(function(){return new s.PropertyIs("x",i.ANY)},null),new f(function(){return new s.AdditionalPropertyIs(i.ANY)},null),new f(function(){return new s.MapPropertyIs(".",i.ANY)},null),new f(function(){return new s.HasProperty("x")},null),new f(function(){return new s.UniqueItems(!0)},function(e){return new s.UniqueItems(e)}),new f(function(){return new s.ComponentShouldBeOfType(i.ANY)},null),new f(function(){return new s.KnownPropertyRestriction(!1)},function(e){return new s.KnownPropertyRestriction(e)}),new f(function(){return new s.FileTypes([""])},function(e){return new s.FileTypes(e)})],this.meta=[new f(function(){return new a.Discriminator("kind")},function(e){return new a.Discriminator(e)}),new f(function(){return new a.DiscriminatorValue("x")},function(e){return new a.DiscriminatorValue(e)}),new f(function(){return new u.Default("")},function(e){return new u.Default(e)}),new f(function(){return new u.Example("")},function(e){return new u.Example(e)}),new f(function(){return new p.Required(!0)},function(e){return new p.Required(e)}),new f(function(){return new a.Examples({})},function(e){return new a.Examples(e)}),new f(function(){return new u.Description("")},function(e){return new u.Description(e)}),new f(function(){return new u.DisplayName("")},function(e){return new u.DisplayName(e)}),new f(function(){return new o.Abstract},function(e){return new o.Abstract}),new f(function(){return new o.Polymorphic},function(e){return new o.Polymorphic}),new f(function(){return new l.XMLInfo({})},function(e){return new l.XMLInfo(e)})],this.known={},this.allPrototypes().forEach(function(t){return e.known[t.name()]=t})}return e.prototype.allPrototypes=function(){return this.meta.concat(this.constraints)},e.prototype.buildFacet=function(e,t){return this.known.hasOwnProperty(e)&&this.known[e].isSimple()?this.known[e].createWithValue(t):null},e.prototype.facetPrototypeWithName=function(e){return this.known.hasOwnProperty(e)?this.known[e]:null},e.prototype.applyableTo=function(e){return this.allPrototypes().filter(function(t){return t.isApplicable(e)})},e.prototype.allMeta=function(){return this.allPrototypes().filter(function(e){return e.isMeta()})},e}();t.Registry=h;var d;t.getInstance=r;
},function(e,t,n){"use strict";function r(e){var t=e.oneMeta(p.Example);if(t)return t.example();if(e.getExtra(h))return null;e.putExtra(h,!0);try{var n=e.oneMeta(p.Examples);if(n){var i=n.examples();if(i&&i.length>0)return i[0]}var a=e.oneMeta(p.Default);if(a)return a.value();if(e.isObject()){var o={};return e.meta().forEach(function(e){if(e instanceof f.PropertyIs){var t=e,n=r(t.value());o[t.propertyName()]=n}}),e.superTypes().forEach(function(e){if(e.oneMeta(p.Example)||e.oneMeta(p.Examples)){var t=r(e);t&&"object"==typeof t&&Object.keys(t).forEach(function(e){o[e]=t[e]})}}),o}if(e.isArray()){var s=e.oneMeta(c.ComponentShouldBeOfType),u=[];return s&&u.push(r(s.value())),u}return e.isUnion()?r(e.typeFamily()[0]):e.isNumber()?1:!!e.isBoolean()||"some value"}finally{e.putExtra(h,!1)}}function i(e,t){var n=e[t];return null!=n&&"object"==typeof n?n.value:n}function a(e){var t=[];if(!e||"object"!=typeof e)return t;for(var n=0,r=Object.keys(e).filter(function(e){return e.length>0&&"("==e.charAt(0)&&")"==e.charAt(e.length-1)});n<r.length;n++){var i=r[n],a=i.substring(1,i.length-1),o=e[i],s=new p.Annotation(a,o,i);t.push(s)}return t}function o(e){var t=[],n=e.oneMeta(p.Examples);if(n){var r=n.value();if(r&&"object"==typeof r){var i;Object.keys(r).forEach(function(a){var o=Array.isArray(r)?null:a,s=r[a],u=y({asXMLString:function(){return i||(i=n.asXMLStrings()),i[a]},ownerType:function(){return e}},s,o);t.push(u)})}}var a=e.oneMeta(p.Example);if(a){var o=a.example();null!=o&&t.push(y(a,a.value(),void 0,!0))}return t}function s(e){for(var t=o(e),n=[],r=0,i=t;r<i.length;r++){var a=i[r],s=a,u=new m(s.rawValue(),s.name(),s.displayName(),s.description(),s.strict(),s.annotations(),s.isSingle(),s.isEmpty());u._scalarsAnnotations=s.scalarsAnnotations(),n.push(u)}return n}function u(e,t){var n=e.getAdapter(l.InheritedType);if(n){var r=o(n);if(r&&r.length>0)return r;if(t&&e.isUserDefined()&&!e.isGenuineUserDefinedType()&&e.genuineUserDefinedTypeInHierarchy()){var i=e.genuineUserDefinedTypeInHierarchy(),a=i.getAdapter(l.InheritedType);if(a){var s=o(a);if(s&&s.length>0)return s}}}if(n){var u=new d(null,void 0,void 0,void 0,!1,void 0,void 0,!0);return u.setOwnerType(n),[u]}return[]}Object.defineProperty(t,"__esModule",{value:!0});var l=n(58),p=n(75),c=n(73),f=n(73),h="exampleCalculation";t.example=r;var d=function(){function e(e,t,n,r,i,a,o,s){void 0===t&&(t=void 0),void 0===n&&(n=void 0),void 0===r&&(r=void 0),void 0===i&&(i=!0),void 0===o&&(o=!1),void 0===s&&(s=!1),this._value=e,this._name=t,this._displayName=n,this._description=r,this._strict=i,this._annotations=a,this._isSingle=o,this._empty=s,this.isExpanded=!1,this._scalarsAnnotations={},this._annotations?this._hasAnnotations=!0:this._annotations={}}return e.prototype.rawValue=function(){return this._value},e.prototype.isEmpty=function(){return this._empty},e.prototype.isJSONString=function(){if(void 0!==this._isJSONString)return this._isJSONString;this._isJSONString=!1;var e=this.firstCharacter();if("{"==e||"["==e)try{JSON.parse(this._value),this._isJSONString=!0}catch(e){}return this._isJSONString},e.prototype.isXMLString=function(){var e=this.firstCharacter();return"<"==e},e.prototype.firstCharacter=function(){if(null==this._value)return null;if("string"!=typeof this._value)return null;var e=this._value.trim();return 0==e.length?null:e.charAt(0)},e.prototype.asXMLString=function(){return this.isXMLString()?this._value:this._owner?this._owner.asXMLString():null},e.prototype.isYAML=function(){return"string"!=typeof this._value||!(this.isJSONString()||this.isXMLString())},e.prototype.asString=function(){return"string"==typeof this._value?""+this._value:JSON.stringify(this._value,null,2)},e.prototype.asJSON=function(){if(this.isJSONString())try{return JSON.parse(this._value)}catch(e){return null}return this.isYAML()?this._value:this.asString()},e.prototype.original=function(){return this._value},e.prototype.expandAsString=function(){return JSON.stringify(this.expandAsJSON(),null,2)},e.prototype.expandAsJSON=function(){return this.isEmpty()?this.isExpanded?this._expandedValue:(this._expandedValue=r(this._ownerType),this.isExpanded=!0,this._expandedValue):this._value},e.prototype.isSingle=function(){return this._isSingle},e.prototype.strict=function(){return this._strict},e.prototype.description=function(){return this._description},e.prototype.displayName=function(){return this._displayName},e.prototype.annotations=function(){return this._annotations},e.prototype.name=function(){return this._name},e.prototype.scalarsAnnotations=function(){return this._scalarsAnnotations},e.prototype.registerScalarAnnotatoion=function(e,t){this._hasScalarAnnotations=!0;var n=this._scalarsAnnotations[t];n||(n={},this._scalarsAnnotations[t]=n),n[e.facetName()]=e},e.prototype.setOwner=function(e){this._owner=e},e.prototype.owner=function(){return this._owner},e.prototype.setOwnerType=function(e){this._ownerType=e},e.prototype.ownerType=function(){return this._ownerType},e.prototype.hasAnnotations=function(){return this._hasAnnotations},e.prototype.hasScalarAnnotations=function(){return this._hasScalarAnnotations},e}(),m=function(){function e(e,t,n,r,i,a,o,s){void 0===t&&(t=void 0),void 0===n&&(n=void 0),void 0===r&&(r=void 0),void 0===i&&(i=!0),void 0===o&&(o=!1),void 0===s&&(s=!1),this._value=e,this._name=t,this._displayName=n,this._description=r,this._strict=i,this._annotations=a,this._isSingle=o,this._empty=s,this.isExpanded=!1,this._scalarsAnnotations={},this._annotations?this._hasAnnotations=!0:this._annotations={}}return e.prototype.annotationsMap=function(){var e={},t=this.scalarsAnnotations();return Object.keys(t).forEach(function(n){var r=[];Object.keys(t[n]).forEach(function(e){r.push(t[n][e])}),e[n]=r}),e},e.prototype.isEmpty=function(){return this._empty},e.prototype.isJSONString=function(){var e=this.firstCharacter();return"{"==e||"["==e},e.prototype.isXMLString=function(){var e=this.firstCharacter();return"<"==e},e.prototype.firstCharacter=function(){if(null==this._value)return null;if("string"!=typeof this._value)return null;var e=this._value.trim();return 0==e.length?null:e.charAt(0)},e.prototype.asXMLString=function(){return this.isXMLString()?this._value:this._owner?this._owner.asXMLString():null},e.prototype.isYAML=function(){return"string"!=typeof this._value||!(this.isJSONString()||this.isXMLString())},e.prototype.asString=function(){return"string"==typeof this._value?""+this._value:JSON.stringify(this._value,null,2)},e.prototype.asJSON=function(){if(this.isJSONString())try{return JSON.parse(this._value)}catch(e){return null}return this.isYAML()?this._value:this.asString()},e.prototype.original=function(){return this._value},e.prototype.expandAsString=function(){return JSON.stringify(this.expandAsJSON(),null,2)},e.prototype.expandAsJSON=function(){return this.isEmpty()?this.isExpanded?this._expandedValue:(this._expandedValue=r(this._ownerType),this.isExpanded=!0,this._expandedValue):this._value},e.prototype.value=function(){return this.expandAsJSON()},e.prototype.isSingle=function(){return this._isSingle},e.prototype.strict=function(){return this._strict},e.prototype.description=function(){return this._description},e.prototype.displayName=function(){return this._displayName},e.prototype.annotations=function(){var e=this,t=[];return Object.keys(this._annotations).forEach(function(n){t.push(e._annotations[n])}),t},e.prototype.name=function(){return this._name},e.prototype.scalarsAnnotations=function(){return this._scalarsAnnotations},e.prototype.registerScalarAnnotatoion=function(e,t){this._hasScalarAnnotations=!0;var n=this._scalarsAnnotations[t];n||(n={},this._scalarsAnnotations[t]=n),n[e.facetName()]=e},e.prototype.setOwner=function(e){this._owner=e},e.prototype.owner=function(){return this._owner},e.prototype.setOwnerType=function(e){this._ownerType=e},e.prototype.ownerType=function(){return this._ownerType},e.prototype.hasAnnotations=function(){return this._hasAnnotations},e.prototype.hasScalarAnnotations=function(){return this._hasScalarAnnotations},e}(),y=function(e,t,n,r){void 0===n&&(n=null),void 0===r&&(r=!1);var o;if(null!=t){var s=t.value;if(s){var u=i(t,"displayName"),l=i(t,"description"),p=i(t,"strict"),c={};a(t).forEach(function(e){c[e.facetName()]=e}),o=new d(s,n,u,l,p,c,r);for(var f=0,h=a(t.displayName);f<h.length;f++){var m=h[f];o.registerScalarAnnotatoion(m,"displayName")}for(var y=0,v=a(t.description);y<v.length;y++){var m=v[y];o.registerScalarAnnotatoion(m,"description")}for(var g=0,A=a(t.strict);g<A.length;g++){var m=A[g];o.registerScalarAnnotatoion(m,"strict")}}else s=t,o=new d(s,n,void 0,void 0,!0,void 0,r)}else o=new d(null,n,null,null,!0,{},r);return o&&o.setOwner(e),o};t.exampleFromInheritedType2=s,t.exampleFromNominal=u},function(e,t,n){"use strict";function r(e){return a(e,"YYYY-MM-DD")}function i(e){var t="11 "+e.trim(),n="YY HH:mm:ss";if(!s.isValid(t,n))return!1;var r=s.parse(t,n,!1),i=s.format(r,n,!1);return i.trim()==t.trim()}function a(e,t){var n=/^(\d{4})-\d{2}-\d{2}$/,r=e.match(n);if(!r||2!=r.length)return!1;var i=parseInt(r[1]);return!((70>i||i>99)&&!s.isValid(e,t))}var o=this&&this.__extends||function(){var e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();Object.defineProperty(t,"__esModule",{value:!0});var s=n(136),u=n(58),l=u.messageRegistry,p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o(t,e),t.prototype.check=function(e){return"string"==typeof e&&r(e)?u.ok():u.error(l.INVALID_DATEONLY,this)},t.prototype.requiredType=function(){return u.STRING},t.prototype.value=function(){return!0},t.prototype.facetName=function(){return"should be date-only"},t}(u.GenericTypeOf);t.DateOnlyR=p;var c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o(t,e),t.prototype.check=function(e){if("string"==typeof e){var t=/^([0-9][0-9]:[0-9][0-9]:[0-9][0-9])(.[0-9]+)?$/,n=e.match(t);if(!n)return u.error(l.INVALID_TIMEONLY,this);var r=n[1];return i(r)?u.ok():u.error(l.INVALID_TIMEONLY,this)}return u.error(l.INVALID_TIMEONLY,this)},t.prototype.requiredType=function(){return u.STRING},t.prototype.value=function(){return!0},t.prototype.facetName=function(){return"should be time-only"},t}(u.GenericTypeOf);t.TimeOnlyR=c;var f=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o(t,e),t.prototype.check=function(e){if("string"==typeof e){var t=/^(\d{4}-\d{2}-\d{2})T([0-9][0-9]:[0-9][0-9]:[0-9][0-9])(.[0-9]+)?$/,n=e.match(t);if(!n||n.length<3)return u.error(l.INVALID_DATETIMEONLY,this);var a=n[1],o=n[2];return r(a)&&i(o)?u.ok():u.error(l.INVALID_DATETIMEONLY,this)}return u.error(l.INVALID_DATETIMEONLY,this)},t.prototype.requiredType=function(){return u.STRING},t.prototype.value=function(){return!0},t.prototype.facetName=function(){return"should be datetime-only"},t}(u.GenericTypeOf);t.DateTimeOnlyR=f;var h=/(Mon|Tue|Wed|Thu|Fri|Sat|Sun)\,[ ]+\d{2}[ ]+(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)[ ]+\d{4}[ ]+\d{2}:\d{2}:\d{2}[ ]+GMT/,d=/(Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday)\,[ ]+\d{2}-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-\d{2}[ ]+\d{2}:\d{2}:\d{2}[ ]+GMT/,m=/(Mon|Tue|Wed|Thu|Fri|Sat|Sun)\,[ ]+(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)[ ]+\d{1,2}[ ]+\d{2}:\d{2}:\d{2}[ ]+GMT/,y=/^(\d{4}-\d{2}-\d{2})T(\d{2}:\d{2}:\d{2})(?:\.\d+)?((?:[\+\-]\d{2}:\d{2})|Z)$/,v=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o(t,e),t.prototype.check=function(e){var t=u.VALIDATED_TYPE,n=!1;if(t.allFacets().forEach(function(e){"format"==e.facetName()&&"rfc2616"===e.value()&&(n=!0)}),"string"==typeof e){if(!n){var a=e.match(y);if(!a||a.length<3)return u.error(l.INVALID_RFC3339,this);var o=a[1],s=a[2];return r(o)&&i(s)?u.ok():u.error(l.INVALID_RFC3339,this)}return e.match(h)||e.match(d)||e.match(m)?u.ok():u.error(l.INVALID_RFC2616,this)}return u.error(l.INVALID_DATTIME,this)},t.prototype.requiredType=function(){return u.STRING},t.prototype.value=function(){return!0},t.prototype.facetName=function(){return"should be datetime-only"},t}(u.GenericTypeOf);t.DateTimeR=v},function(e,t,n){var r,i;!function(a){"use strict";var o={},s="en",u={en:{MMMM:["January","February","March","April","May","June","July","August","September","October","November","December"],MMM:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],dddd:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],ddd:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],dd:["Su","Mo","Tu","We","Th","Fr","Sa"],A:["a.m.","p.m."],formatter:{YYYY:function(e){return("000"+e.getFullYear()).slice(-4)},YY:function(e){return("0"+e.getFullYear()).slice(-2)},Y:function(e){return""+e.getFullYear()},MMMM:function(e){return this.MMMM[e.getMonth()]},MMM:function(e){return this.MMM[e.getMonth()]},MM:function(e){return("0"+(e.getMonth()+1)).slice(-2)},M:function(e){return""+(e.getMonth()+1)},DD:function(e){return("0"+e.getDate()).slice(-2)},D:function(e){return""+e.getDate()},HH:function(e){return("0"+e.getHours()).slice(-2)},H:function(e){return""+e.getHours()},A:function(e){return this.A[e.getHours()>11|0]},hh:function(e){return("0"+(e.getHours()%12||12)).slice(-2)},h:function(e){return""+(e.getHours()%12||12)},mm:function(e){return("0"+e.getMinutes()).slice(-2)},m:function(e){return""+e.getMinutes()},ss:function(e){return("0"+e.getSeconds()).slice(-2)},s:function(e){return""+e.getSeconds()},SSS:function(e){return("00"+e.getMilliseconds()).slice(-3)},SS:function(e){return("0"+(e.getMilliseconds()/10|0)).slice(-2)},S:function(e){return""+(e.getMilliseconds()/100|0)},dddd:function(e){return this.dddd[e.getDay()]},ddd:function(e){return this.ddd[e.getDay()]},dd:function(e){return this.dd[e.getDay()]},Z:function(e){var t=e.utc?0:e.getTimezoneOffset()/.6;return(t>0?"-":"+")+("000"+Math.abs(t-t%100*.4)).slice(-4)},post:function(e){return e}},parser:{find:function(e,t){for(var n,r=-1,i=0,a=0,o=e.length;o>a;a++)n=e[a],!t.indexOf(n)&&n.length>i&&(r=a,i=n.length);return{index:r,length:i}},MMMM:function(e){return this.parser.find(this.MMMM,e)},MMM:function(e){return this.parser.find(this.MMM,e)},A:function(e){return this.parser.find(this.A,e)},h:function(e,t){return(12===e?0:e)+12*t},pre:function(e){return e}}}};o.format=function(e,t,n){var r=o.addMinutes(e,n?e.getTimezoneOffset():0),i=u[s],a=i.formatter;return r.utc=n,t.replace(/(\[[^\[\]]*]|\[.*\][^\[]*\]|YYYY|YY|MMM?M?|DD|HH|hh|mm|ss|SSS?|ddd?d?|.)/g,function(e){var n=a[e];return n?a.post(n.call(i,r,t)):e.replace(/\[(.*)]/,"$1")})},o.parse=function(e,t,n){for(var r,i,a,l,p,c,f,h,d=u[s],m=d.parser.pre(e),y=0,v=/(MMMM?|A)|(YYYY)|(SSS)|(MM|DD|HH|hh|mm|ss)|(YY|M|D|H|h|m|s|SS)|(S)|(.)/g,g={2:/^\d{1,4}/,3:/^\d{1,3}/,4:/^\d\d/,5:/^\d\d?/,6:/^\d/},A={Y:1970,M:1,D:1,H:0,m:0,s:0,S:0};r=v.exec(t);){for(i=0,l=1,a="";!a;)a=r[++i];if(p=a.charAt(0),c=m.slice(y),2>i?(f=d.parser[a].call(d,c,t),A[p]=f.index,"M"===p&&A[p]++,l=f.length):7>i&&(f=(c.match(g[i])||[""])[0],A[p]=0|("S"===p?(f+"000").slice(0,-a.length):f),l=f.length),!l)return NaN;y+=l}return y===m.length&&f?(A.Y+=A.Y<70?2e3:A.Y<100?1900:0,A.H=A.H||d.parser.h(A.h||0,A.A||0),h=new Date(A.Y,A.M-1,A.D,A.H,A.m,A.s,A.S),A.Y!==h.getFullYear()||A.M-1!==h.getMonth()||A.D!==h.getDate()||A.H!==h.getHours()||A.m!==h.getMinutes()||A.s!==h.getSeconds()||A.S!==h.getMilliseconds()?NaN:n?o.addMinutes(h,-h.getTimezoneOffset()):h):NaN},o.isValid=function(e,t){return!!o.parse(e,t)},o.addYears=function(e,t){return o.addMonths(e,12*t)},o.addMonths=function(e,t){var n=new Date(e.getTime());return n.setMonth(n.getMonth()+t),n},o.addDays=function(e,t){var n=new Date(e.getTime());return n.setDate(n.getDate()+t),n},o.addHours=function(e,t){return o.addMilliseconds(e,36e5*t)},o.addMinutes=function(e,t){return o.addMilliseconds(e,6e4*t)},o.addSeconds=function(e,t){return o.addMilliseconds(e,1e3*t)},o.addMilliseconds=function(e,t){return new Date(e.getTime()+t)},o.subtract=function(e,t){var n=e.getTime()-t.getTime();return{toMilliseconds:function(){return n},toSeconds:function(){return n/1e3|0},toMinutes:function(){return n/6e4|0},toHours:function(){return n/36e5|0},toDays:function(){return n/864e5|0}}},o.isLeapYear=function(e){var t=e.getFullYear();return!((t%4||!(t%100))&&t%400)},o.isSameDay=function(e,t){return o.format(e,"YYYYMMDD")===o.format(t,"YYYYMMDD")},o.locale=function(e){return e&&("en"!==e&&a&&n(137)("./"+e),s=e),s},o.getLocales=function(e){return u[e||s]},o.setLocales=function(e,t){var n=function(e,t){var n,r,i=function(){};i.prototype=t,n=new i;for(r in e)e.hasOwnProperty(r)&&(n[r]=e[r]);return n},r=u[e]||u.en,i=n(t,r);t.formatter&&(i.formatter=n(t.formatter,r.formatter)),t.parser&&(i.parser=n(t.parser,r.parser)),u[e]=i},"object"==typeof e&&"object"==typeof e.exports?e.exports=o:(r=[],i=function(){return o}.apply(t,r),!(void 0!==i&&(e.exports=i)))}(this)},function(e,t,n){function r(e){return n(i(e))}function i(e){return a[e]||function(){throw new Error("Cannot find module '"+e+"'.")}()}var a={"./ar":138,"./ar.js":138,"./az":139,"./az.js":139,"./bn":140,"./bn.js":140,"./cs":141,"./cs.js":141,"./de":142,"./de.js":142,"./el":143,"./el.js":143,"./es":144,"./es.js":144,"./fa":145,"./fa.js":145,"./fr":146,"./fr.js":146,"./hi":147,"./hi.js":147,"./hu":148,"./hu.js":148,"./id":149,"./id.js":149,"./it":150,"./it.js":150,"./ja":151,"./ja.js":151,"./jv":152,"./jv.js":152,"./ko":153,"./ko.js":153,"./my":154,"./my.js":154,"./nl":155,"./nl.js":155,"./pa-in":156,"./pa-in.js":156,"./pl":157,"./pl.js":157,"./pt":158,"./pt.js":158,"./ro":159,"./ro.js":159,"./ru":160,"./ru.js":160,"./sr":161,"./sr.js":161,"./th":162,"./th.js":162,"./tr":163,"./tr.js":163,"./uk":164,"./uk.js":164,"./uz":165,"./uz.js":165,"./vi":166,"./vi.js":166,"./zh-cn":167,"./zh-cn.js":167,"./zh-tw":168,"./zh-tw.js":168};r.keys=function(){return Object.keys(a)},r.resolve=i,e.exports=r,r.id=137},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){var t=["٠","١","٢","٣","٤","٥","٦","٧","٨","٩"],n={"٠":0,"١":1,"٢":2,"٣":3,"٤":4,"٥":5,"٦":6,"٧":7,"٨":8,"٩":9};e.setLocales("ar",{MMMM:["كانون الثاني يناير","شباط فبراير","آذار مارس","نيسان أبريل","أيار مايو","حزيران يونيو","تموز يوليو","آب أغسطس","أيلول سبتمبر","تشرين الأول أكتوبر","تشرين الثاني نوفمبر","كانون الأول ديسمبر"],MMM:["كانون الثاني يناير","شباط فبراير","آذار مارس","نيسان أبريل","أيار مايو","حزيران يونيو","تموز يوليو","آب أغسطس","أيلول سبتمبر","تشرين الأول أكتوبر","تشرين الثاني نوفمبر","كانون الأول ديسمبر"],dddd:["الأحد","الإثنين","الثلاثاء","الأربعاء","الخميس","الجمعة","السبت"],ddd:["أحد","إثنين","ثلاثاء","أربعاء","خميس","جمعة","سبت"],dd:["ح","ن","ث","ر","خ","ج","س"],A:["ص","م"],formatter:{post:function(e){return e.replace(/\d/g,function(e){return t[0|e]})}},parser:{pre:function(e){return e.replace(/[٠١٢٣٤٥٦٧٨٩]/g,function(e){return""+n[e]})}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("az",{MMMM:["yanvar","fevral","mart","aprel","may","iyun","iyul","avqust","sentyabr","oktyabr","noyabr","dekabr"],MMM:["yan","fev","mar","apr","may","iyn","iyl","avq","sen","okt","noy","dek"],dddd:["Bazar","Bazar ertəsi","Çərşənbə axşamı","Çərşənbə","Cümə axşamı","Cümə","Şənbə"],ddd:["Baz","BzE","ÇAx","Çər","CAx","Cüm","Şən"],dd:["Bz","BE","ÇA","Çə","CA","Cü","Şə"],A:["gecə","səhər","gündüz","axşam"],formatter:{A:function(e){var t=e.getHours();return 4>t?this.A[0]:12>t?this.A[1]:17>t?this.A[2]:this.A[3]}},parser:{h:function(e,t){return 2>t?e:e>11?e:e+12}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("bn",{MMMM:["জানুয়ারী","ফেবুয়ারী","মার্চ","এপ্রিল","মে","জুন","জুলাই","অগাস্ট","সেপ্টেম্বর","অক্টোবর","নভেম্বর","ডিসেম্বর"],MMM:["জানু","ফেব","মার্চ","এপর","মে","জুন","জুল","অগ","সেপ্ট","অক্টো","নভ","ডিসেম্"],dddd:["রবিবার","সোমবার","মঙ্গলবার","বুধবার","বৃহস্পত্তিবার","শুক্রবার","শনিবার"],ddd:["রবি","সোম","মঙ্গল","বুধ","বৃহস্পত্তি","শুক্র","শনি"],dd:["রব","সম","মঙ্গ","বু","ব্রিহ","শু","শনি"],A:["রাত","সকাল","দুপুর","বিকাল"],formatter:{A:function(e){var t=e.getHours();return 4>t?this.A[0]:10>t?this.A[1]:17>t?this.A[2]:20>t?this.A[3]:this.A[0]}},parser:{h:function(e,t){return 1>t?4>e||e>11?e:e+12:2>t?e:3>t&&e>9?e:e+12}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("cs",{MMMM:["leden","únor","březen","duben","květen","červen","červenec","srpen","září","říjen","listopad","prosinec"],MMM:["led","úno","bře","dub","kvě","čvn","čvc","srp","zář","říj","lis","pro"],dddd:["neděle","pondělí","úterý","středa","čtvrtek","pátek","sobota"],ddd:["ne","po","út","st","čt","pá","so"],dd:["ne","po","út","st","čt","pá","so"]})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("de",{MMMM:["Januar","Februar","März","April","Mai","Juni","Juli","August","September","Oktober","November","Dezember"],MMM:["Jan.","Febr.","Mrz.","Apr.","Mai","Jun.","Jul.","Aug.","Sept.","Okt.","Nov.","Dez."],dddd:["Sonntag","Montag","Dienstag","Mittwoch","Donnerstag","Freitag","Samstag"],ddd:["So.","Mo.","Di.","Mi.","Do.","Fr.","Sa."],dd:["So","Mo","Di","Mi","Do","Fr","Sa"],A:["Uhr nachmittags","Uhr morgens"]})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("el",{MMMM:{nominative:["Ιανουάριος","Φεβρουάριος","Μάρτιος","Απρίλιος","Μάιος","Ιούνιος","Ιούλιος","Αύγουστος","Σεπτέμβριος","Οκτώβριος","Νοέμβριος","Δεκέμβριος"],genitive:["Ιανουαρίου","Φεβρουαρίου","Μαρτίου","Απριλίου","Μαΐου","Ιουνίου","Ιουλίου","Αυγούστου","Σεπτεμβρίου","Οκτωβρίου","Νοεμβρίου","Δεκεμβρίου"]},MMM:["Ιαν","Φεβ","Μαρ","Απρ","Μαϊ","Ιουν","Ιουλ","Αυγ","Σεπ","Οκτ","Νοε","Δεκ"],dddd:["Κυριακή","Δευτέρα","Τρίτη","Τετάρτη","Πέμπτη","Παρασκευή","Σάββατο"],ddd:["Κυρ","Δευ","Τρι","Τετ","Πεμ","Παρ","Σαβ"],dd:["Κυ","Δε","Τρ","Τε","Πε","Πα","Σα"],A:["πμ","μμ"],formatter:{MMMM:function(e,t){return this.MMMM[/D.*MMMM/.test(t)?"genitive":"nominative"][e.getMonth()]},hh:function(e){return("0"+e.getHours()%12).slice(-2)},h:function(e){return e.getHours()%12}},parser:{MMMM:function(e,t){return this.parser.find(this.MMMM[/D.*MMMM/.test(t)?"genitive":"nominative"],e)}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("es",{MMMM:["enero","febrero","marzo","abril","mayo","junio","julio","agosto","septiembre","octubre","noviembre","diciembre"],MMM:["ene.","feb.","mar.","abr.","may.","jun.","jul.","ago.","sep.","oct.","nov.","dic."],dddd:["domingo","lunes","martes","miércoles","jueves","viernes","sábado"],ddd:["dom.","lun.","mar.","mié.","jue.","vie.","sáb."],dd:["do","lu","ma","mi","ju","vi","sá"],A:["de la mañana","de la tarde","de la noche"],formatter:{A:function(e){var t=e.getHours();return 12>t?this.A[0]:19>t?this.A[1]:this.A[2]}},parser:{h:function(e,t){return 1>t?e:e>11?e:e+12}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){var t=["۰","۱","۲","۳","۴","۵","۶","۷","۸","۹"],n={"۰":0,"۱":1,"۲":2,"۳":3,"۴":4,"۵":5,"۶":6,"۷":7,"۸":8,"۹":9};e.setLocales("fa",{MMMM:["ژانویه","فوریه","مارس","آوریل","مه","ژوئن","ژوئیه","اوت","سپتامبر","اکتبر","نوامبر","دسامبر"],MMM:["ژانویه","فوریه","مارس","آوریل","مه","ژوئن","ژوئیه","اوت","سپتامبر","اکتبر","نوامبر","دسامبر"],dddd:["یک‌شنبه","دوشنبه","سه‌شنبه","چهارشنبه","پنج‌شنبه","جمعه","شنبه"],ddd:["یک‌شنبه","دوشنبه","سه‌شنبه","چهارشنبه","پنج‌شنبه","جمعه","شنبه"],dd:["ی","د","س","چ","پ","ج","ش"],A:["قبل از ظهر","بعد از ظهر"],formatter:{post:function(e){return e.replace(/\d/g,function(e){return t[0|e]})}},parser:{pre:function(e){return e.replace(/[۰۱۲۳۴۵۶۷۸۹]/g,function(e){return""+n[e]})}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("fr",{MMMM:["janvier","février","mars","avril","mai","juin","juillet","août","septembre","octobre","novembre","décembre"],MMM:["janv.","févr.","mars","avr.","mai","juin","juil.","août","sept.","oct.","nov.","déc."],dddd:["dimanche","lundi","mardi","mercredi","jeudi","vendredi","samedi"],ddd:["dim.","lun.","mar.","mer.","jeu.","ven.","sam."],dd:["Di","Lu","Ma","Me","Je","Ve","Sa"],A:["matin","l'après-midi"]})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("hi",{MMMM:["जनवरी","फ़रवरी","मार्च","अप्रैल","मई","जून","जुलाई","अगस्त","सितम्बर","अक्टूबर","नवम्बर","दिसम्बर"],MMM:["जन.","फ़र.","मार्च","अप्रै.","मई","जून","जुल.","अग.","सित.","अक्टू.","नव.","दिस."],dddd:["रविवार","सोमवार","मंगलवार","बुधवार","गुरूवार","शुक्रवार","शनिवार"],ddd:["रवि","सोम","मंगल","बुध","गुरू","शुक्र","शनि"],dd:["र","सो","मं","बु","गु","शु","श"],A:["रात","सुबह","दोपहर","शाम"],formatter:{A:function(e){var t=e.getHours();return 4>t?this.A[0]:10>t?this.A[1]:17>t?this.A[2]:20>t?this.A[3]:this.A[0]}},parser:{h:function(e,t){return 1>t?4>e||e>11?e:e+12:2>t?e:3>t&&e>9?e:e+12}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("hu",{MMMM:["január","február","március","április","május","június","július","augusztus","szeptember","október","november","december"],MMM:["jan","feb","márc","ápr","máj","jún","júl","aug","szept","okt","nov","dec"],dddd:["vasárnap","hétfő","kedd","szerda","csütörtök","péntek","szombat"],ddd:["vas","hét","kedd","sze","csüt","pén","szo"],dd:["v","h","k","sze","cs","p","szo"],A:["de","du"]})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("id",{MMMM:["Januari","Februari","Maret","April","Mei","Juni","Juli","Agustus","September","Oktober","November","Desember"],MMM:["Jan","Feb","Mar","Apr","Mei","Jun","Jul","Ags","Sep","Okt","Nov","Des"],dddd:["Minggu","Senin","Selasa","Rabu","Kamis","Jumat","Sabtu"],ddd:["Min","Sen","Sel","Rab","Kam","Jum","Sab"],dd:["Mg","Sn","Sl","Rb","Km","Jm","Sb"],A:["pagi","siang","sore","malam"],formatter:{A:function(e){var t=e.getHours();return 11>t?this.A[0]:15>t?this.A[1]:19>t?this.A[2]:this.A[3]}},parser:{h:function(e,t){return 1>t?e:2>t&&e>=11?e:e+12}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("it",{MMMM:["gennaio","febbraio","marzo","aprile","maggio","giugno","luglio","agosto","settembre","ottobre","novembre","dicembre"],MMM:["gen","feb","mar","apr","mag","giu","lug","ago","set","ott","nov","dic"],dddd:["Domenica","Lunedì","Martedì","Mercoledì","Giovedì","Venerdì","Sabato"],ddd:["Dom","Lun","Mar","Mer","Gio","Ven","Sab"],dd:["Do","Lu","Ma","Me","Gi","Ve","Sa"],A:["di mattina","di pomerrigio"]})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("ja",{MMMM:["1月","2月","3月","4月","5月","6月","7月","8月","9月","10月","11月","12月"],MMM:["1月","2月","3月","4月","5月","6月","7月","8月","9月","10月","11月","12月"],dddd:["日曜日","月曜日","火曜日","水曜日","木曜日","金曜日","土曜日"],ddd:["日","月","火","水","木","金","土"],dd:["日","月","火","水","木","金","土"],A:["午前","午後"],formatter:{hh:function(e){return("0"+e.getHours()%12).slice(-2)},h:function(e){return e.getHours()%12}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("jv",{MMMM:["Januari","Februari","Maret","April","Mei","Juni","Juli","Agustus","September","Oktober","Nopember","Desember"],MMM:["Jan","Feb","Mar","Apr","Mei","Jun","Jul","Ags","Sep","Okt","Nop","Des"],dddd:["Minggu","Senen","Seloso","Rebu","Kemis","Jemuwah","Septu"],ddd:["Min","Sen","Sel","Reb","Kem","Jem","Sep"],dd:["Mg","Sn","Sl","Rb","Km","Jm","Sp"],A:["enjing","siyang","sonten","ndalu"],formatter:{A:function(e){var t=e.getHours();return 11>t?this.A[0]:15>t?this.A[1]:19>t?this.A[2]:this.A[3]}},parser:{h:function(e,t){return 1>t?e:2>t&&e>=11?e:e+12}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("ko",{MMMM:["1월","2월","3월","4월","5월","6월","7월","8월","9월","10월","11월","12월"],MMM:["1월","2월","3월","4월","5월","6월","7월","8월","9월","10월","11월","12월"],dddd:["일요일","월요일","화요일","수요일","목요일","금요일","토요일"],ddd:["일","월","화","수","목","금","토"],dd:["일","월","화","수","목","금","토"],A:["오전","오후"]})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){var t=["၀","၁","၂","၃","၄","၅","၆","၇","၈","၉"],n={"၀":0,"၁":1,"၂":2,"၃":3,"၄":4,"၅":5,"၆":6,"၇":7,"၈":8,"၉":9};e.setLocales("my",{MMMM:["ဇန်နဝါရီ","ဖေဖော်ဝါရီ","မတ်","ဧပြီ","မေ","ဇွန်","ဇူလိုင်","သြဂုတ်","စက်တင်ဘာ","အောက်တိုဘာ","နိုဝင်ဘာ","ဒီဇင်ဘာ"],MMM:["ဇန်","ဖေ","မတ်","ပြီ","မေ","ဇွန်","လိုင်","သြ","စက်","အောက်","နို","ဒီ"],dddd:["တနင်္ဂနွေ","တနင်္လာ","အင်္ဂါ","ဗုဒ္ဓဟူး","ကြာသပတေး","သောကြာ","စနေ"],ddd:["နွေ","လာ","ဂါ","ဟူး","ကြာ","သော","နေ"],dd:["နွေ","လာ","ဂါ","ဟူး","ကြာ","သော","နေ"],formatter:{post:function(e){return e.replace(/\d/g,function(e){return t[0|e]})}},parser:{pre:function(e){return e.replace(/[၀၁၂၃၄၅၆၇၈၉]/g,function(e){return""+n[e]})}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("nl",{MMMM:["januari","februari","maart","april","mei","juni","juli","augustus","september","oktober","november","december"],MMM:{withdots:["jan.","feb.","mrt.","apr.","mei","jun.","jul.","aug.","sep.","okt.","nov.","dec."],withoutdots:["jan","feb","mrt","apr","mei","jun","jul","aug","sep","okt","nov","dec"]},dddd:["zondag","maandag","dinsdag","woensdag","donderdag","vrijdag","zaterdag"],ddd:["zo.","ma.","di.","wo.","do.","vr.","za."],dd:["Zo","Ma","Di","Wo","Do","Vr","Za"],formatter:{MMM:function(e,t){return this.MMM[/-MMM-/.test(t)?"withoutdots":"withdots"][e.getMonth()]}},parser:{MMM:function(e,t){return this.parser.find(this.MMM[/-MMM-/.test(t)?"withoutdots":"withdots"],e)}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],
r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){var t=["੦","੧","੨","੩","੪","੫","੬","੭","੮","੯"],n={"੦":0,"੧":1,"੨":2,"੩":3,"੪":4,"੫":5,"੬":6,"੭":7,"੮":8,"੯":9};e.setLocales("pa-in",{MMMM:["ਜਨਵਰੀ","ਫ਼ਰਵਰੀ","ਮਾਰਚ","ਅਪ੍ਰੈਲ","ਮਈ","ਜੂਨ","ਜੁਲਾਈ","ਅਗਸਤ","ਸਤੰਬਰ","ਅਕਤੂਬਰ","ਨਵੰਬਰ","ਦਸੰਬਰ"],MMM:["ਜਨਵਰੀ","ਫ਼ਰਵਰੀ","ਮਾਰਚ","ਅਪ੍ਰੈਲ","ਮਈ","ਜੂਨ","ਜੁਲਾਈ","ਅਗਸਤ","ਸਤੰਬਰ","ਅਕਤੂਬਰ","ਨਵੰਬਰ","ਦਸੰਬਰ"],dddd:["ਐਤਵਾਰ","ਸੋਮਵਾਰ","ਮੰਗਲਵਾਰ","ਬੁਧਵਾਰ","ਵੀਰਵਾਰ","ਸ਼ੁੱਕਰਵਾਰ","ਸ਼ਨੀਚਰਵਾਰ"],ddd:["ਐਤ","ਸੋਮ","ਮੰਗਲ","ਬੁਧ","ਵੀਰ","ਸ਼ੁਕਰ","ਸ਼ਨੀ"],dd:["ਐਤ","ਸੋਮ","ਮੰਗਲ","ਬੁਧ","ਵੀਰ","ਸ਼ੁਕਰ","ਸ਼ਨੀ"],A:["ਰਾਤ","ਸਵੇਰ","ਦੁਪਹਿਰ","ਸ਼ਾਮ"],formatter:{A:function(e){var t=e.getHours();return 4>t?this.A[0]:10>t?this.A[1]:17>t?this.A[2]:20>t?this.A[3]:this.A[0]},post:function(e){return e.replace(/\d/g,function(e){return t[0|e]})}},parser:{h:function(e,t){return 1>t?4>e||e>11?e:e+12:2>t?e:3>t&&e>=10?e:e+12},pre:function(e){return e.replace(/[੦੧੨੩੪੫੬੭੮੯]/g,function(e){return""+n[e]})}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("pl",{MMMM:{nominative:["styczeń","luty","marzec","kwiecień","maj","czerwiec","lipiec","sierpień","wrzesień","październik","listopad","grudzień"],subjective:["stycznia","lutego","marca","kwietnia","maja","czerwca","lipca","sierpnia","września","października","listopada","grudnia"]},MMM:["sty","lut","mar","kwi","maj","cze","lip","sie","wrz","paź","lis","gru"],dddd:["niedziela","poniedziałek","wtorek","środa","czwartek","piątek","sobota"],ddd:["nie","pon","wt","śr","czw","pt","sb"],dd:["Nd","Pn","Wt","Śr","Cz","Pt","So"],formatter:{MMMM:function(e,t){return this.MMMM[/D MMMM/.test(t)?"subjective":"nominative"][e.getMonth()]}},parser:{MMMM:function(e,t){return this.parser.find(this.MMMM[/D MMMM/.test(t)?"subjective":"nominative"],e)}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("pt",{MMMM:["Janeiro","Fevereiro","Março","Abril","Maio","Junho","Julho","Agosto","Setembro","Outubro","Novembro","Dezembro"],MMM:["Jan","Fev","Mar","Abr","Mai","Jun","Jul","Ago","Set","Out","Nov","Dez"],dddd:["Domingo","Segunda-Feira","Terça-Feira","Quarta-Feira","Quinta-Feira","Sexta-Feira","Sábado"],ddd:["Dom","Seg","Ter","Qua","Qui","Sex","Sáb"],dd:["Dom","2ª","3ª","4ª","5ª","6ª","Sáb"],A:["da madrugada","da manhã","da tarde","da noite"],formatter:{A:function(e){var t=e.getHours();return 5>t?this.A[0]:12>t?this.A[1]:19>t?this.A[2]:this.A[3]}},parser:{h:function(e,t){return 2>t?e:e>11?e:e+12}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("ro",{MMMM:["ianuarie","februarie","martie","aprilie","mai","iunie","iulie","august","septembrie","octombrie","noiembrie","decembrie"],MMM:["ian.","febr.","mart.","apr.","mai","iun.","iul.","aug.","sept.","oct.","nov.","dec."],dddd:["duminică","luni","marți","miercuri","joi","vineri","sâmbătă"],ddd:["Dum","Lun","Mar","Mie","Joi","Vin","Sâm"],dd:["Du","Lu","Ma","Mi","Jo","Vi","Sâ"]})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("ru",{MMMM:["Января","Февраля","Марта","Апреля","Мая","Июня","Июля","Августа","Сентября","Октября","Ноября","Декабря"],MMM:["янв","фев","мар","апр","мая","июня","июля","авг","сен","окт","ноя","дек"],dddd:["Воскресенье","Понедельник","Вторник","Среду","Четверг","Пятницу","Субботу"],ddd:["Вс","Пн","Вт","Ср","Чт","Пт","Сб"],dd:["Вс","Пн","Вт","Ср","Чт","Пт","Сб"],A:["ночи","утра","дня","вечера"],formatter:{A:function(e){var t=e.getHours();return 4>t?this.A[0]:12>t?this.A[1]:17>t?this.A[2]:this.A[3]}},parser:{h:function(e,t){return 2>t?e:e>11?e:e+12}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("sr",{MMMM:["januar","februar","mart","april","maj","jun","jul","avgust","septembar","oktobar","novembar","decembar"],MMM:["jan.","feb.","mar.","apr.","maj","jun","jul","avg.","sep.","okt.","nov.","dec."],dddd:["nedelja","ponedeljak","utorak","sreda","četvrtak","petak","subota"],ddd:["ned.","pon.","uto.","sre.","čet.","pet.","sub."],dd:["ne","po","ut","sr","če","pe","su"]})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("th",{MMMM:["มกราคม","กุมภาพันธ์","มีนาคม","เมษายน","พฤษภาคม","มิถุนายน","กรกฎาคม","สิงหาคม","กันยายน","ตุลาคม","พฤศจิกายน","ธันวาคม"],MMM:["ม.ค.","ก.พ.","มี.ค.","เม.ย.","พ.ค.","มิ.ย.","ก.ค.","ส.ค.","ก.ย.","ต.ค.","พ.ย.","ธ.ค."],dddd:["อาทิตย์","จันทร์","อังคาร","พุธ","พฤหัสบดี","ศุกร์","เสาร์"],ddd:["อาทิตย์","จันทร์","อังคาร","พุธ","พฤหัส","ศุกร์","เสาร์"],dd:["อา.","จ.","อ.","พ.","พฤ.","ศ.","ส."],A:["ก่อนเที่ยง","หลังเที่ยง"]})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("tr",{MMMM:["Ocak","Şubat","Mart","Nisan","Mayıs","Haziran","Temmuz","Ağustos","Eylül","Ekim","Kasım","Aralık"],MMM:["Oca","Şub","Mar","Nis","May","Haz","Tem","Ağu","Eyl","Eki","Kas","Ara"],dddd:["Pazar","Pazartesi","Salı","Çarşamba","Perşembe","Cuma","Cumartesi"],ddd:["Paz","Pts","Sal","Çar","Per","Cum","Cts"],dd:["Pz","Pt","Sa","Ça","Pe","Cu","Ct"]})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("uk",{MMMM:["січня","лютого","березня","квітня","травня","червня","липня","серпня","вересня","жовтня","листопада","грудня"],MMM:["січ","лют","бер","квіт","трав","черв","лип","серп","вер","жовт","лист","груд"],dddd:{nominative:["неділя","понеділок","вівторок","середа","четвер","п’ятниця","субота"],accusative:["неділю","понеділок","вівторок","середу","четвер","п’ятницю","суботу"],genitive:["неділі","понеділка","вівторка","середи","четверга","п’ятниці","суботи"]},ddd:["нд","пн","вт","ср","чт","пт","сб"],dd:["нд","пн","вт","ср","чт","пт","сб"],A:["ночі","ранку","дня","вечора"],formatter:{A:function(e){var t=e.getHours();return 4>t?this.A[0]:12>t?this.A[1]:17>t?this.A[2]:this.A[3]},dddd:function(e,t){var n="nominative";return/(\[[ВвУу]\]) ?dddd/.test(t)?n="accusative":/\[?(?:минулої|наступної)? ?\] ?dddd/.test(t)&&(n="genitive"),this.dddd[n][e.getDay()]}},parser:{h:function(e,t){return 2>t?e:e>11?e:e+12}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("uz",{MMMM:["январ","феврал","март","апрел","май","июн","июл","август","сентябр","октябр","ноябр","декабр"],MMM:["янв","фев","мар","апр","май","июн","июл","авг","сен","окт","ноя","дек"],dddd:["Якшанба","Душанба","Сешанба","Чоршанба","Пайшанба","Жума","Шанба"],ddd:["Якш","Душ","Сеш","Чор","Пай","Жум","Шан"],dd:["Як","Ду","Се","Чо","Па","Жу","Ша"]})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("vi",{MMMM:["tháng 1","tháng 2","tháng 3","tháng 4","tháng 5","tháng 6","tháng 7","tháng 8","tháng 9","tháng 10","tháng 11","tháng 12"],MMM:["Th01","Th02","Th03","Th04","Th05","Th06","Th07","Th08","Th09","Th10","Th11","Th12"],dddd:["chủ nhật","thứ hai","thứ ba","thứ tư","thứ năm","thứ sáu","thứ bảy"],ddd:["CN","T2","T3","T4","T5","T6","T7"],dd:["CN","T2","T3","T4","T5","T6","T7"],A:["sa","ch"]})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("zh-cn",{MMMM:["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月"],MMM:["1月","2月","3月","4月","5月","6月","7月","8月","9月","10月","11月","12月"],dddd:["星期日","星期一","星期二","星期三","星期四","星期五","星期六"],ddd:["周日","周一","周二","周三","周四","周五","周六"],dd:["日","一","二","三","四","五","六"],A:["凌晨","早上","上午","中午","下午","晚上"],formatter:{A:function(e){var t=100*e.getHours()+e.getMinutes();return 600>t?this.A[0]:900>t?this.A[1]:1130>t?this.A[2]:1230>t?this.A[3]:1800>t?this.A[4]:this.A[5]}},parser:{h:function(e,t){return 4>t?e:e>11?e:e+12}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){var r,i,a;!function(o){"use strict";var s=function(e){e.setLocales("zh-tw",{MMMM:["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月"],MMM:["1月","2月","3月","4月","5月","6月","7月","8月","9月","10月","11月","12月"],dddd:["星期日","星期一","星期二","星期三","星期四","星期五","星期六"],ddd:["周日","周一","周二","周三","周四","周五","周六"],dd:["日","一","二","三","四","五","六"],A:["早上","上午","中午","下午","晚上"],formatter:{A:function(e){var t=100*e.getHours()+e.getMinutes();return 900>t?this.A[0]:1130>t?this.A[1]:1230>t?this.A[2]:1800>t?this.A[3]:this.A[4]}},parser:{h:function(e,t){return 3>t?e:e>11?e:e+12}}})};"object"==typeof e&&"object"==typeof e.exports?s(n(136)):(i=[n(136)],r=s,a="function"==typeof r?r.apply(t,i):r,!(void 0!==a&&(e.exports=a)))}(this)},function(e,t,n){"use strict";function r(e,t,n,r){return void 0===n&&(n=_.builtInRegistry()),v(e,new D(null,t,!1,r),n)}function i(e,t,n){return void 0===t&&(t=_.builtInRegistry()),u(new D(null,e,!1,n),t)}function a(e){return"?"==e.charAt(e.length-1)}function o(e,t){void 0===t&&(t=_.builtInRegistry());var n=e.provider&&e.provider();return u(new D(null,e,!1,n),t)}function s(e){return new F(e)}function u(e,t){var n=new x;if(e.anchor){if(e.anchor().__$$)return e.anchor().__$$;e.anchor().__$$=n}var r=e.childWithKey("types");r&&r.kind()===E.ARRAY&&(r=s(r));var i=e.childWithKey("schemas");i&&i.kind()===E.ARRAY&&(i=s(i));var a=new k(r,i,t,n);r&&r.kind()!==E.SCALAR&&r.children().filter(function(e){return e.key()&&!0}).forEach(function(e){var t=_.derive(e.key(),[_.REFERENCE]);n.add(t),a.addType(t)}),i&&i.kind()!==E.SCALAR&&i.children().filter(function(e){return e.key()&&!0}).forEach(function(e){var t=_.derive(e.key(),[_.REFERENCE]);n.add(t),a.addType(t)});var o=e.childWithKey("uses");o&&o.kind()===E.ARRAY&&(o=s(o)),o&&o.kind()===E.MAP&&o.children().forEach(function(e){n.addLibrary(e.key(),u(e,t))}),r&&r.kind()!==E.SCALAR&&r.children().filter(function(e){return e.key()&&!0}).forEach(function(e){a.get(e.key())}),i&&i.kind()!==E.SCALAR&&i.children().filter(function(e){return e.key()&&!0}).forEach(function(e){a.get(e.key())}),a.types().forEach(function(e){return n.add(e)});var r=e.childWithKey("annotationTypes");return r&&r.kind()===E.ARRAY&&(r=s(r)),null!=r&&r.kind()===E.MAP&&r.children().forEach(function(e){n.addAnnotationType(v(e.key(),e,a,!1,!0,!1))}),n}function l(e,t){var n=new U,r=!1,i=e.childWithKey("required");if(i){var o=i.value();"boolean"==typeof o&&(r=!0),o===!1&&(n.optional=!0,n.id=e.key())}var s=e.key();!r&&a(e.key())&&(s=s.substr(0,s.length-1),n.optional=!0),0==s.length||"/.*/"===s?n.additonal=!0:"/"==s.charAt(0)&&"/"==s.charAt(s.length-1)&&(s=s.substring(1,s.length-1),n.regExp=!0),n.type=v(null,e,t,!1,!1,!1);var u=e.getMeta("chaining");if(u&&u.length>0&&0==n.type.metaOfType(M.ImportedByChain).length){var l=n.type;if(n.type.isArray()){var p=n.type.metaOfType(S.ComponentShouldBeOfType);if(p&&p.length>0){var c=p[0].value();l=_.derive("",[c]),p[0].type=l}}else if(n.type.isUnion()){var f=n.type.allOptions();f.length>0&&(l=_.derive("",[f[0]]),f[0]=l)}if(0==l.metaOfType(M.ImportedByChain).length){!l.isSubTypeOf(_.UNKNOWN)&&_.InheritedType.isInstance(l)&&l.addSuper(_.UNKNOWN);for(var h=0,d=u;h<d.length;h++){var m=d[h];l.addMeta(new M.ImportedByChain(m.value))}}l.isSubTypeOf(_.UNKNOWN)||_.InheritedType.isInstance(l)&&l.addSuper(_.UNKNOWN);for(var y=0,g=u;y<g.length;y++){var m=g[y];l.addMeta(new M.ImportedByChain(m.value))}}return n.id=s,n}function p(e){var t=new B;t.name=e.name(),t.superTypes=e.superTypes().map(function(e){return h(e)}),t.annotations=[],t.customFacets=[],t.facetDeclarations=[],t.basicFacets=[],t.properties=[];var n={};return e.declaredMeta().forEach(function(e){if(e instanceof M.Annotation)t.annotations.push(e);else if(e instanceof M.CustomFacet)t.customFacets.push(e);else if(e instanceof M.NotScalar)t.notAScalar=!0;else if(e instanceof w.FacetDeclaration)t.facetDeclarations.push(e);else if(e instanceof S.HasProperty)if(n.hasOwnProperty(e.value()))n[e.value()].optional=!1;else{var r=new U;r.optional=!1,r.id=e.value(),r.type=_.ANY,n[e.value()]=r}else if(e instanceof S.AdditionalPropertyIs){var r=new U;r.optional=!1,r.id="/.*/",r.additonal=!0,r.type=e.value(),n["/.*/"]=r}else if(e instanceof S.MapPropertyIs){var r=new U;r.optional=!1,r.id=e.regexpValue(),r.regExp=!0,r.type=e.value(),n[e.regexpValue()]=r}else if(e instanceof S.PropertyIs)if(n.hasOwnProperty(e.propertyName()))n[e.propertyName()].type=e.value();else{var r=new U;r.optional=!0,r.id=e.propertyName(),r.type=e.value(),n[e.propertyName()]=r}else e instanceof S.KnownPropertyRestriction?t.additionalProperties=e.value():e instanceof M.DiscriminatorValue?e.isStrict()&&t.basicFacets.push(e):e instanceof M.HasPropertiesFacet||t.basicFacets.push(e)}),Object.keys(n).forEach(function(e){return t.properties.push(n[e])}),t}function c(e){return e instanceof b.AbstractType?p(e).toJSON():f(e)}function f(e){var t={},n={};e.types().forEach(function(e){n[e.name()]=c(e)}),Object.keys(n).length>0&&(t.types=n);var n={};return e.annotationTypes().forEach(function(e){n[e.name()]=c(e)}),Object.keys(n).length>0&&(t.annotationTypes=n),t}function h(e){if(e.isAnonymous()){if(e.isArray()){var t=e.oneMeta(S.ComponentShouldBeOfType);if(t){var n=t.value();return n.isAnonymous()&&n.isUnion()?"("+h(n)+")[]":h(n)+"[]"}}return e.isUnion()?e.options().map(function(e){return h(e)}).join(" | "):e.superTypes().map(function(e){return h(e)}).join(" , ")}return e.name()}function d(e,t){if(t===_.ANY||e===t||e.superTypes().some(function(e){return d(e,t)}))return!0;if(e.isUnion()&&e.options){var n=e.options();if(n.some(function(e){return d(e,t)}))return!0}if(t.isUnion()&&t.options){var n=t.options();if(n.some(function(t){return e==t}))return!0}return!1}function m(e,t){var n=e.requiredType(),r=e.requiredTypes();return r&&r.length>0?r.some(function(e){return d(t,e)}):d(t,n)}function y(e,t){for(var n=t.children(),r=0,i=n;r<i.length;r++){var a=i[r],o=a.key();if(o&&"("==o.charAt(0)&&")"==o.charAt(o.length-1)){var s=o.substring(1,o.length-1),u=new M.Annotation(s,a.value(),o);u.setNode(a),u.setOwnerFacet(e),e.addAnnotation(u)}}}function v(e,t,n,r,i,a,o){void 0===n&&(n=_.builtInRegistry()),void 0===r&&(r=!1),void 0===i&&(i=!1),void 0===a&&(a=!0),void 0===o&&(o=!1);var p=t.childWithKey("uses");if(p&&(p.kind()===E.ARRAY&&(p=s(p)),p.kind()===E.MAP)){var c=new x;p.children().forEach(function(e){c.addLibrary(e.key(),u(e,_.builtInRegistry()))}),n=new k(null,null,n,c)}if(t.kind()==E.SCALAR){var f,h=t.value();if(f=null==h||"Null"==h||"NULL"==h?_.STRING:I.parseToType(""+h,n,t),null==e)return V(f,t),f;var d=_.derive(e,[f]),A=t.getMeta("chaining");if(f&&A&&A.length>0){var b=d;if(f.isArray()){var w=f.metaOfType(S.ComponentShouldBeOfType);if(w&&w.length>0){var C=w[0].value();b=_.derive("",[C]),w[0].type=b}}else if(f.isUnion()){var P=f.allOptions();P.length>0&&(b=_.derive("",[P[0]]),P[0]=b)}if(0==b.metaOfType(M.ImportedByChain).length){b.isSubTypeOf(_.UNKNOWN)||b.addSuper(_.UNKNOWN);for(var D=0,U=A;D<U.length;D++){var F=U[D];b.addMeta(new M.ImportedByChain(F.value))}}}return k.isInstance(n)&&(d=g(d,n)),V(d,t),d}if(t.kind()==E.ARRAY){var B=[];t.children().forEach(function(e){B.push(I.parseToType(""+e.value(),n,t))});var d=_.derive(e,B);return k.isInstance(n)&&(d=g(d,n)),V(d,t),d}var K=[],j=t.childWithKey("type"),W=!1;j?t.childWithKey("schema")&&(W=!0):j=t.childWithKey("schema");var H=[];if(!j||o)K=r?t.childWithKey("properties")?[_.OBJECT]:[_.ANY]:t.childWithKey("properties")?[_.OBJECT]:[_.STRING];else{var Y=[],q=j.childWithKey("value");if(!q||q.kind()!=E.SCALAR&&q.kind()!=E.ARRAY||(Y=[j.children().filter(function(e){var t=e.key();return!!t&&"("==t.charAt(0)&&")"==t.charAt(t.length-1)})],j=q),j.kind()==E.SCALAR){var h=j.value();if(null==h||"Null"==h||"NULL"==h)K=[_.STRING];else{var G=j.contentProvider?j.contentProvider():null;K=[I.parseToType(""+h,n,t,G)]}}else j.kind()==E.ARRAY?K=j.children().map(function(e){var t=e.childWithKey("value");return!t||t.kind()!=E.SCALAR&&t.kind()!=E.ARRAY?Y.push([]):(Y.push(e.children().filter(function(e){var t=e.key();return!!t&&"("==t.charAt(0)&&")"==t.charAt(t.length-1)})),e=t),e.value()}).map(function(e){return I.parseToType(""+e,n,t)}):j.kind()==E.MAP&&(K=[v("",j,n,!1,!1,!1)]);if(Y.length>0&&Y.filter(function(e){return e.length>0}).length>0)for(var X=0,z=Y;X<z.length;X++){var $=z[X],J=[];H.push(J);for(var Q=0,Z=$;Q<Z.length;Q++){var ee=Z[Q],te=ee.key(),ne=te.substring(1,te.length-1),re=new M.Annotation(ne,ee.value(),te);re.setNode(ee),J.push(re)}}}for(var ie=_.derive(e,K),ae=0;ae<H.length;ae++){var oe=H[ae];ie.addSupertypeAnnotation(oe,ae)}k.isInstance(n)&&(ie=g(ie,n));var se=ie,ue=null;if(t.children().forEach(function(e){var r=e.key();q=e.childWithKey("value");var a=e;if("example"!=r&&q&&(a=q),r&&"type"!==r&&"uses"!==r&&"schema"!==r&&("properties"!=r&&"additionalProperties"!=r||!ie.isSubTypeOf(_.OBJECT))){var o;if("items"==r){if(ie.isSubTypeOf(_.ARRAY)){var s=[];if(a.kind()==E.SCALAR){var u=a.value();null==u||"Null"==u||"NULL"==u?s=[_.STRING]:(s=[I.parseToType(""+u,n,t)],V(s[0],a))}else if(a.kind()==E.ARRAY){s=a.children().map(function(e){var t=e.childWithKey("value");return!t||t.kind()!=E.SCALAR&&t.kind()!=E.ARRAY?Y.push([]):(Y.push(e.children().filter(function(e){var t=e.key();return!!t&&"("==t.charAt(0)&&")"==t.charAt(t.length-1)})),e=t),e}).map(function(e){var r=I.parseToType(""+e.value(),n,t);return V(r,e),r});var l=_.error(T.ITEMS_SHOULD_BE_REFERENCE_OR_INLINE_TYPE,se);l.setValidationPath({name:"items"}),ie.putExtra(N.PARSE_ERROR,l)}else a.kind()==E.MAP&&(s=[v("",a,n,!1,!1,!1)]);var p=1==s.length?s[0]:_.derive("",s);return o=new L.ComponentShouldBeOfType(p),se.addMeta(o),se.putExtra(N.HAS_ITEMS,!0),q&&y(o,e),o}}else{if("facets"===r)return void(ue=r);if("default"==r||"xml"==r||"required"==r)ue=r;else if("("==r.charAt(0)&&")"==r.charAt(r.length-1)){var c=new M.Annotation(r.substr(1,r.length-2),a.value(),r);return c.setNode(a),void ie.addMeta(c)}if(o=R.getInstance().buildFacet(r,a.value()),o&&("format"!=r||m(o,ie)))o.setNode(a),ie.addMeta(o);else if(i&&"allowedTargets"===r)ie.addMeta(new M.AllowedTargets(a.value()));else{var f=new M.CustomFacet(r,a.value());f.setNode(a),ie.addMeta(f)}}o&&y(o,e)}}),0==ie.metaOfType(M.DiscriminatorValue).length&&ie.addMeta(new M.DiscriminatorValue(ie.name(),!1)),ie.isSubTypeOf(_.OBJECT)){var le=t.childWithKey("properties"),pe=!1;if(le)if(ie.addMeta(new M.HasPropertiesFacet),le.kind()==E.MAP)le.children().forEach(function(e){pe=!0,l(e,n).add(ie)});else{var ce=_.error(T.PROPERTIES_MAP,se);ce.setValidationPath({name:"properties"}),ie.putExtra(N.PARSE_ERROR,ce)}var fe=t.childWithKey("additionalProperties");if(fe)if(q=fe.childWithKey("value"),q&&(fe=q),"boolean"==typeof fe.value())ie.addMeta(new O.KnownPropertyRestriction(fe.value()));else{var ce=_.error(T.ADDITIONAL_PROPERTIES_BOOLEAN,se);ce.setValidationPath({name:"additionalProperties"}),ie.putExtra(N.PARSE_ERROR,ce)}}var le=t.childWithKey("facets");if(le)if(le.kind()==E.MAP)le.children().forEach(function(e){var t=l(e,n);ie.addMeta(new M.FacetDeclaration(t.id,t.type,t.optional))});else{var ce=_.error(T.FACETS_MAP,se);ce.setValidationPath({name:"facets"}),ie.putExtra(N.PARSE_ERROR,ce)}if(ie.isAnonymous()&&ie.isEmpty()&&1==ie.superTypes().length){var he=ie.superTypes()[0];return V(he,t),he}return t.kind()!=E.SCALAR&&ie.addMeta(new M.NotScalar),W&&se.putExtra(_.SCHEMA_AND_TYPE,!0),se.putExtra(_.GLOBAL,a),se.putExtra(_.SOURCE_EXTRA,t),se.putExtra(N.HAS_FACETS,ue),V(se,t),t.getMeta("acceptAllScalarsAsStrings")&&se.addMeta(new M.AcceptAllScalarsAsStrings),se}function g(e,t){for(var n,r=t;r&&!(n=r.typeMap()[e.name()]);)r=r.parent();return null!=n&&n.isSubTypeOf(_.REFERENCE)?null!=n&&n.isSubTypeOf(_.REFERENCE)&&(n.patch(e),e=n):t.addType(e),e.putExtra(N.TOP_LEVEL_EXTRA,!0),e}var A=this&&this.__extends||function(){var e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();Object.defineProperty(t,"__esModule",{value:!0});var E,_=n(58),T=_.messageRegistry,N=n(71),S=n(73),b=n(58),I=n(170),R=n(133),M=n(75),w=n(75),C=n(58),L=n(73),P=n(59),O=n(73);!function(e){e[e.SCALAR=0]="SCALAR",e[e.ARRAY=1]="ARRAY",e[e.MAP=2]="MAP"}(E=t.NodeKind||(t.NodeKind={}));var D=function(){function e(e,t,n,r){void 0===n&&(n=!1),this._key=e,this.obj=t,this.inArr=n,this.provider=r}return e.prototype.value=function(){return this.obj},e.prototype.key=function(){if(!this._key&&this.kind()===E.MAP&&this.inArr){var e=Object.keys(this.obj);if(1===e.length)return e[0]}return this._key},e.prototype.childWithKey=function(t){return null==this.obj?null:this.obj.hasOwnProperty(t)?new e(t,this.obj[t],!1,this.contentProvider()):null},e.prototype.children=function(){var t=this;return Array.isArray(this.obj)?this.obj.map(function(n){return new e(null,n,!0,t.contentProvider())}):this.obj&&"object"==typeof this.obj?Object.keys(this.obj).map(function(n){return new e(n,t.obj[n],!1,t.provider)}):[]},e.prototype.kind=function(){return this.obj?Array.isArray(this.obj)?E.ARRAY:"object"==typeof this.obj?E.MAP:E.SCALAR:E.SCALAR},e.prototype.contentProvider=function(){return this.provider},e.prototype.getMeta=function(e){return null},e}();t.parseJSON=r,t.parseJSONTypeCollection=i;var U=function(){function e(){}return e.prototype.add=function(e){this.optional||this.additonal||this.regExp||this.type.isSubTypeOf(_.NIL)||e.addMeta(new S.HasProperty(this.id));var t;t=this.additonal?new S.AdditionalPropertyIs(this.type):this.regExp?new S.MapPropertyIs(this.id,this.type):new S.PropertyIs(this.id,this.type,this.optional),null!=t&&(e.addMeta(t),this.type instanceof _.InheritedType&&null==this.type.name()&&this.type.setContextMeta(t))},e}();t.PropertyBean=U;var x=function(){function e(){this._types=[],this._typeMap={},this.uses={},this._annotationTypes=[],this._annotationTypeMap={}}return e.prototype.library=function(e){return this.uses[e]},e.prototype.addLibrary=function(e,t){this.uses[e]=t},e.prototype.add=function(e){this._types.push(e),this._typeMap[e.name()]=e},e.prototype.getType=function(e){return this._typeMap.hasOwnProperty(e)?this._typeMap[e]:null},e.prototype.addAnnotationType=function(e){this._annotationTypes.push(e),this._annotationTypeMap[e.name()]=e},e.prototype.getAnnotationType=function(e){return this._annotationTypeMap.hasOwnProperty(e)?this._annotationTypeMap[e]:null},e.prototype.types=function(){return this._types},e.prototype.annotationTypes=function(){return this._annotationTypes},e.prototype.getAnnotationTypeRegistry=function(){var e=this,t=new C.TypeRegistry(_.builtInRegistry(),this,!0);return this.annotationTypes().forEach(function(e){return t.addType(e)}),Object.keys(this.uses).forEach(function(n){e.uses[n].annotationTypes().forEach(function(e){return t.put(n+"."+e.name(),e)})}),t},e.prototype.getTypeRegistry=function(){var e=this,t=new C.TypeRegistry(_.builtInRegistry(),this);return this.types().forEach(function(e){return t.addType(e)}),Object.keys(this.uses).forEach(function(n){e.uses[n].types().forEach(function(e){return t.put(n+"."+e.name(),e)})}),t},e}();t.TypeCollection=x;var k=function(e){function t(t,n,r,i){var a=e.call(this,r,i)||this;return a.toParse=t,a.schemas=n,a.parsing={},a}return A(t,e),t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_AccumulatingRegistry)},t.isInstance=function(e){return null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier&&P.contains(e.getClassIdentifier(),t.CLASS_IDENTIFIER_AccumulatingRegistry)},t.prototype.get=function(t){var n=e.prototype.get.call(this,t);if(!n||n.isSubTypeOf(_.REFERENCE)){var r=this.toParse?this.toParse.childWithKey(t):null;if(r||(r=this.schemas?this.schemas.childWithKey(t):null),r){if(this.parsing[t]){var i=_.derive(t,[_.RECURRENT]);return n&&n.isSubTypeOf(_.REFERENCE)?n.patch(i):n=i,n}this.parsing[t]=!0;try{var a=v(t,r,this)}finally{delete this.parsing[t]}return a}var o=t.indexOf(".");if(-1!=o){var s=t.substring(0,o),u=t.substr(o+1),l=this._c.library(s);if(l){var p=l.getType(u);if(p)return p}}}return n},t.CLASS_IDENTIFIER_AccumulatingRegistry="parse.AccumulatingRegistry",t}(_.TypeRegistry);t.AccumulatingRegistry=k,t.parseTypes=o;var F=function(){function e(e){this.n=e}return e.prototype.key=function(){return null},e.prototype.value=function(){return null},e.prototype.childWithKey=function(e){for(var t=this.children(),n=0;n<t.length;n++)if(t[n].key()==e)return t[n];return null},e.prototype.children=function(){return this.n.children().map(function(e){var t=e.children();return 1==t.length?t[0]:e})},e.prototype.kind=function(){return E.MAP},e.prototype.getMeta=function(e){return null},e}();t.parseTypeCollection=u,t.parsePropertyBean=l;var B=function(){function e(){}return e.prototype.toJSON=function(){var e={};if(this.superTypes&&this.superTypes.length>0&&(1==this.superTypes.length?e.type=this.superTypes[0]:e.type=this.superTypes),this.customFacets&&this.customFacets.forEach(function(t){return e[t.facetName()]=t.value()}),this.annotations&&this.annotations.forEach(function(t){return e["("+t.facetName()+")"]=t.value()}),this.facetDeclarations&&this.facetDeclarations.length>0){var t={};this.facetDeclarations.forEach(function(e){var n=e.facetName();e.isOptional()&&(n+="?");var r=null;r=e.type().isAnonymous()?e.type().isEmpty()?h(e.type()):p(e.type()).toJSON():h(e.type()),t[n]=r}),e.facets=t}if(this.properties&&this.properties.length>0){var n={};this.properties.forEach(function(e){var t=e.id;e.optional&&(t+="?"),e.additonal&&(t="/.*/"),e.regExp&&(t="/"+t+"/");var r=null;r=e.type.isAnonymous()?e.type.isEmpty()?h(e.type):p(e.type).toJSON():h(e.type),n[t]=r}),e.properties=n}return this.basicFacets&&this.basicFacets.forEach(function(t){e[t.facetName()]=t.value()}),1==Object.keys(e).length&&!this.notAScalar&&e.type?e.type:(void 0!==this.additionalProperties&&(e.additionalProperties=this.additionalProperties),e)},e}();t.TypeProto=B,t.toProto=p,t.storeAsJSON=c;var V=function(e,t){t.getMeta("skipValidation")&&e.addMeta(new M.SkipValidation)};t.parse=v},function(e,t,n){"use strict";function r(e,t,n,r){void 0===r&&(r=null);try{var i=e.trim();if(i.length>0){var o="{"==i.charAt(0);if(o||"<"==i.charAt(0)&&i.length>1&&"<"!=i.charAt(1)){var s=n,u=void 0;do u=s,s=u.childWithKey("type");while(s);var p=u&&u.contentProvider&&u.contentProvider();return new f.ExternalType("",i,o,p,r)}var c=l(e),h=a(c,t);return h}return f.derive(e,[f.STRING])}catch(t){return f.derive(e,[f.UNKNOWN])}}function i(e,t){for(;e>0;){var n=f.derive("",[f.ARRAY]);n.addMeta(new h.ComponentShouldBeOfType(t)),t=n,e--}return t}function a(e,t){if("union"==e.type){var n=e;return f.union("",[a(n.first,t),a(n.rest,t)])}if("parens"==e.type){var r=e,o=a(r.expr,t);return i(r.arr,o)}var s=e;if("?"==s.value.charAt(s.value.length-1)){var u=t.get(s.value.substr(0,s.value.length-1));u||(u=f.derive(s.value,[f.UNKNOWN])),u=f.union(s.value,[u,f.NIL]);var l=s.arr;return i(l,u)}var u=t.get(s.value);if(!u){u=f.derive(s.value,[f.UNKNOWN]);var p=t.getByChain(s.value);p&&u.addMeta(new d.ImportedByChain(s.value))}var l=s.arr;return i(l,u)}function o(e){if(e.isSubTypeOf(f.ARRAY)){var t=e.oneMeta(h.ComponentShouldBeOfType);return t?t.value().isUnion()?"("+o(t.value())+")[]":o(t.value())+"[]":"array"}if(e instanceof f.UnionType){var n=e;return n.options().map(function(e){return o(e)}).join(" | ")}return e.isAnonymous()&&e.isEmpty()?e.superTypes().map(function(e){return o(e)}).join(" , "):e.name()}function s(e,t){if(t(e),"union"==e.type){var n=e;s(n.first,t),s(n.rest,t)}else if("parens"==e.type){var r=e;s(r.expr,t)}}function u(e){var t,n=0;if("name"==e.type){var r=e;t=r.value,n=r.arr}else if("union"==e.type){var i=e;t=u(i.first)+" | "+u(i.rest)}else if("parens"==e.type){var a=e;t="("+u(a.expr)+")",n=a.arr}for(;--n>=0;)t+="[]";return t}function l(e){var t=c.parse(e);return t=p(t)}function p(e){if("name"==e.type){var t=e,n=t.value;if(n&&n.length&&"?"==n.charAt(n.length-1)){var r=n.substring(0,n.length-1),i=l(r),a={type:"union",first:i,rest:{type:"name",value:"nil"}};return"number"==typeof t.arr&&t.arr>0&&(a={type:"parens",expr:a,arr:t.arr}),a}return t}if("union"==e.type){var o=e;o.first=p(o.first),o.rest=p(o.rest)}else if("parens"==e.type){var s=e;s.expr=p(s.expr)}return e}Object.defineProperty(t,"__esModule",{value:!0});var c=n(171),f=n(58),h=n(73),d=n(75);t.parseToType=r,t.storeToString=o,t.visit=s,t.serializeToString=u,t.parse=l},function(e,t){"use strict";var n=function(){function e(e,t){function n(){this.constructor=e}n.prototype=t.prototype,e.prototype=new n}function t(e,n,r,i){this.message=e,this.expected=n,this.found=r,this.location=i,this.name="SyntaxError","function"==typeof Error.captureStackTrace&&Error.captureStackTrace(this,t)}function n(e){function n(t){var n,r,i=G[t];if(i)return i;for(n=t-1;!G[n];)n--;for(i=G[n],i={line:i.line,column:i.column,seenCR:i.seenCR};t>n;)r=e.charAt(n),"\n"===r?(i.seenCR||i.line++,i.column=1,i.seenCR=!1):"\r"===r||"\u2028"===r||"\u2029"===r?(i.line++,i.column=1,i.seenCR=!0):(i.column++,i.seenCR=!1),n++;return G[t]=i,i}function r(e,t){var r=n(e),i=n(t);return{start:{offset:e,line:r.line,column:r.column},end:{offset:t,line:i.line,column:i.column}}}function i(e){X>Y||(Y>X&&(X=Y,z=[]),z.push(e))}function a(e,n,r,i){function a(e){var t=1;for(e.sort(function(e,t){return e.description<t.description?-1:e.description>t.description?1:0});t<e.length;)e[t-1]===e[t]?e.splice(t,1):t++}function o(e,t){function n(e){function t(e){return e.charCodeAt(0).toString(16).toUpperCase()}return e.replace(/\\/g,"\\\\").replace(/"/g,'\\"').replace(/\x08/g,"\\b").replace(/\t/g,"\\t").replace(/\n/g,"\\n").replace(/\f/g,"\\f").replace(/\r/g,"\\r").replace(/[\x00-\x07\x0B\x0E\x0F]/g,function(e){return"\\x0"+t(e)}).replace(/[\x10-\x1F\x80-\xFF]/g,function(e){return"\\x"+t(e)}).replace(/[\u0100-\u0FFF]/g,function(e){return"\\u0"+t(e)}).replace(/[\u1000-\uFFFF]/g,function(e){return"\\u"+t(e)})}var r,i,a,o=new Array(e.length);for(a=0;a<e.length;a++)o[a]=e[a].description;return r=e.length>1?o.slice(0,-1).join(", ")+" or "+o[e.length-1]:o[0],i=t?'"'+n(t)+'"':"end of input","Expected "+r+" but "+i+" found."}return null!==n&&a(n),new t(null!==e?e:o(n,r),n,r,i)}function o(){var t,n,r,a,u,p,c,f;return t=Y,n=l(),n!==h?(r=s(),r!==h?(a=Y,u=l(),u!==h?(124===e.charCodeAt(Y)?(p=y,Y++):(p=h,0===$&&i(v)),p!==h?(c=l(),c!==h?(f=o(),f!==h?(u=[u,p,c,f],a=u):(Y=a,a=h)):(Y=a,a=h)):(Y=a,a=h)):(Y=a,a=h),a===h&&(a=null),a!==h?(q=t,n=g(r,a),t=n):(Y=t,t=h)):(Y=t,t=h)):(Y=t,t=h),t}function s(){var t,n,r,a,s,p,c,f,d,m;
if(t=Y,40===e.charCodeAt(Y)?(n=A,Y++):(n=h,0===$&&i(E)),n!==h)if(r=l(),r!==h)if(a=o(),a!==h)if(s=l(),s!==h)if(41===e.charCodeAt(Y)?(p=_,Y++):(p=h,0===$&&i(T)),p!==h){for(c=[],f=Y,d=l(),d!==h?(e.substr(Y,2)===N?(m=N,Y+=2):(m=h,0===$&&i(S)),m!==h?(d=[d,m],f=d):(Y=f,f=h)):(Y=f,f=h);f!==h;)c.push(f),f=Y,d=l(),d!==h?(e.substr(Y,2)===N?(m=N,Y+=2):(m=h,0===$&&i(S)),m!==h?(d=[d,m],f=d):(Y=f,f=h)):(Y=f,f=h);c!==h?(q=t,n=b(a,c),t=n):(Y=t,t=h)}else Y=t,t=h;else Y=t,t=h;else Y=t,t=h;else Y=t,t=h;else Y=t,t=h;return t===h&&(t=u()),t}function u(){var t,n,r,a,o,s;if($++,t=Y,n=[],r=p(),r!==h)for(;r!==h;)n.push(r),r=p();else n=h;if(n!==h){for(r=[],a=Y,o=l(),o!==h?(e.substr(Y,2)===N?(s=N,Y+=2):(s=h,0===$&&i(S)),s!==h?(o=[o,s],a=o):(Y=a,a=h)):(Y=a,a=h);a!==h;)r.push(a),a=Y,o=l(),o!==h?(e.substr(Y,2)===N?(s=N,Y+=2):(s=h,0===$&&i(S)),s!==h?(o=[o,s],a=o):(Y=a,a=h)):(Y=a,a=h);r!==h?(q=t,n=R(n,r),t=n):(Y=t,t=h)}else Y=t,t=h;return $--,t===h&&(n=h,0===$&&i(I)),t}function l(){var t,n;for($++,t=[],w.test(e.charAt(Y))?(n=e.charAt(Y),Y++):(n=h,0===$&&i(C));n!==h;)t.push(n),w.test(e.charAt(Y))?(n=e.charAt(Y),Y++):(n=h,0===$&&i(C));return $--,t===h&&(n=h,0===$&&i(M)),t}function p(){var t;return L.test(e.charAt(Y))?(t=e.charAt(Y),Y++):(t=h,0===$&&i(P)),t===h&&(95===e.charCodeAt(Y)?(t=O,Y++):(t=h,0===$&&i(D)),t===h&&(45===e.charCodeAt(Y)?(t=U,Y++):(t=h,0===$&&i(x)),t===h&&(46===e.charCodeAt(Y)?(t=k,Y++):(t=h,0===$&&i(F)),t===h&&(B.test(e.charAt(Y))?(t=e.charAt(Y),Y++):(t=h,0===$&&i(V)),t===h&&(K.test(e.charAt(Y))?(t=e.charAt(Y),Y++):(t=h,0===$&&i(j)),t===h&&(63===e.charCodeAt(Y)?(t=W,Y++):(t=h,0===$&&i(H)))))))),t}var c,f=arguments.length>1?arguments[1]:{},h={},d={Term:o},m=o,y="|",v={type:"literal",value:"|",description:'"|"'},g=function(e,t){return t?{type:"union",first:e,rest:t[3]}:e},A="(",E={type:"literal",value:"(",description:'"("'},_=")",T={type:"literal",value:")",description:'")"'},N="[]",S={type:"literal",value:"[]",description:'"[]"'},b=function(e,t){return{type:"parens",expr:e,arr:t.length}},I={type:"other",description:"name"},R=function(e,t){return{type:"name",value:e.join(""),arr:t.length}},M={type:"other",description:"whitespace"},w=/^[ \t\n\r]/,C={type:"class",value:"[ \\t\\n\\r]",description:"[ \\t\\n\\r]"},L=/^[A-Z]/,P={type:"class",value:"[A-Z]",description:"[A-Z]"},O="_",D={type:"literal",value:"_",description:'"_"'},U="-",x={type:"literal",value:"-",description:'"-"'},k=".",F={type:"literal",value:".",description:'"."'},B=/^[a-z:#\/]/,V={type:"class",value:"[a-z]",description:"[a-z]"},K=/^[0-9]/,j={type:"class",value:"[0-9]",description:"[0-9]"},W="?",H={type:"literal",value:"?",description:'"?"'},Y=0,q=0,G=[{line:1,column:1,seenCR:!1}],X=0,z=[],$=0;if("startRule"in f){if(!(f.startRule in d))throw new Error("Can't start parsing from rule \""+f.startRule+'".');m=d[f.startRule]}if(c=m(),c!==h&&Y===e.length)return c;throw c!==h&&Y<e.length&&i({type:"end",description:"end of input"}),a(null,z,X<e.length?e.charAt(X):null,X<e.length?r(X,X+1):r(X,X))}return e(t,Error),{SyntaxError:t,parse:n}}();e.exports=n},function(e,t,n){"use strict";function r(e){o=e}function i(e,t,n){void 0===n&&(n=null);var r=null;if(e.getExtra(d))return e.getExtra(d);if(!e){var m=t("any");m||(r=new u.StructuredType(e.name()))}if(e.isBuiltin()){var y="any"!=e.name()&&"array"!=e.name()?t(e.name()):null;r=y?y:e.isScalar()?new u.ValueType(e.name(),null):new u.StructuredType(e.name())}else if(e.isObject())r=new u.StructuredType(e.name(),null);else if(e.isArray()){var v=new u.Array(e.name(),null);r=v,e.putExtra(d,r);var g=e.oneMeta(p.ComponentShouldBeOfType),A=g?g.value():s.ANY;v.setComponent(i(A,t))}else if(e instanceof s.UnionType){var E=new u.Union(e.name(),null);0==e.superTypes().length&&E._superTypes.push(i(s.UNION,t,n)),e.putExtra(d,E),e.options().forEach(function(n){if(null==E.left)E.left=i(n,t);else if(null==E.right)E.right=i(n,t);else{var r=new u.Union(e.name(),null);r.left=E.right,r.right=i(n,t),E.right=r}}),r=E}else if(e.isScalar())r=new u.ValueType(e.name(),null);else if(e instanceof s.ExternalType){var _=e,T=new u.ExternalType(_.name());T.schemaString=_.schema(),r=T}if(r||(r=new u.StructuredType(e.name())),e.superTypes().forEach(function(e){var n=i(e,t);e.isBuiltin()?r._superTypes.push(n):r.addSuperType(n)}),e.isEmpty()){if(e.isArray()&&1==e.superTypes().length&&e.superTypes()[0].isAnonymous()){var N=r.superTypes()[0];N.setName(e.name()),N._subTypes=N._subTypes.filter(function(e){return e!=r}),r=N}if(e.isUnion()&&1==e.superTypes().length&&e.superTypes()[0].isAnonymous()){var N=r.superTypes()[0];N.setName(e.name()),N._subTypes=N._subTypes.filter(function(e){return e!=r}),r=N}}e.putExtra(d,r);var S=l.toProto(e);S.properties.forEach(function(e){var n=e.regExp?"/"+e.id+"/":e.id,a=o?o(n):new u.Property(n);a.withDomain(r),a.withRange(i(e.type,t)),e.optional||a.withRequired(!0),e.regExp&&a.withKeyRegexp(n)}),S.facetDeclarations.filter(function(e){return!e.isBuiltIn()}).forEach(function(e){var n=o?o(e.facetName()):new u.Property(e.facetName());n.withRange(i(e.type(),t)),r.addFacet(n)}),e.customFacets().forEach(function(e){r.fixFacet(e.facetName(),e.value())});for(var b={example:!0,examples:!0},I=e.meta().filter(function(t){if(!(t instanceof f.Discriminator||t instanceof f.DiscriminatorValue)){if(!(t instanceof p.FacetRestriction||t instanceof f.MetaInfo||t instanceof p.KnownPropertyRestriction))return!1;if(t instanceof f.FacetDeclaration||t instanceof f.CustomFacet)return!1}var n=t.requiredType(),r=n.isUnion()?n.allOptions():[n];if(!h.some(r,function(t){return e.isSubTypeOf(t)}))return!1;var i=t.facetName();return!b[i]&&("discriminatorValue"==i?t.isStrict():"allowedTargets"==i||null!=c.getInstance().facetPrototypeWithName(i))}),R=0,M=I;R<M.length;R++){var w=M[R],C=w.facetName();"closed"==C&&(C="additionalProperties"),r.fixFacet(C,w.value(),!0)}return r.addAdapter(e),e.isEmpty()&&r.addAdapter(new u.Empty),r._validator=a(e),e.isBuiltin()?r.buildIn=!0:e.subTypes().forEach(function(e){i(e,t,n)}),r}function a(e){return function(t){return e.validate(t,!1).getErrors()}}Object.defineProperty(t,"__esModule",{value:!0});var o,s=n(58),u=n(173),l=n(169),p=n(73),c=n(133),f=n(75),h=n(59),d="nominal";t.setPropertyConstructor=r,t.toNominal=i},function(e,t,n){"use strict";function r(e){c.push(e)}function i(e){var t=e.typeId();if(!t){var n=e.getAdapter(l.InheritedType);t=n&&n.id()+""||""}return t}var a=this&&this.__extends||function(){var e=Object.setPrototypeOf||{__proto__:[]}instanceof S&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();Object.defineProperty(t,"__esModule",{value:!0});var o=n(174),s=n(71),u=n(61),l=n(58),p=n(72),c=[];t.registerInjector=r;var f=function(){function e(){var e=this;this.adapters=[],c.forEach(function(t){return t.inject(e)})}return e.isInstance=function(t){if(null!=t&&t.getClassIdentifier&&"function"==typeof t.getClassIdentifier)for(var n=0,r=t.getClassIdentifier();n<r.length;n++){var i=r[n];if(i==e.CLASS_IDENTIFIER_Adaptable)return!0}return!1},e.prototype.getClassIdentifier=function(){var t=[];return t.concat(e.CLASS_IDENTIFIER_Adaptable)},e.prototype.addAdapter=function(e){this.adapters.push(e)},e.prototype.getAdapter=function(e){var t=null;return this.adapters.forEach(function(n){n instanceof e&&(t=n)}),t},e.prototype.getAdapters=function(){return this.adapters},e.CLASS_IDENTIFIER_Adaptable="nominal-types.Adaptable",e}();t.Adaptable=f;var h=function(e){function t(t,n){void 0===n&&(n="");var r=e.call(this)||this;return r._name=t,r._description=n,r._tags=[],r._annotations=[],r}return a(t,e),t.prototype.nameId=function(){return this._name},t.prototype.description=function(){return this._description},t.isInstance=function(e){if(null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier)for(var n=0,r=e.getClassIdentifier();n<r.length;n++){var i=r[n];if(i==t.CLASS_IDENTIFIER_Described)return!0}return!1},t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_Described)},t.prototype.addAnnotation=function(e){this._annotations.push(e)},t.prototype.removeAnnotation=function(e){this._annotations=this._annotations.filter(function(t){return t!=e})},t.prototype.annotations=function(){return[].concat(this._annotations)},t.prototype.tags=function(){return this._tags},t.prototype.withDescription=function(e){return this._description=e,this},t.prototype.setName=function(e){this._name=e},t.CLASS_IDENTIFIER_Described="nominal-types.Described",t}(f);t.Described=h;var d=function(e){function t(t,n){var r=e.call(this,t.nameId())||this;return r.type=t,r.parameters=n,r}return a(t,e),t.prototype.parameterNames=function(){return Object.keys(this.parameters)},t.prototype.parameter=function(e){return this.parameters[e]},t.prototype.getType=function(){return this.type},t}(h);t.Annotation=d;var m=function(){function e(){}return e}();t.Empty=m;var y=function(){function e(){}return e.prototype.type=function(e){return null},e.prototype.version=function(){return"Empty"},e.prototype.types=function(){return[]},e.prototype.matched=function(){return{}},e}(),v=new y,g=n(134),A=function(e){function t(t,n,r){void 0===n&&(n=v),void 0===r&&(r="");var i=e.call(this,t)||this;return i._universe=n,i._path=r,i._customProperties=[],i._facets=[],i._superTypes=[],i._subTypes=[],i._requirements=[],i._fixedFacets={},i._fixedBuildInFacets={},i.uc=!1,i}return a(t,e),t.prototype.properties=function(){return[]},t.prototype.externalInHierarchy=function(){var e=this.allSuperTypes(),t=null;return e.forEach(function(e){e instanceof b&&(t=e)}),t},t.prototype.addFacet=function(e){this._facets.push(e)},t.prototype.validate=function(e){if(!this._validator)throw new Error(p.VALIDATE_ONLY_ON_RUNTIME_TYPES_INSTANCES.message);return this._validator(e)},t.prototype.allFacets=function(e){if(void 0===e&&(e={}),this._allFacets)return this._allFacets;if(e[this.nameId()])return[];e[this.typeId()]=this;var n={};return this.superTypes().length>0&&this.superTypes().forEach(function(r){r instanceof t&&r.allFacets(e).forEach(function(e){return n[e.nameId()]=e})}),this._facets.forEach(function(e){return n[e.nameId()]=e}),this._allFacets=Object.keys(n).map(function(e){return n[e]}),this._allFacets},t.prototype.facets=function(){return[].concat(this._facets)},t.prototype.facet=function(e){return u.find(this.allFacets(),function(t){return t.nameId()==e})},t.prototype.typeId=function(){return this.nameId()},t.prototype.allProperties=function(e){if(void 0===e&&(e={}),this._props)return this._props;var n=i(this);if(e[n])return[];e[n]=this;var r={};this.superTypes().length>0&&this.superTypes().forEach(function(n){n instanceof t?n.allProperties(e).forEach(function(e){return r[e.nameId()]=e}):n.allProperties().forEach(function(e){return r[e.nameId()]=e})});for(var a in this.fixedFacets())delete r[a];return this.properties().forEach(function(e){return r[e.nameId()]=e}),this._props=Object.keys(r).map(function(e){return r[e]}),this._props},t.prototype.property=function(e){return u.find(this.allProperties(),function(t){return t.nameId()==e})},t.prototype.hasValueTypeInHierarchy=function(){return null!=u.find(this.allSuperTypes(),function(e){var t=e;if(t.uc)return!1;t.uc=!0;try{return e.hasValueTypeInHierarchy()}finally{t.uc=!1}})},t.prototype.isAnnotationType=function(){return!1},t.prototype.hasStructure=function(){return!1},t.prototype.key=function(){return this._key?this._key:this._universe&&(this._key=this.universe().matched()[this.nameId()],!this._key)?null:this._key},t.prototype.hasArrayInHierarchy=function(){var e=null!=u.find(this.allSuperTypes(),function(e){return e instanceof S});return e},t.prototype.arrayInHierarchy=function(){var e=this.allSuperTypes(),t=null;return e.forEach(function(e){e instanceof S&&(t=e)}),t},t.prototype.unionInHierarchy=function(){var e=this.allSuperTypes(),t=null;return e.forEach(function(e){e instanceof N&&(t=e)}),t},t.prototype.hasExternalInHierarchy=function(){return null!=u.find(this.allSuperTypes(),function(e){var t=e;if(t.uc)return!1;t.uc=!0;try{return e instanceof b}finally{t.uc=!1}})},t.prototype.hasUnionInHierarchy=function(){return null!=u.find(this.allSuperTypes(),function(e){var t=e;if(t.uc)return!1;t.uc=!0;try{return e.hasUnionInHierarchy()}finally{t.uc=!1}})},t.prototype.fixFacet=function(e,t,n){void 0===n&&(n=!1),n?this._fixedBuildInFacets[e]=t:this._fixedFacets[e]=t},t.prototype.getFixedFacets=function(){return this.fixedFacets()},t.prototype.fixedFacets=function(){return this.collectFixedFacets(!1)},t.prototype.fixedBuiltInFacets=function(){return this.collectFixedFacets(!0)},t.prototype.collectFixedFacets=function(e){for(var t=e?this._fixedBuildInFacets:this._fixedFacets,n={},r=0,i=Object.keys(t);r<i.length;r++){var a=i[r];n[a]=t[a]}return this.contributeFacets(n),n},t.prototype.allFixedFacets=function(){return this.collectAllFixedFacets(!1)},t.prototype.allFixedBuiltInFacets=function(){return this.collectAllFixedFacets(!0)},t.prototype.collectAllFixedFacets=function(e){if(e&&this._abf)return this._abf;if(!e&&this._af)return this._af;var t=this.allSuperTypes();t.push(this);var n={};return t.forEach(function(t){for(var r=e?t.fixedBuiltInFacets():t.fixedFacets(),i=0,a=Object.keys(r);i<a.length;i++){var o=a[i];n[o]=r[o]}}),this._af=n,n},t.prototype.contributeFacets=function(e){},t.prototype.getPath=function(){return this._path},t.prototype.setNameAtRuntime=function(e){this._nameAtRuntime=e},t.prototype.getNameAtRuntime=function(){return this._nameAtRuntime},t.prototype.universe=function(){return this._universe?this._universe:new y},t.prototype.superTypes=function(){return[].concat(this._superTypes)},t.prototype.isAssignableFrom=function(e){if(this.nameId()==e)return!this.isUserDefined();for(var t=this.allSuperTypes(),n=0;n<t.length;n++)if(t[n].nameId()==e)return!0;return!1},t.prototype.annotationType=function(){return null},t.prototype.subTypes=function(){return[].concat(this._subTypes)},t.prototype.allSubTypes=function(){var e=[];return this.subTypes().forEach(function(t){e.push(t),e=e.concat(t.allSubTypes())}),u.unique(e)},t.prototype.allSuperTypes=function(){if(this._allSupers)return this._allSupers;var e=[];return this.allSuperTypesRecurrent(this,{},e),this._allSupers=u.unique(e),this._allSupers},t.prototype.allSuperTypesRecurrent=function(e,t,n){var r=this;e.superTypes().forEach(function(e){var a=i(e);if(!a){var o=e.getAdapter(l.InheritedType);a=o&&o.id()+""||""}t[a]||(n.push(e),t[a]=e,r.allSuperTypesRecurrent(e,t,n))})},t.prototype.addSuperType=function(e){e._subTypes.push(this),this._superTypes.push(e)},t.prototype.addRequirement=function(e,t){this._requirements.push(new o.ValueRequirement(e,t))},t.prototype.valueRequirements=function(){return this._requirements},t.prototype.requiredProperties=function(){return this.allProperties().filter(function(e){return e.isRequired()})},t.prototype.printDetails=function(e,n){var r=this;e||(e=""),n||(n={hideProperties:!1,hideSuperTypeProperties:!1,printStandardSuperclasses:!1});var i="  ",a="",o=this.getTypeClassName();a+=e+this.nameId()+"["+o+"]\n";var s=this.properties();s&&s.length>0&&!n.hideProperties&&(a+=e+i+"Properties:\n",s.forEach(function(n){var r="",o=n.range();o instanceof h&&(r+=o.nameId()),o instanceof t&&(r+="[",r+=o.getTypeClassName(),r+="]"),a+=e+i+i+n.nameId()+" : "+r+"\n"}));var l=this.superTypes(),p=l;return l&&!n.printStandardSuperclasses&&(p=u.filter(l,function(e){var n=e instanceof h?e.nameId():"",i=e instanceof t?e.getTypeClassName():"";return!r.isStandardSuperclass(n,i)})),p&&p.length>0&&(a+=e+i+"Super types:\n",p.forEach(function(t){a+=t.printDetails(e+i+i,{hideProperties:n.hideSuperTypeProperties,hideSuperTypeProperties:n.hideSuperTypeProperties,printStandardSuperclasses:n.printStandardSuperclasses})})),a},t.prototype.getTypeClassName=function(){return this.constructor.toString().match(/\w+/g)[1]},t.prototype.isStandardSuperclass=function(e,t){return"TypeDeclaration"===e&&"NodeClass"===t||"ObjectTypeDeclaration"===e&&"NodeClass"===t||"RAMLLanguageElement"===e&&"NodeClass"===t},t.prototype.examples=function(e){return g.exampleFromNominal(this,e)},t.prototype.isGenuineUserDefinedType=function(){if(this.buildIn)return!1;if(this.properties()&&this.properties().length>0)return!0;var e=this.fixedFacets();if(e&&Object.keys(e).length>0)return!0;var t=this.fixedBuiltInFacets();return!!(t&&Object.keys(t).length>0)||this.isTopLevel()&&this.nameId()&&this.nameId().length>0},t.prototype.genuineUserDefinedTypeInHierarchy=function(){if(this.isGenuineUserDefinedType())return this;var e=null,t=this.allSuperTypes();return t.forEach(function(t){!e&&t.isGenuineUserDefinedType()&&(e=t)}),e},t.prototype.hasGenuineUserDefinedTypeInHierarchy=function(){return null!=u.find(this.allSuperTypes(),function(e){var t=e;if(t.uc)return!1;t.uc=!0;try{return e.isGenuineUserDefinedType()}finally{t.uc=!1}})},t.prototype.customProperties=function(){return[].concat(this._customProperties)},t.prototype.allCustomProperties=function(){var e=[];return this.superTypes().forEach(function(t){return e=e.concat(t.allCustomProperties())}),e=e.concat(this.customProperties())},t.prototype.registerCustomProperty=function(e){if(e.domain()!=this)throw new Error(p.SHOULD_BE_ALREADY_OWNED.message);if(-1!=this._customProperties.indexOf(e))throw new Error(p.ALREADY_INCLUDED.message);this._customProperties.push(e)},t.prototype.setCustom=function(e){this._isCustom=e},t.prototype.isCustom=function(){return this._isCustom},t.prototype.isUnion=function(){return!1},t.prototype.union=function(){return null},t.prototype.isExternal=function(){return!1},t.prototype.external=function(){return null},t.prototype.isArray=function(){return!1},t.prototype.isObject=function(){if("object"==this.nameId())return!0;for(var e=0,t=this.allSuperTypes();e<t.length;e++){var n=t[e];if(n.isObject())return!0}return!1},t.prototype.array=function(){return null},t.prototype.isValueType=function(){return!1},t.prototype.kind=function(){var e=[];return this.isObject()&&e.push("object"),this.isArray()&&e.push("array"),this.isValueType()&&e.push("value"),this.isUnion()&&e.push("union"),this.isAnnotationType()&&e.push("annotation"),this.isExternal()&&e.push("external"),e},t.prototype.isBuiltIn=function(){return this.buildIn},t.prototype.setBuiltIn=function(e){this.buildIn=e},t.prototype.isTopLevel=function(){return!(!this.getExtra(s.DEFINED_IN_TYPES_EXTRA)&&!this.getExtra(s.TOP_LEVEL_EXTRA))},t.prototype.isUserDefined=function(){return this.getExtra(s.USER_DEFINED_EXTRA)&&!this.buildIn},t.prototype.putExtra=function(e,t){var n=this.getExtraAdapter();n&&n.putExtra(e,t)},t.prototype.getExtra=function(e){var t=this.getExtraAdapter();return t?t.getExtra(e):null},t.prototype.getExtraAdapter=function(){if(this.getAdapters()){var e=u.find(this.getAdapters(),function(e){return e.getExtra&&"function"==typeof e.getExtra&&e.putExtra&&"function"==typeof e.putExtra?!0:void 0});return e}return null},t}(h);t.AbstractType=A;var E=function(e){function t(t,n,r,i){return void 0===n&&(n=null),void 0===r&&(r=""),void 0===i&&(i=""),e.call(this,t,n,r)||this}return a(t,e),t.prototype.hasStructure=function(){return!1},t.prototype.hasValueTypeInHierarchy=function(){return!0},t.prototype.isValueType=function(){return!0},t.prototype.isUnionType=function(){return!1},t.prototype.isObject=function(){return!1},t}(A);t.ValueType=E;var _=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t._properties=[],t}return a(t,e),t.prototype.hasStructure=function(){return!0},t.prototype.propertyIndex=function(e){for(var t=this.properties(),n=0;n<t.length;n++)if(t[n].nameId()==e)return n;return-1},t.prototype.addProperty=function(e,t){return new T(e).withDomain(this).withRange(t)},t.prototype.allPropertyIndex=function(e){for(var t=this.allProperties(),n=0;n<t.length;n++)if(t[n].nameId()==e)return n;return-1},t.prototype.properties=function(){return[].concat(this._properties)},t.prototype.registerProperty=function(e){if(e.domain()!=this)throw new Error(p.SHOULD_BE_ALREADY_OWNED.message);if(-1!=this._properties.indexOf(e))throw new Error(p.ALREADY_INCLUDED.message);this._properties.push(e)},t}(A);t.StructuredType=_;var T=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t._keyShouldStartFrom=null,t._isRequired=!1,t._isMultiValue=!1,t._descriminates=!1,t._defaultBooleanValue=null,t._defaultIntegerValue=null,t}return a(t,e),t.isInstance=function(e){if(null!=e&&e.getClassIdentifier&&"function"==typeof e.getClassIdentifier)for(var n=0,r=e.getClassIdentifier();n<r.length;n++){var i=r[n];if(i==t.CLASS_IDENTIFIER_Property)return!0}return!1},t.prototype.getClassIdentifier=function(){var n=e.prototype.getClassIdentifier.call(this);return n.concat(t.CLASS_IDENTIFIER_Property)},t.prototype.withMultiValue=function(e){return void 0===e&&(e=!0),this._isMultiValue=e,this},t.prototype.withDescriminating=function(e){return this._descriminates=e,this},t.prototype.withRequired=function(e){return this._isRequired=e,this},t.prototype.isRequired=function(){return this._isRequired},t.prototype.withKeyRestriction=function(e){return this._keyShouldStartFrom=e,this},t.prototype.withDomain=function(e,t){return void 0===t&&(t=!1),this._ownerClass=e,t?e.registerCustomProperty(this):e.registerProperty(this),this},t.prototype.setDefaultVal=function(e){return this._defaultValue=e,this},t.prototype.setDefaultBooleanVal=function(e){return this._defaultBooleanValue=e,this},t.prototype.setDefaultIntegerVal=function(e){return this._defaultIntegerValue=e,this},t.prototype.defaultValue=function(){return null!=this._defaultValue?this._defaultValue:null!=this._defaultBooleanValue?this._defaultBooleanValue:null!=this._defaultIntegerValue?this._defaultIntegerValue:null},t.prototype.isPrimitive=function(){return!1},t.prototype.withRange=function(e){return this._nodeRange=e,this},t.prototype.isValueProperty=function(){return this._nodeRange.hasValueTypeInHierarchy()},t.prototype.enumOptions=function(){return this._enumOptions&&"string"==typeof this._enumOptions?[this._enumOptions+""]:this._enumOptions},t.prototype.keyPrefix=function(){return this._keyShouldStartFrom},t.prototype.withEnumOptions=function(e){return this._enumOptions=e,this},t.prototype.withKeyRegexp=function(e){return this._keyRegexp=e,this},t.prototype.getKeyRegexp=function(){return this._keyRegexp},t.prototype.matchKey=function(e){if(null==e)return!1;if(null!=this._groupName)return this._groupName==e;if(null!=this._keyShouldStartFrom&&0==e.indexOf(this._keyShouldStartFrom))return!0;if(this._enumOptions&&-1!=this._enumOptions.indexOf(e))return!0;if(this.getKeyRegexp())try{if(new RegExp(this.getKeyRegexp()).test(e))return!0}catch(e){}return!1},t.prototype.getFacetValidator=function(){return this.facetValidator},t.prototype.setFacetValidator=function(e){this.facetValidator=e},t.prototype.domain=function(){return this._ownerClass},t.prototype.range=function(){return this._nodeRange},t.prototype.isMultiValue=function(){return!(!this.range()||!this.range().hasArrayInHierarchy())||this._isMultiValue},t.prototype.isDescriminator=function(){return this._descriminates},t.CLASS_IDENTIFIER_Property="nominal-types.Property",t}(h);t.Property=T;var N=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a(t,e),t.prototype.key=function(){return null},t.prototype.leftType=function(){return this.left},t.prototype.rightType=function(){return this.right},t.prototype.isUserDefined=function(){return!0},t.prototype.unionInHierarchy=function(){return this},t.prototype.union=function(){return this},t.prototype.hasUnionInHierarchy=function(){return!0},t.prototype.isUnion=function(){return!0},t.prototype.isObject=function(){return this.leftType().isObject()&&this.rightType().isObject()},t.prototype.hasArrayInHierarchy=function(){return this.left&&this.right?this.left.hasArrayInHierarchy()||this.right.hasArrayInHierarchy():this.left?this.left.hasArrayInHierarchy():this.right?this.right.hasArrayInHierarchy():void 0},t}(A);t.Union=N;var S=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a(t,e),t.prototype.hasArrayInHierarchy=function(){return!0},t.prototype.isArray=function(){return!0},t.prototype.isObject=function(){return!1},t.prototype.arrayInHierarchy=function(){return this},t.prototype.array=function(){return this},t.prototype.isUserDefined=function(){return!0},t.prototype.componentType=function(){return this.component},t.prototype.setComponent=function(e){this.component=e},t.prototype.key=function(){return null},t}(A);t.Array=S;var b=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a(t,e),t.prototype.externalInHierarchy=function(){return this},t.prototype.typeId=function(){return this.schemaString},t.prototype.schema=function(){return this.schemaString},t.prototype.isUserDefined=function(){return!0},t.prototype.hasExternalInHierarchy=function(){return!0},t.prototype.isExternal=function(){return!0},t.prototype.external=function(){return this},t}(_);t.ExternalType=b},function(e,t){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var n=function(){function e(e,t){this.name=e,this.value=t}return e}();t.ValueRequirement=n},function(e,t,n){"use strict";function r(e,t){o.visit(e,t)}function i(e){return o.serializeToString(e)}function a(e){return o.parse(e)}Object.defineProperty(t,"__esModule",{value:!0});var o=n(170);t.visit=r,t.serializeToString=i,t.parse=a},function(e,t,n){"use strict";function r(e){var t=e[0],n={};return e.forEach(function(e){return n[e.name]=e}),e.forEach(function(e){var t=e.imports;Object.keys(t).forEach(function(e){var r=t[e];t[e]=n[r]})}),t}Object.defineProperty(t,"__esModule",{value:!0}),t.universeDumps={RAML08:r(n(177)),RAML10:r(n(178))}},function(e,t){e.exports=[{classes:[{name:"GlobalSchema",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[{typeName:"Referencable",nameSpace:"",basicName:"Referencable",typeKind:0,typeArguments:[{typeName:"Sys.SchemaString",nameSpace:"Sys",basicName:"SchemaString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"}],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"}],fields:[{name:"key",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.key",arguments:[]},{name:"MetaModel.description",arguments:["Name of the global schema, used to refer on schema content"]}],valueConstraint:null,optional:!1},{name:"value",type:{typeName:"Sys.SchemaString",nameSpace:"Sys",basicName:"SchemaString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},annotations:[{name:"MetaModel.description",arguments:["Content of the schema"]},{name:"MetaModel.value",arguments:[]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.actuallyExports",arguments:["value"]},{name:"MetaModel.description",arguments:["Content of the schema"]}],"extends":[{typeName:"RAMLSimpleElement",nameSpace:"",basicName:"RAMLSimpleElement",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"}],moduleName:"RAMLSpec",annotationOverridings:{}},{name:"Api",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"title",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.required",arguments:[]},{name:"MetaModel.description",arguments:["The title property is a short plain text description of the RESTful API. The value SHOULD be suitable for use as a title for the contained user documentation."]}],valueConstraint:null,optional:!1},{name:"version",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["If the RAML API definition is targeted to a specific API version, the API definition MUST contain a version property. The version property is OPTIONAL and should not be used if: The API itself is not versioned. The API definition does not change between versions. The API architect can decide whether a change to user documentation elements, but no change to the API's resources, constitutes a version change. The API architect MAY use any versioning scheme so long as version numbers retain the same format. For example, 'v3', 'v3.0', and 'V3' are all allowed, but are not considered to be equal."]}],valueConstraint:null,optional:!1},{name:"baseUri",type:{typeName:"Sys.FullUriTemplateString",nameSpace:"Sys",basicName:"FullUriTemplateString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},annotations:[{name:"MetaModel.description",arguments:["(Optional during development; Required after implementation) A RESTful API's resources are defined relative to the API's base URI. The use of the baseUri field is OPTIONAL to allow describing APIs that have not yet been implemented. After the API is implemented (even a mock implementation) and can be accessed at a service endpoint, the API definition MUST contain a baseUri property. The baseUri property's value MUST conform to the URI specification RFC2396 or a Level 1 Template URI as defined in RFC6570. The baseUri property SHOULD only be used as a reference value."]}],valueConstraint:null,optional:!1},{name:"baseUriParameters",type:{base:{typeName:"Params.Parameter",nameSpace:"Params",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.setsContextValue",arguments:["location","Params.ParameterLocation.BURI"]},{name:"MetaModel.description",arguments:["Base uri parameters are named parameters which described template parameters in the base uri"]}],valueConstraint:null,optional:!1},{name:"uriParameters",type:{base:{typeName:"Params.Parameter",nameSpace:"Params",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.setsContextValue",arguments:["location","Params.ParameterLocation.BURI"]},{name:"MetaModel.description",arguments:["URI parameters can be further defined by using the uriParameters property. The use of uriParameters is OPTIONAL. The uriParameters property MUST be a map in which each key MUST be the name of the URI parameter as defined in the baseUri property. The uriParameters CANNOT contain a key named version because it is a reserved URI parameter name. The value of the uriParameters property is itself a map that specifies  the property's attributes as named parameters"]}],valueConstraint:null,optional:!1},{name:"protocols",type:{base:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},typeKind:1},annotations:[{name:"MetaModel.oneOf",arguments:[["HTTP","HTTPS"]]},{name:"MetaModel.description",arguments:["A RESTful API can be reached HTTP, HTTPS, or both. The protocols property MAY be used to specify the protocols that an API supports. If the protocols property is not specified, the protocol specified at the baseUri property is used. The protocols property MUST be an array of strings, of values `HTTP` and/or `HTTPS`."]}],valueConstraint:null,optional:!1},{name:"mediaType",type:{typeName:"Bodies.MimeType",nameSpace:"Bodies",basicName:"MimeType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},annotations:[{name:"MetaModel.oftenKeys",arguments:[["application/json","application/xml","application/x-www-form-urlencoded","multipart/formdata"]]
},{name:"MetaModel.description",arguments:["(Optional) The media types returned by API responses, and expected from API requests that accept a body, MAY be defaulted by specifying the mediaType property. This property is specified at the root level of the API definition. The property's value MAY be a single string with a valid media type described in the specification."]},{name:"MetaModel.inherited",arguments:[]}],valueConstraint:null,optional:!1},{name:"schemas",type:{base:{typeName:"GlobalSchema",nameSpace:"",basicName:"GlobalSchema",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.embeddedInMaps",arguments:[]},{name:"MetaModel.description",arguments:["To better achieve consistency and simplicity, the API definition SHOULD include an OPTIONAL schemas property in the root section. The schemas property specifies collections of schemas that could be used anywhere in the API definition. The value of the schemas property is an array of maps; in each map, the keys are the schema name, and the values are schema definitions. The schema definitions MAY be included inline or by using the RAML !include user-defined data type."]}],valueConstraint:null,optional:!1},{name:"traits",type:{base:{typeName:"Methods.Trait",nameSpace:"Methods",basicName:"Trait",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.embeddedInMaps",arguments:[]},{name:"MetaModel.description",arguments:["Declarations of traits used in this API"]}],valueConstraint:null,optional:!1},{name:"securedBy",type:{base:{typeName:"Security.SecuritySchemeRef",nameSpace:"Security",basicName:"SecuritySchemeRef",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.allowNull",arguments:[]},{name:"MetaModel.description",arguments:["A list of the security schemes to apply to all methods, these must be defined in the securitySchemes declaration."]}],valueConstraint:null,optional:!1},{name:"securitySchemes",type:{base:{typeName:"Security.AbstractSecurityScheme",nameSpace:"Security",basicName:"AbstractSecurityScheme",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.embeddedInMaps",arguments:[]},{name:"MetaModel.description",arguments:["Security schemes that can be applied using securedBy"]}],valueConstraint:null,optional:!1},{name:"resourceTypes",type:{base:{typeName:"Resources.ResourceType",nameSpace:"Resources",basicName:"ResourceType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.embeddedInMaps",arguments:[]},{name:"MetaModel.description",arguments:["Declaration of resource types used in this API"]}],valueConstraint:null,optional:!1},{name:"resources",type:{base:{typeName:"Resources.Resource",nameSpace:"Resources",basicName:"Resource",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.newInstanceName",arguments:["New Resource"]},{name:"MetaModel.description",arguments:["Resources are identified by their relative URI, which MUST begin with a slash (/). A resource defined as a root-level property is called a top-level resource. Its property's key is the resource's URI relative to the baseUri. A resource defined as a child property of another resource is called a nested resource, and its property's key is its URI relative to its parent resource's URI. Every property whose key begins with a slash (/), and is either at the root of the API definition or is the child property of a resource property, is a resource property. The key of a resource, i.e. its relative URI, MAY consist of multiple URI path fragments separated by slashes; e.g. `/bom/items` may indicate the collection of items in a bill of materials as a single resource. However, if the individual URI path fragments are themselves resources, the API definition SHOULD use nested resources to describe this structure; e.g. if `/bom` is itself a resource then `/items` should be a nested resource of `/bom`, while `/bom/items` should not be used."]}],valueConstraint:null,optional:!1},{name:"documentation",type:{base:{typeName:"DocumentationItem",nameSpace:"",basicName:"DocumentationItem",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.description",arguments:["The API definition can include a variety of documents that serve as a user guides and reference documentation for the API. Such documents can clarify how the API works or provide business context. Documentation-generators MUST include all the sections in an API definition's documentation property in the documentation output, and they MUST preserve the order in which the documentation is declared. To add user documentation to the API, include the documentation property at the root of the API definition. The documentation property MUST be an array of documents. Each document MUST contain title and content attributes, both of which are REQUIRED. If the documentation property is specified, it MUST include at least one document. Documentation-generators MUST process the content field as if it was defined using Markdown."]}],valueConstraint:null,optional:!1},{name:"RAMLVersion",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["Returns AST node of security scheme, this reference refers to, or null."]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[],moduleName:"RAMLSpec",annotationOverridings:{}},{name:"DocumentationItem",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"title",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["title of documentation section"]},{name:"MetaModel.required",arguments:[]}],valueConstraint:null,optional:!1},{name:"content",type:{typeName:"Sys.MarkdownString",nameSpace:"Sys",basicName:"MarkdownString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},annotations:[{name:"MetaModel.description",arguments:["Content of documentation section"]},{name:"MetaModel.required",arguments:[]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[{typeName:"RAMLSimpleElement",nameSpace:"",basicName:"RAMLSimpleElement",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"}],moduleName:"RAMLSpec",annotationOverridings:{}}],aliases:[],enumDeclarations:[],imports:{MetaModel:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/metamodel.ts",Sys:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts",Params:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/parameters.ts",Common:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/common.ts",Bodies:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts",Resources:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts",Methods:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts",Security:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"},name:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},{classes:[{name:"SpecPartMetaData",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!0,annotations:[],"extends":[],moduleName:null,annotationOverridings:{}}],aliases:[],enumDeclarations:[],imports:{},name:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/metamodel.ts"},{classes:[{name:"ValueType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[],"extends":[],moduleName:null,annotationOverridings:{}},{name:"StringType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["string"]}],"extends":[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"AnyType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["any"]}],"extends":[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"NumberType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["number"]}],"extends":[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"BooleanType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["boolean"]}],"extends":[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"Referencable",methods:[],typeParameters:["T"],typeParameterConstraint:[null],"implements":[],fields:[],isInterface:!0,annotations:[],"extends":[],moduleName:null,annotationOverridings:{}},{name:"Reference",methods:[],typeParameters:["T"],typeParameterConstraint:[null],"implements":[],fields:[{name:"structuredValue",type:{typeName:"TypeInstance",nameSpace:"",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["Returns a structured object if the reference point to one."]}],valueConstraint:null,optional:!1},{name:"name",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["Returns name of referenced object"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"DeclaresDynamicType",methods:[],typeParameters:["T"],typeParameterConstraint:[null],"implements":[],fields:[],isInterface:!0,annotations:[],"extends":[{typeName:"Referencable",nameSpace:"",basicName:"Referencable",typeKind:0,typeArguments:[{typeName:"T",nameSpace:"",basicName:"T",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"UriTemplate",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["This type currently serves both for absolute and relative urls"]}],"extends":[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"RelativeUriString",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["This  type describes relative uri templates"]}],"extends":[{typeName:"UriTemplate",nameSpace:"",basicName:"UriTemplate",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"FullUriTemplateString",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["This  type describes absolute uri templates"]}],"extends":[{typeName:"UriTemplate",nameSpace:"",basicName:"UriTemplate",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"FixedUri",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["This  type describes fixed uris"]}],"extends":[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"MarkdownString",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.innerType",arguments:["markdown"]},{name:"MetaModel.description",arguments:["Mardown string is a string which can contain markdown as an extension this markdown should support links with RAML Pointers since 1.0"]}],"extends":[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"SchemaString",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["Schema at this moment only two subtypes are supported (json schema and xsd)"]}],"extends":[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"JSonSchemaString",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.functionalDescriminator",arguments:["this.mediaType&&this.mediaType.isJSON()"]},{name:"MetaModel.description",arguments:["JSON schema"]}],"extends":[{typeName:"SchemaString",nameSpace:"",basicName:"SchemaString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"XMLSchemaString",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.innerType",arguments:["xml"]},{name:"MetaModel.description",arguments:["XSD schema"]}],"extends":[{typeName:"SchemaString",nameSpace:"",basicName:"SchemaString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"ExampleString",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[],"extends":[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"StatusCodeString",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[],"extends":[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"JSONExample",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.functionalDescriminator",arguments:["this.mediaType.isJSON()"]}],"extends":[{typeName:"ExampleString",nameSpace:"",basicName:"ExampleString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"XMLExample",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.functionalDescriminator",arguments:["this.mediaType.isXML()"]}],"extends":[{typeName:"ExampleString",nameSpace:"",basicName:"ExampleString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"TypeInstance",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"properties",type:{base:{typeName:"TypeInstanceProperty",nameSpace:"",basicName:"TypeInstanceProperty",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"},typeKind:1},annotations:[{name:"MetaModel.description",arguments:["Array of instance properties"]}],valueConstraint:null,optional:!1},{name:"isScalar",type:{typeName:"boolean",nameSpace:"",basicName:"boolean",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Whether the type is scalar"]}],valueConstraint:null,optional:!1},{name:"value",type:{typeName:"any",nameSpace:"",basicName:"any",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["For instances of scalar types returns scalar value"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.customHandling",arguments:[]}],"extends":[],moduleName:null,annotationOverridings:{}},{name:"TypeInstanceProperty",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"name",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Property name"]}],valueConstraint:null,optional:!1},{name:"value",type:{typeName:"TypeInstance",nameSpace:"",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"},annotations:[{name:"MetaModel.description",arguments:["Property value"]}],valueConstraint:null,optional:!1},{name:"values",type:{base:{typeName:"TypeInstance",nameSpace:"",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"},typeKind:1},annotations:[{name:"MetaModel.description",arguments:["Array of values if property value is array"]}],valueConstraint:null,optional:!1},{name:"isArray",type:{typeName:"boolean",nameSpace:"",basicName:"boolean",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Whether property has array as value"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.customHandling",arguments:[]}],"extends":[],moduleName:null,annotationOverridings:{}}],aliases:[],enumDeclarations:[],imports:{MetaModel:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/metamodel.ts",Common:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/common.ts"},name:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"},{classes:[{name:"RAMLSimpleElement",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[],"extends":[],moduleName:null,annotationOverridings:{}}],aliases:[],enumDeclarations:[],imports:{MetaModel:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/metamodel.ts",Sys:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"},name:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/common.ts"},{classes:[{name:"Parameter",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"name",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.key",arguments:[]},{name:"MetaModel.description",arguments:["name of the parameter"]},{name:"MetaModel.extraMetaKey",arguments:["headers"]}],valueConstraint:null,optional:!1},{name:"displayName",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["An alternate, human-friendly name for the parameter"]}],valueConstraint:null,optional:!1},{name:"type",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.defaultValue",arguments:["string"]},{name:"MetaModel.descriminatingProperty",arguments:[]},{name:"MetaModel.description",arguments:["The type attribute specifies the primitive type of the parameter's resolved value. API clients MUST return/throw an error if the parameter's resolved value does not match the specified type. If type is not specified, it defaults to string."]},{name:"MetaModel.canBeDuplicator",arguments:[]}],valueConstraint:null,optional:!1},{name:"location",type:{typeName:"ParameterLocation",nameSpace:"",basicName:"ParameterLocation",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/parameters.ts"},annotations:[{name:"MetaModel.system",arguments:[]},{name:"MetaModel.description",arguments:["Location of the parameter (can not be edited by user)"]}],valueConstraint:null,optional:!1},{name:"required",type:{typeName:"boolean",nameSpace:"",basicName:"boolean",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Set to true if parameter is required"]},{name:"MetaModel.defaultBooleanValue",arguments:[!0]}],valueConstraint:null,optional:!1},{name:"default",type:{typeName:"any",nameSpace:"",basicName:"any",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["The default attribute specifies the default value to use for the property if the property is omitted or its value is not specified. This SHOULD NOT be interpreted as a requirement for the client to send the default attribute's value if there is no other value to send. Instead, the default attribute's value is the value the server uses if the client does not send a value."]}],valueConstraint:null,optional:!1},{name:"example",type:{typeName:"any",nameSpace:"",basicName:"any",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["(Optional) The example attribute shows an example value for the property. This can be used, e.g., by documentation generators to generate sample values for the property."]}],valueConstraint:null,optional:!1},{name:"repeat",type:{typeName:"boolean",nameSpace:"",basicName:"boolean",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["The repeat attribute specifies that the parameter can be repeated. If the parameter can be used multiple times, the repeat parameter value MUST be set to 'true'. Otherwise, the default value is 'false' and the parameter may not be repeated."]},{name:"MetaModel.defaultBooleanValue",arguments:[!1]}],valueConstraint:null,optional:!1},{name:"description",type:{typeName:"Sys.MarkdownString",nameSpace:"Sys",basicName:"MarkdownString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/parameters.ts"},annotations:[{name:"MetaModel.description",arguments:["The description attribute describes the intended use or meaning of the $self. This value MAY be formatted using Markdown."]}],valueConstraint:null,optional:!1},{name:"parametrizedProperties",type:{typeName:"Sys.TypeInstance",nameSpace:"Sys",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/parameters.ts"},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["For parameters defined inside traits and resource types returns object representation of parametrized properties"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[],moduleName:null,annotationOverridings:{}},{name:"StringTypeDeclaration",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"type",type:null,annotations:[],valueConstraint:{isCallConstraint:!1,value:"string"},optional:!1},{name:"pattern",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["(Optional, applicable only for parameters of type string) The pattern attribute is a regular expression that a parameter of type string MUST match. Regular expressions MUST follow the regular expression specification from ECMA 262/Perl 5. The pattern MAY be enclosed in double quotes for readability and clarity."]}],valueConstraint:null,optional:!1},{name:"enum",type:{base:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},typeKind:1},annotations:[{name:"MetaModel.description",arguments:["(Optional, applicable only for parameters of type string) The enum attribute provides an enumeration of the parameter's valid values. This MUST be an array. If the enum attribute is defined, API clients and servers MUST verify that a parameter's value matches a value in the enum array. If there is no matching value, the clients and servers MUST treat this as an error."]}],valueConstraint:null,optional:!1},{name:"minLength",type:{typeName:"number",nameSpace:"",basicName:"number",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["(Optional, applicable only for parameters of type string) The minLength attribute specifies the parameter value's minimum number of characters."]}],valueConstraint:null,optional:!1},{name:"maxLength",type:{typeName:"number",nameSpace:"",basicName:"number",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["(Optional, applicable only for parameters of type string) The maxLength attribute specifies the parameter value's maximum number of characters."]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["Value must be a string"]}],"extends":[{typeName:"Parameter",nameSpace:"",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/parameters.ts"}],moduleName:null,annotationOverridings:{}},{name:"BooleanTypeDeclaration",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"type",type:null,annotations:[],valueConstraint:{isCallConstraint:!1,value:"boolean"},optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["Value must be a boolean"]}],"extends":[{typeName:"Parameter",nameSpace:"",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/parameters.ts"}],moduleName:null,annotationOverridings:{}},{name:"NumberTypeDeclaration",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"type",type:null,annotations:[],valueConstraint:{isCallConstraint:!1,value:"number"},optional:!1},{name:"minimum",type:{typeName:"number",nameSpace:"",basicName:"number",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["(Optional, applicable only for parameters of type number or integer) The minimum attribute specifies the parameter's minimum value."]}],valueConstraint:null,optional:!1},{name:"maximum",type:{typeName:"number",nameSpace:"",basicName:"number",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["(Optional, applicable only for parameters of type number or integer) The maximum attribute specifies the parameter's maximum value."]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["Value MUST be a number. Indicate floating point numbers as defined by YAML."]}],"extends":[{typeName:"Parameter",nameSpace:"",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/parameters.ts"}],moduleName:null,annotationOverridings:{}},{name:"IntegerTypeDeclaration",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"type",type:null,annotations:[],valueConstraint:{isCallConstraint:!1,value:"integer"},optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["Value MUST be a integer."]}],"extends":[{typeName:"NumberTypeDeclaration",nameSpace:"",basicName:"NumberTypeDeclaration",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/parameters.ts"}],moduleName:null,annotationOverridings:{}},{name:"DateTypeDeclaration",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"type",type:null,annotations:[],valueConstraint:{isCallConstraint:!1,value:"date"},optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["Value MUST be a string representation of a date as defined in RFC2616 Section 3.3. "]}],"extends":[{typeName:"Parameter",nameSpace:"",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/parameters.ts"}],moduleName:null,annotationOverridings:{}},{name:"FileTypeDeclaration",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"type",type:null,annotations:[],
valueConstraint:{isCallConstraint:!1,value:"file"},optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.requireValue",arguments:["location","ParameterLocation.FORM"]},{name:"MetaModel.description",arguments:["(Applicable only to Form properties) Value is a file. Client generators SHOULD use this type to handle file uploads correctly."]}],"extends":[{typeName:"Parameter",nameSpace:"",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/parameters.ts"}],moduleName:null,annotationOverridings:{}}],aliases:[],enumDeclarations:[{name:"ParameterLocation",members:["QUERY","HEADERS","URI","FORM","BURI"]}],imports:{MetaModel:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/metamodel.ts",Sys:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts",Common:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/common.ts"},name:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/parameters.ts"},{classes:[{name:"MimeType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["This sub type of the string represents mime types"]}],"extends":[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts"}],moduleName:null,annotationOverridings:{}},{name:"BodyLike",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"name",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.key",arguments:[]},{name:"MetaModel.description",arguments:["Mime type of the request or response body"]},{name:"MetaModel.canInherit",arguments:["mediaType"]},{name:"MetaModel.oftenKeys",arguments:[["application/json","application/xml","application/x-www-form-urlencoded","multipart/form-data"]]}],valueConstraint:null,optional:!1},{name:"schema",type:{typeName:"Sys.SchemaString",nameSpace:"Sys",basicName:"SchemaString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts"},annotations:[{name:"MetaModel.requireValue",arguments:["this.name.isForm()","false"]},{name:"MetaModel.description",arguments:["The structure of a request or response body MAY be further specified by the schema property under the appropriate media type. The schema key CANNOT be specified if a body's media type is application/x-www-form-urlencoded or multipart/form-data. All parsers of RAML MUST be able to interpret JSON Schema and XML Schema. Schema MAY be declared inline or in an external file. However, if the schema is sufficiently large so as to make it difficult for a person to read the API definition, or the schema is reused across multiple APIs or across multiple miles in the same API, the !include user-defined data type SHOULD be used instead of including the content inline. Alternatively, the value of the schema field MAY be the name of a schema specified in the root-level schemas property, or it MAY be declared in an external file and included by using the by using the RAML !include user-defined data type."]}],valueConstraint:null,optional:!1},{name:"example",type:{typeName:"Sys.ExampleString",nameSpace:"Sys",basicName:"ExampleString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts"},annotations:[{name:"MetaModel.description",arguments:["Documentation generators MUST use body properties' example attributes to generate example invocations."]}],valueConstraint:null,optional:!1},{name:"formParameters",type:{base:{typeName:"Params.Parameter",nameSpace:"Params",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts"},typeKind:1},annotations:[{name:"MetaModel.setsContextValue",arguments:["location","Params.ParameterLocation.FORM"]},{name:"MetaModel.description",arguments:["Web forms REQUIRE special encoding and custom declaration. If the API's media type is either application/x-www-form-urlencoded or multipart/form-data, the formParameters property MUST specify the name-value pairs that the API is expecting. The formParameters property is a map in which the key is the name of the web form parameter, and the value is itself a map the specifies the web form parameter's attributes."]}],valueConstraint:null,optional:!1},{name:"schemaContent",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["Returns schema content for the cases when schema is inlined, when schema is included, and when schema is a reference."]}],valueConstraint:null,optional:!1},{name:"description",type:{typeName:"Sys.MarkdownString",nameSpace:"Sys",basicName:"MarkdownString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts"},annotations:[{name:"MetaModel.description",arguments:["Human readable description of the body"]}],valueConstraint:null,optional:!1},{name:"parametrizedProperties",type:{typeName:"Sys.TypeInstance",nameSpace:"Sys",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts"},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["For bodies defined inside traits and resource types returns object representation of parametrized properties"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.canInherit",arguments:["mediaType"]}],"extends":[],moduleName:null,annotationOverridings:{}},{name:"XMLBody",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"schema",type:{typeName:"Sys.XMLSchemaString",nameSpace:"Sys",basicName:"XMLSchemaString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts"},annotations:[{name:"MetaModel.description",arguments:["XSD Schema"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.functionalDescriminator",arguments:["this.mime.isXML()"]},{name:"MetaModel.description",arguments:["Needed to set connection between xml related mime types and xsd schema"]}],"extends":[{typeName:"BodyLike",nameSpace:"",basicName:"BodyLike",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts"}],moduleName:null,annotationOverridings:{}},{name:"JSONBody",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"schema",type:{typeName:"Sys.JSonSchemaString",nameSpace:"Sys",basicName:"JSonSchemaString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts"},annotations:[{name:"MetaModel.description",arguments:["JSON Schema"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.functionalDescriminator",arguments:["this.mime.isJSON()"]},{name:"MetaModel.description",arguments:["Needed to set connection between json related mime types and json schema"]}],"extends":[{typeName:"BodyLike",nameSpace:"",basicName:"BodyLike",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts"}],moduleName:null,annotationOverridings:{}},{name:"Response",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"code",type:{typeName:"Sys.StatusCodeString",nameSpace:"Sys",basicName:"StatusCodeString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts"},annotations:[{name:"MetaModel.key",arguments:[]},{name:"MetaModel.extraMetaKey",arguments:["statusCodes"]},{name:"MetaModel.description",arguments:["Responses MUST be a map of one or more HTTP status codes, where each status code itself is a map that describes that status code."]}],valueConstraint:null,optional:!1},{name:"headers",type:{base:{typeName:"Params.Parameter",nameSpace:"Params",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts"},typeKind:1},annotations:[{name:"MetaModel.setsContextValue",arguments:["location","Params.ParameterLocation.HEADERS"]},{name:"MetaModel.newInstanceName",arguments:["New Header"]},{name:"MetaModel.description",arguments:["An API's methods may support custom header values in responses. The custom, non-standard HTTP headers MUST be specified by the headers property. API's may include the the placeholder token {?} in a header name to indicate that any number of headers that conform to the specified format can be sent in responses. This is particularly useful for APIs that allow HTTP headers that conform to some naming convention to send arbitrary, custom data."]}],valueConstraint:null,optional:!1},{name:"body",type:{base:{typeName:"BodyLike",nameSpace:"",basicName:"BodyLike",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts"},typeKind:1},annotations:[{name:"MetaModel.newInstanceName",arguments:["New Body"]},{name:"MetaModel.description",arguments:["Each response MAY contain a body property, which conforms to the same structure as request body properties (see Body). Responses that can return more than one response code MAY therefore have multiple bodies defined. For APIs without a priori knowledge of the response types for their responses, `*/*` MAY be used to indicate that responses that do not matching other defined data types MUST be accepted. Processing applications MUST match the most descriptive media type first if `*/*` is used."]}],valueConstraint:null,optional:!1},{name:"description",type:{typeName:"Sys.MarkdownString",nameSpace:"Sys",basicName:"MarkdownString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts"},annotations:[{name:"MetaModel.description",arguments:["The description attribute describes the intended use or meaning of the $self. This value MAY be formatted using Markdown."]}],valueConstraint:null,optional:!1},{name:"parametrizedProperties",type:{typeName:"Sys.TypeInstance",nameSpace:"Sys",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts"},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["For responses defined inside traits and resource types returns object representation of parametrized properties"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[],moduleName:null,annotationOverridings:{}}],aliases:[],enumDeclarations:[],imports:{MetaModel:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/metamodel.ts",Sys:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts",Params:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/parameters.ts",Common:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/common.ts"},name:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts"},{classes:[{name:"Resource",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"relativeUri",type:{typeName:"Sys.RelativeUriString",nameSpace:"Sys",basicName:"RelativeUriString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},annotations:[{name:"MetaModel.key",arguments:[]},{name:"MetaModel.startFrom",arguments:["/"]},{name:"MetaModel.description",arguments:["Relative URL of this resource from the parent resource"]}],valueConstraint:null,optional:!1},{name:"type",type:{typeName:"ResourceTypeRef",nameSpace:"",basicName:"ResourceTypeRef",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},annotations:[{name:"MetaModel.description",arguments:["Instantiation of applyed resource type"]}],valueConstraint:null,optional:!1},{name:"is",type:{base:{typeName:"TraitRef",nameSpace:"",basicName:"TraitRef",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},typeKind:1},annotations:[{name:"MetaModel.description",arguments:["Instantiation of applyed traits"]}],valueConstraint:null,optional:!1},{name:"securedBy",type:{base:{typeName:"SecuritySchemeRef",nameSpace:"",basicName:"SecuritySchemeRef",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},typeKind:1},annotations:[{name:"MetaModel.allowNull",arguments:[]},{name:"MetaModel.description",arguments:["securityScheme may also be applied to a resource by using the securedBy key, which is equivalent to applying the securityScheme to all methods that may be declared, explicitly or implicitly, by defining the resourceTypes or traits property for that resource. To indicate that the method may be called without applying any securityScheme, the method may be annotated with the null securityScheme."]}],valueConstraint:null,optional:!1},{name:"uriParameters",type:{base:{typeName:"Params.Parameter",nameSpace:"Params",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},typeKind:1},annotations:[{name:"MetaModel.setsContextValue",arguments:["fieldOrParam",!0]},{name:"MetaModel.setsContextValue",arguments:["location","Params.ParameterLocation.URI"]},{name:"MetaModel.description",arguments:["Uri parameters of this resource"]}],valueConstraint:null,optional:!1},{name:"methods",type:{base:{typeName:"Methods.Method",nameSpace:"Methods",basicName:"Method",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},typeKind:1},annotations:[{name:"MetaModel.newInstanceName",arguments:["New Method"]},{name:"MetaModel.description",arguments:["Methods that can be called on this resource"]}],valueConstraint:null,optional:!1},{name:"resources",type:{base:{typeName:"Resource",nameSpace:"",basicName:"Resource",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},typeKind:1},annotations:[{name:"MetaModel.newInstanceName",arguments:["New Resource"]},{name:"MetaModel.description",arguments:["Children resources"]}],valueConstraint:null,optional:!1},{name:"displayName",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["An alternate, human-friendly name for the resource"]}],valueConstraint:null,optional:!1},{name:"baseUriParameters",type:{base:{typeName:"Params.Parameter",nameSpace:"Params",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},typeKind:1},annotations:[{name:"MetaModel.setsContextValue",arguments:["fieldOrParam",!0]},{name:"MetaModel.setsContextValue",arguments:["location","Params.ParameterLocation.BURI"]},{name:"MetaModel.description",arguments:["A resource or a method can override a base URI template's values. This is useful to restrict or change the default or parameter selection in the base URI. The baseUriParameters property MAY be used to override any or all parameters defined at the root level baseUriParameters property, as well as base URI parameters not specified at the root level."]}],valueConstraint:null,optional:!1},{name:"description",type:{typeName:"Sys.MarkdownString",nameSpace:"Sys",basicName:"MarkdownString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},annotations:[{name:"MetaModel.description",arguments:["The description attribute describes the intended use or meaning of the $self. This value MAY be formatted using Markdown."]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[],moduleName:null,annotationOverridings:{}},{name:"ResourceTypeRef",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"resourceType",type:{typeName:"ResourceType",nameSpace:"",basicName:"ResourceType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["Returns referenced resource type"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[{typeName:"Reference",nameSpace:"",basicName:"Reference",typeKind:0,typeArguments:[{typeName:"ResourceType",nameSpace:"",basicName:"ResourceType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"}],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"}],moduleName:null,annotationOverridings:{}},{name:"ResourceType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[{typeName:"DeclaresDynamicType",nameSpace:"",basicName:"DeclaresDynamicType",typeKind:0,typeArguments:[{typeName:"ResourceType",nameSpace:"",basicName:"ResourceType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"}],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"}],fields:[{name:"name",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.key",arguments:[]},{name:"MetaModel.description",arguments:["Name of the resource type"]}],valueConstraint:null,optional:!1},{name:"usage",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Instructions on how and when the resource type should be used."]}],valueConstraint:null,optional:!1},{name:"methods",type:{base:{typeName:"Methods.Method",nameSpace:"Methods",basicName:"Method",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},typeKind:1},annotations:[{name:"MetaModel.description",arguments:["Methods that are part of this resource type definition"]}],valueConstraint:null,optional:!1},{name:"is",type:{base:{typeName:"Security.TraitRef",nameSpace:"Security",basicName:"TraitRef",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},typeKind:1},annotations:[{name:"MetaModel.description",arguments:["Instantiation of applyed traits"]}],valueConstraint:null,optional:!1},{name:"type",type:{typeName:"ResourceTypeRef",nameSpace:"",basicName:"ResourceTypeRef",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},annotations:[{name:"MetaModel.description",arguments:["Instantiation of applyed resource type"]}],valueConstraint:null,optional:!1},{name:"securedBy",type:{base:{typeName:"Security.SecuritySchemeRef",nameSpace:"Security",basicName:"SecuritySchemeRef",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},typeKind:1},annotations:[{name:"MetaModel.allowNull",arguments:[]},{name:"MetaModel.description",arguments:["securityScheme may also be applied to a resource by using the securedBy key, which is equivalent to applying the securityScheme to all methods that may be declared, explicitly or implicitly, by defining the resourceTypes or traits property for that resource. To indicate that the method may be called without applying any securityScheme, the method may be annotated with the null securityScheme."]}],valueConstraint:null,optional:!1},{name:"uriParameters",type:{base:{typeName:"Params.Parameter",nameSpace:"Params",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},typeKind:1},annotations:[{name:"MetaModel.setsContextValue",arguments:["location","Params.ParameterLocation.URI"]},{name:"MetaModel.description",arguments:["Uri parameters of this resource"]}],valueConstraint:null,optional:!1},{name:"displayName",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["An alternate, human-friendly name for the resource type"]}],valueConstraint:null,optional:!1},{name:"baseUriParameters",type:{base:{typeName:"Params.Parameter",nameSpace:"Params",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},typeKind:1},annotations:[{name:"MetaModel.setsContextValue",arguments:["fieldOrParam",!0]},{name:"MetaModel.setsContextValue",arguments:["location","Params.ParameterLocation.BURI"]},{name:"MetaModel.description",arguments:["A resource or a method can override a base URI template's values. This is useful to restrict or change the default or parameter selection in the base URI. The baseUriParameters property MAY be used to override any or all parameters defined at the root level baseUriParameters property, as well as base URI parameters not specified at the root level."]}],valueConstraint:null,optional:!1},{name:"parametrizedProperties",type:{typeName:"Sys.TypeInstance",nameSpace:"Sys",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["Returns object representation of parametrized properties of the resource type"]}],valueConstraint:null,optional:!1},{name:"description",type:{typeName:"Sys.MarkdownString",nameSpace:"Sys",basicName:"MarkdownString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},annotations:[{name:"MetaModel.description",arguments:["The description attribute describes the intended use or meaning of the $self. This value MAY be formatted using Markdown."]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.inlinedTemplates",arguments:[]},{name:"MetaModel.allowQuestion",arguments:[]}],"extends":[],moduleName:null,annotationOverridings:{}}],aliases:[],enumDeclarations:[],imports:{MetaModel:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/metamodel.ts",Sys:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts",Params:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/parameters.ts",Bodies:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts",Common:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/common.ts",Methods:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts",Security:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"},name:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts"},{classes:[{name:"MethodBase",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"responses",type:{base:{typeName:"Bodies.Response",nameSpace:"Bodies",basicName:"Response",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"},typeKind:1},annotations:[{name:"MetaModel.newInstanceName",arguments:["New Response"]},{name:"MetaModel.description",arguments:["Resource methods MAY have one or more responses. Responses MAY be described using the description property, and MAY include example attributes or schema properties."]}],valueConstraint:null,optional:!1},{name:"body",type:{base:{typeName:"Bodies.BodyLike",nameSpace:"Bodies",basicName:"BodyLike",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"},typeKind:1},annotations:[{name:"MetaModel.newInstanceName",arguments:["New Body"]},{name:"MetaModel.description",arguments:["Some method verbs expect the resource to be sent as a request body. For example, to create a resource, the request must include the details of the resource to create. Resources CAN have alternate representations. For example, an API might support both JSON and XML representations. A method's body is defined in the body property as a hashmap, in which the key MUST be a valid media type."]}],valueConstraint:null,optional:!1},{name:"protocols",type:{base:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},typeKind:1},annotations:[{name:"MetaModel.oneOf",arguments:[["HTTP","HTTPS"]]},{name:"MetaModel.description",arguments:["A method can override an API's protocols value for that single method by setting a different value for the fields."]}],valueConstraint:null,optional:!1},{name:"securedBy",type:{base:{typeName:"SecuritySchemeRef",nameSpace:"",basicName:"SecuritySchemeRef",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"},typeKind:1},annotations:[{name:"MetaModel.allowNull",arguments:[]},{name:"MetaModel.description",arguments:["A list of the security schemas to apply, these must be defined in the securitySchemes declaration. To indicate that the method may be called without applying any securityScheme, the method may be annotated with the null securityScheme. Security schemas may also be applied to a resource with securedBy, which is equivalent to applying the security schemas to all methods that may be declared, explicitly or implicitly, by defining the resourceTypes or traits property for that resource."]}],valueConstraint:null,optional:!1},{name:"baseUriParameters",type:{base:{typeName:"Params.Parameter",nameSpace:"Params",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"},typeKind:1},annotations:[{name:"MetaModel.setsContextValue",arguments:["fieldOrParam",!0]},{name:"MetaModel.setsContextValue",arguments:["location","Params.ParameterLocation.BURI"]},{name:"MetaModel.description",arguments:["A resource or a method can override a base URI template's values. This is useful to restrict or change the default or parameter selection in the base URI. The baseUriParameters property MAY be used to override any or all parameters defined at the root level baseUriParameters property, as well as base URI parameters not specified at the root level."]}],valueConstraint:null,optional:!1},{name:"queryParameters",type:{base:{typeName:"Params.Parameter",nameSpace:"Params",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"},typeKind:1},annotations:[{name:"MetaModel.setsContextValue",arguments:["location","ParameterLocation.QUERY"]},{name:"MetaModel.newInstanceName",arguments:["New query parameter"]},{name:"MetaModel.description",arguments:["An APIs resources MAY be filtered (to return a subset of results) or altered (such as transforming a response body from JSON to XML format) by the use of query strings. If the resource or its method supports a query string, the query string MUST be defined by the queryParameters property"]}],valueConstraint:null,optional:!1},{name:"headers",type:{base:{typeName:"Params.Parameter",nameSpace:"Params",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"},typeKind:1},annotations:[{name:"MetaModel.setsContextValue",arguments:["location","ParameterLocation.HEADERS"]},{name:"MetaModel.description",arguments:["Headers that allowed at this position"]},{name:"MetaModel.newInstanceName",arguments:["New Header"]}],valueConstraint:null,optional:!1},{name:"description",type:{typeName:"Sys.MarkdownString",nameSpace:"Sys",basicName:"MarkdownString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"},annotations:[],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["Method object allows description of http methods"]}],"extends":[],moduleName:null,annotationOverridings:{}},{name:"Method",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"method",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.key",arguments:[]},{name:"MetaModel.extraMetaKey",arguments:["methods"]},{name:"MetaModel.oneOf",arguments:[["get","put","post","delete","patch","options","head","trace","connect"]]},{name:"MetaModel.description",arguments:["Method that can be called"]}],valueConstraint:null,optional:!1},{name:"is",type:{base:{typeName:"TraitRef",nameSpace:"",basicName:"TraitRef",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"},typeKind:1},annotations:[{name:"MetaModel.description",arguments:["Instantiation of applyed traits"]}],valueConstraint:null,optional:!1},{name:"parametrizedProperties",type:{typeName:"Sys.TypeInstance",nameSpace:"Sys",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["For methods defined inside resource types returns object representation of parametrized properties"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[{typeName:"MethodBase",nameSpace:"",basicName:"MethodBase",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"}],moduleName:null,annotationOverridings:{}},{name:"Trait",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[{typeName:"DeclaresDynamicType",
nameSpace:"",basicName:"DeclaresDynamicType",typeKind:0,typeArguments:[{typeName:"Trait",nameSpace:"",basicName:"Trait",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"}],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"}],fields:[{name:"name",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.key",arguments:[]},{name:"MetaModel.description",arguments:["Name of the trait"]}],valueConstraint:null,optional:!1},{name:"usage",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Instructions on how and when the trait should be used."]}],valueConstraint:null,optional:!1},{name:"parametrizedProperties",type:{typeName:"Sys.TypeInstance",nameSpace:"Sys",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["Returns object representation of parametrized properties of the trait"]}],valueConstraint:null,optional:!1},{name:"displayName",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["An alternate, human-friendly name for the trait"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.inlinedTemplates",arguments:[]},{name:"MetaModel.allowQuestion",arguments:[]}],"extends":[{typeName:"MethodBase",nameSpace:"",basicName:"MethodBase",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"}],moduleName:null,annotationOverridings:{}},{name:"TraitRef",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"trait",type:{typeName:"Trait",nameSpace:"",basicName:"Trait",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["Returns referenced trait"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[{typeName:"Reference",nameSpace:"",basicName:"Reference",typeKind:0,typeArguments:[{typeName:"Trait",nameSpace:"",basicName:"Trait",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"}],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"}],moduleName:null,annotationOverridings:{}}],aliases:[],enumDeclarations:[],imports:{MetaModel:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/metamodel.ts",Sys:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts",Params:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/parameters.ts",Bodies:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts",Common:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/common.ts",Security:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"},name:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"},{classes:[{name:"SecuritySchemePart",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"displayName",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["An alternate, human-friendly name for the security scheme part"]}],valueConstraint:null,optional:!1},{name:"is",type:{base:{typeName:"TraitRef",nameSpace:"",basicName:"TraitRef",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"},typeKind:1},annotations:[{name:"MetaModel.description",arguments:["Instantiation of applyed traits"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[{typeName:"MethodBase",nameSpace:"",basicName:"MethodBase",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"}],moduleName:null,annotationOverridings:{headers:[{name:"MetaModel.markdownDescription",arguments:["Optional array of headers, documenting the possible headers that could be accepted."]},{name:"MetaModel.valueDescription",arguments:["Object whose property names are the request header names and whose values describe the values."]}],queryParameters:[{name:"MetaModel.markdownDescription",arguments:["Query parameters, used by the schema in order to authorize the request. Mutually exclusive with queryString."]},{name:"MetaModel.valueDescription",arguments:["Object whose property names are the query parameter names and whose values describe the values."]}],queryString:[{name:"MetaModel.description",arguments:["Specifies the query string, used by the schema in order to authorize the request. Mutually exclusive with queryParameters."]},{name:"MetaModel.valueDescription",arguments:["Type name or type declaration"]}],responses:[{name:"MetaModel.description",arguments:["Optional array of responses, describing the possible responses that could be sent."]}],description:[{name:"MetaModel.description",arguments:["A longer, human-friendly description of the security scheme part"]},{name:"MetaModel.valueDescription",arguments:["Markdown string"]}]}},{name:"SecuritySchemeSettings",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.allowAny",arguments:[]}],"extends":[],moduleName:null,annotationOverridings:{}},{name:"AbstractSecurityScheme",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[{typeName:"Referencable",nameSpace:"",basicName:"Referencable",typeKind:0,typeArguments:[{typeName:"AbstractSecurityScheme",nameSpace:"",basicName:"AbstractSecurityScheme",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"}],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"}],fields:[{name:"name",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.key",arguments:[]},{name:"MetaModel.startFrom",arguments:[""]},{name:"MetaModel.hide",arguments:[]},{name:"MetaModel.description",arguments:["Name of the security scheme"]}],valueConstraint:null,optional:!1},{name:"type",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.required",arguments:[]},{name:"MetaModel.oneOf",arguments:[["OAuth 1.0","OAuth 2.0","Basic Authentication","DigestSecurityScheme Authentication","x-{other}"]]},{name:"MetaModel.descriminatingProperty",arguments:[]},{name:"MetaModel.description",arguments:["The securitySchemes property MUST be used to specify an API's security mechanisms, including the required settings and the authentication methods that the API supports. one authentication method is allowed if the API supports them."]},{name:"MetaModel.valueDescription",arguments:["string<br><br>The value MUST be one of<br>* OAuth 1.0,<br>* OAuth 2.0, <br>* BasicSecurityScheme Authentication<br>* DigestSecurityScheme Authentication<br>* x-&lt;other&gt;"]}],valueConstraint:null,optional:!1},{name:"description",type:{typeName:"Sys.MarkdownString",nameSpace:"Sys",basicName:"MarkdownString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"},annotations:[{name:"MetaModel.description",arguments:["The description attribute MAY be used to describe a security schemes property."]}],valueConstraint:null,optional:!1},{name:"describedBy",type:{typeName:"SecuritySchemePart",nameSpace:"",basicName:"SecuritySchemePart",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"},annotations:[{name:"MetaModel.description",arguments:["A description of the request components related to Security that are determined by the scheme: the headers, query parameters or responses. As a best practice, even for standard security schemes, API designers SHOULD describe these properties of security schemes. Including the security scheme description completes an API documentation."]}],valueConstraint:null,optional:!1},{name:"settings",type:{typeName:"SecuritySchemeSettings",nameSpace:"",basicName:"SecuritySchemeSettings",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"},annotations:[{name:"MetaModel.description",arguments:["The settings attribute MAY be used to provide security scheme-specific information. The required attributes vary depending on the type of security scheme is being declared. It describes the minimum set of properties which any processing application MUST provide and validate if it chooses to implement the security scheme. Processing applications MAY choose to recognize other properties for things such as token lifetime, preferred cryptographic algorithms, and more."]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["Declares globally referable security schema definition"]},{name:"MetaModel.actuallyExports",arguments:["$self"]},{name:"MetaModel.referenceIs",arguments:["settings"]}],"extends":[],moduleName:null,annotationOverridings:{}},{name:"SecuritySchemeRef",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"securitySchemeName",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["Returns the name of security scheme, this reference refers to."]}],valueConstraint:null,optional:!1},{name:"securityScheme",type:{typeName:"AbstractSecurityScheme",nameSpace:"",basicName:"AbstractSecurityScheme",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["Returns AST node of security scheme, this reference refers to, or null."]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.allowAny",arguments:[]}],"extends":[{typeName:"Reference",nameSpace:"",basicName:"Reference",typeKind:0,typeArguments:[{typeName:"AbstractSecurityScheme",nameSpace:"",basicName:"AbstractSecurityScheme",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"}],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"}],moduleName:null,annotationOverridings:{}},{name:"OAuth1SecuritySchemeSettings",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"requestTokenUri",type:{typeName:"Sys.FixedUri",nameSpace:"Sys",basicName:"FixedUri",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"},annotations:[{name:"MetaModel.required",arguments:[]},{name:"MetaModel.description",arguments:["The URI of the Temporary Credential Request endpoint as defined in RFC5849 Section 2.1"]},{name:"MetaModel.valueDescription",arguments:["FixedUriString"]}],valueConstraint:null,optional:!1},{name:"authorizationUri",type:{typeName:"Sys.FixedUri",nameSpace:"Sys",basicName:"FixedUri",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"},annotations:[{name:"MetaModel.required",arguments:[]},{name:"MetaModel.description",arguments:["The URI of the Resource Owner Authorization endpoint as defined in RFC5849 Section 2.2"]},{name:"MetaModel.valueDescription",arguments:["FixedUriString"]}],valueConstraint:null,optional:!1},{name:"tokenCredentialsUri",type:{typeName:"Sys.FixedUri",nameSpace:"Sys",basicName:"FixedUri",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"},annotations:[{name:"MetaModel.required",arguments:[]},{name:"MetaModel.description",arguments:["The URI of the Token Request endpoint as defined in RFC5849 Section 2.3"]},{name:"MetaModel.valueDescription",arguments:["FixedUriString"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.allowAny",arguments:[]},{name:"MetaModel.functionalDescriminator",arguments:["$parent.type=='OAuth 1.0'"]}],"extends":[{typeName:"SecuritySchemeSettings",nameSpace:"",basicName:"SecuritySchemeSettings",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"}],moduleName:null,annotationOverridings:{}},{name:"OAuth2SecuritySchemeSettings",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"accessTokenUri",type:{typeName:"Sys.FixedUri",nameSpace:"Sys",basicName:"FixedUri",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"},annotations:[{name:"MetaModel.required",arguments:[]},{name:"MetaModel.description",arguments:["The URI of the Token Endpoint as defined in RFC6749 Section 3.2. Not required forby implicit grant type."]},{name:"MetaModel.valueDescription",arguments:["FixedUriString"]}],valueConstraint:null,optional:!1},{name:"authorizationUri",type:{typeName:"Sys.FixedUri",nameSpace:"Sys",basicName:"FixedUri",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"},annotations:[{name:"MetaModel.required",arguments:[]},{name:"MetaModel.description",arguments:["The URI of the Authorization Endpoint as defined in RFC6749 Section 3.1. Required forby authorization_code and implicit grant types."]},{name:"MetaModel.valueDescription",arguments:["FixedUriString"]}],valueConstraint:null,optional:!1},{name:"authorizationGrants",type:{base:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},typeKind:1},annotations:[{name:"MetaModel.description",arguments:["A list of the Authorization grants supported by the API as defined in RFC6749 Sections 4.1, 4.2, 4.3 and 4.4, can be any of: authorization_code, password, client_credentials, implicit, or refresh_token."]},{name:"MetaModel.markdownDescription",arguments:["A list of the Authorization grants supported by the API as defined in RFC6749 Sections 4.1, 4.2, 4.3 and 4.4, can be any of:<br>* authorization_code<br>* password<br>* client_credentials <br>* implicit<br>* refresh_token."]}],valueConstraint:null,optional:!1},{name:"scopes",type:{base:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},typeKind:1},annotations:[{name:"MetaModel.description",arguments:["A list of scopes supported by the security scheme as defined in RFC6749 Section 3.3"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.allowAny",arguments:[]}],"extends":[{typeName:"SecuritySchemeSettings",nameSpace:"",basicName:"SecuritySchemeSettings",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"}],moduleName:null,annotationOverridings:{}},{name:"OAuth2SecurityScheme",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"type",type:null,annotations:[],valueConstraint:{isCallConstraint:!1,value:"OAuth 2.0"},optional:!1},{name:"settings",type:{typeName:"OAuth2SecuritySchemeSettings",nameSpace:"",basicName:"OAuth2SecuritySchemeSettings",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"},annotations:[],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["Declares globally referable security schema definition"]},{name:"MetaModel.actuallyExports",arguments:["$self"]},{name:"MetaModel.referenceIs",arguments:["settings"]}],"extends":[{typeName:"AbstractSecurityScheme",nameSpace:"",basicName:"AbstractSecurityScheme",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"}],moduleName:null,annotationOverridings:{}},{name:"OAuth1SecurityScheme",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"type",type:null,annotations:[],valueConstraint:{isCallConstraint:!1,value:"OAuth 1.0"},optional:!1},{name:"settings",type:{typeName:"OAuth1SecuritySchemeSettings",nameSpace:"",basicName:"OAuth1SecuritySchemeSettings",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"},annotations:[],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["Declares globally referable security schema definition"]},{name:"MetaModel.actuallyExports",arguments:["$self"]},{name:"MetaModel.referenceIs",arguments:["settings"]}],"extends":[{typeName:"AbstractSecurityScheme",nameSpace:"",basicName:"AbstractSecurityScheme",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"}],moduleName:null,annotationOverridings:{}},{name:"BasicSecurityScheme",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"type",type:null,annotations:[],valueConstraint:{isCallConstraint:!1,value:"Basic Authentication"},optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["Declares globally referable security schema definition"]},{name:"MetaModel.actuallyExports",arguments:["$self"]},{name:"MetaModel.referenceIs",arguments:["settings"]}],"extends":[{typeName:"AbstractSecurityScheme",nameSpace:"",basicName:"AbstractSecurityScheme",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"}],moduleName:null,annotationOverridings:{}},{name:"DigestSecurityScheme",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"type",type:null,annotations:[],valueConstraint:{isCallConstraint:!1,value:"Digest Authentication"},optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["Declares globally referable security schema definition"]},{name:"MetaModel.actuallyExports",arguments:["$self"]},{name:"MetaModel.referenceIs",arguments:["settings"]}],"extends":[{typeName:"AbstractSecurityScheme",nameSpace:"",basicName:"AbstractSecurityScheme",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"}],moduleName:null,annotationOverridings:{}},{name:"CustomSecurityScheme",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"type",type:null,annotations:[],valueConstraint:{isCallConstraint:!1,value:"x-{other}"},optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["Declares globally referable security schema definition"]},{name:"MetaModel.actuallyExports",arguments:["$self"]},{name:"MetaModel.referenceIs",arguments:["settings"]}],"extends":[{typeName:"AbstractSecurityScheme",nameSpace:"",basicName:"AbstractSecurityScheme",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"}],moduleName:null,annotationOverridings:{}}],aliases:[],enumDeclarations:[],imports:{MetaModel:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/metamodel.ts",Sys:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts",Params:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/parameters.ts",Bodies:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts",Common:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/common.ts",Methods:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts"},name:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"}]},function(e,t){e.exports=[{classes:[{name:"Library",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"usage",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["contains description of why library exist"]}],valueConstraint:null,optional:!1},{name:"name",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.key",arguments:[]},{name:"MetaModel.description",arguments:["Namespace which the library is imported under"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[{typeName:"LibraryBase",nameSpace:"",basicName:"LibraryBase",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"}],moduleName:null,annotationOverridings:{}},{name:"LibraryBase",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"schemas",type:{base:{typeName:"TypeDeclaration",nameSpace:"",basicName:"TypeDeclaration",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"},typeKind:1},annotations:[{name:"MetaModel.embeddedInMaps",arguments:[]},{name:"MetaModel.description",arguments:['Alias for the equivalent "types" property, for compatibility with RAML 0.8. Deprecated - API definitions should use the "types" property, as the "schemas" alias for that property name may be removed in a future RAML version. The "types" property allows for XML and JSON schemas.']}],valueConstraint:null,optional:!1},{name:"types",type:{base:{typeName:"DataModel.TypeDeclaration",nameSpace:"DataModel",basicName:"TypeDeclaration",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"},typeKind:1},annotations:[{name:"MetaModel.embeddedInMaps",arguments:[]},{name:"MetaModel.setsContextValue",arguments:["locationKind","DataModel.LocationKind.MODELS"]},{name:"MetaModel.description",arguments:["Declarations of (data) types for use within this API"]},{name:"MetaModel.markdownDescription",arguments:["Declarations of (data) types for use within this API."]},{name:"MetaModel.valueDescription",arguments:["An object whose properties map type names to type declarations; or an array of such objects"]}],valueConstraint:null,optional:!1},{name:"traits",type:{base:{typeName:"Methods.Trait",nameSpace:"Methods",basicName:"Trait",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"},typeKind:1},annotations:[{name:"MetaModel.embeddedInMaps",arguments:[]},{name:"MetaModel.description",arguments:["Declarations of traits used in this API"]},{name:"MetaModel.description",arguments:["Declarations of traits for use within this API"]},{name:"MetaModel.markdownDescription",arguments:["Declarations of traits for use within this API."]},{name:"MetaModel.valueDescription",arguments:["An object whose properties map trait names to trait declarations; or an array of such objects"]}],valueConstraint:null,optional:!1},{name:"resourceTypes",type:{base:{typeName:"Resources.ResourceType",nameSpace:"Resources",basicName:"ResourceType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"},typeKind:1},annotations:[{name:"MetaModel.embeddedInMaps",arguments:[]},{name:"MetaModel.description",arguments:["Declaration of resource types used in this API"]},{name:"MetaModel.description",arguments:["Declarations of resource types for use within this API"]},{name:"MetaModel.markdownDescription",arguments:["Declarations of resource types for use within this API."]},{name:"MetaModel.valueDescription",arguments:["An object whose properties map resource type names to resource type declarations; or an array of such objects"]}],valueConstraint:null,optional:!1},{name:"annotationTypes",type:{base:{typeName:"DataModel.TypeDeclaration",nameSpace:"DataModel",basicName:"TypeDeclaration",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"},typeKind:1},annotations:[{name:"MetaModel.setsContextValue",arguments:["decls","true"]},{name:"MetaModel.embeddedInMaps",arguments:[]},{name:"MetaModel.description",arguments:["Declarations of annotation types for use by annotations"]},{name:"MetaModel.markdownDescription",arguments:["Declarations of annotation types for use by annotations."]},{name:"MetaModel.valueDescription",arguments:["An object whose properties map annotation type names to annotation type declarations; or an array of such objects"]}],valueConstraint:null,optional:!1},{name:"securitySchemes",type:{base:{typeName:"Security.AbstractSecurityScheme",nameSpace:"Security",basicName:"AbstractSecurityScheme",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"},typeKind:1},annotations:[{name:"MetaModel.embeddedInMaps",arguments:[]},{name:"MetaModel.description",arguments:["Security schemas declarations"]},{name:"MetaModel.description",arguments:["Declarations of security schemes for use within this API."]},{name:"MetaModel.markdownDescription",arguments:["Declarations of security schemes for use within this API."]},{name:"MetaModel.valueDescription",arguments:["An object whose properties map security scheme names to security scheme declarations; or an array of such objects"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.internalClass",arguments:[]}],"extends":[{typeName:"FragmentDeclaration",nameSpace:"",basicName:"FragmentDeclaration",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"}],moduleName:null,annotationOverridings:{}},{name:"Api",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"title",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.required",arguments:[]},{name:"MetaModel.description",arguments:["Short plain-text label for the API"]}],valueConstraint:null,optional:!1},{name:"description",type:{typeName:"Sys.MarkdownString",nameSpace:"Sys",basicName:"MarkdownString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"},annotations:[{name:"MetaModel.description",arguments:["A longer, human-friendly description of the API"]}],valueConstraint:null,optional:!1},{name:"version",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["The version of the API, e.g. 'v1'"]}],valueConstraint:null,optional:!1},{name:"baseUri",type:{typeName:"Sys.FullUriTemplateString",nameSpace:"Sys",basicName:"FullUriTemplateString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"},annotations:[{name:"MetaModel.description",arguments:["A URI that's to be used as the base of all the resources' URIs. Often used as the base of the URL of each resource, containing the location of the API. Can be a template URI."]}],valueConstraint:null,optional:!1},{name:"baseUriParameters",type:{base:{typeName:"DataModel.TypeDeclaration",nameSpace:"DataModel",basicName:"TypeDeclaration",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"},typeKind:1},annotations:[{name:"MetaModel.setsContextValue",arguments:["location","DataModel.ModelLocation.BURI"]},{name:"MetaModel.setsContextValue",arguments:["locationKind","DataModel.LocationKind.APISTRUCTURE"]},{name:"MetaModel.description",arguments:["Named parameters used in the baseUri (template)"]}],valueConstraint:null,optional:!1},{name:"protocols",type:{base:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},typeKind:1},annotations:[{name:"MetaModel.oneOf",arguments:[["HTTP","HTTPS"]]},{name:"MetaModel.description",arguments:["The protocols supported by the API"]},{name:"MetaModel.valueDescription",arguments:['Array of strings, with each being "HTTP" or "HTTPS", case-insensitive']}],valueConstraint:null,optional:!1},{name:"mediaType",type:{base:{typeName:"Bodies.MimeType",nameSpace:"Bodies",basicName:"MimeType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"},typeKind:1},annotations:[{name:"MetaModel.oftenKeys",arguments:[["application/json","application/xml","application/x-www-form-urlencoded","multipart/form-data"]]},{name:"MetaModel.description",arguments:['The default media type to use for request and response bodies (payloads), e.g. "application/json"']},{name:"MetaModel.inherited",arguments:[]},{name:"MetaModel.valueDescription",arguments:["Media type string"]}],valueConstraint:null,optional:!1},{name:"securedBy",type:{base:{typeName:"Security.SecuritySchemeRef",nameSpace:"Security",basicName:"SecuritySchemeRef",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"},typeKind:1},annotations:[{name:"MetaModel.description",arguments:["The security schemes that apply to every resource and method in the API"]}],valueConstraint:null,optional:!1},{name:"resources",type:{base:{typeName:"Resources.Resource",nameSpace:"Resources",basicName:"Resource",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"},typeKind:1},annotations:[{name:"MetaModel.documentationTableLabel",arguments:["/&lt;relativeUri&gt;"]},{name:"MetaModel.newInstanceName",arguments:["New Resource"]},{name:"MetaModel.description",arguments:["The resources of the API, identified as relative URIs that begin with a slash (/). Every property whose key begins with a slash (/), and is either at the root of the API definition or is the child property of a resource property, is a resource property, e.g.: /users, /{groupId}, etc"]}],valueConstraint:null,optional:!1},{name:"documentation",type:{base:{
typeName:"DocumentationItem",nameSpace:"",basicName:"DocumentationItem",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"},typeKind:1},annotations:[{name:"MetaModel.description",arguments:["Additional overall documentation for the API"]}],valueConstraint:null,optional:!1},{name:"RAMLVersion",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:['Returns RAML version. "RAML10" string is returned for RAML 1.0. "RAML08" string is returned for RAML 0.8.']}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[{typeName:"LibraryBase",nameSpace:"",basicName:"LibraryBase",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"}],moduleName:null,annotationOverridings:{annotations:[{name:"MetaModel.markdownDescription",arguments:['Annotations to be applied to this API. Annotations are any property whose key begins with "(" and ends with ")" and whose name (the part between the beginning and ending parentheses) is a declared annotation name.']}]}},{name:"Overlay",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"usage",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["contains description of why overlay exist"]}],valueConstraint:null,optional:!1},{name:"extends",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.required",arguments:[]},{name:"MetaModel.description",arguments:["Location of a valid RAML API definition (or overlay or extension), the overlay is applied to."]}],valueConstraint:null,optional:!1},{name:"title",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Short plain-text label for the API"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[{typeName:"Api",nameSpace:"",basicName:"Api",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"}],moduleName:null,annotationOverridings:{}},{name:"Extension",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"usage",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["contains description of why extension exist"]}],valueConstraint:null,optional:!1},{name:"extends",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.required",arguments:[]},{name:"MetaModel.description",arguments:["Location of a valid RAML API definition (or overlay or extension), the extension is applied to"]}],valueConstraint:null,optional:!1},{name:"title",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Short plain-text label for the API"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[{typeName:"Api",nameSpace:"",basicName:"Api",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"}],moduleName:null,annotationOverridings:{}},{name:"UsesDeclaration",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"key",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.key",arguments:[]},{name:"MetaModel.description",arguments:["Name prefix (without dot) used to refer imported declarations"]}],valueConstraint:null,optional:!1},{name:"value",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Content of the schema"]},{name:"MetaModel.canBeValue",arguments:[]},{name:"MetaModel.value",arguments:[]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[{typeName:"Annotable",nameSpace:"",basicName:"Annotable",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"}],moduleName:null,annotationOverridings:{}},{name:"FragmentDeclaration",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"uses",type:{base:{typeName:"UsesDeclaration",nameSpace:"",basicName:"UsesDeclaration",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"},typeKind:1},annotations:[{name:"MetaModel.embeddedInMaps",arguments:[]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[{typeName:"Annotable",nameSpace:"",basicName:"Annotable",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"}],moduleName:null,annotationOverridings:{}},{name:"DocumentationItem",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"title",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Title of documentation section"]},{name:"MetaModel.required",arguments:[]}],valueConstraint:null,optional:!1},{name:"content",type:{typeName:"Sys.MarkdownString",nameSpace:"Sys",basicName:"MarkdownString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"},annotations:[{name:"MetaModel.description",arguments:["Content of documentation section"]},{name:"MetaModel.required",arguments:[]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.possibleInterfaces",arguments:[["FragmentDeclaration"]]}],"extends":[{typeName:"Annotable",nameSpace:"",basicName:"Annotable",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"}],moduleName:null,annotationOverridings:{}}],aliases:[],enumDeclarations:[],imports:{MetaModel:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/metamodel.ts",Sys:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts",Methods:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/methods.ts",Resources:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/resources.ts",Decls:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/declarations.ts",Params:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/parameters.ts",Common:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/common.ts",Bodies:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/bodies.ts",DataModel:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts",Security:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/security.ts"},name:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/api.ts"},{classes:[{name:"SpecPartMetaData",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!0,annotations:[],"extends":[],moduleName:null,annotationOverridings:{}}],aliases:[],enumDeclarations:[],imports:{},name:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/metamodel.ts"},{classes:[{name:"ValueType",methods:[{returnType:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},name:"value",start:170,end:210,text:"\n\n  value():string {\n    return null\n  }",arguments:[]}],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[],"extends":[{typeName:"Annotable",nameSpace:"",basicName:"Annotable",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"StringType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["string"]},{name:"MetaModel.alias",arguments:["string"]}],"extends":[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"AnyType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["any"]},{name:"MetaModel.alias",arguments:["any"]}],"extends":[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"NumberType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["number"]},{name:"MetaModel.alias",arguments:["number"]}],"extends":[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"IntegerType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["integer"]},{name:"MetaModel.alias",arguments:["integer"]}],"extends":[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"NullType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["null"]},{name:"MetaModel.alias",arguments:["null"]}],"extends":[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"TimeOnlyType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["time-only"]},{name:"MetaModel.alias",arguments:["time-only"]}],"extends":[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"DateOnlyType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["date-only"]},{name:"MetaModel.alias",arguments:["date-only"]}],"extends":[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"DateTimeOnlyType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["datetime-only"]},{name:"MetaModel.alias",arguments:["datetime-only"]}],"extends":[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"DateTimeType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["datetime"]},{name:"MetaModel.alias",arguments:["datetime"]}],"extends":[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"FileType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["file"]},{name:"MetaModel.alias",arguments:["file"]}],"extends":[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"BooleanType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["boolean"]},{name:"MetaModel.alias",arguments:["boolean"]}],"extends":[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"Reference",methods:[],typeParameters:["T"],typeParameterConstraint:[null],"implements":[],fields:[{name:"structuredValue",type:{typeName:"DataModel.TypeInstance",nameSpace:"DataModel",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["Returns a structured object if the reference point to one."]}],valueConstraint:null,optional:!1},{name:"name",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["Returns name of referenced object"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"UriTemplate",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["This type currently serves both for absolute and relative urls"]}],"extends":[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"StatusCodeString",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[],"extends":[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"RelativeUriString",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["This  type describes relative uri templates"]}],"extends":[{typeName:"UriTemplate",nameSpace:"",basicName:"UriTemplate",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"FullUriTemplateString",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["This  type describes absolute uri templates"]}],"extends":[{typeName:"UriTemplate",nameSpace:"",basicName:"UriTemplate",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"FixedUriString",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["This  type describes fixed uris"]}],"extends":[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"ContentType",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[],"extends":[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"MarkdownString",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.innerType",arguments:["markdown"]},{name:"MetaModel.description",arguments:["[GitHub Flavored Markdown](https://help.github.com/articles/github-flavored-markdown/)"]}],"extends":[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"SchemaString",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["Schema at this moment only two subtypes are supported (json schema and xsd)"]},{name:"MetaModel.alias",arguments:["schema"]}],"extends":[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"}],moduleName:null,annotationOverridings:{}}],aliases:[],enumDeclarations:[],imports:{MetaModel:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/metamodel.ts",DataModel:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts",Common:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/common.ts"},name:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/systemTypes.ts"},{classes:[{name:"ExampleSpec",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"value",type:{typeName:"any",nameSpace:"",basicName:"any",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.example",arguments:[]},{name:"MetaModel.selfNode",arguments:[]},{name:"MetaModel.description",arguments:["String representation of example"]},{name:"MetaModel.required",arguments:[]},{name:"MetaModel.valueDescription",arguments:["* Valid value for this type<br>* String representing the serialized version of a valid value"]}],valueConstraint:null,optional:!1},{name:"structuredValue",type:{typeName:"TypeInstance",nameSpace:"",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["Returns object representation of example, if possible"]}],valueConstraint:null,optional:!1},{name:"strict",type:{typeName:"boolean",nameSpace:"",basicName:"boolean",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["By default, examples are validated against any type declaration. Set this to false to allow examples that need not validate."]}],valueConstraint:null,optional:!1},{name:"name",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.key",arguments:[]},{name:"MetaModel.hide",arguments:[]},{name:"MetaModel.description",arguments:["Example identifier, if specified"]}],valueConstraint:null,optional:!1},{name:"displayName",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["An alternate, human-friendly name for the example"]}],valueConstraint:null,optional:!1},{name:"description",type:{typeName:"Sys.MarkdownString",nameSpace:"Sys",basicName:"MarkdownString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"},annotations:[{name:"MetaModel.description",arguments:["A longer, human-friendly description of the example"]},{name:"MetaModel.valueDescription",arguments:["markdown string"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.possibleInterfaces",arguments:[["FragmentDeclaration"]]}],"extends":[{typeName:"Annotable",nameSpace:"",basicName:"Annotable",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"}],moduleName:null,annotationOverridings:{annotations:[{name:"MetaModel.markdownDescription",arguments:['Annotations to be applied to this example. Annotations are any property whose key begins with "(" and ends with ")" and whose name (the part between the beginning and ending parentheses) is a declared annotation name.']}]}},{name:"TypeDeclaration",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"name",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.key",arguments:[]},{name:"MetaModel.description",arguments:["Type name for top level types. For properties and parameters -- property o parameter name, respectively. For bodies -- media type."]},{name:"MetaModel.extraMetaKey",arguments:["headers"]},{name:"MetaModel.hide",arguments:[]}],valueConstraint:null,optional:!1},{name:"displayName",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["The displayName attribute specifies the type display name. It is a friendly name used only for  display or documentation purposes. If displayName is not specified, it defaults to the element's key (the name of the property itself)."]}],valueConstraint:null,optional:!1},{name:"facets",type:{base:{typeName:"TypeDeclaration",nameSpace:"",basicName:"TypeDeclaration",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"},typeKind:1},annotations:[{name:"MetaModel.embeddedInMaps",arguments:[]},{name:"MetaModel.declaringFields",arguments:[]},{name:"MetaModel.description",arguments:["When extending from a type you can define new facets (which can then be set to concrete values by subtypes)."]},{name:"MetaModel.hide",arguments:[]}],valueConstraint:null,optional:!1},{name:"fixedFacets",type:{typeName:"TypeInstance",nameSpace:"",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["Returns facets fixed by the type. Value is an object with properties named after facets fixed. Value of each property is a value of the corresponding facet."]}],valueConstraint:null,optional:!1},{name:"schema",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.typeExpression",arguments:[]},{name:"MetaModel.allowMultiple",arguments:[]},{name:"MetaModel.description",arguments:['Alias for the equivalent "type" property, for compatibility with RAML 0.8. Deprecated - API definitions should use the "type" property, as the "schema" alias for that property name may be removed in a future RAML version. The "type" property allows for XML and JSON schemas.']},{name:"MetaModel.valueDescription",arguments:["Single string denoting the base type or type expression"]}],valueConstraint:null,optional:!1},{name:"type",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.typeExpression",arguments:[]},{name:"MetaModel.allowMultiple",arguments:[]},{name:"MetaModel.canBeValue",arguments:[]},{name:"MetaModel.defaultValue",arguments:["string"]},{name:"MetaModel.descriminatingProperty",arguments:[]},{name:"MetaModel.description",arguments:["A base type which the current type extends, or more generally a type expression."]},{name:"MetaModel.valueDescription",arguments:["string denoting the base type or type expression"]}],valueConstraint:null,optional:!1},{name:"structuredType",type:{typeName:"TypeInstance",nameSpace:"",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.typeExpression",arguments:[]},{name:"MetaModel.description",arguments:["Inlined supertype definition."]},{name:"MetaModel.valueDescription",arguments:["Inlined supertype definition"]}],valueConstraint:null,optional:!1},{name:"location",type:{typeName:"ModelLocation",nameSpace:"",basicName:"ModelLocation",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"},annotations:[{name:"MetaModel.system",arguments:[]},{name:"MetaModel.description",arguments:["Location of the parameter (can not be edited by user)"]},{name:"MetaModel.hide",arguments:[]}],valueConstraint:null,optional:!1},{name:"locationKind",type:{typeName:"LocationKind",nameSpace:"",basicName:"LocationKind",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"},annotations:[{name:"MetaModel.system",arguments:[]},{name:"MetaModel.description",arguments:["Kind of location"]},{name:"MetaModel.hide",arguments:[]}],valueConstraint:null,optional:!1},{name:"default",type:{typeName:"any",nameSpace:"",basicName:"any",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Provides default value for a property"]},{name:"MetaModel.hide",arguments:[]}],valueConstraint:null,optional:!1},{name:"example",type:{typeName:"ExampleSpec",nameSpace:"",basicName:"ExampleSpec",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"},annotations:[{name:"MetaModel.example",arguments:[]},{name:"MetaModel.selfNode",arguments:[]},{name:"MetaModel.description",arguments:["An example of this type instance represented as string or yaml map/sequence. This can be used, e.g., by documentation generators to generate sample values for an object of this type. Cannot be present if the examples property is present."]},{name:"MetaModel.valueDescription",arguments:["* Valid value for this type<br>* String representing the serialized version of a valid value"]}],valueConstraint:null,optional:!1},{name:"examples",type:{base:{typeName:"ExampleSpec",nameSpace:"",basicName:"ExampleSpec",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"},typeKind:1},annotations:[{name:"MetaModel.example",arguments:[]},{name:"MetaModel.selfNode",arguments:[]},{name:"MetaModel.description",arguments:["An example of this type instance represented as string. This can be used, e.g., by documentation generators to generate sample values for an object of this type. Cannot be present if the example property is present."]},{name:"MetaModel.valueDescription",arguments:["* Valid value for this type<br>* String representing the serialized version of a valid value"]}],valueConstraint:null,optional:!1},{name:"required",type:{typeName:"boolean",nameSpace:"",basicName:"boolean",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.requireValue",arguments:["fieldOrParam",!0]},{name:"MetaModel.description",arguments:["For property or parameter states if it is required."]},{name:"MetaModel.describesAnnotation",arguments:["required"]},{name:"MetaModel.hide",arguments:[]},{name:"MetaModel.defaultBooleanValue",arguments:[!0]}],valueConstraint:null,optional:!1},{name:"description",type:{typeName:"Sys.MarkdownString",nameSpace:"Sys",basicName:"MarkdownString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"},annotations:[{name:"MetaModel.description",arguments:["A longer, human-friendly description of the type"]},{name:"MetaModel.valueDescription",arguments:["markdown string"]}],valueConstraint:null,optional:!1},{name:"xml",type:{typeName:"XMLFacetInfo",nameSpace:"",basicName:"XMLFacetInfo",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"},annotations:[],valueConstraint:null,optional:!1},{name:"allowedTargets",type:{base:{typeName:"AnnotationTarget",nameSpace:"",basicName:"AnnotationTarget",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"},typeKind:1},annotations:[{name:"MetaModel.oneOf",arguments:[["API","DocumentationItem","Resource","Method","Response","RequestBody","ResponseBody","TypeDeclaration","NamedExample","ResourceType","Trait","SecurityScheme","SecuritySchemeSettings","AnnotationTypeDeclaration","Library","Overlay","Extension","Scalar"]]},{name:"MetaModel.description",arguments:["Restrictions on where annotations of this type can be applied. If this property is specified, annotations of this type may only be applied on a property corresponding to one of the target names specified as the value of this property."]},{name:"MetaModel.valueDescription",arguments:["An array, or single, of names allowed target nodes."]}],valueConstraint:null,optional:!1},{name:"isAnnotation",type:{typeName:"boolean",nameSpace:"",basicName:"boolean",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Whether the type represents annotation"]}],valueConstraint:null,optional:!1},{name:"parametrizedProperties",type:{typeName:"TypeInstance",nameSpace:"",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"
},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["For types defined in traits or resource types returns object representation of parametrized properties"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.convertsToGlobalOfType",arguments:["SchemaString"]},{name:"MetaModel.canInherit",arguments:["mediaType"]},{name:"MetaModel.possibleInterfaces",arguments:[["FragmentDeclaration"]]}],"extends":[{typeName:"Annotable",nameSpace:"",basicName:"Annotable",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"}],moduleName:null,annotationOverridings:{annotations:[{name:"MetaModel.markdownDescription",arguments:['Annotations to be applied to this type. Annotations are any property whose key begins with "(" and ends with ")" and whose name (the part between the beginning and ending parentheses) is a declared annotation name.']}]}},{name:"XMLFacetInfo",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"attribute",type:{typeName:"boolean",nameSpace:"",basicName:"boolean",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["If attribute is set to true, a type instance should be serialized as an XML attribute. It can only be true for scalar types."]}],valueConstraint:null,optional:!1},{name:"wrapped",type:{typeName:"boolean",nameSpace:"",basicName:"boolean",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["If wrapped is set to true, a type instance should be wrapped in its own XML element. It can not be true for scalar types and it can not be true at the same moment when attribute is true."]}],valueConstraint:null,optional:!1},{name:"name",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Allows to override the name of the XML element or XML attribute in it's XML representation."]}],valueConstraint:null,optional:!1},{name:"namespace",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Allows to configure the name of the XML namespace."]}],valueConstraint:null,optional:!1},{name:"prefix",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Allows to configure the prefix which will be used during serialization to XML."]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],"extends":[{typeName:"Annotable",nameSpace:"",basicName:"Annotable",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"}],moduleName:null,annotationOverridings:{}},{name:"ArrayTypeDeclaration",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"type",type:null,annotations:[],valueConstraint:{isCallConstraint:!1,value:"array"},optional:!1},{name:"uniqueItems",type:{typeName:"boolean",nameSpace:"",basicName:"boolean",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.facetId",arguments:["uniqueItems"]},{name:"MetaModel.description",arguments:["Should items in array be unique"]}],valueConstraint:null,optional:!1},{name:"items",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.typeExpression",arguments:[]},{name:"MetaModel.allowMultiple",arguments:[]},{name:"MetaModel.canBeValue",arguments:[]},{name:"MetaModel.description",arguments:["Array component type."]},{name:"MetaModel.valueDescription",arguments:["Inline type declaration or type name."]}],valueConstraint:null,optional:!1},{name:"structuredItems",type:{typeName:"TypeInstance",nameSpace:"",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.typeExpression",arguments:[]},{name:"MetaModel.description",arguments:["Inlined component type definition"]},{name:"MetaModel.valueDescription",arguments:["Inlined component type definition"]}],valueConstraint:null,optional:!1},{name:"minItems",type:{typeName:"number",nameSpace:"",basicName:"number",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.facetId",arguments:["minItems"]},{name:"MetaModel.description",arguments:["Minimum amount of items in array"]},{name:"MetaModel.valueDescription",arguments:["integer ( >= 0 ). Defaults to 0"]}],valueConstraint:null,optional:!1},{name:"maxItems",type:{typeName:"number",nameSpace:"",basicName:"number",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.facetId",arguments:["maxItems"]},{name:"MetaModel.description",arguments:["Maximum amount of items in array"]},{name:"MetaModel.valueDescription",arguments:["integer ( >= 0 ). Defaults to undefined."]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.convertsToGlobalOfType",arguments:["SchemaString"]},{name:"MetaModel.alias",arguments:["array"]},{name:"MetaModel.declaresSubTypeOf",arguments:["TypeDeclaration"]}],"extends":[{typeName:"TypeDeclaration",nameSpace:"",basicName:"TypeDeclaration",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"}],moduleName:null,annotationOverridings:{}},{name:"UnionTypeDeclaration",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"type",type:null,annotations:[],valueConstraint:{isCallConstraint:!1,value:"union"},optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.convertsToGlobalOfType",arguments:["SchemaString"]},{name:"MetaModel.requireValue",arguments:["locationKind","LocationKind.MODELS"]},{name:"MetaModel.declaresSubTypeOf",arguments:["TypeDeclaration"]}],"extends":[{typeName:"TypeDeclaration",nameSpace:"",basicName:"TypeDeclaration",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"}],moduleName:null,annotationOverridings:{}},{name:"ObjectTypeDeclaration",methods:[],typeParameters:[],typeParameterConstraint:[],"implements":[],fields:[{name:"type",type:null,annotations:[{name:"MetaModel.hide",arguments:[]}],valueConstraint:{isCallConstraint:!1,value:"object"},optional:!1},{name:"properties",type:{base:{typeName:"TypeDeclaration",nameSpace:"",basicName:"TypeDeclaration",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-1.0/datamodel.ts"},typeKind:1},annotations:[{name:"MetaModel.embeddedInMaps",arguments:[]},{name:"MetaModel.setsContextValue",arguments:["fieldOrParam",!0]},{name:"MetaModel.description",arguments:["The properties that instances of this type may or must have."]},{name:"MetaModel.valueDescription",arguments:["An object whose keys are the