/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.module.apikit.exception.BadRequestException;
import org.mule.module.apikit.validation.AbstractRestSchemaValidator;
import org.mule.module.apikit.validation.cache.XmlSchemaCache;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RestXmlSchemaValidator
extends AbstractRestSchemaValidator {
    protected static final Logger logger = LoggerFactory.getLogger(RestXmlSchemaValidator.class);

    public RestXmlSchemaValidator(MuleContext muleContext) {
        super(muleContext);
    }

    @Override
    public void validate(String configId, String schemaPath, MuleEvent muleEvent, IRaml api) throws BadRequestException {
        try {
            Document data;
            Object input = muleEvent.getMessage().getPayload();
            String messageEncoding = muleEvent.getEncoding();
            String charset = RestXmlSchemaValidator.getHeaderCharset(muleEvent.getMessage());
            if (input instanceof InputStream) {
                logger.debug("transforming payload to perform XSD validation");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copyLarge((InputStream)((InputStream)input), (OutputStream)baos);
                DataType dataType = DataTypeFactory.create(ByteArrayInputStream.class, (String)muleEvent.getMessage().getDataType().getMimeType());
                dataType.setEncoding(messageEncoding);
                muleEvent.getMessage().setPayload((Object)new ByteArrayInputStream(baos.toByteArray()), dataType);
                data = RestXmlSchemaValidator.loadDocument(new ByteArrayInputStream(baos.toByteArray()), charset);
            } else if (input instanceof String) {
                data = RestXmlSchemaValidator.loadDocument(new StringReader((String)input));
            } else if (input instanceof byte[]) {
                data = RestXmlSchemaValidator.loadDocument(new ByteArrayInputStream((byte[])input), charset);
            } else {
                throw new BadRequestException("Don't know how to parse " + input.getClass().getName());
            }
            Schema schema = (Schema)XmlSchemaCache.getXmlSchemaCache(this.muleContext, configId, api).get((Object)schemaPath);
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(data.getDocumentElement()));
        }
        catch (Exception e) {
            logger.info("Schema validation failed: " + e.getMessage());
            throw new BadRequestException(e);
        }
    }

    public static String getHeaderCharset(MuleMessage message) {
        String contentType = (String)message.getInboundProperty("Content-Type", (Object)"application/xml");
        if (contentType.contains("charset=")) {
            return message.getEncoding();
        }
        return null;
    }

    private static Document loadDocument(InputStream stream, String charset) throws IOException {
        if (charset == null) {
            return RestXmlSchemaValidator.loadDocument(new InputSource(stream));
        }
        return RestXmlSchemaValidator.loadDocument(new InputSource(new InputStreamReader(stream, charset)));
    }

    private static Document loadDocument(Reader reader) throws IOException {
        return RestXmlSchemaValidator.loadDocument(new InputSource(reader));
    }

    private static Document loadDocument(InputSource source) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        RestXmlSchemaValidator.setFeatures(factory);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(source);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("An internal operation failed.", e);
        }
        catch (SAXException e) {
            throw new IOException("An internal operation failed.", e);
        }
    }

    private static void setFeatures(DocumentBuilderFactory dbf) {
        String feature = null;
        try {
            feature = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(feature, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException e) {
            logger.info("ParserConfigurationException was thrown. The feature '" + feature + "' is probably not supported by your XML processor.");
        }
    }
}

