/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.schema;

import com.jayway.restassured.RestAssured;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class JsonSchemaRefTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigFile() {
        return "org/mule/module/apikit/schema/json-schema-ref-config.xml";
    }

    @Test
    public void validSchema() throws Exception {
        RestAssured.given().body("{\"/\": {\"fstype\": \"ext4\", \"device\": \"/dev/hda\"}, \"swap\": {\"fstype\": \"ext4\", \"device\": \"/dev/hdb\"}}").contentType("application/json").expect().statusCode(200).when().put("/api/resource", new Object[0]);
    }

    @Test
    public void invalidSchema() throws Exception {
        RestAssured.given().body("{\"/\": {\"fstype\": \"ext4\", \"device\": \"/dev/hda\"}, \"swap\": {\"fstype\": \"ext4\"}}").contentType("application/json").expect().statusCode(400).when().put("/api/resource", new Object[0]);
    }

    @Test
    public void validGlobalSchema() throws Exception {
        RestAssured.given().body("{\"/\": {\"fstype\": \"ext4\", \"device\": \"/dev/hda\"}, \"swap\": {\"fstype\": \"ext4\", \"device\": \"/dev/hdb\"}}").contentType("application/json").expect().statusCode(200).when().put("/api/global", new Object[0]);
    }

    @Test
    public void invalidGlobalSchema() throws Exception {
        RestAssured.given().body("{\"/\": {\"device\": \"/dev/hda\"}, \"swap\": {\"fstype\": \"ext4\", \"device\": \"/dev/hdb\"}}").contentType("application/json").expect().statusCode(400).when().put("/api/global", new Object[0]);
    }

    @Test
    public void validGlobalIncludeSchema() throws Exception {
        RestAssured.given().body("{\"/\": {\"fstype\": \"ext4\", \"device\": \"/dev/hda\"}, \"swap\": {\"fstype\": \"ext4\", \"device\": \"/dev/hdb\"}}").contentType("application/json").expect().statusCode(200).when().put("/api/global-include", new Object[0]);
    }

    @Test
    public void invalidGlobalIncludeSchema() throws Exception {
        RestAssured.given().body("{\"/\": {\"device\": \"/dev/hda\"}, \"swap\": {\"fstype\": \"ext4\", \"device\": \"/dev/hdb\"}}").contentType("application/json").expect().statusCode(400).when().put("/api/global-include", new Object[0]);
    }
}

