/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.jayway.restassured.RestAssured;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class ContentTypeTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/contenttype/content-type-config.xml";
    }

    @Test
    public void getOnAcceptAnythingAndNullPayload() throws Exception {
        RestAssured.given().header("Accept", (Object)"*/*", new Object[0]).expect().response().body(CoreMatchers.is((Object)""), new Matcher[0]).statusCode(200).when().get("/api/resources", new Object[0]);
    }

    @Test
    public void getOnUsingInvalidAcceptHeader() throws Exception {
        RestAssured.given().header("Accept", (Object)"invalid/invalid", new Object[0]).expect().response().statusCode(406).when().get("/api/resources", new Object[0]);
    }

    @Test
    public void getOnUsingSingleInvalidAcceptHeader() throws Exception {
        RestAssured.given().header("Accept", (Object)"invalid", new Object[0]).expect().response().statusCode(406).when().get("/api/resources", new Object[0]);
    }

    @Test
    public void getOnAcceptNotSpecified() throws Exception {
        RestAssured.given().header("Accept", (Object)"", new Object[0]).expect().response().body(CoreMatchers.is((Object)""), new Matcher[0]).statusCode(200).when().get("/api/resources", new Object[0]);
    }

    @Test
    public void getOnAcceptAnythingResponseJson() throws Exception {
        RestAssured.given().header("Accept", (Object)"", new Object[0]).header("ctype", (Object)"json", new Object[0]).expect().response().contentType(CoreMatchers.is((Object)"application/json")).body(CoreMatchers.is((Object)"never mind"), new Matcher[0]).statusCode(200).when().get("/api/multitype", new Object[0]);
    }

    @Test
    public void getOnAcceptAnythingResponseXml() throws Exception {
        RestAssured.given().header("Accept", (Object)"", new Object[0]).header("ctype", (Object)"xml", new Object[0]).expect().response().contentType(CoreMatchers.is((Object)"application/xml")).body(CoreMatchers.is((Object)"never mind"), new Matcher[0]).statusCode(200).when().get("/api/multitype", new Object[0]);
    }

    @Test
    public void getOnAcceptAnythingResponseHtml() throws Exception {
        RestAssured.given().header("Accept", (Object)"", new Object[0]).header("ctype", (Object)"default", new Object[0]).expect().response().contentType(CoreMatchers.is((Object)"text/html")).body(CoreMatchers.is((Object)"never mind"), new Matcher[0]).statusCode(200).when().get("/api/multitype", new Object[0]);
    }
}

