/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.parameters;

import com.jayway.restassured.RestAssured;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class ParametersTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/parameters/parameters-config.xml";
    }

    @Test
    public void requiredHeaderNotProvided() throws Exception {
        RestAssured.given().expect().response().statusCode(400).body(CoreMatchers.is((Object)"Required header one not specified"), new Matcher[0]).when().get("/api/resources?first=fi", new Object[0]);
    }

    @Test
    public void invalidEnumHeaderProvided() throws Exception {
        RestAssured.given().header("one", (Object)"invalid", new Object[0]).expect().response().statusCode(400).body(CoreMatchers.is((Object)"Invalid value 'invalid' for header one. Value must be one of [foo, bar]"), new Matcher[0]).when().get("/api/resources?first=fi", new Object[0]);
    }

    @Test
    public void invalidHeaderPlaceholderProvided() throws Exception {
        RestAssured.given().header("mule-special", (Object)"dough", new Object[0]).header("one", (Object)"foo", new Object[0]).expect().response().statusCode(400).body(CoreMatchers.is((Object)"Invalid value 'dough' for header mule-{?}. Value must be one of [wow, yeah]"), new Matcher[0]).when().get("/api/resources?first=fi", new Object[0]);
    }

    @Test
    public void validHeaderPlaceholderProvided() throws Exception {
        RestAssured.given().header("mule-special", (Object)"yeah", new Object[0]).header("one", (Object)"foo", new Object[0]).expect().response().statusCode(200).when().get("/api/resources?first=fi", new Object[0]);
    }

    @Test
    public void requiredQueryParamNotProvided() throws Exception {
        RestAssured.given().expect().response().statusCode(400).body(CoreMatchers.is((Object)"Required query parameter first not specified"), new Matcher[0]).when().get("/api/resources", new Object[0]);
    }

    @Test
    public void requiredQueryParamAndHeaderProvided() throws Exception {
        RestAssured.given().header("one", (Object)"foo", new Object[0]).expect().response().statusCode(200).when().get("/api/resources?first=fi", new Object[0]);
    }

    @Test
    public void invalidQueryParamMinLength() throws Exception {
        RestAssured.given().header("one", (Object)"foo", new Object[0]).queryParam("first", new Object[]{"f"}).expect().response().statusCode(400).body(CoreMatchers.is((Object)"Invalid value 'f' for query parameter first. Value length is shorter than 2"), new Matcher[0]).when().get("/api/resources", new Object[0]);
    }

    @Test
    public void invalidQueryParamMaxLength() throws Exception {
        RestAssured.given().header("one", (Object)"foo", new Object[0]).queryParam("first", new Object[]{"first"}).expect().response().statusCode(400).body(CoreMatchers.is((Object)"Invalid value 'first' for query parameter first. Value length is longer than 3"), new Matcher[0]).when().get("/api/resources", new Object[0]);
    }

    @Test
    public void invalidQueryParamPattern() throws Exception {
        RestAssured.given().header("one", (Object)"foo", new Object[0]).queryParam("first", new Object[]{"1st"}).expect().response().statusCode(400).body(CoreMatchers.is((Object)"Invalid value '1st' for query parameter first. Value does not match pattern [^0-9]*"), new Matcher[0]).when().get("/api/resources", new Object[0]);
    }

    @Test
    public void validSingleUriParamType() throws Exception {
        RestAssured.given().header("one", (Object)"foo", new Object[0]).queryParam("first", new Object[]{"fi"}).expect().response().statusCode(200).when().get("/api/resources/4", new Object[0]);
    }

    @Test
    public void validMultipleUriParamType() throws Exception {
        RestAssured.given().header("one", (Object)"foo", new Object[0]).queryParam("first", new Object[]{"fi"}).expect().response().statusCode(200).when().get("/api/resources/4/one", new Object[0]);
    }

    @Test
    public void invalidParentUriParamType() throws Exception {
        RestAssured.given().header("one", (Object)"foo", new Object[0]).queryParam("first", new Object[]{"fi"}).expect().response().statusCode(400).body(CoreMatchers.is((Object)"Invalid value '0' for uri parameter id. Value is below the minimum 1"), new Matcher[0]).when().get("/api/resources/0/one", new Object[0]);
    }

    @Test
    public void invalidUriParamType() throws Exception {
        RestAssured.given().header("one", (Object)"foo", new Object[0]).queryParam("first", new Object[]{"fi"}).expect().response().statusCode(400).body(CoreMatchers.is((Object)"Invalid value 'a' for uri parameter id. Integer required"), new Matcher[0]).when().get("/api/resources/a", new Object[0]);
    }

    @Test
    public void invalidUriParamMinimum() throws Exception {
        RestAssured.given().header("one", (Object)"foo", new Object[0]).queryParam("first", new Object[]{"fi"}).expect().response().statusCode(400).body(CoreMatchers.is((Object)"Invalid value '0' for uri parameter id. Value is below the minimum 1"), new Matcher[0]).when().get("/api/resources/0", new Object[0]);
    }

    @Test
    public void invalidUriParamMaximum() throws Exception {
        RestAssured.given().header("one", (Object)"foo", new Object[0]).queryParam("first", new Object[]{"fi"}).expect().response().statusCode(400).body(CoreMatchers.is((Object)"Invalid value '10' for uri parameter id. Value is above the maximum 5"), new Matcher[0]).when().get("/api/resources/10", new Object[0]);
    }

    @Test
    public void invalidBooleanQueryParamProvided() throws Exception {
        RestAssured.given().expect().response().statusCode(400).body(CoreMatchers.is((Object)"Invalid value 'yes' for query parameter third. Value must be one of [true, false]"), new Matcher[0]).when().get("/api/resources?first=fi&third=yes", new Object[0]);
    }

    @Test
    public void repeatableQueryParam() {
        RestAssured.given().queryParam("status", new Object[]{"a", "b"}).expect().response().statusCode(200).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void raml() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/raml+yaml", new Object[0]).expect().response().body(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"baseUri"), (Matcher)CoreMatchers.containsString((String)("http://localhost:" + this.serverPort.getNumber() + "/api"))), new Matcher[0]).statusCode(200).when().get("/api", new Object[0]);
    }
}

