/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.leagues;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.mule.api.annotations.ContainsTransformerMethods;
import org.mule.api.annotations.Transformer;
import org.mule.module.apikit.leagues.Team;

@ContainsTransformerMethods
@XmlRootElement
@JsonAutoDetect
public class Teams {
    private List<Team> teams;

    @XmlElement(name="teams")
    public List<Team> getTeams() {
        return this.teams;
    }

    public void setTeams(List<Team> teams) {
        this.teams = teams;
    }

    public Team getTeam(String id) {
        for (Team team : this.teams) {
            if (!team.getId().equals(id)) continue;
            return team;
        }
        return null;
    }

    @Transformer(resultMimeType="application/json")
    public String toJson(Teams teams) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)teams);
    }

    @Transformer(resultMimeType="text/xml")
    public String toXml(Teams teams) throws IOException, JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{this.getClass()});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        m.marshal((Object)teams, (OutputStream)boas);
        return new String(boas.toByteArray());
    }
}

