/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.net.URI;
import java.net.URISyntaxException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.module.apikit.uri.URICoder;
import org.mule.module.apikit.uri.URIPattern;
import org.mule.module.apikit.uri.URIResolveResult;
import org.mule.module.apikit.uri.URIResolver;

public class UriTemplateTestCase {
    private static final String HOST = "hi.com";
    private static final String URL_PREFIX = "http://hi.com";
    private static char[] SPECIAL_CHARS_URI_ENCODED = new char[]{'\"', '?', '[', ']', '{', '}', '\\'};
    private static char[] SPECIAL_CHARS_NOT_URI_ENCODED = new char[]{',', ';', ':', '\'', '=', '!', '*', '@', '(', ')', '/'};

    @Test
    public void alphaCharacters() {
        this.matchSingleTemplateLevelOne("onetwo");
        this.matchSingleTemplateLevelOne("TWOONE");
    }

    @Test
    public void spaceCharacter() {
        this.matchSingleTemplateLevelOne("one two");
        this.matchSingleTemplateLevelOne(" one two  three ");
    }

    @Test
    public void specialUriEncodedCharactersLevelOne() {
        for (char c : SPECIAL_CHARS_URI_ENCODED) {
            this.matchSingleTemplateLevelOne("one" + c + "two");
        }
    }

    @Test
    public void specialNotUriEncodedCharactersLevelOne() {
        for (char c : SPECIAL_CHARS_NOT_URI_ENCODED) {
            this.matchMultiTemplateLevelOne("one" + c + "two");
        }
    }

    @Test
    @Ignore
    public void specialNotUriEncodedCharactersLevelTwo() {
        for (char c : SPECIAL_CHARS_NOT_URI_ENCODED) {
            this.matchSingleTemplateLevelTwo("one" + c + "two");
        }
    }

    @Test
    public void plusCharacter() {
        this.matchMultiTemplateLevelOne("one+two");
    }

    @Test
    public void percentEncodeReservedCharacters() {
        for (char c : SPECIAL_CHARS_URI_ENCODED) {
            this.matchSingleTemplateLevelOne(URICoder.encode((String)("one" + c + "two")));
        }
        for (char c : SPECIAL_CHARS_NOT_URI_ENCODED) {
            this.matchSingleTemplateLevelOne(URICoder.encode((String)("one" + c + "two")));
        }
    }

    private void matchSingleTemplateLevelOne(String value) {
        URIResolver resolver = new URIResolver(this.getUri(value));
        URIPattern pattern = new URIPattern("http://hi.com/{id}");
        URIResolveResult resolve = resolver.resolve(pattern);
        Assert.assertThat((Object)((String)resolve.get("id")), (Matcher)Is.is((Object)URICoder.encode((String)value)));
    }

    private void matchSingleTemplateLevelTwo(String value) {
        URIResolver resolver = new URIResolver(this.getUri(value));
        URIPattern pattern = new URIPattern("http://hi.com/{+id}");
        URIResolveResult resolve = resolver.resolve(pattern);
        Assert.assertThat((Object)((String)resolve.get("id")), (Matcher)Is.is((Object)value));
    }

    private void matchMultiTemplateLevelOne(String value) {
        URIResolver resolver = new URIResolver(this.getUri(value));
        char sep = value.charAt(3);
        URIPattern pattern = new URIPattern("http://hi.com/{id1}" + sep + "{id2}");
        URIResolveResult resolve = resolver.resolve(pattern);
        Assert.assertThat((Object)((String)resolve.get("id1")), (Matcher)Is.is((Object)"one"));
        Assert.assertThat((Object)((String)resolve.get("id2")), (Matcher)Is.is((Object)"two"));
    }

    private String getUri(String value) {
        URI uri;
        try {
            uri = new URI("http", HOST, "/" + value, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return uri.toString();
    }
}

