/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.Pipeline;
import org.mule.api.processor.DefaultMessageProcessorPathElement;
import org.mule.api.processor.MessageProcessorPathElement;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.NotificationUtils;

public class MessageProcessorNotificationPathTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/module/apikit/path/message-processor-path.xml";
    }

    @Test
    public void exceptionStrategy() throws Exception {
        this.testFlowPaths("exception-strategy", "/0", "es/0/0");
    }

    private void testFlowPaths(String flowName, String ... nodes) throws Exception {
        Object[] expectedPaths = this.generatePaths(flowName, nodes);
        FlowConstruct flow = this.getFlowConstruct(this.unescape(flowName));
        DefaultMessageProcessorPathElement flowElement = new DefaultMessageProcessorPathElement(null, flowName);
        ((Pipeline)flow).addMessageProcessorPathElements((MessageProcessorPathElement)flowElement);
        Map messageProcessorPaths = NotificationUtils.buildPathResolver((MessageProcessorPathElement)flowElement).getFlowMap();
        Object[] flowPaths = messageProcessorPaths.values().toArray(new String[0]);
        Arrays.sort(expectedPaths);
        Arrays.sort(flowPaths);
        Assert.assertArrayEquals((Object[])expectedPaths, (Object[])flowPaths);
    }

    private String[] generatePaths(String flowName, String[] nodes) {
        LinkedHashSet<String> pathSet = new LinkedHashSet<String>();
        String base = "/" + flowName + "/processors";
        for (String node : nodes) {
            if (!node.startsWith("/")) {
                base = "/" + flowName + "/";
            }
            pathSet.add(base + node);
        }
        return pathSet.toArray(new String[0]);
    }

    private String unescape(String name) {
        StringBuilder builder = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i < name.length() - 1 && name.charAt(i + 1) == '/') {
                builder.append("/");
                ++i;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

