/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.DataType;
import org.mule.module.apikit.exception.BadRequestException;
import org.mule.module.apikit.validation.AbstractRestSchemaValidator;
import org.mule.module.apikit.validation.cache.XmlSchemaCache;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;
import org.raml.model.Raml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RestXmlSchemaValidator
extends AbstractRestSchemaValidator {
    protected static final Logger logger = LoggerFactory.getLogger(RestXmlSchemaValidator.class);

    public RestXmlSchemaValidator(MuleContext muleContext) {
        super(muleContext);
    }

    @Override
    public void validate(String configId, String schemaPath, MuleEvent muleEvent, Raml api) throws BadRequestException {
        try {
            Document data;
            Object input = muleEvent.getMessage().getPayload();
            if (input instanceof InputStream) {
                input = IOUtils.toString((InputStream)((InputStream)input), (String)muleEvent.getMessage().getEncoding());
                logger.debug("transforming payload to perform XSD validation");
                DataType dataType = DataTypeFactory.create(String.class, (String)muleEvent.getMessage().getDataType().getMimeType());
                muleEvent.getMessage().setPayload(input, dataType);
            }
            if (input instanceof String) {
                data = RestXmlSchemaValidator.loadDocument(IOUtils.toInputStream((String)((String)input)));
            } else if (input instanceof byte[]) {
                data = RestXmlSchemaValidator.loadDocument(new ByteArrayInputStream((byte[])input));
            } else {
                throw new BadRequestException("Don't know how to parse " + input.getClass().getName());
            }
            Schema schema = (Schema)XmlSchemaCache.getXmlSchemaCache(this.muleContext, configId, api).get((Object)schemaPath);
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(data.getDocumentElement()));
        }
        catch (Exception e) {
            logger.info("Schema validation failed: " + e.getMessage());
            throw new BadRequestException(e);
        }
    }

    public static Document loadDocument(InputStream inputStream) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        RestXmlSchemaValidator.setFeatures(factory);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(inputStream));
        }
        catch (ParserConfigurationException e) {
            throw new IOException("An internal operation failed.", e);
        }
        catch (SAXException e) {
            throw new IOException("An internal operation failed.", e);
        }
    }

    private static void setFeatures(DocumentBuilderFactory dbf) {
        String feature = null;
        try {
            feature = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(feature, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException e) {
            logger.info("ParserConfigurationException was thrown. The feature '" + feature + "' is probably not supported by your XML processor.");
        }
    }
}

