/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.transform;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.net.MediaType;
import java.util.Collection;
import java.util.List;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.module.apikit.RestContentTypeParser;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.transform.DataTypePair;
import org.mule.module.apikit.transform.TransformerCache;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.raml.model.MimeType;

public class ApikitResponseTransformer
extends AbstractMessageTransformer {
    public static final String BEST_MATCH_REPRESENTATION = "_ApikitResponseTransformer_bestMatchRepresentation";
    public static final String CONTRACT_MIME_TYPES = "_ApikitResponseTransformer_contractMimeTypes";
    public static final String APIKIT_ROUTER_REQUEST = "_ApikitResponseTransformer_apikitRouterRequest";
    public static final String ACCEPT_HEADER = "_ApikitResponseTransformer_AcceptedHeaders";

    public Object transformMessage(MuleMessage message, String encoding) throws TransformerException {
        if (message.getInvocationProperty(APIKIT_ROUTER_REQUEST) == null) {
            return message;
        }
        String responseRepresentation = (String)message.getInvocationProperty(BEST_MATCH_REPRESENTATION);
        List responseMimeTypes = (List)message.getInvocationProperty(CONTRACT_MIME_TYPES);
        String acceptedHeader = (String)message.getInvocationProperty(ACCEPT_HEADER);
        if (responseRepresentation == null) {
            if (message.getOutboundProperty("http.status") == null) {
                message.setPayload((Object)NullPayload.getInstance());
            }
            return message;
        }
        return this.transformToExpectedContentType(message, responseRepresentation, responseMimeTypes, acceptedHeader);
    }

    public Object transformToExpectedContentType(MuleMessage message, String responseRepresentation, List<MimeType> responseMimeTypes, String acceptedHeader) throws TransformerException {
        Object payload = message.getPayload();
        String msgMimeType = null;
        DataType dataType = message.getDataType();
        if (dataType != null && dataType.getMimeType() != null) {
            msgMimeType = dataType.getMimeType() + ";charset=" + message.getEncoding();
        }
        String msgContentType = (String)message.getOutboundProperty("Content-Type");
        if ("*/*".equals(responseRepresentation)) {
            if (msgContentType == null) {
                throw new ApikitRuntimeException("Content-Type must be set in the flow when declaring */* response type");
            }
            return payload;
        }
        if (payload instanceof NullPayload) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Response transformation not required. Message payload type is NullPayload");
            }
            return payload;
        }
        Collection<MimeType> conjunctionTypes = this.getBestMatchMediaTypes(responseMimeTypes, acceptedHeader);
        String msgAcceptedContentType = this.acceptedContentType(msgMimeType, msgContentType, conjunctionTypes);
        if (msgAcceptedContentType != null) {
            message.setOutboundProperty("Content-Type", (Object)msgAcceptedContentType);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Response transformation not required. Message payload type is " + msgAcceptedContentType));
            }
            return payload;
        }
        DataType sourceDataType = DataTypeFactory.create(message.getPayload().getClass(), (String)msgMimeType);
        DataType resultDataType = DataTypeFactory.create(String.class, (String)responseRepresentation);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Resolving transformer between [source=%s] and [result=%s]", sourceDataType, resultDataType));
        }
        try {
            Transformer transformer = (Transformer)TransformerCache.getTransformerCache(this.muleContext).get((Object)new DataTypePair(sourceDataType, resultDataType));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Transformer resolved to [transformer=%s]", transformer));
            }
            Object newPayload = transformer.transform(message.getPayload());
            message.setOutboundProperty("Content-Type", (Object)responseRepresentation);
            return newPayload;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    private Collection<MimeType> getBestMatchMediaTypes(List<MimeType> responseMimeTypes, String acceptedHeader) {
        if (acceptedHeader.contains("*/*")) {
            return responseMimeTypes;
        }
        Collection<String> acceptedTypes = this.transformAcceptedTypes(acceptedHeader);
        return this.filterAccepted(responseMimeTypes, acceptedTypes);
    }

    private Collection<MimeType> filterAccepted(List<MimeType> responseMimeTypes, final Collection<String> acceptedTypes) {
        return Collections2.filter(responseMimeTypes, (Predicate)new Predicate<MimeType>(){

            public boolean apply(MimeType m) {
                return acceptedTypes.contains(m.getType());
            }
        });
    }

    private Collection<String> transformAcceptedTypes(String acceptedHeader) {
        List<MediaType> acceptedMediaTypes = RestContentTypeParser.parseMediaTypes(acceptedHeader);
        return Collections2.transform(acceptedMediaTypes, (Function)new Function<MediaType, String>(){

            public String apply(MediaType mediaType) {
                return mediaType.type() + "/" + mediaType.subtype();
            }
        });
    }

    private String acceptedContentType(String msgMimeType, String msgContentType, Collection<MimeType> conjunctionTypes) {
        for (MimeType acceptedMediaType : conjunctionTypes) {
            if (msgMimeType == null || !msgMimeType.contains(acceptedMediaType.getType())) continue;
            return msgMimeType;
        }
        for (MimeType acceptedMediaType : conjunctionTypes) {
            if (msgContentType == null || !msgContentType.contains(acceptedMediaType.getType())) continue;
            return msgContentType;
        }
        return null;
    }
}

