/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.uri;

import java.util.Hashtable;
import java.util.Map;
import org.mule.module.apikit.uri.VariableResolver;
import org.mule.module.apikit.uri.VariableType;

public class VariableBinder {
    private static final VariableResolver DEFAULT_RESOLVER = new VariableResolver(){

        @Override
        public boolean exists(String value) {
            return true;
        }

        @Override
        public Object resolve(String value) {
            return value;
        }
    };
    private Map<String, VariableResolver> _byname = new Hashtable<String, VariableResolver>();
    private Map<String, VariableResolver> _bytype = new Hashtable<String, VariableResolver>();

    public void bind(String name, VariableResolver resolver) {
        this._byname.put(name, resolver);
    }

    public void bindName(String name, VariableResolver resolver) {
        this._byname.put(name, resolver);
    }

    public void bindType(String type, VariableResolver resolver) {
        this._bytype.put(type, resolver);
    }

    public VariableResolver getResolver(String name, VariableType type) {
        VariableResolver resolver = this._byname.get(name);
        if (resolver == null && type != null) {
            resolver = this._bytype.get(type.getName());
        }
        return resolver != null ? resolver : DEFAULT_RESOLVER;
    }

    public VariableResolver getResolver(String name) {
        VariableResolver resolver = this._byname.get(name);
        return resolver != null ? resolver : DEFAULT_RESOLVER;
    }

    public VariableResolver getResolver(VariableType type) {
        if (type == null) {
            return DEFAULT_RESOLVER;
        }
        VariableResolver resolver = this._bytype.get(type.getName());
        return resolver != null ? resolver : DEFAULT_RESOLVER;
    }

    public boolean isNameBound(String name) {
        if (name == null) {
            return false;
        }
        return this._byname.containsKey(name);
    }

    public boolean isTypeBound(String type) {
        if (type == null) {
            return false;
        }
        return this._bytype.containsKey(type);
    }
}

