/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.proxy;

import com.jayway.restassured.RestAssured;
import org.hamcrest.CoreMatchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.infrastructure.deployment.AbstractFakeMuleServerTestCase;

public class MultipleProxyTestCase
extends AbstractFakeMuleServerTestCase {
    private static final int PROXIES_COUNT = 2;
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public DynamicPort proxyPort = new DynamicPort("proxyPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    public void setUp() throws Exception {
        super.setUp();
        RestAssured.port = this.proxyPort.getNumber();
    }

    @Test
    public void proxy() throws Exception {
        this.muleServer.deployAppFromClasspathFolder("org/mule/module/apikit/proxy/proxied-app", "proxied");
        this.muleServer.start();
        this.muleServer.deployAppFromClasspathFolder("org/mule/module/apikit/proxy/app-multiple", "proxy");
        this.muleServer.assertDeploymentSuccess("proxy");
        for (int count = 1; count <= 2; ++count) {
            this.getOnLeaguesJson(count);
        }
    }

    private void getOnLeaguesJson(int proxy) throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().body("name", JUnitMatchers.hasItems((Object[])new String[]{"Liga BBVA", "Premiere League"}), new Object[0]).header("Content-type", CoreMatchers.containsString((String)"application/json")).statusCode(200).when().get("/proxy" + proxy + "/leagues", new Object[0]);
    }
}

