/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.parameters;

import com.jayway.restassured.RestAssured;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.construct.Flow;
import org.mule.module.apikit.Configuration;
import org.mule.module.http.internal.listener.DefaultHttpListener;
import org.mule.module.http.internal.listener.DefaultHttpListenerConfig;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class BaseUriParametersTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    private Configuration config;

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    @Before
    public void setupConfig() throws InitialisationException {
        DefaultHttpListenerConfig listenerConfig = (DefaultHttpListenerConfig)Mockito.mock(DefaultHttpListenerConfig.class);
        Mockito.when((Object)listenerConfig.getHost()).thenReturn((Object)"localhost");
        Mockito.when((Object)listenerConfig.getPort()).thenReturn((Object)8080);
        Mockito.when((Object)listenerConfig.getTlsContext()).thenReturn(null);
        DefaultHttpListener listener = (DefaultHttpListener)Mockito.mock(DefaultHttpListener.class);
        Mockito.when((Object)listener.getConfig()).thenReturn((Object)listenerConfig);
        Mockito.when((Object)listener.getPath()).thenReturn((Object)"api");
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.getMessageSource()).thenReturn((Object)listener);
        this.config = new Configuration();
        this.config.setMuleContext(muleContext);
        this.config.setRaml("org/mule/module/apikit/parameters/baseuri-parameters.yaml");
        this.config.initialise();
        this.config.loadApiDefinition((FlowConstruct)flow);
    }

    @Test
    public void noBaseUriParameters() throws Exception {
        IRaml api = this.config.getApi();
        Assert.assertThat((Object)api.getBaseUriParameters().size(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)api.getResource("/resources").getBaseUriParameters().size(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)api.getResource("/resources").getAction("get").getBaseUriParameters().size(), (Matcher)Matchers.is((Object)0));
    }
}

