/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.jayway.restassured.RestAssured;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class ConfigurationTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPortDefault = new DynamicPort("serverPortDefault");
    @Rule
    public DynamicPort serverPortCustom = new DynamicPort("serverPortCustom");
    @Rule
    public DynamicPort serverPortNoConsole = new DynamicPort("serverPortNoConsole");
    @Rule
    public DynamicPort serverPortMapping = new DynamicPort("serverPortMapping");
    @Rule
    public DynamicPort serverPortNoValidations = new DynamicPort("serverPortNoValidations");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/config/configuration-test-config.xml";
    }

    @Test
    public void resourceOnDefaultConfig() throws Exception {
        RestAssured.port = this.serverPortDefault.getNumber();
        RestAssured.given().header("Accept", (Object)"text/plain", new Object[0]).expect().response().body(CoreMatchers.is((Object)"some resources"), new Matcher[0]).statusCode(200).when().get("/default/resource", new Object[0]);
    }

    @Test
    public void consoleOnDefaultConfig() throws Exception {
        RestAssured.port = this.serverPortDefault.getNumber();
        RestAssured.given().header("Accept", (Object)"text/html", new Object[0]).expect().response().body(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"<title>API Console</title>"), (Matcher)CoreMatchers.containsString((String)"src=\"./?\"")), new Matcher[0]).header("Content-type", "text/html").statusCode(200).when().get("/default/console/", new Object[0]);
    }

    @Test
    public void consoleResourceOnDefaultConfig() throws Exception {
        RestAssured.port = this.serverPortDefault.getNumber();
        RestAssured.given().header("Accept", (Object)"text/css", new Object[0]).expect().response().body(CoreMatchers.containsString((String)".CodeMirror"), new Matcher[0]).header("Content-type", "text/css").statusCode(200).when().get("/default/console/styles/api-console-light-theme.css", new Object[0]);
    }

    @Test
    public void resourceOnCustomConsolePathConfig() throws Exception {
        RestAssured.port = this.serverPortCustom.getNumber();
        RestAssured.given().expect().response().body(CoreMatchers.is((Object)"some resources"), new Matcher[0]).statusCode(200).when().get("/custom/resource", new Object[0]);
    }

    @Test
    public void resourceOnExplicitMappingConfig() throws Exception {
        RestAssured.port = this.serverPortMapping.getNumber();
        RestAssured.given().expect().response().body(CoreMatchers.is((Object)"explicitely mapped flow"), new Matcher[0]).statusCode(200).when().get("/mapping/resource", new Object[0]);
    }

    @Test
    public void consoleOnCustomConsolePathConfig() throws Exception {
        RestAssured.port = this.serverPortCustom.getNumber();
        RestAssured.given().header("Accept", (Object)"text/html", new Object[0]).expect().response().body(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"<title>API Console</title>"), (Matcher)CoreMatchers.containsString((String)"src=\"./?\"")), new Matcher[0]).header("Content-type", "text/html").statusCode(200).when().get("/custom/custom/", new Object[0]);
    }

    @Test
    public void consoleResourceOnCustomConsolePathConfig() throws Exception {
        RestAssured.port = this.serverPortCustom.getNumber();
        RestAssured.given().header("Accept", (Object)"text/css", new Object[0]).expect().response().body(CoreMatchers.containsString((String)".CodeMirror"), new Matcher[0]).header("Content-type", "text/css").statusCode(200).when().get("/custom/custom/styles/api-console-light-theme.css", new Object[0]);
    }

    @Test
    public void resourceOnNoConsoleConfig() throws Exception {
        RestAssured.port = this.serverPortNoConsole.getNumber();
        RestAssured.given().expect().response().body(CoreMatchers.is((Object)"some resources"), new Matcher[0]).statusCode(200).when().get("/no-console/resource", new Object[0]);
    }

    @Test
    public void consoleOnNoConsoleConfig() throws Exception {
        RestAssured.port = this.serverPortNoConsole.getNumber();
        RestAssured.given().header("Accept", (Object)"text/html", new Object[0]).expect().response().body(CoreMatchers.containsString((String)"resource not found"), new Matcher[0]).statusCode(404).when().get("/no-console/console/", new Object[0]);
    }

    @Test
    public void patch() throws Exception {
        RestAssured.port = this.serverPortDefault.getNumber();
        RestAssured.given().expect().statusCode(204).when().patch("/default/resource", new Object[0]);
    }

    @Test
    public void enableValidations() {
        RestAssured.port = this.serverPortDefault.getNumber();
        RestAssured.given().contentType("application/x-www-form-urlencoded").header("must", (Object)"true", new Object[0]).formParam("must", new Object[]{"true"}).expect().response().body(CoreMatchers.containsString((String)"no validations performed"), new Matcher[0]).statusCode(200).when().put("/default/forgiving/one?must=true", new Object[0]);
    }

    @Test
    public void disableValidations() {
        RestAssured.port = this.serverPortNoValidations.getNumber();
        RestAssured.given().contentType("application/x-www-form-urlencoded").formParam("one", new Object[]{"true"}).expect().response().body(CoreMatchers.containsString((String)"no validations performed"), new Matcher[0]).statusCode(200).when().put("/no-validations/forgiving/any", new Object[0]);
    }
}

