/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.module.apikit.AbstractConfiguration;
import org.mule.module.apikit.Configuration;
import org.mule.module.apikit.HttpRestRequest;
import org.mule.transformer.types.DataTypeFactory;
import org.raml.model.ActionType;

public class RamlDescriptorHandler {
    private AbstractConfiguration config;

    public RamlDescriptorHandler(AbstractConfiguration config) {
        this.config = config;
    }

    public boolean handles(HttpRestRequest request) {
        String path = request.getResourcePath();
        return this.isValidPath(path) && ActionType.GET.toString().equals(request.getMethod().toUpperCase()) && request.getAdapter().getAcceptableResponseMediaTypes().contains("application/raml+yaml");
    }

    public MuleEvent processConsoleRequest(MuleEvent event) throws MuleException {
        return this.process(event, this.config.getApikitRamlConsole(event));
    }

    public MuleEvent processRouterRequest(MuleEvent event) throws MuleException {
        return this.process(event, this.config.getApikitRaml(event));
    }

    private MuleEvent process(MuleEvent event, String raml) throws MuleException {
        event.getMessage().setPayload((Object)raml, DataTypeFactory.create(String.class, (String)"application/raml+yaml"));
        event.getMessage().setOutboundProperty("Content-Type", (Object)"application/raml+yaml");
        event.getMessage().setOutboundProperty("Expires", (Object)-1);
        event.getMessage().setOutboundProperty("Content-Length", (Object)raml.length());
        event.getMessage().setOutboundProperty("Access-Control-Allow-Origin", (Object)"*");
        return event;
    }

    private boolean isValidPath(String path) {
        if (this.config instanceof Configuration && ((Configuration)this.config).isConsoleEnabled() && path.equals("/" + ((Configuration)this.config).getConsolePath())) {
            return true;
        }
        return path.equals(this.config.getApi().getUri());
    }
}

