/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.transform;

import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.transform.ApikitResponseTransformer;
import org.mule.module.apikit.transform.DataTypePair;
import org.mule.module.apikit.transform.TransformerCache;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.SimpleDataType;
import org.mule.transport.NullPayload;
import org.raml.model.MimeType;

public class ApikitResponseTransformerTestCase {
    private ApikitResponseTransformer responseTransformer = new ApikitResponseTransformer();
    @Mock
    private MuleMessage message;
    @Mock
    private MuleContext muleContext;
    @Mock
    private MuleRegistry muleRegistry;
    @Mock
    private LoadingCache<DataTypePair, Transformer> transformerCache;
    @Mock
    private Transformer transformer;

    @Before
    public void setUp() throws ExecutionException, RegistrationException {
        MockitoAnnotations.initMocks((Object)this);
        this.responseTransformer.setMuleContext(this.muleContext);
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)this.muleRegistry);
        Mockito.when((Object)this.muleContext.getRegistry().get("__restRouterTransformerCache")).thenReturn(this.transformerCache);
    }

    @Test
    public void jsonRAMLJsonAccept() throws TransformerException {
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)"{application/json;charset=UTF-8}");
        Mockito.when((Object)this.message.getDataType()).thenReturn((Object)new SimpleDataType(String.class, "application/json"));
        Mockito.when((Object)this.message.getEncoding()).thenReturn((Object)"UTF-8");
        ArrayList<MimeType> responseMimeType = new ArrayList<MimeType>();
        responseMimeType.add(new MimeType("application/json"));
        Object responsePayload = this.responseTransformer.transformToExpectedContentType(this.message, "application/json", responseMimeType, "application/json");
        Assert.assertNotNull((Object)responsePayload);
        Assert.assertThat((Object)responsePayload, (Matcher)Matchers.instanceOf(String.class));
        Assert.assertEquals((Object)"{application/json;charset=UTF-8}", (Object)responsePayload);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.transformerCache});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.transformer});
    }

    @Test
    public void jsonRAMLJsonAcceptContentXml() throws TransformerException {
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)"{application/json;charset=UTF-8}");
        Mockito.when((Object)this.message.getDataType()).thenReturn((Object)new SimpleDataType(String.class, "application/json"));
        Mockito.when((Object)this.message.getEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)this.message.getOutboundProperty("Content-Type")).thenReturn((Object)"application/xml");
        ArrayList<MimeType> responseMimeType = new ArrayList<MimeType>();
        responseMimeType.add(new MimeType("application/json"));
        Object responsePayload = this.responseTransformer.transformToExpectedContentType(this.message, "application/json", responseMimeType, "application/json");
        Assert.assertNotNull((Object)responsePayload);
        Assert.assertThat((Object)responsePayload, (Matcher)Matchers.instanceOf(String.class));
        Assert.assertEquals((Object)"{application/json;charset=UTF-8}", (Object)responsePayload);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.transformerCache});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.transformer});
    }

    @Test
    public void jsonRAMLJsonAcceptContentJson() throws TransformerException {
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)"{application/json;charset=UTF-8}");
        Mockito.when((Object)this.message.getDataType()).thenReturn((Object)new SimpleDataType(String.class, "application/json"));
        Mockito.when((Object)this.message.getEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)this.message.getOutboundProperty("Content-Type")).thenReturn((Object)"application/json");
        ArrayList<MimeType> responseMimeType = new ArrayList<MimeType>();
        responseMimeType.add(new MimeType("application/json"));
        Object responsePayload = this.responseTransformer.transformToExpectedContentType(this.message, "application/json", responseMimeType, "application/json");
        Assert.assertNotNull((Object)responsePayload);
        Assert.assertThat((Object)responsePayload, (Matcher)Matchers.instanceOf(String.class));
        Assert.assertEquals((Object)"{application/json;charset=UTF-8}", (Object)responsePayload);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.transformerCache});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.transformer});
    }

    @Test
    public void xmlRAMLJsonAccept() throws TransformerException, RegistrationException, ExecutionException {
        String payload = "{application/xml;charset=UTF-8}";
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)payload);
        Mockito.when((Object)this.message.getDataType()).thenReturn((Object)new SimpleDataType(String.class, "application/xml"));
        Mockito.when((Object)this.message.getEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)TransformerCache.getTransformerCache((MuleContext)this.muleContext)).thenReturn(this.transformerCache);
        Mockito.when((Object)this.transformerCache.get(Mockito.isA(DataTypePair.class))).thenReturn((Object)this.transformer);
        ArrayList<MimeType> responseMimeType = new ArrayList<MimeType>();
        responseMimeType.add(new MimeType("application/json"));
        Object responsePayload = this.responseTransformer.transformToExpectedContentType(this.message, "application/xml", responseMimeType, "application/json");
        Assert.assertNull((Object)responsePayload);
        ((Transformer)Mockito.verify((Object)this.transformer)).transform((Object)payload);
    }

    @Test
    public void jsonRAMLXmlAccept() throws TransformerException, RegistrationException, ExecutionException {
        String payload = "{application/json;charset=UTF-8}";
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)payload);
        Mockito.when((Object)this.message.getDataType()).thenReturn((Object)new SimpleDataType(String.class, "application/xml"));
        Mockito.when((Object)this.message.getEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)TransformerCache.getTransformerCache((MuleContext)this.muleContext)).thenReturn(this.transformerCache);
        Mockito.when((Object)this.transformerCache.get(Mockito.isA(DataTypePair.class))).thenReturn((Object)this.transformer);
        ArrayList<MimeType> responseMimeType = new ArrayList<MimeType>();
        responseMimeType.add(new MimeType("application/json"));
        Object responsePayload = this.responseTransformer.transformToExpectedContentType(this.message, "application/xml", responseMimeType, "application/xml");
        Assert.assertNull((Object)responsePayload);
        ((Transformer)Mockito.verify((Object)this.transformer)).transform((Object)payload);
    }

    @Test
    public void contentJsonMsgNull() throws TransformerException, RegistrationException, ExecutionException {
        String payload = "{application/json;charset=UTF-8}";
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)payload);
        Mockito.when((Object)this.message.getDataType()).thenReturn(null);
        Mockito.when((Object)this.message.getEncoding()).thenReturn(null);
        Mockito.when((Object)this.message.getOutboundProperty("Content-Type")).thenReturn((Object)"application/json");
        Mockito.when((Object)TransformerCache.getTransformerCache((MuleContext)this.muleContext)).thenReturn(this.transformerCache);
        Mockito.when((Object)this.transformerCache.get(Mockito.isA(DataTypePair.class))).thenReturn((Object)this.transformer);
        ArrayList<MimeType> responseMimeType = new ArrayList<MimeType>();
        responseMimeType.add(new MimeType("application/json"));
        Object responsePayload = this.responseTransformer.transformToExpectedContentType(this.message, "application/json", responseMimeType, "application/json");
        Assert.assertNotNull((Object)payload);
        Assert.assertThat((Object)payload, (Matcher)Matchers.instanceOf(String.class));
        Assert.assertEquals((Object)"{application/json;charset=UTF-8}", (Object)responsePayload);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.transformerCache});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.transformer});
    }

    @Test(expected=ApikitRuntimeException.class)
    public void nullResponseRepresentationContentTypeNull() throws TransformerException {
        try {
            this.responseTransformer.transformToExpectedContentType(this.message, "*/*", null, "application/json");
        }
        catch (ApikitRuntimeException e) {
            Assert.assertEquals((Object)"Content-Type must be set in the flow when declaring */* response type", (Object)e.getMessage());
            throw e;
        }
    }

    @Test
    public void nullResponseRepresentationContentTypeNotNull() throws TransformerException {
        String payload = "{application/json;charset=UTF-8}";
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)payload);
        Mockito.when((Object)this.message.getOutboundProperty("Content-Type")).thenReturn((Object)"application/xml");
        Object responsePayload = this.responseTransformer.transformToExpectedContentType(this.message, "*/*", null, "application/json");
        Assert.assertNotNull((Object)payload);
        Assert.assertThat((Object)payload, (Matcher)Matchers.instanceOf(String.class));
        Assert.assertEquals((Object)"{application/json;charset=UTF-8}", (Object)responsePayload);
    }

    @Test
    public void nullPayload() throws TransformerException {
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)NullPayload.getInstance());
        Object responsePayload = this.responseTransformer.transformToExpectedContentType(this.message, "**/*//*", null, "application/json");
        Assert.assertTrue((boolean)(responsePayload instanceof NullPayload));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.transformerCache});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.transformer});
    }

    @Test
    public void transformerException() throws TransformerException, ExecutionException, RegistrationException {
        String payload = "{application/json;charset=UTF-8}";
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)payload);
        Mockito.when((Object)this.message.getDataType()).thenReturn((Object)new SimpleDataType(String.class, "application/xml"));
        Mockito.when((Object)this.message.getEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)TransformerCache.getTransformerCache((MuleContext)this.muleContext)).thenReturn(this.transformerCache);
        Mockito.when((Object)this.transformerCache.get(Mockito.isA(DataTypePair.class))).thenReturn((Object)this.transformer);
        Mockito.when((Object)this.transformer.transform(this.message.getPayload())).thenThrow(new Throwable[]{new NullPointerException()});
        ArrayList<MimeType> responseMimeType = new ArrayList<MimeType>();
        responseMimeType.add(new MimeType("application/json"));
        Object responsePayload = null;
        try {
            responsePayload = this.responseTransformer.transformToExpectedContentType(this.message, "application/xml", responseMimeType, "application/xml");
            Assert.assertTrue((String)"Expected exception not thrown", (boolean)false);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof TransformerException));
        }
        ((Transformer)Mockito.verify((Object)this.transformer)).transform((Object)payload);
        Assert.assertNull((Object)responsePayload);
    }

    @Test
    public void compoundAcceptOnlyJson() throws TransformerException {
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)"{application/json;charset=UTF-8}");
        Mockito.when((Object)this.message.getDataType()).thenReturn((Object)new SimpleDataType(String.class, "application/json"));
        Mockito.when((Object)this.message.getEncoding()).thenReturn((Object)"UTF-8");
        ArrayList<MimeType> responseMimeType = new ArrayList<MimeType>();
        responseMimeType.add(new MimeType("application/json"));
        Object responsePayload = this.responseTransformer.transformToExpectedContentType(this.message, "application/json", responseMimeType, "application/json,application/xml;q=0.9,*/*;q=0.8;charset=UTF-8");
        Assert.assertNotNull((Object)responsePayload);
        Assert.assertThat((Object)responsePayload, (Matcher)Matchers.instanceOf(String.class));
        Assert.assertEquals((Object)"{application/json;charset=UTF-8}", (Object)responsePayload);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.transformerCache});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.transformer});
    }

    @Test
    public void compoundAcceptOnlyXml() throws TransformerException {
        String payload = "{application/xml;charset=UTF-8}";
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)payload);
        Mockito.when((Object)this.message.getDataType()).thenReturn((Object)new SimpleDataType(String.class, "application/xml"));
        Mockito.when((Object)this.message.getEncoding()).thenReturn((Object)"UTF-8");
        ArrayList<MimeType> responseMimeType = new ArrayList<MimeType>();
        responseMimeType.add(new MimeType("application/xml"));
        Object responsePayload = this.responseTransformer.transformToExpectedContentType(this.message, "application/xml", responseMimeType, "application/json,application/xml;q=0.9,*/*;q=0.8;charset=UTF-8");
        Assert.assertNotNull((Object)responsePayload);
        Assert.assertThat((Object)responsePayload, (Matcher)Matchers.instanceOf(String.class));
        Assert.assertEquals((Object)"{application/xml;charset=UTF-8}", (Object)responsePayload);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.transformerCache});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.transformer});
    }

    @Test
    public void compoundAcceptOnlyOther() throws TransformerException, ExecutionException {
        String payload = "application/json;charset=UTF-8";
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)payload);
        Mockito.when((Object)this.message.getDataType()).thenReturn((Object)new SimpleDataType(String.class, "application/json"));
        Mockito.when((Object)this.message.getEncoding()).thenReturn((Object)"UTF-8");
        ArrayList<MimeType> responseMimeType = new ArrayList<MimeType>();
        responseMimeType.add(new MimeType("text/plain"));
        DataType sourceDataType = DataTypeFactory.create(String.class, (String)"application/json;charset=UTF-8");
        DataType resultDataType = DataTypeFactory.create(String.class, (String)"*/*");
        Mockito.when((Object)this.transformerCache.get(Mockito.isA(DataTypePair.class))).thenThrow(new Throwable[]{new ExecutionException((Throwable)new TransformerException(CoreMessages.noTransformerFoundForMessage((DataType)sourceDataType, (DataType)resultDataType)))});
        Object responsePayload = null;
        try {
            responsePayload = this.responseTransformer.transformToExpectedContentType(this.message, null, responseMimeType, "application/json,application/xml;q=0.9,*/*;q=0.8;charset=UTF-8");
            Assert.assertTrue((String)"Expected exception not thrown", (boolean)false);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof TransformerException));
        }
        Assert.assertNull(responsePayload);
    }
}

