/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.leagues;

import com.jayway.restassured.RestAssured;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hamcrest.CoreMatchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.mule.module.apikit.util.RegexMatcher;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

public class LeaguesTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/leagues/leagues-base-flow-config.xml, org/mule/module/apikit/leagues/leagues-http-flow-config.xml";
    }

    @Test
    public void resourceNotFound() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().statusCode(404).body(CoreMatchers.is((Object)"resource not found"), new org.hamcrest.Matcher[0]).when().get("/api/matches", new Object[0]);
    }

    @Test
    public void methodNotAllowed() throws Exception {
        RestAssured.expect().response().statusCode(405).body(CoreMatchers.is((Object)"method not allowed"), new org.hamcrest.Matcher[0]).when().delete("/api/leagues", new Object[0]);
    }

    @Test
    public void unsupportedMediaType() throws Exception {
        RestAssured.given().body("Liga Criolla").contentType("text/plain").expect().response().statusCode(415).body(CoreMatchers.is((Object)"unsupported media type"), new org.hamcrest.Matcher[0]).when().post("/api/leagues", new Object[0]);
    }

    @Test
    public void notAcceptable() throws Exception {
        RestAssured.given().header("Accept", (Object)"text/plain", new Object[0]).expect().response().statusCode(406).body(CoreMatchers.is((Object)"not acceptable"), new org.hamcrest.Matcher[0]).when().get("/api/leagues", new Object[0]);
    }

    @Test
    public void badRequestJson() throws Exception {
        RestAssured.given().body("{\"liga\": \"Criolla\"}").contentType("application/json").expect().response().statusCode(400).body(CoreMatchers.is((Object)"bad request"), new org.hamcrest.Matcher[0]).when().post("/api/leagues", new Object[0]);
    }

    @Test
    public void badRequestXml() throws Exception {
        RestAssured.given().body("<leaguee xmlns=\"http://mulesoft.com/schemas/soccer\"><name>MLS</name></leaguee>").contentType("text/xml").expect().response().statusCode(400).body(CoreMatchers.is((Object)"bad request"), new org.hamcrest.Matcher[0]).when().post("/api/leagues", new Object[0]);
    }

    @Test
    public void getOnLeaguesJson() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().body("leagues.name", JUnitMatchers.hasItems((Object[])new String[]{"Liga BBVA", "Premier League"}), new Object[0]).header("Content-type", "application/json").statusCode(200).when().get("/api/leagues", new Object[0]);
    }

    @Test
    public void getOnLeaguesJsonTrailingSlash() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().body("leagues.name", JUnitMatchers.hasItems((Object[])new String[]{"Liga BBVA", "Premier League"}), new Object[0]).header("Content-type", "application/json").statusCode(200).when().get("/api/leagues/", new Object[0]);
    }

    @Test
    public void getOnLeaguesXml() throws Exception {
        RestAssured.given().header("Accept", (Object)"text/xml", new Object[0]).expect().response().body("leagues.league.name", JUnitMatchers.hasItems((Object[])new String[]{"Liga BBVA", "Premier League"}), new Object[0]).header("Content-type", "text/xml").statusCode(200).when().get("/api/leagues", new Object[0]);
    }

    @Test
    public void postOnLeaguesJson() throws Exception {
        RestAssured.given().body("{ \"name\": \"Major League Soccer\" }").contentType("application/json").expect().statusCode(201).header("Location", "http://localhost:" + this.serverPort.getValue() + "/api/leagues/4").body(CoreMatchers.is((Object)""), new org.hamcrest.Matcher[0]).header("Content-Length", "0").when().post("/api/leagues", new Object[0]);
    }

    @Test
    public void postOnLeaguesXml() throws Exception {
        RestAssured.given().body("<league xmlns=\"http://mulesoft.com/schemas/soccer\"><name>MLS</name></league>").contentType("text/xml").expect().statusCode(201).header("Location", "http://localhost:" + this.serverPort.getValue() + "/api/leagues/4").when().post("/api/leagues", new Object[0]);
    }

    @Test
    public void postOnLeaguesXmlWindows1252() throws Exception {
        InputStream inputStrem = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/mule/module/apikit/leagues/league-windows1252.xml");
        String body = IOUtils.toString((InputStream)inputStrem, (String)"windows-1252");
        Matcher matcher = Pattern.compile(".*<description>(.*)</description>.*").matcher(body);
        matcher.find();
        String responseBody = matcher.group(1);
        RestAssured.given().body(body).contentType("text/xml;charset=windows-1252").header("Accept", (Object)"text/plain", new Object[0]).expect().statusCode(201).body(CoreMatchers.is((Object)responseBody), new org.hamcrest.Matcher[0]).header("Location", "http://localhost:" + this.serverPort.getValue() + "/api/leagues/4").when().post("/api/leagues", new Object[0]);
    }

    @Test
    public void postCustomStatus() throws Exception {
        RestAssured.given().body("{ \"name\": \"(invlid name)\" }").contentType("application/json").expect().statusCode(400).body(CoreMatchers.is((Object)"Invalid League Name"), new org.hamcrest.Matcher[0]).when().post("/api/leagues", new Object[0]);
    }

    @Test
    public void getOnSingleLeagueJson() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().body("name", CoreMatchers.is((Object)"Liga BBVA"), new Object[0]).header("Content-type", "application/json").statusCode(200).when().get("/api/leagues/liga-bbva", new Object[0]);
    }

    @Test
    public void getOnSingleLeagueXml() throws Exception {
        RestAssured.given().header("Accept", (Object)"text/xml", new Object[0]).expect().response().body("league.name", CoreMatchers.is((Object)"Liga BBVA"), new Object[0]).header("Content-type", "text/xml").statusCode(200).when().get("/api/leagues/liga-bbva", new Object[0]);
    }

    @Test
    public void putOnSingleLeagueJson() throws Exception {
        RestAssured.given().body("{ \"name\": \"Liga Hispanica\" }").contentType("application/json").expect().statusCode(204).body(CoreMatchers.is((Object)""), new org.hamcrest.Matcher[0]).when().put("/api/leagues/liga-bbva", new Object[0]);
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().body("leagues.name", JUnitMatchers.hasItems((Object[])new String[]{"Liga Hispanica", "Premier League"}), new Object[0]).header("Content-type", "application/json").statusCode(200).when().get("/api/leagues", new Object[0]);
    }

    @Test
    public void putOnSingleLeagueXml() throws Exception {
        RestAssured.given().body("<league xmlns=\"http://mulesoft.com/schemas/soccer\"><name>Hispanic League</name></league>").contentType("text/xml").expect().statusCode(204).body(CoreMatchers.is((Object)""), new org.hamcrest.Matcher[0]).when().put("/api/leagues/liga-bbva", new Object[0]);
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().body("leagues.name", JUnitMatchers.hasItems((Object[])new String[]{"Hispanic League", "Premier League"}), new Object[0]).header("Content-type", "application/json").statusCode(200).when().get("/api/leagues", new Object[0]);
    }

    @Test
    public void putCustomStatus() throws Exception {
        RestAssured.given().body("{ \"name\": \"(invlid name)\" }").contentType("application/json").expect().statusCode(400).body(CoreMatchers.is((Object)""), new org.hamcrest.Matcher[0]).when().put("/api/leagues/liga-bbva", new Object[0]);
    }

    @Test
    public void putMultiPartFormData() throws Exception {
        RestAssured.given().multiPart("description", "Barcelona Badge").multiPart("image", "bbva.jpg", ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/mule/module/apikit/leagues/bbva.jpg")).expect().statusCode(200).body("upload", CoreMatchers.is((Object)"OK"), new Object[0]).when().put("/api/leagues/liga-bbva/badge", new Object[0]);
    }

    @Test
    public void deleteOnSingleLeague() throws Exception {
        RestAssured.expect().response().statusCode(204).body(CoreMatchers.is((Object)""), new org.hamcrest.Matcher[0]).when().delete("/api/leagues/liga-bbva", new Object[0]);
    }

    @Test
    public void uriParamMaxLenError() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().body(CoreMatchers.is((Object)"bad request"), new org.hamcrest.Matcher[0]).statusCode(400).when().get("/api/leagues/a-name-long-enough-not-to-be-valid", new Object[0]);
    }

    @Test
    public void uriParamPatternError() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().body(CoreMatchers.is((Object)"bad request"), new org.hamcrest.Matcher[0]).statusCode(400).when().get("/api/leagues/invalid_name", new Object[0]);
    }

    @Test
    public void getTeamsQueryParams() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().body("name", JUnitMatchers.hasItems((Object[])new String[]{"Barcelona", "Real Madrid", "Valencia", "Athletic Bilbao", "Atletico Madrid"}), new Object[0]).header("Content-type", "application/json").header("preferred-team", "BCN").statusCode(200).when().get("/api/leagues/liga-bbva/teams", new Object[0]);
    }

    @Test
    public void getTeamsHeaderCaseInsensitive() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).header("Preferred", (Object)"RMD", new Object[0]).expect().response().body("name", JUnitMatchers.hasItems((Object[])new String[]{"Barcelona", "Real Madrid", "Valencia", "Athletic Bilbao", "Atletico Madrid"}), new Object[0]).header("Content-type", "application/json").header("preferred-team", "RMD").statusCode(200).when().get("/api/leagues/liga-bbva/teams", new Object[0]);
    }

    @Test
    public void getTeamsQueryParamsOffset3() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().body("name", CoreMatchers.allOf((org.hamcrest.Matcher)JUnitMatchers.hasItems((Object[])new String[]{"Athletic Bilbao", "Atletico Madrid"}), (org.hamcrest.Matcher)CoreMatchers.not((org.hamcrest.Matcher)JUnitMatchers.hasItem((Object)"Barcelona")), (org.hamcrest.Matcher)CoreMatchers.not((org.hamcrest.Matcher)JUnitMatchers.hasItem((Object)"Real Madrid")), (org.hamcrest.Matcher)CoreMatchers.not((org.hamcrest.Matcher)JUnitMatchers.hasItem((Object)"Valencia"))), new Object[0]).header("Content-type", "application/json").statusCode(200).when().get("/api/leagues/liga-bbva/teams?offset=3", new Object[0]);
    }

    @Test
    public void getTeamsQueryParamsMinimumError() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().body(CoreMatchers.is((Object)"bad request"), new org.hamcrest.Matcher[0]).statusCode(400).when().get("/api/leagues/liga-bbva/teams?offset=-1", new Object[0]);
    }

    @Test
    public void getTeamsQueryParamsMaximumError() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().body(CoreMatchers.is((Object)"bad request"), new org.hamcrest.Matcher[0]).statusCode(400).when().get("/api/leagues/liga-bbva/teams?limit=11", new Object[0]);
    }

    @Test
    public void getRaml() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/raml+yaml", new Object[0]).expect().response().body((org.hamcrest.Matcher)RegexMatcher.matches("(?s).*baseUri: \"http://[localhost0-9.]+:" + RestAssured.port + "/api\".*"), new org.hamcrest.Matcher[0]).header("Content-type", "application/raml+yaml").statusCode(200).when().get("/api", new Object[0]);
    }

    @Test
    public void getRamlWrongContentType() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().body(CoreMatchers.containsString((String)"resource not found"), new org.hamcrest.Matcher[0]).statusCode(404).when().get("/api", new Object[0]);
    }

    @Test
    public void console() throws Exception {
        RestAssured.given().header("Accept", (Object)"text/html", new Object[0]).expect().response().body(CoreMatchers.allOf((org.hamcrest.Matcher)CoreMatchers.containsString((String)"<title>API Console</title>"), (org.hamcrest.Matcher)RegexMatcher.matches("(?s).*src=\"http://[localhost0-9.]+:" + RestAssured.port + "/api/\".*")), new org.hamcrest.Matcher[0]).header("Content-type", "text/html").statusCode(200).when().get("/api/console/index.html", new Object[0]);
    }

    @Test
    public void consoleDirectory() throws Exception {
        RestAssured.given().header("Accept", (Object)"text/html", new Object[0]).expect().response().body(CoreMatchers.allOf((org.hamcrest.Matcher)CoreMatchers.containsString((String)"<title>API Console</title>"), (org.hamcrest.Matcher)RegexMatcher.matches("(?s).*src=\"http://[localhost0-9.]+:" + RestAssured.port + "/api/\".*")), new org.hamcrest.Matcher[0]).header("Content-type", "text/html").statusCode(200).when().get("/api/console/", new Object[0]);
    }

    @Test
    public void consoleDirectoryNoSlash() throws Exception {
        RestAssured.given().redirects().follow(false).header("Accept", (Object)"text/html", new Object[0]).expect().response().statusCode(301).header("Location", "http://localhost:" + this.serverPort.getValue() + "/api/console/").when().get("/api/console", new Object[0]);
    }

    @Test
    public void getAnyResponse() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().body("name", CoreMatchers.is((Object)"Liga BBVA"), new Object[0]).header("Content-type", "application/json").statusCode(200).when().get("/api/leagues/liga-bbva/badge", new Object[0]);
    }

    @Test
    public void getDefaultResponseCode() throws Exception {
        RestAssured.given().expect().response().statusCode(200).when().get("/api/leagues/liga-bbva/teams/leader", new Object[0]);
    }

    @Test
    public void resolveTemplateWithSpecialChars() throws Exception {
        RestAssured.given().expect().response().statusCode(200).when().get("/api/leagues/league+one", new Object[0]);
    }
}

