/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.apikit.Configuration;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.uri.URIPattern;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.raml.model.Action;
import org.raml.model.Resource;
import org.raml.model.SecurityReference;
import org.raml.model.parameter.Header;
import org.raml.model.parameter.QueryParameter;

public class ApiUpdateTestCase
extends AbstractMuleContextTestCase {
    private static final String METHOD_GET = "get";
    private static final String RESOURCE_LEAGUES = "/leagues";
    private static final String GET_LEAGUES = "get:/leagues";
    private static final String RESOURCE_ORDERS = "/orders";
    private static final String GET_ORDERS = "get:/orders";
    private Configuration config;
    private String traitName = "secured";
    private String traitYaml = "usage: Apply this to any method that needs to be secured\ndescription: Some requests require authentication.\nheaders:\n  injected:\n    displayName: injected\n    required: true\nqueryParameters:\n  access_token:\n    description: Access Token\n    type: string\n    example: ACCESS_TOKEN\n    required: true";

    private void setupConfig(String yamlPath) throws InitialisationException {
        this.config = new Configuration();
        this.config.setMuleContext(muleContext);
        this.config.setRaml("org/mule/module/apikit/" + yamlPath);
        this.config.initialise();
    }

    @Before
    public void setupConfigWithTraits() throws InitialisationException {
        this.setupConfig("leagues/leagues.yaml");
    }

    private void setupConfigWithoutTraits() throws InitialisationException {
        this.setupConfig("pathless/pathless.yaml");
    }

    @Test
    public void addAndRemoveTrait() throws InitialisationException {
        this.assertInitialStateWithTraits();
        this.config.getRamlUpdater().injectTrait(this.traitName, this.traitYaml).applyTrait(this.traitName, new String[]{GET_LEAGUES}).resetAndUpdate();
        Assert.assertThat((Object)this.config.getApi().getTraits().size(), (Matcher)CoreMatchers.is((Object)2));
        this.assertTraitInjected(this.config.getApi().getResource(RESOURCE_LEAGUES).getAction(METHOD_GET));
        this.assertTraitInjected(((Resource)this.config.routingTable.get(new URIPattern(RESOURCE_LEAGUES))).getAction(METHOD_GET));
        this.config.getRamlUpdater().reset();
        this.assertInitialStateWithTraits();
    }

    private void assertTraitInjected(Action action) {
        Assert.assertThat((Object)action.getIs().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(action.getIs().get(0), (Matcher)CoreMatchers.is((Object)this.traitName));
        Assert.assertThat((Object)action.getHeaders().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Header)action.getHeaders().get("injected")).getDisplayName(), (Matcher)CoreMatchers.is((Object)"injected"));
        Assert.assertThat((Object)action.getQueryParameters().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((QueryParameter)action.getQueryParameters().get("access_token")).getDescription(), (Matcher)CoreMatchers.is((Object)"Access Token"));
    }

    @Test
    public void addAndRemoveFirstTrait() throws InitialisationException {
        this.setupConfigWithoutTraits();
        this.assertInitialStateWithoutTraits();
        this.config.getRamlUpdater().injectTrait(this.traitName, this.traitYaml).applyTrait(this.traitName, new String[]{GET_ORDERS}).resetAndUpdate();
        Assert.assertThat((Object)this.config.getApi().getTraits().size(), (Matcher)CoreMatchers.is((Object)1));
        this.assertTraitInjected(this.config.getApi().getResource(RESOURCE_ORDERS).getAction(METHOD_GET));
        this.assertTraitInjected(((Resource)this.config.routingTable.get(new URIPattern(RESOURCE_ORDERS))).getAction(METHOD_GET));
        this.config.getRamlUpdater().reset();
        this.assertInitialStateWithoutTraits();
    }

    @Test
    public void addAndRemoveSecurityScheme() throws InitialisationException {
        String name = "oauth2SecurityScheme";
        String yaml = "description: |\n    Dropbox supports OAuth 2.0 for authenticating all API requests.\ntype: OAuth 2.0\ndescribedBy:\n    headers:\n        Authorization:\n            description: |\n               Used to send a valid OAuth 2 access token. Do not use\n               with the \"access_token\" query string parameter.\n            type: string\n    queryParameters:\n        access_token:\n            description: |\n               Used to send a valid OAuth 2 access token. Do not use together with\n               the \"Authorization\" header\n            type: string\n    responses:\n        401:\n            description: |\n                Bad or expired token.\n        403:\n            description: |\n                Bad OAuth request (wrong consumer key, bad nonce, expired\n                timestamp...). Unfortunately, re-authenticating the user won't help here.\nsettings:\n  authorizationUri: https://www.dropbox.com/1/oauth2/authorize\n  accessTokenUri: https://api.dropbox.com/1/oauth2/token\n  authorizationGrants: [code, token]\n  scopes: [ 'https://www.google.com/m8/feeds' ]\n";
        this.assertInitialStateWithTraits();
        this.config.getRamlUpdater().injectSecuritySchemes(name, yaml).applySecurityScheme(name, new String[]{GET_LEAGUES}).resetAndUpdate();
        Assert.assertThat((Object)this.config.getApi().getSecuritySchemes().size(), (Matcher)CoreMatchers.is((Object)1));
        this.assertSecuritySchemeInjected(this.config.getApi().getResource(RESOURCE_LEAGUES).getAction(METHOD_GET), name);
        this.assertSecuritySchemeInjected(((Resource)this.config.routingTable.get(new URIPattern(RESOURCE_LEAGUES))).getAction(METHOD_GET), name);
        this.config.getRamlUpdater().reset();
        this.assertInitialStateWithTraits();
    }

    private void assertSecuritySchemeInjected(Action action, String name) {
        Assert.assertThat((Object)action.getSecuredBy().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((SecurityReference)action.getSecuredBy().get(0)).getName(), (Matcher)CoreMatchers.is((Object)name));
    }

    @Test(expected=ApikitRuntimeException.class)
    public void traitMismatch() {
        this.config.getRamlUpdater().injectTrait("rightName", "headers:").applyTrait("wrongName", new String[]{GET_LEAGUES}).resetAndUpdate();
    }

    @Test(expected=ApikitRuntimeException.class)
    public void securitySchemaMismatch() {
        this.config.getRamlUpdater().injectSecuritySchemes("rightName", "settings:").applySecurityScheme("wrongName", new String[]{GET_LEAGUES}).resetAndUpdate();
    }

    @Test(expected=ApikitRuntimeException.class)
    public void injectAndResetForbidden() {
        this.config.getRamlUpdater().injectSecuritySchemes("name", "settings:").reset();
    }

    private void assertInitialState(int traits, String resource) {
        Assert.assertThat((Object)this.config.getApi().getTraits().size(), (Matcher)CoreMatchers.is((Object)traits));
        Assert.assertThat((Object)this.config.getApi().getSecuritySchemes().size(), (Matcher)CoreMatchers.is((Object)0));
        Action action = this.config.getApi().getResource(resource).getAction(METHOD_GET);
        Assert.assertThat((Object)action.getIs().size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)action.getHeaders().size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)action.getQueryParameters().size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)action.getSecuredBy().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    private void assertInitialStateWithTraits() {
        this.assertInitialState(1, RESOURCE_LEAGUES);
    }

    private void assertInitialStateWithoutTraits() {
        this.assertInitialState(0, RESOURCE_ORDERS);
    }
}

