/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.schema;

import com.jayway.restassured.RestAssured;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class GeneratedSchemaTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/schema/generated-schema-config.xml";
    }

    @Test
    public void putValidJson() throws Exception {
        RestAssured.given().body("{\"username\":\"gbs\",\"firstName\":\"george\",\"lastName\":\"bernard shaw\",\"emailAddresses\":[\"gbs@ie\"]}").contentType("application/json").expect().statusCode(204).body(CoreMatchers.is((Object)""), new Matcher[0]).when().put("/api/currentuser", new Object[0]);
    }

    @Test
    public void putInvalidJson() throws Exception {
        RestAssured.given().body("{\"username\":\"gbs\",\"firstName\":\"george\",\"lastName\":\"bernard shaw\"}").contentType("application/json").expect().statusCode(400).body(CoreMatchers.is((Object)"bad request"), new Matcher[0]).when().put("/api/currentuser", new Object[0]);
    }

    @Test
    public void putValidXml() throws Exception {
        RestAssured.given().body("<user xmlns=\"http://mulesoft.org/schemas/sample\" username=\"gbs\" firstName=\"george\" lastName=\"bernard shaw\"><email-addresses><email-address>gbs@ie</email-address></email-addresses></user>").contentType("text/xml").expect().statusCode(204).body(CoreMatchers.is((Object)""), new Matcher[0]).when().put("/api/currentuser", new Object[0]);
    }

    @Test
    public void putInvalidXml() throws Exception {
        RestAssured.given().body("<user xmlns=\"http://mulesoft.org/schemas/sample\" username=\"gbs\" firstName=\"george\" lastName=\"bernard shaw\"><email-addresses></email-addresses></user>").contentType("text/xml").expect().statusCode(400).body(CoreMatchers.is((Object)"bad request"), new Matcher[0]).when().put("/api/currentuser", new Object[0]);
    }
}

