/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.schema;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.specification.ResponseSpecification;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;
import org.raml.parser.utils.StreamUtils;

public class EncodingTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigFile() {
        return "org/mule/module/apikit/schema/encoding-config.xml";
    }

    @Test
    public void postXmlWindows1252on08() throws Exception {
        this.postXmlWindows1252("/api08");
    }

    @Test
    public void postXmlWindows1252on08asString() throws Exception {
        this.postXmlWindows1252("/api08str");
    }

    private void postXmlWindows1252(String api) throws Exception {
        InputStream inputStrem = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/mule/module/apikit/schema/payload-windows1252.xml");
        String body = IOUtils.toString((InputStream)inputStrem, (String)"windows-1252");
        ((ResponseSpecification)RestAssured.given().body(body).contentType("application/xml;charset=windows-1252").header("Accept", (Object)"application/xml", new Object[0]).expect().log().everything()).statusCode(200).body(CoreMatchers.is((Object)body), new Matcher[0]).when().post(api + "/testXml", new Object[0]);
    }

    @Test
    public void postJsonUtf16beOn08() throws IOException {
        this.postJsonUtf16be("/api08");
    }

    @Test
    public void postJsonUtf16beOn08asString() throws IOException {
        this.postJsonUtf16be("/api08str");
    }

    private void postJsonUtf16be(String api) throws IOException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/mule/module/apikit/unicode/diacritics-utf16be.json");
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        String responseBody = StreamUtils.toString((InputStream)new ByteArrayInputStream(bytes));
        RestAssured.given().body(bytes).contentType("application/json;charset=UTF-16").expect().statusCode(200).body(CoreMatchers.is((Object)responseBody), new Matcher[0]).when().post(api + "/testJson", new Object[0]);
    }
}

