/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.jayway.restassured.RestAssured;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.LoggerMessageProcessor;
import org.mule.api.source.MessageSource;
import org.mule.construct.Flow;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.module.apikit.Configuration;
import org.mule.module.apikit.Router;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class JavaConfigurationTestCase
extends AbstractMuleTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    private MuleContext muleContext;

    public int getTestTimeoutSecs() {
        return 6000;
    }

    @Before
    public void setUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        this.muleContext = new DefaultMuleContextFactory().createMuleContext();
    }

    @After
    public void tearDown() throws Exception {
        this.muleContext.dispose();
    }

    @Test
    public void runJavaConfig() {
        this.buildJavaConfig(this.createEndpoint());
        RestAssured.given().header("Accept", (Object)"*/*", new Object[0]).expect().response().body(CoreMatchers.containsString((String)"/api/leagues"), new Matcher[0]).statusCode(200).when().get("/api/leagues", new Object[0]);
    }

    @Test
    public void runJavaConfigNoEndpoint() {
        try {
            this.buildJavaConfig(null);
            Assert.assertTrue((String)"Expected exception org.mule.api.lifecycle.LifecycleException was not thrown", (boolean)false);
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)IsInstanceOf.instanceOf(RuntimeException.class));
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)"org.mule.api.lifecycle.LifecycleException: Flow endpoint is null, APIKIT requires a listener ref in each of it's flows"));
        }
    }

    private void buildJavaConfig(InboundEndpoint inboundEndpoint) {
        try {
            if (inboundEndpoint != null) {
                this.muleContext.getRegistry().registerEndpoint((ImmutableEndpoint)inboundEndpoint);
            }
            Flow flow = new Flow("get:/leagues", this.muleContext);
            LoggerMessageProcessor loggerMessageProcessor = new LoggerMessageProcessor();
            loggerMessageProcessor.setMessage("Payload is #[payload]");
            flow.setMessageProcessors(Collections.singletonList(loggerMessageProcessor));
            this.muleContext.getRegistry().registerFlowConstruct((FlowConstruct)flow);
            Flow routerFlow = new Flow("RestRouterFlow", this.muleContext);
            routerFlow.setMessageSource((MessageSource)inboundEndpoint);
            Router apikitRouter = this.configureApikitRouter(this.muleContext);
            routerFlow.setMessageProcessors(Arrays.asList(apikitRouter));
            this.muleContext.getRegistry().registerFlowConstruct((FlowConstruct)routerFlow);
            this.muleContext.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private InboundEndpoint createEndpoint() {
        String host = "localhost";
        String path = "api";
        EndpointURIEndpointBuilder endpointURIEndpointBuilder = new EndpointURIEndpointBuilder("http://" + host + ":" + this.serverPort.getValue() + "/" + path, this.muleContext);
        try {
            return endpointURIEndpointBuilder.buildInboundEndpoint();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Router configureApikitRouter(MuleContext muleContext) throws IllegalAccessException, InvocationTargetException, InitialisationException {
        Router apikitRouter = new Router();
        Configuration config = new Configuration();
        config.setRaml("org/mule/module/apikit/leagues/leagues.yaml");
        config.setMuleContext(muleContext);
        config.initialise();
        apikitRouter.setConfig(config);
        apikitRouter.setMuleContext(muleContext);
        return apikitRouter;
    }
}

