/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.leagues;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.mule.api.annotations.ContainsTransformerMethods;
import org.mule.api.annotations.Transformer;
import org.mule.module.apikit.leagues.League;

@ContainsTransformerMethods
@XmlRootElement
@JsonAutoDetect
public class Leagues {
    private List<League> leagues;

    @XmlElement(name="league")
    public List<League> getLeagues() {
        return this.leagues;
    }

    public void setLeagues(List<League> leagues) {
        this.leagues = leagues;
    }

    public League getLeague(String id) {
        for (League league : this.leagues) {
            if (!league.getId().equals(id)) continue;
            return league;
        }
        return null;
    }

    public boolean deleteLeague(String id) {
        return this.leagues.remove(new League(id));
    }

    @Transformer(resultMimeType="application/json")
    public String toJson(Leagues leagues) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)leagues);
    }

    @Transformer(resultMimeType="text/xml")
    public String toXml(Leagues leagues) throws IOException, JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{this.getClass()});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        m.marshal((Object)leagues, (OutputStream)boas);
        return new String(boas.toByteArray());
    }
}

