/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.jayway.restassured.RestAssured;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class ContentTypeRoutingTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/contenttype/content-routing-flow-config.xml";
    }

    @Test
    public void postOnLeaguesJson() throws Exception {
        RestAssured.given().body("{ \"name\": \"Major League Soccer\" }").contentType("application/json").expect().statusCode(201).header("incoming-content-type", "application/json").body(CoreMatchers.is((Object)""), new Matcher[0]).header("Content-Length", "0").when().post("/api/leagues", new Object[0]);
    }

    @Test
    public void postOnLeaguesXml() throws Exception {
        RestAssured.given().body("<league xmlns=\"http://mulesoft.com/schemas/soccer\"><name>MLS</name></league>").contentType("application/xml").expect().statusCode(201).header("incoming-content-type", "application/xml").when().post("/api/leagues", new Object[0]);
    }

    @Test
    public void putOnSingleLeagueJson() throws Exception {
        RestAssured.given().body("{ \"name\": \"Liga Hispanica\" }").contentType("application/json").expect().statusCode(204).body(CoreMatchers.is((Object)""), new Matcher[0]).header("incoming-content-type", CoreMatchers.startsWith((String)"application/json")).when().put("/api/leagues/liga-bbva", new Object[0]);
    }

    @Test
    public void putOnSingleLeagueXml() throws Exception {
        RestAssured.given().body("<league xmlns=\"http://mulesoft.com/schemas/soccer\"><name>Hispanic League</name></league>").contentType("application/xml").expect().statusCode(204).body(CoreMatchers.is((Object)""), new Matcher[0]).header("incoming-content-type", CoreMatchers.startsWith((String)"application/xml")).when().put("/api/leagues/liga-bbva", new Object[0]);
    }
}

