/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.config.EncoderConfig;
import com.jayway.restassured.config.RestAssuredConfig;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.raml.parser.utils.StreamUtils;

public class UnicodeSupportTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        RestAssured.config = new RestAssuredConfig().encoderConfig(new EncoderConfig("UTF-8", "UTF-8"));
        super.doSetUp();
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/unicode/resource-config.xml";
    }

    @Test
    public void resource() throws Exception {
        RestAssured.given().expect().response().statusCode(200).when().get("/api/ping\u00fcino", new Object[0]);
    }

    @Test
    public void template() throws Exception {
        RestAssured.given().expect().response().statusCode(200).body(CoreMatchers.is((Object)"my name is fr\u00edo"), new Matcher[0]).when().get("/api/ping\u00fcino/fr\u00edo", new Object[0]);
    }

    @Test
    public void jsonBodyUtf8() throws IOException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/mule/module/apikit/unicode/diacritics-utf8.json");
        String body = StreamUtils.toString((InputStream)inputStream);
        RestAssured.given().body(body).contentType("application/json").expect().statusCode(200).body(CoreMatchers.is((Object)body), new Matcher[0]).when().post("/api/testUtf8", new Object[0]);
    }

    @Test
    public void jsonBodyUtf16BE() throws IOException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/mule/module/apikit/unicode/diacritics-utf16be.json");
        String body = StreamUtils.toString((InputStream)inputStream);
        RestAssured.given().body(body).contentType("application/json").expect().statusCode(200).body(CoreMatchers.is((Object)body), new Matcher[0]).when().post("/api/testUtf16", new Object[0]);
    }
}

