/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.cache;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import org.mule.module.apikit.exception.ApikitRuntimeException;

public final class JsonSchemaAndNode {
    private final JsonSchema jsonSchema;
    private final JsonNode jsonNode;

    public JsonSchemaAndNode(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
        try {
            ValidationConfiguration validationCfg = ValidationConfiguration.newBuilder().setDefaultVersion(SchemaVersion.DRAFTV3).freeze();
            JsonSchemaFactory jsonSchemaFactory = JsonSchemaFactory.newBuilder().setValidationConfiguration(validationCfg).freeze();
            this.jsonSchema = jsonSchemaFactory.getJsonSchema(jsonNode);
        }
        catch (ProcessingException e) {
            throw new ApikitRuntimeException(e);
        }
    }

    public JsonSchema getJsonSchema() {
        return this.jsonSchema;
    }

    public JsonNode getJsonNode() {
        return this.jsonNode;
    }
}

