/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.uri;

import java.util.ArrayList;
import java.util.List;
import org.mule.module.apikit.uri.Matchable;
import org.mule.module.apikit.uri.Token;
import org.mule.module.apikit.uri.URITemplateSyntaxException;
import org.mule.module.apikit.uri.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TokenBase
implements Token {
    private final String _exp;

    public TokenBase(String exp) throws NullPointerException {
        if (exp == null) {
            throw new NullPointerException("Cannot create a token with a null value.");
        }
        this._exp = exp;
    }

    @Override
    public boolean isResolvable() {
        return this instanceof Matchable;
    }

    @Override
    public String expression() {
        return this._exp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TokenBase t = (TokenBase)o;
        return this._exp == t._exp || this._exp != null && this._exp.equals(t._exp);
    }

    public int hashCode() {
        return 31 * this._exp.hashCode() + this._exp.hashCode();
    }

    public String toString() {
        return this._exp;
    }

    protected static final String strip(String exp) {
        if (exp.length() < 2) {
            return exp;
        }
        if (exp.charAt(0) == '{' && exp.charAt(exp.length() - 1) == '}') {
            return exp.substring(1, exp.length() - 1);
        }
        return exp;
    }

    protected static final List<Variable> toVariables(String exp) throws URITemplateSyntaxException {
        String[] exps = exp.split(",");
        ArrayList<Variable> vars = new ArrayList<Variable>(exps.length);
        for (String e : exps) {
            vars.add(Variable.parse(e));
        }
        return vars;
    }
}

