/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.StartException;
import org.mule.construct.Flow;
import org.mule.module.apikit.AbstractConfiguration;
import org.mule.module.apikit.ApiRouter;
import org.mule.module.apikit.HttpRestRequest;
import org.mule.module.apikit.RamlDescriptorHandler;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.exception.InvalidUriParameterException;
import org.mule.module.apikit.exception.MethodNotAllowedException;
import org.mule.module.apikit.exception.MuleRestException;
import org.mule.module.apikit.uri.ResolvedVariables;
import org.mule.module.apikit.uri.URIPattern;
import org.mule.module.apikit.uri.URIResolveResult;
import org.mule.module.apikit.uri.URIResolver;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.parameter.UriParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRouter
implements ApiRouter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    protected AbstractConfiguration config;
    protected RamlDescriptorHandler ramlHandler;

    public void start() throws MuleException {
        this.startConfiguration();
        this.ramlHandler = new RamlDescriptorHandler(this.config);
        this.config.publishConsoleUrls(this.muleContext.getConfiguration().getWorkingDirectory());
    }

    protected abstract void startConfiguration() throws StartException;

    protected Raml getApi() {
        return this.config.getApi();
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        URIResolver uriResolver;
        URIPattern uriPattern;
        HttpRestRequest request = this.getHttpRestRequest(event);
        String path = request.getResourcePath();
        MuleEvent handled = this.handleEvent(event, path);
        if (handled != null) {
            return handled;
        }
        if (this.ramlHandler.handles(request)) {
            return this.ramlHandler.processRouterRequest(event);
        }
        path = path.isEmpty() ? "/" : path;
        try {
            uriPattern = (URIPattern)this.getUriPatternCache().get((Object)path);
            uriResolver = (URIResolver)this.getUriResolverCache().get((Object)path);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof MuleRestException) {
                throw (MuleRestException)((Object)e.getCause());
            }
            throw new DefaultMuleException((Throwable)e);
        }
        Resource resource = this.getRoutingTable().get(uriPattern);
        if (resource.getAction(request.getMethod()) == null) {
            throw new MethodNotAllowedException(resource.getUri(), request.getMethod());
        }
        URIResolveResult resolvedVariables = uriResolver.resolve(uriPattern);
        this.processUriParameters(resolvedVariables, resource, event);
        Flow flow = this.getFlow(resource, request);
        if (flow == null) {
            throw new ApikitRuntimeException("Flow not found for resource: " + resource);
        }
        return request.process(flow, resource.getAction(request.getMethod()));
    }

    private Map<URIPattern, Resource> getRoutingTable() {
        return this.config.routingTable;
    }

    private LoadingCache<String, URIResolver> getUriResolverCache() {
        return this.config.uriResolverCache;
    }

    private LoadingCache<String, URIPattern> getUriPatternCache() {
        return this.config.uriPatternCache;
    }

    protected abstract MuleEvent handleEvent(MuleEvent var1, String var2) throws MuleException;

    private HttpRestRequest getHttpRestRequest(MuleEvent event) {
        return this.config.getHttpRestRequest(event);
    }

    private void processUriParameters(ResolvedVariables resolvedVariables, Resource resource, MuleEvent event) throws InvalidUriParameterException {
        if (this.logger.isDebugEnabled()) {
            for (String string : resolvedVariables.names()) {
                this.logger.debug("        uri parameter: " + string + "=" + resolvedVariables.get(string));
            }
        }
        if (!this.config.isDisableValidations()) {
            for (Map.Entry entry : resource.getResolvedUriParameters().entrySet()) {
                String value = (String)resolvedVariables.get((String)entry.getKey());
                UriParameter uriParameter = (UriParameter)entry.getValue();
                if (uriParameter.validate(value)) continue;
                String msg = String.format("Invalid value '%s' for uri parameter %s. %s", value, entry.getKey(), uriParameter.message(value));
                throw new InvalidUriParameterException(msg);
            }
        }
        for (String string : resolvedVariables.names()) {
            event.getMessage().setInvocationProperty(string, resolvedVariables.get(string));
        }
    }

    protected abstract Flow getFlow(Resource var1, HttpRestRequest var2);
}

