/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.jayway.restassured.RestAssured;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class PathlessEndpointStandaloneTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPortNoRouter = new DynamicPort("serverPortNoRouter");
    @Rule
    public DynamicPort serverPortPathless = new DynamicPort("serverPortPathless");
    @Rule
    public DynamicPort serverPortEmptyPath = new DynamicPort("serverPortEmptyPath");
    @Rule
    public DynamicPort serverPortSlashPath = new DynamicPort("serverPortSlashPath");
    @Rule
    public DynamicPort serverPortAddressSlashPath = new DynamicPort("serverPortAddressSlashPath");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/pathless/pathless-standalone-config.xml";
    }

    @Test
    @Ignore
    public void consoleWithoutRouter() {
        RestAssured.port = this.serverPortNoRouter.getNumber();
        RestAssured.given().header("Accept", (Object)"text/html", new Object[0]).expect().response().body(CoreMatchers.containsString((String)"API not initialized. Probably there is no APIkit Router associated to the Configuration"), new Matcher[0]).header("Content-type", "text/plain").statusCode(500).when().get("/index.html", new Object[0]);
    }

    @Test
    public void consolePathless() throws Exception {
        RestAssured.port = this.serverPortPathless.getNumber();
        this.console("");
    }

    @Test
    public void ramlPathless() throws Exception {
        RestAssured.port = this.serverPortPathless.getNumber();
        this.raml("");
    }

    @Test
    public void baseuriPathless() throws Exception {
        int port;
        RestAssured.port = port = this.serverPortPathless.getNumber();
        this.baseUri("", "http://localhost:" + port);
    }

    @Test
    public void consoleEmptyPath() throws Exception {
        RestAssured.port = this.serverPortEmptyPath.getNumber();
        this.console("");
    }

    @Test
    public void consoleSlashPath() throws Exception {
        RestAssured.port = this.serverPortSlashPath.getNumber();
        this.console("");
    }

    @Test
    public void consoleAddressSlashPath() throws Exception {
        RestAssured.port = this.serverPortAddressSlashPath.getNumber();
        this.console("/console");
    }

    @Test
    public void ramlAddressSlashPath() throws Exception {
        RestAssured.port = this.serverPortAddressSlashPath.getNumber();
        this.raml("/console/");
    }

    @Test
    public void baseuriAddressSlashPath() throws Exception {
        int port;
        RestAssured.port = port = this.serverPortAddressSlashPath.getNumber();
        this.baseUri("/api", "http://localhost:" + port);
    }

    private void console(String path) {
        RestAssured.given().header("Accept", (Object)"text/html", new Object[0]).expect().response().body(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"<title>API Console</title>"), (Matcher)CoreMatchers.containsString((String)("src=\"http://localhost:" + RestAssured.port + path))), new Matcher[0]).header("Content-type", "text/html").statusCode(200).when().get(path + "/index.html", new Object[0]);
    }

    private void raml(String path) {
        RestAssured.given().header("Accept", (Object)"application/raml+yaml", new Object[0]).expect().response().body(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"title"), (Matcher)CoreMatchers.containsString((String)"Endpoint API")), new Matcher[0]).statusCode(200).when().get(path, new Object[0]);
    }

    private void baseUri(String path, String expectedBaseUri) {
        RestAssured.given().header("Accept", (Object)"application/raml+yaml", new Object[0]).expect().response().body(CoreMatchers.containsString((String)("baseUri: \"" + expectedBaseUri + "/api\"")), new Matcher[0]).statusCode(200).when().get(path + "/", new Object[0]);
    }
}

