RAML.Inspector=function(){"use strict";function extractResources(basePathSegments,api,securitySchemes){var resources=[],apiResources=api.resources||[];return apiResources.forEach(function(resource){var resourcePathSegments=basePathSegments.concat(RAML.Client.createPathSegment(resource)),overview=exports.resourceOverviewSource(resourcePathSegments,resource);if(overview.methods=overview.methods.map(function(method){return RAML.Inspector.Method.create(method,securitySchemes)}),resources.push(overview),resource.resources){var extracted=extractResources(resourcePathSegments,resource,securitySchemes);extracted.forEach(function(resource){resources.push(resource)})}}),resources}function groupResources(resources){var currentPrefix,resourceGroups=[];return(resources||[]).forEach(function(resource){var prefix=resource.pathSegments[0].toString();prefix===currentPrefix||0===prefix.indexOf(currentPrefix+"/")?resourceGroups[resourceGroups.length-1].push(resource):(currentPrefix=resource.pathSegments[0].toString(),resourceGroups.push([resource]))}),resourceGroups}var exports={},METHOD_ORDERING=["GET","POST","PUT","PATCH","DELETE","HEAD","OPTIONS","TRACE","CONNECT"];return exports.resourceOverviewSource=function(pathSegments,resource){var clone=RAML.Utils.clone(resource);return clone.traits=resource.is,clone.resourceType=resource.type,clone.type=clone.is=void 0,clone.pathSegments=pathSegments,clone.methods=resource.methods||[],clone.methods.sort(function(a,b){var aOrder=METHOD_ORDERING.indexOf(a.method.toUpperCase()),bOrder=METHOD_ORDERING.indexOf(b.method.toUpperCase());return aOrder>bOrder?1:-1}),clone.uriParametersForDocumentation=pathSegments.map(function(segment){return segment.parameters}).filter(function(params){return!!params}).reduce(function(accum,parameters){for(var key in parameters){var parameter=parameters[key];parameter&&(parameter=parameter instanceof Array?parameter:[parameter]),accum[key]=parameter}return accum},{}),clone.toString=function(){return this.pathSegments.map(function(segment){return segment.toString()}).join("")},clone},exports.create=function(api){return api.baseUri&&(api.baseUri=RAML.Client.createBaseUri(api)),api.resources=extractResources([],api,api.securitySchemes),api.resourceGroups=groupResources(api.resources),api},exports}(),function(){"use strict";function ensureArray(value){return void 0!==value&&null!==value?value instanceof Array?value:[value]:void 0}function normalizeNamedParameters(parameters){Object.keys(parameters||{}).forEach(function(key){parameters[key]=ensureArray(parameters[key])})}function wrapWithParameterizedHeader(name,definitions){return definitions.map(function(definition){return RAML.Inspector.ParameterizedHeader.fromRAML(name,definition)})}function filterHeaders(headers){var filtered={plain:{},parameterized:{}};return Object.keys(headers||{}).forEach(function(key){key.match(PARAMETER)?filtered.parameterized[key]=wrapWithParameterizedHeader(key,headers[key]):filtered.plain[key]=headers[key]}),filtered}function processBody(body){var content=body["application/x-www-form-urlencoded"];content&&normalizeNamedParameters(content.formParameters),content=body["multipart/form-data"],content&&normalizeNamedParameters(content.formParameters)}function processResponses(responses){Object.keys(responses).forEach(function(status){var response=responses[status];response&&normalizeNamedParameters(response.headers)})}function securitySchemesExtractor(securitySchemes){return securitySchemes=securitySchemes||[],function(){var securedBy=this.securedBy||[],selectedSchemes={};return securedBy=securedBy.filter(function(name){return null!==name&&"object"!=typeof name}),securitySchemes.forEach(function(scheme){securedBy.forEach(function(name){scheme[name]&&(selectedSchemes[name]=scheme[name])})}),selectedSchemes}}function allowsAnonymousAccess(){var securedBy=this.securedBy||[null];return securedBy.some(function(name){return null===name})}var PARAMETER=/\{\*\}/;RAML.Inspector.Method={create:function(raml,securitySchemes){var method=RAML.Utils.clone(raml);return method.responseCodes=Object.keys(method.responses||{}),method.securitySchemes=securitySchemesExtractor(securitySchemes),method.allowsAnonymousAccess=allowsAnonymousAccess,normalizeNamedParameters(method.headers),normalizeNamedParameters(method.queryParameters),method.headers=filterHeaders(method.headers),processBody(method.body||{}),processResponses(method.responses||{}),method.plainAndParameterizedHeaders=RAML.Utils.copy(method.headers.plain),Object.keys(method.headers.parameterized).forEach(function(parameterizedHeader){method.plainAndParameterizedHeaders[parameterizedHeader]=method.headers.parameterized[parameterizedHeader].map(function(parameterized){return parameterized.definition()})}),method}}}(),function(){"use strict";function validate(value){if(value=value?value.trim():"",""===value)throw new Error;return value}function fromRAML(name,definition){var parameterizedString=new RAML.Client.ParameterizedString(name,definition);return{create:function(value){value=validate(value);var header=RAML.Utils.clone(definition);return header.displayName=parameterizedString.render({"*":value}),header},definition:function(){return definition}}}RAML.Inspector.ParameterizedHeader={fromRAML:fromRAML}}(),function(){function createConfiguration(parsed){var config={baseUriParameters:{}};return{baseUriParameters:function(baseUriParameters){config.baseUriParameters=baseUriParameters||{}},getBaseUri:function(){var template=RAML.Client.createBaseUri(parsed);return config.baseUriParameters.version=parsed.version,template.render(config.baseUriParameters)}}}var Client=function(configuration){this.baseUri=configuration.getBaseUri()};RAML.Client={create:function(parsed,configure){var configuration=createConfiguration(parsed);return configure&&configure(configuration),new Client(configuration)},createBaseUri:function(rootRAML){var baseUri=rootRAML.baseUri.toString();return new RAML.Client.ParameterizedString(baseUri,rootRAML.baseUriParameters,{parameterValues:{version:rootRAML.version}})},createPathSegment:function(resourceRAML){return new RAML.Client.ParameterizedString(resourceRAML.relativeUri,resourceRAML.uriParameters)}}}(),function(){"use strict";RAML.Client.AuthStrategies={"for":function(scheme,credentials){if(!scheme)return RAML.Client.AuthStrategies.anonymous();switch(scheme.type){case"Basic Authentication":return new RAML.Client.AuthStrategies.Basic(scheme,credentials);case"OAuth 2.0":return new RAML.Client.AuthStrategies.Oauth2(scheme,credentials);case"OAuth 1.0":return new RAML.Client.AuthStrategies.Oauth1(scheme,credentials);default:throw new Error("Unknown authentication strategy: "+scheme.type)}}}}(),function(){var NO_OP_TOKEN={sign:function(){}},Anonymous=function(){};Anonymous.prototype.authenticate=function(){return{then:function(success){success(NO_OP_TOKEN)}}};var anonymous=new Anonymous;RAML.Client.AuthStrategies.Anonymous=Anonymous,RAML.Client.AuthStrategies.anonymous=function(){return anonymous}}(),function(){var Basic=function(scheme,credentials){this.token=new Basic.Token(credentials)};Basic.prototype.authenticate=function(){var token=this.token;return{then:function(success){success(token)}}},Basic.Token=function(credentials){var words=CryptoJS.enc.Utf8.parse(credentials.username+":"+credentials.password);this.encoded=CryptoJS.enc.Base64.stringify(words)},Basic.Token.prototype.sign=function(request){request.header("Authorization","Basic "+this.encoded)},RAML.Client.AuthStrategies.Basic=Basic}(),function(){"use strict";var Oauth1=function(scheme,credentials){var signerFactory=RAML.Client.AuthStrategies.Oauth1.Signer.createFactory(scheme.settings,credentials);this.requestTemporaryCredentials=RAML.Client.AuthStrategies.Oauth1.requestTemporaryCredentials(scheme.settings,signerFactory),this.requestAuthorization=RAML.Client.AuthStrategies.Oauth1.requestAuthorization(scheme.settings),this.requestTokenCredentials=RAML.Client.AuthStrategies.Oauth1.requestTokenCredentials(scheme.settings,signerFactory)};Oauth1.proxyRequest=function(url){return RAML.Settings.proxy&&(url=RAML.Settings.proxy+url),url},Oauth1.parseUrlEncodedData=function(data){var result={};return data.split("&").forEach(function(param){var keyAndValue=param.split("=");result[keyAndValue[0]]=keyAndValue[1]}),result},Oauth1.prototype.authenticate=function(){return this.requestTemporaryCredentials().then(this.requestAuthorization).then(this.requestTokenCredentials)},RAML.Client.AuthStrategies.Oauth1=Oauth1}(),function(){"use strict";var WINDOW_NAME="raml-console-oauth1";RAML.Client.AuthStrategies.Oauth1.requestAuthorization=function(settings){return function(temporaryCredentials){var authorizationUrl=settings.authorizationUri+"?oauth_token="+temporaryCredentials.token,deferred=$.Deferred();return window.RAML.authorizationSuccess=function(authResult){temporaryCredentials.verifier=authResult.verifier,deferred.resolve(temporaryCredentials)},window.open(authorizationUrl,WINDOW_NAME),deferred.promise()}}}(),function(){"use strict";RAML.Client.AuthStrategies.Oauth1.requestTemporaryCredentials=function(settings,signerFactory){return function(){var url=RAML.Client.AuthStrategies.Oauth1.proxyRequest(settings.requestTokenUri),request=RAML.Client.Request.create(url,"post");return signerFactory().sign(request),$.ajax(request.toOptions()).then(function(rawFormData){var data=RAML.Client.AuthStrategies.Oauth1.parseUrlEncodedData(rawFormData);return{token:data.oauth_token,tokenSecret:data.oauth_token_secret}})}}}(),function(){"use strict";RAML.Client.AuthStrategies.Oauth1.requestTokenCredentials=function(settings,signerFactory){return function(temporaryCredentials){var url=RAML.Client.AuthStrategies.Oauth1.proxyRequest(settings.tokenCredentialsUri),request=RAML.Client.Request.create(url,"post");return signerFactory(temporaryCredentials).sign(request),$.ajax(request.toOptions()).then(function(rawFormData){var credentials=RAML.Client.AuthStrategies.Oauth1.parseUrlEncodedData(rawFormData);return signerFactory({token:credentials.oauth_token,tokenSecret:credentials.oauth_token_secret})})}}}(),function(){"use strict";function baseParameters(consumerCredentials){return{oauth_consumer_key:consumerCredentials.consumerKey,oauth_version:"1.0"}}var Signer=RAML.Client.AuthStrategies.Oauth1.Signer={};Signer.createFactory=function(settings,consumerCredentials){return settings=settings||{},function(tokenCredentials){var type="PLAINTEXT"===settings.signatureMethod?"Plaintext":"Hmac",mode=void 0===tokenCredentials?"Temporary":"Token";return new Signer[type][mode](consumerCredentials,tokenCredentials)}},Signer.generateTemporaryCredentialParameters=function(consumerCredentials){var result=baseParameters(consumerCredentials);return result.oauth_callback=RAML.Settings.oauth1RedirectUri,result},Signer.generateTokenCredentialParameters=function(consumerCredentials,tokenCredentials){var result=baseParameters(consumerCredentials);return result.oauth_token=tokenCredentials.token,tokenCredentials.verifier&&(result.oauth_verifier=tokenCredentials.verifier),result},Signer.rfc3986Encode=function(str){return encodeURIComponent(str).replace(/[!'()]/g,window.escape).replace(/\*/g,"%2A")},Signer.setRequestHeader=function(params,request){var header=Object.keys(params).map(function(key){return key+'="'+Signer.rfc3986Encode(params[key])+'"'}).join(", ");request.header("Authorization","OAuth "+header)}}(),function(){"use strict";function uriWithoutProxy(url){return RAML.Settings.proxy&&(url=url.replace(RAML.Settings.proxy,"")),url}function generateSignature(params,request,key){params.oauth_signature_method="HMAC-SHA1",params.oauth_timestamp=Math.floor(Date.now()/1e3),params.oauth_nonce=CryptoJS.lib.WordArray.random(16).toString();var data=Hmac.constructHmacText(request,params),hash=CryptoJS.HmacSHA1(data,key);params.oauth_signature=hash.toString(CryptoJS.enc.Base64)}var generateTemporaryCredentialParameters=RAML.Client.AuthStrategies.Oauth1.Signer.generateTemporaryCredentialParameters,generateTokenCredentialParameters=RAML.Client.AuthStrategies.Oauth1.Signer.generateTokenCredentialParameters,rfc3986Encode=RAML.Client.AuthStrategies.Oauth1.Signer.rfc3986Encode,setRequestHeader=RAML.Client.AuthStrategies.Oauth1.Signer.setRequestHeader,Hmac={constructHmacText:function(request,oauthParams){var options=request.toOptions();return[options.type.toUpperCase(),this.encodeURI(options.url),rfc3986Encode(this.encodeParameters(request,oauthParams))].join("&")},encodeURI:function(uri){var parser=document.createElement("a");parser.href=uriWithoutProxy(uri);var hostname="";return hostname="https:"===parser.protocol&&443===parser.port||"http:"===parser.protocol&&80===parser.port?parser.hostname.toLowerCase():parser.host.toLowerCase(),rfc3986Encode(parser.protocol+"//"+hostname+parser.pathname)},encodeParameters:function(request,oauthParameters){var params=request.queryParams(),formParams={};"application/x-www-form-urlencoded"===request.toOptions().contentType&&(formParams=request.data());var result=[];for(var key in params)result.push([rfc3986Encode(key),rfc3986Encode(params[key])]);for(var formKey in formParams)result.push([rfc3986Encode(formKey),rfc3986Encode(formParams[formKey])]);for(var oauthKey in oauthParameters)result.push([rfc3986Encode(oauthKey),rfc3986Encode(oauthParameters[oauthKey])]);return result.sort(function(a,b){return a[0]===b[0]?a[1].localeCompare(b[1]):a[0].localeCompare(b[0])}),result.map(function(tuple){return tuple.join("=")}).join("&")}};Hmac.Temporary=function(consumerCredentials){this.consumerCredentials=consumerCredentials},Hmac.Temporary.prototype.sign=function(request){var params=generateTemporaryCredentialParameters(this.consumerCredentials),key=rfc3986Encode(this.consumerCredentials.consumerSecret)+"&";generateSignature(params,request,key),setRequestHeader(params,request)},Hmac.Token=function(consumerCredentials,tokenCredentials){this.consumerCredentials=consumerCredentials,this.tokenCredentials=tokenCredentials},Hmac.Token.prototype.sign=function(request){var params=generateTokenCredentialParameters(this.consumerCredentials,this.tokenCredentials),key=rfc3986Encode(this.consumerCredentials.consumerSecret)+"&"+rfc3986Encode(this.tokenCredentials.tokenSecret);generateSignature(params,request,key),setRequestHeader(params,request)},RAML.Client.AuthStrategies.Oauth1.Signer.Hmac=Hmac}(),function(){"use strict";var generateTemporaryCredentialParameters=RAML.Client.AuthStrategies.Oauth1.Signer.generateTemporaryCredentialParameters,generateTokenCredentialParameters=RAML.Client.AuthStrategies.Oauth1.Signer.generateTokenCredentialParameters,rfc3986Encode=RAML.Client.AuthStrategies.Oauth1.Signer.rfc3986Encode,setRequestHeader=RAML.Client.AuthStrategies.Oauth1.Signer.setRequestHeader,Plaintext={};Plaintext.Temporary=function(consumerCredentials){this.consumerCredentials=consumerCredentials},Plaintext.Temporary.prototype.sign=function(request){var params=generateTemporaryCredentialParameters(this.consumerCredentials);params.oauth_signature=rfc3986Encode(this.consumerCredentials.consumerSecret)+"&",params.oauth_signature_method="PLAINTEXT",setRequestHeader(params,request)},Plaintext.Token=function(consumerCredentials,tokenCredentials){this.consumerCredentials=consumerCredentials,this.tokenCredentials=tokenCredentials},Plaintext.Token.prototype.sign=function(request){var params=generateTokenCredentialParameters(this.consumerCredentials,this.tokenCredentials);params.oauth_signature=rfc3986Encode(this.consumerCredentials.consumerSecret)+"&"+rfc3986Encode(this.tokenCredentials.tokenSecret),params.oauth_signature_method="PLAINTEXT",setRequestHeader(params,request)},RAML.Client.AuthStrategies.Oauth1.Signer.Plaintext=Plaintext}(),function(){"use strict";var Oauth2=function(scheme,credentials){this.grant=RAML.Client.AuthStrategies.Oauth2.Grant.create(scheme.settings,credentials),this.tokenFactory=RAML.Client.AuthStrategies.Oauth2.Token.createFactory(scheme)};Oauth2.prototype.authenticate=function(){return this.grant.request().then(Oauth2.createToken(this.tokenFactory))},RAML.Client.AuthStrategies.Oauth2=Oauth2}(),function(){"use strict";RAML.Client.AuthStrategies.Oauth2.createToken=function(tokenFactory){return function(token){return tokenFactory(token)}}}(),function(){"use strict";RAML.Client.AuthStrategies.Oauth2.credentialsManager=function(credentials,responseType){return{authorizationUrl:function(baseUrl){return baseUrl+"?client_id="+credentials.clientId+"&response_type="+responseType+"&redirect_uri="+RAML.Settings.oauth2RedirectUri},accessTokenParameters:function(code){return{client_id:credentials.clientId,client_secret:credentials.clientSecret,code:code,grant_type:"authorization_code",redirect_uri:RAML.Settings.oauth2RedirectUri}}}}}(),function(){"use strict";function grantTypeFrom(settings){var authorizationGrants=settings.authorizationGrants||[],filtered=authorizationGrants.filter(function(grant){return grant===IMPLICIT_GRANT}),specifiedGrant=filtered[0]||authorizationGrants[0];if(!GRANTS.some(function(grant){return grant===specifiedGrant}))throw new Error("Unknown grant type: "+specifiedGrant);return specifiedGrant}var GRANTS=["code","token"],IMPLICIT_GRANT="token",Oauth2=RAML.Client.AuthStrategies.Oauth2,Grant={create:function(settings,credentials){var type=grantTypeFrom(settings),credentialsManager=Oauth2.credentialsManager(credentials,type),className=type.charAt(0).toUpperCase()+type.slice(1);return new this[className](settings,credentialsManager)}};Grant.Code=function(settings,credentialsManager){this.settings=settings,this.credentialsManager=credentialsManager},Grant.Code.prototype.request=function(){var requestAuthorization=Oauth2.requestAuthorization(this.settings,this.credentialsManager),requestAccessToken=Oauth2.requestAccessToken(this.settings,this.credentialsManager);return requestAuthorization.then(requestAccessToken)},Grant.Token=function(settings,credentialsManager){this.settings=settings,this.credentialsManager=credentialsManager},Grant.Token.prototype.request=function(){return Oauth2.requestAuthorization(this.settings,this.credentialsManager)},Oauth2.Grant=Grant}(),function(){"use strict";function proxyRequest(url){return RAML.Settings.proxy&&(url=RAML.Settings.proxy+url),url}function accessTokenFromObject(data){return data.access_token}function accessTokenFromString(data){for(var vars=data.split("&"),i=0;i<vars.length;i++){var pair=vars[i].split("=");if("access_token"===decodeURIComponent(pair[0]))return decodeURIComponent(pair[1])}return void 0}RAML.Client.AuthStrategies.Oauth2.requestAccessToken=function(settings,credentialsManager){return function(code){var url=proxyRequest(settings.accessTokenUri),requestOptions={url:url,type:"post",data:credentialsManager.accessTokenParameters(code)};return $.ajax(requestOptions).then(function(data){var extract=accessTokenFromString;return"object"==typeof data&&(extract=accessTokenFromObject),extract(data)})}}}(),function(){"use strict";var WINDOW_NAME="raml-console-oauth2";RAML.Client.AuthStrategies.Oauth2.requestAuthorization=function(settings,credentialsManager){var authorizationUrl=credentialsManager.authorizationUrl(settings.authorizationUri),deferred=$.Deferred();return window.RAML.authorizationSuccess=function(code){deferred.resolve(code)},window.open(authorizationUrl,WINDOW_NAME),deferred.promise()}}(),function(){"use strict";function tokenConstructorFor(scheme){var describedBy=scheme.describedBy||{},headers=describedBy.headers||{},queryParameters=describedBy.queryParameters||{};return headers.Authorization?Header:queryParameters.access_token?QueryParameter:Header}var Header=function(accessToken){this.accessToken=accessToken};Header.prototype.sign=function(request){request.header("Authorization","Bearer "+this.accessToken)};var QueryParameter=function(accessToken){this.accessToken=accessToken};QueryParameter.prototype.sign=function(request){request.queryParam("access_token",this.accessToken)},RAML.Client.AuthStrategies.Oauth2.Token={createFactory:function(scheme){var TokenConstructor=tokenConstructorFor(scheme);return function(value){return new TokenConstructor(value)}}}}(),function(){"use strict";function tokenize(template){var tokens=template.split(templateMatcher);return tokens.filter(function(token){return token.length>0})}function rendererFor(template,uriParameters){var requiredParameters=Object.keys(uriParameters||{}).filter(function(name){return uriParameters[name].required});return function(context){context=context||{},requiredParameters.forEach(function(name){if(!context[name])throw new Error("Missing required uri parameter: "+name)});var templated=template.replace(templateMatcher,function(match,parameterName){return context[parameterName]||""});return templated}}var templateMatcher=/\{([^}]*)\}/g;RAML.Client.ParameterizedString=function(template,uriParameters,options){options=options||{parameterValues:{}},template=template.replace(templateMatcher,function(match,parameterName){return options.parameterValues[parameterName]?options.parameterValues[parameterName]:"{"+parameterName+"}"}),this.parameters=uriParameters,this.templated=Object.keys(this.parameters||{}).length>0,this.tokens=tokenize(template),this.render=rendererFor(template,uriParameters),this.toString=function(){return template}}}(),function(){"use strict";RAML.Client.PathBuilder={create:function(pathSegments){return function(contexts){return contexts=contexts||[],pathSegments.map(function(pathSegment,index){return pathSegment.render(contexts[index])}).join("")}}}}(),function(){"use strict";var CONTENT_TYPE="content-type",FORM_DATA="multipart/form-data",RequestDsl=function(options){var rawData,queryParams,isMultipartRequest;this.data=function(data){return void 0===data?RAML.Utils.clone(rawData):void(rawData=data)},this.queryParams=function(parameters){return void 0===parameters?RAML.Utils.clone(queryParams):void(queryParams=parameters)},this.queryParam=function(name,value){queryParams=queryParams||{},queryParams[name]=value},this.header=function(name,value){if(options.headers=options.headers||{},name.toLowerCase()===CONTENT_TYPE){if(value===FORM_DATA)return void(isMultipartRequest=!0);isMultipartRequest=!1,options.contentType=value}options.headers[name]=value},this.headers=function(headers){options.headers={},isMultipartRequest=!1,options.contentType=!1;for(var name in headers)this.header(name,headers[name])},this.toOptions=function(){var o=RAML.Utils.clone(options);if(o.traditional=!0,rawData)if(isMultipartRequest){var data=new FormData,appendValueForKey=function(key){return function(value){data.append(key,value)}};for(var key in rawData)rawData[key].forEach(appendValueForKey(key));o.processData=!1,o.data=data}else o.processData=!0,o.data=rawData;if(!RAML.Utils.isEmpty(queryParams)){var separator=options.url.match("\\?")?"&":"?";o.url=options.url+separator+$.param(queryParams,!0)}return o}};RAML.Client.Request={create:function(url,method){var request={};return RequestDsl.call(request,{url:url,type:method,contentType:!1}),request}}}(),function(){"use strict";function isEmpty(value){return null===value||void 0===value||""===value}function baseValidations(definition){var validations={};return definition.required&&(validations.required=VALIDATIONS.required),validations}function numberValidations(validations,definition){definition.minimum&&(validations.minimum=VALIDATIONS.minimum(definition.minimum)),definition.maximum&&(validations.maximum=VALIDATIONS.maximum(definition.maximum))}function Validator(validations){this.validations=validations}var RFC1123=/^(Mon|Tue|Wed|Thu|Fri|Sat|Sun), \d{2} (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \d{4} \d{2}:\d{2}:\d{2} GMT$/,VALIDATIONS={required:function(value){return!isEmpty(value)},"boolean":function(value){return isEmpty(value)||"true"===value||"false"===value},"enum":function(enumeration){return function(value){return isEmpty(value)||enumeration.some(function(item){return item===value})}},integer:function(value){return isEmpty(value)||!!/^-?(0|[1-9][0-9]*)$/.exec(value)},number:function(value){return isEmpty(value)||!!/^-?(0|[1-9][0-9]*)(\.[0-9]*)?([eE][-+]?[0-9]+)?$/.exec(value)},minimum:function(minimum){return function(value){return isEmpty(value)||value>=minimum}},maximum:function(maximum){return function(value){return isEmpty(value)||maximum>=value}},minLength:function(minimum){return function(value){return isEmpty(value)||value.length>=minimum}},maxLength:function(maximum){return function(value){return isEmpty(value)||value.length<=maximum}},pattern:function(pattern){var regex=new RegExp(pattern);return function(value){return isEmpty(value)||!!regex.exec(value)}},date:function(value){return isEmpty(value)||!!RFC1123.exec(value)}},VALIDATIONS_FOR_TYPE={string:function(definition){var validations=baseValidations(definition);return definition.enum&&(validations.enum=VALIDATIONS.enum(definition.enum)),definition.minLength&&(validations.minLength=VALIDATIONS.minLength(definition.minLength)),definition.maxLength&&(validations.maxLength=VALIDATIONS.maxLength(definition.maxLength)),definition.pattern&&(validations.pattern=VALIDATIONS.pattern(definition.pattern)),validations},integer:function(definition){var validations=baseValidations(definition);return validations.integer=VALIDATIONS.integer,numberValidations(validations,definition),validations},number:function(definition){var validations=baseValidations(definition);return validations.number=VALIDATIONS.number,numberValidations(validations,definition),validations},"boolean":function(definition){var validations=baseValidations(definition);return validations.boolean=VALIDATIONS.boolean,validations},date:function(definition){var validations=baseValidations(definition);return validations.date=VALIDATIONS.date,validations}};Validator.prototype.validate=function(value){var errors;for(var validation in this.validations)this.validations[validation](value)||(errors=errors||[],errors.push(validation));return errors},Validator.from=function(definition){if(!definition)throw new Error("definition is required!");var validations;return validations=VALIDATIONS_FOR_TYPE[definition.type]?VALIDATIONS_FOR_TYPE[definition.type](definition):{},new Validator(validations)},RAML.Client.Validator=Validator}(),function(){RAML.Controllers={}}(),function(){"use strict";RAML.Controllers.BodyDocumentation=function($scope,DataStore){$scope.bodyKey=$scope.keyBase+":body",$scope.displayed={},$scope.expandSchema=function(contentType){var key=$scope.bodyKey+":schemaExpanded:"+contentType;return DataStore.set(key,!0)},$scope.schemaExpanded=function(contentType){var key=$scope.bodyKey+":schemaExpanded:"+contentType;return DataStore.get(key)}}}(),function(){"use strict";function hasFormParameters(method){return FORM_MIME_TYPES.some(function(type){return method.body&&method.body[type]&&!RAML.Utils.isEmpty(method.body[type].formParameters)})}var FORM_MIME_TYPES=["application/x-www-form-urlencoded","multipart/form-data"],controller=function($scope){function hasUriParameters(){return $scope.resource.pathSegments.some(function(segment){return segment.templated})}function hasParameters(){return!(!hasUriParameters()&&!$scope.method.queryParameters&&RAML.Utils.isEmpty($scope.method.headers.plain)&&!hasFormParameters($scope.method))}function hasTraits(method){return method.is&&method.is.length>0}$scope.documentation=this,$scope.generateKey=function(base,method){return base+":"+method.method},this.hasRequestDocumentation=function(){return hasTraits($scope.method)||!!$scope.method.description||hasParameters()||!RAML.Utils.isEmpty($scope.method.body)},this.hasResponseDocumentation=function(){return!RAML.Utils.isEmpty($scope.method.responses)}};controller.prototype.isEmpty=function(params){return RAML.Utils.isEmpty(params)},RAML.Controllers.Documentation=controller}(),function(){var controller=function($scope){$scope.namedParametersDocumentation=this};controller.prototype.constraints=function(parameter){var result="";return parameter.required&&(result+="required, "),result+=parameter.enum?"one of ("+parameter.enum.join(", ")+")":parameter.type,parameter.pattern&&(result+=" matching "+parameter.pattern),parameter.minLength&&parameter.maxLength?result+=", "+parameter.minLength+"-"+parameter.maxLength+" characters":parameter.minLength&&!parameter.maxLength?result+=", at least "+parameter.minLength+" characters":parameter.maxLength&&!parameter.minLength&&(result+=", at most "+parameter.maxLength+" characters"),parameter.minimum&&parameter.maximum?result+=" between "+parameter.minimum+"-"+parameter.maximum:parameter.minimum&&!parameter.maximum?result+=" ≥ "+parameter.minimum:parameter.maximum&&!parameter.minimum&&(result+=" ≤ "+parameter.maximum),parameter.repeat&&(result+=", repeatable"),parameter.default&&(result+=", default: "+parameter.default),result},RAML.Controllers.NamedParametersDocumentation=controller}(),function(){"use strict";var controller=function($scope,$attrs,ramlParserWrapper){$scope.ramlConsole=this,$attrs.hasOwnProperty("withRootDocumentation")&&(this.withRootDocumentation=!0),$scope.src&&ramlParserWrapper.load($scope.src),this.keychain={}};controller.prototype.gotoView=function(view){this.view=view},controller.prototype.tryItEnabled=function(){return!(!this.api||!this.api.baseUri)},controller.prototype.showRootDocumentation=function(){return this.withRootDocumentation&&this.api&&this.api.documentation&&this.api.documentation.length>0},RAML.Controllers.RAMLConsole=controller}(),function(){"use strict";function generateKey(resource){return resource.toString()}RAML.Controllers.Resource=function($scope,DataStore,$element){$scope.resourceView=this,$scope.$emit("console:resource:rendered",$scope.resource,$element),$scope.$on("$destroy",function(){$scope.$emit("console:resource:destroyed",$scope.resource)}),this.expanded=DataStore.get(generateKey($scope.resource)),this.openDocumentation=function($event,method,resource){$event.stopPropagation(),$scope.$emit("console:expand",resource,method,$element,angular.element($event.currentTarget))},this.closePopover=function($event){$event.stopPropagation(),$scope.$emit("console:resource:close",$element)},this.toggleExpansion=function(){this.expanded=!this.expanded,DataStore.set(generateKey($scope.resource),this.expanded)}}}(),function(){function Controller($scope,DataStore){this.tabs=[],this.DataStore=DataStore,this.key=$scope.keyBase+":tabset",$scope.tabset=this}Controller.prototype.select=function(tab,dontPersist){tab.disabled||(dontPersist||this.DataStore.set(this.key,tab.heading),this.tabs.forEach(function(item){item.active=!1}),tab.active=!0,this.active=tab)},Controller.prototype.addTab=function(tab){var previouslyEnabled=this.DataStore.get(this.key)===tab.heading,allOthersDisabled=this.tabs.every(function(tab){return tab.disabled});(allOthersDisabled||previouslyEnabled)&&this.select(tab,this.DataStore.get(this.key)),this.tabs.push(tab)},RAML.Controllers.tabset=Controller}(),function(){var controller=function($scope,DataStore){this.DataStore=DataStore,this.key=$scope.keyBase+":toggle",this.toggleItems=$scope.toggleItems=[],this.toggleModel=$scope.toggleModel||{},$scope.toggle=this};controller.prototype.select=function(toggleItem,dontPersist){this.toggleModel.selected=void 0,this.toggleItems.forEach(function(toggleItem){toggleItem.active=!1}),toggleItem.active=!0,this.toggleModel.selected=toggleItem.heading,dontPersist||this.DataStore.set(this.key,toggleItem.heading)},controller.prototype.addToggleItem=function(toggleItem){var previouslyEnabled=this.DataStore.get(this.key)===toggleItem.heading,noneActive=this.toggleItems.every(function(toggleItem){return!toggleItem.active});(noneActive||previouslyEnabled)&&this.select(toggleItem,!0),this.toggleItems.push(toggleItem)},RAML.Controllers.toggle=controller}(),function(){function parseHeaders(headers){var key,val,i,parsed={};return headers?(headers.split("\n").forEach(function(line){i=line.indexOf(":"),key=line.substr(0,i).trim().toLowerCase(),val=line.substr(i+1).trim(),key&&(parsed[key]?parsed[key]+=", "+val:parsed[key]=val)}),parsed):parsed
}var apply,TryIt=function($scope){$scope.apiClient=this,$scope.method&&(this.method=$scope.method,this.httpMethod=$scope.method.method,this.securitySchemes=$scope.method.securitySchemes()),this.parsed=$scope.api,this.keychain=$scope.ramlConsole.keychain,apply=function(){$scope.$apply.apply($scope,arguments)},this.setResponse=function(response){return $scope.apiClient.response=response,response}};TryIt.prototype.inProgress=function(){return this.response&&!this.response.status&&!this.missingUriParameters},TryIt.prototype.execute=function(){function handleResponse(jqXhr){response.body=jqXhr.responseText,response.status=jqXhr.status,response.headers=parseHeaders(jqXhr.getAllResponseHeaders()),response.headers["content-type"]&&(response.contentType=response.headers["content-type"].split(";")[0]),apply()}this.missingUriParameters=!1,this.disallowedAnonymousRequest=!1;var url,response=this.setResponse({});try{var pathBuilder=this.context.pathBuilder,client=RAML.Client.create(this.parsed,function(client){client.baseUriParameters(pathBuilder.baseUriContext)});url=response.requestUrl=client.baseUri+pathBuilder(pathBuilder.segmentContexts)}catch(e){return this.setResponse(void 0),void(this.missingUriParameters=!0)}RAML.Settings.proxy&&(url=RAML.Settings.proxy+url);var request=RAML.Client.Request.create(url,this.httpMethod);RAML.Utils.isEmpty(this.context.queryParameters.data())||request.queryParams(this.context.queryParameters.data()),RAML.Utils.isEmpty(this.context.headers.data())||request.headers(this.context.headers.data()),this.context.bodyContent&&(request.header("Content-Type",this.context.bodyContent.selected),request.data(this.context.bodyContent.data()));var authStrategy;try{"Anonymous"!==this.keychain.selected||this.method.allowsAnonymousAccess()||(this.disallowedAnonymousRequest=!0);var scheme=this.securitySchemes&&this.securitySchemes[this.keychain.selected],credentials=this.keychain[this.keychain.selected];authStrategy=RAML.Client.AuthStrategies.for(scheme,credentials)}catch(e){}authStrategy.authenticate().then(function(token){token.sign(request),$.ajax(request.toOptions()).then(function(data,textStatus,jqXhr){handleResponse(jqXhr)},function(jqXhr){handleResponse(jqXhr)})})},RAML.Controllers.TryIt=TryIt}(),function(){"use strict";var FORM_URLENCODED="application/x-www-form-urlencoded",FORM_DATA="multipart/form-data",BodyContent=function(contentTypes){this.contentTypes=Object.keys(contentTypes),this.selected=this.contentTypes[0];var definitions=this.definitions={};this.contentTypes.forEach(function(contentType){var definition=contentTypes[contentType]||{};switch(contentType){case FORM_URLENCODED:case FORM_DATA:definitions[contentType]=new RAML.Controllers.TryIt.NamedParameters(definition.formParameters);break;default:definitions[contentType]=new RAML.Controllers.TryIt.BodyType(definition)}})};BodyContent.prototype.isForm=function(contentType){return contentType===FORM_URLENCODED||contentType===FORM_DATA},BodyContent.prototype.isSelected=function(contentType){return contentType===this.selected},BodyContent.prototype.fillWithExample=function($event){$event.preventDefault(),this.definitions[this.selected].fillWithExample()},BodyContent.prototype.hasExample=function(contentType){return this.definitions[contentType].hasExample()},BodyContent.prototype.data=function(){return this.selected?this.definitions[this.selected].data():void 0},BodyContent.prototype.copyFrom=function(oldContent){var content=this;oldContent.contentTypes.forEach(function(contentType){content.definitions[contentType]&&content.definitions[contentType].copyFrom(oldContent.definitions[contentType])}),this.contentTypes.some(function(contentType){return contentType===oldContent.selected})&&(this.selected=oldContent.selected)},RAML.Controllers.TryIt.BodyContent=BodyContent}(),function(){"use strict";var BodyType=function(contentType){this.contentType=contentType||{},this.value=void 0};BodyType.prototype.fillWithExample=function(){this.value=this.contentType.example},BodyType.prototype.hasExample=function(){return!!this.contentType.example},BodyType.prototype.data=function(){return this.value},BodyType.prototype.copyFrom=function(oldBodyType){this.value=oldBodyType.value},RAML.Controllers.TryIt.BodyType=BodyType}(),function(){"use strict";var Context=function(resource,method){this.headers=new RAML.Controllers.TryIt.NamedParameters(method.headers.plain,method.headers.parameterized),this.queryParameters=new RAML.Controllers.TryIt.NamedParameters(method.queryParameters),method.body&&(this.bodyContent=new RAML.Controllers.TryIt.BodyContent(method.body)),this.pathBuilder=new RAML.Client.PathBuilder.create(resource.pathSegments),this.pathBuilder.baseUriContext={},this.pathBuilder.segmentContexts=resource.pathSegments.map(function(){return{}})};Context.prototype.merge=function(oldContext){this.headers.copyFrom(oldContext.headers),this.queryParameters.copyFrom(oldContext.queryParameters),this.bodyContent&&oldContext.bodyContent&&this.bodyContent.copyFrom(oldContext.bodyContent),this.pathBuilder.baseUriContext=oldContext.pathBuilder.baseUriContext,this.pathBuilder.segmentContexts=oldContext.pathBuilder.segmentContexts},RAML.Controllers.TryIt.Context=Context}(),function(){"use strict";var NamedParameter=function(definitions){this.definitions=definitions,this.selected=definitions[0].type};NamedParameter.prototype.hasMultipleTypes=function(){return this.definitions.length>1},NamedParameter.prototype.isSelected=function(definition){return this.selected===definition.type},RAML.Controllers.TryIt.NamedParameter=NamedParameter}(),function(){"use strict";function copy(object){var shallow={};return Object.keys(object||{}).forEach(function(key){shallow[key]=new RAML.Controllers.TryIt.NamedParameter(object[key])}),shallow}function filterEmpty(object){var copy={};return Object.keys(object).forEach(function(key){var values=object[key].filter(function(value){return void 0!==value&&null!==value&&("string"!=typeof value||value.trim().length>0)});values.length>0&&(copy[key]=values)}),copy}var NamedParameters=function(plain,parameterized){this.plain=copy(plain),this.parameterized=parameterized,Object.keys(parameterized||{}).forEach(function(key){parameterized[key].created=[]}),this.values={},Object.keys(this.plain).forEach(function(key){this.values[key]=[void 0]}.bind(this))};NamedParameters.prototype.create=function(name,value){var parameters=this.parameterized[name],definition=parameters.map(function(parameterizedHeader){return parameterizedHeader.create(value)}),parameterizedName=definition[0].displayName;parameters.created.push(parameterizedName),this.plain[parameterizedName]=new RAML.Controllers.TryIt.NamedParameter(definition),this.values[parameterizedName]=[void 0]},NamedParameters.prototype.remove=function(name){delete this.plain[name],delete this.values[name]},NamedParameters.prototype.data=function(){return filterEmpty(this.values)},NamedParameters.prototype.copyFrom=function(oldParameters){var parameters=this;Object.keys(oldParameters.parameterized||{}).forEach(function(key){parameters.parameterized[key]&&oldParameters.parameterized[key].created.forEach(function(createdParam){parameters.plain[createdParam]=oldParameters.plain[createdParam]})});var keys=Object.keys(oldParameters.plain||{}).filter(function(key){return parameters.plain[key]});keys.forEach(function(key){parameters.values[key]=oldParameters.values[key]})},RAML.Controllers.TryIt.NamedParameters=NamedParameters}(),function(){RAML.Directives={}}(),function(){"use strict";RAML.Directives.apiResources=function(){var controller=function($scope,$element){var self=$scope.apiResources=this;this.collapsed={},this.toggleAll=function(collapsed){$scope.api.resourceGroups.forEach(function(group){var key=self.keyFor(group);self.collapsed[key]=collapsed})},this.isCollapsed=function(group){var key=self.keyFor(group);return self.collapsed[key]},this.openDocumentation=function($event,method,resource){$event.stopPropagation(),console.log("emit:console:expand"),$scope.$emit("console:expand",resource,method,$element,angular.element($event.currentTarget))},this.closePopover=function($event){$event.stopPropagation(),$scope.$emit("console:resource:close",$element)}};return controller.prototype.keyFor=function(group){return group[0].pathSegments[0].toString()},{restrict:"E",templateUrl:"views/api_resources.tmpl.html",replace:!0,controller:controller}}}(),function(){RAML.Directives.basicAuth=function(){return{restrict:"E",templateUrl:"views/basic_auth.tmpl.html",replace:!0,scope:{credentials:"="}}}}(),function(){"use strict";RAML.Directives.bodyContent=function(){return{restrict:"E",templateUrl:"views/body_content.tmpl.html",replace:!0,scope:{body:"="}}}}(),function(){"use strict";RAML.Directives.bodyDocumentation=function(){return{restrict:"E",replace:!0,templateUrl:"views/body_documentation.tmpl.html",scope:{body:"=",keyBase:"="},controller:RAML.Controllers.BodyDocumentation}}}(),function(){"use strict";function sanitize(options){var code=options.code||"",formatter=formatters[options.mode]||formatters.default;try{options.code=formatter(code)}catch(e){}}var formatters={"application/json":function(code){return vkbeautify.json(code)},"text/xml":function(code){return vkbeautify.xml(code)},"default":function(code){return code}},Controller=function($scope,$element){sanitize($scope),this.editor=new CodeMirror($element[0],{mode:$scope.mode,readOnly:!0,value:$scope.code,lineNumbers:!0,indentUnit:4}),this.editor.setSize("100%","100%")};Controller.prototype.refresh=function(options){sanitize(options),this.editor.setOption("mode",options.mode),this.editor.setValue(options.code),this.editor.refresh()};var link=function(scope,element,attrs,editor){var watchCode=function(){return scope.visible&&scope.code};scope.$watch(watchCode,function(visible){visible&&editor.refresh(scope)})};RAML.Directives.codeMirror=function(){return{link:link,restrict:"A",replace:!0,controller:Controller,scope:{code:"=codeMirror",visible:"=",mode:"@?"}}},RAML.Directives.codeMirror.Controller=Controller}(),function(){"use strict";var Controller=function($scope){this.toggle=function(){$scope.collapsed=!$scope.collapsed}};RAML.Directives.collapsible=function($parse){return{controller:Controller,restrict:"EA",scope:!0,link:function(scope,element,attrs){if(!attrs.collapsed&&!attrs.expanded)return void(scope.collapsed=!0);var attr=attrs.collapsed||attrs.expanded,normalizeForAttribute=function(arg){return attrs.expanded?!arg:arg};scope.collapsed=normalizeForAttribute($parse(attr)(scope)),scope.$watch(attr,function(value){scope.collapsed=normalizeForAttribute(value)}),scope.$watch("collapsed",function(collapsed){$parse(attr).assign(scope.$parent,normalizeForAttribute(collapsed)),element.removeClass("collapsed expanded"),element.addClass(collapsed?"collapsed":"expanded")})}}},RAML.Directives.collapsibleToggle=function(){return{require:"^collapsible",restrict:"EA",link:function(scope,element,attrs,controller){element.bind("click",function(){scope.$apply(controller.toggle)})}}},RAML.Directives.collapsibleContent=function(){return{require:"^collapsible",restrict:"EA",link:function(scope,element){scope.$watch("collapsed",function(collapsed){element.css("display",collapsed?"none":"block")})}}}}(),function(){"use strict";RAML.Directives.documentation=function(){return{controller:RAML.Controllers.Documentation,restrict:"E",templateUrl:"views/documentation.tmpl.html",replace:!0}}}(),function(){"use strict";RAML.Directives.enum=function($timeout,$filter){function correctHeight(el,container){var enumRect=el.getBoundingClientRect(),containerRect=container.getBoundingClientRect(),top=enumRect.top,bottom=enumRect.bottom;return top<=containerRect.top&&(top=containerRect.top),bottom>=containerRect.bottom&&(bottom=containerRect.bottom),bottom-top}var KEY_DOWN=40,KEY_UP=38,KEY_ENTER=13,link=function($scope,$el){function filterEnumElements(){$scope.filteredEnum=$filter("filter")($scope.options,$scope.$parent.model)}$scope.$watch("$parent.model",filterEnumElements),$scope.selectItem=function(item){$scope.model=$scope.$parent.model=item,$scope.focused=!1},filterEnumElements(),$el.find("input").bind("focus",function(){$scope.$apply(function(){$scope.selectedIndex=-1,$scope.focused=!0})}),$el.find("input").bind("blur",function(){$scope.$apply(function(){$scope.model=$scope.$parent.model,$scope.focused=!1})}),$el.bind("mousedown",function(event){"LI"===event.target.tagName&&event.preventDefault()}),$el.find("input").bind("input",function(){$scope.$apply(function(){$scope.focused=!0,$scope.selectedIndex=0})}),$el.find("input").bind("keydown",function(e){switch(e.keyCode){case KEY_UP:$scope.selectedIndex=$scope.selectedIndex-1,$scope.selectedIndex=Math.max(0,$scope.selectedIndex),e.preventDefault();break;case KEY_DOWN:$scope.selectedIndex=$scope.selectedIndex+1,$scope.selectedIndex=Math.min($scope.filteredEnum.length-1,$scope.selectedIndex),e.preventDefault();break;case KEY_ENTER:var selection=$scope.filteredEnum[$scope.selectedIndex];selection&&$scope.selectItem(selection),e.preventDefault()}$scope.$apply()}),$scope.$watch("focused",function(){$scope.filteredEnum=$scope.options,setTimeout(function(){var ul=$el.find("ul"),container=$el[0].offsetParent;ul.css("max-height",null),$scope.containedBy&&(container=document.querySelector($scope.containedBy)),container&&(ul.css("max-height",correctHeight(ul[0],container)+"px"),filterEnumElements(),$scope.$digest())})})};return{restrict:"E",transclude:!0,link:link,templateUrl:"views/enum.tmpl.html",scope:{options:"=",model:"=",containedBy:"="}}}}(),function(angular){"use strict";var inputOverride=angular.module("fileInputOverride",[]);inputOverride.config(["$provide",function($provide){$provide.decorator("inputDirective",["$delegate",function($delegate){return angular.forEach($delegate,function(inputDirective){var originalCompile=inputDirective.compile;inputDirective.compile=function(element,attrs){return attrs.type&&"file"===attrs.type.toLowerCase()?function(scope,element,attr,ctrl){element.bind("change",function(){scope.$apply(function(){var files=element[0].files,viewValue=attr.multiple?files:files[0];ctrl.$setViewValue(viewValue)})})}:originalCompile.apply(this,arguments)}}),$delegate}])}])}(window.angular),function(){"use strict";RAML.Directives.markdown=function($sanitize){var converter=new Showdown.converter({extensions:["table"]}),link=function(scope,element){var processMarkdown=function(markdown){var result=converter.makeHtml(markdown||"");element.html($sanitize(result))};scope.$watch("markdown",processMarkdown)};return{restrict:"A",link:link,scope:{markdown:"="}}}}(),function(){"use strict";RAML.Directives.method=function(){return{restrict:"E",templateUrl:"views/method.tmpl.html",replace:!0}}}(),function(){var Controller=function($scope){$scope.displayParameters=function(){var parameters=$scope.parameters||{};return parameters.plain=parameters.plain||{},parameters.parameterized=parameters.parameterized||{},Object.keys(parameters.plain).length>0||Object.keys(parameters.parameterized).length>0}};RAML.Directives.namedParameters=function(){return{restrict:"E",controller:Controller,templateUrl:"views/named_parameters.tmpl.html",replace:!0,scope:{heading:"@",parameters:"="}}}}(),function(){"use strict";RAML.Directives.namedParametersDocumentation=function(){return{restrict:"E",replace:!0,controller:RAML.Controllers.NamedParametersDocumentation,templateUrl:"views/named_parameters_documentation.tmpl.html",scope:{heading:"@",parameters:"="}}}}(),function(){RAML.Directives.oauth1=function(){return{restrict:"E",templateUrl:"views/oauth1.tmpl.html",replace:!0,scope:{credentials:"="}}}}(),function(){RAML.Directives.oauth2=function(){return{restrict:"E",templateUrl:"views/oauth2.tmpl.html",replace:!0,scope:{credentials:"="}}}}(),function(){var Controller=function($scope){$scope.placeholder=$scope.placeholder||$scope.definition.example,$scope.inputType="file"===$scope.definition.type?"file":$scope.definition.enum?"enum":"default"};RAML.Directives.parameterField=function(){return{restrict:"E",templateUrl:"views/parameter_field.tmpl.html",controller:Controller,scope:{name:"=",model:"=",definition:"=",placeholder:"=?",invalidClass:"@?",containedBy:"@"}}}}(),function(){RAML.Directives.parameterFields=function(){return{restrict:"E",templateUrl:"views/parameter_fields.tmpl.html",scope:{parameters:"="}}}}(),function(){"use strict";var Controller=function($scope){$scope.parameterFactory=this,this.parameterName=$scope.parameterName,this.parameters=$scope.parameters};Controller.prototype.open=function($event){$event.preventDefault(),this.opened=!0},Controller.prototype.create=function($event){$event.preventDefault();try{this.parameters.create(this.parameterName,this.value),this.opened=!1,this.value=this.status=""}catch(e){this.status="error"}},RAML.Directives.parameterizedParameter=function(){return{restrict:"E",templateUrl:"views/parameterized_parameter.tmpl.html",replace:!0,controller:Controller,scope:{parameters:"=",parameterName:"="}}}}(),function(){"use strict";RAML.Directives.ramlConsole=function(ramlParserWrapper,DataStore,$timeout){var link=function($scope,$el,$attrs,controller){$scope.popOverOpen=function(){if(!$scope.api)return!1;var currentlyDisplayed=DataStore.get($scope.api.title+":popup");return $scope.api.resources.some(function(resource){return resource.toString()===currentlyDisplayed})},ramlParserWrapper.onParseSuccess(function(raml){var inner=$($el[0]).find(".inner");if(inner.length){var height=inner[0].scrollHeight;inner.css("height",height)}$scope.api=controller.api=RAML.Inspector.create(raml),$timeout(function(){inner.css("height","auto")},0)}),ramlParserWrapper.onParseError(function(error){$scope.parseError=error})};return{restrict:"E",templateUrl:"views/raml-console.tmpl.html",controller:RAML.Controllers.RAMLConsole,scope:{src:"@"},link:link}}}(),function(){"use strict";RAML.Directives.ramlConsoleInitializer=function(ramlParserWrapper){var controller=function($scope){$scope.consoleLoader=this};controller.prototype.load=function(){ramlParserWrapper.load(this.location),this.finished=!0},controller.prototype.parse=function(){ramlParserWrapper.parse(this.raml),this.finished=!0};var link=function($scope,$element,$attrs,controller){-1!==document.location.search.indexOf("?raml=")&&(controller.location=document.location.search.replace("?raml=",""),controller.load())};return{restrict:"E",controller:controller,link:link}}}(),function(){"use strict";RAML.Directives.resource=function(){return{restrict:"E",templateUrl:"views/resource.tmpl.html",replace:!0,controller:RAML.Controllers.Resource}}}(),function(){"use strict";RAML.Directives.resourceDocumentation=function($rootScope,$window){function Controller($scope){var receipt;$rootScope.$on("console:resource:destroyed",function(event,resource){$scope.resource&&$scope.resource.toString()===resource.toString()&&(receipt=setTimeout(function(){popover.close($scope),popover=void 0},100))}),$rootScope.$on("console:resource:close",function(event,$resourceEl){var $li=$resourceEl[0],$resourcePanel=angular.element($li.querySelector(".resource-panel"));angular.element($li.querySelectorAll(".tab")).removeClass("is-active"),angular.element($li).removeClass("is-active"),angular.element($li.querySelectorAll(".resource")).removeClass("is-active"),$resourcePanel.removeAttr("style")}),$rootScope.$on("console:expand",function(event,resource,method,$resourceEl,$current){console.log("on:console:expand");var root=angular.element(document.querySelector(".resource-list-root"))[0];angular.element(root.querySelectorAll(".resource-panel")).removeAttr("style"),angular.element(root.querySelectorAll(".tab")).removeClass("is-active"),angular.element(root.querySelectorAll(".resource")).removeClass("is-active");var $li=$current.parent().parent().parent()[0],$resourcePanel=angular.element($li.querySelector(".resource-panel"));$resourcePanel.css("overflow","visible"),$resourcePanel.css("display","block"),$resourcePanel.css("height","auto"),$resourcePanel.css("margin-top","0px"),$resourcePanel.css("margin-bottom","0px"),$resourcePanel.css("padding-top","0px"),$resourcePanel.css("padding-bottom","0px"),angular.element($resourceEl[0].querySelectorAll(".tab")).removeClass("is-active"),$current.addClass("is-active"),angular.element($li).addClass("is-active"),angular.element($li.querySelector(".resource")).addClass("is-active"),$scope.method=method,$scope.resource=resource}),$scope.isEmpty=function(params){return RAML.Utils.isEmpty(params)},$scope.showResponse=function($event){angular.element(angular.element($event.currentTarget).parent()[0].querySelectorAll("a")).removeClass("is-active"),angular.element($event.currentTarget).addClass("is-active"),angular.element(document.querySelectorAll(".resource-response")).addClass("is-active"),angular.element(document.querySelectorAll(".resource-request")).removeClass("is-active")},$scope.showRequest=function($event){angular.element(angular.element($event.currentTarget).parent()[0].querySelectorAll("a")).removeClass("is-active"),angular.element($event.currentTarget).addClass("is-active"),angular.element(document.querySelectorAll(".resource-request")).addClass("is-active"),angular.element(document.querySelectorAll(".resource-response")).removeClass("is-active")},$scope.showSchema=function(responseCode){$scope["resourceStatus"+responseCode]=!$scope["resourceStatus"+responseCode]},$scope.toggleFullScreen=function(){var $sidebar=angular.element(document.querySelectorAll(".sidebar"));document.querySelectorAll(".sidebar.is-fullscreen").length>0?$sidebar.removeClass("is-fullscreen"):$sidebar.addClass("is-fullscreen")},$scope.collapseTryIt=function(){document.querySelectorAll(".sidebar.is-collapsed").length>0?(angular.element(document.querySelectorAll(".resource-panel")).removeClass("has-sidebar-fullscreen has-sidebar-collapsed"),angular.element(document.querySelectorAll(".sidebar")).removeClass("is-collapsed")):(angular.element(document.querySelectorAll(".resource-panel")).addClass("has-sidebar-fullscreen has-sidebar-collapsed"),angular.element(document.querySelectorAll(".sidebar")).addClass("is-collapsed"))},$scope.displayHeaders=function(){if($scope.method){var parameters=$scope.method.headers||{};return parameters.plain=parameters.plain||{},parameters.parameterized=parameters.parameterized||{},Object.keys(parameters.plain).length>0||Object.keys(parameters.parameterized).length>0}},$scope.displayQueryParameters=function(){if($scope.method){var parameters=$scope.method.queryParameters||{};return Object.keys(parameters).length>0}},$scope.displayUriParameters=function(){if($scope.resource){var parameters=$scope.resource.uriParametersForDocumentation||{};return Object.keys(parameters).length>0}}}var popover;return angular.element($window).bind("resize",function(){popover&&popover.resize()}),{restrict:"E",templateUrl:"views/resource_documentation.tmpl.html",controller:Controller,scope:{api:"=",ramlConsole:"=",ngShow:"="}}}}(),function(){"use strict";RAML.Directives.repeatable=function($parse){var controller=function($scope,$attrs){this.repeatable=function(){return $parse($attrs.repeatable)($scope)},this.new=function(){$scope.repeatableModel.push("")},this.remove=function(index){$scope.repeatableModel.splice(index,1)}};return{restrict:"EA",templateUrl:"views/repeatable.tmpl.html",transclude:!0,controller:controller,link:function(scope,element,attrs){scope.repeatable=!attrs.repeatable||$parse(attrs.repeatable)(scope),scope.repeatableModel=$parse(attrs.repeatableModel)(scope),scope.$watch("repeatableModel",function(value){$parse(attrs.repeatableModel).assign(scope,value)},!0)}}}}(),function(){RAML.Directives.repeatableAdd=function(){return{require:"^repeatable",restrict:"E",template:'<i class="fa fa-plus-square" ng-show="visible" ng-click="new()"></i>',scope:!0,link:function(scope,element,attrs,controller){scope.$watch("$last",function(last){scope.visible=controller.repeatable()&&last}),scope.new=function(){controller.new()}}}}}(),function(){RAML.Directives.repeatableRemove=function(){return{require:"^repeatable",restrict:"E",template:'<i class="fa fa-times-circle" ng-show="visible" ng-click="remove()"></i>',scope:!0,link:function(scope,element,attrs,controller){scope.$watch("repeatableModel.length",function(length){scope.visible=controller.repeatable()&&length>1}),scope.remove=function(){var index=scope.$index;controller.remove(index)}}}}}(),function(){RAML.Directives.responses=function(){return{restrict:"E",templateUrl:"views/responses.tmpl.html"}}}(),function(){"use strict";RAML.Directives.rootDocumentation=function(){return{restrict:"E",templateUrl:"views/root_documentation.tmpl.html",replace:!0}}}(),function(){RAML.Directives.securitySchemes=function(){var controller=function($scope){$scope.securitySchemes=this};return controller.prototype.supports=function(scheme){return"OAuth 2.0"===scheme.type||"OAuth 1.0"===scheme.type||"Basic Authentication"===scheme.type},{restrict:"E",templateUrl:"views/security_schemes.tmpl.html",replace:!0,controller:controller,scope:{schemes:"=",keychain:"=",baseKey:"="}}}}(),function(){"use strict";!function(){RAML.Directives.consoleTabset=function(){return{restrict:"E",templateUrl:"views/tabset.tmpl.html",replace:!0,transclude:!0,controller:RAML.Controllers.tabset,scope:{heading:"@",keyBase:"@"}}}}(),function(){function Controller($scope){this.registerSubtabs=function(subtabs,keyBase){$scope.subtabs=subtabs,$scope.keyBase=keyBase},this.registerUriBar=function(uriBar){$scope.uriBar=uriBar}}RAML.Directives.consoleTab=function($location,$anchorScroll,DataStore){return{restrict:"E",templateUrl:"views/tab.tmpl.html",replace:!0,transclude:!0,require:"^consoleTabset",controller:Controller,link:function($scope,$element,$attrs,tabsetCtrl){var selected=DataStore.get($scope.keyBase);$scope.select=function(subItem){selected=subItem;var responseCode=$("#"+selected)[0],container=$element.parent()[0];container.scrollTop=responseCode.offsetTop-container.getBoundingClientRect().top+responseCode.offsetParent.getBoundingClientRect().top,DataStore.set($scope.keyBase,selected)},$scope.selected=function(subItem){return(selected||$scope.subtabs[0])===subItem},tabsetCtrl.addTab($scope)},scope:{active:"=",disabled:"=",heading:"@"}}}}(),function(){RAML.Directives.subtabs=function(){return{restrict:"E",require:"^consoleTab",link:function($scope,$element,$attrs,tabCtrl){tabCtrl.registerSubtabs($scope.tabs,$scope.keyBase)},scope:{tabs:"=",keyBase:"@"}}}}(),function(){RAML.Directives.uriBar=function(){return{restrict:"E",require:"^consoleTab",link:function($scope,$element,$attrs,tabCtrl){$attrs.$observe("pathBuilder",function(pathBuilder){pathBuilder&&tabCtrl.registerUriBar($scope)})},scope:{pathBuilder:"=",baseUri:"=",pathSegments:"="}}}}()}(),function(){"use strict";RAML.Directives.toggle=function(){return{restrict:"E",replace:!0,transclude:!0,controller:RAML.Controllers.toggle,templateUrl:"views/toggle.tmpl.html",scope:{keyBase:"@",toggleModel:"=?"}}}}(),function(){"use strict";var link=function($scope,$element,$attrs,toggleCtrl){toggleCtrl.addToggleItem($scope)};RAML.Directives.toggleItem=function(){return{restrict:"E",require:"^toggle",replace:!0,transclude:!0,link:link,templateUrl:"views/toggle-item.tmpl.html",scope:{heading:"@",active:"=?"}}}}(),function(){"use strict";RAML.Directives.tryIt=function(DataStore){return{restrict:"E",templateUrl:"views/try_it.tmpl.html",replace:!0,link:function($scope){$scope.$watch("method",function(){new RAML.Controllers.TryIt($scope,DataStore)})}}}}(),function(){"use strict";RAML.Directives.validatedInput=function($parse){var Controller=function($attrs){this.constraints=$parse($attrs.constraints)};Controller.prototype.validate=function(scope,value){var constraints=this.constraints(scope),validator=RAML.Client.Validator.from(constraints);return validator.validate(value)};var link=function($scope,$el,$attrs,controllers){function validateField(){var errors=validateController.validate($scope,modelController.$modelValue);errors?$el.addClass(errorClass):$el.removeClass(errorClass)}var modelController=controllers[0],validateController=controllers[1],errorClass=$parse($attrs.invalidClass)($scope)||"warning";$el.bind("blur",function(){$scope.$apply(validateField)}),$el.bind("focus",function(){$scope.$apply(function(){$el.removeClass(errorClass)})}),angular.element($el[0].form).bind("submit",function(){$scope.$apply(validateField)})};return{restrict:"A",require:["ngModel","validatedInput"],controller:Controller,link:link}}}(),RAML.Filters={},function(){"use strict";RAML.Filters.nameFromParameterizable=function(){return function(input){return"object"==typeof input&&null!==input?Object.keys(input)[0]:input?input:void 0}}}(),function(){"use strict";RAML.Filters.yesNo=function(){return function(input){return input?"Yes":"No"}}}(),function(){"use strict";RAML.Services={}}(),function(){"use strict";RAML.Services.DataStore=function(){var store={};return{get:function(key){var entry=store[key];return entry?entry.value:void 0},set:function(key,value){store[key]={valid:!0,value:value}},reset:function(){store={}}}}}(),function(){"use strict";RAML.Services.RAMLParserWrapper=function($rootScope,ramlParser,$q){var ramlProcessor,errorProcessor,whenParsed,PARSE_SUCCESS="event:raml-parsed",load=function(file){setPromise(ramlParser.loadFile(file))},parse=function(raml){setPromise(ramlParser.load(raml))},onParseSuccess=function(cb){ramlProcessor=function(){cb.apply(this,arguments),$rootScope.$$phase||$rootScope.$digest()},whenParsed&&whenParsed.then(ramlProcessor)},onParseError=function(cb){errorProcessor=function(){cb.apply(this,arguments),$rootScope.$$phase||$rootScope.$digest()},whenParsed&&whenParsed.then(void 0,errorProcessor)},setPromise=function(promise){whenParsed=promise,(ramlProcessor||errorProcessor)&&whenParsed.then(ramlProcessor,errorProcessor)};return $rootScope.$on(PARSE_SUCCESS,function(e,raml){setPromise($q.when(raml))}),{load:load,parse:parse,onParseSuccess:onParseSuccess,onParseError:onParseError}}}(),function(){RAML.Settings=RAML.Settings||{};var location=window.location,uri=location.protocol+"//"+location.host+location.pathname+"authentication/oauth2.html";RAML.Settings.oauth2RedirectUri=RAML.Settings.oauth2RedirectUri||uri,RAML.Settings.oauth1RedirectUri=RAML.Settings.oauth1RedirectUri||uri.replace(/oauth2\.html$/,"oauth1.html")}(),function(){"use strict";function Clone(){}RAML.Utils={clone:function(object){return Clone.prototype=object,new Clone},copy:function(object){var copiedObject={};for(var key in object)copiedObject[key]=object[key];return copiedObject},isEmpty:function(object){return object?0===Object.keys(object).length:!0}}}(),function(){var module=angular.module("raml",[]);module.factory("ramlParser",function(){return RAML.Parser})}(),function(){var module=angular.module("ramlConsoleApp",["raml","ngSanitize","fileInputOverride"]);module.directive("apiResources",RAML.Directives.apiResources),module.directive("basicAuth",RAML.Directives.basicAuth),module.directive("bodyContent",RAML.Directives.bodyContent),module.directive("bodyDocumentation",RAML.Directives.bodyDocumentation),module.directive("codeMirror",RAML.Directives.codeMirror),module.directive("collapsible",RAML.Directives.collapsible),module.directive("collapsibleContent",RAML.Directives.collapsibleContent),module.directive("collapsibleToggle",RAML.Directives.collapsibleToggle),module.directive("documentation",RAML.Directives.documentation),module.directive("enum",RAML.Directives.enum),module.directive("markdown",RAML.Directives.markdown),module.directive("method",RAML.Directives.method),module.directive("namedParameters",RAML.Directives.namedParameters),module.directive("namedParametersDocumentation",RAML.Directives.namedParametersDocumentation),module.directive("oauth1",RAML.Directives.oauth1),module.directive("oauth2",RAML.Directives.oauth2),module.directive("parameterField",RAML.Directives.parameterField),module.directive("parameterFields",RAML.Directives.parameterFields),module.directive("parameterizedParameter",RAML.Directives.parameterizedParameter),module.directive("ramlConsole",RAML.Directives.ramlConsole),module.directive("ramlConsoleInitializer",RAML.Directives.ramlConsoleInitializer),module.directive("repeatable",RAML.Directives.repeatable),module.directive("repeatableAdd",RAML.Directives.repeatableAdd),module.directive("repeatableRemove",RAML.Directives.repeatableRemove),module.directive("resource",RAML.Directives.resource),module.directive("resourceDocumentation",RAML.Directives.resourceDocumentation),module.directive("responses",RAML.Directives.responses),module.directive("rootDocumentation",RAML.Directives.rootDocumentation),module.directive("securitySchemes",RAML.Directives.securitySchemes),module.directive("consoleTab",RAML.Directives.consoleTab),module.directive("consoleTabset",RAML.Directives.consoleTabset),module.directive("subtabs",RAML.Directives.subtabs),module.directive("uriBar",RAML.Directives.uriBar),module.directive("toggle",RAML.Directives.toggle),module.directive("toggleItem",RAML.Directives.toggleItem),module.directive("tryIt",RAML.Directives.tryIt),module.directive("validatedInput",RAML.Directives.validatedInput),module.controller("TryItController",RAML.Controllers.tryIt),module.service("DataStore",RAML.Services.DataStore),module.service("ramlParserWrapper",RAML.Services.RAMLParserWrapper),module.filter("nameFromParameterizable",RAML.Filters.nameFromParameterizable),module.filter("yesNo",RAML.Filters.yesNo)
}(),angular.module("ramlConsoleApp").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("views/api_resources.tmpl.html",'<ol class="resource-list resource-list-root" id="raml-console-api-reference" role="resources">\n  <li role="resource-group" class="resource-list-item" ng-repeat="resourceGroup in api.resourceGroups">\n    <header class="resource resource-root clearfix" ng-init="resource = resourceGroup[0]">\n      <div class="resource-path-container">\n        <button class="resource-root-toggle" ng-show="resourceGroup.length > 1">\n          <span class="visuallyhidden">See Nested Resources</span>\n        </button>\n\n        <h2 class="resource-heading resource-heading-large">\n          <span ng-repeat=\'segment in resource.pathSegments\' class="resource-path-active">{{segment.toString()}}</span>\n        </h2>\n\n        <span ng-if=\'resource.resourceType\' class="flag resource-heading-flag resource-heading-flag-root"><b>Type:</b> {{resource.resourceType|nameFromParameterizable}}</span>\n      </div>\n\n      <div class="tab-list">\n        <a class="tab" href="#" ng-repeat="method in resource.methods" ng-click="apiResources.openDocumentation($event, method, resource)">\n          <svg class="tab-image tab-{{method.method}}">\n            <use xlink:href="img/tab.svg#shape"></use>\n          </svg>\n\n          <span class="tab-label">{{method.method.toUpperCase()}}</span>\n        </a>\n      </div>\n\n      <button class="resource-close-btn" ng-click=\'apiResources.closePopover($event)\'>\n        Close\n      </button>\n    </header>\n\n    <resource-documentation api="api" raml-console="ramlConsole"></resource-documentation>\n\n    <ol class="resource-list">\n      <resource ng-repeat="resource in resourceGroup" ng-show="!$first"></resource>\n    </ol>\n  </li>\n</ol>\n'),$templateCache.put("views/api_resources.tmpl.old.html",'<div id="raml-console-api-reference" role="resources">\n  <div collapsible collapsed=\'apiResources.collapsed[apiResources.keyFor(resourceGroup)]\' role="resource-group" class="resource-group" ng-repeat="resourceGroup in api.resourceGroups">\n    <i collapsible-toggle class="fa" ng-class="{\'fa-caret-right\': collapsed, \'fa-caret-down\': !collapsed}"></i>\n\n    <div collapsible-toggle class="resource" role="resource-group-placeholder" ng-show="collapsed" ng-init="resource = resourceGroup[0]">\n      <div class="resource-placeholder" role="resource-placeholder">\n        <div class="resource-container">\n          <div class=\'resource\'>\n            <div>\n              <div class=\'summary accordion-toggle\'>\n                <h3 class="path">\n                  <span ng-repeat=\'segment in resource.pathSegments\'>{{segment.toString()}} </span>\n                </h3>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n\n    <div collapsible-content>\n      <resource ng-repeat="resource in resourceGroup"></resource>\n    </div>\n  </div>\n</div>\n'),$templateCache.put("views/basic_auth.tmpl.html",'<fieldset class="labelled-inline" role="basic">\n  <div class="control-group">\n    <label for="username">Username</label>\n    <input type="text" name="username" ng-model=\'credentials.username\'/>\n  </div>\n\n  <div class="control-group">\n    <label for="password">Password</label>\n    <input type="password" name="password" ng-model=\'credentials.password\'/>\n  </div>\n</fieldset>\n'),$templateCache.put("views/body_content.tmpl.html",'<section class="documentation-section request-body" ng-show="body">\n  <fieldset class="bordered">\n    <h2>Body</h2>\n\n    <toggle key-base="baseKey + \':body\'" toggle-model="body">\n      <toggle-item ng-repeat="contentType in body.contentTypes" heading="{{contentType}}">\n        <div class="labelled-inline" ng-if=\'body.isForm(contentType)\' ng-show="body.isSelected(contentType)">\n          <parameter-fields parameters=\'body.definitions[contentType]\'></parameter-fields>\n        </div>\n\n        <div ng-if="!body.isForm(contentType)" ng-show="body.isSelected(contentType)">\n          <textarea name="{{contentType}}" ng-model="body.definitions[contentType].value"></textarea>\n          <a href="#" class="body-prefill" ng-show="body.hasExample(contentType)" ng-click="body.fillWithExample($event)">Prefill with example</a>\n        </div>\n      </toggle-item>\n    </toggle>\n  </fieldset>\n</section>\n'),$templateCache.put("views/body_documentation.tmpl.html","<section class='body-documentation'>\n  <h2>Body</h2>\n\n  <toggle key-base='{{ bodyKey }}'>\n    <toggle-item ng-repeat='(contentType, definition) in body track by contentType' active=\"displayed[contentType]\" heading='{{contentType}}'>\n      <div ng-switch=\"contentType\">\n        <named-parameters-documentation ng-switch-when=\"application/x-www-form-urlencoded\" role='parameter-group' parameters='definition.formParameters'></named-parameters-documentation>\n        <named-parameters-documentation ng-switch-when=\"multipart/form-data\" role='parameter-group' parameters='definition.formParameters'></named-parameters-documentation>\n        <div ng-switch-default>\n"+'          <section ng-if="definition.example" role="example">\n            <h5>Example</h5>\n            <div class="code" code-mirror="definition.example" mode="{{contentType}}" visible="displayed[contentType]"></div>\n          </section>\n          <section ng-if="definition.schema" role="schema">\n            <a class="schema-toggle" ng-click="expandSchema(contentType)" ng-show="!schemaExpanded(contentType)">Show Schema</a>\n            <div ng-if="schemaExpanded(contentType)">\n              <h5>Schema</h5>\n              <div class="code" code-mirror="definition.schema" mode="{{contentType}}" visible="displayed[contentType] && schemaExpanded(contentType)"></div>\n            </div>\n          </section>\n        </div>\n      </div>\n    </toggle-item>\n  </toggle>\n</section>\n'),$templateCache.put("views/documentation.tmpl.html","<section class='documentation' role='documentation'>\n  <console-tabset key-base='{{ generateKey(resource.toString(), method) }}' heading='{{ method.method }}'>\n    <console-tab role='documentation-requests' heading=\"Request\" active='documentation.requestsActive' disabled=\"!documentation.hasRequestDocumentation()\">\n      <div class=\"modifiers\">\n"+'        <span class="modifier-group" ng-if="method.is">\n          <span class="caption">Traits:</span>\n          <ul role="traits">\n            <li class="trait" ng-repeat="trait in method.is" ng-bind="trait|nameFromParameterizable"></li>\n          </ul>\n        </span>\n      </div>\n\n      <div class="documentation-section" ng-if="method.description">\n        <section>\n          <h2>Description</h2>\n          <div role="full-description" class="description" markdown="method.description"></div>\n        </section>\n      </div>\n\n      <div class="documentation-section" ng-if=\'!documentation.isEmpty(method.plainAndParameterizedHeaders)\'>\n        <named-parameters-documentation heading=\'Headers\' role=\'parameter-group\' parameters=\'method.plainAndParameterizedHeaders\'></named-parameters-documentation>\n      </div>\n\n      <div class="documentation-section" ng-if=\'!documentation.isEmpty(resource.uriParametersForDocumentation)\'>\n        <named-parameters-documentation heading=\'URI Parameters\' role=\'parameter-group\' parameters=\'resource.uriParametersForDocumentation\'></named-parameters-documentation>\n      </div>\n\n      <div class="documentation-section" ng-if=\'!documentation.isEmpty(method.queryParameters)\'>\n        <named-parameters-documentation heading=\'Query Parameters\' role=\'parameter-group\' parameters=\'method.queryParameters\'></named-parameters-documentation>\n      </div>\n\n      <div class="documentation-section" ng-if=\'method.body && documentation.requestsActive\'>\n        <body-documentation body="method.body" key-base="generateKey(resource.toString(), method) + \':request\'"></body-documentation>\n      </div>\n    </console-tab>\n\n    <console-tab role="documentation-responses" heading="Responses"  active=\'documentation.responsesActive\' disabled=\'!documentation.hasResponseDocumentation()\'>\n      <responses></responses>\n    </console-tab>\n\n    <console-tab role="try-it" heading="Try It" active="documentation.tryItActive" disabled="!ramlConsole.tryItEnabled()">\n      <try-it></try-it>\n    </console-tab>\n  </console-tabset>\n</section>\n'),$templateCache.put("views/enum.tmpl.html",'<div class="autocomplete">\n  <span ng-transclude></span>\n  <ul ng-show="focused">\n    <li ng-click=\'selectItem(item)\' ng-class="{ selected: $index == selectedIndex }" ng-repeat="item in filteredEnum">\n      {{item}}\n    </li>\n  </ul>\n</div>\n'),$templateCache.put("views/method.tmpl.html",'<div class="method {{method.method}}" role="method">\n  <documentation></documentation>\n</div>\n'),$templateCache.put("views/named_parameters.tmpl.html",'<section id="sidebar-headers" ng-show="displayParameters()">\n  <header class="sidebar-row sidebar-subheader">\n    <h4 class="sidebar-subhead">{{heading}}</h4>\n  </header>\n\n  <parameter-fields parameters="parameters"></parameter-fields>\n</section>\n'),$templateCache.put("views/named_parameters_documentation.tmpl.html",'<section class="resource-section">\n  <h3 class="resource-heading-a">{{heading}}</h3>\n\n  <div class="resource-param" ng-repeat=\'parameter in parameters\'>\n    <div ng-repeat="definition in parameter">\n      <h4 class="resource-param-heading">{{definition.displayName}} <span class="resource-param-instructional">{{namedParametersDocumentation.constraints(definition)}}</span></h4>\n\n      <span markdown="definition.description"></span>\n      <div ng-if="definition.example"><span class="label">Example:</span> <code class="well" role="example">{{definition.example}}</code></div>\n    </div>\n  </div>\n</section>\n'),$templateCache.put("views/oauth1.tmpl.html",'<fieldset class="labelled-inline" role="oauth1">\n  <div class="control-group">\n    <label for="consumerKey">Consumer Key</label>\n    <input type="text" name="consumerKey" ng-model=\'credentials.consumerKey\'/>\n  </div>\n\n  <div class="control-group">\n    <label for="consumerSecret">Consumer Secret</label>\n    <input type="password" name="consumerSecret" ng-model=\'credentials.consumerSecret\'/>\n  </div>\n</fieldset>\n'),$templateCache.put("views/oauth2.tmpl.html",'<fieldset class="labelled-inline" role="oauth2">\n  <div class="control-group">\n    <label for="clientId">Client ID</label>\n    <input type="text" name="clientId" ng-model=\'credentials.clientId\'/>\n  </div>\n\n  <div class="control-group">\n    <label for="clientSecret">Client Secret</label>\n    <input type="password" name="clientSecret" ng-model=\'credentials.clientSecret\'/>\n  </div>\n</fieldset>\n'),$templateCache.put("views/parameter_field.tmpl.html","<ng-switch on='inputType' class='parameter-field-input'>\n  <span ng-switch-when=\"file\">\n    <input name=\"{{name}}\" type='file' ng-model='$parent.model'/>\n  </span>\n\n  <span ng-switch-when=\"enum\">\n    <enum options='definition.enum' model='$parent.model' contained-by=\"containedBy\">\n      <input validated-input name=\"{{name}}\" type='text' ng-model='$parent.model' placeholder='{{placeholder}}' ng-trim=\"false\" constraints='definition' invalid-class='invalidClass'/>\n    </enum>\n  </span>\n\n  <span ng-switch-default>\n    <input validated-input name=\"{{name}}\" type='text' ng-model='$parent.model' placeholder='{{placeholder}}' ng-trim=\"false\" constraints='definition' invalid-class='invalidClass'/>\n  </span>\n</ng-switch>\n"),$templateCache.put("views/parameter_fields.tmpl.html",'<div class="sidebar-row" ng-repeat="(parameterName, parameter) in parameters.plain track by parameterName">\n  <p class="sidebar-input-container" ng-repeat="definition in parameter.definitions" ng-show="parameter.isSelected(definition)">\n    <button class="sidebar-input-reset"><span class="visuallyhidden">Reset field</span></button>\n    <span class="sidebar-input-tooltip-container">\n      <button class="sidebar-input-tooltip"><span class="visuallyhidden">Show documentation</span></button>\n      <span class="sidebar-tooltip-flyout">\n        <span>Use .json to specify application/json media type.</span>\n      </span>\n    </span>\n    <parameter-field name=\'parameterName\' model=\'repeatableModel[$index]\' definition=\'definition\' ></parameter-field>\n    <parameterized-parameter parameter-name="name" parameters="parameters"></parameterized-parameter>\n  </p>\n</div>\n'),$templateCache.put("views/parameterized_parameter.tmpl.html",'<div class="labelled-inline">\n  <label for="{{parameterName}}">{{parameterName}}:</label>\n  <a href=\'#\' role="open-factory" ng-click="parameterFactory.open($event)" ng-hide="parameterFactory.opened">Add Header<i class=\'fa fa-plus-square\'></i></a>\n  <span ng-show="parameterFactory.opened">\n    <input type="text" name="{{parameterName}}" ng-model="parameterFactory.value" ng-class="parameterFactory.status"/>\n'+"    <a href='#' role='create-parameter' ng-click=\"parameterFactory.create($event)\"><i class='fa fa-plus-square'></i></a>\n  </span>\n</div>\n"),$templateCache.put("views/raml-console.tmpl.html",'<main class="container primary" role="api-console" id="raml-console">\n  <h1 class="title">{{api.title}}</h1>\n\n  <div ng-if=\'api.resourceGroups.length > 0\'>\n    <api-resources ng-if=\'api.resourceGroups.length > 0\'></api-resources>\n  </div>\n</main>\n'),$templateCache.put("views/raml-console.tmpl.old.html",'<article role="api-console" id="raml-console">\n  <resource-documentation api="api" raml-console="ramlConsole"></resource-documentation>\n  <div role="error" ng-if="parseError">\n    {{parseError}}\n  </div>\n\n  <nav id="raml-console-main-nav" ng-if=\'ramlConsole.showRootDocumentation()\' ng-switch=\'ramlConsole.view\'>\n    <a class="btn" ng-switch-when=\'rootDocumentation\' role="view-api-reference" ng-click=\'ramlConsole.gotoView("apiReference")\'>&larr; API Reference</a>\n    <a class="btn" ng-switch-default role="view-root-documentation" ng-click=\'ramlConsole.gotoView("rootDocumentation")\'>Documentation &rarr;</a>\n  </nav>\n\n  <div id="raml-console-content">\n    <div class="inner" ng-switch=\'ramlConsole.view\'>\n      <div ng-switch-when=\'rootDocumentation\'>\n        <root-documentation></root-documentation>\n      </div>\n      <div ng-switch-default>\n        <div ng-if=\'api.resourceGroups.length > 0\'>\n          <api-resources></api-resources>\n        </div>\n      </div>\n    </div>\n  </div>\n</article>\n'),$templateCache.put("views/repeatable.tmpl.html",'<div ng-if="repeatable" ng-repeat="model in repeatableModel track by $index">\n  <div ng-transclude></div>\n</div>\n\n<div ng-if="!repeatable">\n  <div ng-transclude></div>\n</div>\n'),$templateCache.put("views/resource.tmpl.html",'<li class="resource-list-item">\n  <div class="resource clearfix">\n    <div class="resource-path-container">\n      <h3 class="resource-heading">\n        <span ng-repeat=\'segment in resource.pathSegments\' ng-class="{\'resource-path-active\':$last}">{{segment.toString()}}</span>\n      </h3>\n\n      <span class="flag resource-heading-flag"><b>Type:</b> {{resource.resourceType|nameFromParameterizable}}</span>\n    </div>\n\n    <div class="tab-list">\n      <a class="tab" href="#" ng-click="resourceView.openDocumentation($event, method, resource)" ng-repeat="method in resource.methods">\n        <svg class="tab-image tab-{{method.method}}">\n          <use xlink:href="img/tab.svg#shape"></use>\n        </svg>\n\n        <span class="tab-label">{{method.method.toUpperCase()}}</span>\n      </a>\n    </div>\n\n    <button class="resource-close-btn" ng-click=\'resourceView.closePopover($event)\'>\n      Close\n    </button>\n  </div>\n  <resource-documentation api="api" raml-console="ramlConsole"></resource-documentation>\n</li>\n'),$templateCache.put("views/resource.tmpl.old.html",'<div class="resource-placeholder" role="resource-placeholder">\n  <div class="resource-container">\n    <div ng-class="{expanded: resourceView.expanded || selectedMethod}" class=\'resource\' role="resource" ng-click=\'resourceView.toggleExpansion()\'>\n      <div>\n        <div class=\'summary accordion-toggle\' role=\'resource-summary\'>\n          <div class="modifiers" ng-class="{expanded: selectedMethod}" ng-show=\'resourceView.expanded || selectedMethod\'>\n            <span class="modifier-group" ng-if=\'resource.resourceType\'>\n              <span class="caption">Type:</span>\n              <ul>\n                <li class="resource-type" role="resource-type" ng-bind="resource.resourceType|nameFromParameterizable"></li>\n              </ul>\n            </span>\n            <span class="modifier-group" ng-if=\'resource.traits.length > 0\'>\n              <span class="caption">Traits:</span>\n              <ul>\n                <li class="trait" ng-show=\'resourceView.expanded\' role="trait" ng-repeat="trait in resource.traits" ng-bind="trait|nameFromParameterizable"></li>\n              </ul>\n            </span>\n          </div>\n\n          <h3 class="path">\n            <span role=\'segment\' ng-repeat=\'segment in resource.pathSegments\'>{{segment.toString()}} </span>\n          </h3>\n          <ul class=\'methods\' role="methods" ng-if="resource.methods">\n            <li class=\'method-name\' ng-class=\'method.method\' ng-click="resourceView.openDocumentation($event, method)" ng-repeat="method in resource.methods">{{method.method}}</li>\n          </ul>\n        </div>\n      </div>\n\n      <div role=\'description\'\n           class=\'description\'\n           ng-show=\'resourceView.expanded && resource.description\'\n           markdown=\'resource.description\'>\n      </div>\n    </div>\n  </div>\n</div>\n'),$templateCache.put("views/resource_documentation.tmpl.html",'<div class="resource-panel">\n  <div class="resource-panel-wrapper">\n    <div class="sidebar">\n      <div class="sidebar-flex-wrapper">\n        <div class="sidebar-content">\n          <header class="sidebar-row sidebar-header">\n            <h3 class="sidebar-head">\n              Try it\n              <a href="#" class="sidebar-fullscreen-toggle js-sidebar-fullscreen" ng-click="toggleFullScreen()">\n                <img src="img/icn-expand.svg" alt="">\n                <span class="visuallyhidden">Expand</span>\n              </a>\n            </h3>\n          </header>\n\n          <!-- Show more -->\n          <div class="sidebar-show-more">\n            <p>\n              more <img src="img/icn-chevron-down.svg" alt="">\n            </p>\n          </div>\n\n          <div class="sidebar-content-wrapper">\n            <section>\n              <header class="sidebar-row sidebar-subheader sidebar-subheader-top">\n                <h4 class="sidebar-subhead">Authentication</h4>\n              </header>\n\n              <div class="sidebar-row">\n                <div class="toggle-group sidebar-toggle-group">\n                  <button class="toggle toggle-mini is-active">Anonymous</button>\n                  <button class="toggle toggle-mini">oauth_2_0</button>\n                </div>\n              </div>\n            </section>\n\n            <section id="sidebar-uri-parameters" ng-show="displayUriParameters()">\n              <header class="sidebar-row sidebar-subheader">\n                <h4 class="sidebar-subhead">URI Parameters</h4>\n              </header>\n\n              <div class="sidebar-row">\n                <p class="sidebar-input-container" ng-repeat="(parameterName, parameter) in resource.uriParametersForDocumentation track by parameterName">\n                  <button class="sidebar-input-reset"><span class="visuallyhidden">Reset field</span></button>\n                  <span class="sidebar-input-tooltip-container">\n                    <button class="sidebar-input-tooltip"><span class="visuallyhidden">Show documentation</span></button>\n                    <span class="sidebar-tooltip-flyout">\n                      <span>Use .json to specify application/json media type.</span>\n                    </span>\n                  </span>\n                  <label for="mediaTypeExtension" class="sidebar-label">{{parameterName}}</label>\n                  <input id="mediaTypeExtension" class="sidebar-input" value=".json">\n                </p>\n              </div>\n            </section>\n\n            <section id="sidebar-headers" ng-show="displayHeaders()">\n              <header class="sidebar-row sidebar-subheader">\n                <h4 class="sidebar-subhead">Headers</h4>\n              </header>\n\n\n              <div class="sidebar-row">\n                <p class="sidebar-input-container" ng-repeat="(parameterName, parameter) in method.headers.plain track by parameterName">\n                  <button class="sidebar-input-reset"><span class="visuallyhidden">Reset field</span></button>\n                  <span class="sidebar-input-tooltip-container">\n                    <button class="sidebar-input-tooltip"><span class="visuallyhidden">Show documentation</span></button>\n                    <span class="sidebar-tooltip-flyout">\n                      <span>Use .json to specify application/json media type.</span>\n                    </span>\n                  </span>\n                  <label for="accept" class="sidebar-label">{{parameterName}}</label>\n                  <input id="accept" class="sidebar-input">\n                </p>\n              </div>\n            </section>\n\n            <section ng-show="displayQueryParameters()">\n              <header class="sidebar-row sidebar-subheader">\n                <h4 class="sidebar-subhead">Query Parameters</h4>\n              </header>\n\n              <div class="sidebar-row">\n                <p id="sidebar-query-parameters-all" class="sidebar-input-container" ng-repeat="(parameterName, parameter) in method.queryParameters track by parameterName">\n                  <button class="sidebar-input-reset"><span class="visuallyhidden">Reset field</span></button>\n                  <span class="sidebar-input-tooltip-container">\n                    <button class="sidebar-input-tooltip"><span class="visuallyhidden">Show documentation</span></button>\n                    <span class="sidebar-tooltip-flyout">\n                      <span>Use .json to specify application/json media type.</span>\n                    </span>\n                  </span>\n                  <label for="all" class="sidebar-label">{{parameterName}}</label>\n                  <input id="all" class="sidebar-input">\n                </p>\n              </div>\n            </section>\n\n            <section>\n              <header class="sidebar-row sidebar-subheader">\n                <h4 class="sidebar-subhead">Request URI</h4>\n              </header>\n\n              <div class="sidebar-row">\n                <p class="sidebar-response-item sidebar-request-url">{{api.baseUri.toString()}}</p>\n\n                <div class="sidebar-action-group">\n                  <button class="sidebar-action sidebar-action-get">{{method.method.toUpperCase()}}</button>\n                </div>\n              </div>\n            </section>\n\n            <section>\n              <header class="sidebar-row sidebar-header">\n                <h3 class="sidebar-head sidebar-head-expand">\n                  <button class="sidebar-expand-btn is-collapsed js-toggle-request-metadata">\n                    Request\n                  </button>\n                </h3>\n                <button class="resource-btn">Copy</button>\n              </header>\n              <div class="sidebar-request-metadata">\n\n                <div class="sidebar-row">\n                  <h3 class="sidebar-response-head">Headers</h3>\n                  <div class="sidebar-response-item">\n                    <p class="sidebar-response-metadata">\n                      <b>Accept:</b> <br>bytes\n                    </p>\n                  <p class="sidebar-response-metadata">\n                      <b>X-GitHub-Media-Type:</b> <br>keep-alive\n                    </p>\n                    <p class="sidebar-response-metadata">\n                      <b>X-GitHub-Request-Id:</b> <br>gzip\n                    </p>\n                    <p class="sidebar-response-metadata">\n                      <b>X-RateLimit-Limit:</b> <br>86\n                    </p>\n                    <p class="sidebar-response-metadata">\n                      <b>X-RateLimit-Remaining:</b> <br>application/json; charset=utf-8\n                    </p>\n                    <p class="sidebar-response-metadata">\n                      <b>X-RateLimit-Reset:</b> <br>Thu, 05 Jun 2014 02:09:20 GMT\n                    </p>\n                  </div>\n\n                  <h3 class="sidebar-response-head sidebar-response-head-pre">Body</h3>\n  <pre class="sidebar-pre"><code>{\n    "body": [\n      {\n        "message": "This is an example",\n        "example": 215\n      }\n    ]\n  }</code></pre>\n                </div>\n              </div>\n            </section>\n\n            <section>\n              <header class="sidebar-row sidebar-header">\n                <h3 class="sidebar-head">Response</h3>\n              </header>\n\n              <div class="sidebar-row">\n                <h3 class="sidebar-response-head">Status</h3>\n                <p class="sidebar-response-item">200</p>\n\n                <h3 class="sidebar-response-head">Headers</h3>\n                <div class="sidebar-response-item">\n                  <p class="sidebar-response-metadata">\n                    <b>accept-ranges:</b> <br>bytes\n                  </p>\n                <p class="sidebar-response-metadata">\n                    <b>connection:</b> <br>keep-alive\n                  </p>\n                  <p class="sidebar-response-metadata">\n                    <b>content-encoding:</b> <br>gzip\n                  </p>\n                  <p class="sidebar-response-metadata">\n                    <b>content-length:</b> <br>86\n                  </p>\n                  <p class="sidebar-response-metadata">\n                    <b>content-type:</b> <br>application/json; charset=utf-8\n                  </p>\n                  <p class="sidebar-response-metadata">\n                    <b>date:</b> <br>Thu, 05 Jun 2014 02:09:20 GMT\n                  </p>\n                  <p class="sidebar-response-metadata">\n                    <b>strict-transport-security:</b> <br>max-age=631138519\n                  </p>\n                  <p class="sidebar-response-metadata">\n                    <b>x-varnish-cache:</b> <br>MISS\n                  </p>\n                  </p>\n                </div>\n\n                <h3 class="sidebar-response-head sidebar-response-head-pre">Body</h3>\n<pre class="sidebar-pre"><code>{\n  "errors": [\n    {\n      "message": "Bad Authentication data",\n      "code": 215\n    }\n  ]\n}</code></pre>\n              </div>\n            </section>\n          </div>\n        </div>\n\n        <!-- Sidebar control to intermediate view -->\n        <div class="sidebar-controls sidebar-controls-collapse js-sidebar-collapse-toggle">\n          <button class="collapse" ng-click="collapseTryIt()">\n            <span class="discoverable">Try it</span>\n            <img src="img/icn-expand.svg" alt="">\n          </button>\n        </div>\n\n        <!-- Sidebar control to full-screen/full-width view -->\n        <div class="sidebar-controls sidebar-controls-fullscreen js-sidebar-fullscreen">\n          <button class="collapse">\n            <span class="discoverable">Try it</span>\n            <img src="img/icn-expand.svg" alt="">\n          </button>\n        </div>\n\n      </div>\n    </div>\n\n    <div class="resource-panel-primary">\n      <div class="resource-panel-subheader resource-panel-primary-row clearfix">\n        <div class="resource-panel-description">\n          <p class="description"></p>\n        </div>\n\n        <ul class="flag-list resource-panel-flag-list" ng-if=\'resource.traits.length > 0\'>\n          <li class="flag" ng-repeat="trait in resource.traits"><b>Trait:</b> {{trait|nameFromParameterizable}}</li>\n        </ul>\n\n        <ul class="flag-list resource-panel-flag-list" ng-if=\'resource.resourceType\'>\n          <li class="flag"><b>Type:</b> {{resource.resourceType|nameFromParameterizable}}</li>\n        </ul>\n      </div>\n\n      <div class="resource-panel-tabs clearfix">\n\n        <div class="toggle-tabs resource-panel-toggle-tabs">\n          <a href="#" class="toggle-tab is-active" ng-click=\'showRequest($event)\'>Request</a><a href="#" class="toggle-tab" ng-click=\'showResponse($event)\'>Response</a>\n        </div>\n      </div>\n\n      <!-- Request -->\n<div class="resource-request resource-panel-primary-row resource-panel-content is-active">\n  <h3 class="resource-heading-a">Description</h3>\n\n  <p>{{method.description}}</p>\n\n  <named-parameters-documentation ng-if=\'!isEmpty(resource.uriParametersForDocumentation)\' heading=\'URI Parameters\' role=\'parameter-group\' parameters=\'resource.uriParametersForDocumentation\'></named-parameters-documentation >\n\n  <named-parameters-documentation ng-if=\'!isEmpty(method.plainAndParameterizedHeaders)\' heading=\'Headers\' role=\'parameter-group\' parameters=\'method.plainAndParameterizedHeaders\'></named-parameters-documentation>\n\n  <named-parameters-documentation ng-if=\'!isEmpty(method.queryParameters)\' heading=\'Query Parameters\' role=\'parameter-group\' parameters=\'method.queryParameters\'></named-parameters-documentation>\n</div>\n\n<!-- Response -->\n<div class="resource-response resource-panel-primary-row resource-panel-content">\n  <div class="resource-response-jump">\n    <p>\n      Jump to status\n      <span class="resource-btns" ng-repeat=\'(responseCode, response) in method.responses\'>\n        <a class="resource-btn" href="#code{{responseCode}}">{{responseCode}}</a>\n      </span>\n    </p>\n  </div>\n\n  <section id="#code{{responseCode}}" class="resource-status-{{responseCode}} resource-section resource-response-section" ng-repeat=\'(responseCode, response) in method.responses\'>\n    <a name="code{{responseCode}}"></a>\n    <h3 class="resource-heading-a">Status {{responseCode}}</h3>\n    <div markdown=\'response.description\'></div>\n    <div class="resource-response" ng-if="response.body" ng-repeat=\'(contentType, definition) in response.body track by contentType\'>\n      <h4 class="resource-body-heading">\n        Body\n        <span class="flag">{{contentType}}</span>\n      </h4>\n\n      <span>Example:</span>\n      <pre class="resource-pre"><code>{{definition.example}}</code></pre>\n\n      <p><button class="resource-btn js-schema-toggle" ng-if="definition.schema" ng-click="showSchema(responseCode)">Show Schema</button></p>\n      <pre class="resource-pre" ng-show="resourceStatus{{responseCode}}"><code>{{definition.schema}}</code></pre>\n    </div>\n  </section>\n\n</div>\n\n\n    </div>\n  </div>\n</div>\n'),$templateCache.put("views/resource_documentation.tmpl.old.html",'<div class="resource-placeholder resource-popover mask-resource-list" ng-show="resource">\n  <div class="resource-container">\n    <div class="resource expanded" ng-if="resource">\n      <div>\n        <i class="fa fa-times collapse" ng-click=\'closePopover($event)\'></i>\n\n        <div class="summary accordion-toggle" role="resource-summary">\n          <div class="modifiers expanded">\n            <span class="modifier-group" ng-if=\'resource.resourceType\'>\n              <span class="caption">Type:</span>\n              <ul>\n                <li class="resource-type" role="resource-type" ng-bind="resource.resourceType|nameFromParameterizable"></li>\n              </ul>\n            </span>\n            <span class="modifier-group" ng-if=\'resource.traits.length > 0\'>\n              <span class="caption">Traits:</span>\n              <ul>\n                <li class="trait" role="trait" ng-repeat="trait in resource.traits" ng-bind="trait|nameFromParameterizable"></li>\n              </ul>\n            </span>\n          </div>\n\n          <h3 class="path">\n            <span role=\'segment\' ng-repeat=\'segment in resource.pathSegments\'>{{segment.toString()}} </span>\n          </h3>\n          <ul class=\'methods\' role="methods" ng-if="resource.methods">\n            <li class=\'method-name\' ng-class=\'method.method\' ng-repeat="method in resource.methods" ng-click="selectMethod(method)">{{method.method}}</li>\n          </ul>\n        </div>\n      </div>\n\n      <method ng-repeat="method in resource.methods" ng-if="method === selectedMethod"></method>\n    </div>\n  </div>\n</div>\n'),$templateCache.put("views/responses.tmpl.html","<section class=\"responses\">\n  <subtabs tabs=\"method.responseCodes\" key-base=\"{{ resource.toString() + ':' + method.method }}\"></subtabs>\n  <div class=\"documentation-section response\" expanded='responsesView.expanded[responseCode]' ng-repeat='(responseCode, response) in method.responses'>\n    <a id=\"{{responseCode}}\" class=\"response-code\" role=\"response-code\"> {{responseCode}} </a>\n    <section role='response'>\n      <div markdown='response.description'></div>\n      <div ng-if='!documentation.isEmpty(response.headers)'>\n        <named-parameters-documentation heading='Headers' role='parameter-group' parameters='response.headers'></named-parameters-documentation>\n      </div>\n\n      <div ng-if=\"response.body && documentation.responsesActive\" class='body-documentation'>\n        <body-documentation body=\"response.body\" key-base='keyBase + \":responses:\" + responseCode'></body-documentation>\n      </div>\n    </section>\n  </div>\n</section>\n"),$templateCache.put("views/root_documentation.tmpl.html",'<div role="root-documentation">\n  <section collapsible expanded=\'expanded\' ng-repeat="document in api.documentation">\n    <h2 collapsible-toggle>{{document.title}}</h2>\n    <div collapsible-content class="content">\n      <div markdown=\'document.content\'></div>\n    </div>\n  </section>\n</div>\n'),$templateCache.put("views/security_schemes.tmpl.html",'<section class="documentation-section authentication">\n  <fieldset class="bordered">\n    <h2>Authentication</h2>\n\n    <toggle key-base="baseKey + \':securitySchemes\'" toggle-model="keychain">\n      <toggle-item heading="Anonymous"></toggle-item>\n      <toggle-item ng-repeat="(name, scheme) in schemes" heading="{{name}}">\n        <div ng-switch="scheme.type">\n          <basic-auth ng-switch-when="Basic Authentication" credentials=\'keychain[name]\'></basic-auth>\n          <oauth1 ng-switch-when="OAuth 1.0" credentials=\'keychain[name]\'></oauth1>\n          <oauth2 ng-switch-when="OAuth 2.0" credentials=\'keychain[name]\'></oauth2>\n        </div>\n      </toggle-item>\n    </toggle>\n  </fieldset>\n</section>\n'),$templateCache.put("views/tab.tmpl.html",'<div class="method-content" ng-class="{active: active, disabled: disabled}" ng-show="active" ng-transclude>\n</div>\n'),$templateCache.put("views/tabset.tmpl.html",'<div class="method-nav-container">\n  <div class="method-nav">\n    <ul class="method-nav-group">\n      <li>\n        <a>{{heading}}</a>\n      </li>\n\n      <li class="method-nav-item" ng-repeat="item in tabset.tabs" ng-class="{active: item.active, disabled: item.disabled}">\n        <a ng-click="tabset.select(item)">{{item.heading}}</a>\n      </li>\n    </ul>\n\n    <ul ng-repeat="item in tabset.tabs" class="method-nav-group method-sub-nav" ng-if="tabset.active.heading == item.heading && item.subtabs">\n      <li>\n        <a>{{item.heading}}</a>\n      </li>\n      <li class="method-nav-item" ng-repeat="subItem in item.subtabs" ng-click="item.select(subItem)" ng-class="{active: item.selected(subItem)}">\n        <a>{{subItem}}</a>\n      </li>\n    </ul>\n\n    <div class="method-nav-group method-sub-nav uri-bar" ng-repeat="item in tabset.tabs" ng-if="tabset.active.heading == item.heading && item.uriBar">\n      <span role="path" class="path">\n        <span class="segment">\n          <span ng-repeat=\'token in item.uriBar.baseUri.tokens track by $index\'>\n            <span ng-if=\'item.uriBar.baseUri.parameters[token]\'>\n'+"              <parameter-field name='token' placeholder='token' model='item.uriBar.pathBuilder.baseUriContext[token]' definition='item.uriBar.baseUri.parameters[token]' invalid-class='error'\n              contained-by='[role=\"documentation\"]'></parameter-field>\n            </span>\n            <span class=\"segment\" ng-if=\"!item.uriBar.baseUri.parameters[token]\">{{token}}</span>\n          </span>\n          <span role='segment' ng-repeat='segment in item.uriBar.pathSegments' ng-init=\"$segmentIndex = $index\">\n            <span ng-repeat='token in segment.tokens track by $index'>\n              <span ng-if='segment.parameters[token]'>\n                <parameter-field name='token' placeholder='token' model='item.uriBar.pathBuilder.segmentContexts[$segmentIndex][token]' definition='segment.parameters[token]' invalid-class='error' contained-by='[role=\"documentation\"]'></parameter-field>\n              </span>\n              <span class=\"segment\" ng-if=\"!segment.parameters[token]\">{{token}}</span>\n            </span>\n          </span>\n        </span>\n      </span>\n    </div>\n  </div>\n\n  <div class=\"method-content-container\" ng-transclude>\n  </div>\n<div>\n"),$templateCache.put("views/toggle-item.tmpl.html",'<div class="toggle-item" ng-class="{active: active, disabled: disabled}" ng-show="active" ng-transclude></div>\n'),$templateCache.put("views/toggle.tmpl.html",'<div class="toggle">\n  <fieldset class="labelled-radio-group">\n    <div class="radio-group">\n      <label class="radio" ng-repeat="item in toggleItems" ng-class="{active: item.active, disabled: item.disabled}">\n        <span ng-click="toggle.select(item)">{{item.heading}}</span>\n      </label>\n    </div>\n  </fieldset>\n\n  <div class="item-content" ng-transclude></div>\n</div>\n'),$templateCache.put("views/try_it.tmpl.html",'<section class="try-it">\n  <form>\n    <uri-bar base-uri="api.baseUri" path-segments="resource.pathSegments" path-builder="context.pathBuilder"></uri-bar>\n\n    <security-schemes ng-if="apiClient.securitySchemes" schemes="apiClient.securitySchemes" keychain="ramlConsole.keychain" base-key="apiClient.baseKey()"></security-schemes>\n    <named-parameters heading="Headers" parameters="context.headers"></named-parameters>\n    <named-parameters heading="Query Parameters" parameters="context.queryParameters"></named-parameters>\n    <!-- the ng-if below reinstantiates the try it directive which results in the try it\n         section getting updated when a method is selected in the resource popover.\n    -->\n    <body-content ng-if="context.bodyContent" body="context.bodyContent"></body-content>\n\n\n    <div class="form-actions">\n      <i ng-show=\'apiClient.inProgress()\' class="fa fa-spinner fa-spin fa-lg"></i>\n\n      <div role="error" class="error" ng-show="apiClient.missingUriParameters">\n        Required URI Parameters must be entered\n      </div>\n      <div role="warning" class="warning" ng-show="apiClient.disallowedAnonymousRequest">\n        Successful responses require authentication\n      </div>\n      <button role="try-it" ng-class="\'btn-\' + method.method" ng-click="apiClient.execute()">\n        {{method.method}}\n      </button>\n    </div>\n  </form>\n\n  <div class="response" ng-if="apiClient.response">\n    <h4>Response</h4>\n    <div class="request-url">\n      <h5>Request URL</h5>\n      <code class="response-value">{{apiClient.response.requestUrl}}</code>\n    </div>\n\n    <div class="status">\n      <h5>Status</h5>\n      <code class="response-value">{{apiClient.response.status}}</code>\n    </div>\n    <div class="headers">\n      <h5>Headers</h5>\n      <ul class="response-value">\n        <li ng-repeat="(header, value) in apiClient.response.headers track by header">\n          <code>\n            <span class="header-key">{{header}}:</span>\n            <span class="header-value">{{value}}</span>\n          </code>\n        </li>\n      </ul>\n    </div>\n    <div class="body" ng-if="apiClient.response.body">\n      <h5>Body</h5>\n      <div class="response-value">\n        <div class="code" mode=\'{{apiClient.response.contentType}}\' code-mirror="apiClient.response.body" visible="apiClient.response.body"></div>\n      </div>\n    </div>\n  </div>\n</section>\n')
}]);