/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.parameters;

import com.jayway.restassured.RestAssured;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class FormParametersTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/parameters/form-parameters-config.xml";
    }

    @Test
    public void validMultipartFormProvided() throws Exception {
        RestAssured.given().multiPart("first", "primero").multiPart("second", "segundo").multiPart("third", "true").multiPart("payload", "3.4").expect().response().statusCode(201).when().post("/api/multipart", new Object[0]);
    }

    @Test
    public void requiredMultipartFormParamNotProvided() throws Exception {
        RestAssured.given().multiPart("second", "segundo").multiPart("third", "true").multiPart("payload", "3.4").expect().response().statusCode(400).when().post("/api/multipart", new Object[0]);
    }

    @Test
    public void validUrlencodedFormProvided() throws Exception {
        RestAssured.given().header("Content-Type", (Object)"application/x-www-form-urlencoded", new Object[0]).formParam("first", new Object[]{"prime"}).formParam("second", new Object[]{"segundo"}).formParam("third", new Object[]{"true"}).expect().response().statusCode(201).when().post("/api/url-encoded", new Object[0]);
    }

    @Test
    public void requiredUrlencodedFormParamNotProvided() throws Exception {
        RestAssured.given().header("Content-Type", (Object)"application/x-www-form-urlencoded", new Object[0]).formParam("second", new Object[]{"segundo"}).formParam("third", new Object[]{"true"}).expect().response().statusCode(400).when().post("/api/url-encoded", new Object[0]);
    }

    @Test
    public void invalidTypeUrlencodedFormProvided() throws Exception {
        RestAssured.given().header("Content-Type", (Object)"application/x-www-form-urlencoded", new Object[0]).formParam("first", new Object[]{"prime"}).formParam("second", new Object[]{"segundo"}).formParam("third", new Object[]{"35"}).expect().response().statusCode(400).when().post("/api/url-encoded", new Object[0]);
    }

    @Test
    public void invalidEnumUrlencodedFormProvided() throws Exception {
        RestAssured.given().header("Content-Type", (Object)"application/x-www-form-urlencoded", new Object[0]).formParam("first", new Object[]{"prime"}).formParam("second", new Object[]{"second"}).expect().response().statusCode(400).when().post("/api/url-encoded", new Object[0]);
    }
}

