/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.util.Collection;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.apikit.AbstractConfiguration;
import org.mule.module.apikit.ConsoleHandler;
import org.mule.module.apikit.HttpRestRouterRequest;
import org.raml.model.ActionType;
import org.raml.model.Raml;

public class Console
implements MessageProcessor,
Initialisable,
MuleContextAware,
FlowConstructAware {
    private AbstractConfiguration config;
    private MuleContext muleContext;
    private ConsoleHandler consoleHandler;
    private FlowConstruct flowConstruct;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public void setConfig(AbstractConfiguration config) {
        this.config = config;
    }

    public AbstractConfiguration getConfig() {
        return this.config;
    }

    private Raml getApi() {
        return this.getConfig().getApi();
    }

    public void initialise() throws InitialisationException {
        if (this.flowConstruct == null) {
            return;
        }
        if (this.config == null) {
            Collection<AbstractConfiguration> configurations = AbstractConfiguration.getAllConfigurations(this.muleContext);
            if (configurations.size() != 1) {
                throw new InitialisationException(MessageFactory.createStaticMessage((String)"APIKit configuration not Found"), (Initialisable)this);
            }
            this.config = configurations.iterator().next();
        }
        this.consoleHandler = new ConsoleHandler(this.getConfig().getEndpointAddress(this.flowConstruct), "");
        this.config.addConsoleUrl(this.consoleHandler.getConsoleUrl());
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        HttpRestRouterRequest request = new HttpRestRouterRequest(event, this.getConfig());
        String path = request.getResourcePath();
        if ((path.isEmpty() || path.equals("/")) && ActionType.GET.toString().equals(request.getMethod().toUpperCase()) && request.getAdapter().getAcceptableResponseMediaTypes().contains("application/raml+yaml")) {
            String raml = this.config.getApikitRaml(event);
            event.getMessage().setPayload((Object)raml);
            event.getMessage().setOutboundProperty("Content-Type", (Object)"application/raml+yaml");
            event.getMessage().setOutboundProperty("Content-Length", (Object)raml.length());
            event.getMessage().setOutboundProperty("Access-Control-Allow-Origin", (Object)"*");
            return event;
        }
        return this.consoleHandler.process(event);
    }
}

