/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.jayway.restassured.RestAssured;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class RootResourceTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/resource/root-resource-config.xml";
    }

    @Test
    public void getRootResource() throws Exception {
        RestAssured.given().header("Accept", (Object)"text/plain", new Object[0]).expect().response().body(CoreMatchers.containsString((String)"root"), new Matcher[0]).header("Content-type", "text/plain").statusCode(200).when().get("/api", new Object[0]);
    }

    @Test
    public void getRootResourceWithSlash() throws Exception {
        RestAssured.given().header("Accept", (Object)"text/plain", new Object[0]).expect().response().body(CoreMatchers.containsString((String)"root"), new Matcher[0]).header("Content-type", "text/plain").statusCode(200).when().get("/api/", new Object[0]);
    }

    @Test
    public void getResourceUnderRoot() throws Exception {
        RestAssured.given().header("Accept", (Object)"text/plain", new Object[0]).expect().response().body(CoreMatchers.containsString((String)"under"), new Matcher[0]).header("Content-type", "text/plain").statusCode(200).when().get("/api//under", new Object[0]);
    }

    @Test
    public void getResourceUnderRootSingleSlashNotFound() throws Exception {
        RestAssured.given().header("Accept", (Object)"text/plain", new Object[0]).expect().response().body(CoreMatchers.containsString((String)"not found"), new Matcher[0]).header("Content-type", "text/plain").statusCode(404).when().get("/api/under", new Object[0]);
    }

    @Test
    public void getLevelRootResource() throws Exception {
        RestAssured.given().header("Accept", (Object)"text/plain", new Object[0]).expect().response().body(CoreMatchers.containsString((String)"level"), new Matcher[0]).header("Content-type", "text/plain").statusCode(200).when().get("/api/level", new Object[0]);
    }
}

