/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.parameters;

import com.jayway.restassured.RestAssured;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class DefaultParametersTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/parameters/default-parameters-config.xml";
    }

    @Test
    public void defaultHeader() throws Exception {
        RestAssured.given().header("Accept", (Object)"text/plain", new Object[0]).expect().response().header("one", "bar").statusCode(200).when().get("/api/headers", new Object[0]);
    }

    @Test
    public void defaultQueryParameter() throws Exception {
        RestAssured.given().header("Accept", (Object)"text/plain", new Object[0]).expect().response().header("first", "1").statusCode(200).when().get("/api/queryParams", new Object[0]);
    }

    @Test
    public void defaultFormParameterMultipart() throws Exception {
        RestAssured.given().multiPart("first", "primero").multiPart("third", "true").multiPart("payload", "3.4").expect().response().header("second", "segundo").statusCode(201).when().post("/api/multipart", new Object[0]);
    }

    @Test
    public void defaultFormParameterUrlencoded() throws Exception {
        RestAssured.given().header("Content-Type", (Object)"application/x-www-form-urlencoded", new Object[0]).formParam("second", new Object[]{"segundo"}).formParam("third", new Object[]{"true"}).expect().response().header("first", "primo").statusCode(201).when().post("/api/url-encoded", new Object[0]);
    }
}

