/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.latestruntime;

import com.jayway.restassured.RestAssured;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class PathlessEndpointMule35TestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPortPathless = new DynamicPort("serverPortPathless");
    @Rule
    public DynamicPort serverPortEmptyPath = new DynamicPort("serverPortEmptyPath");
    @Rule
    public DynamicPort serverPortSlashPath = new DynamicPort("serverPortSlashPath");
    @Rule
    public DynamicPort serverPortAddressSlashPath = new DynamicPort("serverPortAddressSlashPath");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/pathless/pathless-config.xml";
    }

    @Test
    public void ramlEmptyPath() throws Exception {
        RestAssured.port = this.serverPortEmptyPath.getNumber();
        this.raml("");
    }

    @Test
    public void baseuriEmptyPath() throws Exception {
        int port;
        RestAssured.port = port = this.serverPortEmptyPath.getNumber();
        this.baseUri("", "http://localhost:" + port);
    }

    @Test
    public void ramlSlashPath() throws Exception {
        RestAssured.port = this.serverPortSlashPath.getNumber();
        this.raml("");
    }

    @Test
    public void baseuriSlashPath() throws Exception {
        int port;
        RestAssured.port = port = this.serverPortSlashPath.getNumber();
        this.baseUri("", "http://localhost:" + port);
    }

    private void raml(String path) {
        RestAssured.given().header("Accept", (Object)"application/raml+yaml", new Object[0]).expect().response().body(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"title"), (Matcher)CoreMatchers.containsString((String)"Endpoint API")), new Matcher[0]).statusCode(200).when().get(path, new Object[0]);
    }

    private void baseUri(String path, String expectedBaseUri) {
        RestAssured.given().header("Accept", (Object)"application/raml+yaml", new Object[0]).expect().response().body(CoreMatchers.containsString((String)("baseUri: \"" + expectedBaseUri + "\"")), new Matcher[0]).statusCode(200).when().get(path + "/", new Object[0]);
    }
}

