/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.StartException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.Flow;
import org.mule.module.apikit.AbstractConfiguration;
import org.mule.module.apikit.AbstractRouter;
import org.mule.module.apikit.ApiRouter;
import org.mule.module.apikit.FlowResolver;
import org.mule.module.apikit.ProxyConfiguration;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.raml.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Proxy
extends AbstractInterceptingMessageProcessor
implements ApiRouter {
    public static final Set<String> MULE_REQUEST_HEADERS;
    public static final Set<String> MULE_RESPONSE_HEADERS;
    protected static final Logger LOGGER;
    private ProxyRouter proxyRouter = new ProxyRouter();

    public void start() throws MuleException {
        this.proxyRouter.start();
    }

    public MuleEvent process(MuleEvent muleEvent) throws MuleException {
        return this.proxyRouter.process(muleEvent);
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.proxyRouter.setFlowConstruct(flowConstruct);
    }

    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
        this.proxyRouter.setMuleContext(context);
    }

    public ProxyConfiguration getConfig() {
        return this.proxyRouter.getConfig();
    }

    public void setConfig(ProxyConfiguration config) {
        this.proxyRouter.setConfig(config);
    }

    public static void copyProperties(MuleEvent event, Set<String> skip) {
        MuleMessage message = event.getMessage();
        Set inboundPropertyNames = message.getInboundPropertyNames();
        for (String name : inboundPropertyNames) {
            if (!skip.contains(name)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format(">>>>>>>  copying header %s -> %s", name, message.getInboundProperty(name)));
                }
                message.setOutboundProperty(name, message.getInboundProperty(name));
                continue;
            }
            LOGGER.debug(String.format("/////// skipping header %s -> %s", name, message.getInboundProperty(name)));
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(Proxy.class);
        String[] headers = new String[]{"http.context.path", "http.context.uri", "http.headers", "http.method", "http.query.params", "http.query.string", "http.relative.path", "http.request", "http.request.path", "http.status", "http.version", "server", "x-mule_encoding", "x-mule_session", "MULE_ORIGINATING_ENDPOINT", "MULE_REMOTE_CLIENT_ADDRESS"};
        MULE_RESPONSE_HEADERS = new HashSet<String>(Arrays.asList(headers));
        MULE_RESPONSE_HEADERS.remove("http.status");
        MULE_REQUEST_HEADERS = new HashSet<String>(MULE_RESPONSE_HEADERS);
        MULE_REQUEST_HEADERS.remove("http.method");
    }

    private class ProxyRouter
    extends AbstractRouter {
        private Flow basicFlow;

        private ProxyRouter() {
        }

        public ProxyConfiguration getConfig() {
            return (ProxyConfiguration)this.config;
        }

        public void setConfig(ProxyConfiguration config) {
            this.config = config;
        }

        protected void startConfiguration() throws StartException {
            if (this.config == null) {
                try {
                    this.config = (AbstractConfiguration)this.muleContext.getRegistry().lookupObject(ProxyConfiguration.class);
                }
                catch (RegistrationException e) {
                    throw new StartException(MessageFactory.createStaticMessage((String)"APIKit Proxy configuration not Found"), (Startable)this);
                }
            }
            ((ProxyConfiguration)this.config).setChain(Proxy.this.next);
            this.config.initializeRestFlowMapWrapper();
            this.config.loadApiDefinition(this.flowConstruct);
            this.basicFlow = this.buildBasicFlow();
        }

        private Flow buildBasicFlow() {
            String flowName = "__intercepted_chain_flow";
            Flow wrapper = new Flow(flowName, this.muleContext);
            wrapper.setMessageProcessors(Collections.singletonList(Proxy.this.next));
            try {
                this.muleContext.getRegistry().registerFlowConstruct((FlowConstruct)wrapper);
            }
            catch (MuleException e) {
                throw new RuntimeException("Error registering flow " + flowName, e);
            }
            return wrapper;
        }

        protected MuleEvent handleEvent(MuleEvent event, String path) throws MuleException {
            Proxy.copyProperties(event, MULE_REQUEST_HEADERS);
            event.getMessage().setOutboundProperty("http.disable.status.code.exception.check", (Object)"true");
            return null;
        }

        protected Flow getFlow(Resource resource, String method) {
            FlowResolver flowResolver = this.config.getRestFlowMap().get(method + ":" + resource.getUri());
            Flow rawFlow = ((ProxyConfiguration.ProxyFlowResolver)flowResolver).getRawFlow();
            if (rawFlow == null) {
                rawFlow = this.basicFlow;
            }
            return rawFlow;
        }
    }
}

