/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.proxy;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.specification.ResponseSpecification;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpProxyTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public DynamicPort proxyPort = new DynamicPort("proxyPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.proxyPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigFile() {
        return "org/mule/module/apikit/proxy/http-proxy-config.xml";
    }

    @Test
    public void getRaml() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/raml+yaml", new Object[0]).expect().response().body(Matchers.containsString((String)("baseUri: \"http://localhost:" + this.proxyPort.getValue() + "/api\"")), new Matcher[0]).header("Content-type", "application/raml+yaml").statusCode(200).when().get("/api", new Object[0]);
    }

    @Test
    public void getConsole() throws Exception {
        ((ResponseSpecification)RestAssured.given().header("Accept", (Object)"text/html", new Object[0]).expect().log().everything()).response().body(Matchers.containsString((String)("raml-console src=\"http://localhost:" + this.proxyPort.getValue() + "/console/\"")), new Matcher[0]).statusCode(200).when().get("/console", new Object[0]);
    }

    @Test
    public void getConsoleSlash() throws Exception {
        ((ResponseSpecification)RestAssured.given().header("Accept", (Object)"text/html", new Object[0]).expect().log().everything()).response().body(Matchers.containsString((String)("raml-console src=\"http://localhost:" + this.proxyPort.getValue() + "/console/\"")), new Matcher[0]).statusCode(200).when().get("/console/", new Object[0]);
    }
}

