/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.cache;

import com.google.common.cache.CacheLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.mule.api.MuleContext;
import org.mule.module.apikit.validation.cache.SchemaCacheUtils;
import org.mule.module.apikit.validation.io.SchemaResourceLoader;
import org.raml.model.Raml;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSchemaCacheLoader
extends CacheLoader<String, Schema> {
    private ResourceLoader resourceLoader;
    private Raml api;

    public XmlSchemaCacheLoader(MuleContext muleContext, Raml api) {
        this.api = api;
        this.resourceLoader = new SchemaResourceLoader(muleContext.getExecutionClassLoader());
    }

    public Schema load(String schemaLocation) throws IOException, SAXException {
        InputStream is;
        if (schemaLocation.startsWith("/")) {
            is = new ByteArrayInputStream(SchemaCacheUtils.resolveSchema(schemaLocation, this.api).getBytes());
        } else {
            Resource schemaResource = this.resourceLoader.getResource(schemaLocation);
            is = schemaResource.getInputStream();
        }
        return XmlSchemaCacheLoader.compileSchema(is);
    }

    private static Schema compileSchema(InputStream inputStream) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return factory.newSchema(new StreamSource(inputStream));
    }
}

