/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.google.common.net.MediaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.mule.DefaultMuleMessage;
import org.mule.VoidMuleEvent;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.FilterUnacceptedException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.construct.Flow;
import org.mule.message.ds.StringDataSource;
import org.mule.module.apikit.Configuration;
import org.mule.module.apikit.DataTypePair;
import org.mule.module.apikit.HttpProtocolAdapter;
import org.mule.module.apikit.RestContentTypeParser;
import org.mule.module.apikit.SchemaType;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.exception.BadRequestException;
import org.mule.module.apikit.exception.InvalidFormParameterException;
import org.mule.module.apikit.exception.InvalidHeaderException;
import org.mule.module.apikit.exception.InvalidQueryParameterException;
import org.mule.module.apikit.exception.MuleRestException;
import org.mule.module.apikit.exception.NotAcceptableException;
import org.mule.module.apikit.exception.UnsupportedMediaTypeException;
import org.mule.module.apikit.transform.TransformerCache;
import org.mule.module.apikit.validation.RestSchemaValidator;
import org.mule.module.apikit.validation.RestSchemaValidatorFactory;
import org.mule.module.apikit.validation.cache.SchemaCacheUtils;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.mule.transport.http.transformers.FormTransformer;
import org.mule.util.CaseInsensitiveHashMap;
import org.raml.model.Action;
import org.raml.model.MimeType;
import org.raml.model.Response;
import org.raml.model.parameter.FormParameter;
import org.raml.model.parameter.Header;
import org.raml.model.parameter.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRestRequest {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private MuleEvent requestEvent;
    private Configuration config;
    private Action action;
    private HttpProtocolAdapter adapter;

    public HttpRestRequest(MuleEvent event, Configuration config) {
        this.requestEvent = event;
        this.config = config;
        this.adapter = new HttpProtocolAdapter(event);
    }

    public HttpProtocolAdapter getAdapter() {
        return this.adapter;
    }

    public String getResourcePath() {
        String path = this.adapter.getResourceURI().getPath();
        String basePath = this.adapter.getBaseURI().getPath();
        int start = basePath.endsWith("/") ? basePath.length() - 1 : basePath.length();
        int end = path.endsWith("/") ? path.length() - 1 : path.length();
        return path.substring(start, end);
    }

    public String getMethod() {
        return this.adapter.getMethod().toLowerCase();
    }

    public MuleEvent process(Flow flow, Action action) throws MuleException {
        this.action = action;
        if (!this.config.isDisableValidations()) {
            this.processQueryParameters();
            this.processHeaders();
        }
        this.negotiateInputRepresentation();
        List<MimeType> responseMimeTypes = this.getResponseMimeTypes();
        String responseRepresentation = this.negotiateOutputRepresentation(responseMimeTypes);
        MuleEvent responseEvent = flow.process(this.requestEvent);
        if (responseEvent == null || VoidMuleEvent.getInstance().equals(responseEvent)) {
            throw new FilterUnacceptedException(CoreMessages.messageRejectedByFilter(), this.requestEvent);
        }
        if (responseRepresentation != null) {
            this.transformToExpectedContentType(responseEvent, responseRepresentation, responseMimeTypes);
        } else {
            responseEvent.getMessage().setPayload((Object)NullPayload.getInstance());
        }
        if (responseEvent.getMessage().getOutboundProperty("http.status") == null) {
            int status = this.getSuccessStatus();
            if (status == -1) {
                throw new ApikitRuntimeException("No success status defined for action: " + action);
            }
            responseEvent.getMessage().setOutboundProperty("http.status", (Object)this.getSuccessStatus());
        }
        return responseEvent;
    }

    private void processQueryParameters() throws InvalidQueryParameterException {
        for (String expectedKey : this.action.getQueryParameters().keySet()) {
            QueryParameter expected = (QueryParameter)this.action.getQueryParameters().get(expectedKey);
            String actual = (String)((Map)this.requestEvent.getMessage().getInboundProperty("http.query.params")).get(expectedKey);
            if (actual == null && expected.isRequired()) {
                throw new InvalidQueryParameterException("Required query parameter " + expectedKey + " not specified");
            }
            if (actual == null && expected.getDefaultValue() != null) {
                this.setQueryParameter(expectedKey, expected.getDefaultValue());
            }
            if (actual == null || expected.validate(actual)) continue;
            throw new InvalidQueryParameterException("Invalid query parameter value " + actual + " for " + expectedKey);
        }
    }

    private void setQueryParameter(String key, String value) {
        this.requestEvent.getMessage().setProperty(key, (Object)value, PropertyScope.INBOUND);
        ((Map)this.requestEvent.getMessage().getInboundProperty("http.query.params")).put(key, value);
    }

    private void processHeaders() throws InvalidHeaderException {
        for (String expectedKey : this.action.getHeaders().keySet()) {
            Header expected = (Header)this.action.getHeaders().get(expectedKey);
            CaseInsensitiveHashMap incomingHeaders = new CaseInsensitiveHashMap((Map)this.requestEvent.getMessage().getInboundProperty("http.headers"));
            if (expectedKey.contains("{?}")) {
                String regex = expectedKey.replace("{?}", ".*");
                for (String incoming : incomingHeaders.keySet()) {
                    String incomingValue = (String)incomingHeaders.get(incoming);
                    if (!incoming.matches(regex) || expected.validate(incomingValue)) continue;
                    throw new InvalidHeaderException("Invalid header value " + incomingValue + " for " + expectedKey);
                }
                continue;
            }
            String actual = (String)incomingHeaders.get(expectedKey);
            if (actual == null && expected.isRequired()) {
                throw new InvalidHeaderException("Required header " + expectedKey + " not specified");
            }
            if (actual == null && expected.getDefaultValue() != null) {
                this.setHeader(expectedKey, expected.getDefaultValue());
            }
            if (actual == null || expected.validate(actual)) continue;
            throw new InvalidHeaderException("Invalid header value " + actual + " for " + expectedKey);
        }
    }

    private void setHeader(String key, String value) {
        this.requestEvent.getMessage().setProperty(key, (Object)value, PropertyScope.INBOUND);
        ((Map)this.requestEvent.getMessage().getInboundProperty("http.headers")).put(key, value);
    }

    private void transformToExpectedContentType(MuleEvent muleEvent, String responseRepresentation, List<MimeType> responseMimeTypes) throws MuleException {
        MuleMessage message = muleEvent.getMessage();
        String msgMimeType = message.getDataType() != null ? message.getDataType().getMimeType() : null;
        String msgContentType = (String)message.getOutboundProperty("Content-Type");
        if ("*/*".equals(responseRepresentation)) {
            if (msgContentType == null) {
                throw new ApikitRuntimeException("Content-Type must be set in the flow when declaring */* response type");
            }
            return;
        }
        if (message.getPayload() instanceof NullPayload) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Response transformation not required. Message payload type is NullPayload");
            }
            return;
        }
        String msgAcceptedContentType = this.acceptedContentType(msgMimeType, msgContentType, responseMimeTypes);
        if (msgAcceptedContentType != null) {
            message.setOutboundProperty("Content-Type", (Object)msgAcceptedContentType);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Response transformation not required. Message payload type is " + msgAcceptedContentType);
            }
            return;
        }
        DataType sourceDataType = DataTypeFactory.create(message.getPayload().getClass(), (String)msgMimeType);
        DataType resultDataType = DataTypeFactory.create(String.class, (String)responseRepresentation);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Resolving transformer between [source=%s] and [result=%s]", sourceDataType, resultDataType));
        }
        try {
            Transformer transformer = (Transformer)TransformerCache.getTransformerCache(muleEvent.getMuleContext()).get((Object)new DataTypePair(sourceDataType, resultDataType));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Transformer resolved to [transformer=%s]", transformer));
            }
            Object payload = transformer.transform(message.getPayload());
            message.setPayload(payload);
            message.setOutboundProperty("Content-Type", (Object)responseRepresentation);
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    private String acceptedContentType(String msgMimeType, String msgContentType, List<MimeType> responseMimeTypes) {
        for (MimeType responseMimeType : responseMimeTypes) {
            if (msgMimeType != null && msgMimeType.contains(responseMimeType.getType())) {
                return responseMimeType.getType();
            }
            if (msgContentType == null || !msgContentType.contains(responseMimeType.getType())) continue;
            return responseMimeType.getType();
        }
        return null;
    }

    private void negotiateInputRepresentation() throws MuleRestException {
        if (this.action == null || !this.action.hasBody()) {
            this.logger.debug("=== no body types defined: accepting any request content-type");
            return;
        }
        String requestMimeTypeName = null;
        boolean found = false;
        if (this.adapter.getRequestMediaType() != null) {
            requestMimeTypeName = this.adapter.getRequestMediaType();
        }
        for (String mimeTypeName : this.action.getBody().keySet()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("comparing request media type %s with expected %s\n", requestMimeTypeName, mimeTypeName));
            }
            if (!mimeTypeName.equals(requestMimeTypeName)) continue;
            found = true;
            if (this.config.isDisableValidations()) break;
            this.valideateBody(mimeTypeName);
            break;
        }
        if (!found) {
            throw new UnsupportedMediaTypeException();
        }
    }

    private void valideateBody(String mimeTypeName) throws MuleRestException {
        MimeType actionMimeType = (MimeType)this.action.getBody().get(mimeTypeName);
        if (actionMimeType.getSchema() != null && (mimeTypeName.contains("xml") || mimeTypeName.contains("json"))) {
            this.validateSchema(mimeTypeName);
        } else if (actionMimeType.getFormParameters() != null && mimeTypeName.contains("multipart/form-data")) {
            this.validateMultipartForm(actionMimeType.getFormParameters());
        } else if (actionMimeType.getFormParameters() != null && mimeTypeName.contains("application/x-www-form-urlencoded")) {
            this.validateUrlencodedForm(actionMimeType.getFormParameters());
        }
    }

    private void validateUrlencodedForm(Map<String, List<FormParameter>> formParameters) throws BadRequestException {
        Map paramMap;
        try {
            paramMap = (Map)new FormTransformer().transformMessage(this.requestEvent.getMessage(), this.requestEvent.getEncoding());
        }
        catch (TransformerException e) {
            this.logger.warn("Cannot validate url-encoded form", (Throwable)e);
            return;
        }
        for (String expectedKey : formParameters.keySet()) {
            if (formParameters.get(expectedKey).size() != 1) continue;
            FormParameter expected = formParameters.get(expectedKey).get(0);
            Object actual = paramMap.get(expectedKey);
            if (actual == null && expected.isRequired()) {
                throw new InvalidFormParameterException("Required form parameter " + expectedKey + " not specified");
            }
            if (actual == null && expected.getDefaultValue() != null) {
                paramMap.put(expectedKey, expected.getDefaultValue());
            }
            if (actual == null || !(actual instanceof String) || expected.validate((String)actual)) continue;
            throw new InvalidFormParameterException("Invalid form parameter value " + actual + " for " + expectedKey);
        }
        this.requestEvent.getMessage().setPayload((Object)paramMap);
    }

    private void validateMultipartForm(Map<String, List<FormParameter>> formParameters) throws BadRequestException {
        for (String expectedKey : formParameters.keySet()) {
            if (formParameters.get(expectedKey).size() != 1) continue;
            FormParameter expected = formParameters.get(expectedKey).get(0);
            DataHandler dataHandler = this.requestEvent.getMessage().getInboundAttachment(expectedKey);
            if (dataHandler == null && expected.isRequired()) {
                throw new InvalidFormParameterException("Required form parameter " + expectedKey + " not specified");
            }
            if (dataHandler != null || expected.getDefaultValue() == null) continue;
            DataHandler defaultDataHandler = new DataHandler((DataSource)new StringDataSource(expected.getDefaultValue(), expectedKey));
            try {
                ((DefaultMuleMessage)this.requestEvent.getMessage()).addInboundAttachment(expectedKey, defaultDataHandler);
            }
            catch (Exception e) {
                this.logger.warn("Cannot set default part " + expectedKey, (Throwable)e);
            }
        }
    }

    private void validateSchema(String mimeTypeName) throws MuleRestException {
        SchemaType schemaType = mimeTypeName.contains("json") ? SchemaType.JSONSchema : SchemaType.XMLSchema;
        RestSchemaValidator validator = RestSchemaValidatorFactory.getInstance().createValidator(schemaType, this.requestEvent.getMuleContext());
        validator.validate(SchemaCacheUtils.getSchemaCacheKey(this.action, mimeTypeName), this.requestEvent, this.config.getApi());
    }

    private String negotiateOutputRepresentation(List<MimeType> mimeTypes) throws MuleRestException {
        if (this.action == null || this.action.getResponses() == null || mimeTypes.isEmpty()) {
            return null;
        }
        MediaType bestMatch = RestContentTypeParser.bestMatch(mimeTypes, this.adapter.getAcceptableResponseMediaTypes());
        if (bestMatch == null) {
            throw new NotAcceptableException();
        }
        this.logger.debug("=== negotiated response content-type: " + bestMatch.toString());
        for (MimeType representation : mimeTypes) {
            if (!representation.getType().equals(bestMatch.withoutParameters().toString())) continue;
            return representation.getType();
        }
        throw new NotAcceptableException();
    }

    private List<MimeType> getResponseMimeTypes() {
        Response response;
        ArrayList<MimeType> mimeTypes = new ArrayList<MimeType>();
        int status = this.getSuccessStatus();
        if (status != -1 && (response = (Response)this.action.getResponses().get(String.valueOf(status))) != null && response.hasBody()) {
            Collection types = response.getBody().values();
            this.logger.debug(String.format("=== adding response mimeTypes for status %d : %s", status, types));
            mimeTypes.addAll(types);
        }
        return mimeTypes;
    }

    private int getSuccessStatus() {
        for (String status : this.action.getResponses().keySet()) {
            int code = Integer.parseInt(status);
            if (code < 200 || code >= 300) continue;
            return code;
        }
        return 200;
    }
}

