/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.apikit.exception.NotFoundException;
import org.mule.transport.http.components.ResourceNotFoundException;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.util.FilenameUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleHandler {
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    public static final String MIME_TYPE_JAVASCRIPT = "application/x-javascript";
    public static final String MIME_TYPE_PNG = "image/png";
    public static final String MIME_TYPE_GIF = "image/gif";
    public static final String MIME_TYPE_CSS = "text/css";
    private static final String RESOURCE_BASE = "/console";
    private Map<String, String> homePage = new ConcurrentHashMap<String, String>();
    private String consolePath;
    private String baseHost;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ConsoleHandler(String ramlUri, String consolePath) throws InitialisationException {
        this.consolePath = this.sanitize(consolePath);
        String indexHtml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/console/index.html"));
        ramlUri = ramlUri.endsWith("/") ? ramlUri : ramlUri + "/";
        String baseHomePage = indexHtml.replaceFirst("<raml-console src=\"[^\"]+\"", "<raml-console src=\"" + ramlUri + "\"");
        try {
            this.baseHost = new URI(ramlUri).getHost();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.homePage.put(this.baseHost, baseHomePage);
    }

    private String sanitize(String consolePath) {
        if (consolePath.endsWith("/")) {
            consolePath = consolePath.substring(0, consolePath.length() - 1);
        }
        if (!consolePath.isEmpty() && !consolePath.startsWith("/")) {
            consolePath = "/" + consolePath;
        }
        return consolePath;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        DefaultMuleEvent resultEvent;
        String path = (String)event.getMessage().getInboundProperty("http.request.path");
        String contextPath = (String)event.getMessage().getInboundProperty("http.context.path");
        if (!(path = path.substring(contextPath.length())).startsWith("/") && !path.isEmpty()) {
            path = "/" + path;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Console request: " + path);
        }
        InputStream in = null;
        try {
            if (path.equals(this.consolePath)) {
                event.getMessage().setOutboundProperty("http.status", (Object)String.valueOf(301));
                String context = (String)event.getMessage().getInboundProperty("http.context.uri");
                String scheme = context.substring(0, context.indexOf("/"));
                String host = (String)event.getMessage().getInboundProperty("Host");
                String requestPath = (String)event.getMessage().getInboundProperty("http.request.path");
                String redirectLocation = scheme + "//" + host + requestPath + "/";
                String queryString = (String)event.getMessage().getInboundProperty("http.query.string");
                if (StringUtils.isNotEmpty((String)queryString)) {
                    redirectLocation = redirectLocation + "?" + queryString;
                }
                event.getMessage().setOutboundProperty("Location", (Object)redirectLocation);
                return event;
            }
            if (path.equals(this.consolePath + "/") || path.equals(this.consolePath + "/index.html")) {
                path = "/console/index.html";
                String host = (String)event.getMessage().getInboundProperty("host");
                if (host.contains(":")) {
                    host = host.split(":")[0];
                }
                in = new ByteArrayInputStream(this.getHomePage(host).getBytes());
            } else if (path.startsWith(this.consolePath)) {
                in = this.getClass().getResourceAsStream(RESOURCE_BASE + path.substring(this.consolePath.length()));
            }
            if (in == null) {
                throw new NotFoundException(path);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copyLarge((InputStream)in, (OutputStream)baos);
            byte[] buffer = baos.toByteArray();
            String mimetype = this.getMimeType(path);
            if (mimetype == null) {
                mimetype = DEFAULT_MIME_TYPE;
            }
            resultEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)buffer, event.getMuleContext()), event);
            resultEvent.getMessage().setOutboundProperty("http.status", (Object)String.valueOf(200));
            resultEvent.getMessage().setOutboundProperty("Content-Type", (Object)mimetype);
            resultEvent.getMessage().setOutboundProperty("Content-Length", (Object)buffer.length);
        }
        catch (IOException e) {
            throw new ResourceNotFoundException(HttpMessages.fileNotFound((String)(RESOURCE_BASE + path)), event);
        }
        return resultEvent;
    }

    private String getHomePage(String host) {
        if (!"0.0.0.0".equals(this.baseHost)) {
            return this.homePage.get(this.baseHost);
        }
        String page = this.homePage.get(host);
        if (page == null) {
            page = this.homePage.get(this.baseHost).replace("0.0.0.0", host);
            this.homePage.put(host, page);
        }
        return page;
    }

    private String getMimeType(String path) {
        String mimeType = DEFAULT_MIME_TYPE;
        if (FilenameUtils.getExtension((String)path).equals("html")) {
            mimeType = "text/html";
        } else if (FilenameUtils.getExtension((String)path).equals("js")) {
            mimeType = MIME_TYPE_JAVASCRIPT;
        } else if (FilenameUtils.getExtension((String)path).equals("png")) {
            mimeType = MIME_TYPE_PNG;
        } else if (FilenameUtils.getExtension((String)path).equals("gif")) {
            mimeType = MIME_TYPE_GIF;
        } else if (FilenameUtils.getExtension((String)path).equals("css")) {
            mimeType = MIME_TYPE_CSS;
        }
        return mimeType;
    }
}

