/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.construct.Flow;
import org.mule.module.apikit.ActionImplementedRuleExtension;
import org.mule.module.apikit.FlowMapping;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.util.BeanUtils;
import org.raml.emitter.RamlEmitter;
import org.raml.model.Raml;
import org.raml.parser.loader.CompositeResourceLoader;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.FileResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.NodeRuleFactory;
import org.raml.parser.rule.NodeRuleFactoryExtension;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.RamlDocumentBuilder;
import org.raml.parser.visitor.RamlValidationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    public static final String APPLICATION_RAML = "application/raml+yaml";
    public static final String BIND_ALL_HOST = "0.0.0.0";
    public static final String DEFAULT_CONSOLE_PATH = "console";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    private String raml;
    private boolean consoleEnabled = true;
    private String consolePath = "console";
    private boolean disableValidations;
    private List<FlowMapping> flowMappings = new ArrayList<FlowMapping>();
    private FlowConstruct flowConstruct;
    private Raml api;
    private String baseHost;
    private Map<String, String> apikitRaml = new ConcurrentHashMap<String, String>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRaml() {
        return this.raml;
    }

    public void setRaml(String raml) {
        this.raml = raml;
    }

    public boolean isConsoleEnabled() {
        return this.consoleEnabled;
    }

    public void setConsoleEnabled(boolean consoleEnabled) {
        this.consoleEnabled = consoleEnabled;
    }

    public String getConsolePath() {
        return this.consolePath;
    }

    public void setConsolePath(String consolePath) {
        this.consolePath = consolePath;
    }

    public boolean isDisableValidations() {
        return this.disableValidations;
    }

    public void setDisableValidations(boolean disableValidations) {
        this.disableValidations = disableValidations;
    }

    public List<FlowMapping> getFlowMappings() {
        return this.flowMappings;
    }

    public void setFlowMappings(List<FlowMapping> flowMappings) {
        this.flowMappings = flowMappings;
    }

    public Raml getApi() {
        return this.api;
    }

    public String getApikitRaml(String host) {
        if (!BIND_ALL_HOST.equals(this.baseHost)) {
            return this.apikitRaml.get(this.baseHost);
        }
        String hostRaml = this.apikitRaml.get(host);
        if (hostRaml == null) {
            Raml clone;
            try {
                clone = (Raml)BeanUtils.cloneBean((Object)this.api);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            clone.setBaseUri(this.api.getBaseUri().replace(this.baseHost, host));
            hostRaml = new RamlEmitter().dump(clone);
            this.apikitRaml.put(host, hostRaml);
        }
        return hostRaml;
    }

    public void loadApiDefinition(MuleContext muleContext, FlowConstruct flowConstruct, Map<String, Flow> restFlowMap) {
        this.flowConstruct = flowConstruct;
        DefaultResourceLoader loader = new DefaultResourceLoader();
        String appHome = (String)muleContext.getRegistry().get("app.home");
        if (appHome != null) {
            loader = new CompositeResourceLoader(new ResourceLoader[]{new FileResourceLoader(appHome), loader});
        }
        this.validateRaml((ResourceLoader)loader, restFlowMap);
        RamlDocumentBuilder builder = new RamlDocumentBuilder((ResourceLoader)loader, new TagResolver[0]);
        this.api = (Raml)builder.build(this.getRaml());
        this.injectEndpointUri();
        this.flowMappings = new ArrayList<FlowMapping>();
        this.apikitRaml = new ConcurrentHashMap<String, String>();
        this.apikitRaml.put(this.baseHost, new RamlEmitter().dump(this.api));
    }

    protected void validateRaml(ResourceLoader resourceLoader, Map<String, Flow> restFlowMap) {
        NodeRuleFactory ruleFactory = new NodeRuleFactory(new NodeRuleFactoryExtension[]{new ActionImplementedRuleExtension(restFlowMap)});
        List results = RamlValidationService.createDefault((ResourceLoader)resourceLoader, (NodeRuleFactory)ruleFactory, (TagResolver[])new TagResolver[0]).validate(this.getRaml());
        List errors = ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.ERROR, (List)results);
        if (!errors.isEmpty()) {
            String msg = this.aggregateMessages(errors, "Invalid API descriptor -- errors found: ");
            throw new ApikitRuntimeException(msg);
        }
        List warnings = ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.WARN, (List)results);
        if (!warnings.isEmpty()) {
            this.logger.warn(this.aggregateMessages(warnings, "API descriptor Warnings -- warnings found: "));
        }
    }

    private String aggregateMessages(List<ValidationResult> results, String header) {
        StringBuilder sb = new StringBuilder();
        sb.append(header).append(results.size()).append("\n\n");
        for (ValidationResult result : results) {
            sb.append(result.getMessage()).append(" -- ");
            sb.append(" file: ");
            sb.append(result.getIncludeName() != null ? result.getIncludeName() : this.getRaml());
            if (result.getLine() != ValidationResult.UNKNOWN) {
                sb.append(" -- line ");
                sb.append(result.getLine());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private void injectEndpointUri() {
        String address = this.getEndpointAddress(this.flowConstruct);
        this.api.setBaseUri(address);
        try {
            this.baseHost = new URI(address).getHost();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getEndpointAddress(FlowConstruct flowConstruct) {
        ImmutableEndpoint endpoint = (ImmutableEndpoint)((Flow)flowConstruct).getMessageSource();
        String address = endpoint.getAddress();
        String path = endpoint.getEndpointURI().getPath();
        String scheme = endpoint.getEndpointURI().getScheme();
        String chAddress = System.getProperty("fullDomain");
        String chBaseUri = scheme + "://" + chAddress + path;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("yaml baseUri: " + this.api.getBaseUri());
            this.logger.debug("mule baseUri: " + address);
            this.logger.debug("chub baseUri: " + chBaseUri);
        }
        if (chAddress != null) {
            address = chBaseUri;
        }
        if (address.endsWith("/")) {
            this.logger.debug("removing trailing slash from baseuri -> " + address);
            address = address.substring(0, address.length() - 1);
        }
        return address;
    }
}

