/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.cache;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.cache.CacheLoader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eel.kitchen.jsonschema.util.JsonLoader;
import org.mule.api.MuleContext;
import org.mule.module.apikit.validation.cache.JsonSchemaAndNode;
import org.mule.module.apikit.validation.cache.SchemaCacheUtils;
import org.mule.module.apikit.validation.io.SchemaResourceLoader;
import org.raml.model.Raml;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonSchemaCacheLoader
extends CacheLoader<String, JsonSchemaAndNode> {
    private ResourceLoader resourceLoader;
    private Raml api;

    public JsonSchemaCacheLoader(MuleContext muleContext, Raml api) {
        this.api = api;
        this.resourceLoader = new SchemaResourceLoader(muleContext.getExecutionClassLoader());
    }

    public JsonSchemaAndNode load(String schemaLocation) throws IOException {
        JsonNode schemaNode;
        if (schemaLocation.startsWith("/")) {
            schemaNode = JsonLoader.fromString((String)SchemaCacheUtils.resolveSchema(schemaLocation, this.api));
        } else {
            Resource schemaResource = this.resourceLoader.getResource(schemaLocation);
            schemaNode = JsonLoader.fromReader((Reader)new InputStreamReader(schemaResource.getInputStream()));
        }
        return new JsonSchemaAndNode(schemaNode);
    }
}

