/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.apikit.Configuration;
import org.mule.module.apikit.ConsoleHandler;
import org.mule.module.apikit.HttpRestRequest;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.raml.model.ActionType;
import org.raml.model.Raml;

public class Console
implements MessageProcessor,
Initialisable,
MuleContextAware,
FlowConstructAware {
    private Configuration config;
    private MuleContext muleContext;
    private ConsoleHandler consoleHandler;
    private FlowConstruct flowConstruct;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public Configuration getConfig() {
        return this.config;
    }

    private Raml getApi() {
        return this.getConfig().getApi();
    }

    private String getRaml() {
        return this.getConfig().getApikitRaml();
    }

    public void initialise() throws InitialisationException {
        if (this.flowConstruct == null) {
            return;
        }
        if (this.config == null) {
            try {
                this.config = (Configuration)this.muleContext.getRegistry().lookupObject(Configuration.class);
            }
            catch (RegistrationException e) {
                throw new InitialisationException(MessageFactory.createStaticMessage((String)"APIKit configuration not Found"), (Initialisable)this);
            }
        }
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        if (this.getApi() == null) {
            throw new ApikitRuntimeException("API not initialized. Probably there is no APIkit Router associated to the Configuration");
        }
        HttpRestRequest request = new HttpRestRequest(event, this.getConfig());
        String path = request.getResourcePath();
        if (path.isEmpty() && ActionType.GET.toString().equals(request.getMethod().toUpperCase()) && request.getAdapter().getAcceptableResponseMediaTypes().contains("application/raml+yaml")) {
            event.getMessage().setPayload((Object)this.getRaml());
            event.getMessage().setOutboundProperty("Content-Type", (Object)"application/raml+yaml");
            event.getMessage().setOutboundProperty("Content-Length", (Object)this.getRaml().length());
            event.getMessage().setOutboundProperty("Access-Control-Allow-Origin", (Object)"*");
            return event;
        }
        if (this.consoleHandler == null) {
            this.consoleHandler = new ConsoleHandler(this.getConfig().getEndpointAddress(this.flowConstruct), "");
        }
        return this.consoleHandler.process(event);
    }
}

