/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.IOUtils;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.Flow;
import org.mule.module.apikit.ActionImplementedRuleExtension;
import org.mule.module.apikit.Configuration;
import org.mule.module.apikit.ConsoleHandler;
import org.mule.module.apikit.FlowMapping;
import org.mule.module.apikit.HttpRestRequest;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.exception.InvalidUriParameterException;
import org.mule.module.apikit.exception.MethodNotAllowedException;
import org.mule.module.apikit.exception.MuleRestException;
import org.mule.module.apikit.exception.NotFoundException;
import org.mule.module.apikit.uri.ResolvedVariables;
import org.mule.module.apikit.uri.URIPattern;
import org.mule.module.apikit.uri.URIResolveResult;
import org.mule.module.apikit.uri.URIResolver;
import org.mule.util.StringMessageUtils;
import org.raml.model.ActionType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.parameter.UriParameter;
import org.raml.parser.loader.CompositeResourceLoader;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.FileResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.NodeRuleFactory;
import org.raml.parser.rule.NodeRuleFactoryExtension;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.RamlDocumentBuilder;
import org.raml.parser.visitor.RamlValidationService;
import org.raml.parser.visitor.YamlDocumentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Router
implements MessageProcessor,
Initialisable,
MuleContextAware,
FlowConstructAware {
    public static final String APPLICATION_RAML = "application/raml+yaml";
    public static final String VERSION = "#%RAML 0.8\n---\n";
    private static final int URI_CACHE_SIZE = 1000;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private MuleContext muleContext;
    private FlowConstruct flowConstruct;
    private Configuration config;
    private Raml api;
    private Map<String, Flow> restFlowMap;
    private Map<URIPattern, Resource> routingTable;
    private LoadingCache<String, URIResolver> uriResolverCache;
    private LoadingCache<String, URIPattern> uriPatternCache;
    private String ramlYaml;
    private ConsoleHandler consoleHandler;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public void initialise() throws InitialisationException {
        if (this.flowConstruct == null) {
            return;
        }
        if (this.config == null) {
            try {
                this.config = (Configuration)this.muleContext.getRegistry().lookupObject(Configuration.class);
            }
            catch (RegistrationException e) {
                throw new InitialisationException(MessageFactory.createStaticMessage((String)"APIKit configuration not Found"), (Initialisable)this);
            }
        }
        this.loadRestFlowMap();
        this.loadApiDefinition();
        this.consoleHandler = new ConsoleHandler(this.api.getBaseUri(), this.config.getConsolePath());
        this.routingTable = new HashMap<URIPattern, Resource>();
        this.buildRoutingTable(this.api.getResources());
        this.logger.info("Building resource URI cache...");
        this.uriResolverCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, URIResolver>(){

            public URIResolver load(String path) throws IOException {
                return new URIResolver(path);
            }
        });
        this.uriPatternCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, URIPattern>(){

            public URIPattern load(String path) throws Exception {
                URIResolver resolver = (URIResolver)Router.this.uriResolverCache.get((Object)path);
                Collection<URIPattern> matches = resolver.findAll(Router.this.routingTable.keySet());
                if (matches.size() == 0) {
                    Router.this.logger.warn("No matching patterns for URI " + path);
                    throw new NotFoundException(path);
                }
                if (Router.this.logger.isDebugEnabled()) {
                    Router.this.logger.debug(matches.size() + " matching patterns for URI " + path + ". Finding best one...");
                }
                for (URIPattern p : matches) {
                    boolean best = p == resolver.find(Router.this.routingTable.keySet(), URIResolver.MatchRule.BEST_MATCH);
                    if (!best) continue;
                    return p;
                }
                return null;
            }
        });
        if (this.logger.isInfoEnabled()) {
            String msg = String.format("APIKit Console URL: %s", this.api.getBaseUri() + "/" + this.config.getConsolePath());
            this.logger.info(StringMessageUtils.getBoilerPlate((String)msg));
        }
    }

    private void loadRestFlowMap() {
        this.restFlowMap = new HashMap<String, Flow>();
        Collection flows = this.muleContext.getRegistry().lookupObjects(Flow.class);
        for (Flow flow : flows) {
            String key = this.getRestFlowKey(flow.getName());
            if (key == null) continue;
            this.restFlowMap.put(key, flow);
        }
        for (FlowMapping mapping : this.config.getFlowMappings()) {
            this.restFlowMap.put(mapping.getAction() + ":" + mapping.getResource(), mapping.getFlow());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("==== RestFlows defined:");
            for (String key : this.restFlowMap.keySet()) {
                this.logger.debug("\t\t" + key);
            }
        }
    }

    private String getRestFlowKey(String name) {
        String[] coords = name.split(":");
        String[] methods = new String[]{"get", "put", "post", "delete", "head", "patch", "options"};
        if (coords.length < 2 || !Arrays.asList(methods).contains(coords[0])) {
            return null;
        }
        if (coords.length == 3 && !coords[2].equals(this.config.getName())) {
            return null;
        }
        return coords[0] + ":" + coords[1];
    }

    private void loadApiDefinition() {
        String ramlBuffer;
        InputStream ramlStream;
        DefaultResourceLoader loader = new DefaultResourceLoader();
        String appHome = (String)this.muleContext.getRegistry().get("app.home");
        if (appHome != null) {
            loader = new CompositeResourceLoader(new ResourceLoader[]{new FileResourceLoader(appHome), loader});
        }
        if ((ramlStream = loader.fetchResource(this.config.getRaml())) == null) {
            throw new ApikitRuntimeException(String.format("API descriptor %s not found", this.config.getRaml()));
        }
        try {
            ramlBuffer = IOUtils.toString((InputStream)ramlStream);
        }
        catch (IOException e) {
            throw new ApikitRuntimeException(String.format("Cannot read API descriptor %s", this.config.getRaml()));
        }
        this.validateRaml(ramlBuffer, (ResourceLoader)loader);
        RamlDocumentBuilder builder = new RamlDocumentBuilder((ResourceLoader)loader, new TagResolver[0]);
        this.api = (Raml)builder.build(ramlBuffer);
        this.injectEndpointUri(builder);
        this.ramlYaml = VERSION + YamlDocumentBuilder.dumpFromAst((Node)builder.getRootNode());
    }

    protected void validateRaml(String ramlBuffer, ResourceLoader resourceLoader) {
        NodeRuleFactory ruleFactory = new NodeRuleFactory(new NodeRuleFactoryExtension[]{new ActionImplementedRuleExtension(this.restFlowMap)});
        List results = RamlValidationService.createDefault((ResourceLoader)resourceLoader, (NodeRuleFactory)ruleFactory, (TagResolver[])new TagResolver[0]).validate(ramlBuffer);
        List errors = ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.ERROR, (List)results);
        if (!errors.isEmpty()) {
            String msg = this.aggregateMessages(errors, "Invalid API descriptor -- errors found: ");
            throw new ApikitRuntimeException(msg);
        }
        List warnings = ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.WARN, (List)results);
        if (!warnings.isEmpty()) {
            this.logger.warn(this.aggregateMessages(warnings, "API descriptor Warnings -- warnings found: "));
        }
    }

    private String aggregateMessages(List<ValidationResult> results, String header) {
        StringBuilder sb = new StringBuilder();
        sb.append(header).append(results.size()).append("\n\n");
        for (ValidationResult result : results) {
            sb.append(result.getMessage()).append(" -- ");
            sb.append(" file: ");
            sb.append(result.getIncludeName() != null ? result.getIncludeName() : this.config.getRaml());
            if (result.getStartMark() != null) {
                sb.append(" -- ");
                sb.append(result.getStartMark());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private void injectEndpointUri(RamlDocumentBuilder builder) {
        ImmutableEndpoint endpoint = (ImmutableEndpoint)((Flow)this.flowConstruct).getMessageSource();
        String address = endpoint.getAddress();
        String path = endpoint.getEndpointURI().getPath();
        String scheme = endpoint.getEndpointURI().getScheme();
        String chAddress = System.getProperty("fullDomain");
        String chBaseUri = scheme + "://" + chAddress + path;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("yaml baseUri: " + this.api.getBaseUri());
            this.logger.debug("mule baseUri: " + address);
            this.logger.debug("chub baseUri: " + chBaseUri);
        }
        if (chAddress != null) {
            address = chBaseUri;
        }
        if (address.endsWith("/")) {
            this.logger.debug("removing trailing slash from baseuri -> " + address);
            address = address.substring(0, address.length() - 1);
        }
        this.api.setBaseUri(address);
        ArrayList<NodeTuple> tuples = new ArrayList<NodeTuple>();
        boolean baseUriPresent = false;
        for (NodeTuple tuple : builder.getRootNode().getValue()) {
            if (((ScalarNode)tuple.getKeyNode()).getValue().equals("baseUri")) {
                ScalarNode valueNode = (ScalarNode)tuple.getValueNode();
                tuples.add(new NodeTuple(tuple.getKeyNode(), (Node)new ScalarNode(valueNode.getTag(), address, valueNode.getStartMark(), valueNode.getEndMark(), valueNode.getStyle())));
                baseUriPresent = true;
                continue;
            }
            tuples.add(tuple);
        }
        if (!baseUriPresent) {
            ScalarNode keyNode = new ScalarNode(Tag.STR, "baseUri", null, null, Character.valueOf('0'));
            ScalarNode valueNode = new ScalarNode(Tag.STR, address, null, null, Character.valueOf('0'));
            tuples.add(new NodeTuple((Node)keyNode, (Node)valueNode));
        }
        builder.getRootNode().setValue(tuples);
    }

    private void buildRoutingTable(Map<String, Resource> resources) {
        for (Resource resource : resources.values()) {
            String parentUri = resource.getParentUri();
            if (parentUri.contains("{version}")) {
                resource.setParentUri(parentUri.replaceAll("\\{version}", this.api.getVersion()));
            }
            String uri = resource.getUri();
            this.logger.debug("Adding URI to the routing table: " + uri);
            this.routingTable.put(new URIPattern(uri), resource);
            if (resource.getResources() == null) continue;
            this.buildRoutingTable(resource.getResources());
        }
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        URIResolver uriResolver;
        URIPattern uriPattern;
        HttpRestRequest request = new HttpRestRequest(event, this.api);
        String path = request.getResourcePath();
        if (path.startsWith(this.api.getUri() + "/" + this.config.getConsolePath())) {
            if (this.config.isConsoleEnabled()) {
                return this.consoleHandler.process(event);
            }
            throw new NotFoundException("console disabled");
        }
        if (path.equals(this.api.getUri()) && ActionType.GET.toString().equals(request.getMethod().toUpperCase()) && request.getAdapter().getAcceptableResponseMediaTypes().contains(APPLICATION_RAML)) {
            event.getMessage().setPayload((Object)this.ramlYaml);
            event.getMessage().setOutboundProperty("Content-Type", (Object)APPLICATION_RAML);
            event.getMessage().setOutboundProperty("Content-Length", (Object)this.ramlYaml.length());
            return event;
        }
        try {
            uriPattern = (URIPattern)this.uriPatternCache.get((Object)path);
            uriResolver = (URIResolver)this.uriResolverCache.get((Object)path);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof MuleRestException) {
                throw (MuleRestException)((Object)e.getCause());
            }
            throw new DefaultMuleException((Throwable)e);
        }
        Resource resource = this.routingTable.get(uriPattern);
        if (resource.getAction(request.getMethod()) == null) {
            throw new MethodNotAllowedException(resource.getUri(), request.getMethod());
        }
        URIResolveResult resolvedVariables = uriResolver.resolve(uriPattern);
        this.processUriParameters(resolvedVariables, resource, event);
        Flow flow = this.getFlow(resource, request.getMethod());
        if (flow == null) {
            throw new ApikitRuntimeException("Flow not found for resource: " + resource);
        }
        return request.process(flow, resource.getAction(request.getMethod()));
    }

    private void processUriParameters(ResolvedVariables resolvedVariables, Resource resource, MuleEvent event) throws InvalidUriParameterException {
        if (this.logger.isDebugEnabled()) {
            for (String name : resolvedVariables.names()) {
                this.logger.debug("        uri parameter: " + name + "=" + resolvedVariables.get(name));
            }
        }
        for (String key : resource.getUriParameters().keySet()) {
            String value = (String)resolvedVariables.get(key);
            if (((UriParameter)resource.getUriParameters().get(key)).validate(value)) continue;
            throw new InvalidUriParameterException("Invalid uri parameter value " + value + " for " + key);
        }
        for (String name : resolvedVariables.names()) {
            event.getMessage().setInvocationProperty(name, resolvedVariables.get(name));
        }
    }

    private Flow getFlow(Resource resource, String method) {
        return this.restFlowMap.get(method + ":" + resource.getUri());
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }
}

