/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.uri;

import java.util.Map;
import java.util.regex.Pattern;
import org.mule.module.apikit.uri.Matchable;
import org.mule.module.apikit.uri.Parameters;
import org.mule.module.apikit.uri.Token;
import org.mule.module.apikit.uri.TokenBase;
import org.mule.module.apikit.uri.URICoder;
import org.mule.module.apikit.uri.URITemplateSyntaxException;
import org.mule.module.apikit.uri.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenVariable
extends TokenBase
implements Token,
Matchable {
    private Variable _var;

    public TokenVariable(String exp) throws NullPointerException, URITemplateSyntaxException {
        this(Variable.parse(exp));
    }

    public TokenVariable(Variable var) throws NullPointerException {
        super('{' + var.toString() + "}");
        this._var = var;
    }

    public Variable getVariable() {
        return this._var;
    }

    @Override
    public String expand(Parameters variables) {
        return URICoder.encode(this._var.value(variables));
    }

    @Override
    public boolean match(String value) {
        return Variable.isValidValue(value);
    }

    @Override
    public Pattern pattern() {
        return Variable.VALID_VALUE;
    }

    @Override
    public boolean resolve(String expanded, Map<Variable, Object> values) {
        values.put(this._var, URICoder.decode(expanded));
        return true;
    }
}

