/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.google.common.net.MediaType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpProtocolAdapter {
    private URI baseURI;
    private URI resourceURI;
    private String method;
    private String acceptableResponseMediaTypes;
    private String requestMediaType;
    private Map<String, Object> queryParams;

    public HttpProtocolAdapter(MuleEvent event) {
        MuleMessage message = event.getMessage();
        this.baseURI = event.getMessageSourceURI();
        if (message.getInboundProperty("host") != null) {
            String hostHeader = (String)message.getInboundProperty("host");
            if (hostHeader.indexOf(58) != -1) {
                String host = hostHeader.substring(0, hostHeader.indexOf(58));
                int port = Integer.parseInt(hostHeader.substring(hostHeader.indexOf(58) + 1));
                try {
                    String requestPath = (String)message.getInboundProperty("http.request.path");
                    this.resourceURI = new URI("http", null, host, port, requestPath, null, null);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Cannot parse URI", e);
                }
            } else {
                try {
                    String requestPath = (String)message.getInboundProperty("http.request.path");
                    this.resourceURI = new URI("http", null, (String)message.getInboundProperty("host"), 80, requestPath, null, null);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Cannot parse URI", e);
                }
            }
        } else {
            try {
                this.resourceURI = new URI("http", null, this.baseURI.getHost(), this.baseURI.getPort(), (String)message.getInboundProperty("http.request.path"), null, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Cannot parse URI", e);
            }
        }
        this.method = (String)message.getInboundProperty("http.method");
        if (!StringUtils.isBlank((String)((String)message.getInboundProperty("accept")))) {
            this.acceptableResponseMediaTypes = (String)message.getInboundProperty("accept");
        }
        if (!StringUtils.isBlank((String)((String)message.getInboundProperty("content-type")))) {
            this.requestMediaType = (String)message.getInboundProperty("content-type");
        }
        if (this.requestMediaType == null && !StringUtils.isBlank((String)((String)message.getOutboundProperty("content-type")))) {
            this.requestMediaType = (String)message.getOutboundProperty("content-type");
        }
        this.queryParams = (Map)message.getInboundProperty("http.query.params");
    }

    private List<MediaType> parseAcceptHeader(String acceptHeader) {
        LinkedList<MediaType> mediaTypes = new LinkedList<MediaType>();
        String[] types = StringUtils.split((String)acceptHeader, (char)',');
        if (types != null) {
            for (String type : types) {
                MediaType mediaType = MediaType.parse((String)type.trim());
                if (!mediaType.parameters().containsKey((Object)"q")) {
                    mediaType = mediaType.withParameter("q", "1");
                }
                mediaTypes.add(mediaType);
            }
        }
        return mediaTypes;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public URI getResourceURI() {
        return this.resourceURI;
    }

    public String getMethod() {
        return this.method;
    }

    public String getAcceptableResponseMediaTypes() {
        return this.acceptableResponseMediaTypes;
    }

    public String getRequestMediaType() {
        return this.requestMediaType != null ? this.requestMediaType.split(";")[0] : null;
    }

    public Map<String, Object> getQueryParams() {
        return this.queryParams;
    }
}

