/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import org.mule.api.MuleContext;
import org.mule.module.apikit.SchemaType;
import org.mule.module.apikit.validation.RestJsonSchemaValidator;
import org.mule.module.apikit.validation.RestSchemaValidator;
import org.mule.module.apikit.validation.RestXmlSchemaValidator;

public final class RestSchemaValidatorFactory {
    private static RestSchemaValidatorFactory INSTANCE = new RestSchemaValidatorFactory();

    private RestSchemaValidatorFactory() {
    }

    public static RestSchemaValidatorFactory getInstance() {
        return INSTANCE;
    }

    public RestSchemaValidator createValidator(SchemaType schemaType, MuleContext muleContext) {
        if (schemaType == SchemaType.JSONSchema) {
            return new RestJsonSchemaValidator(muleContext);
        }
        if (schemaType == SchemaType.XMLSchema) {
            return new RestXmlSchemaValidator(muleContext);
        }
        throw new IllegalArgumentException("Invalid schema type: " + (Object)((Object)schemaType));
    }
}

