/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.google.common.net.MediaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.construct.Flow;
import org.mule.module.apikit.DataTypePair;
import org.mule.module.apikit.HttpProtocolAdapter;
import org.mule.module.apikit.RestContentTypeParser;
import org.mule.module.apikit.SchemaType;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.exception.InvalidQueryParameterException;
import org.mule.module.apikit.exception.MuleRestException;
import org.mule.module.apikit.exception.NotAcceptableException;
import org.mule.module.apikit.exception.UnsupportedMediaTypeException;
import org.mule.module.apikit.transform.TransformerCache;
import org.mule.module.apikit.validation.RestSchemaValidator;
import org.mule.module.apikit.validation.RestSchemaValidatorFactory;
import org.mule.transformer.types.DataTypeFactory;
import org.raml.model.Action;
import org.raml.model.MimeType;
import org.raml.model.Raml;
import org.raml.model.Response;
import org.raml.model.parameter.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRestRequest {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private MuleEvent requestEvent;
    private Raml api;
    private Action action;
    private HttpProtocolAdapter adapter;

    public HttpRestRequest(MuleEvent event, Raml api) {
        this.requestEvent = event;
        this.api = api;
        this.adapter = new HttpProtocolAdapter(event);
    }

    public HttpProtocolAdapter getAdapter() {
        return this.adapter;
    }

    public String getResourcePath() {
        String path = this.adapter.getResourceURI().getPath();
        String basePath = this.adapter.getBaseURI().getPath();
        int start = basePath.endsWith("/") ? basePath.length() - 1 : basePath.length();
        int end = path.endsWith("/") ? path.length() - 1 : path.length();
        return path.substring(start, end);
    }

    public String getMethod() {
        return this.adapter.getMethod().toLowerCase();
    }

    public MuleEvent process(Flow flow, Action action) throws MuleException {
        this.action = action;
        this.processQueryParameters();
        this.validateInputRepresentation();
        String responseRepresentation = this.negotiateOutputRepresentation();
        MuleEvent responseEvent = flow.process(this.requestEvent);
        if (responseRepresentation != null) {
            this.transformToExpectedContentType(responseEvent, responseRepresentation);
        }
        if (responseEvent.getMessage().getOutboundProperty("http.status") == null) {
            int status = this.getSuccessStatus();
            if (status == -1) {
                throw new ApikitRuntimeException("No success status defined for action: " + action);
            }
            responseEvent.getMessage().setOutboundProperty("http.status", (Object)this.getSuccessStatus());
        }
        return responseEvent;
    }

    private void processQueryParameters() throws InvalidQueryParameterException {
        for (String expectedKey : this.action.getQueryParameters().keySet()) {
            QueryParameter expected = (QueryParameter)this.action.getQueryParameters().get(expectedKey);
            String actual = (String)this.requestEvent.getMessage().getInboundProperty(expectedKey);
            if (actual == null && expected.isRequired()) {
                throw new InvalidQueryParameterException("Required query parameter " + expected + " not specified");
            }
            if (actual == null || expected.validate(actual)) continue;
            throw new InvalidQueryParameterException("Invalid uri parameter value " + actual + " for " + expected);
        }
    }

    private void transformToExpectedContentType(MuleEvent muleEvent, String responseRepresentation) throws MuleException {
        MuleMessage message = muleEvent.getMessage();
        String msgMimeType = message.getDataType().getMimeType();
        String msgContentType = (String)message.getOutboundProperty("Content-Type");
        message.setOutboundProperty("Content-Type", (Object)responseRepresentation);
        if (responseRepresentation.equals(msgMimeType) || responseRepresentation.equals(msgContentType)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Response transformation not required. Message payload type is " + msgMimeType, new Object[0]));
            }
            return;
        }
        DataType sourceDataType = DataTypeFactory.create(message.getPayload().getClass(), (String)msgMimeType);
        DataType resultDataType = DataTypeFactory.create(String.class, (String)responseRepresentation);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Resolving transformer between [source=%s] and [result=%s]", sourceDataType, resultDataType));
        }
        try {
            Transformer transformer = (Transformer)TransformerCache.getTransformerCache(muleEvent.getMuleContext()).get((Object)new DataTypePair(sourceDataType, resultDataType));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Transformer resolved to [transformer=%s]", transformer));
            }
            Object payload = transformer.transform(message.getPayload());
            message.setPayload(payload);
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    private void validateInputRepresentation() throws MuleRestException {
        if (this.action == null || this.action.getBody().isEmpty()) {
            this.logger.debug("=== no body types defined: accepting any request content-type");
            return;
        }
        String requestMimeTypeName = null;
        boolean found = false;
        if (this.adapter.getRequestMediaType() != null) {
            requestMimeTypeName = this.adapter.getRequestMediaType();
        }
        for (String mimeTypeName : this.action.getBody().keySet()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("comparing request media type %s with expected %s\n", requestMimeTypeName, mimeTypeName));
            }
            if (!mimeTypeName.equals(requestMimeTypeName)) continue;
            found = true;
            if (((MimeType)this.action.getBody().get(mimeTypeName)).getSchema() == null || !mimeTypeName.contains("xml") && !mimeTypeName.contains("json")) break;
            this.validateSchema(mimeTypeName);
            break;
        }
        if (!found) {
            throw new UnsupportedMediaTypeException();
        }
    }

    private void validateSchema(String mimeTypeName) throws MuleRestException {
        SchemaType schemaType = mimeTypeName.contains("json") ? SchemaType.JSONSchema : SchemaType.XMLSchema;
        RestSchemaValidator validator = RestSchemaValidatorFactory.getInstance().createValidator(schemaType, this.requestEvent.getMuleContext());
        StringBuilder key = new StringBuilder(this.action.getResource().getUri());
        key.append(",").append(this.action.getType());
        key.append(",").append(mimeTypeName);
        validator.validate(key.toString(), this.requestEvent, this.api);
    }

    private String negotiateOutputRepresentation() throws MuleRestException {
        List<MimeType> mimeTypes = this.getResponseMimeTypes();
        if (this.action == null || this.action.getResponses() == null || mimeTypes.isEmpty()) {
            return null;
        }
        MediaType bestMatch = RestContentTypeParser.bestMatch(mimeTypes, this.adapter.getAcceptableResponseMediaTypes());
        if (bestMatch == null) {
            throw new NotAcceptableException();
        }
        this.logger.debug("=== negotiated response content-type: " + bestMatch.toString());
        for (MimeType representation : mimeTypes) {
            if (!representation.getType().equals(bestMatch.withoutParameters().toString())) continue;
            return representation.getType();
        }
        throw new NotAcceptableException();
    }

    private List<MimeType> getResponseMimeTypes() {
        Response response;
        ArrayList<MimeType> mimeTypes = new ArrayList<MimeType>();
        int status = this.getSuccessStatus();
        if (status != -1 && (response = (Response)this.action.getResponses().get(String.valueOf(status))) != null) {
            Collection types = response.getBody().values();
            this.logger.debug(String.format("=== adding response mimeTypes for status %d : %s", status, types));
            mimeTypes.addAll(types);
        }
        return mimeTypes;
    }

    private int getSuccessStatus() {
        for (String status : this.action.getResponses().keySet()) {
            int code = Integer.parseInt(status);
            if (code < 200 || code >= 300) continue;
            return code;
        }
        return -1;
    }
}

