/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.MimetypesFileTypeMap;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.apikit.exception.NotFoundException;
import org.mule.transport.http.components.ResourceNotFoundException;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.util.FilenameUtils;
import org.mule.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleHandler {
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    public static final String MIME_TYPE_JAVASCRIPT = "application/x-javascript";
    public static final String MIME_TYPE_PNG = "image/png";
    public static final String MIME_TYPE_GIF = "image/gif";
    public static final String MIME_TYPE_CSS = "text/css";
    private static final String RESOURCE_BASE = "/console";
    private MimetypesFileTypeMap mimeTypes;
    private String homePage;
    private String consolePath;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ConsoleHandler(String ramlUri, String consolePath) throws InitialisationException {
        this.consolePath = this.sanitize(consolePath);
        this.mimeTypes = new MimetypesFileTypeMap();
        this.mimeTypes.addMimeTypes("text/javascript js");
        this.mimeTypes.addMimeTypes("text/css css");
        String indexHtml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/console/index.html"));
        this.homePage = indexHtml.replaceFirst("<raml-definition id=\"([^\"]+)\" src=\"[^\"]+\">", "<raml-definition id=\"$1\" src=\"" + ramlUri + "\">");
    }

    private String sanitize(String consolePath) {
        if (consolePath.endsWith("/")) {
            consolePath = consolePath.substring(0, consolePath.length() - 1);
        }
        if (!consolePath.startsWith("/")) {
            consolePath = "/" + consolePath;
        }
        return consolePath;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        DefaultMuleEvent resultEvent;
        String path = (String)event.getMessage().getInboundProperty("http.request.path");
        String contextPath = (String)event.getMessage().getInboundProperty("http.context.path");
        if (!(path = path.substring(contextPath.length())).startsWith("/")) {
            path = "/" + path;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Console request: " + path);
        }
        try {
            InputStream in;
            if (path.equals(this.consolePath)) {
                event.getMessage().setOutboundProperty("http.status", (Object)String.valueOf(301));
                String redirectLocation = event.getMessageSourceURI() + RESOURCE_BASE + "/";
                event.getMessage().setOutboundProperty("Location", (Object)redirectLocation);
                return event;
            }
            if (path.equals(this.consolePath + "/") || path.equals(this.consolePath + "/index.html")) {
                path = "/console/index.html";
                in = new ByteArrayInputStream(this.homePage.getBytes());
            } else {
                in = this.getClass().getResourceAsStream(path);
            }
            if (in == null) {
                throw new NotFoundException(path);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copyLarge((InputStream)in, (OutputStream)baos);
            byte[] buffer = baos.toByteArray();
            String mimetype = this.getMimeType(path);
            if (mimetype == null) {
                mimetype = DEFAULT_MIME_TYPE;
            }
            resultEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)buffer, event.getMuleContext()), event);
            resultEvent.getMessage().setOutboundProperty("http.status", (Object)String.valueOf(200));
            resultEvent.getMessage().setOutboundProperty("Content-Type", (Object)mimetype);
            resultEvent.getMessage().setOutboundProperty("Content-Length", (Object)buffer.length);
        }
        catch (IOException e) {
            throw new ResourceNotFoundException(HttpMessages.fileNotFound((String)(RESOURCE_BASE + path)), event);
        }
        return resultEvent;
    }

    private String getMimeType(String path) {
        String mimeType = DEFAULT_MIME_TYPE;
        if (FilenameUtils.getExtension((String)path).equals("html")) {
            mimeType = "text/html";
        } else if (FilenameUtils.getExtension((String)path).equals("js")) {
            mimeType = MIME_TYPE_JAVASCRIPT;
        } else if (FilenameUtils.getExtension((String)path).equals("png")) {
            mimeType = MIME_TYPE_PNG;
        } else if (FilenameUtils.getExtension((String)path).equals("gif")) {
            mimeType = MIME_TYPE_GIF;
        } else if (FilenameUtils.getExtension((String)path).equals("css")) {
            mimeType = MIME_TYPE_CSS;
        }
        return mimeType;
    }
}

