/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.amazon.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.Capabilities;
import org.mule.api.Capability;
import org.mule.api.ConnectionManager;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.config.PoolingProfile;
import org.mule.modules.amazon.adapters.SQSConnectorConnectionIdentifierAdapter;
import org.mule.modules.amazon.connectivity.ManagedConnectionProcessTemplate;
import org.mule.modules.amazon.connectivity.SQSConnectorConnectionFactory;
import org.mule.modules.amazon.connectivity.SQSConnectorConnectionKey;

public class SQSConnectorConnectionManager
implements Capabilities,
ConnectionManager<SQSConnectorConnectionKey, SQSConnectorConnectionIdentifierAdapter>,
MetadataAware,
MuleContextAware,
Initialisable,
ProcessAdapter<SQSConnectorConnectionIdentifierAdapter> {
    private String queueName;
    private String accessKey;
    private String secretAccessKey;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private GenericKeyedObjectPool connectionPool;
    protected PoolingProfile connectionPoolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "sqs";
    private static final String MODULE_VERSION = "1.2.1-beta1";
    private static final String DEVKIT_VERSION = "3.3.1";
    private static final String DEVKIT_BUILD = "UNNAMED.1292.1980b66";

    public void setAccessKey(String value) {
        this.accessKey = value;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setSecretAccessKey(String value) {
        this.secretAccessKey = value;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    public void setConnectionPoolingProfile(PoolingProfile value) {
        this.connectionPoolingProfile = value;
    }

    public PoolingProfile getConnectionPoolingProfile() {
        return this.connectionPoolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setQueueName(String value) {
        this.queueName = value;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void initialise() {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        if (this.connectionPoolingProfile != null) {
            config.maxIdle = this.connectionPoolingProfile.getMaxIdle();
            config.maxActive = this.connectionPoolingProfile.getMaxActive();
            config.maxWait = this.connectionPoolingProfile.getMaxWait();
            config.whenExhaustedAction = (byte)this.connectionPoolingProfile.getExhaustedAction();
        }
        this.connectionPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new SQSConnectorConnectionFactory(this), config);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    public SQSConnectorConnectionIdentifierAdapter acquireConnection(SQSConnectorConnectionKey key) throws Exception {
        return (SQSConnectorConnectionIdentifierAdapter)this.connectionPool.borrowObject((Object)key);
    }

    public void releaseConnection(SQSConnectorConnectionKey key, SQSConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    public void destroyConnection(SQSConnectorConnectionKey key, SQSConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    public boolean isCapableOf(Capability capability) {
        if (capability == Capability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == Capability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    public <P> ProcessTemplate<P, SQSConnectorConnectionIdentifierAdapter> getProcessTemplate() {
        return new ManagedConnectionProcessTemplate(this, this.muleContext);
    }

    public SQSConnectorConnectionKey getDefaultConnectionKey() {
        return new SQSConnectorConnectionKey(this.getQueueName());
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }
}

